# Contributing to Pimcore
As an open source project we love to work together with our community to improve and develop our products. 
It's also important for us to make clear that **we're not working for you or your company**, 
but we enjoy to work together to solve issues or improve the product. 

## Contributing Pull Requests
We gladly accept community pull requests. This is the preferred way to contribute to Pimcore. 
There are a few necessary steps before we can accept a pull request:

* [Fork us!](https://help.github.com/articles/fork-a-repo/)
* Select the right branch. `main`(e.g. `10.x`) for features and improvements or latest maintenance branch for bug fixes (e.g. `10.1`)
* Code! Follow the coding standards defined [here](https://github.com/pimcore/pimcore/blob/10.x/.php-cs-fixer.dist.php) and [here](https://github.com/pimcore/pimcore/blob/10.x/doc/Development_Documentation/19_Development_Tools_and_Details/29_Testing/02_Core_Tests.md#perform-phpstan-analysis)
* [Send a pull request](https://help.github.com/articles/using-pull-requests/) from your fork’s branch to our repo branch.
* [Sign the CLA](https://cla-assistant.io/pimcore/pimcore) - see also below.


## Bug Reports
**Please provide a fix for the bug as a pull request (PR) whenever possible!**  
If you've created a pull request, it's not necessary anymore to create an issue for the bug. 

* Only file an issue if you're not able to fix the bug and provide the patch as a pull request.
* Please keep in mind that the Pimcore team will only work on system critical and security bugs. 
* [Open an issue](https://github.com/pimcore/pimcore/issues) here on GitHub.
* Report security issues only by using [this form](https://pimcorehq.wufoo.com/forms/pimcore-security-report/). 
* Please be patient as not all items will be tested immediately - remember, pimcore is open source and free of charge. 
* Occasionally we'll close issues if they appear stale or are too vague - please don't take this personally! 
Please feel free to re-open issues we've closed if there's something we've missed and they still need to be addressed.

### Contributor License Agreement
The following terms are used throughout this agreement:

* **You** - the person or legal entity including its affiliates asked to accept this agreement. An affiliate is any 
entity that controls or is controlled by the legal entity, or is under common control with it.

* **Project** - is an umbrella term that refers to any and all Pimcore projects.

* **Contribution** - any type of work that is submitted to a Project, including any modifications or additions to 
existing work.

* **Submitted** - conveyed to a Project via a pull request, commit, issue, or any form of electronic, written, or 
verbal communication with Pimcore, contributors or maintainers.

#### 1. Grant of Copyright License.
Subject to the terms and conditions of this agreement, You grant to the Projects’ maintainers, contributors, users and 
to Pimcore a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable copyright license to reproduce, 
prepare derivative works of, publicly display, publicly perform, sublicense, and distribute Your contributions and such 
derivative works. Except for this license, You reserve all rights, title, and interest in your contributions.

#### 2. Grant of Patent License.
Subject to the terms and conditions of this agreement, You grant to the Projects’ maintainers, contributors, users and 
to Pimcore a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable (except as stated in this section) 
patent license to make, have made, use, offer to sell, sell, import, and otherwise transfer your contributions, where 
such license applies only to those patent claims licensable by you that are necessarily infringed by your contribution 
or by combination of your contribution with the project to which this contribution was submitted. 

If any entity institutes patent litigation - including cross-claim or counterclaim in a lawsuit - against You alleging 
that your contribution or any project it was submitted to constitutes or is responsible for direct or contributory 
patent infringement, then any patent licenses granted to that entity under this agreement shall terminate as of the 
date such litigation is filed.

#### 3. Source of Contribution.
Your contribution is either your original creation, based upon previous work that, to the best of your knowledge, is 
covered under an appropriate open source license and you have the right under that license to submit that work with 
modifications, whether created in whole or in part by you, or you have clearly identified the source of the contribution 
and any license or other restriction (like related patents, trademarks, and license agreements) of which you are 
personally aware.
