<?php

/**
 * Pimcore
 *
 * This source file is available under two different licenses:
 * - GNU General Public License version 3 (GPLv3)
 * - Pimcore Commercial License (PCL)
 * Full copyright and license information is available in
 * LICENSE.md which is distributed with this source code.
 *
 *  @copyright  Copyright (c) Pimcore GmbH (http://www.pimcore.org)
 *  @license    http://www.pimcore.org/license     GPLv3 and PCL
 */

namespace Pimcore\Bundle\EcommerceFrameworkBundle\Tracking;

class ProductAction extends AbstractProductData
{
    /**
     * @var int
     */
    protected $quantity = 1;

    /**
     * @var string
     */
    protected $coupon;

    /**
     * @return int|float
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * @param int|float $quantity
     *
     * @return ProductAction
     */
    public function setQuantity($quantity)
    {
        $this->quantity = $quantity;

        return $this;
    }

    /**
     * @return string
     */
    public function getCoupon()
    {
        return $this->coupon;
    }

    /**
     * @param string $coupon
     *
     * @return ProductAction
     */
    public function setCoupon($coupon)
    {
        $this->coupon = $coupon;

        return $this;
    }
}
