# Upgrading Pimcore from Version 6.x to Version 10

## System Requirement changes
 - PHP >= 8.0
 - Apache >= 2.4
 - Composer >= 2.0

> As Pimcore 6.x works only with PHP < 8.0 and Pimcore 10 works only with PHP >= 8.0, a switch of PHP version is needed during the upgrade process.

## Database Requirement changes
- MariaDB >= 10.3
- MySQL >= 8.0

## Preparatory Work
- If you're on a version between 6.0.0 and 6.8.x, then please update to 6.9.x first and then continue with the upgrade steps.
- Check if all of your used Bundles are compatible with Pimcore X
- If you're using REST Webservices or the PHP templating engine,
  upgrade to [Datahub](https://github.com/pimcore/data-hub) and [Twig templates](https://twig.symfony.com/doc/3.x/)
  or consider using our [LTS offering](https://pimcore.com/en/services/lts) which brings back this functionality as optional commercial bundles. 

## IMPORTANT CHANGES TO DO PRIOR THE UPDATE! (TO DO WITH PHP < 8.0)

### Update folder structure 
Update your project folder structure as per [Symfony Flex](https://symfony.com/doc/5.2/setup/flex.html) guidelines. See demo changes [here](https://github.com/pimcore/demo/pull/203/files)

### Migrate legacy module/controller/action configurations to new controller references
You can use `./bin/console migration:controller-reference` to migrate your existing Documents, Static routes and Document Types to the new controller references in the format: `AppBundle\Controller\FooController::barAction`.

### Migrate Document versions to be compatible with Pimcore X (only relevant for versions created before 6.7)
If you wish to carry forward Document version files from 6.x  to Pimcore X, then it is required run command `pimcore:documents:migrate-elements` to migrate deprecated property `elements` to `editables`.

### Ensure your database configuration includes the following definitions:
```yml
doctrine:
  dbal:
    connections:
      default:
        mapping_types:
          enum: string
          bit: boolean
```
 
### Cleanup your composer.json
```
composer remove --no-update wikimedia/composer-merge-plugin doctrine/migrations php-http/guzzle6-adapter
composer require --no-update php-http/guzzle7-adapter:^0.1.1
Update composer.json as per [skeleton](https://github.com/pimcore/skeleton/blob/10.x/composer.json)
```

Important changes:
- Move configs from `app/config/*.yml` to `config/*.yaml`
- Move templates from `app/Resources/views` to `templates` and bundles templates from `app/Resources/XYZBundle/views` to `templates/bundles/XYZBundle`
- Move `app/AppKernel.php` to `src/Kernel.php` and edit it to have `namespace App;` and class name `Kernel`
- Rename `web/` to `public/` & `web/app.php` to `public/index.php`
- Rename `config/routing.yml` to `config/routes.yaml`
- Move your Environment specific configs to `config/packages/$ENV/*.yaml`
- Check your Folder Structure with [Skeleton Project](https://github.com/pimcore/skeleton)

Some Helpers for your changes
````
mv /app/config/ /config/ 
mv /web/ /public/ 
mv /app/Resources/views/ /templates/ 
mv /src/AppBundle/* /src/
mv /public/app.php /public/index.php 
mv /app/AppKernel.php /src/Kernel.php 
````

### Add .env environment file
Add [.env](https://github.com/pimcore/skeleton/blob/10.x/.env) file to project root, if not exists already.

### Migrate Php templates to Twig
Since Pimcore X supports only Symfony 5, which dropped the support for Php templates, it is required to update your php templates to Twig. 

If you are using enterprise edition, then it is still possible to support Php templates by installing `pimcore/php-templating-engine-bundle`.

You can use the following [RegEx](https://gist.github.com/putzflorian/219f582377b20d64d97ea9d8751dbb89) to Replace Strings in your Template Files  
For example Rewrite `{% extends ':Layout:default.html.twig' %}` to `{% extends 'Layout/default.html.twig' %}` and so on  
`Use this not as a Batch process try with your IDE to replace it manually`   

### Adapt System settings
Due to change in Pimcore config that no extra keys are allowed under pimcore node anymore, it is required to adapt system settings as per [system.template.yml](https://github.com/pimcore/demo/blob/10.x/var/config/system.template.yml) & [config.yaml](https://github.com/pimcore/demo/blob/10.x/config/config.yaml)

### Adapt Security config
It is not longer possible to merge security configurations from multiple locations, including bundles. Instead you have to move them to one single config file, e.g. `config/packages/security.yaml`. Check `bin/console debug:config security firewalls` to find firewall configurations which have to be moved. Please adapt `config/packages/security.yaml` from [skeleton](https://github.com/pimcore/skeleton/blob/10.x/config/packages/security.yaml) and merge your own firewall configs into one single file.

points to consider:
 - Removed `swiftmailer` config 
 - `cache` key renamed to `full_page_cache`
 - Removed webservice config

### Flush your `/tmp` directories
```bash
rm -r var/tmp
rm -r public/var/tmp
```

### Flush your recycle-bin
Migrating the items in the recycle-bin is not supported.
To have a clear start with Pimcore 10 we recommend to flush it before migration.
```bash
rm -r var/recyclebin
```

```sql
TRUNCATE TABLE recyclebin;
```

### Move user images
The default location of the user images has changed, simply move the contents over to the new location: 
```bash
mkdir var/admin
mv var/user-image var/admin/user-image
```

### Update your `.htaccess` or your Nginx configuration
- Updated `.htaccess` is available [here](https://github.com/pimcore/skeleton/blob/10.x/public/.htaccess). 
- Updated Nginx configuration is available [here](../03_System_Setup_and_Hosting/02_Nginx_Configuration.md). 

## SWITCH COMPOSER AND PHP VERSION, AND DO THE UPDATE!
- Ensure Composer is updated to version >= 2.0
- Switch PHP version to PHP >= 8.0
- Run composer update (`COMPOSER_MEMORY_LIMIT=-1 composer update`)

## CHANGES TO DO AFTER THE UPDATE! (TO DO WITH PHP >= 8.0)

### Verify migrations execution
By default, Composer update runs Pimcore migrations automatically, however it is better to check if all migrations are executed for smooth transition.
To verify, run command: `./bin/console doctrine:migrations:up-to-date --prefix=Pimcore\\Bundle\\CoreBundle`.

If you see message, `[ERROR] Out-of-date! x migrations are available to execute.`, then run command: `./bin/console doctrine:migrations:migrate --prefix=Pimcore\\Bundle\\CoreBundle`.
