<?php

/**
 * Pimcore
 *
 * This source file is available under two different licenses:
 * - GNU General Public License version 3 (GPLv3)
 * - Pimcore Commercial License (PCL)
 * Full copyright and license information is available in
 * LICENSE.md which is distributed with this source code.
 *
 *  @copyright  Copyright (c) Pimcore GmbH (http://www.pimcore.org)
 *  @license    http://www.pimcore.org/license     GPLv3 and PCL
 */

namespace Pimcore\Cache\Core;

/**
 * @internal
 */
class CacheQueueItem
{
    /**
     * @var string
     */
    protected $key;

    /**
     * @var mixed
     */
    protected $data;

    /**
     * @var array
     */
    protected $tags = [];

    /**
     * @param int|\DateInterval|null $lifetime
     */
    protected $lifetime = null;

    /**
     * @var int
     */
    protected $priority = 0;

    /**
     * @var bool
     */
    protected $force = false;

    /**
     * @param string $key
     * @param mixed $data
     * @param array $tags
     * @param int|\DateInterval|null $lifetime
     * @param int|null $priority
     * @param bool $force
     */
    public function __construct($key, $data, array $tags = [], $lifetime = null, $priority = 0, $force = false)
    {
        $this->key = $key;
        $this->data = $data;
        $this->tags = $tags;
        $this->lifetime = $lifetime;
        $this->priority = (int)$priority;
        $this->force = (bool)$force;
    }

    /**
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * @return mixed
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * @param mixed $data
     */
    public function setData($data): void
    {
        $this->data = $data;
    }

    /**
     * @return array
     */
    public function getTags()
    {
        return $this->tags;
    }

    /**
     * @return int|\DateInterval|null
     */
    public function getLifetime()
    {
        return $this->lifetime;
    }

    /**
     * @return int
     */
    public function getPriority()
    {
        return $this->priority;
    }

    /**
     * @return bool
     */
    public function isForce()
    {
        return $this->force;
    }
}
