<?php

/**
 * Pimcore
 *
 * This source file is available under two different licenses:
 * - GNU General Public License version 3 (GPLv3)
 * - Pimcore Commercial License (PCL)
 * Full copyright and license information is available in
 * LICENSE.md which is distributed with this source code.
 *
 *  @copyright  Copyright (c) Pimcore GmbH (http://www.pimcore.org)
 *  @license    http://www.pimcore.org/license     GPLv3 and PCL
 */

namespace Pimcore\Model\DataObject\ClassDefinition\Data;

use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\Concrete;

interface LayoutDefinitionEnrichmentInterface
{
    /**
     * Override point for Enriching the layout definition before the layout is returned to the admin interface.
     *
     * @param Concrete|null $object
     * @param array $context additional contextual data
     *
     * @return $this
     *
     * @throws \Exception
     */
    public function enrichLayoutDefinition(/*?Concrete */ $object, /**  array */ $context = []) /* : self */;
}
