<?php

/**
 * Pimcore
 *
 * This source file is available under two different licenses:
 * - GNU General Public License version 3 (GPLv3)
 * - Pimcore Commercial License (PCL)
 * Full copyright and license information is available in
 * LICENSE.md which is distributed with this source code.
 *
 *  @copyright  Copyright (c) Pimcore GmbH (http://www.pimcore.org)
 *  @license    http://www.pimcore.org/license     GPLv3 and PCL
 */

namespace Pimcore\Model\Tool\TmpStore;

use Pimcore\Model;

/**
 * @internal
 *
 * @property \Pimcore\Model\Tool\TmpStore $model
 */
class Dao extends Model\Dao\AbstractDao
{
    /**
     * @param string $id
     * @param mixed $data
     * @param string $tag
     * @param int $lifetime
     *
     * @return bool
     */
    public function add($id, $data, $tag, $lifetime)
    {
        try {
            $serialized = false;
            if (is_object($data) || is_array($data)) {
                $serialized = true;
                $data = serialize($data);
            }

            $this->db->insertOrUpdate('tmp_store', [
                'id' => $id,
                'data' => $data,
                'tag' => $tag,
                'date' => time(),
                'expiryDate' => (time() + $lifetime),
                'serialized' => (int) $serialized,
            ]);

            return true;
        } catch (\Exception $e) {
            return false;
        }
    }

    /**
     * @param string $id
     */
    public function delete($id)
    {
        $this->db->delete('tmp_store', ['id' => $id]);
    }

    /**
     * @param string $id
     *
     * @return bool
     */
    public function getById($id)
    {
        $item = $this->db->fetchRow('SELECT * FROM tmp_store WHERE id = ?', $id);

        if (is_array($item) && array_key_exists('id', $item)) {
            if ($item['serialized']) {
                $item['data'] = unserialize($item['data']);
            }

            $this->assignVariablesToModel($item);

            return true;
        }

        return false;
    }

    /**
     * @param string $tag
     *
     * @return array
     */
    public function getIdsByTag($tag)
    {
        $items = $this->db->fetchCol('SELECT id FROM tmp_store WHERE tag = ?', [$tag]);

        return $items;
    }
}
