![Pimcore - Own the digital World](./doc/Development_Documentation/img/logo-readme.svg)
  
  
Pimcore - CMS/CMF, MDM, PIM, DAM and E-Commerce

[![Packagist](https://img.shields.io/packagist/v/pimcore/pimcore.svg)](https://packagist.org/packages/pimcore/pimcore)
[![Software License](https://img.shields.io/badge/license-GPLv3-brightgreen.svg?style=flat)](LICENSE.md)
[![Build Status](https://travis-ci.org/pimcore/pimcore.svg)](https://travis-ci.org/pimcore/pimcore)
[![Gitter](https://img.shields.io/badge/gitter-join%20chat-brightgreen.svg?style=flat)](https://gitter.im/pimcore/pimcore)

* 🌍 [http://pimcore.com/](https://pimcore.com/) - Learn more about Pimcore
* 📖 [Documentation](https://pimcore.com/docs/)
* 📚 [API Documentation](https://pimcore.com/docs/api/)
* 🉐 **Help translating Pimcore!** Start with [Essentials](https://poeditor.com/join/project/VWmZyvFVMH), continue with [Extended](https://poeditor.com/join/project/XliCYYgILb).
* 👍 Like us on [Facebook](https://www.facebook.com/pimcore)
* 🕊 Twitter: [@pimcore](https://twitter.com/pimcore) - Get the latest news
* 🐞  Issue Tracker: - [Issues](https://github.com/pimcore/pimcore/issues) - Report bugs here
* 🗨  [Forums](https://talk.pimcore.org/) - Discussions 
* 👪 [Community Chat](https://gitter.im/pimcore/pimcore) - Gitter 
   
   
**Looking for the previous stable (version 4)?  
See https://github.com/pimcore/pimcore/tree/pimcore4**

## Contribute  
**Bug fixes:** please create a pull request including a step by step description to reproduce the problem  
**Contribute features:** contact the core-team on our [Gitter channel](https://gitter.im/pimcore/pimcore) before you start developing   
**Security vulnerabilities:** please use [this form](https://pimcorehq.wufoo.com/forms/pimcore-security-report/)
  
For details, please have a look at our [contributing guide](CONTRIBUTING.md).

## Overview
![Technology and Architecture](./doc/Development_Documentation/img/pimcore-technology-architecture.svg)

## Key Benefits and Advantages
### ⚒ Data Modelling and UI Design at the same Time 
No matter if your're dealing with unstructured web documents or structured data for MDM/PIM, you define the 
UI design (web documents by a template and structured data with a intuitive graphical editor), Pimcore knows 
how to persist the data efficiently and optimized for fast access.

### 🎛 Agnostic and Universal Framework for your Data
Due to the framework approach, Pimcore is very flexible and adapts perfectly to your needs. Built on top of 
the well-known Symfony Framework you have a solid and modern foundation for your project. 

### 🚀 Extensible and huge Symfony Community
Benefit from all existing Symfony Components and Bundles provided by the community or create your own 
Bundles to extend your Projects with reusable components. 

### 💎 Your Digital World consolidated in one Platform
No more API, import/export and synchronization hell between MDM/PIM, E-Commerce, DAM, CRM and your Web-CMS. 
All is working seamlessly together, natively ... this is what Pimcore is built for. 

### ✨️ Modern and Intuitive UI
We love good looking user interfaces, designed to be efficient for the daily use and optimized for a great
experience for editors. 

## Preview and Demo
![Pimcore Admin Interface Screenshot](./doc/Development_Documentation/img/pimcore-screenshot-1.png)

#### Basic Demo (CMS)
_Admin-URL_: [https://demo-basic.pimcore.org/admin](https://demo-basic.pimcore.org/admin)  
_Username_: `admin`  
_Password_: `demo`

#### Advanced Demo (MDM/PIM, E-Commerce, DAM, CMS, ...)
_Admin-URL_: [https://demo-advanced.pimcore.org/admin](https://demo-advanced.pimcore.org/admin)  
_Username_: `admin`  
_Password_: `demo`

## Getting Started
_**Only 3 commands to start!**_ 😎
```bash
COMPOSER_MEMORY_LIMIT=-1 composer create-project pimcore/skeleton:dev-master ./my-project
cd ./my-project
./vendor/bin/pimcore-install
```

This will install an empty skeleton application, 
but we're also offering 3 different demo packages for your convenience - of course also with 3 commands 💪
[Click here for more installation options and a detailed guide](https://pimcore.com/docs/5.x/Development_Documentation/Getting_Started/Installation.html)

## Copyright and License 
Copyright: [Pimcore](http://www.pimcore.org) GmbH  
For licensing details please visit [LICENSE.md](LICENSE.md) 
  
  

