# PimcoreEcommerceFrameworkBundle Configuration Reference

The following is the generated reference for the `pimcore_ecommerce_framework` configuration tree. This reference can
be generated by issuing the following command:

    $ bin/console config:dump-reference pimcore_ecommerce_framework
    
```yaml
# Default configuration for extension with alias: "pimcore_ecommerce_framework"
pimcore_ecommerce_framework:

    # If true, the bundle will alias legacy class names (OnlineShop\Framework\*) to the new namespace
    use_legacy_class_mapping: false

    # Default scale used for Decimal objects
    decimal_scale:        4

    # Configuration of Pimcore backend menu entries
    pimcore:
        menu:

            # Enabling/Disabling Pricing Rules menu entry. User specific settings can be done via permissions.
            pricing_rules:
                enabled:              true

            # Configuring order list menu - enabling/disabling and defining route of order list to inject custom implementations of order backend.
            order_list:
                enabled:              true
                route:                pimcore_ecommerce_backend_admin-order_list
                path:                 null

    # Configuration of e-commerce framework factory
    factory:

        # Service Id of factory implementation
        factory_id:           Pimcore\Bundle\EcommerceFrameworkBundle\Factory

        # If true the factory will not fall back to the default tenant if a tenant is passed but not existing
        strict_tenants:       false

    # Configuration of environment
    environment:
        environment_id:       Pimcore\Bundle\EcommerceFrameworkBundle\SessionEnvironment
        options:              []

    # Settings for cart manager
    cart_manager:

        # Configuration per tenant. If a _defaults key is set, it will be merged into every tenant. It needs to be set in every file. A tenant named "default" is mandatory.
        tenants:

            # Examples:
            _defaults:
                cart:
                    factory_id:          CartFactory
            default:
                cart:
                    factory_options:
                        cart_class_name:     Pimcore\Bundle\EcommerceFrameworkBundle\CartManager\Cart
                price_calculator:
                    modificators:
                        shipping:
                            class:               Pimcore\Bundle\EcommerceFrameworkBundle\CartManager\CartPriceModificator\Shipping
                            options:
                                charge:              5.90
            noShipping:
                price_calculator:
                    factory_id:          PriceCalculatorFactory
                    modificators:        ~

            # Prototype
            name:

                # Service id of cart service
                cart_manager_id:      Pimcore\Bundle\EcommerceFrameworkBundle\CartManager\MultiCartManager

                # Configuration for carts
                cart:

                    # Service id of cart factory and configuration array
                    factory_id:           Pimcore\Bundle\EcommerceFrameworkBundle\CartManager\CartFactory
                    factory_options:

                        # Defaults:
                        cart_class_name:     Pimcore\Bundle\EcommerceFrameworkBundle\CartManager\Cart
                        guest_cart_class_name: Pimcore\Bundle\EcommerceFrameworkBundle\CartManager\SessionCart
                price_calculator:
                    factory_id:           Pimcore\Bundle\EcommerceFrameworkBundle\CartManager\CartPriceCalculatorFactory
                    factory_options:      []

                    # List price modificators for cart, e.g. for shipping-cost, special discounts, etc. Key is name of modificator.
                    modificators:

                        # Prototype
                        name:
                            class:                ~ # Required
                            options:              []

    # Configuration of Order Manager
    order_manager:

        # Configuration per tenant. If a _defaults key is set, it will be merged into every tenant. A tenant named "default" is mandatory.
        tenants:

            # Prototype
            name:

                # Service id for order manager implementation
                order_manager_id:     Pimcore\Bundle\EcommerceFrameworkBundle\OrderManager\OrderManager

                # Options for order manager
                options:

                    # Pimcore object class for orders
                    order_class:          \Pimcore\Model\DataObject\OnlineShopOrder

                    # Pimcore object class for order items
                    order_item_class:     \Pimcore\Model\DataObject\OnlineShopOrderItem

                    # Class for order listing
                    list_class:           Pimcore\Bundle\EcommerceFrameworkBundle\OrderManager\Order\Listing

                    # Class for order item listing
                    list_item_class:      Pimcore\Bundle\EcommerceFrameworkBundle\OrderManager\Order\Listing\Item

                    # Default parent folder for new orders
                    parent_order_folder:  /order/%%Y/%%m/%%d
                order_agent:

                    # Service id for order agent factory
                    factory_id:           Pimcore\Bundle\EcommerceFrameworkBundle\OrderManager\Order\AgentFactory
                    factory_options:      []

    # Configuration of Pricing Manager
    pricing_manager:
        enabled:              ~ # Deprecated (The child node "enabled" at the root level path "pimcore_ecommerce_framework.pricing_manager" is deprecated. Please migrate to the new tenant structure.)
        pricing_manager_id:   ~ # Deprecated (The child node "pricing_manager_id" at the root level path "pimcore_ecommerce_framework.pricing_manager" is deprecated. Please migrate to the new tenant structure.)
        pricing_manager_options:
            rule_class:           ~ # Deprecated (The child node "rule_class" at the root level path "pimcore_ecommerce_framework.pricing_manager.pricing_manager_options" is deprecated. Please migrate to the new tenant structure.)
            price_info_class:     ~ # Deprecated (The child node "price_info_class" at the root level path "pimcore_ecommerce_framework.pricing_manager.pricing_manager_options" is deprecated. Please migrate to the new tenant structure.)
            environment_class:    ~ # Deprecated (The child node "environment_class" at the root level path "pimcore_ecommerce_framework.pricing_manager.pricing_manager_options" is deprecated. Please migrate to the new tenant structure.)

        # Condition mapping from name to used class
        conditions:

            # Prototype
            name:                 ~

        # Action mapping from name to used class
        actions:

            # Prototype
            name:                 ~

        # Configuration per tenant. If a _defaults key is set, it will be merged into every tenant. A tenant named "default" is mandatory.
        tenants:

            # Prototype
            name:
                enabled:              true

                # Service id of pricing manager
                pricing_manager_id:   Pimcore\Bundle\EcommerceFrameworkBundle\PricingManager\PricingManager

                # Options for pricing manager
                pricing_manager_options:
                    rule_class:           Pimcore\Bundle\EcommerceFrameworkBundle\PricingManager\Rule
                    price_info_class:     Pimcore\Bundle\EcommerceFrameworkBundle\PricingManager\PriceInfo
                    environment_class:    Pimcore\Bundle\EcommerceFrameworkBundle\PricingManager\Environment

    # Configuration of price systems - key is name of price system.
    price_systems:

        # Prototype
        name:
            name:                 ~
            id:                   ~ # Required

    # Configuration of availability systems - key is name of price system.
    availability_systems:

        # Prototype
        name:
            name:                 ~
            id:                   ~ # Required

    # Configuration of checkout manager
    checkout_manager:

        # Configuration per tenant. If a _defaults key is set, it will be merged into every tenant. A tenant named "default" is mandatory.
        tenants:

            # Prototype
            name:
                factory_id:           Pimcore\Bundle\EcommerceFrameworkBundle\CheckoutManager\CheckoutManagerFactory
                factory_options:      []

                # Define payment provider which should be used for payment. Payment providers are defined in payment_manager section.
                payment:
                    provider:             null

                # Define used commit order processor
                commit_order_processor:
                    id:                   Pimcore\Bundle\EcommerceFrameworkBundle\CheckoutManager\CommitOrderProcessor
                    options:              []

                # Define different checkout steps which need to be committed before commit of order is possible
                steps:

                    # Prototype
                    name:
                        class:                ~ # Required
                        options:              []

    # Configuration of payment manager and payment providers
    payment_manager:
        payment_manager_id:   Pimcore\Bundle\EcommerceFrameworkBundle\PaymentManager\PaymentManager

        # Configuration of payment providers, key is name of provider.
        providers:

            # Prototype
            name:
                name:                 ~

                # Service id of payment provider implementation
                provider_id:          ~ # Required

                # Currently active profile
                profile:              ~ # Required

                # Available profiles with options
                profiles:

                    # Prototype
                    name:

                        # Prototype
                        name:                 ~

    # Configuration of index service
    index_service:
        index_service_id:     Pimcore\Bundle\EcommerceFrameworkBundle\IndexService\IndexService
        default_tenant:       default

        # Configure assortment tenants - at least one tenant has to be configured. If a _defaults key is set, it will be merged into every tenant.
        tenants:

            # Prototype
            name:
                enabled:              true

                # Service id of config implementation
                config_id:            Pimcore\Bundle\EcommerceFrameworkBundle\IndexService\Config\DefaultMysql
                config_options:       []

                # Worker id of worker implementation. Can be omitted, then default worker id of configured config is used.
                worker_id:            ~

                # Placeholder values in this tenant attributes definition (locale: "%%locale%%") will be replaced by the given placeholder value (eg. "de_AT")
                placeholders:

                    # Example:
                    placeholders:
                        %%locale%%:          de_AT

                # Add columns for general fulltext search index of product list - they must be part of the column configuration below
                search_attributes:    []

                # Attributes definition for product index - key is name of attribute
                attributes:

                    # Prototype
                    name:
                        name:                 ~ # Required

                        # Defines object attribute field name, can be omitted if the same like name of index attribute
                        field_name:           null

                        # Type of index attribute (database column or elastic search data type)
                        type:                 null

                        # Locale for localized fields, can be omitted if not necessary
                        locale:               null

                        # Defines filter group for filter definition in filter service
                        filter_group:         null
                        options:              []

                        # Service id of getter for this field
                        getter_id:            null
                        getter_options:       []

                        # Service id of interpreter for this field
                        interpreter_id:       null
                        interpreter_options:  []
                        mapping:              []

                        # Hides field in field list selection data type of filter service - default to false
                        hide_in_fieldlist_datatype: false

    # Configuration of filter service
    filter_service:

        # Configuration per tenant. If a _defaults key is set, it will be merged into every tenant.
        tenants:

            # Prototype
            name:
                enabled:              true
                service_id:           Pimcore\Bundle\EcommerceFrameworkBundle\FilterService\FilterService

                # Assign backend implementations and views to filter type field collections
                filter_types:

                    # Prototype
                    name:

                        # Service id for filter type implementation
                        filter_type_id:       ~ # Required

                        # Default template for filter, can be overwritten in filter definition
                        template:             ~ # Required
                        options:              []

    # Configuration of voucher service
    voucher_service:

        # Service id of voucher service implementation
        voucher_service_id:   Pimcore\Bundle\EcommerceFrameworkBundle\VoucherService\DefaultService
        voucher_service_options:

            # Reservations older than x MINUTES get removed by maintenance task
            reservation_minutes_threshold: 5

            # Statistics older than x DAYS get removed by maintenance task
            statistics_days_threshold: 30

        # Configuration of token managers
        token_managers:

            # Service id of token manager factory
            factory_id:           Pimcore\Bundle\EcommerceFrameworkBundle\VoucherService\TokenManager\TokenManagerFactory

            # Mapping for token manager implementations
            mapping:

                # Prototype
                name:                 ~

    # Configuration of offer tool
    offer_tool:

        # Service id for offer tool service
        service_id:           Pimcore\Bundle\EcommerceFrameworkBundle\OfferTool\DefaultService
        order_storage:

            # Pimcore object class for offers
            offer_class:          Pimcore\Model\DataObject\OfferToolOffer

            # Pimcore object class for offer items
            offer_item_class:     Pimcore\Model\DataObject\OfferToolOfferItem

            # default path for new offers
            parent_folder_path:   /offertool/offers/%%Y/%%m

    # Configuration of Tracking Manager
    tracking_manager:

        # Service id of tracking manager
        tracking_manager_id:  Pimcore\Bundle\EcommerceFrameworkBundle\Tracking\TrackingManager

        # Enable/Disable trackers and configure them
        trackers:

            # Prototype
            name:
                enabled:              true

                # Service id for tracker
                id:                   ~ # Required
                options:              []

                # Service id for item builder for tracker
                item_builder_id:      Pimcore\Bundle\EcommerceFrameworkBundle\Tracking\TrackingItemBuilder

                # List of assortment and checkout tenants where this tracker should be activated for.
                tenants:

                    # Add list of assortment tenants where the tracker should be activated for. Empty array means activated for all tenants.
                    assortment:           []

                    # Add list of checkout tenants where the tracker should be activated for. Empty array means activated for all tenants.
                    checkout:             []

```
