<?php
/**
 * Pimcore
 *
 * This source file is available under two different licenses:
 * - GNU General Public License version 3 (GPLv3)
 * - Pimcore Enterprise License (PEL)
 * Full copyright and license information is available in
 * LICENSE.md which is distributed with this source code.
 *
 * @copyright  Copyright (c) Pimcore GmbH (http://www.pimcore.org)
 * @license    http://www.pimcore.org/license     GPLv3 and PEL
 */

namespace Pimcore\Templating\Helper;

use Pimcore\Tool\DeviceDetector;
use Symfony\Component\Templating\Helper\Helper;

class Device extends Helper
{
    /**
     * @param null $default
     *
     * @return DeviceDetector
     */
    public function __invoke($default = null)
    {
        return DeviceDetector::getInstance($default);
    }

    /**
     * Returns the canonical name of this helper.
     *
     * @return string The canonical name
     */
    public function getName()
    {
        return 'device';
    }
}
