<?php
/**
 * Pimcore
 *
 * This source file is available under two different licenses:
 * - GNU General Public License version 3 (GPLv3)
 * - Pimcore Enterprise License (PEL)
 * Full copyright and license information is available in
 * LICENSE.md which is distributed with this source code.
 *
 * @category   Pimcore
 * @package    Asset
 * @copyright  Copyright (c) 2009-2016 pimcore GmbH (http://www.pimcore.org)
 * @license    http://www.pimcore.org/license     GPLv3 and PEL
 */

namespace Pimcore\Model\Asset\Listing;

use Pimcore\Model;

class Dao extends Model\Listing\Dao\AbstractDao
{
    
    /** @var  Callback function */
    protected $onCreateQueryCallback;


    /**
     * Get the assets from database
     *
     * @return array
     */
    public function load()
    {
        $assets = array();

        $select = (string) $this->getQuery(array('id', "type"));
        $assetsData = $this->db->fetchAll($select, $this->model->getConditionVariables());

        foreach ($assetsData as $assetData) {
            if ($assetData["type"]) {
                if ($asset = Model\Asset::getById($assetData["id"])) {
                    $assets[] = $asset;
                }
            }
        }

        $this->model->setAssets($assets);
        return $assets;
    }

    public function getQuery($columns)
    {
        $select = $this->db->select();
        $select->from(
            [ "assets" ], $columns
        );
        $this->addConditions($select);
        $this->addOrder($select);
        $this->addLimit($select);
        $this->addGroupBy($select);

        if ($this->onCreateQueryCallback) {
            $closure = $this->onCreateQueryCallback;
            $closure($select);
        }

        return $select;
    }

    /**
     * Loads a list of document ids for the specicifies parameters, returns an array of ids
     *
     * @return array
     */
    public function loadIdList()
    {
        $select = (string) $this->getQuery(array('id', "type"));
        $assetIds = $this->db->fetchCol($select, $this->model->getConditionVariables());

        return $assetIds;
    }

    public function getCount()
    {
        $select = (string) $this->getQuery(array(new \Zend_Db_Expr('COUNT(*)')));
        $amount = (int) $this->db->fetchOne($select, $this->model->getConditionVariables());
        return $amount;
    }

    public function getTotalCount()
    {
        $select = $this->getQuery(array(new \Zend_Db_Expr('COUNT(*)')));
        $select->reset(\Zend_Db_Select::LIMIT_COUNT);
        $select->reset(\Zend_Db_Select::LIMIT_OFFSET);
        $select = (string) $select;
        $amount = (int) $this->db->fetchOne($select, $this->model->getConditionVariables());

        return $amount;
    }

    public function onCreateQuery(callable $callback)
    {
        $this->onCreateQueryCallback = $callback;
    }
}
