<?php
/**
 * Pimcore
 *
 * This source file is available under two different licenses:
 * - GNU General Public License version 3 (GPLv3)
 * - Pimcore Enterprise License (PEL)
 * Full copyright and license information is available in
 * LICENSE.md which is distributed with this source code.
 *
 * @category   Pimcore
 * @package    Object|Class
 * @copyright  Copyright (c) 2009-2016 pimcore GmbH (http://www.pimcore.org)
 * @license    http://www.pimcore.org/license     GPLv3 and PEL
 */

namespace Pimcore\Model\Object\ClassDefinition\Data;

interface DataInterface
{

    /**
     * converts object data to a simple string value or CSV Export
     * @abstract
     * @param null|AbstractObject $object
     * @param mixed $params
     * @param array $params
     * @return string
     */
    public function getForCsvExport($object, $params = array());

    /**
     * @param $importValue
     * @return mixed
     */
    public function getFromCsvImport($importValue, $object = null, $params = array());
}
