/**
 * Pimcore
 *
 * This source file is subject to the GNU General Public License version 3 (GPLv3)
 * For the full copyright and license information, please view the LICENSE.md and gpl-3.0.txt
 * files that are distributed with this source code. 
 *
 * @copyright  Copyright (c) 2009-2016 pimcore GmbH (http://www.pimcore.org)
 * @license    http://www.pimcore.org/license     GNU General Public License version 3 (GPLv3)
 */

pimcore.registerNS("pimcore.object.abstract");
pimcore.object.abstract = Class.create(pimcore.element.abstract, {

    selectInTree: function (type) {

        if(type != "variant" || this.data.general.showVariants) {
            try {
                //customview path
                var customTreeMatch = false;
                //NOTICE this is a bit hacky :)
                //the trees do not have their childs loaded until the path to them is expanded
                //so there is no way (?) to check if the node is present in one of the customviews
                //but we can explode the object path and if some ID matches some custom view tree rootId
                //we use that tree
                var tmpIDs = this.data.idPath.split('/');
                for (var cvs = 0; cvs < pimcore.settings.customviews.length; cvs++) {
                    cv = pimcore.settings.customviews[cvs];
                    if (tmpIDs.length > 0 && tmpIDs.indexOf(cv.rootId.toString()) > -1) {
                        //calculate the path to expand on the custom view tree
                        var cvNodePath = this.data.idPath.substr(this.data.idPath.indexOf("/"+cv.rootId.toString()+"/"));
                        Ext.getCmp("pimcore_panel_tree_customviews_"+cv.id).expand();
                        var tree = pimcore.globalmanager.get("layout_customview_tree_"+cv.id);
                        pimcore.helpers.selectPathInTree(tree.tree, cvNodePath);
                        customTreeMatch = true;
                        break;
                    }
                }
                //object tree path
                if (!customTreeMatch) {
                    Ext.getCmp("pimcore_panel_tree_objects").expand();
                    var tree = pimcore.globalmanager.get("layout_object_tree");
                    pimcore.helpers.selectPathInTree(tree.tree, this.data.idPath);
                }
            } catch (e) {
                console.log(e);
            }
        }
    }
});