/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 25);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});
//main config file

var config = {};

config.TRANSPARENCY = false;
config.TRANSPARENCY_TYPE = 'squares'; //squares, green, grey
config.LANG = 'en';
config.WIDTH = null;
config.HEIGHT = null;
config.visible_width = null;
config.visible_height = null;
config.COLOR = '#008000';
config.ALPHA = 255;
config.ZOOM = 1;
config.pixabay_key = '3ca2cd8af3fde33af218bea02-9021417';
config.layers = [];
config.layer = null;
config.need_render = false;
config.mouse = {};

config.TOOLS = [{
	name: 'select',
	title: 'Select object tool',
	attributes: {
		auto_select: true
	}
}, {
	name: 'selection',
	title: 'Selection',
	attributes: {},
	on_leave: 'on_leave'
}, {
	name: 'brush',
	title: 'Brush',
	attributes: {
		size: 4,
		smart_brush: true
	}
}, {
	name: 'pencil',
	title: 'Pencil',
	on_update: 'on_params_update',
	attributes: {
		antialiasing: true,
		size: 2
	}
}, {
	name: 'pick_color',
	title: 'Pick Color',
	attributes: {
		global: false
	}
}, {
	name: 'erase',
	title: 'Erase',
	on_update: 'on_params_update',
	attributes: {
		size: 30,
		circle: true,
		strict: true
	}
}, {
	name: 'magic_wand',
	title: 'Magic Wand Tool',
	attributes: {
		power: 15,
		anti_aliasing: true,
		contiguous: false
	}
}, {
	name: 'fill',
	title: 'Fill',
	attributes: {
		power: 5,
		anti_aliasing: false,
		contiguous: false
	}
}, {
	name: 'line',
	title: 'Line',
	attributes: {
		size: 1,
		type: {
			value: 'Simple',
			values: ['Simple', 'Arrow']
		}
	}
}, {
	name: 'rectangle',
	title: 'Rectangle',
	attributes: {
		size: 1,
		fill: true,
		square: false
	}
}, {
	name: 'circle',
	title: 'Circle',
	attributes: {
		size: 1,
		fill: true,
		circle: false
	}
}, {
	name: 'media',
	title: 'Search images',
	on_activate: 'on_activate',
	attributes: {
		size: 30
	}
}, {
	name: 'text',
	title: 'Text',
	attributes: {
		size: 40,
		bold: false,
		italic: false,
		stroke: false,
		align: {
			value: 'Left',
			values: ["Left", "Center", "Right"]
		},
		family: {
			value: 'Arial',
			values: ["Arial", "Courier", "Impact", "Helvetica", "monospace", "Times New Roman", "Verdana"]
		},
		stroke_size: 1
	}
}, {
	name: 'gradient',
	title: 'Gradient',
	attributes: {
		color_1: '#008000',
		color_2: '#ffffff',
		alpha: 0,
		radial: false,
		radial_power: 50
	}
}, {
	name: 'clone',
	title: 'Clone tool',
	attributes: {
		size: 30,
		anti_aliasing: true,
		source_layer: {
			value: 'Current',
			values: ['Current', 'Previous']
		}
	}
}, {
	name: 'crop',
	title: 'Crop',
	on_update: 'on_params_update',
	on_leave: 'on_leave',
	attributes: {
		crop: true
	}
}, {
	name: 'blur',
	title: 'Blur tool',
	attributes: {
		size: 30,
		strength: 1
	}
}, {
	name: 'sharpen',
	title: 'Sharpen tool',
	attributes: {
		size: 30
	}
}, {
	name: 'desaturate',
	title: 'Desaturate',
	attributes: {
		size: 50,
		anti_aliasing: true
	}
}, {
	name: 'bulge_pinch',
	title: 'Bulge/Pinch tool',
	attributes: {
		radius: 80,
		power: 50,
		bulge: true
	}
}, {
	name: 'animation',
	title: 'Play animation',
	on_update: 'on_params_update',
	on_leave: 'on_leave',
	attributes: {
		play: false,
		delay: 400
	}
}];

//link to active tool
config.TOOL = config.TOOLS[2];

exports.default = config;

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * miniPaint - https://github.com/viliusle/miniPaint
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * author: Vilius L.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseGui = __webpack_require__(7);

var _baseGui2 = _interopRequireDefault(_baseGui);

var _baseSelection = __webpack_require__(12);

var _baseSelection2 = _interopRequireDefault(_baseSelection);

var _baseState = __webpack_require__(17);

var _baseState2 = _interopRequireDefault(_baseState);

var _trim = __webpack_require__(16);

var _trim2 = _interopRequireDefault(_trim);

var _zoomView = __webpack_require__(56);

var _zoomView2 = _interopRequireDefault(_zoomView);

var _helpers = __webpack_require__(4);

var _helpers2 = _interopRequireDefault(_helpers);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var instance = null;

/**
 * Layers class - manages layers. Each layer is object with various types. Keys:
 * - id (int)
 * - link (image)
 * - parent_id (int)
 * - name (string)
 * - type (string)
 * - x (int)
 * - y (int)
 * - width (int)
 * - height (int)
 * - width_original (int)
 * - height_original (int)
 * - visible (bool)
 * - opacity (0-100)
 * - order (int)
 * - composition (string)
 * - rotate (int) 0-359
 * - data (various data here)
 * - params (object)
 * - color {hex}
 * - status (string)
 * - filters (array)
 * - render_function (function)
 */

var Base_layers_class = function () {
	function Base_layers_class() {
		_classCallCheck(this, Base_layers_class);

		//singleton
		if (instance) {
			return instance;
		}
		instance = this;

		this.Base_gui = new _baseGui2.default();
		this.Helper = new _helpers2.default();
		this.Image_trim = new _trim2.default();
		this.Base_state = new _baseState2.default();

		this.canvas = document.getElementById('canvas_minipaint');
		this.ctx = document.getElementById('canvas_minipaint').getContext("2d");
		this.ctx_preview = document.getElementById('canvas_preview').getContext("2d");
		this.last_zoom = 1;
		this.zoomView = _zoomView2.default;
		this.auto_increment = 1;
		this.stable_dimesions = [];
		this.tempCanvas = document.createElement('canvas');
	}

	/**
  * do preparation on start
  */


	_createClass(Base_layers_class, [{
		key: 'init',
		value: function init() {
			this.init_zoom_lib();
			this.insert({});

			var sel_config = {
				enable_background: false,
				enable_borders: true,
				enable_controlls: false,
				data_function: function data_function() {
					return _config2.default.layer;
				}
			};
			this.Base_selection = new _baseSelection2.default(this.ctx, sel_config, 'main');

			this.render(true);
		}
	}, {
		key: 'init_zoom_lib',
		value: function init_zoom_lib() {
			_zoomView2.default.setBounds(0, 0, _config2.default.WIDTH, _config2.default.HEIGHT);
			_zoomView2.default.setContext(this.ctx);
			this.stable_dimesions = [_config2.default.WIDTH, _config2.default.HEIGHT];
		}
	}, {
		key: 'pre_render',
		value: function pre_render() {
			this.ctx.save();
			_zoomView2.default.canvasDefault();
			this.ctx.clearRect(0, 0, _config2.default.WIDTH * _config2.default.ZOOM, _config2.default.HEIGHT * _config2.default.ZOOM);
		}
	}, {
		key: 'after_render',
		value: function after_render() {
			_config2.default.need_render = false;
			this.ctx.restore();
			_zoomView2.default.canvasDefault();
		}

		/**
   * renders all layers objects on main canvas
   * 
   * @param {bool} force
   */

	}, {
		key: 'render',
		value: function render(force) {
			var _this = this;
			if (force !== true) {
				//request render and exit
				_config2.default.need_render = true;
				return;
			}

			if (this.stable_dimesions[0] != _config2.default.WIDTH || this.stable_dimesions[1] != _config2.default.HEIGHT) {
				//dimensions changed - reinit zoom lib
				this.init_zoom_lib();
			}

			if (_config2.default.need_render == true) {

				if (this.last_zoom != _config2.default.ZOOM) {
					//change zoom
					_zoomView2.default.scaleAt(this.Base_gui.GUI_preview.zoom_data.x, this.Base_gui.GUI_preview.zoom_data.y, _config2.default.ZOOM / this.last_zoom);
				} else if (this.Base_gui.GUI_preview.zoom_data.move_pos != null) {
					//move visible window
					var pos = this.Base_gui.GUI_preview.zoom_data.move_pos;
					var pos_global = _zoomView2.default.toScreen(pos);
					_zoomView2.default.move(-pos_global.x, -pos_global.y);
					this.Base_gui.GUI_preview.zoom_data.move_pos = null;
				}

				//prepare
				this.pre_render();

				//take data
				var layers_sorted = this.get_sorted_layers();

				_zoomView2.default.apply();

				//render main canvas
				for (var i = layers_sorted.length - 1; i >= 0; i--) {
					var value = layers_sorted[i];
					this.ctx.globalAlpha = value.opacity / 100;
					this.ctx.globalCompositeOperation = value.composition;

					this.render_object(this.ctx, value);
				}

				//grid
				this.Base_gui.draw_grid(this.ctx);

				//render selected object controls
				this.Base_selection.draw_selection();

				//render preview
				this.render_preview(layers_sorted);

				//reset
				this.after_render();
				this.last_zoom = _config2.default.ZOOM;

				this.Base_gui.GUI_details.render_details();
			}

			requestAnimationFrame(function () {
				_this.render(force);
			});
		}
	}, {
		key: 'render_preview',
		value: function render_preview(layers) {
			var w = this.Base_gui.GUI_preview.PREVIEW_SIZE.w;
			var h = this.Base_gui.GUI_preview.PREVIEW_SIZE.h;

			this.ctx_preview.save();
			this.ctx_preview.clearRect(0, 0, w, h);

			//prepare scale
			this.ctx_preview.scale(w / _config2.default.WIDTH, h / _config2.default.HEIGHT);

			for (var i = layers.length - 1; i >= 0; i--) {
				var value = layers[i];

				if (value.visible == false) {
					//not visible
					continue;
				}
				if (value.type == null) {
					//empty type
					continue;
				}

				this.ctx_preview.globalAlpha = value.opacity / 100;
				this.ctx_preview.globalCompositeOperation = value.composition;

				this.render_object(this.ctx_preview, value);
			}

			this.ctx_preview.restore();
			this.Base_gui.GUI_preview.render_preview_active_zone();
		}

		/**
   * export current 1ayers to given canvas
   * 
   * @param {canvas.context} ctx
   * @param {object} object
   */

	}, {
		key: 'render_object',
		value: function render_object(ctx, object) {
			if (object.visible == false || object.type == null) return;

			//apply filters
			var filter_code = '';
			for (var i in object.filters) {
				var filter = object.filters[i];

				if (filter_code != '') filter_code += ' ';
				filter_code += filter.name + "(" + filter.params.value + ")";
			}
			if (filter_code != '') ctx.filter = filter_code;else ctx.filter = 'none';

			//example with canvas object - other types should overwrite this method
			if (object.type == 'image') {
				//image - default behaviour
				var rotateSupport = true;
				if (rotateSupport == false) {
					if (object.link_canvas != undefined && object.link_canvas != null) {
						//we have draft canvas - use it
						ctx.drawImage(object.link_canvas, object.x, object.y, object.width, object.height);
					} else {
						ctx.drawImage(object.link, object.x, object.y, object.width, object.height);
					}
				} else {
					ctx.save();

					ctx.translate(object.x + object.width / 2, object.y + object.height / 2);
					ctx.rotate(object.rotate * Math.PI / 180);
					if (object.link_canvas != undefined && object.link_canvas != null) {
						//we have draft canvas - use it
						ctx.drawImage(object.link_canvas, -object.width / 2, -object.height / 2, object.width, object.height);
					} else {
						ctx.drawImage(object.link, -object.width / 2, -object.height / 2, object.width, object.height);
					}

					ctx.restore();
				}
			} else {
				//call render function from other module
				var render_class = object.render_function[0];
				var render_function = object.render_function[1];

				this.Base_gui.GUI_tools.tools_modules[render_class][render_function](ctx, object);
			}
			ctx.filter = 'none';
		}

		/**
   * creates new layer
   * 
   * @param {array} settings
   * @param {boolean} can_automate
   */

	}, {
		key: 'insert',
		value: function insert(settings) {
			var can_automate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

			var _this = this;
			var need_autoresize = false;

			//create empty layer
			var layer = {
				id: this.auto_increment,
				parent_id: 0,
				name: this.Helper.ucfirst(_config2.default.TOOL.name) + ' #' + this.auto_increment,
				type: null,
				link: null,
				x: 0,
				y: 0,
				width: 0,
				width_original: null,
				height: 0,
				height_original: null,
				visible: true,
				opacity: 100,
				order: this.auto_increment,
				composition: 'source-over',
				rotate: 0,
				data: null,
				params: {},
				status: null,
				color: _config2.default.COLOR,
				filters: [],
				render_function: null
			};

			//add data
			for (var i in settings) {
				if (typeof layer[i] == "undefined") {
					_alertifyMin2.default.error('Error: wrong key: ' + i);
					continue;
				}
				layer[i] = settings[i];
			}

			//if image - prepare
			if (layer.type == 'image') {

				if (_config2.default.layers.length == 1 && _config2.default.layer.width == 0 && _config2.default.layer.height == 0 && _config2.default.layer.data == null) {
					//remove first empty layer?
					this.delete(_config2.default.layer.id, true);
				}

				if (layer.link == null) {
					if (_typeof(layer.data) == 'object') {
						//load actual image
						if (layer.width == 0) layer.width = layer.data.width;
						if (layer.height == 0) layer.height = layer.data.height;
						layer.link = layer.data.cloneNode(true);
						layer.data = null;
						need_autoresize = true;
					} else if (typeof layer.data == 'string') {
						//try loading as imageData
						layer.link = new Image();
						layer.link.onload = function () {
							//update dimensions
							if (layer.width == 0) layer.width = layer.link.width;
							if (layer.height == 0) layer.height = layer.link.height;
							if (layer.width_original == null) layer.width_original = layer.width;
							if (layer.height_original == null) layer.height_original = layer.height;
							//free data

							layer.data = null;
							_this.autoresize(layer.width, layer.height, layer.id, can_automate);
							_this.render();
							layer.link.onload = function () {
								_config2.default.need_render = true;
							};
						};
						layer.link.src = layer.data;
					} else {
						_alertifyMin2.default.error('Error: can not load image.');
					}
				}
			}

			if (settings != undefined && _config2.default.layers.length > 0 && _config2.default.layer.width == 0 && _config2.default.layer.height == 0 && _config2.default.layer.data == null && layer.type != 'image' && can_automate !== false) {
				//update existing empty
				for (var i in layer) {
					if (i == 'id') continue;
					if (i == 'name') continue;
					if (i == 'order') continue;
					_config2.default.layer[i] = layer[i];
				}
			} else {
				//new layer
				_config2.default.layers.push(layer);
				_config2.default.layer = this.get_layer(this.auto_increment);
				this.auto_increment++;

				if (_config2.default.layer == null) {
					_config2.default.layer = _config2.default.layers[0];
				}
			}

			if (layer.id >= this.auto_increment) this.auto_increment = layer.id + 1;

			if (need_autoresize == true) {
				this.autoresize(_config2.default.layer.width, _config2.default.layer.height);
			}

			this.render();
			this.Base_gui.GUI_layers.render_layers();
		}

		/**
   * autoresize layer, based on dimensions, up - always, if 1 layer - down.
   * 
   * @param {int} width
   * @param {int} height
   * @param {int} layer_id
   * @param {boolean} can_automate
   */

	}, {
		key: 'autoresize',
		value: function autoresize(width, height, layer_id) {
			var can_automate = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;

			var _this = this;
			var need_fit = false;

			if (layer_id == undefined) layer_id = _config2.default.layer;

			//resize up
			if (width > _config2.default.WIDTH || height > _config2.default.HEIGHT) {

				var wrapper = document.getElementById('main_wrapper');
				var page_w = wrapper.clientWidth;
				var page_h = wrapper.clientHeight;

				if (width > page_w || height > page_h) {
					need_fit = true;
				}
				if (width > _config2.default.WIDTH) _config2.default.WIDTH = parseInt(width);
				if (height > _config2.default.HEIGHT) _config2.default.HEIGHT = parseInt(height);
			}

			//resize down
			if (_config2.default.layers.length == 1 && can_automate !== false) {
				if (width < _config2.default.WIDTH) _config2.default.WIDTH = parseInt(width);
				if (height < _config2.default.HEIGHT) _config2.default.HEIGHT = parseInt(height);
			}

			this.Base_gui.prepare_canvas();

			//fit zoom when after short pause
			if (need_fit == true) {
				var myCallback = function myCallback() {
					_this.Base_gui.GUI_preview.zoom_auto();
				};

				var internal = window.setTimeout(myCallback, 100);
			}
		}

		/**
   * returns layer
   * 
   * @param {int} id
   * @returns {object}
   */

	}, {
		key: 'get_layer',
		value: function get_layer(id) {
			for (var i in _config2.default.layers) {
				if (_config2.default.layers[i].id == id) {
					return _config2.default.layers[i];
				}
			}
			return null;
		}

		/**
   * removes layer
   * 
   * @param {int} id
   * @param {boolean} force - Force to delete first layer?
   */

	}, {
		key: 'delete',
		value: function _delete(id, force) {
			id = parseInt(id);
			if (_config2.default.layers.length == 1 && (force == undefined || force == false)) {
				//only 1 layer left
				if (_config2.default.layer.type == null) {
					//STOP
					return;
				} else {
					//delete it, but before that - create new empty layer
					this.insert();
				}
			}

			if (_config2.default.layer.id == id) {
				//select previous layer
				_config2.default.layer = this.find_next(id);
				if (_config2.default.layer == null) _config2.default.layer = this.find_previous(id);
			}

			for (var i in _config2.default.layers) {
				if (_config2.default.layers[i].id == id) {
					//delete

					if (_config2.default.layers[i].type == 'image') {
						//clean image
						_config2.default.layers[i].link = null;
					}

					_config2.default.layers.splice(i, 1);
				}
			}

			this.render();
			this.Base_gui.GUI_layers.render_layers();
		}

		/*
   * removes all layers
   */

	}, {
		key: 'reset_layers',
		value: function reset_layers(auto_insert) {
			for (var i = _config2.default.layers.length - 1; i >= 0; i--) {
				this.delete(_config2.default.layers[i].id, true);
			}
			this.auto_increment = 1;

			if (auto_insert != undefined && auto_insert === true) {
				var settings = {};
				this.insert(settings);
			}

			this.render();
			this.Base_gui.GUI_layers.render_layers();
		}

		/**
   * toggle layer visibility
   * 
   * @param {int} id
   */

	}, {
		key: 'toggle_visibility',
		value: function toggle_visibility(id) {
			id = parseInt(id);
			var link = this.get_layer(id);

			if (link.visible == false) link.visible = true;else link.visible = false;

			this.render();
			this.Base_gui.GUI_layers.render_layers();
		}

		/*
   * renew layers HTML
   */

	}, {
		key: 'refresh_gui',
		value: function refresh_gui() {
			this.Base_gui.GUI_layers.render_layers();
		}

		/**
   * marks layer as selected, active
   * 
   * @param {int} id
   */

	}, {
		key: 'select',
		value: function select(id) {
			id = parseInt(id);
			_config2.default.layer = this.get_layer(id);
			this.Base_selection.reset_selection();

			this.render();
			this.Base_gui.GUI_layers.render_layers();
		}

		/**
   * change layer opacity
   * 
   * @param {int} id
   * @param {int} value 0-100
   */

	}, {
		key: 'set_opacity',
		value: function set_opacity(id, value) {
			id = parseInt(id);
			value = parseInt(value);
			if (value < 0 || value > 100) {
				//reset
				value = 100;
			}
			var link = this.get_layer(id);

			link.opacity = value;
		}

		/**
   * clear layer data
   * 
   * @param {int} id
   */

	}, {
		key: 'layer_clear',
		value: function layer_clear(id) {
			id = parseInt(id);
			var link = this.get_layer(id);

			link.data = null;
			link.x = 0;
			link.y = 0;
			link.width = 0;
			link.height = 0;
		}

		/**
   * move layer up or down
   * 
   * @param {int} id
   * @param {int} direction
   */

	}, {
		key: 'move',
		value: function move(id, direction) {
			id = parseInt(id);
			var link = this.get_layer(id);

			if (direction < 0) {
				var target = this.find_previous(id);
			} else {
				var target = this.find_next(id);
			}
			if (target != null) {
				var current_order = link.order;
				link.order = target.order;
				target.order = current_order;
			}

			this.render();
			this.Base_gui.GUI_layers.render_layers();
		}

		/**
   * clone and sort.
   */

	}, {
		key: 'get_sorted_layers',
		value: function get_sorted_layers() {
			return _config2.default.layers.concat().sort(
			//sort function
			function (a, b) {
				return b.order - a.order;
			});
		}

		/**
   * checks if layer empty
   * 
   * @param {int} id
   * @returns {Boolean}
   */

	}, {
		key: 'is_layer_empty',
		value: function is_layer_empty(id) {
			var link = this.get_layer(id);

			if (link.width == 0 && link.height == 0 && link.data == null) {
				return true;
			}

			return false;
		}

		/**
   * find next layer
   * 
   * @param {int} id layer id
   * @returns {layer|null}
   */

	}, {
		key: 'find_next',
		value: function find_next(id) {
			id = parseInt(id);
			var link = this.get_layer(id);
			var layers_sorted = this.get_sorted_layers();

			var last = null;
			for (var i = layers_sorted.length - 1; i >= 0; i--) {
				var value = layers_sorted[i];

				if (last != null && last.id == link.id) {
					return value;
				}
				last = value;
			}

			return null;
		}

		/**
   * find previous layer
   * 
   * @param {int} id layer id
   * @returns {layer|null}
   */

	}, {
		key: 'find_previous',
		value: function find_previous(id) {
			id = parseInt(id);
			var link = this.get_layer(id);
			var layers_sorted = this.get_sorted_layers();

			var last = null;
			for (var i in layers_sorted) {
				var value = layers_sorted[i];

				if (last != null && last.id == link.id) {
					return value;
				}
				last = value;
			}

			return null;
		}

		/**
   * returns global position, for example if canvas is zoomed, it will convert relative mouse position to absolute at 100% zoom.
   * 
   * @param {int} x
   * @param {int} y
   * @returns {object} keys: x, y
   */

	}, {
		key: 'get_world_coords',
		value: function get_world_coords(x, y) {
			return _zoomView2.default.toWorld(x, y);
		}

		/**
   * register new live filter
   * 
   * @param {int} layer_id
   * @param {string} name
   * @param {object} params
   */

	}, {
		key: 'add_filter',
		value: function add_filter(layer_id, name, params) {
			if (layer_id == null) layer_id = _config2.default.layer.id;
			var link = this.get_layer(layer_id);
			var filter = {
				id: this.Helper.getRandomInt(1, 999999999),
				name: name,
				params: params
			};
			link.filters.push(filter);

			_config2.default.need_render = true;
			this.Base_gui.GUI_layers.render_layers();
		}

		/**
   * delets live filter
   * 
   * @param {int} layer_id
   * @param {string} filter_id
   */

	}, {
		key: 'delete_filter',
		value: function delete_filter(layer_id, filter_id) {
			if (layer_id == null) layer_id = _config2.default.layer.id;
			var link = this.get_layer(layer_id);

			for (var i in link.filters) {
				if (link.filters[i].id == filter_id) {
					link.filters.splice(i, 1);
				}
			}

			_config2.default.need_render = true;
			this.Base_gui.GUI_layers.render_layers();
		}

		/**
   * exports all layers to canvas for saving
   * 
   * @param {canvas.context} ctx
   * @param {int} layer_id Optional
   */

	}, {
		key: 'convert_layers_to_canvas',
		value: function convert_layers_to_canvas(ctx, layer_id) {
			var layers_sorted = this.get_sorted_layers();
			for (var i = layers_sorted.length - 1; i >= 0; i--) {
				var value = layers_sorted[i];

				if (value.visible == false || value.type == null) {
					continue;
				}
				if (layer_id != undefined && value.id != layer_id) {
					continue;
				}

				ctx.globalAlpha = value.opacity / 100;
				ctx.globalCompositeOperation = value.composition;

				this.render_object(ctx, value);
			}
		}
		/**
   * exports (active) layer to canvas for saving
   * 
   * @param {int} layer_id
   * @param {boolean} actual_area if false, all visible and trimed area will be used
   * @param {boolean} can_trim default is true
   * @returns {canvas}
   */

	}, {
		key: 'convert_layer_to_canvas',
		value: function convert_layer_to_canvas(layer_id) {
			var actual_area = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
			var can_trim = arguments[2];

			if (layer_id == null) layer_id = _config2.default.layer.id;
			var link = this.get_layer(layer_id);
			var offset_x = 0;
			var offset_y = 0;

			//create tmp canvas
			var canvas = document.createElement('canvas');
			if (actual_area === true && link.type == 'image') {
				canvas.width = link.width_original;
				canvas.height = link.height_original;
				can_trim = false;
			} else {
				canvas.width = Math.max(link.width, _config2.default.WIDTH);
				canvas.height = Math.max(link.height, _config2.default.HEIGHT);
			}

			//add data
			if (actual_area === true && link.type == 'image') {
				canvas.getContext("2d").drawImage(link.link, 0, 0);
			} else {
				this.render_object(canvas.getContext("2d"), link);
			}

			//trim
			if ((can_trim == true || can_trim == undefined) && link.type != null) {
				var trim_info = this.Image_trim.get_trim_info(layer_id);
				if (trim_info.left > 0 || trim_info.top > 0 || trim_info.right > 0 || trim_info.bottom > 0) {
					offset_x = trim_info.left;
					offset_y = trim_info.top;

					this.Helper.change_canvas_size(canvas, canvas.width - trim_info.left - trim_info.right, canvas.height - trim_info.top - trim_info.bottom, offset_x, offset_y);
				}
			}

			canvas.dataset.x = offset_x;
			canvas.dataset.y = offset_y;

			return canvas;
		}

		/**
   * updates layer image data
   * 
   * @param {canvas} canvas
   * @param {int} layer_id (optional)
   */

	}, {
		key: 'update_layer_image',
		value: function update_layer_image(canvas, layer_id) {
			if (layer_id == null) layer_id = _config2.default.layer.id;
			var link = this.get_layer(layer_id);

			if (link.type != 'image') return null;

			if (this.Helper.is_edge_or_ie() == false) {
				//update image using blob (faster)
				canvas.toBlob(function (blob) {
					link.link.src = window.URL.createObjectURL(blob);
					_config2.default.need_render = true;
				}, 'image/png');
			} else {
				//slow way for IE, Edge
				link.link.src = canvas.toDataURL();
			}

			_config2.default.need_render = true;
		}

		/**
   * returns canvas dimensions.
   * 
   * @returns {object}
   */

	}, {
		key: 'get_dimensions',
		value: function get_dimensions() {
			return {
				width: _config2.default.WIDTH,
				height: _config2.default.HEIGHT
			};
		}
	}]);

	return Base_layers_class;
}();

exports.default = Base_layers_class;

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*! alertifyjs - v1.11.0 - Mohammad Younes <Mohammad@alertifyjs.com> (http://alertifyjs.com) */
!function(a){"use strict";function b(a,b){a.className+=" "+b}function c(a,b){for(var c=a.className.split(" "),d=b.split(" "),e=0;e<d.length;e+=1){var f=c.indexOf(d[e]);f>-1&&c.splice(f,1)}a.className=c.join(" ")}function d(){return"rtl"===a.getComputedStyle(document.body).direction}function e(){return document.documentElement&&document.documentElement.scrollTop||document.body.scrollTop}function f(){return document.documentElement&&document.documentElement.scrollLeft||document.body.scrollLeft}function g(a){for(;a.lastChild;)a.removeChild(a.lastChild)}function h(a){if(null===a)return a;var b;if(Array.isArray(a)){b=[];for(var c=0;c<a.length;c+=1)b.push(h(a[c]));return b}if(a instanceof Date)return new Date(a.getTime());if(a instanceof RegExp)return b=new RegExp(a.source),b.global=a.global,b.ignoreCase=a.ignoreCase,b.multiline=a.multiline,b.lastIndex=a.lastIndex,b;if("object"==typeof a){b={};for(var d in a)a.hasOwnProperty(d)&&(b[d]=h(a[d]));return b}return a}function i(a,b){var c=a.elements.root;c.parentNode.removeChild(c),delete a.elements,a.settings=h(a.__settings),a.__init=b,delete a.__internal}function j(a,b){return function(){if(arguments.length>0){for(var c=[],d=0;d<arguments.length;d+=1)c.push(arguments[d]);return c.push(a),b.apply(a,c)}return b.apply(a,[null,a])}}function k(a,b){return{index:a,button:b,cancel:!1}}function l(a,b){if("function"==typeof b.get(a))return b.get(a).call(b)}function m(){function a(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c]);return a}function b(a){var b=d[a].dialog;return b&&"function"==typeof b.__init&&b.__init(b),b}function c(b,c,e,f){var g={dialog:null,factory:c};return void 0!==f&&(g.factory=function(){return a(new d[f].factory,new c)}),e||(g.dialog=a(new g.factory,t)),d[b]=g}var d={};return{defaults:o,dialog:function(d,e,f,g){if("function"!=typeof e)return b(d);if(this.hasOwnProperty(d))throw new Error("alertify.dialog: name already exists");var h=c(d,e,f,g);this[d]=f?function(){if(0===arguments.length)return h.dialog;var b=a(new h.factory,t);return b&&"function"==typeof b.__init&&b.__init(b),b.main.apply(b,arguments),b.show.apply(b)}:function(){if(h.dialog&&"function"==typeof h.dialog.__init&&h.dialog.__init(h.dialog),0===arguments.length)return h.dialog;var a=h.dialog;return a.main.apply(h.dialog,arguments),a.show.apply(h.dialog)}},closeAll:function(a){for(var b=p.slice(0),c=0;c<b.length;c+=1){var d=b[c];void 0!==a&&a===d||d.close()}},setting:function(a,c,d){if("notifier"===a)return u.setting(c,d);var e=b(a);return e?e.setting(c,d):void 0},set:function(a,b,c){return this.setting(a,b,c)},get:function(a,b){return this.setting(a,b)},notify:function(a,b,c,d){return u.create(b,d).push(a,c)},message:function(a,b,c){return u.create(null,c).push(a,b)},success:function(a,b,c){return u.create("success",c).push(a,b)},error:function(a,b,c){return u.create("error",c).push(a,b)},warning:function(a,b,c){return u.create("warning",c).push(a,b)},dismissAll:function(){u.dismissAll()}}}var n={ENTER:13,ESC:27,F1:112,F12:123,LEFT:37,RIGHT:39},o={autoReset:!0,basic:!1,closable:!0,closableByDimmer:!0,frameless:!1,maintainFocus:!0,maximizable:!0,modal:!0,movable:!0,moveBounded:!1,overflow:!0,padding:!0,pinnable:!0,pinned:!0,preventBodyShift:!1,resizable:!0,startMaximized:!1,transition:"pulse",notifier:{delay:5,position:"bottom-right",closeButton:!1},glossary:{title:"AlertifyJS",ok:"OK",cancel:"Cancel",acccpt:"Accept",deny:"Deny",confirm:"Confirm",decline:"Decline",close:"Close",maximize:"Maximize",restore:"Restore"},theme:{input:"ajs-input",ok:"ajs-ok",cancel:"ajs-cancel"}},p=[],q=function(){return document.addEventListener?function(a,b,c,d){a.addEventListener(b,c,!0===d)}:document.attachEvent?function(a,b,c){a.attachEvent("on"+b,c)}:void 0}(),r=function(){return document.removeEventListener?function(a,b,c,d){a.removeEventListener(b,c,!0===d)}:document.detachEvent?function(a,b,c){a.detachEvent("on"+b,c)}:void 0}(),s=function(){var a,b,c=!1,d={animation:"animationend",OAnimation:"oAnimationEnd oanimationend",msAnimation:"MSAnimationEnd",MozAnimation:"animationend",WebkitAnimation:"webkitAnimationEnd"};for(a in d)if(void 0!==document.documentElement.style[a]){b=d[a],c=!0;break}return{type:b,supported:c}}(),t=function(){function m(a){if(!a.__internal){delete a.__init,a.__settings||(a.__settings=h(a.settings)),null===za&&document.body.setAttribute("tabindex","0");var c;"function"==typeof a.setup?(c=a.setup(),c.options=c.options||{},c.focus=c.focus||{}):c={buttons:[],focus:{element:null,select:!1},options:{}},"object"!=typeof a.hooks&&(a.hooks={});var d=[];if(Array.isArray(c.buttons))for(var e=0;e<c.buttons.length;e+=1){var f=c.buttons[e],g={};for(var i in f)f.hasOwnProperty(i)&&(g[i]=f[i]);d.push(g)}var k=a.__internal={isOpen:!1,activeElement:document.body,timerIn:void 0,timerOut:void 0,buttons:d,focus:c.focus,options:{title:void 0,modal:void 0,basic:void 0,frameless:void 0,pinned:void 0,movable:void 0,moveBounded:void 0,resizable:void 0,autoReset:void 0,closable:void 0,closableByDimmer:void 0,maximizable:void 0,startMaximized:void 0,pinnable:void 0,transition:void 0,padding:void 0,overflow:void 0,onshow:void 0,onclosing:void 0,onclose:void 0,onfocus:void 0,onmove:void 0,onmoved:void 0,onresize:void 0,onresized:void 0,onmaximize:void 0,onmaximized:void 0,onrestore:void 0,onrestored:void 0},resetHandler:void 0,beginMoveHandler:void 0,beginResizeHandler:void 0,bringToFrontHandler:void 0,modalClickHandler:void 0,buttonsClickHandler:void 0,commandsClickHandler:void 0,transitionInHandler:void 0,transitionOutHandler:void 0,destroy:void 0},l={};l.root=document.createElement("div"),l.root.className=Ca.base+" "+Ca.hidden+" ",l.root.innerHTML=Ba.dimmer+Ba.modal,l.dimmer=l.root.firstChild,l.modal=l.root.lastChild,l.modal.innerHTML=Ba.dialog,l.dialog=l.modal.firstChild,l.dialog.innerHTML=Ba.reset+Ba.commands+Ba.header+Ba.body+Ba.footer+Ba.resizeHandle+Ba.reset,l.reset=[],l.reset.push(l.dialog.firstChild),l.reset.push(l.dialog.lastChild),l.commands={},l.commands.container=l.reset[0].nextSibling,l.commands.pin=l.commands.container.firstChild,l.commands.maximize=l.commands.pin.nextSibling,l.commands.close=l.commands.maximize.nextSibling,l.header=l.commands.container.nextSibling,l.body=l.header.nextSibling,l.body.innerHTML=Ba.content,l.content=l.body.firstChild,l.footer=l.body.nextSibling,l.footer.innerHTML=Ba.buttons.auxiliary+Ba.buttons.primary,l.resizeHandle=l.footer.nextSibling,l.buttons={},l.buttons.auxiliary=l.footer.firstChild,l.buttons.primary=l.buttons.auxiliary.nextSibling,l.buttons.primary.innerHTML=Ba.button,l.buttonTemplate=l.buttons.primary.firstChild,l.buttons.primary.removeChild(l.buttonTemplate);for(var m=0;m<a.__internal.buttons.length;m+=1){var n=a.__internal.buttons[m];ya.indexOf(n.key)<0&&ya.push(n.key),n.element=l.buttonTemplate.cloneNode(),n.element.innerHTML=n.text,"string"==typeof n.className&&""!==n.className&&b(n.element,n.className);for(var o in n.attrs)"className"!==o&&n.attrs.hasOwnProperty(o)&&n.element.setAttribute(o,n.attrs[o]);"auxiliary"===n.scope?l.buttons.auxiliary.appendChild(n.element):l.buttons.primary.appendChild(n.element)}a.elements=l,k.resetHandler=j(a,X),k.beginMoveHandler=j(a,aa),k.beginResizeHandler=j(a,ga),k.bringToFrontHandler=j(a,B),k.modalClickHandler=j(a,R),k.buttonsClickHandler=j(a,T),k.commandsClickHandler=j(a,F),k.transitionInHandler=j(a,Y),k.transitionOutHandler=j(a,Z);for(var p in k.options)void 0!==c.options[p]?a.set(p,c.options[p]):v.defaults.hasOwnProperty(p)?a.set(p,v.defaults[p]):"title"===p&&a.set(p,v.defaults.glossary[p]);"function"==typeof a.build&&a.build()}document.body.appendChild(a.elements.root)}function o(){wa=f(),xa=e()}function t(){a.scrollTo(wa,xa)}function u(){for(var a=0,d=0;d<p.length;d+=1){var e=p[d];(e.isModal()||e.isMaximized())&&(a+=1)}0===a&&document.body.className.indexOf(Ca.noOverflow)>=0?(c(document.body,Ca.noOverflow),w(!1)):a>0&&document.body.className.indexOf(Ca.noOverflow)<0&&(w(!0),b(document.body,Ca.noOverflow))}function w(d){v.defaults.preventBodyShift&&document.documentElement.scrollHeight>document.documentElement.clientHeight&&(d?(Ea=xa,Da=a.getComputedStyle(document.body).top,b(document.body,Ca.fixed),document.body.style.top=-xa+"px"):(xa=Ea,document.body.style.top=Da,c(document.body,Ca.fixed),t()))}function x(a,d,e){"string"==typeof e&&c(a.elements.root,Ca.prefix+e),b(a.elements.root,Ca.prefix+d),za=a.elements.root.offsetWidth}function y(a){a.get("modal")?(c(a.elements.root,Ca.modeless),a.isOpen()&&(pa(a),N(a),u())):(b(a.elements.root,Ca.modeless),a.isOpen()&&(oa(a),N(a),u()))}function z(a){a.get("basic")?b(a.elements.root,Ca.basic):c(a.elements.root,Ca.basic)}function A(a){a.get("frameless")?b(a.elements.root,Ca.frameless):c(a.elements.root,Ca.frameless)}function B(a,b){for(var c=p.indexOf(b),d=c+1;d<p.length;d+=1)if(p[d].isModal())return;return document.body.lastChild!==b.elements.root&&(document.body.appendChild(b.elements.root),p.splice(p.indexOf(b),1),p.push(b),W(b)),!1}function C(a,d,e,f){switch(d){case"title":a.setHeader(f);break;case"modal":y(a);break;case"basic":z(a);break;case"frameless":A(a);break;case"pinned":O(a);break;case"closable":Q(a);break;case"maximizable":P(a);break;case"pinnable":K(a);break;case"movable":ea(a);break;case"resizable":ka(a);break;case"transition":x(a,f,e);break;case"padding":f?c(a.elements.root,Ca.noPadding):a.elements.root.className.indexOf(Ca.noPadding)<0&&b(a.elements.root,Ca.noPadding);break;case"overflow":f?c(a.elements.root,Ca.noOverflow):a.elements.root.className.indexOf(Ca.noOverflow)<0&&b(a.elements.root,Ca.noOverflow);break;case"transition":x(a,f,e)}"function"==typeof a.hooks.onupdate&&a.hooks.onupdate.call(a,d,e,f)}function D(a,b,c,d,e){var f={op:void 0,items:[]};if(void 0===e&&"string"==typeof d)f.op="get",b.hasOwnProperty(d)?(f.found=!0,f.value=b[d]):(f.found=!1,f.value=void 0);else{var g;if(f.op="set","object"==typeof d){var h=d;for(var i in h)b.hasOwnProperty(i)?(b[i]!==h[i]&&(g=b[i],b[i]=h[i],c.call(a,i,g,h[i])),f.items.push({key:i,value:h[i],found:!0})):f.items.push({key:i,value:h[i],found:!1})}else{if("string"!=typeof d)throw new Error("args must be a string or object");b.hasOwnProperty(d)?(b[d]!==e&&(g=b[d],b[d]=e,c.call(a,d,g,e)),f.items.push({key:d,value:e,found:!0})):f.items.push({key:d,value:e,found:!1})}}return f}function E(a){var b;S(a,function(a){return b=!0===a.invokeOnClose}),!b&&a.isOpen()&&a.close()}function F(a,b){switch(a.srcElement||a.target){case b.elements.commands.pin:b.isPinned()?H(b):G(b);break;case b.elements.commands.maximize:b.isMaximized()?J(b):I(b);break;case b.elements.commands.close:E(b)}return!1}function G(a){a.set("pinned",!0)}function H(a){a.set("pinned",!1)}function I(a){l("onmaximize",a),b(a.elements.root,Ca.maximized),a.isOpen()&&u(),l("onmaximized",a)}function J(a){l("onrestore",a),c(a.elements.root,Ca.maximized),a.isOpen()&&u(),l("onrestored",a)}function K(a){a.get("pinnable")?b(a.elements.root,Ca.pinnable):c(a.elements.root,Ca.pinnable)}function L(a){var b=f();a.elements.modal.style.marginTop=e()+"px",a.elements.modal.style.marginLeft=b+"px",a.elements.modal.style.marginRight=-b+"px"}function M(a){var b=parseInt(a.elements.modal.style.marginTop,10),c=parseInt(a.elements.modal.style.marginLeft,10);if(a.elements.modal.style.marginTop="",a.elements.modal.style.marginLeft="",a.elements.modal.style.marginRight="",a.isOpen()){var d=0,g=0;""!==a.elements.dialog.style.top&&(d=parseInt(a.elements.dialog.style.top,10)),a.elements.dialog.style.top=d+(b-e())+"px",""!==a.elements.dialog.style.left&&(g=parseInt(a.elements.dialog.style.left,10)),a.elements.dialog.style.left=g+(c-f())+"px"}}function N(a){a.get("modal")||a.get("pinned")?M(a):L(a)}function O(a){a.get("pinned")?(c(a.elements.root,Ca.unpinned),a.isOpen()&&M(a)):(b(a.elements.root,Ca.unpinned),a.isOpen()&&!a.isModal()&&L(a))}function P(a){a.get("maximizable")?b(a.elements.root,Ca.maximizable):c(a.elements.root,Ca.maximizable)}function Q(a){a.get("closable")?(b(a.elements.root,Ca.closable),ua(a)):(c(a.elements.root,Ca.closable),va(a))}function R(a,b){var c=a.srcElement||a.target;return Fa||c!==b.elements.modal||!0!==b.get("closableByDimmer")||E(b),Fa=!1,!1}function S(a,b){for(var c=0;c<a.__internal.buttons.length;c+=1){var d=a.__internal.buttons[c];if(!d.element.disabled&&b(d)){var e=k(c,d);"function"==typeof a.callback&&a.callback.apply(a,[e]),!1===e.cancel&&a.close();break}}}function T(a,b){var c=a.srcElement||a.target;S(b,function(a){return a.element===c&&(Ga=!0)})}function U(a){if(Ga)return void(Ga=!1);var b=p[p.length-1],c=a.keyCode;return 0===b.__internal.buttons.length&&c===n.ESC&&!0===b.get("closable")?(E(b),!1):ya.indexOf(c)>-1?(S(b,function(a){return a.key===c}),!1):void 0}function V(a){var b=p[p.length-1],c=a.keyCode;if(c===n.LEFT||c===n.RIGHT){for(var d=b.__internal.buttons,e=0;e<d.length;e+=1)if(document.activeElement===d[e].element)switch(c){case n.LEFT:return void d[(e||d.length)-1].element.focus();case n.RIGHT:return void d[(e+1)%d.length].element.focus()}}else if(c<n.F12+1&&c>n.F1-1&&ya.indexOf(c)>-1)return a.preventDefault(),a.stopPropagation(),S(b,function(a){return a.key===c}),!1}function W(a,b){if(b)b.focus();else{var c=a.__internal.focus,d=c.element;switch(typeof c.element){case"number":a.__internal.buttons.length>c.element&&(d=!0===a.get("basic")?a.elements.reset[0]:a.__internal.buttons[c.element].element);break;case"string":d=a.elements.body.querySelector(c.element);break;case"function":d=c.element.call(a)}void 0!==d&&null!==d||0!==a.__internal.buttons.length||(d=a.elements.reset[0]),d&&d.focus&&(d.focus(),c.select&&d.select&&d.select())}}function X(a,b){if(!b)for(var c=p.length-1;c>-1;c-=1)if(p[c].isModal()){b=p[c];break}if(b&&b.isModal()){var d,e=a.srcElement||a.target,f=e===b.elements.reset[1]||0===b.__internal.buttons.length&&e===document.body;f&&(b.get("maximizable")?d=b.elements.commands.maximize:b.get("closable")&&(d=b.elements.commands.close)),void 0===d&&("number"==typeof b.__internal.focus.element?e===b.elements.reset[0]?d=b.elements.buttons.auxiliary.firstChild||b.elements.buttons.primary.firstChild:f&&(d=b.elements.reset[0]):e===b.elements.reset[0]&&(d=b.elements.buttons.primary.lastChild||b.elements.buttons.auxiliary.lastChild)),W(b,d)}}function Y(a,b){clearTimeout(b.__internal.timerIn),W(b),t(),Ga=!1,l("onfocus",b),r(b.elements.dialog,s.type,b.__internal.transitionInHandler),c(b.elements.root,Ca.animationIn)}function Z(a,b){clearTimeout(b.__internal.timerOut),r(b.elements.dialog,s.type,b.__internal.transitionOutHandler),da(b),ja(b),b.isMaximized()&&!b.get("startMaximized")&&J(b),v.defaults.maintainFocus&&b.__internal.activeElement&&(b.__internal.activeElement.focus(),b.__internal.activeElement=null),"function"==typeof b.__internal.destroy&&b.__internal.destroy.apply(b)}function $(a,b){var c=a[Ka]-Ia,d=a[La]-Ja;Na&&(d-=document.body.scrollTop),b.style.left=c+"px",b.style.top=d+"px"}function _(a,b){var c=a[Ka]-Ia,d=a[La]-Ja;Na&&(d-=document.body.scrollTop),b.style.left=Math.min(Ma.maxLeft,Math.max(Ma.minLeft,c))+"px",b.style.top=Na?Math.min(Ma.maxTop,Math.max(Ma.minTop,d))+"px":Math.max(Ma.minTop,d)+"px"}function aa(a,c){if(null===Pa&&!c.isMaximized()&&c.get("movable")){var d,e=0,f=0;if("touchstart"===a.type?(a.preventDefault(),d=a.targetTouches[0],Ka="clientX",La="clientY"):0===a.button&&(d=a),d){var g=c.elements.dialog;if(b(g,Ca.capture),g.style.left&&(e=parseInt(g.style.left,10)),g.style.top&&(f=parseInt(g.style.top,10)),Ia=d[Ka]-e,Ja=d[La]-f,c.isModal()?Ja+=c.elements.modal.scrollTop:c.isPinned()&&(Ja-=document.body.scrollTop),c.get("moveBounded")){var h=g,i=-e,j=-f;do{i+=h.offsetLeft,j+=h.offsetTop}while(h=h.offsetParent);Ma={maxLeft:i,minLeft:-i,maxTop:document.documentElement.clientHeight-g.clientHeight-j,minTop:-j},Oa=_}else Ma=null,Oa=$;return l("onmove",c),Na=!c.isModal()&&c.isPinned(),Ha=c,Oa(d,g),b(document.body,Ca.noSelection),!1}}}function ba(a){if(Ha){var b;"touchmove"===a.type?(a.preventDefault(),b=a.targetTouches[0]):0===a.button&&(b=a),b&&Oa(b,Ha.elements.dialog)}}function ca(){if(Ha){var a=Ha;Ha=Ma=null,c(document.body,Ca.noSelection),c(a.elements.dialog,Ca.capture),l("onmoved",a)}}function da(a){Ha=null;var b=a.elements.dialog;b.style.left=b.style.top=""}function ea(a){a.get("movable")?(b(a.elements.root,Ca.movable),a.isOpen()&&qa(a)):(da(a),c(a.elements.root,Ca.movable),a.isOpen()&&ra(a))}function fa(a,b,c){var e=b,f=0,g=0;do{f+=e.offsetLeft,g+=e.offsetTop}while(e=e.offsetParent);var h,i;!0===c?(h=a.pageX,i=a.pageY):(h=a.clientX,i=a.clientY);var j=d();if(j&&(h=document.body.offsetWidth-h,isNaN(Qa)||(f=document.body.offsetWidth-f-b.offsetWidth)),b.style.height=i-g+Ta+"px",b.style.width=h-f+Ta+"px",!isNaN(Qa)){var k=.5*Math.abs(b.offsetWidth-Ra);j&&(k*=-1),b.offsetWidth>Ra?b.style.left=Qa+k+"px":b.offsetWidth>=Sa&&(b.style.left=Qa-k+"px")}}function ga(a,c){if(!c.isMaximized()){var d;if("touchstart"===a.type?(a.preventDefault(),d=a.targetTouches[0]):0===a.button&&(d=a),d){l("onresize",c),Pa=c,Ta=c.elements.resizeHandle.offsetHeight/2;var e=c.elements.dialog;return b(e,Ca.capture),Qa=parseInt(e.style.left,10),e.style.height=e.offsetHeight+"px",e.style.minHeight=c.elements.header.offsetHeight+c.elements.footer.offsetHeight+"px",e.style.width=(Ra=e.offsetWidth)+"px","none"!==e.style.maxWidth&&(e.style.minWidth=(Sa=e.offsetWidth)+"px"),e.style.maxWidth="none",b(document.body,Ca.noSelection),!1}}}function ha(a){if(Pa){var b;"touchmove"===a.type?(a.preventDefault(),b=a.targetTouches[0]):0===a.button&&(b=a),b&&fa(b,Pa.elements.dialog,!Pa.get("modal")&&!Pa.get("pinned"))}}function ia(){if(Pa){var a=Pa;Pa=null,c(document.body,Ca.noSelection),c(a.elements.dialog,Ca.capture),Fa=!0,l("onresized",a)}}function ja(a){Pa=null;var b=a.elements.dialog;"none"===b.style.maxWidth&&(b.style.maxWidth=b.style.minWidth=b.style.width=b.style.height=b.style.minHeight=b.style.left="",Qa=Number.Nan,Ra=Sa=Ta=0)}function ka(a){a.get("resizable")?(b(a.elements.root,Ca.resizable),a.isOpen()&&sa(a)):(ja(a),c(a.elements.root,Ca.resizable),a.isOpen()&&ta(a))}function la(){for(var a=0;a<p.length;a+=1){var b=p[a];b.get("autoReset")&&(da(b),ja(b))}}function ma(b){1===p.length&&(q(a,"resize",la),q(document.body,"keyup",U),q(document.body,"keydown",V),q(document.body,"focus",X),q(document.documentElement,"mousemove",ba),q(document.documentElement,"touchmove",ba),q(document.documentElement,"mouseup",ca),q(document.documentElement,"touchend",ca),q(document.documentElement,"mousemove",ha),q(document.documentElement,"touchmove",ha),q(document.documentElement,"mouseup",ia),q(document.documentElement,"touchend",ia)),q(b.elements.commands.container,"click",b.__internal.commandsClickHandler),q(b.elements.footer,"click",b.__internal.buttonsClickHandler),q(b.elements.reset[0],"focus",b.__internal.resetHandler),q(b.elements.reset[1],"focus",b.__internal.resetHandler),Ga=!0,q(b.elements.dialog,s.type,b.__internal.transitionInHandler),b.get("modal")||oa(b),b.get("resizable")&&sa(b),b.get("movable")&&qa(b)}function na(b){1===p.length&&(r(a,"resize",la),r(document.body,"keyup",U),r(document.body,"keydown",V),r(document.body,"focus",X),r(document.documentElement,"mousemove",ba),r(document.documentElement,"mouseup",ca),r(document.documentElement,"mousemove",ha),r(document.documentElement,"mouseup",ia)),r(b.elements.commands.container,"click",b.__internal.commandsClickHandler),r(b.elements.footer,"click",b.__internal.buttonsClickHandler),r(b.elements.reset[0],"focus",b.__internal.resetHandler),r(b.elements.reset[1],"focus",b.__internal.resetHandler),q(b.elements.dialog,s.type,b.__internal.transitionOutHandler),b.get("modal")||pa(b),b.get("movable")&&ra(b),b.get("resizable")&&ta(b)}function oa(a){q(a.elements.dialog,"focus",a.__internal.bringToFrontHandler,!0)}function pa(a){r(a.elements.dialog,"focus",a.__internal.bringToFrontHandler,!0)}function qa(a){q(a.elements.header,"mousedown",a.__internal.beginMoveHandler),q(a.elements.header,"touchstart",a.__internal.beginMoveHandler)}function ra(a){r(a.elements.header,"mousedown",a.__internal.beginMoveHandler),r(a.elements.header,"touchstart",a.__internal.beginMoveHandler)}function sa(a){q(a.elements.resizeHandle,"mousedown",a.__internal.beginResizeHandler),q(a.elements.resizeHandle,"touchstart",a.__internal.beginResizeHandler)}function ta(a){r(a.elements.resizeHandle,"mousedown",a.__internal.beginResizeHandler),r(a.elements.resizeHandle,"touchstart",a.__internal.beginResizeHandler)}function ua(a){q(a.elements.modal,"click",a.__internal.modalClickHandler)}function va(a){r(a.elements.modal,"click",a.__internal.modalClickHandler)}var wa,xa,ya=[],za=null,Aa=a.navigator.userAgent.indexOf("Safari")>-1&&a.navigator.userAgent.indexOf("Chrome")<0,Ba={dimmer:'<div class="ajs-dimmer"></div>',modal:'<div class="ajs-modal" tabindex="0"></div>',dialog:'<div class="ajs-dialog" tabindex="0"></div>',reset:'<button class="ajs-reset"></button>',commands:'<div class="ajs-commands"><button class="ajs-pin"></button><button class="ajs-maximize"></button><button class="ajs-close"></button></div>',header:'<div class="ajs-header"></div>',body:'<div class="ajs-body"></div>',content:'<div class="ajs-content"></div>',footer:'<div class="ajs-footer"></div>',buttons:{primary:'<div class="ajs-primary ajs-buttons"></div>',auxiliary:'<div class="ajs-auxiliary ajs-buttons"></div>'},button:'<button class="ajs-button"></button>',resizeHandle:'<div class="ajs-handle"></div>'},Ca={animationIn:"ajs-in",animationOut:"ajs-out",base:"alertify",basic:"ajs-basic",capture:"ajs-capture",closable:"ajs-closable",fixed:"ajs-fixed",frameless:"ajs-frameless",hidden:"ajs-hidden",maximize:"ajs-maximize",maximized:"ajs-maximized",maximizable:"ajs-maximizable",modeless:"ajs-modeless",movable:"ajs-movable",noSelection:"ajs-no-selection",noOverflow:"ajs-no-overflow",noPadding:"ajs-no-padding",pin:"ajs-pin",pinnable:"ajs-pinnable",prefix:"ajs-",resizable:"ajs-resizable",restore:"ajs-restore",shake:"ajs-shake",unpinned:"ajs-unpinned"},Da="",Ea=0,Fa=!1,Ga=!1,Ha=null,Ia=0,Ja=0,Ka="pageX",La="pageY",Ma=null,Na=!1,Oa=null,Pa=null,Qa=Number.Nan,Ra=0,Sa=0,Ta=0;return{__init:m,isOpen:function(){return this.__internal.isOpen},isModal:function(){return this.elements.root.className.indexOf(Ca.modeless)<0},isMaximized:function(){return this.elements.root.className.indexOf(Ca.maximized)>-1},isPinned:function(){return this.elements.root.className.indexOf(Ca.unpinned)<0},maximize:function(){return this.isMaximized()||I(this),this},restore:function(){return this.isMaximized()&&J(this),this},pin:function(){return this.isPinned()||G(this),this},unpin:function(){return this.isPinned()&&H(this),this},bringToFront:function(){return B(null,this),this},moveTo:function(a,b){if(!isNaN(a)&&!isNaN(b)){l("onmove",this);var c=this.elements.dialog,e=c,f=0,g=0;c.style.left&&(f-=parseInt(c.style.left,10)),c.style.top&&(g-=parseInt(c.style.top,10));do{f+=e.offsetLeft,g+=e.offsetTop}while(e=e.offsetParent);var h=a-f,i=b-g;d()&&(h*=-1),c.style.left=h+"px",c.style.top=i+"px",l("onmoved",this)}return this},resizeTo:function(a,b){var c=parseFloat(a),d=parseFloat(b),e=/(\d*\.\d+|\d+)%/;if(!isNaN(c)&&!isNaN(d)&&!0===this.get("resizable")){l("onresize",this),(""+a).match(e)&&(c=c/100*document.documentElement.clientWidth),(""+b).match(e)&&(d=d/100*document.documentElement.clientHeight);var f=this.elements.dialog;"none"!==f.style.maxWidth&&(f.style.minWidth=(Sa=f.offsetWidth)+"px"),f.style.maxWidth="none",f.style.minHeight=this.elements.header.offsetHeight+this.elements.footer.offsetHeight+"px",f.style.width=c+"px",f.style.height=d+"px",l("onresized",this)}return this},setting:function(a,b){var c=this,d=D(this,this.__internal.options,function(a,b,d){C(c,a,b,d)},a,b);if("get"===d.op)return d.found?d.value:void 0!==this.settings?D(this,this.settings,this.settingUpdated||function(){},a,b).value:void 0;if("set"===d.op){if(d.items.length>0)for(var e=this.settingUpdated||function(){},f=0;f<d.items.length;f+=1){var g=d.items[f];g.found||void 0===this.settings||D(this,this.settings,e,g.key,g.value)}return this}},set:function(a,b){return this.setting(a,b),this},get:function(a){return this.setting(a)},setHeader:function(b){return"string"==typeof b?(g(this.elements.header),this.elements.header.innerHTML=b):b instanceof a.HTMLElement&&this.elements.header.firstChild!==b&&(g(this.elements.header),this.elements.header.appendChild(b)),this},setContent:function(b){return"string"==typeof b?(g(this.elements.content),this.elements.content.innerHTML=b):b instanceof a.HTMLElement&&this.elements.content.firstChild!==b&&(g(this.elements.content),this.elements.content.appendChild(b)),this},showModal:function(a){return this.show(!0,a)},show:function(a,d){if(m(this),this.__internal.isOpen){da(this),ja(this),b(this.elements.dialog,Ca.shake);var e=this;setTimeout(function(){c(e.elements.dialog,Ca.shake)},200)}else{if(this.__internal.isOpen=!0,p.push(this),v.defaults.maintainFocus&&(this.__internal.activeElement=document.activeElement),"function"==typeof this.prepare&&this.prepare(),ma(this),void 0!==a&&this.set("modal",a),o(),u(),"string"==typeof d&&""!==d&&(this.__internal.className=d,b(this.elements.root,d)),this.get("startMaximized")?this.maximize():this.isMaximized()&&J(this),N(this),c(this.elements.root,Ca.animationOut),b(this.elements.root,Ca.animationIn),clearTimeout(this.__internal.timerIn),this.__internal.timerIn=setTimeout(this.__internal.transitionInHandler,s.supported?1e3:100),Aa){var f=this.elements.root;f.style.display="none",setTimeout(function(){f.style.display="block"},0)}za=this.elements.root.offsetWidth,c(this.elements.root,Ca.hidden),"function"==typeof this.hooks.onshow&&this.hooks.onshow.call(this),l("onshow",this)}return this},close:function(){return this.__internal.isOpen&&!1!==l("onclosing",this)&&(na(this),c(this.elements.root,Ca.animationIn),b(this.elements.root,Ca.animationOut),clearTimeout(this.__internal.timerOut),this.__internal.timerOut=setTimeout(this.__internal.transitionOutHandler,s.supported?1e3:100),b(this.elements.root,Ca.hidden),za=this.elements.modal.offsetWidth,void 0!==this.__internal.className&&""!==this.__internal.className&&c(this.elements.root,this.__internal.className),"function"==typeof this.hooks.onclose&&this.hooks.onclose.call(this),l("onclose",this),p.splice(p.indexOf(this),1),this.__internal.isOpen=!1,u()),this},closeOthers:function(){return v.closeAll(this),this},destroy:function(){return this.__internal.isOpen?(this.__internal.destroy=function(){i(this,m)},this.close()):i(this,m),this}}}(),u=function(){function d(a){a.__internal||(a.__internal={position:v.defaults.notifier.position,delay:v.defaults.notifier.delay},l=document.createElement("DIV"),h(a)),l.parentNode!==document.body&&document.body.appendChild(l)}function e(a){a.__internal.pushed=!0,m.push(a)}function f(a){m.splice(m.indexOf(a),1),a.__internal.pushed=!1}function h(a){switch(l.className=n.base,a.__internal.position){case"top-right":b(l,n.top+" "+n.right);break;case"top-left":b(l,n.top+" "+n.left);break;case"top-center":b(l,n.top+" "+n.center);break;case"bottom-left":b(l,n.bottom+" "+n.left);break;case"bottom-center":b(l,n.bottom+" "+n.center);break;default:case"bottom-right":b(l,n.bottom+" "+n.right)}}function i(d,h){function i(a,b){b.__internal.closeButton&&"true"!==a.target.getAttribute("data-close")||b.dismiss(!0)}function m(a,b){r(b.element,s.type,m),l.removeChild(b.element)}function o(a){return a.__internal||(a.__internal={pushed:!1,delay:void 0,timer:void 0,clickHandler:void 0,transitionEndHandler:void 0,transitionTimeout:void 0},a.__internal.clickHandler=j(a,i),a.__internal.transitionEndHandler=j(a,m)),a}function p(a){clearTimeout(a.__internal.timer),clearTimeout(a.__internal.transitionTimeout)}return o({element:d,push:function(a,c){if(!this.__internal.pushed){e(this),p(this);var d,f;switch(arguments.length){case 0:f=this.__internal.delay;break;case 1:"number"==typeof a?f=a:(d=a,f=this.__internal.delay);break;case 2:d=a,f=c}return this.__internal.closeButton=v.defaults.notifier.closeButton,void 0!==d&&this.setContent(d),u.__internal.position.indexOf("top")<0?l.appendChild(this.element):l.insertBefore(this.element,l.firstChild),k=this.element.offsetWidth,b(this.element,n.visible),q(this.element,"click",this.__internal.clickHandler),this.delay(f)}return this},ondismiss:function(){},callback:h,dismiss:function(a){return this.__internal.pushed&&(p(this),"function"==typeof this.ondismiss&&!1===this.ondismiss.call(this)||(r(this.element,"click",this.__internal.clickHandler),void 0!==this.element&&this.element.parentNode===l&&(this.__internal.transitionTimeout=setTimeout(this.__internal.transitionEndHandler,s.supported?1e3:100),c(this.element,n.visible),"function"==typeof this.callback&&this.callback.call(this,a)),f(this))),this},delay:function(a){if(p(this),this.__internal.delay=void 0===a||isNaN(+a)?u.__internal.delay:+a,this.__internal.delay>0){var b=this;this.__internal.timer=setTimeout(function(){b.dismiss()},1e3*this.__internal.delay)}return this},setContent:function(c){if("string"==typeof c?(g(this.element),this.element.innerHTML=c):c instanceof a.HTMLElement&&this.element.firstChild!==c&&(g(this.element),this.element.appendChild(c)),this.__internal.closeButton){var d=document.createElement("span");b(d,n.close),d.setAttribute("data-close",!0),this.element.appendChild(d)}return this},dismissOthers:function(){return u.dismissAll(this),this}})}var k,l,m=[],n={base:"alertify-notifier",message:"ajs-message",top:"ajs-top",right:"ajs-right",bottom:"ajs-bottom",left:"ajs-left",center:"ajs-center",visible:"ajs-visible",hidden:"ajs-hidden",close:"ajs-close"};return{setting:function(a,b){if(d(this),void 0===b)return this.__internal[a];switch(a){case"position":this.__internal.position=b,h(this);break;case"delay":this.__internal.delay=b}return this},set:function(a,b){return this.setting(a,b),this},get:function(a){return this.setting(a)},create:function(a,b){d(this);var c=document.createElement("div");return c.className=n.message+("string"==typeof a&&""!==a?" ajs-"+a:""),i(c,b)},dismissAll:function(a){for(var b=m.slice(0),c=0;c<b.length;c+=1){var d=b[c];void 0!==a&&a===d||d.dismiss()}}}}(),v=new m;v.dialog("alert",function(){return{main:function(a,b,c){var d,e,f;switch(arguments.length){case 1:e=a;break;case 2:"function"==typeof b?(e=a,f=b):(d=a,e=b);break;case 3:d=a,e=b,f=c}return this.set("title",d),this.set("message",e),this.set("onok",f),this},setup:function(){return{buttons:[{text:v.defaults.glossary.ok,key:n.ESC,invokeOnClose:!0,className:v.defaults.theme.ok}],focus:{element:0,select:!1},options:{maximizable:!1,resizable:!1}}},build:function(){},prepare:function(){},setMessage:function(a){this.setContent(a)},settings:{message:void 0,onok:void 0,label:void 0},settingUpdated:function(a,b,c){switch(a){case"message":this.setMessage(c);break;case"label":this.__internal.buttons[0].element&&(this.__internal.buttons[0].element.innerHTML=c)}},callback:function(a){if("function"==typeof this.get("onok")){var b=this.get("onok").call(this,a);void 0!==b&&(a.cancel=!b)}}}}),v.dialog("confirm",function(){function a(a){null!==c.timer&&(clearInterval(c.timer),c.timer=null,a.__internal.buttons[c.index].element.innerHTML=c.text)}function b(b,d,e){a(b),c.duration=e,c.index=d,c.text=b.__internal.buttons[d].element.innerHTML,c.timer=setInterval(j(b,c.task),1e3),c.task(null,b)}var c={timer:null,index:null,text:null,duration:null,task:function(b,d){if(d.isOpen()){if(d.__internal.buttons[c.index].element.innerHTML=c.text+" (&#8207;"+c.duration+"&#8207;) ",c.duration-=1,-1===c.duration){a(d);var e=d.__internal.buttons[c.index],f=k(c.index,e);"function"==typeof d.callback&&d.callback.apply(d,[f]),!1!==f.close&&d.close()}}else a(d)}};return{main:function(a,b,c,d){var e,f,g,h;switch(arguments.length){case 1:f=a;break;case 2:f=a,g=b;break;case 3:f=a,g=b,h=c;break;case 4:e=a,f=b,g=c,h=d}return this.set("title",e),this.set("message",f),this.set("onok",g),this.set("oncancel",h),this},setup:function(){return{buttons:[{text:v.defaults.glossary.ok,key:n.ENTER,className:v.defaults.theme.ok},{text:v.defaults.glossary.cancel,key:n.ESC,invokeOnClose:!0,
className:v.defaults.theme.cancel}],focus:{element:0,select:!1},options:{maximizable:!1,resizable:!1}}},build:function(){},prepare:function(){},setMessage:function(a){this.setContent(a)},settings:{message:null,labels:null,onok:null,oncancel:null,defaultFocus:null,reverseButtons:null},settingUpdated:function(a,b,c){switch(a){case"message":this.setMessage(c);break;case"labels":"ok"in c&&this.__internal.buttons[0].element&&(this.__internal.buttons[0].text=c.ok,this.__internal.buttons[0].element.innerHTML=c.ok),"cancel"in c&&this.__internal.buttons[1].element&&(this.__internal.buttons[1].text=c.cancel,this.__internal.buttons[1].element.innerHTML=c.cancel);break;case"reverseButtons":!0===c?this.elements.buttons.primary.appendChild(this.__internal.buttons[0].element):this.elements.buttons.primary.appendChild(this.__internal.buttons[1].element);break;case"defaultFocus":this.__internal.focus.element="ok"===c?0:1}},callback:function(b){a(this);var c;switch(b.index){case 0:"function"==typeof this.get("onok")&&void 0!==(c=this.get("onok").call(this,b))&&(b.cancel=!c);break;case 1:"function"==typeof this.get("oncancel")&&void 0!==(c=this.get("oncancel").call(this,b))&&(b.cancel=!c)}},autoOk:function(a){return b(this,0,a),this},autoCancel:function(a){return b(this,1,a),this}}}),v.dialog("prompt",function(){var b=document.createElement("INPUT"),c=document.createElement("P");return{main:function(a,b,c,d,e){var f,g,h,i,j;switch(arguments.length){case 1:g=a;break;case 2:g=a,h=b;break;case 3:g=a,h=b,i=c;break;case 4:g=a,h=b,i=c,j=d;break;case 5:f=a,g=b,h=c,i=d,j=e}return this.set("title",f),this.set("message",g),this.set("value",h),this.set("onok",i),this.set("oncancel",j),this},setup:function(){return{buttons:[{text:v.defaults.glossary.ok,key:n.ENTER,className:v.defaults.theme.ok},{text:v.defaults.glossary.cancel,key:n.ESC,invokeOnClose:!0,className:v.defaults.theme.cancel}],focus:{element:b,select:!0},options:{maximizable:!1,resizable:!1}}},build:function(){b.className=v.defaults.theme.input,b.setAttribute("type","text"),b.value=this.get("value"),this.elements.content.appendChild(c),this.elements.content.appendChild(b)},prepare:function(){},setMessage:function(b){"string"==typeof b?(g(c),c.innerHTML=b):b instanceof a.HTMLElement&&c.firstChild!==b&&(g(c),c.appendChild(b))},settings:{message:void 0,labels:void 0,onok:void 0,oncancel:void 0,value:"",type:"text",reverseButtons:void 0},settingUpdated:function(a,c,d){switch(a){case"message":this.setMessage(d);break;case"value":b.value=d;break;case"type":switch(d){case"text":case"color":case"date":case"datetime-local":case"email":case"month":case"number":case"password":case"search":case"tel":case"time":case"week":b.type=d;break;default:b.type="text"}break;case"labels":d.ok&&this.__internal.buttons[0].element&&(this.__internal.buttons[0].element.innerHTML=d.ok),d.cancel&&this.__internal.buttons[1].element&&(this.__internal.buttons[1].element.innerHTML=d.cancel);break;case"reverseButtons":!0===d?this.elements.buttons.primary.appendChild(this.__internal.buttons[0].element):this.elements.buttons.primary.appendChild(this.__internal.buttons[1].element)}},callback:function(a){var c;switch(a.index){case 0:this.settings.value=b.value,"function"==typeof this.get("onok")&&void 0!==(c=this.get("onok").call(this,a,this.settings.value))&&(a.cancel=!c);break;case 1:"function"==typeof this.get("oncancel")&&void 0!==(c=this.get("oncancel").call(this,a))&&(a.cancel=!c),a.cancel||(b.value=this.settings.value)}}}}),"object"==typeof module&&"object"==typeof module.exports?module.exports=v: true?!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function(){return v}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)):a.alertify||(a.alertify=v)}("undefined"!=typeof window?window:this);

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * user dialogs library
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * @author ViliusL
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Usage:
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * import Dialog_class from './libs/popup.js';
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * var POP = new popup();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * var settings = {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *		title: 'Differences',
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *		comment: '',
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *		preview: true,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *		className: '',
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *		params: [
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *			{name: "param1", title: "Parameter #1:", value: "111"},
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *			{name: "param2", title: "Parameter #2:", value: "222"},
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *		],
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *		on_load: function(params){...},
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *		on_change: function(params, canvas_preview, w, h){...},
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *		on_finish: function(params){...},
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * };
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * this.POP.show(settings);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Params types:
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * - name		type				example
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * - ---------------------------------------------------------------
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * - name		string				'parameter1'
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * - title		string				'enter value:'
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * - type		string				'select', 'textarea', 'color'
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * - value		string				'314'
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * - values		array fo strings	['one', 'two', 'three']
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * - range		numbers interval	[0, 255]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * - step		int/float			1	
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * - placeholder	text			'enter number here'
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * - html		html text			'<b>bold</b>'
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * - function	function			'cutom_function'
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


__webpack_require__(54);

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _baseGui = __webpack_require__(7);

var _baseGui2 = _interopRequireDefault(_baseGui);

var _translate = __webpack_require__(15);

var _translate2 = _interopRequireDefault(_translate);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var instance = null;

var template = '\n\t<div id="pretitle_area"></div>\n\t<span class="grey right" id="popup_comment"></span>\n\t<h2 class="trn" id="popup_title"></h2>\n\t<div id="dialog_content">\n\t\t<div id="preview_content"></div>\n\t\t<div id="params_content"></div>\n\t</div>\n\t<div class="buttons">\n\t\t<button type="button" id="popup_ok" class="button trn">Ok</button>\n\t\t<button type="button" id="popup_cancel" class="button trn">Cancel</button>\n\t</div>\n';

var Dialog_class = function () {
	function Dialog_class() {
		_classCallCheck(this, Dialog_class);

		//singleton
		if (instance) {
			return instance;
		}
		instance = this;
		window.POP = this;

		this.active = false;
		this.title = null;
		this.onfinish = false;
		this.preview = false;
		this.onload = false;
		this.onchange = false;
		this.width_mini = 225;
		this.height_mini = 200;
		this.effects = false;
		this.id = 0;
		this.parameters = [];
		this.Base_layers = new _baseLayers2.default();
		this.Base_gui = new _baseGui2.default();
		this.Help_translate = new _translate2.default();
		this.last_params_hash = '';
		this.layer_active_small = document.createElement("canvas");
		this.layer_active_small_ctx = this.layer_active_small.getContext("2d");
		this.ef_index = null; //current effect list key
		this.ef_prev_index = null;
		this.ef_next_index = null;

		this.set_events();
	}

	/**
  * shows dialog
  * 
  * @param {array} config
  */


	_createClass(Dialog_class, [{
		key: 'show',
		value: function show(config) {

			if (this.active == true) {
				this.hide();
			}

			this.title = config.title || '';
			this.parameters = config.params || [];
			this.onfinish = config.on_finish || false;
			this.preview = config.preview || false;
			this.onchange = config.on_change || false;
			this.onload = config.on_load || false;
			this.effects = config.effects || false;
			this.className = config.className || '';
			this.comment = config.comment || '';

			this.show_action();
		}

		/**
   * hides dialog
   */

	}, {
		key: 'hide',
		value: function hide() {
			document.getElementById("popup").style.display = 'none';
			this.parameters = [];
			this.active = false;
			this.preview = false;
			this.onload = false;
			this.onchange = false;
			this.effects = false;
			this.title = null;
			this.className = '';
			this.comment = '';
			this.onfinish = false;
		}

		/* ----------------- private functions ---------------------------------- */

	}, {
		key: 'set_events',
		value: function set_events() {
			var _this = this;

			document.addEventListener('keydown', function (event) {
				var code = event.keyCode;

				if (code == 27) {
					//escape
					_this.hide();
				}
			}, false);
		}
	}, {
		key: 'onChangeEvent',
		value: function onChangeEvent(e) {
			var params = this.get_params();

			var hash = JSON.stringify(params);
			if (this.last_params_hash == hash) {
				//nothing changed
				return;
			}
			this.last_params_hash = hash;

			if (this.onchange != false) {
				if (this.preview != false) {
					var canvas_right = document.getElementById("pop_post");
					var ctx_right = canvas_right.getContext("2d");

					ctx_right.clearRect(0, 0, this.width_mini, this.height_mini);
					ctx_right.drawImage(this.layer_active_small, 0, 0, this.width_mini, this.height_mini);

					this.onchange(params, ctx_right, this.width_mini, this.height_mini, canvas_right);
				} else {
					this.onchange(params);
				}
			}
		}

		//renders preview. If input=range supported, is called on every param update - must be fast...

	}, {
		key: 'preview_handler',
		value: function preview_handler(e) {
			if (this.preview !== false) {
				this.onChangeEvent(e);
			}
		}

		//OK pressed - prepare data and call handlers

	}, {
		key: 'save',
		value: function save() {
			var params = this.get_params();

			if (this.onfinish) {
				this.onfinish(params);
			}

			this.hide();
		}
	}, {
		key: 'get_params',
		value: function get_params() {
			var response = {};
			var inputs = document.getElementsByTagName('input');
			for (var i = 0; i < inputs.length; i++) {
				if (inputs[i].id.substr(0, 9) == 'pop_data_') {
					var key = inputs[i].id.substr(9);
					if (this.strpos(key, "_poptmp") != false) key = key.substring(0, this.strpos(key, "_poptmp"));
					var value = inputs[i].value;
					if (inputs[i].type == 'radio') {
						if (inputs[i].checked == true) response[key] = value;
					} else if (inputs[i].type == 'number') {
						response[key] = parseFloat(value);
					} else if (inputs[i].type == 'checkbox') {
						if (inputs[i].checked == true) response[key] = true;else response[key] = false;
					} else if (inputs[i].type == 'range') {
						response[key] = parseFloat(value);
					} else {
						response[key] = value;
					}
				}
			}
			var selects = document.getElementsByTagName('select');
			for (var i = 0; i < selects.length; i++) {
				if (selects[i].id.substr(0, 9) == 'pop_data_') {
					var key = selects[i].id.substr(9);
					var value = selects[i].value;
					response[key] = value;
				}
			}
			var textareas = document.getElementsByTagName('textarea');
			for (var i = 0; i < textareas.length; i++) {
				if (textareas[i].id.substr(0, 9) == 'pop_data_') {
					var key = textareas[i].id.substr(9);
					var value = textareas[i].value;
					response[key] = value;
				}
			}

			return response;
		}

		/**
   * show popup window.
   * used strings: "Ok", "Cancel", "Preview"
   */

	}, {
		key: 'show_action',
		value: function show_action() {
			this.id = this.getRandomInt(0, 999999999);
			if (this.active == true) {
				this.hide();
				return false;
			}
			this.active = true;

			//build content
			var html_pretitle_area = this.render_effect_browser();
			var html_preview_content = '';
			var html_params = '';

			//preview area
			if (this.preview !== false) {
				html_preview_content += '<div style="margin-top:10px;margin-bottom:15px;">';
				html_preview_content += '<canvas style="position:relative;float:left;margin:0 5px 5px 0;border:1px solid #393939;" width="' + this.width_mini + '" height="' + this.height_mini + '" id="pop_pre"></canvas>';
				html_preview_content += '<div id="canvas_preview_container">';
				html_preview_content += '	<canvas style="position:absolute;border:1px solid #393939;background-color:#ffffff;" width="' + this.width_mini + '" height="' + this.height_mini + '" id="pop_post_back"></canvas>';
				html_preview_content += '	<canvas style="position:relative;border:1px solid #393939;" width="' + this.width_mini + '" height="' + this.height_mini + '" id="pop_post"></canvas>';
				html_preview_content += '</div>';
				html_preview_content += '</div>';
			}

			//generate params
			html_params += this.generateParamsHtml();

			document.getElementById("popup").innerHTML = template;
			document.getElementById("pretitle_area").innerHTML = html_pretitle_area;
			document.getElementById("popup_title").innerHTML = this.title;
			document.getElementById("popup_comment").innerHTML = this.comment;
			document.getElementById("preview_content").innerHTML = html_preview_content;
			document.getElementById("params_content").innerHTML = html_params;
			if (this.onfinish != false) {
				document.getElementById("popup_cancel").style.display = '';
			} else {
				document.getElementById("popup_cancel").style.display = 'none';
			}

			document.getElementById("popup").style.display = "block";
			document.getElementById("popup").className = this.className;

			//events
			var _this = this;
			document.getElementById('popup_ok').addEventListener('click', function (event) {
				_this.save();
			});
			var targets = document.querySelectorAll('#popup input');
			for (var i = 0; i < targets.length; i++) {
				targets[i].addEventListener('keyup', function (event) {
					_this.onkeyup(event);
				});
			}
			if (this.onfinish != false) {
				document.getElementById('popup_cancel').addEventListener('click', function (event) {
					_this.hide();
				});
			}

			//onload
			if (this.onload) {
				var params = this.get_params();
				this.onload(params);
			}

			//some events for effects browser
			this.add_effects_browser_events();

			//load preview
			if (this.preview !== false) {
				//get canvas from layer
				var canvas = this.Base_layers.convert_layer_to_canvas();

				//draw original image
				var canvas_left = document.getElementById("pop_pre");
				var pop_pre = canvas_left.getContext("2d");
				pop_pre.clearRect(0, 0, this.width_mini, this.height_mini);
				pop_pre.rect(0, 0, this.width_mini, this.height_mini);
				pop_pre.fillStyle = "#ffffff";
				pop_pre.fill();
				this.draw_background(pop_pre, this.width_mini, this.height_mini, 10);

				pop_pre.scale(this.width_mini / canvas.width, this.height_mini / canvas.height);
				pop_pre.drawImage(canvas, 0, 0);
				pop_pre.scale(1, 1);

				//prepare temp canvas for faster repaint
				this.layer_active_small.width = POP.width_mini;
				this.layer_active_small.height = POP.height_mini;
				this.layer_active_small_ctx.scale(this.width_mini / canvas.width, this.height_mini / canvas.height);
				this.layer_active_small_ctx.drawImage(canvas, 0, 0);
				this.layer_active_small_ctx.scale(1, 1);

				//draw right backround
				var canvas_right_back = document.getElementById("pop_post_back").getContext("2d");
				this.draw_background(canvas_right_back, this.width_mini, this.height_mini, 10);

				//copy to right side
				var canvas_right = document.getElementById("pop_post").getContext("2d");
				canvas_right.clearRect(0, 0, this.width_mini, this.height_mini);
				canvas_right.drawImage(canvas_left, 0, 0, this.width_mini, this.height_mini);

				//prepare temp canvas
				this.preview_handler();
			}

			//call translation again to translate popup
			this.Help_translate.translate();
		}
	}, {
		key: 'generateParamsHtml',
		value: function generateParamsHtml() {
			var html = '<table style="width:99%;">';
			for (var i in this.parameters) {
				var parameter = this.parameters[i];

				html += '<tr id="popup-tr-' + this.parameters[i].name + '">';
				if (title != 'Error' && parameter.title != undefined) html += '<th class="trn">' + parameter.title + '</th>';
				if (parameter.name != undefined) {
					if (parameter.values != undefined) {
						if (parameter.values.length > 10 || parameter.type == 'select') {
							//drop down
							html += '<td colspan="2"><select onchange="POP.onChangeEvent();" style="font-size:12px;" id="pop_data_' + parameter.name + '">';
							var k = 0;
							for (var j in parameter.values) {
								var sel = '';
								if (parameter.value == parameter.values[j]) sel = 'selected="selected"';
								if (parameter.value == undefined && k == 0) sel = 'selected="selected"';
								html += '<option ' + sel + ' name="' + parameter.values[j] + '">' + parameter.values[j] + '</option>';
								k++;
							}
							html += '</select></td>';
						} else {
							//radio
							html += '<td colspan="2">';
							if (parameter.values.length > 2) html += '<div class="group">';
							var k = 0;
							for (var j in parameter.values) {
								var ch = '';
								if (parameter.value == parameter.values[j]) ch = 'checked="checked"';
								if (parameter.value == undefined && k == 0) ch = 'checked="checked"';

								var title = parameter.values[j];
								var parts = parameter.values[j].split(" - ");
								if (parts.length > 1) {
									title = parts[0] + ' - <span class="trn">' + parts[1] + '</span>';
								}

								html += '<input type="radio" onchange="POP.onChangeEvent();" ' + ch + ' name="' + parameter.name + '" id="pop_data_' + parameter.name + "_poptmp" + j + '" value="' + parameter.values[j] + '">';
								html += '<label style="margin-right:20px;" class="trn" for="pop_data_' + parameter.name + "_poptmp" + j + '">' + title + '</label>';
								if (parameter.values.length > 2) html += '<br />';
								k++;
							}
							if (parameter.values.length > 2) html += '</div>';
							html += '</td>';
						}
					} else if (parameter.value != undefined) {
						//input, range, textarea, color
						var step = 1;
						if (parameter.step != undefined) step = parameter.step;
						if (parameter.range != undefined) {
							//range
							html += '<td><input type="range" name="' + parameter.name + '" id="pop_data_' + parameter.name + '" value="' + parameter.value + '" min="' + parameter.range[0] + '" max="' + parameter.range[1] + '" step="' + step + '" oninput="document.getElementById(\'pv' + i + '\').innerHTML=Math.round(this.value*100)/100;POP.preview_handler();" onchange="POP.onChangeEvent();" /></td>';
							html += '<td style="padding-left:10px;width:50px;" id="pv' + i + '">' + parameter.value + '</td>';
						} else if (parameter.type == 'color') {
							//color
							html += '<td><input type="color" id="pop_data_' + parameter.name + '" value="' + parameter.value + '" onchange="POP.onChangeEvent();" /></td>';
						} else if (typeof parameter.value == 'boolean') {
							var checked = '';
							if (parameter.value === true) checked = 'checked';
							html += '<td class="checkbox"><input type="checkbox" id="pop_data_' + parameter.name + '" ' + checked + ' onclick="POP.onChangeEvent();" > <label class="trn" for="pop_data_' + parameter.name + '">Toggle</label></td>';
						} else {
							//input or textarea
							if (parameter.placeholder == undefined) parameter.placeholder = '';
							if (parameter.type == 'textarea') {
								html += '<td><textarea style="height:80px;" id="pop_data_' + parameter.name + '" placeholder="' + parameter.placeholder + '">' + parameter.value + '</textarea></td>';
							} else {
								var input_type = "text";
								if (parameter.placeholder != undefined && parameter.placeholder != '' && !isNaN(parameter.placeholder)) input_type = 'number';
								if (parameter.value != undefined && typeof parameter.value == 'number') input_type = 'number';

								html += '<td colspan="2"><input type="' + input_type + '" id="pop_data_' + parameter.name + '" value="' + parameter.value + '" placeholder="' + parameter.placeholder + '" /></td>';
							}
						}
					}
				} else if (parameter.function != undefined) {
					//custom function
					var result;
					result = parameter.function();
					html += '<td colspan="3">' + result + '</td>';
				} else if (parameter.html != undefined) {
					//html
					html += '<td style="padding-bottom:3px;padding-top:3px;" colspan="2">' + parameter.html + '</td>';
				} else if (parameter.title == undefined) {
					//gap
					html += '<td style="padding-bottom:3px;padding-top:3px;" colspan="2"></td>';
				} else {
					//locked fields without name
					var str = "" + parameter.value;
					var id_tmp = parameter.title.toLowerCase().replace(/[^\w]+/g, '').replace(/ +/g, '-');
					id_tmp = id_tmp.substring(0, 10);
					if (str.length < 40) html += '<td colspan="2"><div class="trn" id="pop_data_' + id_tmp + '" style="padding: 2px 0px;">' + parameter.value + '</div></td>';else html += '<td style="font-size:11px;" colspan="2"><textarea disabled="disabled">' + parameter.value + '</textarea></td>';
				}
				html += '</tr>';
			}
			html += '</table>';

			return html;
		}

		//validate input field, unless browser supports input=range

	}, {
		key: 'validate',
		value: function validate(field) {
			for (var i in this.parameters) {
				var parameter = this.parameters[i];
				if ("pop_data_" + parameter.name == field.id && parameter.range != undefined) {
					if (field.value == '-' || field.value == '') return true;

					var value = parseFloat(field.value);
					if (isNaN(value) || value != field.value) field.value = parameter.value; //not number
					if (value < parameter.range[0]) field.value = parameter.range[0]; //less then min
					else if (value > parameter.range[1]) field.value = parameter.range[1]; //more then max
				}
			}
		}

		//on key press inside input text

	}, {
		key: 'onkeyup',
		value: function onkeyup(event) {
			if (event.keyCode == "13") {
				//Enter was pressed
				this.save();
			}
		}
	}, {
		key: 'get_dimensions',
		value: function get_dimensions() {
			var theWidth, theHeight;
			if (window.innerWidth) {
				theWidth = window.innerWidth;
			} else if (document.documentElement && document.documentElement.clientWidth) {
				theWidth = document.documentElement.clientWidth;
			} else if (document.body) {
				theWidth = document.body.clientWidth;
			}
			if (window.innerHeight) {
				theHeight = window.innerHeight;
			} else if (document.documentElement && document.documentElement.clientHeight) {
				theHeight = document.documentElement.clientHeight;
			} else if (document.body) {
				theHeight = document.body.clientHeight;
			}
			return [theWidth, theHeight];
		}
	}, {
		key: 'getRandomInt',
		value: function getRandomInt(min, max) {
			return Math.floor(Math.random() * (max - min + 1)) + min;
		}
	}, {
		key: 'strpos',
		value: function strpos(haystack, needle, offset) {
			var i = (haystack + '').indexOf(needle, offset || 0);
			return i === -1 ? false : i;
		}
	}, {
		key: 'draw_background',
		value: function draw_background(canvas, W, H, gap, force) {
			if (_config2.default.TRANSPARENCY == false && force == undefined) {
				canvas.beginPath();
				canvas.rect(0, 0, W, H);
				canvas.fillStyle = "#ffffff";
				canvas.fill();
				return false;
			}
			if (gap == undefined) gap = 10;
			var fill = true;
			for (var i = 0; i < W; i = i + gap) {
				if (i % (gap * 2) == 0) fill = true;else fill = false;
				for (var j = 0; j < H; j = j + gap) {
					if (fill == true) {
						canvas.fillStyle = '#eeeeee';
						canvas.fillRect(i, j, gap, gap);
						fill = false;
					} else fill = true;
				}
			}
		}
	}, {
		key: 'ucfirst',
		value: function ucfirst(string) {
			return string.charAt(0).toUpperCase() + string.slice(1);
		}
	}, {
		key: 'get_effects_list',
		value: function get_effects_list() {
			var list = [];

			for (var i in this.Base_gui.modules) {
				if (i.indexOf("effects") == -1 || i.indexOf("abstract") > -1) continue;

				list[i] = this.Base_gui.modules[i];
			}

			return list;
		}
	}, {
		key: 'render_effect_browser',
		value: function render_effect_browser() {
			if (this.effects == false) return '';

			var html = '';
			var filters_config = this.get_effects_list();
			var breaking = false;
			this.ef_index = null;
			this.ef_next_index = null;
			this.ef_prev_index = null;
			for (var key in filters_config) {
				if (breaking == true) {
					this.ef_next_index = key;
					break;
				}
				var title = this.get_filter_title(key);
				if (title.toLowerCase() == this.title.toLowerCase()) {
					this.ef_index = key;
					breaking = true;
					continue;
				}
				this.ef_prev_index = key;
			}

			html += '<span style="float:right;">';
			html += '<input id="previous_filter" type="button" value="&lt;"> ';
			html += '<select id="effect_browser">';
			html += '<option class="trn" value="">--- Select effect ---</option>';
			for (var key in filters_config) {
				var title = this.get_filter_title(key);
				title = this.ucfirst(title);
				var selected = '';
				if (title.toLowerCase() == this.title.toLowerCase()) var selected = 'selected';
				html += ' <option ' + selected + ' value="' + key + '">' + title + '</option>';
			}
			html += '</select>';
			html += ' <input id="next_filter" onclick="" type="button" value="&gt;"> ';
			html += '</span>';

			return html;
		}
	}, {
		key: 'add_effects_browser_events',
		value: function add_effects_browser_events() {
			if (this.effects == false) return;

			var _this = this;
			var filters_config = this.get_effects_list();
			var prev_index = this.ef_prev_index;
			var next_index = this.ef_next_index;

			document.getElementById('previous_filter').disabled = false;
			document.getElementById('next_filter').disabled = false;
			if (prev_index == null) {
				document.getElementById('previous_filter').disabled = true;
			}
			if (next_index == null) {
				document.getElementById('next_filter').disabled = true;
			}
			//previous
			document.getElementById('previous_filter').addEventListener('click', function (event) {
				_this.hide();
				var function_name = prev_index.toLowerCase().replace(/ /g, '_').replace('effects/', '');
				filters_config[prev_index][function_name]();
			});
			//next
			document.getElementById('next_filter').addEventListener('click', function (event) {
				_this.hide();
				var function_name = next_index.toLowerCase().replace(/ /g, '_').replace('effects/', '');
				filters_config[next_index][function_name]();
			});
			//onchange
			var effect_browser = document.getElementById('effect_browser');
			effect_browser.addEventListener('change', function (event) {
				_this.hide();
				var value = effect_browser.options[effect_browser.selectedIndex].value;
				var function_name = value.toLowerCase().replace(/ /g, '_').replace('effects/', '');
				filters_config[value][function_name]();
			});
		}
	}, {
		key: 'get_filter_title',
		value: function get_filter_title(key) {
			var title = key.replace('effects/', '').replace(/_/g, ' ');

			//exceptions
			if (title == 'negative') title = 'invert';

			return title;
		}
	}]);

	return Dialog_class;
}();

exports.default = Dialog_class;

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * various helpers
 * 
 * @author ViliusL
 */
var Helper_class = function () {
	function Helper_class() {
		_classCallCheck(this, Helper_class);

		this.time = null;
	}

	_createClass(Helper_class, [{
		key: "get_url_parameters",
		value: function get_url_parameters() {
			var queryDict = {};
			location.search.substr(1).split("&").forEach(function (item) {
				queryDict[item.split("=")[0]] = item.split("=")[1];
			});

			return queryDict;
		}

		/**
   * starts timer
   */

	}, {
		key: "timer_start",
		value: function timer_start() {
			this.time = Date.now();
		}

		/**
   * calculates time betweeen two calls.
   * 
   * @param {string} name Optional
   * @param {boolean} echo Default is true.
   */

	}, {
		key: "timer_end",
		value: function timer_end(name, echo) {
			var text = Math.round(Date.now() - this.time) / 1000 + " s";
			if (echo != undefined && echo === false) return text;
			if (name != undefined) text += ' (' + name + ')';
			console.log(text);
		}

		//format time

	}, {
		key: "format_time",
		value: function format_time(datetime) {
			return new Date(datetime).toJSON().slice(0, 19).replace(/T/g, ' ');
		}

		/**
   * Find the position of the first occurrence of string or false.
   * 
   * @param {string} haystack
   * @param {string} needle
   * @param {int} offset
   * @returns {Boolean|String}
   */

	}, {
		key: "strpos",
		value: function strpos(haystack, needle, offset) {
			var i = (haystack + '').indexOf(needle, offset || 0);
			return i === -1 ? false : i;
		}

		/**
   * return cookie value from global cookie
   * 
   * @param {string} name
   * @returns {object|string}
   */

	}, {
		key: "getCookie",
		value: function getCookie(name) {
			var cookie = this._getCookie('config');
			if (cookie == '') cookie = {};else cookie = JSON.parse(cookie);

			if (cookie[name] != undefined) return cookie[name];else return null;
		}

		/**
   * sets cookie value to global cookie
   * 
   * @param {type} name
   * @param {type} value
   * @returns {undefined}
   */

	}, {
		key: "setCookie",
		value: function setCookie(name, value) {
			var cookie = this._getCookie('config');
			if (cookie == '') cookie = {};else cookie = JSON.parse(cookie);

			cookie[name] = value;
			var cookie = JSON.stringify(cookie);

			this._setCookie('config', cookie);
		}
	}, {
		key: "_getCookie",
		value: function _getCookie(NameOfCookie) {
			if (document.cookie.length > 0) {
				var begin = document.cookie.indexOf(NameOfCookie + "=");
				if (begin != -1) {
					begin += NameOfCookie.length + 1;
					var end = document.cookie.indexOf(";", begin);
					if (end == -1) end = document.cookie.length;
					return document.cookie.substring(begin, end);
				}
			}
			return '';
		}
	}, {
		key: "_setCookie",
		value: function _setCookie(NameOfCookie, value, expiredays) {
			if (expiredays == undefined) expiredays = 180;
			var ExpireDate = new Date();
			ExpireDate.setTime(ExpireDate.getTime() + expiredays * 24 * 3600 * 1000);
			document.cookie = NameOfCookie + "=" + value + (expiredays == null ? "" : "; expires=" + ExpireDate.toGMTString());
		}
	}, {
		key: "delCookie",
		value: function delCookie(NameOfCookie) {
			if (this.getCookie(NameOfCookie)) {
				document.cookie = NameOfCookie + "=" + "; expires=Thu, 01-Jan-70 00:00:01 GMT";
			}
		}
	}, {
		key: "getRandomInt",
		value: function getRandomInt(min, max) {
			return Math.floor(Math.random() * (max - min + 1)) + min;
		}
	}, {
		key: "font_pixel_to_height",
		value: function font_pixel_to_height(px) {
			return Math.round(px * 0.75);
		}
	}, {
		key: "rgbToHex",
		value: function rgbToHex(r, g, b) {
			if (r > 255 || g > 255 || b > 255) throw "Invalid color component";
			var tmp = (r << 16 | g << 8 | b).toString(16);

			return "#" + ("000000" + tmp).slice(-6);
		}
	}, {
		key: "rgb2hex_all",
		value: function rgb2hex_all(rgb) {
			rgb = rgb.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/);
			return "#" + this.hex(rgb[1]) + this.hex(rgb[2]) + this.hex(rgb[3]);
		}
	}, {
		key: "hex",
		value: function hex(x) {
			x = parseInt(x);
			return ("0" + x.toString(16)).slice(-2);
		}
	}, {
		key: "hex2rgb",
		value: function hex2rgb(hex) {
			if (hex[0] == "#") hex = hex.substr(1);
			if (hex.length == 3) {
				var temp = hex;
				hex = '';
				temp = /^([a-f0-9])([a-f0-9])([a-f0-9])$/i.exec(temp).slice(1);
				for (var i = 0; i < 3; i++) {
					hex += temp[i] + temp[i];
				}
			}
			var triplets = /^([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/i.exec(hex).slice(1);
			return {
				r: parseInt(triplets[0], 16),
				g: parseInt(triplets[1], 16),
				b: parseInt(triplets[2], 16),
				a: 255
			};
		}
	}, {
		key: "remove_selection",
		value: function remove_selection() {
			if (window.getSelection) {
				if (window.getSelection().empty) // Chrome
					window.getSelection().empty();else if (window.getSelection().removeAllRanges) // Firefox
					window.getSelection().removeAllRanges();
			} else if (document.selection) // IE?
				document.selection.empty();
		}

		//credits: richard maloney 2006

	}, {
		key: "darkenColor",
		value: function darkenColor(color, v) {
			if (color.length > 6) {
				color = color.substring(1, color.length);
			}
			var rgb = parseInt(color, 16);
			var r = Math.abs((rgb >> 16 & 0xFF) + v);
			if (r > 255) r = r - (r - 255);
			var g = Math.abs((rgb >> 8 & 0xFF) + v);
			if (g > 255) g = g - (g - 255);
			var b = Math.abs((rgb & 0xFF) + v);
			if (b > 255) b = b - (b - 255);
			r = Number(r < 0 || isNaN(r)) ? 0 : (r > 255 ? 255 : r).toString(16);
			if (r.length == 1) r = '0' + r;
			g = Number(g < 0 || isNaN(g)) ? 0 : (g > 255 ? 255 : g).toString(16);
			if (g.length == 1) g = '0' + g;
			b = Number(b < 0 || isNaN(b)) ? 0 : (b > 255 ? 255 : b).toString(16);
			if (b.length == 1) b = '0' + b;
			return "#" + r + g + b;
		}

		/**
   * JavaScript Number Formatter, author: KPL, KHL
   * 
   * @param {int} n
   * @param {int} decPlaces
   * @param {string} thouSeparator
   * @param {string} decSeparator
   * @returns {string}
   */

	}, {
		key: "number_format",
		value: function number_format(n, decPlaces, thouSeparator, decSeparator) {
			var decPlaces = isNaN(decPlaces = Math.abs(decPlaces)) ? 2 : decPlaces;
			var decSeparator = decSeparator == undefined ? "." : decSeparator;
			var thouSeparator = thouSeparator == undefined ? "," : thouSeparator;
			var sign = n < 0 ? "-" : "";
			var i = parseInt(n = Math.abs(+n || 0).toFixed(decPlaces)) + "";
			var j = (j = i.length) > 3 ? j % 3 : 0;
			return sign + (j ? i.substr(0, j) + thouSeparator : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thouSeparator) + (decPlaces ? decSeparator + Math.abs(n - i).toFixed(decPlaces).slice(2) : "");
		}
	}, {
		key: "chech_input_color_support",
		value: function chech_input_color_support() {
			var i = document.createElement("input");
			i.setAttribute("type", "color");
			return i.type !== "text";
		}
	}, {
		key: "b64toBlob",
		value: function b64toBlob(b64Data, contentType, sliceSize) {
			contentType = contentType || '';
			sliceSize = sliceSize || 512;

			var byteCharacters = atob(b64Data);
			var byteArrays = [];

			for (var offset = 0; offset < byteCharacters.length; offset += sliceSize) {
				var slice = byteCharacters.slice(offset, offset + sliceSize);

				var byteNumbers = new Array(slice.length);
				for (var i = 0; i < slice.length; i++) {
					byteNumbers[i] = slice.charCodeAt(i);
				}

				var byteArray = new Uint8Array(byteNumbers);

				byteArrays.push(byteArray);
			}

			var blob = new Blob(byteArrays, { type: contentType });
			return blob;
		}
	}, {
		key: "escapeHtml",
		value: function escapeHtml(text) {
			return text.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;").replace(/'/g, "&#039;");
		}
	}, {
		key: "isNumeric",
		value: function isNumeric(n) {
			return !isNaN(parseFloat(n)) && isFinite(n);
		}

		/**
   * Converts an HSL color value to RGB. Conversion formula
   * adapted from http://en.wikipedia.org/wiki/HSL_color_space.
   * Assumes h, s, and l are contained in the set [0, 1] and
   * returns r, g, and b in the set [0, 255].
   *
   * @param {number} h The hue
   * @param {number} s The saturation
   * @param {number} l The lightness
   * @return {Array} The RGB representation
   */

	}, {
		key: "hslToRgb",
		value: function hslToRgb(h, s, l) {
			var r, g, b;

			if (s == 0) {
				r = g = b = l; // achromatic
			} else {
				var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
				var p = 2 * l - q;
				r = this.hue2rgb(p, q, h + 1 / 3);
				g = this.hue2rgb(p, q, h);
				b = this.hue2rgb(p, q, h - 1 / 3);
			}

			return [Math.round(r * 255), Math.round(g * 255), Math.round(b * 255)];
		}
	}, {
		key: "hue2rgb",
		value: function hue2rgb(p, q, t) {
			if (t < 0) t += 1;
			if (t > 1) t -= 1;
			if (t < 1 / 6) return p + (q - p) * 6 * t;
			if (t < 1 / 2) return q;
			if (t < 2 / 3) return p + (q - p) * (2 / 3 - t) * 6;
			return p;
		}

		/**
   * Converts an RGB color value to HSL. Conversion formula
   * adapted from http://en.wikipedia.org/wiki/HSL_color_space.
   * Assumes r, g, and b are contained in the set [0, 255] and
   * returns h, s, and l.
   * 
   * @param {number} r red color value
   * @param {number} g green color value
   * @param {number} b blue color value
   * @return {object} The HSL representation
   */

	}, {
		key: "rgbToHsl",
		value: function rgbToHsl(r, g, b) {
			r /= 255;
			g /= 255;
			b /= 255;
			var max = Math.max(r, g, b),
			    min = Math.min(r, g, b);
			var h,
			    s,
			    l = (max + min) / 2;

			if (max == min) {
				h = s = 0; // achromatic
			} else {
				var d = max - min;
				s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
				switch (max) {
					case r:
						h = (g - b) / d + (g < b ? 6 : 0);
						break;
					case g:
						h = (b - r) / d + 2;
						break;
					case b:
						h = (r - g) / d + 4;
						break;
				}
				h /= 6;
			}

			return {
				h: Math.round(h * 255),
				s: Math.round(s * 255),
				l: Math.round(l * 255)
			};
		}
	}, {
		key: "ucfirst",
		value: function ucfirst(string) {
			return string.charAt(0).toUpperCase() + string.slice(1);
		}

		/**
   * change canvas size without loosing data
   * 
   * @param {canvas} canvas
   * @param {int} width
   * @param {int} height
   * @param {int} offset_x
   * @param {int} offset_y
   */

	}, {
		key: "change_canvas_size",
		value: function change_canvas_size(canvas, width, height, offset_x, offset_y) {
			if (offset_x == undefined) offset_x = 0;
			if (offset_y == undefined) offset_y = 0;

			//copy data;
			var tmp = document.createElement('canvas');
			var ctx = tmp.getContext("2d");
			tmp.width = canvas.width;
			tmp.height = canvas.height;
			ctx.drawImage(canvas, 0, 0);

			canvas.width = Math.max(1, width);
			canvas.height = Math.max(1, height);

			//restore image
			canvas.getContext("2d").drawImage(tmp, -offset_x, -offset_y);
		}
	}, {
		key: "image_round",
		value: function image_round(ctx_main, mouse_x, mouse_y, size_w, size_h, img_data) {
			var anti_aliasing = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : false;

			//create tmp canvas
			var canvasTmp = document.createElement('canvas');
			canvasTmp.width = size_w;
			canvasTmp.height = size_h;

			var size_half_w = Math.round(size_w / 2);
			var size_half_h = Math.round(size_h / 2);
			var ctx = canvasTmp.getContext("2d");
			var width = canvasTmp.width;
			var height = canvasTmp.height;
			var xx = mouse_x - size_half_w;
			var yy = mouse_y - size_half_h;

			ctx.clearRect(0, 0, width, height);
			ctx.save();
			//draw main data
			ctx.putImageData(img_data, 0, 0);
			ctx.globalCompositeOperation = 'destination-in';

			//create form
			var gradient = ctx.createRadialGradient(size_half_w, size_half_h, 0, size_half_w, size_half_h, size_half_w);
			gradient.addColorStop(0, '#ffffff');
			if (anti_aliasing == true) gradient.addColorStop(0.8, '#ffffff');else gradient.addColorStop(0.99, '#ffffff');
			gradient.addColorStop(1, 'rgba(255,255,255,0');
			ctx.fillStyle = gradient;

			ctx.beginPath();
			ctx.ellipse(size_half_w, size_half_h, size_w * 2, size_h * 2, 0, 0, 2 * Math.PI);
			ctx.fill();
			ctx_main.drawImage(canvasTmp, 0, 0, size_w, size_h, xx, yy, size_w, size_h);
			//reset
			ctx.restore();
			ctx.clearRect(0, 0, width, height);
		}

		//if IE 11 or Edge

	}, {
		key: "is_edge_or_ie",
		value: function is_edge_or_ie() {
			//ie11
			if (!window.ActiveXObject && "ActiveXObject" in window) return true;
			//edge
			if (navigator.userAgent.indexOf('Edge/') != -1) return true;
			return false;
		}
	}]);

	return Helper_class;
}();

exports.default = Helper_class;

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * miniPaint - https://github.com/viliusle/miniPaint
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * author: Vilius L.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Base tools class, can be used for extending on tools like brush, provides various helping methods.
 */
var Base_tools_class = function () {
	function Base_tools_class(save_mouse) {
		_classCallCheck(this, Base_tools_class);

		this.Base_layers = new _baseLayers2.default();
		this.is_drag = false;
		this.mouse_click_pos = [false, false];
		this.mouse_move_last = [false, false];
		this.canvas_offset = { x: null, y: null };
		this.mouse_valid = false;
		this.mouse_click_valid = false;
		this.speed_average = 0;
		this.save_mouse = save_mouse;

		this.prepare();

		if (this.save_mouse == true) {
			this.events();
		}
	}

	_createClass(Base_tools_class, [{
		key: 'events',
		value: function events() {
			var _this = this;

			//collect mouse info
			document.addEventListener('mousedown', function (event) {
				_this.set_mouse_info(event);

				_this.is_drag = true;
				_this.speed_average = 0;
				var mouse = _this.get_mouse_info(event, true);
				_this.mouse_click_pos[0] = mouse.x;
				_this.mouse_click_pos[1] = mouse.y;
			});
			document.addEventListener('mousemove', function (event) {
				_this.set_mouse_info(event);

				_this.speed_average = _this.calc_average_mouse_speed(event);
			});
			document.addEventListener('mouseup', function (event) {
				_this.is_drag = false;
				_this.set_mouse_info(event);
			});
		}

		/**
   * do preparation
   */

	}, {
		key: 'prepare',
		value: function prepare() {
			//calc canvas position offset
			var bodyRect = document.body.getBoundingClientRect();
			var canvas_el = document.getElementById('canvas_minipaint').getBoundingClientRect();
			this.canvas_offset.x = canvas_el.left - bodyRect.left;
			this.canvas_offset.y = canvas_el.top - bodyRect.top;

			this.is_drag = _config2.default.mouse.is_drag;
		}
	}, {
		key: 'set_mouse_info',
		value: function set_mouse_info(event) {
			if (this.save_mouse !== true) {
				//not maint
				return false;
			}
			if (event != undefined && event.changedTouches) {
				//using touch events
				event = event.changedTouches[0];
			}

			var mouse_x = event.pageX - this.canvas_offset.x;
			var mouse_y = event.pageY - this.canvas_offset.y;

			if (event.target.id != "canvas_minipaint") {
				//outside canvas
				this.mouse_valid = false;
			} else {
				this.mouse_valid = true;
			}

			if (event.type == 'mousedown') {
				if (event.target.id != "canvas_minipaint" || event.which != 1) this.mouse_click_valid = false;else this.mouse_click_valid = true;
				this.mouse_valid = true;
			}

			//adapt coords to ZOOM
			var global_pos = this.Base_layers.get_world_coords(mouse_x, mouse_y);
			mouse_x = global_pos.x;
			mouse_y = global_pos.y;

			var start_pos = this.Base_layers.get_world_coords(0, 0);
			var x_rel = mouse_x - start_pos.x;
			var y_rel = mouse_y - start_pos.y;

			//save
			_config2.default.mouse = {
				x: mouse_x,
				y: mouse_y,
				x_rel: x_rel,
				y_rel: y_rel,
				click_x: this.mouse_click_pos[0],
				click_y: this.mouse_click_pos[1],
				last_x: this.mouse_move_last[0],
				last_y: this.mouse_move_last[1],
				valid: this.mouse_valid,
				click_valid: this.mouse_click_valid,
				is_drag: this.is_drag,
				speed_average: this.speed_average
			};

			if (event.type == 'mousemove') {
				//save last pos
				this.mouse_move_last[0] = mouse_x;
				this.mouse_move_last[1] = mouse_y;
			}
		}
	}, {
		key: 'get_mouse_info',
		value: function get_mouse_info() {
			return _config2.default.mouse;
		}
	}, {
		key: 'calc_average_mouse_speed',
		value: function calc_average_mouse_speed(event) {
			if (this.is_drag == false) return null;

			//calc average speed
			var avg_speed_max = 30;
			var avg_speed_changing_power = 2;
			var mouse = this.get_mouse_info(event, true);

			var dx = Math.abs(mouse.x - mouse.last_x);
			var dy = Math.abs(mouse.y - mouse.last_y);
			var delta = Math.sqrt(dx * dx + dy * dy);
			var mouse_average_speed = this.speed_average;
			if (delta > avg_speed_max / 2) {
				mouse_average_speed += avg_speed_changing_power;
			} else {
				mouse_average_speed -= avg_speed_changing_power;
			}
			mouse_average_speed = Math.max(0, mouse_average_speed); //min
			mouse_average_speed = Math.min(avg_speed_max, mouse_average_speed); //max

			return mouse_average_speed;
		}
	}, {
		key: 'get_params_hash',
		value: function get_params_hash() {
			var data = [this.getParams(), _config2.default.COLOR, _config2.default.ALPHA];
			return JSON.stringify(data);
		}
	}, {
		key: 'clone',
		value: function clone(object) {
			return JSON.parse(JSON.stringify(object));
		}

		/**
   * customized mouse cursor
   * 
   * @param {int} x
   * @param {int} y
   * @param {int} size
   * @param {string} type cicle, rect
   */

	}, {
		key: 'show_mouse_cursor',
		value: function show_mouse_cursor(x, y, size, type) {

			//fix coods, because of scroll
			var start_pos = this.Base_layers.get_world_coords(0, 0);
			x = x - start_pos.x;
			y = y - start_pos.y;

			var element = document.getElementById('mouse');
			size = size * _config2.default.ZOOM;
			x = x * _config2.default.ZOOM;
			y = y * _config2.default.ZOOM;

			if (size < 5) {
				//too small
				element.className = '';
				return;
			}

			element.style.width = size + 'px';
			element.style.height = size + 'px';

			element.style.left = x - Math.ceil(size / 2) + 'px';
			element.style.top = y - Math.ceil(size / 2) + 'px';

			//add style
			element.className = '';
			element.classList.add(type);
		}
	}, {
		key: 'getParams',
		value: function getParams() {
			return _config2.default.TOOL.attributes;
		}
	}, {
		key: 'adaptSize',
		value: function adaptSize(value) {
			var type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "width";

			var response;
			if (_config2.default.layer.width_original == null) {
				return value;
			}

			if (type === "width") {
				response = value / (_config2.default.layer.width / _config2.default.layer.width_original);
			} else {
				response = value / (_config2.default.layer.height / _config2.default.layer.height_original);
			}

			return response;
		}
	}]);

	return Base_tools_class;
}();

exports.default = Base_tools_class;

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});
//about - A Javascript Image filter library for the HTML5 Canvas tag. 
//author - https://github.com/arahaya/ImageFilters.js
//demo - http://www.arahaya.com/imagefilters/

var ImageFilters = {};
ImageFilters.utils = {
	initSampleCanvas: function initSampleCanvas() {
		var _canvas = document.createElement('canvas'),
		    _context = _canvas.getContext('2d');

		_canvas.width = 0;
		_canvas.height = 0;

		this.getSampleCanvas = function () {
			return _canvas;
		};
		this.getSampleContext = function () {
			return _context;
		};
		this.createImageData = _context.createImageData ? function (w, h) {
			return _context.createImageData(w, h);
		} : function (w, h) {
			return new ImageData(w, h);
		};
	},
	getSampleCanvas: function getSampleCanvas() {
		this.initSampleCanvas();
		return this.getSampleCanvas();
	},
	getSampleContext: function getSampleContext() {
		this.initSampleCanvas();
		return this.getSampleContext();
	},
	createImageData: function createImageData(w, h) {
		this.initSampleCanvas();
		return this.createImageData(w, h);
	},
	clamp: function clamp(value) {
		return value > 255 ? 255 : value < 0 ? 0 : value;
	},
	buildMap: function buildMap(f) {
		for (var m = [], k = 0, v; k < 256; k += 1) {
			m[k] = (v = f(k)) > 255 ? 255 : v < 0 ? 0 : v | 0;
		}
		return m;
	},
	applyMap: function applyMap(src, dst, map) {
		for (var i = 0, l = src.length; i < l; i += 4) {
			dst[i] = map[src[i]];
			dst[i + 1] = map[src[i + 1]];
			dst[i + 2] = map[src[i + 2]];
			dst[i + 3] = src[i + 3];
		}
	},
	mapRGB: function mapRGB(src, dst, func) {
		this.applyMap(src, dst, this.buildMap(func));
	},
	getPixelIndex: function getPixelIndex(x, y, width, height, edge) {
		if (x < 0 || x >= width || y < 0 || y >= height) {
			switch (edge) {
				case 1:
					// clamp
					x = x < 0 ? 0 : x >= width ? width - 1 : x;
					y = y < 0 ? 0 : y >= height ? height - 1 : y;
					break;
				case 2:
					// wrap
					x = (x %= width) < 0 ? x + width : x;
					y = (y %= height) < 0 ? y + height : y;
					break;
				default:
					// transparent
					return null;
			}
		}
		return y * width + x << 2;
	},
	getPixel: function getPixel(src, x, y, width, height, edge) {
		if (x < 0 || x >= width || y < 0 || y >= height) {
			switch (edge) {
				case 1:
					// clamp
					x = x < 0 ? 0 : x >= width ? width - 1 : x;
					y = y < 0 ? 0 : y >= height ? height - 1 : y;
					break;
				case 2:
					// wrap
					x = (x %= width) < 0 ? x + width : x;
					y = (y %= height) < 0 ? y + height : y;
					break;
				default:
					// transparent
					return 0;
			}
		}

		var i = y * width + x << 2;

		// ARGB
		return src[i + 3] << 24 | src[i] << 16 | src[i + 1] << 8 | src[i + 2];
	},
	getPixelByIndex: function getPixelByIndex(src, i) {
		return src[i + 3] << 24 | src[i] << 16 | src[i + 1] << 8 | src[i + 2];
	},
	/**
  * one of the most important functions in this library.
  * I want to make this as fast as possible.
  */
	copyBilinear: function copyBilinear(src, x, y, width, height, dst, dstIndex, edge) {
		var fx = x < 0 ? x - 1 | 0 : x | 0,
		    // Math.floor(x)
		fy = y < 0 ? y - 1 | 0 : y | 0,
		    // Math.floor(y)
		wx = x - fx,
		    wy = y - fy,
		    i,
		    nw = 0,
		    ne = 0,
		    sw = 0,
		    se = 0,
		    cx,
		    cy,
		    r,
		    g,
		    b,
		    a;

		if (fx >= 0 && fx < width - 1 && fy >= 0 && fy < height - 1) {
			// in bounds, no edge actions required
			i = fy * width + fx << 2;

			if (wx || wy) {
				nw = src[i + 3] << 24 | src[i] << 16 | src[i + 1] << 8 | src[i + 2];

				i += 4;
				ne = src[i + 3] << 24 | src[i] << 16 | src[i + 1] << 8 | src[i + 2];

				i = i - 8 + (width << 2);
				sw = src[i + 3] << 24 | src[i] << 16 | src[i + 1] << 8 | src[i + 2];

				i += 4;
				se = src[i + 3] << 24 | src[i] << 16 | src[i + 1] << 8 | src[i + 2];
			} else {
				// no interpolation required
				dst[dstIndex] = src[i];
				dst[dstIndex + 1] = src[i + 1];
				dst[dstIndex + 2] = src[i + 2];
				dst[dstIndex + 3] = src[i + 3];
				return;
			}
		} else {
			// edge actions required
			nw = this.getPixel(src, fx, fy, width, height, edge);

			if (wx || wy) {
				ne = this.getPixel(src, fx + 1, fy, width, height, edge);
				sw = this.getPixel(src, fx, fy + 1, width, height, edge);
				se = this.getPixel(src, fx + 1, fy + 1, width, height, edge);
			} else {
				// no interpolation required
				dst[dstIndex] = nw >> 16 & 0xFF;
				dst[dstIndex + 1] = nw >> 8 & 0xFF;
				dst[dstIndex + 2] = nw & 0xFF;
				dst[dstIndex + 3] = nw >> 24 & 0xFF;
				return;
			}
		}

		cx = 1 - wx;
		cy = 1 - wy;
		r = ((nw >> 16 & 0xFF) * cx + (ne >> 16 & 0xFF) * wx) * cy + ((sw >> 16 & 0xFF) * cx + (se >> 16 & 0xFF) * wx) * wy;
		g = ((nw >> 8 & 0xFF) * cx + (ne >> 8 & 0xFF) * wx) * cy + ((sw >> 8 & 0xFF) * cx + (se >> 8 & 0xFF) * wx) * wy;
		b = ((nw & 0xFF) * cx + (ne & 0xFF) * wx) * cy + ((sw & 0xFF) * cx + (se & 0xFF) * wx) * wy;
		a = ((nw >> 24 & 0xFF) * cx + (ne >> 24 & 0xFF) * wx) * cy + ((sw >> 24 & 0xFF) * cx + (se >> 24 & 0xFF) * wx) * wy;

		dst[dstIndex] = r > 255 ? 255 : r < 0 ? 0 : r | 0;
		dst[dstIndex + 1] = g > 255 ? 255 : g < 0 ? 0 : g | 0;
		dst[dstIndex + 2] = b > 255 ? 255 : b < 0 ? 0 : b | 0;
		dst[dstIndex + 3] = a > 255 ? 255 : a < 0 ? 0 : a | 0;
	},
	/**
  * @param r 0 <= n <= 255
  * @param g 0 <= n <= 255
  * @param b 0 <= n <= 255
  * @return Array(h, s, l)
  */
	rgbToHsl: function rgbToHsl(r, g, b) {
		r /= 255;
		g /= 255;
		b /= 255;

		//        var max = Math.max(r, g, b),
		//            min = Math.min(r, g, b),
		var max = r > g ? r > b ? r : b : g > b ? g : b,
		    min = r < g ? r < b ? r : b : g < b ? g : b,
		    chroma = max - min,
		    h = 0,
		    s = 0,

		// Lightness
		l = (min + max) / 2;

		if (chroma !== 0) {
			// Hue
			if (r === max) {
				h = (g - b) / chroma + (g < b ? 6 : 0);
			} else if (g === max) {
				h = (b - r) / chroma + 2;
			} else {
				h = (r - g) / chroma + 4;
			}
			h /= 6;

			// Saturation
			s = l > 0.5 ? chroma / (2 - max - min) : chroma / (max + min);
		}

		return [h, s, l];
	},
	/**
  * @param h 0.0 <= n <= 1.0
  * @param s 0.0 <= n <= 1.0
  * @param l 0.0 <= n <= 1.0
  * @return Array(r, g, b)
  */
	hslToRgb: function hslToRgb(h, s, l) {
		var m1,
		    m2,
		    hue,
		    r,
		    g,
		    b,
		    rgb = [];

		if (s === 0) {
			r = g = b = l * 255 + 0.5 | 0;
			rgb = [r, g, b];
		} else {
			if (l <= 0.5) {
				m2 = l * (s + 1);
			} else {
				m2 = l + s - l * s;
			}

			m1 = l * 2 - m2;
			hue = h + 1 / 3;

			var tmp;
			for (var i = 0; i < 3; i += 1) {
				if (hue < 0) {
					hue += 1;
				} else if (hue > 1) {
					hue -= 1;
				}

				if (6 * hue < 1) {
					tmp = m1 + (m2 - m1) * hue * 6;
				} else if (2 * hue < 1) {
					tmp = m2;
				} else if (3 * hue < 2) {
					tmp = m1 + (m2 - m1) * (2 / 3 - hue) * 6;
				} else {
					tmp = m1;
				}

				rgb[i] = tmp * 255 + 0.5 | 0;

				hue -= 1 / 3;
			}
		}

		return rgb;
	}
};

ImageFilters.Translate = function (srcImageData, x, y, interpolation) {};
ImageFilters.Scale = function (srcImageData, scaleX, scaleY, interpolation) {};
ImageFilters.Rotate = function (srcImageData, originX, originY, angle, resize, interpolation) {};
ImageFilters.Affine = function (srcImageData, matrix, resize, interpolation) {};
ImageFilters.UnsharpMask = function (srcImageData, level) {};

ImageFilters.ConvolutionFilter = function (srcImageData, matrixX, matrixY, matrix, divisor, bias, preserveAlpha, clamp, color, alpha) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	divisor = divisor || 1;
	bias = bias || 0;

	// default true
	preserveAlpha !== false && (preserveAlpha = true);
	clamp !== false && (clamp = true);

	color = color || 0;
	alpha = alpha || 0;

	var index = 0,
	    rows = matrixX >> 1,
	    cols = matrixY >> 1,
	    clampR = color >> 16 & 0xFF,
	    clampG = color >> 8 & 0xFF,
	    clampB = color & 0xFF,
	    clampA = alpha * 0xFF;

	for (var y = 0; y < srcHeight; y += 1) {
		for (var x = 0; x < srcWidth; x += 1, index += 4) {
			var r = 0,
			    g = 0,
			    b = 0,
			    a = 0,
			    replace = false,
			    mIndex = 0,
			    v;

			for (var row = -rows; row <= rows; row += 1) {
				var rowIndex = y + row,
				    offset;

				if (0 <= rowIndex && rowIndex < srcHeight) {
					offset = rowIndex * srcWidth;
				} else if (clamp) {
					offset = y * srcWidth;
				} else {
					replace = true;
				}

				for (var col = -cols; col <= cols; col += 1) {
					var m = matrix[mIndex++];

					if (m !== 0) {
						var colIndex = x + col;

						if (!(0 <= colIndex && colIndex < srcWidth)) {
							if (clamp) {
								colIndex = x;
							} else {
								replace = true;
							}
						}

						if (replace) {
							r += m * clampR;
							g += m * clampG;
							b += m * clampB;
							a += m * clampA;
						} else {
							var p = offset + colIndex << 2;
							r += m * srcPixels[p];
							g += m * srcPixels[p + 1];
							b += m * srcPixels[p + 2];
							a += m * srcPixels[p + 3];
						}
					}
				}
			}

			dstPixels[index] = (v = r / divisor + bias) > 255 ? 255 : v < 0 ? 0 : v | 0;
			dstPixels[index + 1] = (v = g / divisor + bias) > 255 ? 255 : v < 0 ? 0 : v | 0;
			dstPixels[index + 2] = (v = b / divisor + bias) > 255 ? 255 : v < 0 ? 0 : v | 0;
			dstPixels[index + 3] = preserveAlpha ? srcPixels[index + 3] : (v = a / divisor + bias) > 255 ? 255 : v < 0 ? 0 : v | 0;
		}
	}

	return dstImageData;
};

/**
 * @param threshold 0.0 <= n <= 1.0
 */
ImageFilters.Binarize = function (srcImageData, threshold) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	if (isNaN(threshold)) {
		threshold = 0.5;
	}

	threshold *= 255;

	for (var i = 0; i < srcLength; i += 4) {
		var avg = srcPixels[i] + srcPixels[i + 1] + srcPixels[i + 2] / 3;

		dstPixels[i] = dstPixels[i + 1] = dstPixels[i + 2] = avg <= threshold ? 0 : 255;
		dstPixels[i + 3] = 255;
	}

	return dstImageData;
};

ImageFilters.BlendAdd = function (srcImageData, blendImageData, dx, dy) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data,
	    blendPixels = blendImageData.data;

	var v;

	for (var i = 0; i < srcLength; i += 4) {
		dstPixels[i] = (v = srcPixels[i] + blendPixels[i]) > 255 ? 255 : v;
		dstPixels[i + 1] = (v = srcPixels[i + 1] + blendPixels[i + 1]) > 255 ? 255 : v;
		dstPixels[i + 2] = (v = srcPixels[i + 2] + blendPixels[i + 2]) > 255 ? 255 : v;
		dstPixels[i + 3] = 255;
	}

	return dstImageData;
};

ImageFilters.BlendSubtract = function (srcImageData, blendImageData, dx, dy) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data,
	    blendPixels = blendImageData.data;

	var v;

	for (var i = 0; i < srcLength; i += 4) {
		dstPixels[i] = (v = srcPixels[i] - blendPixels[i]) < 0 ? 0 : v;
		dstPixels[i + 1] = (v = srcPixels[i + 1] - blendPixels[i + 1]) < 0 ? 0 : v;
		dstPixels[i + 2] = (v = srcPixels[i + 2] - blendPixels[i + 2]) < 0 ? 0 : v;
		dstPixels[i + 3] = 255;
	}

	return dstImageData;
};

/**
 * Algorithm based on BoxBlurFilter.java by Huxtable.com
 * @see http://www.jhlabs.com/ip/blurring.html
 * Copyright 2005 Huxtable.com. All rights reserved.
 */
ImageFilters.BoxBlur = function () {
	var blur = function blur(src, dst, width, height, radius) {
		var tableSize = radius * 2 + 1;
		var radiusPlus1 = radius + 1;
		var widthMinus1 = width - 1;

		var r, g, b, a;

		var srcIndex = 0;
		var dstIndex;
		var p, next, prev;
		var i, l, x, y, nextIndex, prevIndex;

		var sumTable = [];
		for (i = 0, l = 256 * tableSize; i < l; i += 1) {
			sumTable[i] = i / tableSize | 0;
		}

		for (y = 0; y < height; y += 1) {
			r = g = b = a = 0;
			dstIndex = y;

			p = srcIndex << 2;
			r += radiusPlus1 * src[p];
			g += radiusPlus1 * src[p + 1];
			b += radiusPlus1 * src[p + 2];
			a += radiusPlus1 * src[p + 3];

			for (i = 1; i <= radius; i += 1) {
				p = srcIndex + (i < width ? i : widthMinus1) << 2;
				r += src[p];
				g += src[p + 1];
				b += src[p + 2];
				a += src[p + 3];
			}

			for (x = 0; x < width; x += 1) {
				p = dstIndex << 2;
				dst[p] = sumTable[r];
				dst[p + 1] = sumTable[g];
				dst[p + 2] = sumTable[b];
				dst[p + 3] = sumTable[a];

				nextIndex = x + radiusPlus1;
				if (nextIndex > widthMinus1) {
					nextIndex = widthMinus1;
				}

				prevIndex = x - radius;
				if (prevIndex < 0) {
					prevIndex = 0;
				}

				next = srcIndex + nextIndex << 2;
				prev = srcIndex + prevIndex << 2;

				r += src[next] - src[prev];
				g += src[next + 1] - src[prev + 1];
				b += src[next + 2] - src[prev + 2];
				a += src[next + 3] - src[prev + 3];

				dstIndex += height;
			}
			srcIndex += width;
		}
	};

	return function (srcImageData, hRadius, vRadius, quality) {
		var srcPixels = srcImageData.data,
		    srcWidth = srcImageData.width,
		    srcHeight = srcImageData.height,
		    srcLength = srcPixels.length,
		    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
		    dstPixels = dstImageData.data,
		    tmpImageData = this.utils.createImageData(srcWidth, srcHeight),
		    tmpPixels = tmpImageData.data;

		for (var i = 0; i < quality; i += 1) {
			// only use the srcPixels on the first loop
			blur(i ? dstPixels : srcPixels, tmpPixels, srcWidth, srcHeight, hRadius);
			blur(tmpPixels, dstPixels, srcHeight, srcWidth, vRadius);
		}

		return dstImageData;
	};
}();

/**
 * @ param strength 1 <= n <= 4
 */
ImageFilters.GaussianBlur = function (srcImageData, strength) {
	var size, matrix, divisor;

	switch (strength) {
		case 2:
			size = 5;
			matrix = [1, 1, 2, 1, 1, 1, 2, 4, 2, 1, 2, 4, 8, 4, 2, 1, 2, 4, 2, 1, 1, 1, 2, 1, 1];
			divisor = 52;
			break;
		case 3:
			size = 7;
			matrix = [1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 4, 2, 2, 1, 2, 2, 4, 8, 4, 2, 2, 2, 4, 8, 16, 8, 4, 2, 2, 2, 4, 8, 4, 2, 2, 1, 2, 2, 4, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1];
			divisor = 140;
			break;
		case 4:
			size = 15;
			matrix = [2, 2, 3, 4, 5, 5, 6, 6, 6, 5, 5, 4, 3, 2, 2, 2, 3, 4, 5, 7, 7, 8, 8, 8, 7, 7, 5, 4, 3, 2, 3, 4, 6, 7, 9, 10, 10, 11, 10, 10, 9, 7, 6, 4, 3, 4, 5, 7, 9, 10, 12, 13, 13, 13, 12, 10, 9, 7, 5, 4, 5, 7, 9, 11, 13, 14, 15, 16, 15, 14, 13, 11, 9, 7, 5, 5, 7, 10, 12, 14, 16, 17, 18, 17, 16, 14, 12, 10, 7, 5, 6, 8, 10, 13, 15, 17, 19, 19, 19, 17, 15, 13, 10, 8, 6, 6, 8, 11, 13, 16, 18, 19, 20, 19, 18, 16, 13, 11, 8, 6, 6, 8, 10, 13, 15, 17, 19, 19, 19, 17, 15, 13, 10, 8, 6, 5, 7, 10, 12, 14, 16, 17, 18, 17, 16, 14, 12, 10, 7, 5, 5, 7, 9, 11, 13, 14, 15, 16, 15, 14, 13, 11, 9, 7, 5, 4, 5, 7, 9, 10, 12, 13, 13, 13, 12, 10, 9, 7, 5, 4, 3, 4, 6, 7, 9, 10, 10, 11, 10, 10, 9, 7, 6, 4, 3, 2, 3, 4, 5, 7, 7, 8, 8, 8, 7, 7, 5, 4, 3, 2, 2, 2, 3, 4, 5, 5, 6, 6, 6, 5, 5, 4, 3, 2, 2];
			divisor = 2044;
			break;
		default:
			size = 3;
			matrix = [1, 2, 1, 2, 4, 2, 1, 2, 1];
			divisor = 16;
			break;
	}
	return this.ConvolutionFilter(srcImageData, size, size, matrix, divisor, 0, false);
};

/**
 * Stack Blur Algorithm by Mario Klingemann <mario@quasimondo.com>
 * @see http://incubator.quasimondo.com/processing/fast_blur_deluxe.php
 */
/*
 Copyright (c) 2010 Mario Klingemann
 
 Permission is hereby granted, free of charge, to any person
 obtaining a copy of this software and associated documentation
 files (the "Software"), to deal in the Software without
 restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following
 conditions:
 
 The above copyright notice and this permission notice shall be
 included in all copies or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 OTHER DEALINGS IN THE SOFTWARE.
 */
ImageFilters.StackBlur = function () {
	var mul_table = [512, 512, 456, 512, 328, 456, 335, 512, 405, 328, 271, 456, 388, 335, 292, 512, 454, 405, 364, 328, 298, 271, 496, 456, 420, 388, 360, 335, 312, 292, 273, 512, 482, 454, 428, 405, 383, 364, 345, 328, 312, 298, 284, 271, 259, 496, 475, 456, 437, 420, 404, 388, 374, 360, 347, 335, 323, 312, 302, 292, 282, 273, 265, 512, 497, 482, 468, 454, 441, 428, 417, 405, 394, 383, 373, 364, 354, 345, 337, 328, 320, 312, 305, 298, 291, 284, 278, 271, 265, 259, 507, 496, 485, 475, 465, 456, 446, 437, 428, 420, 412, 404, 396, 388, 381, 374, 367, 360, 354, 347, 341, 335, 329, 323, 318, 312, 307, 302, 297, 292, 287, 282, 278, 273, 269, 265, 261, 512, 505, 497, 489, 482, 475, 468, 461, 454, 447, 441, 435, 428, 422, 417, 411, 405, 399, 394, 389, 383, 378, 373, 368, 364, 359, 354, 350, 345, 341, 337, 332, 328, 324, 320, 316, 312, 309, 305, 301, 298, 294, 291, 287, 284, 281, 278, 274, 271, 268, 265, 262, 259, 257, 507, 501, 496, 491, 485, 480, 475, 470, 465, 460, 456, 451, 446, 442, 437, 433, 428, 424, 420, 416, 412, 408, 404, 400, 396, 392, 388, 385, 381, 377, 374, 370, 367, 363, 360, 357, 354, 350, 347, 344, 341, 338, 335, 332, 329, 326, 323, 320, 318, 315, 312, 310, 307, 304, 302, 299, 297, 294, 292, 289, 287, 285, 282, 280, 278, 275, 273, 271, 269, 267, 265, 263, 261, 259];

	var shg_table = [9, 11, 12, 13, 13, 14, 14, 15, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24];

	function BlurStack() {
		this.r = 0;
		this.g = 0;
		this.b = 0;
		this.a = 0;
		this.next = null;
	}

	return function (srcImageData, radius) {
		var srcPixels = srcImageData.data,
		    srcWidth = srcImageData.width,
		    srcHeight = srcImageData.height,
		    srcLength = srcPixels.length,
		    dstImageData = this.Clone(srcImageData),
		    dstPixels = dstImageData.data;

		var x,
		    y,
		    i,
		    p,
		    yp,
		    yi,
		    yw,
		    r_sum,
		    g_sum,
		    b_sum,
		    a_sum,
		    r_out_sum,
		    g_out_sum,
		    b_out_sum,
		    a_out_sum,
		    r_in_sum,
		    g_in_sum,
		    b_in_sum,
		    a_in_sum,
		    pr,
		    pg,
		    pb,
		    pa,
		    rbs,
		    div = radius + radius + 1,
		    w4 = srcWidth << 2,
		    widthMinus1 = srcWidth - 1,
		    heightMinus1 = srcHeight - 1,
		    radiusPlus1 = radius + 1,
		    sumFactor = radiusPlus1 * (radiusPlus1 + 1) / 2,
		    stackStart = new BlurStack(),
		    stack = stackStart,
		    stackIn,
		    stackOut,
		    stackEnd,
		    mul_sum = mul_table[radius],
		    shg_sum = shg_table[radius];

		for (i = 1; i < div; i += 1) {
			stack = stack.next = new BlurStack();
			if (i == radiusPlus1) {
				stackEnd = stack;
			}
		}

		stack.next = stackStart;
		yw = yi = 0;

		for (y = 0; y < srcHeight; y += 1) {
			r_in_sum = g_in_sum = b_in_sum = a_in_sum = r_sum = g_sum = b_sum = a_sum = 0;

			r_out_sum = radiusPlus1 * (pr = dstPixels[yi]);
			g_out_sum = radiusPlus1 * (pg = dstPixels[yi + 1]);
			b_out_sum = radiusPlus1 * (pb = dstPixels[yi + 2]);
			a_out_sum = radiusPlus1 * (pa = dstPixels[yi + 3]);

			r_sum += sumFactor * pr;
			g_sum += sumFactor * pg;
			b_sum += sumFactor * pb;
			a_sum += sumFactor * pa;

			stack = stackStart;

			for (i = 0; i < radiusPlus1; i += 1) {
				stack.r = pr;
				stack.g = pg;
				stack.b = pb;
				stack.a = pa;
				stack = stack.next;
			}

			for (i = 1; i < radiusPlus1; i += 1) {
				p = yi + ((widthMinus1 < i ? widthMinus1 : i) << 2);
				r_sum += (stack.r = pr = dstPixels[p]) * (rbs = radiusPlus1 - i);
				g_sum += (stack.g = pg = dstPixels[p + 1]) * rbs;
				b_sum += (stack.b = pb = dstPixels[p + 2]) * rbs;
				a_sum += (stack.a = pa = dstPixels[p + 3]) * rbs;

				r_in_sum += pr;
				g_in_sum += pg;
				b_in_sum += pb;
				a_in_sum += pa;

				stack = stack.next;
			}

			stackIn = stackStart;
			stackOut = stackEnd;

			for (x = 0; x < srcWidth; x += 1) {
				dstPixels[yi] = r_sum * mul_sum >> shg_sum;
				dstPixels[yi + 1] = g_sum * mul_sum >> shg_sum;
				dstPixels[yi + 2] = b_sum * mul_sum >> shg_sum;
				dstPixels[yi + 3] = a_sum * mul_sum >> shg_sum;

				r_sum -= r_out_sum;
				g_sum -= g_out_sum;
				b_sum -= b_out_sum;
				a_sum -= a_out_sum;

				r_out_sum -= stackIn.r;
				g_out_sum -= stackIn.g;
				b_out_sum -= stackIn.b;
				a_out_sum -= stackIn.a;

				p = yw + ((p = x + radius + 1) < widthMinus1 ? p : widthMinus1) << 2;

				r_in_sum += stackIn.r = dstPixels[p];
				g_in_sum += stackIn.g = dstPixels[p + 1];
				b_in_sum += stackIn.b = dstPixels[p + 2];
				a_in_sum += stackIn.a = dstPixels[p + 3];

				r_sum += r_in_sum;
				g_sum += g_in_sum;
				b_sum += b_in_sum;
				a_sum += a_in_sum;

				stackIn = stackIn.next;

				r_out_sum += pr = stackOut.r;
				g_out_sum += pg = stackOut.g;
				b_out_sum += pb = stackOut.b;
				a_out_sum += pa = stackOut.a;

				r_in_sum -= pr;
				g_in_sum -= pg;
				b_in_sum -= pb;
				a_in_sum -= pa;

				stackOut = stackOut.next;

				yi += 4;
			}

			yw += srcWidth;
		}

		for (x = 0; x < srcWidth; x += 1) {
			g_in_sum = b_in_sum = a_in_sum = r_in_sum = g_sum = b_sum = a_sum = r_sum = 0;

			yi = x << 2;
			r_out_sum = radiusPlus1 * (pr = dstPixels[yi]);
			g_out_sum = radiusPlus1 * (pg = dstPixels[yi + 1]);
			b_out_sum = radiusPlus1 * (pb = dstPixels[yi + 2]);
			a_out_sum = radiusPlus1 * (pa = dstPixels[yi + 3]);

			r_sum += sumFactor * pr;
			g_sum += sumFactor * pg;
			b_sum += sumFactor * pb;
			a_sum += sumFactor * pa;

			stack = stackStart;

			for (i = 0; i < radiusPlus1; i += 1) {
				stack.r = pr;
				stack.g = pg;
				stack.b = pb;
				stack.a = pa;
				stack = stack.next;
			}

			yp = srcWidth;

			for (i = 1; i <= radius; i += 1) {
				yi = yp + x << 2;

				r_sum += (stack.r = pr = dstPixels[yi]) * (rbs = radiusPlus1 - i);
				g_sum += (stack.g = pg = dstPixels[yi + 1]) * rbs;
				b_sum += (stack.b = pb = dstPixels[yi + 2]) * rbs;
				a_sum += (stack.a = pa = dstPixels[yi + 3]) * rbs;

				r_in_sum += pr;
				g_in_sum += pg;
				b_in_sum += pb;
				a_in_sum += pa;

				stack = stack.next;

				if (i < heightMinus1) {
					yp += srcWidth;
				}
			}

			yi = x;
			stackIn = stackStart;
			stackOut = stackEnd;

			for (y = 0; y < srcHeight; y += 1) {
				p = yi << 2;
				dstPixels[p] = r_sum * mul_sum >> shg_sum;
				dstPixels[p + 1] = g_sum * mul_sum >> shg_sum;
				dstPixels[p + 2] = b_sum * mul_sum >> shg_sum;
				dstPixels[p + 3] = a_sum * mul_sum >> shg_sum;

				r_sum -= r_out_sum;
				g_sum -= g_out_sum;
				b_sum -= b_out_sum;
				a_sum -= a_out_sum;

				r_out_sum -= stackIn.r;
				g_out_sum -= stackIn.g;
				b_out_sum -= stackIn.b;
				a_out_sum -= stackIn.a;

				p = x + ((p = y + radiusPlus1) < heightMinus1 ? p : heightMinus1) * srcWidth << 2;

				r_sum += r_in_sum += stackIn.r = dstPixels[p];
				g_sum += g_in_sum += stackIn.g = dstPixels[p + 1];
				b_sum += b_in_sum += stackIn.b = dstPixels[p + 2];
				a_sum += a_in_sum += stackIn.a = dstPixels[p + 3];

				stackIn = stackIn.next;

				r_out_sum += pr = stackOut.r;
				g_out_sum += pg = stackOut.g;
				b_out_sum += pb = stackOut.b;
				a_out_sum += pa = stackOut.a;

				r_in_sum -= pr;
				g_in_sum -= pg;
				b_in_sum -= pb;
				a_in_sum -= pa;

				stackOut = stackOut.next;

				yi += srcWidth;
			}
		}

		return dstImageData;
	};
}();

/**
 * TV based algorithm
 */
ImageFilters.Brightness = function (srcImageData, brightness) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	this.utils.mapRGB(srcPixels, dstPixels, function (value) {
		value += brightness;
		return value > 255 ? 255 : value;
	});

	return dstImageData;
};

/**
 * GIMP algorithm modified. pretty close to fireworks
 * @param brightness -100 <= n <= 100
 * @param contrast -100 <= n <= 100
 */
ImageFilters.BrightnessContrastGimp = function (srcImageData, brightness, contrast) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data,
	    p4 = Math.PI / 4;

	// fix to -1 <= n <= 1
	brightness /= 100;

	// fix to -99 <= n <= 99
	contrast *= 0.99;
	// fix to -1 < n < 1
	contrast /= 100;
	// apply GIMP formula
	contrast = Math.tan((contrast + 1) * p4);

	// get the average color
	for (var avg = 0, i = 0; i < srcLength; i += 4) {
		avg += srcPixels[i] * 19595 + srcPixels[i + 1] * 38470 + srcPixels[i + 2] * 7471 >> 16;
	}
	avg = avg / (srcLength / 4);

	this.utils.mapRGB(srcPixels, dstPixels, function (value) {
		if (brightness < 0) {
			value = value * (1 + brightness);
		} else if (brightness > 0) {
			value = value + (255 - value) * brightness;
		}
		//value += brightness;

		if (contrast !== 0) {
			value = (value - avg) * contrast + avg;
		}
		return value + 0.5 | 0;
	});
	return dstImageData;
};

/**
 * more like the new photoshop algorithm
 * @param brightness -100 <= n <= 100
 * @param contrast -100 <= n <= 100
 */
ImageFilters.BrightnessContrastPhotoshop = function (srcImageData, brightness, contrast) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	// fix to 0 <= n <= 2;
	brightness = (brightness + 100) / 100;
	contrast = (contrast + 100) / 100;

	this.utils.mapRGB(srcPixels, dstPixels, function (value) {
		value *= brightness;
		value = (value - 127.5) * contrast + 127.5;
		return value + 0.5 | 0;
	});
	return dstImageData;
};

ImageFilters.Channels = function (srcImageData, channel) {
	var matrix;

	switch (channel) {
		case 2:
			// green
			matrix = [0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0];
			break;
		case 3:
			// blue
			matrix = [0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0];
			break;
		default:
			// red
			matrix = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0];
			break;

	}

	return this.ColorMatrixFilter(srcImageData, matrix);
};

ImageFilters.Clone = function (srcImageData) {
	return this.Copy(srcImageData, this.utils.createImageData(srcImageData.width, srcImageData.height));
};

/**
 * slower
 */
ImageFilters.CloneBuiltin = function (srcImageData) {
	var srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    canvas = this.utils.getSampleCanvas(),
	    context = this.utils.getSampleContext(),
	    dstImageData;

	canvas.width = srcWidth;
	canvas.height = srcHeight;

	context.putImageData(srcImageData, 0, 0);
	dstImageData = context.getImageData(0, 0, srcWidth, srcHeight);

	canvas.width = 0;
	canvas.height = 0;

	return dstImageData;
};

ImageFilters.ColorMatrixFilter = function (srcImageData, matrix) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	var m0 = matrix[0],
	    m1 = matrix[1],
	    m2 = matrix[2],
	    m3 = matrix[3],
	    m4 = matrix[4],
	    m5 = matrix[5],
	    m6 = matrix[6],
	    m7 = matrix[7],
	    m8 = matrix[8],
	    m9 = matrix[9],
	    m10 = matrix[10],
	    m11 = matrix[11],
	    m12 = matrix[12],
	    m13 = matrix[13],
	    m14 = matrix[14],
	    m15 = matrix[15],
	    m16 = matrix[16],
	    m17 = matrix[17],
	    m18 = matrix[18],
	    m19 = matrix[19];

	var value, i, r, g, b, a;
	for (i = 0; i < srcLength; i += 4) {
		r = srcPixels[i];
		g = srcPixels[i + 1];
		b = srcPixels[i + 2];
		a = srcPixels[i + 3];

		dstPixels[i] = (value = r * m0 + g * m1 + b * m2 + a * m3 + m4) > 255 ? 255 : value < 0 ? 0 : value | 0;
		dstPixels[i + 1] = (value = r * m5 + g * m6 + b * m7 + a * m8 + m9) > 255 ? 255 : value < 0 ? 0 : value | 0;
		dstPixels[i + 2] = (value = r * m10 + g * m11 + b * m12 + a * m13 + m14) > 255 ? 255 : value < 0 ? 0 : value | 0;
		dstPixels[i + 3] = (value = r * m15 + g * m16 + b * m17 + a * m18 + m19) > 255 ? 255 : value < 0 ? 0 : value | 0;
	}

	return dstImageData;
};

ImageFilters.ColorTransformFilter = function (srcImageData, redMultiplier, greenMultiplier, blueMultiplier, alphaMultiplier, redOffset, greenOffset, blueOffset, alphaOffset) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	var i, v;
	for (i = 0; i < srcLength; i += 4) {
		dstPixels[i] = (v = srcPixels[i] * redMultiplier + redOffset) > 255 ? 255 : v < 0 ? 0 : v;
		dstPixels[i + 1] = (v = srcPixels[i + 1] * greenMultiplier + greenOffset) > 255 ? 255 : v < 0 ? 0 : v;
		dstPixels[i + 2] = (v = srcPixels[i + 2] * blueMultiplier + blueOffset) > 255 ? 255 : v < 0 ? 0 : v;
		dstPixels[i + 3] = (v = srcPixels[i + 3] * alphaMultiplier + alphaOffset) > 255 ? 255 : v < 0 ? 0 : v;
	}

	return dstImageData;
};

ImageFilters.Copy = function (srcImageData, dstImageData) {
	var srcPixels = srcImageData.data,
	    srcLength = srcPixels.length,
	    dstPixels = dstImageData.data;

	while (srcLength--) {
		dstPixels[srcLength] = srcPixels[srcLength];
	}

	return dstImageData;
};

ImageFilters.Crop = function (srcImageData, x, y, width, height) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(width, height),
	    dstPixels = dstImageData.data;

	var srcLeft = Math.max(x, 0),
	    srcTop = Math.max(y, 0),
	    srcRight = Math.min(x + width, srcWidth),
	    srcBottom = Math.min(y + height, srcHeight),
	    dstLeft = srcLeft - x,
	    dstTop = srcTop - y,
	    srcRow,
	    srcCol,
	    srcIndex,
	    dstIndex;

	for (srcRow = srcTop, dstRow = dstTop; srcRow < srcBottom; srcRow += 1, dstRow += 1) {
		for (srcCol = srcLeft, dstCol = dstLeft; srcCol < srcRight; srcCol += 1, dstCol += 1) {
			srcIndex = srcRow * srcWidth + srcCol << 2;
			dstIndex = dstRow * width + dstCol << 2;
			dstPixels[dstIndex] = srcPixels[srcIndex];
			dstPixels[dstIndex + 1] = srcPixels[srcIndex + 1];
			dstPixels[dstIndex + 2] = srcPixels[srcIndex + 2];
			dstPixels[dstIndex + 3] = srcPixels[srcIndex + 3];
		}
	}

	return dstImageData;
};

ImageFilters.CropBuiltin = function (srcImageData, x, y, width, height) {
	var srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    canvas = this.utils.getSampleCanvas(),
	    context = this.utils.getSampleContext();

	canvas.width = srcWidth;
	canvas.height = srcHeight;
	context.putImageData(srcImageData, 0, 0);
	var result = context.getImageData(x, y, width, height);

	canvas.width = 0;
	canvas.height = 0;

	return result;
};

/**
 * sets to the average of the highest and lowest contrast
 */
ImageFilters.Desaturate = function (srcImageData) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	for (var i = 0; i < srcLength; i += 4) {
		var r = srcPixels[i],
		    g = srcPixels[i + 1],
		    b = srcPixels[i + 2],
		    max = r > g ? r > b ? r : b : g > b ? g : b,
		    min = r < g ? r < b ? r : b : g < b ? g : b,
		    avg = (max + min) / 2 + 0.5 | 0;

		dstPixels[i] = dstPixels[i + 1] = dstPixels[i + 2] = avg;
		dstPixels[i + 3] = srcPixels[i + 3];
	}

	return dstImageData;
};

ImageFilters.DisplacementMapFilter = function (srcImageData, mapImageData, mapX, mapY, componentX, componentY, scaleX, scaleY, mode) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = ImageFilters.Clone(srcImageData),
	    dstPixels = dstImageData.data;

	mapX || (mapX = 0);
	mapY || (mapY = 0);
	componentX || (componentX = 0); // red?
	componentY || (componentY = 0);
	scaleX || (scaleX = 0);
	scaleY || (scaleY = 0);
	mode || (mode = 2); // wrap

	var mapWidth = mapImageData.width,
	    mapHeight = mapImageData.height,
	    mapPixels = mapImageData.data,
	    mapRight = mapWidth + mapX,
	    mapBottom = mapHeight + mapY,
	    dstIndex,
	    srcIndex,
	    mapIndex,
	    cx,
	    cy,
	    tx,
	    ty,
	    x,
	    y;

	for (x = 0; x < srcWidth; x += 1) {
		for (y = 0; y < srcHeight; y += 1) {

			dstIndex = y * srcWidth + x << 2;

			if (x < mapX || y < mapY || x >= mapRight || y >= mapBottom) {
				// out of the map bounds
				// copy src to dst
				srcIndex = dstIndex;
			} else {
				// apply map
				mapIndex = (y - mapY) * mapWidth + (x - mapX) << 2;

				// tx = x + ((componentX(x, y) - 128) * scaleX) / 256
				cx = mapPixels[mapIndex + componentX];
				tx = x + ((cx - 128) * scaleX >> 8);

				// tx = y + ((componentY(x, y) - 128) * scaleY) / 256
				cy = mapPixels[mapIndex + componentY];
				ty = y + ((cy - 128) * scaleY >> 8);

				srcIndex = ImageFilters.utils.getPixelIndex(tx + 0.5 | 0, ty + 0.5 | 0, srcWidth, srcHeight, mode);
				if (srcIndex === null) {
					// if mode == ignore and (tx,ty) is out of src bounds
					// then copy (x,y) to dst
					srcIndex = dstIndex;
				}
			}

			dstPixels[dstIndex] = srcPixels[srcIndex];
			dstPixels[dstIndex + 1] = srcPixels[srcIndex + 1];
			dstPixels[dstIndex + 2] = srcPixels[srcIndex + 2];
			dstPixels[dstIndex + 3] = srcPixels[srcIndex + 3];
		}
	}

	return dstImageData;
};

/**
 * Floyd-Steinberg algorithm
 * @param levels 2 <= n <= 255
 */
ImageFilters.Dither = function (srcImageData, levels) {
	var srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    dstImageData = this.Clone(srcImageData),
	    dstPixels = dstImageData.data;

	levels = levels < 2 ? 2 : levels > 255 ? 255 : levels;

	// Build a color map using the same algorithm as the posterize filter.
	var posterize,
	    levelMap = [],
	    levelsMinus1 = levels - 1,
	    j = 0,
	    k = 0,
	    i;

	for (i = 0; i < levels; i += 1) {
		levelMap[i] = 255 * i / levelsMinus1;
	}

	posterize = this.utils.buildMap(function (value) {
		var ret = levelMap[j];

		k += levels;

		if (k > 255) {
			k -= 255;
			j += 1;
		}

		return ret;
	});

	// Apply the dithering algorithm to each pixel
	var x,
	    y,
	    index,
	    old_r,
	    old_g,
	    old_b,
	    new_r,
	    new_g,
	    new_b,
	    err_r,
	    err_g,
	    err_b,
	    nbr_r,
	    nbr_g,
	    nbr_b,
	    srcWidthMinus1 = srcWidth - 1,
	    srcHeightMinus1 = srcHeight - 1,
	    A = 7 / 16,
	    B = 3 / 16,
	    C = 5 / 16,
	    D = 1 / 16;

	for (y = 0; y < srcHeight; y += 1) {
		for (x = 0; x < srcWidth; x += 1) {
			// Get the current pixel.
			index = y * srcWidth + x << 2;

			old_r = dstPixels[index];
			old_g = dstPixels[index + 1];
			old_b = dstPixels[index + 2];

			// Quantize using the color map
			new_r = posterize[old_r];
			new_g = posterize[old_g];
			new_b = posterize[old_b];

			// Set the current pixel.
			dstPixels[index] = new_r;
			dstPixels[index + 1] = new_g;
			dstPixels[index + 2] = new_b;

			// Quantization errors
			err_r = old_r - new_r;
			err_g = old_g - new_g;
			err_b = old_b - new_b;

			// Apply the matrix.
			// x + 1, y
			index += 1 << 2;
			if (x < srcWidthMinus1) {
				nbr_r = dstPixels[index] + A * err_r;
				nbr_g = dstPixels[index + 1] + A * err_g;
				nbr_b = dstPixels[index + 2] + A * err_b;

				dstPixels[index] = nbr_r > 255 ? 255 : nbr_r < 0 ? 0 : nbr_r | 0;
				dstPixels[index + 1] = nbr_g > 255 ? 255 : nbr_g < 0 ? 0 : nbr_g | 0;
				dstPixels[index + 2] = nbr_b > 255 ? 255 : nbr_b < 0 ? 0 : nbr_b | 0;
			}

			// x - 1, y + 1
			index += srcWidth - 2 << 2;
			if (x > 0 && y < srcHeightMinus1) {
				nbr_r = dstPixels[index] + B * err_r;
				nbr_g = dstPixels[index + 1] + B * err_g;
				nbr_b = dstPixels[index + 2] + B * err_b;

				dstPixels[index] = nbr_r > 255 ? 255 : nbr_r < 0 ? 0 : nbr_r | 0;
				dstPixels[index + 1] = nbr_g > 255 ? 255 : nbr_g < 0 ? 0 : nbr_g | 0;
				dstPixels[index + 2] = nbr_b > 255 ? 255 : nbr_b < 0 ? 0 : nbr_b | 0;
			}

			// x, y + 1
			index += 1 << 2;
			if (y < srcHeightMinus1) {
				nbr_r = dstPixels[index] + C * err_r;
				nbr_g = dstPixels[index + 1] + C * err_g;
				nbr_b = dstPixels[index + 2] + C * err_b;

				dstPixels[index] = nbr_r > 255 ? 255 : nbr_r < 0 ? 0 : nbr_r | 0;
				dstPixels[index + 1] = nbr_g > 255 ? 255 : nbr_g < 0 ? 0 : nbr_g | 0;
				dstPixels[index + 2] = nbr_b > 255 ? 255 : nbr_b < 0 ? 0 : nbr_b | 0;
			}

			// x + 1, y + 1
			index += 1 << 2;
			if (x < srcWidthMinus1 && y < srcHeightMinus1) {
				nbr_r = dstPixels[index] + D * err_r;
				nbr_g = dstPixels[index + 1] + D * err_g;
				nbr_b = dstPixels[index + 2] + D * err_b;

				dstPixels[index] = nbr_r > 255 ? 255 : nbr_r < 0 ? 0 : nbr_r | 0;
				dstPixels[index + 1] = nbr_g > 255 ? 255 : nbr_g < 0 ? 0 : nbr_g | 0;
				dstPixels[index + 2] = nbr_b > 255 ? 255 : nbr_b < 0 ? 0 : nbr_b | 0;
			}
		}
	}

	return dstImageData;
};

ImageFilters.Edge = function (srcImageData) {
	//pretty close to Fireworks 'Find Edges' effect
	return this.ConvolutionFilter(srcImageData, 3, 3, [-1, -1, -1, -1, 8, -1, -1, -1, -1]);
};

ImageFilters.Emboss = function (srcImageData) {
	return this.ConvolutionFilter(srcImageData, 3, 3, [-2, -1, 0, -1, 1, 1, 0, 1, 2]);
};

ImageFilters.Enrich = function (srcImageData) {
	return this.ConvolutionFilter(srcImageData, 3, 3, [0, -2, 0, -2, 20, -2, 0, -2, 0], 10, -40);
};

ImageFilters.Flip = function (srcImageData, vertical) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	var x, y, srcIndex, dstIndex, i;

	for (y = 0; y < srcHeight; y += 1) {
		for (x = 0; x < srcWidth; x += 1) {
			srcIndex = y * srcWidth + x << 2;
			if (vertical) {
				dstIndex = (srcHeight - y - 1) * srcWidth + x << 2;
			} else {
				dstIndex = y * srcWidth + (srcWidth - x - 1) << 2;
			}

			dstPixels[dstIndex] = srcPixels[srcIndex];
			dstPixels[dstIndex + 1] = srcPixels[srcIndex + 1];
			dstPixels[dstIndex + 2] = srcPixels[srcIndex + 2];
			dstPixels[dstIndex + 3] = srcPixels[srcIndex + 3];
		}
	}

	return dstImageData;
};

ImageFilters.Gamma = function (srcImageData, gamma) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	this.utils.mapRGB(srcPixels, dstPixels, function (value) {
		value = 255 * Math.pow(value / 255, 1 / gamma) + 0.5;
		return value > 255 ? 255 : value + 0.5 | 0;
	});

	return dstImageData;
};

ImageFilters.GrayScale = function (srcImageData) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	for (var i = 0; i < srcLength; i += 4) {
		var intensity = srcPixels[i] * 19595 + srcPixels[i + 1] * 38470 + srcPixels[i + 2] * 7471 >> 16;
		//var intensity = (srcPixels[i] * 0.3086 + srcPixels[i + 1] * 0.6094 + srcPixels[i + 2] * 0.0820) | 0;
		dstPixels[i] = dstPixels[i + 1] = dstPixels[i + 2] = intensity;
		dstPixels[i + 3] = srcPixels[i + 3];
	}

	return dstImageData;
};

/**
 * @param hueDelta  -180 <= n <= 180
 * @param satDelta  -100 <= n <= 100
 * @param lightness -100 <= n <= 100
 */
ImageFilters.HSLAdjustment = function (srcImageData, hueDelta, satDelta, lightness) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	hueDelta /= 360;
	satDelta /= 100;
	lightness /= 100;

	var rgbToHsl = this.utils.rgbToHsl;
	var hslToRgb = this.utils.hslToRgb;
	var h, s, l, hsl, rgb, i;

	for (i = 0; i < srcLength; i += 4) {
		// convert to HSL
		hsl = rgbToHsl(srcPixels[i], srcPixels[i + 1], srcPixels[i + 2]);

		// hue
		h = hsl[0] + hueDelta;
		while (h < 0) {
			h += 1;
		}
		while (h > 1) {
			h -= 1;
		}

		// saturation
		s = hsl[1] + hsl[1] * satDelta;
		if (s < 0) {
			s = 0;
		} else if (s > 1) {
			s = 1;
		}

		// lightness
		l = hsl[2];
		if (lightness > 0) {
			l += (1 - l) * lightness;
		} else if (lightness < 0) {
			l += l * lightness;
		}

		// convert back to rgb
		rgb = hslToRgb(h, s, l);

		dstPixels[i] = rgb[0];
		dstPixels[i + 1] = rgb[1];
		dstPixels[i + 2] = rgb[2];
		dstPixels[i + 3] = srcPixels[i + 3];
	}

	return dstImageData;
};

ImageFilters.Invert = function (srcImageData) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	this.utils.mapRGB(srcPixels, dstPixels, function (value) {
		return 255 - value;
	});

	return dstImageData;
};

ImageFilters.Mosaic = function (srcImageData, blockSize) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	var cols = Math.ceil(srcWidth / blockSize),
	    rows = Math.ceil(srcHeight / blockSize),
	    row,
	    col,
	    x_start,
	    x_end,
	    y_start,
	    y_end,
	    x,
	    y,
	    yIndex,
	    index,
	    size,
	    r,
	    g,
	    b,
	    a;

	for (row = 0; row < rows; row += 1) {
		y_start = row * blockSize;
		y_end = y_start + blockSize;

		if (y_end > srcHeight) {
			y_end = srcHeight;
		}

		for (col = 0; col < cols; col += 1) {
			x_start = col * blockSize;
			x_end = x_start + blockSize;

			if (x_end > srcWidth) {
				x_end = srcWidth;
			}

			// get the average color from the src
			r = g = b = a = 0;
			size = (x_end - x_start) * (y_end - y_start);

			for (y = y_start; y < y_end; y += 1) {
				yIndex = y * srcWidth;

				for (x = x_start; x < x_end; x += 1) {
					index = yIndex + x << 2;
					r += srcPixels[index];
					g += srcPixels[index + 1];
					b += srcPixels[index + 2];
					a += srcPixels[index + 3];
				}
			}

			r = r / size + 0.5 | 0;
			g = g / size + 0.5 | 0;
			b = b / size + 0.5 | 0;
			a = a / size + 0.5 | 0;

			// fill the dst with that color
			for (y = y_start; y < y_end; y += 1) {
				yIndex = y * srcWidth;

				for (x = x_start; x < x_end; x += 1) {
					index = yIndex + x << 2;
					dstPixels[index] = r;
					dstPixels[index + 1] = g;
					dstPixels[index + 2] = b;
					dstPixels[index + 3] = a;
				}
			}
		}
	}

	return dstImageData;
};

/**
 * @param range  1 <= n <= 5
 * @param levels 1 <= n <= 256
 */
ImageFilters.Oil = function (srcImageData, range, levels) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	var index = 0,
	    rh = [],
	    gh = [],
	    bh = [],
	    rt = [],
	    gt = [],
	    bt = [],
	    x,
	    y,
	    i,
	    row,
	    col,
	    rowIndex,
	    colIndex,
	    offset,
	    srcIndex,
	    sr,
	    sg,
	    sb,
	    ri,
	    gi,
	    bi,
	    r,
	    g,
	    b;

	for (y = 0; y < srcHeight; y += 1) {
		for (x = 0; x < srcWidth; x += 1) {
			for (i = 0; i < levels; i += 1) {
				rh[i] = gh[i] = bh[i] = rt[i] = gt[i] = bt[i] = 0;
			}

			for (row = -range; row <= range; row += 1) {
				rowIndex = y + row;

				if (rowIndex < 0 || rowIndex >= srcHeight) {
					continue;
				}

				offset = rowIndex * srcWidth;

				for (col = -range; col <= range; col += 1) {
					colIndex = x + col;
					if (colIndex < 0 || colIndex >= srcWidth) {
						continue;
					}

					srcIndex = offset + colIndex << 2;
					sr = srcPixels[srcIndex];
					sg = srcPixels[srcIndex + 1];
					sb = srcPixels[srcIndex + 2];
					ri = sr * levels >> 8;
					gi = sg * levels >> 8;
					bi = sb * levels >> 8;
					rt[ri] += sr;
					gt[gi] += sg;
					bt[bi] += sb;
					rh[ri] += 1;
					gh[gi] += 1;
					bh[bi] += 1;
				}
			}

			r = g = b = 0;
			for (i = 1; i < levels; i += 1) {
				if (rh[i] > rh[r]) {
					r = i;
				}
				if (gh[i] > gh[g]) {
					g = i;
				}
				if (bh[i] > bh[b]) {
					b = i;
				}
			}

			dstPixels[index] = rt[r] / rh[r] | 0;
			dstPixels[index + 1] = gt[g] / gh[g] | 0;
			dstPixels[index + 2] = bt[b] / bh[b] | 0;
			dstPixels[index + 3] = srcPixels[index + 3];
			index += 4;
		}
	}

	return dstImageData;
};

ImageFilters.OpacityFilter = function (srcImageData, opacity) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	for (var i = 0; i < srcLength; i += 4) {
		dstPixels[i] = srcPixels[i];
		dstPixels[i + 1] = srcPixels[i + 1];
		dstPixels[i + 2] = srcPixels[i + 2];
		dstPixels[i + 3] = opacity;
	}

	return dstImageData;
};

/**
 * @param levels 2 <= n <= 255
 */
ImageFilters.Posterize = function (srcImageData, levels) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	levels = levels < 2 ? 2 : levels > 255 ? 255 : levels;

	var levelMap = [],
	    levelsMinus1 = levels - 1,
	    j = 0,
	    k = 0,
	    i;

	for (i = 0; i < levels; i += 1) {
		levelMap[i] = 255 * i / levelsMinus1;
	}

	this.utils.mapRGB(srcPixels, dstPixels, function (value) {
		var ret = levelMap[j];

		k += levels;

		if (k > 255) {
			k -= 255;
			j += 1;
		}

		return ret;
	});

	return dstImageData;
};

/**
 * @param scale 0.0 <= n <= 5.0
 */
ImageFilters.Rescale = function (srcImageData, scale) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	this.utils.mapRGB(srcPixels, dstPixels, function (value) {
		value *= scale;
		return value > 255 ? 255 : value + 0.5 | 0;
	});

	return dstImageData;
};

/**
 * Nearest neighbor
 */
ImageFilters.ResizeNearestNeighbor = function (srcImageData, width, height) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(width, height),
	    dstPixels = dstImageData.data;

	var xFactor = srcWidth / width,
	    yFactor = srcHeight / height,
	    dstIndex = 0,
	    srcIndex,
	    x,
	    y,
	    offset;

	for (y = 0; y < height; y += 1) {
		offset = (y * yFactor | 0) * srcWidth;

		for (x = 0; x < width; x += 1) {
			srcIndex = offset + x * xFactor << 2;

			dstPixels[dstIndex] = srcPixels[srcIndex];
			dstPixels[dstIndex + 1] = srcPixels[srcIndex + 1];
			dstPixels[dstIndex + 2] = srcPixels[srcIndex + 2];
			dstPixels[dstIndex + 3] = srcPixels[srcIndex + 3];
			dstIndex += 4;
		}
	}

	return dstImageData;
};

/**
 * Bilinear
 */
ImageFilters.Resize = function (srcImageData, width, height) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(width, height),
	    dstPixels = dstImageData.data;

	var xFactor = srcWidth / width,
	    yFactor = srcHeight / height,
	    dstIndex = 0,
	    x,
	    y;

	for (y = 0; y < height; y += 1) {
		for (x = 0; x < width; x += 1) {
			this.utils.copyBilinear(srcPixels, x * xFactor, y * yFactor, srcWidth, srcHeight, dstPixels, dstIndex, 0);
			dstIndex += 4;
		}
	}

	return dstImageData;
};

/**
 * faster resizing using the builtin context.scale()
 * the resizing algorithm may be different between browsers
 * this might not work if the image is transparent.
 * to fix that we probably need two contexts
 */
ImageFilters.ResizeBuiltin = function (srcImageData, width, height) {
	var srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    canvas = this.utils.getSampleCanvas(),
	    context = this.utils.getSampleContext(),
	    dstImageData;

	canvas.width = Math.max(srcWidth, width);
	canvas.height = Math.max(srcHeight, height);
	context.save();

	context.putImageData(srcImageData, 0, 0);
	context.scale(width / srcWidth, height / srcHeight);
	context.drawImage(canvas, 0, 0);

	dstImageData = context.getImageData(0, 0, width, height);

	context.restore();
	canvas.width = 0;
	canvas.height = 0;

	return dstImageData;
};

ImageFilters.Sepia = function (srcImageData) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	var r, g, b, i, value;

	for (i = 0; i < srcLength; i += 4) {
		r = srcPixels[i];
		g = srcPixels[i + 1];
		b = srcPixels[i + 2];

		dstPixels[i] = (value = r * 0.393 + g * 0.769 + b * 0.189) > 255 ? 255 : value < 0 ? 0 : value + 0.5 | 0;
		dstPixels[i + 1] = (value = r * 0.349 + g * 0.686 + b * 0.168) > 255 ? 255 : value < 0 ? 0 : value + 0.5 | 0;
		dstPixels[i + 2] = (value = r * 0.272 + g * 0.534 + b * 0.131) > 255 ? 255 : value < 0 ? 0 : value + 0.5 | 0;
		dstPixels[i + 3] = srcPixels[i + 3];
	}

	return dstImageData;
};

/**
 * @param factor 1 <= n
 */
ImageFilters.Sharpen = function (srcImageData, factor) {
	//Convolution formula from VIGRA
	return this.ConvolutionFilter(srcImageData, 3, 3, [-factor / 16, -factor / 8, -factor / 16, -factor / 8, factor * 0.75 + 1, -factor / 8, -factor / 16, -factor / 8, -factor / 16]);
};

ImageFilters.Solarize = function (srcImageData) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	this.utils.mapRGB(srcPixels, dstPixels, function (value) {
		return value > 127 ? (value - 127.5) * 2 : (127.5 - value) * 2;
	});

	return dstImageData;
};

ImageFilters.Transpose = function (srcImageData) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcHeight, srcWidth),
	    dstPixels = dstImageData.data;

	var srcIndex, dstIndex;

	for (y = 0; y < srcHeight; y += 1) {
		for (x = 0; x < srcWidth; x += 1) {
			srcIndex = y * srcWidth + x << 2;
			dstIndex = x * srcHeight + y << 2;

			dstPixels[dstIndex] = srcPixels[srcIndex];
			dstPixels[dstIndex + 1] = srcPixels[srcIndex + 1];
			dstPixels[dstIndex + 2] = srcPixels[srcIndex + 2];
			dstPixels[dstIndex + 3] = srcPixels[srcIndex + 3];
		}
	}

	return dstImageData;
};

/**
 * @param centerX 0.0 <= n <= 1.0
 * @param centerY 0.0 <= n <= 1.0
 * @param radius
 * @param angle(degree)
 * @param smooth
 */
ImageFilters.Twril = function (srcImageData, centerX, centerY, radius, angle, edge, smooth) {
	var srcPixels = srcImageData.data,
	    srcWidth = srcImageData.width,
	    srcHeight = srcImageData.height,
	    srcLength = srcPixels.length,
	    dstImageData = this.utils.createImageData(srcWidth, srcHeight),
	    dstPixels = dstImageData.data;

	//convert position to px
	centerX = srcWidth * centerX;
	centerY = srcHeight * centerY;

	// degree to radian
	angle *= Math.PI / 180;

	var radius2 = radius * radius,
	    max_y = srcHeight - 1,
	    max_x = srcWidth - 1,
	    dstIndex = 0,
	    x,
	    y,
	    dx,
	    dy,
	    distance,
	    a,
	    tx,
	    ty,
	    srcIndex,
	    pixel,
	    i;

	for (y = 0; y < srcHeight; y += 1) {
		for (x = 0; x < srcWidth; x += 1) {
			dx = x - centerX;
			dy = y - centerY;
			distance = dx * dx + dy * dy;

			if (distance > radius2) {
				// out of the effected area. just copy the pixel
				dstPixels[dstIndex] = srcPixels[dstIndex];
				dstPixels[dstIndex + 1] = srcPixels[dstIndex + 1];
				dstPixels[dstIndex + 2] = srcPixels[dstIndex + 2];
				dstPixels[dstIndex + 3] = srcPixels[dstIndex + 3];
			} else {
				// main formula
				distance = Math.sqrt(distance);
				a = Math.atan2(dy, dx) + angle * (radius - distance) / radius;
				tx = centerX + distance * Math.cos(a);
				ty = centerY + distance * Math.sin(a);

				// copy target pixel
				if (smooth) {
					// bilinear
					this.utils.copyBilinear(srcPixels, tx, ty, srcWidth, srcHeight, dstPixels, dstIndex, edge);
				} else {
					// nearest neighbor
					// round tx, ty
					srcIndex = (ty + 0.5 | 0) * srcWidth + (tx + 0.5 | 0) << 2;
					dstPixels[dstIndex] = srcPixels[srcIndex];
					dstPixels[dstIndex + 1] = srcPixels[srcIndex + 1];
					dstPixels[dstIndex + 2] = srcPixels[srcIndex + 2];
					dstPixels[dstIndex + 3] = srcPixels[srcIndex + 3];
				}
			}

			dstIndex += 4;
		}
	}

	return dstImageData;
};

exports.default = ImageFilters;

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * miniPaint - https://github.com/viliusle/miniPaint
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * author: Vilius L.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _guiTools = __webpack_require__(13);

var _guiTools2 = _interopRequireDefault(_guiTools);

var _guiPreview = __webpack_require__(22);

var _guiPreview2 = _interopRequireDefault(_guiPreview);

var _guiColors = __webpack_require__(79);

var _guiColors2 = _interopRequireDefault(_guiColors);

var _guiLayers = __webpack_require__(80);

var _guiLayers2 = _interopRequireDefault(_guiLayers);

var _guiInformation = __webpack_require__(81);

var _guiInformation2 = _interopRequireDefault(_guiInformation);

var _guiDetails = __webpack_require__(82);

var _guiDetails2 = _interopRequireDefault(_guiDetails);

var _guiMenu = __webpack_require__(83);

var _guiMenu2 = _interopRequireDefault(_guiMenu);

var _translate = __webpack_require__(15);

var _translate2 = _interopRequireDefault(_translate);

var _helpers = __webpack_require__(4);

var _helpers2 = _interopRequireDefault(_helpers);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var instance = null;

/**
 * Main GUI class
 */

var Base_gui_class = function () {
	function Base_gui_class() {
		_classCallCheck(this, Base_gui_class);

		//singleton
		if (instance) {
			return instance;
		}
		instance = this;

		this.Helper = new _helpers2.default();

		//last used menu id
		this.last_menu = '';

		//grid dimnesions config
		this.grid_size = [50, 50];

		//if grid is visible
		this.grid = false;

		//common image dimensions
		this.common_dimensions = [[640, 480, '480p'], [800, 600, 'SVGA'], [1024, 768, 'XGA'], [1280, 720, 'hdtv, 720p'], [1600, 1200, 'UXGA'], [1920, 1080, 'Full HD, 1080p'], [3840, 2160, '4K UHD']];

		this.GUI_tools = new _guiTools2.default(this);
		this.GUI_preview = new _guiPreview2.default(this);
		this.GUI_colors = new _guiColors2.default(this);
		this.GUI_layers = new _guiLayers2.default(this);
		this.GUI_information = new _guiInformation2.default(this);
		this.GUI_details = new _guiDetails2.default(this);
		this.GUI_menu = new _guiMenu2.default();
		this.Help_translate = new _translate2.default();
		this.modules = {};
	}

	_createClass(Base_gui_class, [{
		key: 'load_modules',
		value: function load_modules() {
			var _this = this;
			var modules_context = __webpack_require__(86);
			modules_context.keys().forEach(function (key) {
				if (key.indexOf('Base' + '/') < 0) {
					var moduleKey = key.replace('./', '').replace('.js', '');
					var classObj = modules_context(key);
					_this.modules[moduleKey] = new classObj.default();
				}
			});
		}
	}, {
		key: 'load_default_values',
		value: function load_default_values() {
			//transparency
			var transparency_cookie = this.Helper.getCookie('transparency');
			if (transparency_cookie === null) {
				//default
				_config2.default.TRANSPARENCY = false;
			}
			if (transparency_cookie) {
				_config2.default.TRANSPARENCY = true;
			} else {
				_config2.default.TRANSPARENCY = false;
			}

			//transparency_type
			var transparency_type = this.Helper.getCookie('transparency_type');
			if (transparency_type === null) {
				//default
				_config2.default.TRANSPARENCY_TYPE = 'squares';
			}
			if (transparency_type) {
				_config2.default.TRANSPARENCY_TYPE = transparency_type;
			}
		}
	}, {
		key: 'render_main_gui',
		value: function render_main_gui() {
			this.autodetect_dimensions();

			this.prepare_canvas();
			this.GUI_tools.render_main_tools();
			this.GUI_preview.render_main_preview();
			this.GUI_colors.render_main_colors();
			this.GUI_layers.render_main_layers();
			this.GUI_information.render_main_information();
			this.GUI_details.render_main_details();
			this.GUI_menu.render_main();
			this.load_saved_changes();

			this.set_events();
			this.load_translations();
		}
	}, {
		key: 'set_events',
		value: function set_events() {
			var _this = this;
			//menu events
			var targets = document.querySelectorAll('#main_menu a');
			for (var i = 0; i < targets.length; i++) {
				if (targets[i].dataset.target == undefined) continue;
				targets[i].addEventListener('click', function (event) {
					var parts = this.dataset.target.split('.');
					var module = parts[0];
					var function_name = parts[1];
					var param = parts[2];

					//close menu
					var menu = document.querySelector('#main_menu .selected');
					if (menu != undefined) {
						menu.click();
					}

					//call module
					if (_this.modules[module] == undefined) {
						_alertifyMin2.default.error('Modules class not found: ' + module);
						return;
					}
					if (_this.modules[module][function_name] == undefined) {
						_alertifyMin2.default.error('Module function not found. ' + module + '.' + function_name);
						return;
					}
					_this.modules[module][function_name](param);
				});
			}

			//registerToggleAbility
			var targets = document.querySelectorAll('.toggle');
			for (var i = 0; i < targets.length; i++) {
				if (targets[i].dataset.target == undefined) continue;
				targets[i].addEventListener('click', function (event) {
					this.classList.toggle('toggled');
					var target = document.getElementById(this.dataset.target);
					target.classList.toggle('hidden');
					//save
					if (_this.Helper.strpos(target.classList, 'hidden') === false) _this.Helper.setCookie(this.dataset.target, 1);else _this.Helper.setCookie(this.dataset.target, 0);
				});
			}

			document.getElementById('mobile_menu_button').addEventListener('click', function (event) {
				document.querySelector('.sidebar_right').classList.toggle('active');
			});
			window.addEventListener('resize', function (event) {
				//resize
				_this.prepare_canvas();
				_config2.default.need_render = true;
			}, false);
		}
	}, {
		key: 'prepare_canvas',
		value: function prepare_canvas() {
			var canvas = document.getElementById('canvas_minipaint');
			var ctx = canvas.getContext("2d");

			var wrapper = document.getElementById('main_wrapper');
			var page_w = wrapper.clientWidth;
			var page_h = wrapper.clientHeight;

			var w = Math.min(Math.ceil(_config2.default.WIDTH * _config2.default.ZOOM), page_w);
			var h = Math.min(Math.ceil(_config2.default.HEIGHT * _config2.default.ZOOM), page_h);

			canvas.width = w;
			canvas.height = h;

			_config2.default.visible_width = w;
			_config2.default.visible_height = h;

			ctx.webkitImageSmoothingEnabled = false;
			ctx.oImageSmoothingEnabled = false;
			ctx.msImageSmoothingEnabled = false;
			ctx.imageSmoothingEnabled = false;

			this.render_canvas_background('canvas_minipaint');

			//change wrapper dimensions
			document.getElementById('canvas_wrapper').style.width = w + 'px';
			document.getElementById('canvas_wrapper').style.height = h + 'px';
		}
	}, {
		key: 'load_saved_changes',
		value: function load_saved_changes() {
			var targets = document.querySelectorAll('.toggle');
			for (var i = 0; i < targets.length; i++) {
				if (targets[i].dataset.target == undefined) continue;

				var target = document.getElementById(targets[i].dataset.target);
				var saved = this.Helper.getCookie(targets[i].dataset.target);
				if (saved === 0) {
					targets[i].classList.toggle('toggled');
					target.classList.add('hidden');
				}
			}
		}
	}, {
		key: 'load_translations',
		value: function load_translations() {
			var lang_cookie = this.Helper.getCookie('language');
			if (lang_cookie != null && lang_cookie != 'en') {
				_config2.default.LANG = lang_cookie.replace(/([^a-z]+)/gi, '');
				this.Help_translate.translate(_config2.default.LANG);
			}
		}
	}, {
		key: 'autodetect_dimensions',
		value: function autodetect_dimensions() {
			var wrapper = document.getElementById('main_wrapper');
			var page_w = wrapper.clientWidth;
			var page_h = wrapper.clientHeight;
			var auto_size = false;

			var save_resolution_cookie = this.Helper.getCookie('save_resolution');
			var last_resolution = this.Helper.getCookie('last_resolution');
			if (save_resolution_cookie != null && save_resolution_cookie != '' && last_resolution != null && last_resolution != '') {
				//load last saved resolution
				last_resolution = JSON.parse(last_resolution);
				_config2.default.WIDTH = parseInt(last_resolution[0]);
				_config2.default.HEIGHT = parseInt(last_resolution[1]);
			} else {
				//use largest possible
				for (var i = this.common_dimensions.length - 1; i >= 0; i--) {
					if (this.common_dimensions[i][0] > page_w || this.common_dimensions[i][1] > page_h) {
						//browser size is too small
						continue;
					}
					_config2.default.WIDTH = parseInt(this.common_dimensions[i][0]);
					_config2.default.HEIGHT = parseInt(this.common_dimensions[i][1]);
					auto_size = true;
					break;
				}

				if (auto_size == false) {
					//screen size is smaller then 400x300
					_config2.default.WIDTH = parseInt(page_w) - 5;
					_config2.default.HEIGHT = parseInt(page_h) - 10;
					if (page_w < 585) {
						_config2.default.HEIGHT = _config2.default.HEIGHT - 15;
					}
				}
			}
		}
	}, {
		key: 'render_canvas_background',
		value: function render_canvas_background(canvas_id, gap) {
			if (gap == undefined) gap = 10;

			var target = document.getElementById(canvas_id + '_background');

			if (_config2.default.TRANSPARENCY == false) {
				target.className = 'transparent-grid white';
				return false;
			} else {
				target.className = 'transparent-grid ' + _config2.default.TRANSPARENCY_TYPE;
			}
			target.style.backgroundSize = gap * 2 + 'px auto';
		}
	}, {
		key: 'draw_grid',
		value: function draw_grid(ctx) {
			if (this.grid == false) return;

			var gap_x = this.grid_size[0];
			var gap_y = this.grid_size[1];

			var width = _config2.default.WIDTH;
			;
			var height = _config2.default.HEIGHT;

			//size
			if (gap_x != undefined && gap_y != undefined) this.grid_size = [gap_x, gap_y];else {
				gap_x = this.grid_size[0];
				gap_y = this.grid_size[1];
			}
			gap_x = parseInt(gap_x);
			gap_y = parseInt(gap_y);
			ctx.lineWidth = 1;
			ctx.beginPath();
			if (gap_x < 2) gap_x = 2;
			if (gap_y < 2) gap_y = 2;
			for (var i = gap_x; i < width; i = i + gap_x) {
				if (gap_x == 0) break;
				if (i % (gap_x * 5) == 0) {
					//main lines
					ctx.strokeStyle = '#222222';
				} else {
					//small lines
					ctx.strokeStyle = '#bbbbbb';
				}
				ctx.beginPath();
				ctx.moveTo(0.5 + i, 0);
				ctx.lineTo(0.5 + i, height);
				ctx.stroke();
			}
			for (var i = gap_y; i < height; i = i + gap_y) {
				if (gap_y == 0) break;
				if (i % (gap_y * 5) == 0) {
					//main lines
					ctx.strokeStyle = '#222222';
				} else {
					//small lines
					ctx.strokeStyle = '#bbbbbb';
				}
				ctx.beginPath();
				ctx.moveTo(0, 0.5 + i);
				ctx.lineTo(width, 0.5 + i);
				ctx.stroke();
			}
		}
	}]);

	return Base_gui_class;
}();

exports.default = Base_gui_class;

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _popup = __webpack_require__(3);

var _popup2 = _interopRequireDefault(_popup);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _helpers = __webpack_require__(4);

var _helpers2 = _interopRequireDefault(_helpers);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Effects_common_class = function () {
	function Effects_common_class() {
		_classCallCheck(this, Effects_common_class);

		this.POP = new _popup2.default();
		this.Base_layers = new _baseLayers2.default();
		this.Helper = new _helpers2.default();
		this.params = null;
	}

	_createClass(Effects_common_class, [{
		key: 'show_dialog',
		value: function show_dialog(type, params) {
			var _this = this;
			var title = this.Helper.ucfirst(type);
			title = title.replace(/-/g, ' ');
			if (type == 'shadow') type = 'drop-shadow';

			var settings = {
				title: title,
				preview: true,
				effects: true,
				params: params,
				on_change: function on_change(params, canvas_preview, w, h) {
					_this.params = params;
					canvas_preview.filter = _this.preview(params, type);
					canvas_preview.drawImage(this.layer_active_small, 0, 0);
				},
				on_finish: function on_finish(params) {

					window.State.save();
					_this.params = params;
					_this.save(params, type);
				}
			};
			this.POP.show(settings);
		}
	}, {
		key: 'save',
		value: function save(params, type) {
			params.value = this.convert_value(params.value, params, 'save');

			this.Base_layers.add_filter(null, type, params);
		}
	}, {
		key: 'preview',
		value: function preview(params, type) {
			var value = this.convert_value(params.value, params, 'preview');
			return type + "(" + value + ")";
		}
	}, {
		key: 'convert_value',
		value: function convert_value(value, params) {
			return value;
		}
	}]);

	return Effects_common_class;
}();

exports.default = Effects_common_class;

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
/*
 * glfx.js
 * http://evanw.github.com/glfx.js/
 *
 * Copyright 2011 Evan Wallace
 * Released under the MIT license
 */
var fx = function () {
  function q(a, d, c) {
    return Math.max(a, Math.min(d, c));
  }function w(b) {
    return { _: b, loadContentsOf: function loadContentsOf(b) {
        a = this._.gl;this._.loadContentsOf(b);
      }, destroy: function destroy() {
        a = this._.gl;this._.destroy();
      } };
  }function A(a) {
    return w(r.fromElement(a));
  }function B(b, d) {
    var c = a.UNSIGNED_BYTE;if (a.getExtension("OES_texture_float") && a.getExtension("OES_texture_float_linear")) {
      var e = new r(100, 100, a.RGBA, a.FLOAT);try {
        e.drawTo(function () {
          c = a.FLOAT;
        });
      } catch (g) {}e.destroy();
    }this._.texture && this._.texture.destroy();
    this._.spareTexture && this._.spareTexture.destroy();this.width = b;this.height = d;this._.texture = new r(b, d, a.RGBA, c);this._.spareTexture = new r(b, d, a.RGBA, c);this._.extraTexture = this._.extraTexture || new r(0, 0, a.RGBA, c);this._.flippedShader = this._.flippedShader || new h(null, "uniform sampler2D texture;varying vec2 texCoord;void main(){gl_FragColor=texture2D(texture,vec2(texCoord.x,1.0-texCoord.y));}");this._.isInitialized = !0;
  }function C(a, d, c) {
    this._.isInitialized && a._.width == this.width && a._.height == this.height || B.call(this, d ? d : a._.width, c ? c : a._.height);a._.use();this._.texture.drawTo(function () {
      h.getDefaultShader().drawRect();
    });return this;
  }function D() {
    this._.texture.use();this._.flippedShader.drawRect();return this;
  }function f(a, d, c, e) {
    (c || this._.texture).use();this._.spareTexture.drawTo(function () {
      a.uniforms(d).drawRect();
    });this._.spareTexture.swapWith(e || this._.texture);
  }function E(a) {
    a.parentNode.insertBefore(this, a);a.parentNode.removeChild(a);return this;
  }
  function F() {
    var b = new r(this._.texture.width, this._.texture.height, a.RGBA, a.UNSIGNED_BYTE);this._.texture.use();b.drawTo(function () {
      h.getDefaultShader().drawRect();
    });return w(b);
  }function G() {
    var b = this._.texture.width,
        d = this._.texture.height,
        c = new Uint8Array(4 * b * d);this._.texture.drawTo(function () {
      a.readPixels(0, 0, b, d, a.RGBA, a.UNSIGNED_BYTE, c);
    });return c;
  }function k(b) {
    return function () {
      a = this._.gl;return b.apply(this, arguments);
    };
  }function x(a, d, c, e, g, l, n, p) {
    var m = c - g,
        h = e - l,
        f = n - g,
        k = p - l;g = a - c + g - n;l = d - e + l - p;var q = m * k - f * h,
        f = (g * k - f * l) / q,
        m = (m * l - g * h) / q;return [c - a + f * c, e - d + f * e, f, n - a + m * n, p - d + m * p, m, a, d, 1];
  }function y(a) {
    var d = a[0],
        c = a[1],
        e = a[2],
        g = a[3],
        l = a[4],
        n = a[5],
        p = a[6],
        m = a[7];a = a[8];var f = d * l * a - d * n * m - c * g * a + c * n * p + e * g * m - e * l * p;return [(l * a - n * m) / f, (e * m - c * a) / f, (c * n - e * l) / f, (n * p - g * a) / f, (d * a - e * p) / f, (e * g - d * n) / f, (g * m - l * p) / f, (c * p - d * m) / f, (d * l - c * g) / f];
  }function z(a) {
    var d = a.length;this.xa = [];this.ya = [];this.u = [];this.y2 = [];a.sort(function (a, b) {
      return a[0] - b[0];
    });for (var c = 0; c < d; c++) {
      this.xa.push(a[c][0]), this.ya.push(a[c][1]);
    }this.u[0] = 0;this.y2[0] = 0;for (c = 1; c < d - 1; ++c) {
      a = this.xa[c + 1] - this.xa[c - 1];var e = (this.xa[c] - this.xa[c - 1]) / a,
          g = e * this.y2[c - 1] + 2;this.y2[c] = (e - 1) / g;this.u[c] = (6 * ((this.ya[c + 1] - this.ya[c]) / (this.xa[c + 1] - this.xa[c]) - (this.ya[c] - this.ya[c - 1]) / (this.xa[c] - this.xa[c - 1])) / a - e * this.u[c - 1]) / g;
    }this.y2[d - 1] = 0;for (c = d - 2; 0 <= c; --c) {
      this.y2[c] = this.y2[c] * this.y2[c + 1] + this.u[c];
    }
  }function u(a, d) {
    return new h(null, a + "uniform sampler2D texture;uniform vec2 texSize;varying vec2 texCoord;void main(){vec2 coord=texCoord*texSize;" + d + "gl_FragColor=texture2D(texture,coord/texSize);vec2 clampedCoord=clamp(coord,vec2(0.0),texSize);if(coord!=clampedCoord){gl_FragColor.a*=max(0.0,1.0-length(coord-clampedCoord));}}");
  }function H(b, d) {
    a.brightnessContrast = a.brightnessContrast || new h(null, "uniform sampler2D texture;uniform float brightness;uniform float contrast;varying vec2 texCoord;void main(){vec4 color=texture2D(texture,texCoord);color.rgb+=brightness;if(contrast>0.0){color.rgb=(color.rgb-0.5)/(1.0-contrast)+0.5;}else{color.rgb=(color.rgb-0.5)*(1.0+contrast)+0.5;}gl_FragColor=color;}");
    f.call(this, a.brightnessContrast, { brightness: q(-1, b, 1), contrast: q(-1, d, 1) });return this;
  }function t(a) {
    a = new z(a);for (var d = [], c = 0; 256 > c; c++) {
      d.push(q(0, Math.floor(256 * a.interpolate(c / 255)), 255));
    }return d;
  }function I(b, d, c) {
    b = t(b);1 == arguments.length ? d = c = b : (d = t(d), c = t(c));for (var e = [], g = 0; 256 > g; g++) {
      e.splice(e.length, 0, b[g], d[g], c[g], 255);
    }this._.extraTexture.initFromBytes(256, 1, e);this._.extraTexture.use(1);a.curves = a.curves || new h(null, "uniform sampler2D texture;uniform sampler2D map;varying vec2 texCoord;void main(){vec4 color=texture2D(texture,texCoord);color.r=texture2D(map,vec2(color.r)).r;color.g=texture2D(map,vec2(color.g)).g;color.b=texture2D(map,vec2(color.b)).b;gl_FragColor=color;}");
    a.curves.textures({ map: 1 });f.call(this, a.curves, {});return this;
  }function J(b) {
    a.denoise = a.denoise || new h(null, "uniform sampler2D texture;uniform float exponent;uniform float strength;uniform vec2 texSize;varying vec2 texCoord;void main(){vec4 center=texture2D(texture,texCoord);vec4 color=vec4(0.0);float total=0.0;for(float x=-4.0;x<=4.0;x+=1.0){for(float y=-4.0;y<=4.0;y+=1.0){vec4 sample=texture2D(texture,texCoord+vec2(x,y)/texSize);float weight=1.0-abs(dot(sample.rgb-center.rgb,vec3(0.25)));weight=pow(weight,exponent);color+=sample*weight;total+=weight;}}gl_FragColor=color/total;}");
    for (var d = 0; 2 > d; d++) {
      f.call(this, a.denoise, { exponent: Math.max(0, b), texSize: [this.width, this.height] });
    }return this;
  }function K(b, d) {
    a.hueSaturation = a.hueSaturation || new h(null, "uniform sampler2D texture;uniform float hue;uniform float saturation;varying vec2 texCoord;void main(){vec4 color=texture2D(texture,texCoord);float angle=hue*3.14159265;float s=sin(angle),c=cos(angle);vec3 weights=(vec3(2.0*c,-sqrt(3.0)*s-c,sqrt(3.0)*s-c)+1.0)/3.0;float len=length(color.rgb);color.rgb=vec3(dot(color.rgb,weights.xyz),dot(color.rgb,weights.zxy),dot(color.rgb,weights.yzx));float average=(color.r+color.g+color.b)/3.0;if(saturation>0.0){color.rgb+=(average-color.rgb)*(1.0-1.0/(1.001-saturation));}else{color.rgb+=(average-color.rgb)*(-saturation);}gl_FragColor=color;}");
    f.call(this, a.hueSaturation, { hue: q(-1, b, 1), saturation: q(-1, d, 1) });return this;
  }function L(b) {
    a.noise = a.noise || new h(null, "uniform sampler2D texture;uniform float amount;varying vec2 texCoord;float rand(vec2 co){return fract(sin(dot(co.xy,vec2(12.9898,78.233)))*43758.5453);}void main(){vec4 color=texture2D(texture,texCoord);float diff=(rand(texCoord)-0.5)*amount;color.r+=diff;color.g+=diff;color.b+=diff;gl_FragColor=color;}");
    f.call(this, a.noise, { amount: q(0, b, 1) });return this;
  }function M(b) {
    a.sepia = a.sepia || new h(null, "uniform sampler2D texture;uniform float amount;varying vec2 texCoord;void main(){vec4 color=texture2D(texture,texCoord);float r=color.r;float g=color.g;float b=color.b;color.r=min(1.0,(r*(1.0-(0.607*amount)))+(g*(0.769*amount))+(b*(0.189*amount)));color.g=min(1.0,(r*0.349*amount)+(g*(1.0-(0.314*amount)))+(b*0.168*amount));color.b=min(1.0,(r*0.272*amount)+(g*0.534*amount)+(b*(1.0-(0.869*amount))));gl_FragColor=color;}");
    f.call(this, a.sepia, { amount: q(0, b, 1) });return this;
  }function N(b, d) {
    a.unsharpMask = a.unsharpMask || new h(null, "uniform sampler2D blurredTexture;uniform sampler2D originalTexture;uniform float strength;uniform float threshold;varying vec2 texCoord;void main(){vec4 blurred=texture2D(blurredTexture,texCoord);vec4 original=texture2D(originalTexture,texCoord);gl_FragColor=mix(blurred,original,1.0+strength);}");
    this._.extraTexture.ensureFormat(this._.texture);this._.texture.use();this._.extraTexture.drawTo(function () {
      h.getDefaultShader().drawRect();
    });this._.extraTexture.use(1);this.triangleBlur(b);a.unsharpMask.textures({ originalTexture: 1 });f.call(this, a.unsharpMask, { strength: d });this._.extraTexture.unuse(1);return this;
  }function O(b) {
    a.vibrance = a.vibrance || new h(null, "uniform sampler2D texture;uniform float amount;varying vec2 texCoord;void main(){vec4 color=texture2D(texture,texCoord);float average=(color.r+color.g+color.b)/3.0;float mx=max(color.r,max(color.g,color.b));float amt=(mx-average)*(-amount*3.0);color.rgb=mix(color.rgb,vec3(mx),amt);gl_FragColor=color;}");
    f.call(this, a.vibrance, { amount: q(-1, b, 1) });return this;
  }function P(b, d) {
    a.vignette = a.vignette || new h(null, "uniform sampler2D texture;uniform float size;uniform float amount;varying vec2 texCoord;void main(){vec4 color=texture2D(texture,texCoord);float dist=distance(texCoord,vec2(0.5,0.5));color.rgb*=smoothstep(0.8,size*0.799,dist*(amount+size));gl_FragColor=color;}");
    f.call(this, a.vignette, { size: q(0, b, 1), amount: q(0, d, 1) });return this;
  }function Q(b, d, c) {
    a.lensBlurPrePass = a.lensBlurPrePass || new h(null, "uniform sampler2D texture;uniform float power;varying vec2 texCoord;void main(){vec4 color=texture2D(texture,texCoord);color=pow(color,vec4(power));gl_FragColor=vec4(color);}");var e = "uniform sampler2D texture0;uniform sampler2D texture1;uniform vec2 delta0;uniform vec2 delta1;uniform float power;varying vec2 texCoord;" + s + "vec4 sample(vec2 delta){float offset=random(vec3(delta,151.7182),0.0);vec4 color=vec4(0.0);float total=0.0;for(float t=0.0;t<=30.0;t++){float percent=(t+offset)/30.0;color+=texture2D(texture0,texCoord+delta*percent);total+=1.0;}return color/total;}";
    a.lensBlur0 = a.lensBlur0 || new h(null, e + "void main(){gl_FragColor=sample(delta0);}");a.lensBlur1 = a.lensBlur1 || new h(null, e + "void main(){gl_FragColor=(sample(delta0)+sample(delta1))*0.5;}");a.lensBlur2 = a.lensBlur2 || new h(null, e + "void main(){vec4 color=(sample(delta0)+2.0*texture2D(texture1,texCoord))/3.0;gl_FragColor=pow(color,vec4(power));}").textures({ texture1: 1 });for (var e = [], g = 0; 3 > g; g++) {
      var l = c + 2 * g * Math.PI / 3;e.push([b * Math.sin(l) / this.width, b * Math.cos(l) / this.height]);
    }b = Math.pow(10, q(-1, d, 1));f.call(this, a.lensBlurPrePass, { power: b });this._.extraTexture.ensureFormat(this._.texture);f.call(this, a.lensBlur0, { delta0: e[0] }, this._.texture, this._.extraTexture);f.call(this, a.lensBlur1, { delta0: e[1], delta1: e[2] }, this._.extraTexture, this._.extraTexture);f.call(this, a.lensBlur0, { delta0: e[1] });this._.extraTexture.use(1);f.call(this, a.lensBlur2, { power: 1 / b, delta0: e[2] });return this;
  }
  function R(b, d, c, e, g, l) {
    a.tiltShift = a.tiltShift || new h(null, "uniform sampler2D texture;uniform float blurRadius;uniform float gradientRadius;uniform vec2 start;uniform vec2 end;uniform vec2 delta;uniform vec2 texSize;varying vec2 texCoord;" + s + "void main(){vec4 color=vec4(0.0);float total=0.0;float offset=random(vec3(12.9898,78.233,151.7182),0.0);vec2 normal=normalize(vec2(start.y-end.y,end.x-start.x));float radius=smoothstep(0.0,1.0,abs(dot(texCoord*texSize-start,normal))/gradientRadius)*blurRadius;for(float t=-30.0;t<=30.0;t++){float percent=(t+offset-0.5)/30.0;float weight=1.0-abs(percent);vec4 sample=texture2D(texture,texCoord+delta/texSize*percent*radius);sample.rgb*=sample.a;color+=sample*weight;total+=weight;}gl_FragColor=color/total;gl_FragColor.rgb/=gl_FragColor.a+0.00001;}");
    var n = c - b,
        p = e - d,
        m = Math.sqrt(n * n + p * p);f.call(this, a.tiltShift, { blurRadius: g, gradientRadius: l, start: [b, d], end: [c, e], delta: [n / m, p / m], texSize: [this.width, this.height] });f.call(this, a.tiltShift, { blurRadius: g, gradientRadius: l, start: [b, d], end: [c, e], delta: [-p / m, n / m], texSize: [this.width, this.height] });return this;
  }function S(b) {
    a.triangleBlur = a.triangleBlur || new h(null, "uniform sampler2D texture;uniform vec2 delta;varying vec2 texCoord;" + s + "void main(){vec4 color=vec4(0.0);float total=0.0;float offset=random(vec3(12.9898,78.233,151.7182),0.0);for(float t=-30.0;t<=30.0;t++){float percent=(t+offset-0.5)/30.0;float weight=1.0-abs(percent);vec4 sample=texture2D(texture,texCoord+delta*percent);sample.rgb*=sample.a;color+=sample*weight;total+=weight;}gl_FragColor=color/total;gl_FragColor.rgb/=gl_FragColor.a+0.00001;}");
    f.call(this, a.triangleBlur, { delta: [b / this.width, 0] });f.call(this, a.triangleBlur, { delta: [0, b / this.height] });return this;
  }function T(b, d, c) {
    a.zoomBlur = a.zoomBlur || new h(null, "uniform sampler2D texture;uniform vec2 center;uniform float strength;uniform vec2 texSize;varying vec2 texCoord;" + s + "void main(){vec4 color=vec4(0.0);float total=0.0;vec2 toCenter=center-texCoord*texSize;float offset=random(vec3(12.9898,78.233,151.7182),0.0);for(float t=0.0;t<=40.0;t++){float percent=(t+offset)/40.0;float weight=4.0*(percent-percent*percent);vec4 sample=texture2D(texture,texCoord+toCenter*percent*strength/texSize);sample.rgb*=sample.a;color+=sample*weight;total+=weight;}gl_FragColor=color/total;gl_FragColor.rgb/=gl_FragColor.a+0.00001;}");
    f.call(this, a.zoomBlur, { center: [b, d], strength: c, texSize: [this.width, this.height] });return this;
  }function U(b, d, c, e) {
    a.colorHalftone = a.colorHalftone || new h(null, "uniform sampler2D texture;uniform vec2 center;uniform float angle;uniform float scale;uniform vec2 texSize;varying vec2 texCoord;float pattern(float angle){float s=sin(angle),c=cos(angle);vec2 tex=texCoord*texSize-center;vec2 point=vec2(c*tex.x-s*tex.y,s*tex.x+c*tex.y)*scale;return(sin(point.x)*sin(point.y))*4.0;}void main(){vec4 color=texture2D(texture,texCoord);vec3 cmy=1.0-color.rgb;float k=min(cmy.x,min(cmy.y,cmy.z));cmy=(cmy-k)/(1.0-k);cmy=clamp(cmy*10.0-3.0+vec3(pattern(angle+0.26179),pattern(angle+1.30899),pattern(angle)),0.0,1.0);k=clamp(k*10.0-5.0+pattern(angle+0.78539),0.0,1.0);gl_FragColor=vec4(1.0-cmy-k,color.a);}");
    f.call(this, a.colorHalftone, { center: [b, d], angle: c, scale: Math.PI / e, texSize: [this.width, this.height] });return this;
  }function V(b, d, c, e) {
    a.dotScreen = a.dotScreen || new h(null, "uniform sampler2D texture;uniform vec2 center;uniform float angle;uniform float scale;uniform vec2 texSize;varying vec2 texCoord;float pattern(){float s=sin(angle),c=cos(angle);vec2 tex=texCoord*texSize-center;vec2 point=vec2(c*tex.x-s*tex.y,s*tex.x+c*tex.y)*scale;return(sin(point.x)*sin(point.y))*4.0;}void main(){vec4 color=texture2D(texture,texCoord);float average=(color.r+color.g+color.b)/3.0;gl_FragColor=vec4(vec3(average*10.0-5.0+pattern()),color.a);}");
    f.call(this, a.dotScreen, { center: [b, d], angle: c, scale: Math.PI / e, texSize: [this.width, this.height] });return this;
  }function W(b) {
    a.edgeWork1 = a.edgeWork1 || new h(null, "uniform sampler2D texture;uniform vec2 delta;varying vec2 texCoord;" + s + "void main(){vec2 color=vec2(0.0);vec2 total=vec2(0.0);float offset=random(vec3(12.9898,78.233,151.7182),0.0);for(float t=-30.0;t<=30.0;t++){float percent=(t+offset-0.5)/30.0;float weight=1.0-abs(percent);vec3 sample=texture2D(texture,texCoord+delta*percent).rgb;float average=(sample.r+sample.g+sample.b)/3.0;color.x+=average*weight;total.x+=weight;if(abs(t)<15.0){weight=weight*2.0-1.0;color.y+=average*weight;total.y+=weight;}}gl_FragColor=vec4(color/total,0.0,1.0);}");
    a.edgeWork2 = a.edgeWork2 || new h(null, "uniform sampler2D texture;uniform vec2 delta;varying vec2 texCoord;" + s + "void main(){vec2 color=vec2(0.0);vec2 total=vec2(0.0);float offset=random(vec3(12.9898,78.233,151.7182),0.0);for(float t=-30.0;t<=30.0;t++){float percent=(t+offset-0.5)/30.0;float weight=1.0-abs(percent);vec2 sample=texture2D(texture,texCoord+delta*percent).xy;color.x+=sample.x*weight;total.x+=weight;if(abs(t)<15.0){weight=weight*2.0-1.0;color.y+=sample.y*weight;total.y+=weight;}}float c=clamp(10000.0*(color.y/total.y-color.x/total.x)+0.5,0.0,1.0);gl_FragColor=vec4(c,c,c,1.0);}");
    f.call(this, a.edgeWork1, { delta: [b / this.width, 0] });f.call(this, a.edgeWork2, { delta: [0, b / this.height] });return this;
  }function X(b, d, c) {
    a.hexagonalPixelate = a.hexagonalPixelate || new h(null, "uniform sampler2D texture;uniform vec2 center;uniform float scale;uniform vec2 texSize;varying vec2 texCoord;void main(){vec2 tex=(texCoord*texSize-center)/scale;tex.y/=0.866025404;tex.x-=tex.y*0.5;vec2 a;if(tex.x+tex.y-floor(tex.x)-floor(tex.y)<1.0)a=vec2(floor(tex.x),floor(tex.y));else a=vec2(ceil(tex.x),ceil(tex.y));vec2 b=vec2(ceil(tex.x),floor(tex.y));vec2 c=vec2(floor(tex.x),ceil(tex.y));vec3 TEX=vec3(tex.x,tex.y,1.0-tex.x-tex.y);vec3 A=vec3(a.x,a.y,1.0-a.x-a.y);vec3 B=vec3(b.x,b.y,1.0-b.x-b.y);vec3 C=vec3(c.x,c.y,1.0-c.x-c.y);float alen=length(TEX-A);float blen=length(TEX-B);float clen=length(TEX-C);vec2 choice;if(alen<blen){if(alen<clen)choice=a;else choice=c;}else{if(blen<clen)choice=b;else choice=c;}choice.x+=choice.y*0.5;choice.y*=0.866025404;choice*=scale/texSize;gl_FragColor=texture2D(texture,choice+center/texSize);}");
    f.call(this, a.hexagonalPixelate, { center: [b, d], scale: c, texSize: [this.width, this.height] });return this;
  }function Y(b) {
    a.ink = a.ink || new h(null, "uniform sampler2D texture;uniform float strength;uniform vec2 texSize;varying vec2 texCoord;void main(){vec2 dx=vec2(1.0/texSize.x,0.0);vec2 dy=vec2(0.0,1.0/texSize.y);vec4 color=texture2D(texture,texCoord);float bigTotal=0.0;float smallTotal=0.0;vec3 bigAverage=vec3(0.0);vec3 smallAverage=vec3(0.0);for(float x=-2.0;x<=2.0;x+=1.0){for(float y=-2.0;y<=2.0;y+=1.0){vec3 sample=texture2D(texture,texCoord+dx*x+dy*y).rgb;bigAverage+=sample;bigTotal+=1.0;if(abs(x)+abs(y)<2.0){smallAverage+=sample;smallTotal+=1.0;}}}vec3 edge=max(vec3(0.0),bigAverage/bigTotal-smallAverage/smallTotal);gl_FragColor=vec4(color.rgb-dot(edge,edge)*strength*100000.0,color.a);}");
    f.call(this, a.ink, { strength: b * b * b * b * b, texSize: [this.width, this.height] });return this;
  }function Z(b, d, c, e) {
    a.bulgePinch = a.bulgePinch || u("uniform float radius;uniform float strength;uniform vec2 center;", "coord-=center;float distance=length(coord);if(distance<radius){float percent=distance/radius;if(strength>0.0){coord*=mix(1.0,smoothstep(0.0,radius/distance,percent),strength*0.75);}else{coord*=mix(1.0,pow(percent,1.0+strength*0.75)*radius/distance,1.0-percent);}}coord+=center;");
    f.call(this, a.bulgePinch, { radius: c, strength: q(-1, e, 1), center: [b, d], texSize: [this.width, this.height] });return this;
  }function $(b, d, c) {
    a.matrixWarp = a.matrixWarp || u("uniform mat3 matrix;uniform bool useTextureSpace;", "if(useTextureSpace)coord=coord/texSize*2.0-1.0;vec3 warp=matrix*vec3(coord,1.0);coord=warp.xy/warp.z;if(useTextureSpace)coord=(coord*0.5+0.5)*texSize;");b = Array.prototype.concat.apply([], b);if (4 == b.length) b = [b[0], b[1], 0, b[2], b[3], 0, 0, 0, 1];else if (9 != b.length) throw "can only warp with 2x2 or 3x3 matrix";f.call(this, a.matrixWarp, { matrix: d ? y(b) : b, texSize: [this.width, this.height], useTextureSpace: c | 0 });return this;
  }function aa(a, d) {
    var c = x.apply(null, d),
        e = x.apply(null, a),
        c = y(c);return this.matrixWarp([c[0] * e[0] + c[1] * e[3] + c[2] * e[6], c[0] * e[1] + c[1] * e[4] + c[2] * e[7], c[0] * e[2] + c[1] * e[5] + c[2] * e[8], c[3] * e[0] + c[4] * e[3] + c[5] * e[6], c[3] * e[1] + c[4] * e[4] + c[5] * e[7], c[3] * e[2] + c[4] * e[5] + c[5] * e[8], c[6] * e[0] + c[7] * e[3] + c[8] * e[6], c[6] * e[1] + c[7] * e[4] + c[8] * e[7], c[6] * e[2] + c[7] * e[5] + c[8] * e[8]]);
  }function ba(b, d, c, e) {
    a.swirl = a.swirl || u("uniform float radius;uniform float angle;uniform vec2 center;", "coord-=center;float distance=length(coord);if(distance<radius){float percent=(radius-distance)/radius;float theta=percent*percent*angle;float s=sin(theta);float c=cos(theta);coord=vec2(coord.x*c-coord.y*s,coord.x*s+coord.y*c);}coord+=center;");
    f.call(this, a.swirl, { radius: c, center: [b, d], angle: e, texSize: [this.width, this.height] });return this;
  }var v = {};(function () {
    function a(b) {
      if (!b.getExtension("OES_texture_float")) return !1;var c = b.createFramebuffer(),
          e = b.createTexture();b.bindTexture(b.TEXTURE_2D, e);b.texParameteri(b.TEXTURE_2D, b.TEXTURE_MAG_FILTER, b.NEAREST);b.texParameteri(b.TEXTURE_2D, b.TEXTURE_MIN_FILTER, b.NEAREST);b.texParameteri(b.TEXTURE_2D, b.TEXTURE_WRAP_S, b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_2D, b.TEXTURE_WRAP_T, b.CLAMP_TO_EDGE);
      b.texImage2D(b.TEXTURE_2D, 0, b.RGBA, 1, 1, 0, b.RGBA, b.UNSIGNED_BYTE, null);b.bindFramebuffer(b.FRAMEBUFFER, c);b.framebufferTexture2D(b.FRAMEBUFFER, b.COLOR_ATTACHMENT0, b.TEXTURE_2D, e, 0);c = b.createTexture();b.bindTexture(b.TEXTURE_2D, c);b.texParameteri(b.TEXTURE_2D, b.TEXTURE_MAG_FILTER, b.LINEAR);b.texParameteri(b.TEXTURE_2D, b.TEXTURE_MIN_FILTER, b.LINEAR);b.texParameteri(b.TEXTURE_2D, b.TEXTURE_WRAP_S, b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_2D, b.TEXTURE_WRAP_T, b.CLAMP_TO_EDGE);b.texImage2D(b.TEXTURE_2D, 0, b.RGBA, 2, 2, 0, b.RGBA, b.FLOAT, new Float32Array([2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]));var e = b.createProgram(),
          d = b.createShader(b.VERTEX_SHADER),
          g = b.createShader(b.FRAGMENT_SHADER);b.shaderSource(d, "attribute vec2 vertex;void main(){gl_Position=vec4(vertex,0.0,1.0);}");b.shaderSource(g, "uniform sampler2D texture;void main(){gl_FragColor=texture2D(texture,vec2(0.5));}");b.compileShader(d);b.compileShader(g);b.attachShader(e, d);b.attachShader(e, g);b.linkProgram(e);d = b.createBuffer();b.bindBuffer(b.ARRAY_BUFFER, d);b.bufferData(b.ARRAY_BUFFER, new Float32Array([0, 0]), b.STREAM_DRAW);b.enableVertexAttribArray(0);b.vertexAttribPointer(0, 2, b.FLOAT, !1, 0, 0);d = new Uint8Array(4);b.useProgram(e);b.viewport(0, 0, 1, 1);b.bindTexture(b.TEXTURE_2D, c);b.drawArrays(b.POINTS, 0, 1);b.readPixels(0, 0, 1, 1, b.RGBA, b.UNSIGNED_BYTE, d);return 127 === d[0] || 128 === d[0];
    }function d() {}function c(a) {
      "OES_texture_float_linear" === a ? (void 0 === this.$OES_texture_float_linear$ && Object.defineProperty(this, "$OES_texture_float_linear$", { enumerable: !1, configurable: !1, writable: !1, value: new d() }), a = this.$OES_texture_float_linear$) : a = n.call(this, a);return a;
    }function e() {
      var a = f.call(this);-1 === a.indexOf("OES_texture_float_linear") && a.push("OES_texture_float_linear");return a;
    }try {
      var g = document.createElement("canvas").getContext("experimental-webgl");
    } catch (l) {}if (g && -1 === g.getSupportedExtensions().indexOf("OES_texture_float_linear") && a(g)) {
      var n = WebGLRenderingContext.prototype.getExtension,
          f = WebGLRenderingContext.prototype.getSupportedExtensions;
      WebGLRenderingContext.prototype.getExtension = c;WebGLRenderingContext.prototype.getSupportedExtensions = e;
    }
  })();var a;v.canvas = function () {
    var b = document.createElement("canvas");try {
      a = b.getContext("experimental-webgl", { premultipliedAlpha: !1 });
    } catch (d) {
      a = null;
    }if (!a) throw "This browser does not support WebGL";b._ = { gl: a, isInitialized: !1, texture: null, spareTexture: null, flippedShader: null };b.texture = k(A);b.draw = k(C);b.update = k(D);b.replace = k(E);b.contents = k(F);b.getPixelArray = k(G);b.brightnessContrast = k(H);
    b.hexagonalPixelate = k(X);b.hueSaturation = k(K);b.colorHalftone = k(U);b.triangleBlur = k(S);b.unsharpMask = k(N);b.perspective = k(aa);b.matrixWarp = k($);b.bulgePinch = k(Z);b.tiltShift = k(R);b.dotScreen = k(V);b.edgeWork = k(W);b.lensBlur = k(Q);b.zoomBlur = k(T);b.noise = k(L);b.denoise = k(J);b.curves = k(I);b.swirl = k(ba);b.ink = k(Y);b.vignette = k(P);b.vibrance = k(O);b.sepia = k(M);return b;
  };v.splineInterpolate = t;var h = function () {
    function b(b, c) {
      var e = a.createShader(b);a.shaderSource(e, c);a.compileShader(e);if (!a.getShaderParameter(e, a.COMPILE_STATUS)) throw "compile error: " + a.getShaderInfoLog(e);return e;
    }function d(d, l) {
      this.texCoordAttribute = this.vertexAttribute = null;this.program = a.createProgram();d = d || c;l = l || e;l = "precision highp float;" + l;a.attachShader(this.program, b(a.VERTEX_SHADER, d));a.attachShader(this.program, b(a.FRAGMENT_SHADER, l));a.linkProgram(this.program);if (!a.getProgramParameter(this.program, a.LINK_STATUS)) throw "link error: " + a.getProgramInfoLog(this.program);
    }var c = "attribute vec2 vertex;attribute vec2 _texCoord;varying vec2 texCoord;void main(){texCoord=_texCoord;gl_Position=vec4(vertex*2.0-1.0,0.0,1.0);}",
        e = "uniform sampler2D texture;varying vec2 texCoord;void main(){gl_FragColor=texture2D(texture,texCoord);}";d.prototype.destroy = function () {
      a.deleteProgram(this.program);this.program = null;
    };d.prototype.uniforms = function (b) {
      a.useProgram(this.program);for (var e in b) {
        if (b.hasOwnProperty(e)) {
          var c = a.getUniformLocation(this.program, e);if (null !== c) {
            var d = b[e];if ("[object Array]" == Object.prototype.toString.call(d)) switch (d.length) {case 1:
                a.uniform1fv(c, new Float32Array(d));break;
              case 2:
                a.uniform2fv(c, new Float32Array(d));break;case 3:
                a.uniform3fv(c, new Float32Array(d));break;case 4:
                a.uniform4fv(c, new Float32Array(d));break;case 9:
                a.uniformMatrix3fv(c, !1, new Float32Array(d));break;case 16:
                a.uniformMatrix4fv(c, !1, new Float32Array(d));break;default:
                throw "dont't know how to load uniform \"" + e + '" of length ' + d.length;} else if ("[object Number]" == Object.prototype.toString.call(d)) a.uniform1f(c, d);else throw 'attempted to set uniform "' + e + '" to invalid value ' + (d || "undefined").toString();
          }
        }
      }return this;
    };d.prototype.textures = function (b) {
      a.useProgram(this.program);for (var c in b) {
        b.hasOwnProperty(c) && a.uniform1i(a.getUniformLocation(this.program, c), b[c]);
      }return this;
    };d.prototype.drawRect = function (b, c, e, d) {
      var f = a.getParameter(a.VIEWPORT);c = void 0 !== c ? (c - f[1]) / f[3] : 0;b = void 0 !== b ? (b - f[0]) / f[2] : 0;e = void 0 !== e ? (e - f[0]) / f[2] : 1;d = void 0 !== d ? (d - f[1]) / f[3] : 1;null == a.vertexBuffer && (a.vertexBuffer = a.createBuffer());a.bindBuffer(a.ARRAY_BUFFER, a.vertexBuffer);a.bufferData(a.ARRAY_BUFFER, new Float32Array([b, c, b, d, e, c, e, d]), a.STATIC_DRAW);null == a.texCoordBuffer && (a.texCoordBuffer = a.createBuffer(), a.bindBuffer(a.ARRAY_BUFFER, a.texCoordBuffer), a.bufferData(a.ARRAY_BUFFER, new Float32Array([0, 0, 0, 1, 1, 0, 1, 1]), a.STATIC_DRAW));null == this.vertexAttribute && (this.vertexAttribute = a.getAttribLocation(this.program, "vertex"), a.enableVertexAttribArray(this.vertexAttribute));null == this.texCoordAttribute && (this.texCoordAttribute = a.getAttribLocation(this.program, "_texCoord"), a.enableVertexAttribArray(this.texCoordAttribute));
      a.useProgram(this.program);a.bindBuffer(a.ARRAY_BUFFER, a.vertexBuffer);a.vertexAttribPointer(this.vertexAttribute, 2, a.FLOAT, !1, 0, 0);a.bindBuffer(a.ARRAY_BUFFER, a.texCoordBuffer);a.vertexAttribPointer(this.texCoordAttribute, 2, a.FLOAT, !1, 0, 0);a.drawArrays(a.TRIANGLE_STRIP, 0, 4);
    };d.getDefaultShader = function () {
      a.defaultShader = a.defaultShader || new d();return a.defaultShader;
    };return d;
  }();z.prototype.interpolate = function (a) {
    for (var d = 0, c = this.ya.length - 1; 1 < c - d;) {
      var e = c + d >> 1;this.xa[e] > a ? c = e : d = e;
    }var e = this.xa[c] - this.xa[d],
        g = (this.xa[c] - a) / e;a = (a - this.xa[d]) / e;return g * this.ya[d] + a * this.ya[c] + ((g * g * g - g) * this.y2[d] + (a * a * a - a) * this.y2[c]) * e * e / 6;
  };var r = function () {
    function b(b, c, d, f) {
      this.gl = a;this.id = a.createTexture();this.width = b;this.height = c;this.format = d;this.type = f;a.bindTexture(a.TEXTURE_2D, this.id);a.texParameteri(a.TEXTURE_2D, a.TEXTURE_MAG_FILTER, a.LINEAR);a.texParameteri(a.TEXTURE_2D, a.TEXTURE_MIN_FILTER, a.LINEAR);a.texParameteri(a.TEXTURE_2D, a.TEXTURE_WRAP_S, a.CLAMP_TO_EDGE);a.texParameteri(a.TEXTURE_2D, a.TEXTURE_WRAP_T, a.CLAMP_TO_EDGE);b && c && a.texImage2D(a.TEXTURE_2D, 0, this.format, b, c, 0, this.format, this.type, null);
    }function d(a) {
      null == c && (c = document.createElement("canvas"));c.width = a.width;c.height = a.height;a = c.getContext("2d");a.clearRect(0, 0, c.width, c.height);return a;
    }b.fromElement = function (c) {
      var d = new b(0, 0, a.RGBA, a.UNSIGNED_BYTE);d.loadContentsOf(c);return d;
    };b.prototype.loadContentsOf = function (b) {
      this.width = b.width || b.videoWidth;this.height = b.height || b.videoHeight;a.bindTexture(a.TEXTURE_2D, this.id);a.texImage2D(a.TEXTURE_2D, 0, this.format, this.format, this.type, b);
    };b.prototype.initFromBytes = function (b, c, d) {
      this.width = b;this.height = c;this.format = a.RGBA;this.type = a.UNSIGNED_BYTE;a.bindTexture(a.TEXTURE_2D, this.id);a.texImage2D(a.TEXTURE_2D, 0, a.RGBA, b, c, 0, a.RGBA, this.type, new Uint8Array(d));
    };b.prototype.destroy = function () {
      a.deleteTexture(this.id);this.id = null;
    };b.prototype.use = function (b) {
      a.activeTexture(a.TEXTURE0 + (b || 0));a.bindTexture(a.TEXTURE_2D, this.id);
    };b.prototype.unuse = function (b) {
      a.activeTexture(a.TEXTURE0 + (b || 0));a.bindTexture(a.TEXTURE_2D, null);
    };b.prototype.ensureFormat = function (b, c, d, f) {
      if (1 == arguments.length) {
        var h = arguments[0];b = h.width;c = h.height;d = h.format;f = h.type;
      }if (b != this.width || c != this.height || d != this.format || f != this.type) this.width = b, this.height = c, this.format = d, this.type = f, a.bindTexture(a.TEXTURE_2D, this.id), a.texImage2D(a.TEXTURE_2D, 0, this.format, b, c, 0, this.format, this.type, null);
    };b.prototype.drawTo = function (b) {
      a.framebuffer = a.framebuffer || a.createFramebuffer();a.bindFramebuffer(a.FRAMEBUFFER, a.framebuffer);a.framebufferTexture2D(a.FRAMEBUFFER, a.COLOR_ATTACHMENT0, a.TEXTURE_2D, this.id, 0);if (a.checkFramebufferStatus(a.FRAMEBUFFER) !== a.FRAMEBUFFER_COMPLETE) throw Error("incomplete framebuffer");a.viewport(0, 0, this.width, this.height);b();a.bindFramebuffer(a.FRAMEBUFFER, null);
    };var c = null;b.prototype.fillUsingCanvas = function (b) {
      b(d(this));this.format = a.RGBA;this.type = a.UNSIGNED_BYTE;a.bindTexture(a.TEXTURE_2D, this.id);a.texImage2D(a.TEXTURE_2D, 0, a.RGBA, a.RGBA, a.UNSIGNED_BYTE, c);return this;
    };
    b.prototype.toImage = function (b) {
      this.use();h.getDefaultShader().drawRect();var f = 4 * this.width * this.height,
          k = new Uint8Array(f),
          n = d(this),
          p = n.createImageData(this.width, this.height);a.readPixels(0, 0, this.width, this.height, a.RGBA, a.UNSIGNED_BYTE, k);for (var m = 0; m < f; m++) {
        p.data[m] = k[m];
      }n.putImageData(p, 0, 0);b.src = c.toDataURL();
    };b.prototype.swapWith = function (a) {
      var b;b = a.id;a.id = this.id;this.id = b;b = a.width;a.width = this.width;this.width = b;b = a.height;a.height = this.height;this.height = b;b = a.format;a.format = this.format;this.format = b;
    };return b;
  }(),
      s = "float random(vec3 scale,float seed){return fract(sin(dot(gl_FragCoord.xyz+seed,scale))*43758.5453+seed);}";return v;
}();

exports.default = fx;

/***/ }),
/* 10 */
/***/ (function(module, exports) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
module.exports = function(useSourceMap) {
	var list = [];

	// return the list of modules as css string
	list.toString = function toString() {
		return this.map(function (item) {
			var content = cssWithMappingToString(item, useSourceMap);
			if(item[2]) {
				return "@media " + item[2] + "{" + content + "}";
			} else {
				return content;
			}
		}).join("");
	};

	// import a list of modules into the list
	list.i = function(modules, mediaQuery) {
		if(typeof modules === "string")
			modules = [[null, modules, ""]];
		var alreadyImportedModules = {};
		for(var i = 0; i < this.length; i++) {
			var id = this[i][0];
			if(typeof id === "number")
				alreadyImportedModules[id] = true;
		}
		for(i = 0; i < modules.length; i++) {
			var item = modules[i];
			// skip already imported module
			// this implementation is not 100% perfect for weird media query combinations
			//  when a module is imported multiple times with different media queries.
			//  I hope this will never occur (Hey this way we have smaller bundles)
			if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
				if(mediaQuery && !item[2]) {
					item[2] = mediaQuery;
				} else if(mediaQuery) {
					item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
				}
				list.push(item);
			}
		}
	};
	return list;
};

function cssWithMappingToString(item, useSourceMap) {
	var content = item[1] || '';
	var cssMapping = item[3];
	if (!cssMapping) {
		return content;
	}

	if (useSourceMap && typeof btoa === 'function') {
		var sourceMapping = toComment(cssMapping);
		var sourceURLs = cssMapping.sources.map(function (source) {
			return '/*# sourceURL=' + cssMapping.sourceRoot + source + ' */'
		});

		return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
	}

	return [content].join('\n');
}

// Adapted from convert-source-map (MIT)
function toComment(sourceMap) {
	// eslint-disable-next-line no-undef
	var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
	var data = 'sourceMappingURL=data:application/json;charset=utf-8;base64,' + base64;

	return '/*# ' + data + ' */';
}


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/

var stylesInDom = {};

var	memoize = function (fn) {
	var memo;

	return function () {
		if (typeof memo === "undefined") memo = fn.apply(this, arguments);
		return memo;
	};
};

var isOldIE = memoize(function () {
	// Test for IE <= 9 as proposed by Browserhacks
	// @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
	// Tests for existence of standard globals is to allow style-loader
	// to operate correctly into non-standard environments
	// @see https://github.com/webpack-contrib/style-loader/issues/177
	return window && document && document.all && !window.atob;
});

var getElement = (function (fn) {
	var memo = {};

	return function(selector) {
		if (typeof memo[selector] === "undefined") {
			var styleTarget = fn.call(this, selector);
			// Special case to return head of iframe instead of iframe itself
			if (styleTarget instanceof window.HTMLIFrameElement) {
				try {
					// This will throw an exception if access to iframe is blocked
					// due to cross-origin restrictions
					styleTarget = styleTarget.contentDocument.head;
				} catch(e) {
					styleTarget = null;
				}
			}
			memo[selector] = styleTarget;
		}
		return memo[selector]
	};
})(function (target) {
	return document.querySelector(target)
});

var singleton = null;
var	singletonCounter = 0;
var	stylesInsertedAtTop = [];

var	fixUrls = __webpack_require__(29);

module.exports = function(list, options) {
	if (typeof DEBUG !== "undefined" && DEBUG) {
		if (typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
	}

	options = options || {};

	options.attrs = typeof options.attrs === "object" ? options.attrs : {};

	// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
	// tags it will allow on a page
	if (!options.singleton && typeof options.singleton !== "boolean") options.singleton = isOldIE();

	// By default, add <style> tags to the <head> element
	if (!options.insertInto) options.insertInto = "head";

	// By default, add <style> tags to the bottom of the target
	if (!options.insertAt) options.insertAt = "bottom";

	var styles = listToStyles(list, options);

	addStylesToDom(styles, options);

	return function update (newList) {
		var mayRemove = [];

		for (var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];

			domStyle.refs--;
			mayRemove.push(domStyle);
		}

		if(newList) {
			var newStyles = listToStyles(newList, options);
			addStylesToDom(newStyles, options);
		}

		for (var i = 0; i < mayRemove.length; i++) {
			var domStyle = mayRemove[i];

			if(domStyle.refs === 0) {
				for (var j = 0; j < domStyle.parts.length; j++) domStyle.parts[j]();

				delete stylesInDom[domStyle.id];
			}
		}
	};
};

function addStylesToDom (styles, options) {
	for (var i = 0; i < styles.length; i++) {
		var item = styles[i];
		var domStyle = stylesInDom[item.id];

		if(domStyle) {
			domStyle.refs++;

			for(var j = 0; j < domStyle.parts.length; j++) {
				domStyle.parts[j](item.parts[j]);
			}

			for(; j < item.parts.length; j++) {
				domStyle.parts.push(addStyle(item.parts[j], options));
			}
		} else {
			var parts = [];

			for(var j = 0; j < item.parts.length; j++) {
				parts.push(addStyle(item.parts[j], options));
			}

			stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
		}
	}
}

function listToStyles (list, options) {
	var styles = [];
	var newStyles = {};

	for (var i = 0; i < list.length; i++) {
		var item = list[i];
		var id = options.base ? item[0] + options.base : item[0];
		var css = item[1];
		var media = item[2];
		var sourceMap = item[3];
		var part = {css: css, media: media, sourceMap: sourceMap};

		if(!newStyles[id]) styles.push(newStyles[id] = {id: id, parts: [part]});
		else newStyles[id].parts.push(part);
	}

	return styles;
}

function insertStyleElement (options, style) {
	var target = getElement(options.insertInto)

	if (!target) {
		throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");
	}

	var lastStyleElementInsertedAtTop = stylesInsertedAtTop[stylesInsertedAtTop.length - 1];

	if (options.insertAt === "top") {
		if (!lastStyleElementInsertedAtTop) {
			target.insertBefore(style, target.firstChild);
		} else if (lastStyleElementInsertedAtTop.nextSibling) {
			target.insertBefore(style, lastStyleElementInsertedAtTop.nextSibling);
		} else {
			target.appendChild(style);
		}
		stylesInsertedAtTop.push(style);
	} else if (options.insertAt === "bottom") {
		target.appendChild(style);
	} else if (typeof options.insertAt === "object" && options.insertAt.before) {
		var nextSibling = getElement(options.insertInto + " " + options.insertAt.before);
		target.insertBefore(style, nextSibling);
	} else {
		throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");
	}
}

function removeStyleElement (style) {
	if (style.parentNode === null) return false;
	style.parentNode.removeChild(style);

	var idx = stylesInsertedAtTop.indexOf(style);
	if(idx >= 0) {
		stylesInsertedAtTop.splice(idx, 1);
	}
}

function createStyleElement (options) {
	var style = document.createElement("style");

	options.attrs.type = "text/css";

	addAttrs(style, options.attrs);
	insertStyleElement(options, style);

	return style;
}

function createLinkElement (options) {
	var link = document.createElement("link");

	options.attrs.type = "text/css";
	options.attrs.rel = "stylesheet";

	addAttrs(link, options.attrs);
	insertStyleElement(options, link);

	return link;
}

function addAttrs (el, attrs) {
	Object.keys(attrs).forEach(function (key) {
		el.setAttribute(key, attrs[key]);
	});
}

function addStyle (obj, options) {
	var style, update, remove, result;

	// If a transform function was defined, run it on the css
	if (options.transform && obj.css) {
	    result = options.transform(obj.css);

	    if (result) {
	    	// If transform returns a value, use that instead of the original css.
	    	// This allows running runtime transformations on the css.
	    	obj.css = result;
	    } else {
	    	// If the transform function returns a falsy value, don't add this css.
	    	// This allows conditional loading of css
	    	return function() {
	    		// noop
	    	};
	    }
	}

	if (options.singleton) {
		var styleIndex = singletonCounter++;

		style = singleton || (singleton = createStyleElement(options));

		update = applyToSingletonTag.bind(null, style, styleIndex, false);
		remove = applyToSingletonTag.bind(null, style, styleIndex, true);

	} else if (
		obj.sourceMap &&
		typeof URL === "function" &&
		typeof URL.createObjectURL === "function" &&
		typeof URL.revokeObjectURL === "function" &&
		typeof Blob === "function" &&
		typeof btoa === "function"
	) {
		style = createLinkElement(options);
		update = updateLink.bind(null, style, options);
		remove = function () {
			removeStyleElement(style);

			if(style.href) URL.revokeObjectURL(style.href);
		};
	} else {
		style = createStyleElement(options);
		update = applyToTag.bind(null, style);
		remove = function () {
			removeStyleElement(style);
		};
	}

	update(obj);

	return function updateStyle (newObj) {
		if (newObj) {
			if (
				newObj.css === obj.css &&
				newObj.media === obj.media &&
				newObj.sourceMap === obj.sourceMap
			) {
				return;
			}

			update(obj = newObj);
		} else {
			remove();
		}
	};
}

var replaceText = (function () {
	var textStore = [];

	return function (index, replacement) {
		textStore[index] = replacement;

		return textStore.filter(Boolean).join('\n');
	};
})();

function applyToSingletonTag (style, index, remove, obj) {
	var css = remove ? "" : obj.css;

	if (style.styleSheet) {
		style.styleSheet.cssText = replaceText(index, css);
	} else {
		var cssNode = document.createTextNode(css);
		var childNodes = style.childNodes;

		if (childNodes[index]) style.removeChild(childNodes[index]);

		if (childNodes.length) {
			style.insertBefore(cssNode, childNodes[index]);
		} else {
			style.appendChild(cssNode);
		}
	}
}

function applyToTag (style, obj) {
	var css = obj.css;
	var media = obj.media;

	if(media) {
		style.setAttribute("media", media)
	}

	if(style.styleSheet) {
		style.styleSheet.cssText = css;
	} else {
		while(style.firstChild) {
			style.removeChild(style.firstChild);
		}

		style.appendChild(document.createTextNode(css));
	}
}

function updateLink (link, options, obj) {
	var css = obj.css;
	var sourceMap = obj.sourceMap;

	/*
		If convertToAbsoluteUrls isn't defined, but sourcemaps are enabled
		and there is no publicPath defined then lets turn convertToAbsoluteUrls
		on by default.  Otherwise default to the convertToAbsoluteUrls option
		directly
	*/
	var autoFixUrls = options.convertToAbsoluteUrls === undefined && sourceMap;

	if (options.convertToAbsoluteUrls || autoFixUrls) {
		css = fixUrls(css);
	}

	if (sourceMap) {
		// http://stackoverflow.com/a/26603875
		css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
	}

	var blob = new Blob([css], { type: "text/css" });

	var oldSrc = link.href;

	link.href = URL.createObjectURL(blob);

	if(oldSrc) URL.revokeObjectURL(oldSrc);
}


/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * miniPaint - https://github.com/viliusle/miniPaint
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * author: Vilius L.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var instance = null;
var settings_all = [];

/**
 * Selection class - draws rectangular selection on canvas, can be resized.
 */

var Base_selection_class = function () {

	/**
  * settings:
  * - enable_background
  * - enable_borders
  * - enable_controlls
  * 
  * @param {ctx} ctx
  * @param {object} settings
  * @param {string} key
  */
	function Base_selection_class(ctx, settings) {
		var key = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

		_classCallCheck(this, Base_selection_class);

		if (key != null) {
			settings_all[key] = settings;
		}

		//singleton
		if (instance) {
			return instance;
		}
		instance = this;

		this.ctx = ctx;
		this.mouse_lock = null;
		this.selected_obj_positions = {};
		this.selected_object_drag_type = null;

		this.events();
	}

	_createClass(Base_selection_class, [{
		key: 'events',
		value: function events() {
			var _this = this;

			document.addEventListener('mousedown', function (e) {
				_this.selected_object_actions(e);
			});
			document.addEventListener('mousemove', function (e) {
				_this.selected_object_actions(e);
			});
			document.addEventListener('mouseup', function (e) {
				_this.selected_object_actions(e);
			});
		}
	}, {
		key: 'set_selection',
		value: function set_selection(x, y, width, height) {
			var settings = this.find_settings();

			if (x != null) settings.data.x = x;
			if (y != null) settings.data.y = y;
			if (width != null) settings.data.width = width;
			if (height != null) settings.data.height = height;
			_config2.default.need_render = true;
		}
	}, {
		key: 'reset_selection',
		value: function reset_selection() {
			var settings = this.find_settings();

			settings.data = {
				x: null,
				y: null,
				width: null,
				height: null
			};
			_config2.default.need_render = true;
		}
	}, {
		key: 'get_selection',
		value: function get_selection() {
			var settings = this.find_settings();

			return settings.data;
		}
	}, {
		key: 'find_settings',
		value: function find_settings() {
			var current_key = _config2.default.TOOL.name;
			var settings = null;

			for (var i in settings_all) {
				if (i == current_key) settings = settings_all[i];
			}

			//default
			if (settings === null) {
				settings = settings_all['main'];
			}

			//find data
			settings.data = settings.data_function.call();

			return settings;
		}

		/**
   * marks object as selected, and draws corners
   */

	}, {
		key: 'draw_selection',
		value: function draw_selection() {
			var _this = this;
			var settings = this.find_settings();
			var data = settings.data;

			if (settings.data === null || settings.data.status == 'draft') {
				return;
			}

			var x = settings.data.x;
			var y = settings.data.y;
			var w = settings.data.width;
			var h = settings.data.height;

			if (x == null || y == null || w == null || h == null) {
				//not supported 
				return;
			}

			var block_size_default = 14;
			block_size_default = Math.ceil(block_size_default / _config2.default.ZOOM);

			if (_config2.default.ZOOM != 1) {
				x = Math.round(x);
				y = Math.round(y);
				w = Math.round(w);
				h = Math.round(h);
			}
			var block_size = block_size_default;
			var half_size = Math.ceil(block_size / 2);

			this.ctx.save();
			if (data.rotate != null && data.rotate != 0) {
				//rotate
				this.ctx.translate(data.x + data.width / 2, data.y + data.height / 2);
				this.ctx.rotate(data.rotate * Math.PI / 180);
				x = Math.round(-data.width / 2);
				y = Math.round(-data.height / 2);
			}

			var half_fix = 0.5;

			//fill
			if (settings.enable_background == true) {
				this.ctx.fillStyle = "rgba(0, 255, 0, 0.3)";
				this.ctx.fillRect(x, y, w, h);
			}

			//borders
			if (settings.enable_borders == true && _config2.default.layers.length > 1) {
				this.ctx.lineWidth = 1;
				this.ctx.strokeStyle = "rgba(0, 128, 0, 0.5)";
				this.ctx.strokeRect(x + half_fix, y + half_fix, w, h);
			}

			//draw corners
			if (Math.abs(w) > block_size * 3 && Math.abs(h) > block_size * 3) {
				corner(x - half_size, y - half_size, 0, 0, 'left_top');
				corner(x + w + half_size, y - half_size, -1, 0, 'right_top');
				corner(x - half_size, y + h + half_size, 0, -1, 'left_bottom');
				corner(x + w + half_size, y + h + half_size, -1, -1, 'right_bottom');
			}

			if (settings.enable_controlls == true) {
				//draw centers
				if (Math.abs(w) > block_size * 5) {
					corner(x + w / 2 - block_size / 2, y - half_size, 0, 0, 'top');
					corner(x + w / 2 - block_size / 2, y + h + half_size, 0, -1, 'bottom');
				}
				if (Math.abs(h) > block_size * 5) {
					corner(x - half_size, y + h / 2 - block_size / 2, 0, 0, 'left');
					corner(x + w + half_size, y + h / 2 - block_size / 2, -1, 0, 'right');
				}
			}

			function corner(x, y, dx, dy, name) {
				var block_size = Math.round(block_size_default / 2) * 2;
				x = Math.round(x);
				y = Math.round(y);
				var angle = 0;
				if (settings.data.rotate != null && settings.data.rotate > 0) {
					angle = settings.data.rotate;
				}

				//register position
				_this.selected_obj_positions[name] = {
					x: x + dx * block_size,
					y: y + dy * block_size,
					size: block_size
				};

				if (settings.enable_controlls == false || angle > 0) {
					_this.ctx.strokeStyle = "rgba(0, 128, 0, 0.4)";
					_this.ctx.fillStyle = "rgba(255, 255, 255, 0.8)";
				} else {
					_this.ctx.strokeStyle = "#008000";
					_this.ctx.fillStyle = "#ffffff";
				}

				//borders
				_this.ctx.lineWidth = 1;
				if (_config2.default.ZOOM < 1) _this.ctx.lineWidth = 2;
				_this.ctx.beginPath();
				_this.ctx.arc(x + dx * block_size + half_size, y + dy * block_size + half_size, half_size, 0, 2 * Math.PI);
				_this.ctx.fill();
				_this.ctx.stroke();
			}

			//restore
			this.ctx.restore();
		}
	}, {
		key: 'selected_object_actions',
		value: function selected_object_actions(e) {
			var settings = this.find_settings();
			if (document.body.style.cursor != 'default') {
				document.body.style.cursor = 'default';
			}
			if (e.type == 'mousedown' && _config2.default.mouse.valid == false || settings.enable_controlls == false) {
				return;
			}
			if (settings.data.rotate != null && settings.data.rotate > 0) {
				//controls on rotated object disabled
				return;
			}

			var mouse = _config2.default.mouse;
			var type = this.selected_object_drag_type;

			if (e.type == 'mousemove' && this.mouse_lock == 'selected_object_actions') {
				document.body.style.cursor = "pointer";
				if (e.buttons == 1) {
					//do transformations
					var dx = mouse.x - mouse.last_x;
					var dy = mouse.y - mouse.last_y;

					if (type == 'left_top') {
						settings.data.x += dx;
						settings.data.y += dy;
						settings.data.width -= dx;
						settings.data.height -= dy;
					} else if (type == 'right_top') {
						settings.data.width += dx;
						settings.data.y += dy;
						settings.data.height -= dy;
					} else if (type == 'left_bottom') {
						settings.data.x += dx;
						settings.data.height += dy;
						settings.data.width -= dx;
					} else if (type == 'right_bottom') {
						settings.data.width += dx;
						settings.data.height += dy;
					} else if (type == 'top') {
						settings.data.y += dy;
						settings.data.height -= dy;
					} else if (type == 'bottom') settings.data.height += dy;else if (type == 'left') {
						settings.data.x += dx;
						settings.data.width -= dx;
					} else if (type == 'right') settings.data.width += dx;

					_config2.default.need_render = true;
				}
				return;
			}
			if (e.type == 'mouseup' && this.mouse_lock == 'selected_object_actions') {
				//reset
				this.mouse_lock = null;
			}

			for (var i in this.selected_obj_positions) {
				var positions = this.selected_obj_positions[i];

				if (mouse.x >= positions.x && mouse.x <= positions.x + positions.size && mouse.y >= positions.y && mouse.y <= positions.y + positions.size) {
					//match
					if (e.type == 'mousedown') {
						if (e.buttons == 1) {
							this.mouse_lock = 'selected_object_actions';
							this.selected_object_drag_type = i;
						}
					}
					if (e.type == 'mousemove') {
						document.body.style.cursor = "pointer";
					}
				}
			}
		}
	}]);

	return Base_selection_class;
}();

exports.default = Base_selection_class;

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * miniPaint - https://github.com/viliusle/miniPaint
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * author: Vilius L.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _helpers = __webpack_require__(4);

var _helpers2 = _interopRequireDefault(_helpers);

var _translate = __webpack_require__(15);

var _translate2 = _interopRequireDefault(_translate);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var instance = null;

/**
 * GUI class responsible for rendering left sidebar tools
 */

var GUI_tools_class = function () {
	function GUI_tools_class(GUI_class) {
		_classCallCheck(this, GUI_tools_class);

		//singleton
		if (instance) {
			return instance;
		}
		instance = this;

		this.Helper = new _helpers2.default();
		this.Help_translate = new _translate2.default();

		//active tool
		this.active_tool = 'brush';
		this.tools_modules = {};
	}

	_createClass(GUI_tools_class, [{
		key: 'load_plugins',
		value: function load_plugins() {
			var _this = this;
			var ctx = document.getElementById('canvas_minipaint').getContext("2d");
			var plugins_context = __webpack_require__(52);
			plugins_context.keys().forEach(function (key) {
				if (key.indexOf('Base' + '/') < 0) {
					var moduleKey = key.replace('./', '').replace('.js', '');
					var classObj = plugins_context(key);
					_this.tools_modules[moduleKey] = new classObj.default(ctx);

					//init events once
					_this.tools_modules[moduleKey].load();
				}
			});
		}
	}, {
		key: 'render_main_tools',
		value: function render_main_tools() {
			this.load_plugins();

			this.render_tools();
		}
	}, {
		key: 'render_tools',
		value: function render_tools() {
			var target_id = "tools_container";
			var _this = this;
			var saved_tool = this.Helper.getCookie('active_tool');
			if (saved_tool != null) {
				this.active_tool = saved_tool;
			}

			//left menu
			for (var i in _config2.default.TOOLS) {
				var item = _config2.default.TOOLS[i];

				var itemDom = document.createElement('span');
				itemDom.id = item.name;
				itemDom.title = item.title;
				if (item.name == this.active_tool) {
					itemDom.className = 'item trn active ' + item.name;
				} else {
					itemDom.className = 'item trn ' + item.name;
				}

				//event
				itemDom.addEventListener('click', function (event) {
					_this.activate_tool(this.id);
				});

				//register
				document.getElementById(target_id).appendChild(itemDom);
			}

			this.show_action_attributes();
			this.activate_tool(this.active_tool);
		}
	}, {
		key: 'activate_tool',
		value: function activate_tool(key) {
			//reset last
			document.querySelector('#tools_container .' + this.active_tool).classList.remove("active");

			//send exit event to old previous tool
			if (_config2.default.TOOL.on_leave != undefined) {
				var moduleKey = _config2.default.TOOL.name;
				var functionName = _config2.default.TOOL.on_leave;
				this.tools_modules[moduleKey][functionName]();
			}

			//change active
			this.active_tool = key;
			document.querySelector('#tools_container .' + this.active_tool).classList.add("active");
			for (var i in _config2.default.TOOLS) {
				if (_config2.default.TOOLS[i].name == this.active_tool) {
					_config2.default.TOOL = _config2.default.TOOLS[i];
				}
			}

			//check module
			if (this.tools_modules[key] == undefined) {
				_alertifyMin2.default.error('Tools class not found: ' + key);
				return;
			}

			//send activate event to new tool
			if (_config2.default.TOOL.on_activate != undefined) {
				var moduleKey = _config2.default.TOOL.name;
				var functionName = _config2.default.TOOL.on_activate;
				this.tools_modules[moduleKey][functionName]();
			}

			this.show_action_attributes();
			this.Helper.setCookie('active_tool', this.active_tool);
			_config2.default.need_render = true;
		}
	}, {
		key: 'action_data',
		value: function action_data() {
			for (var i in _config2.default.TOOLS) {
				if (_config2.default.TOOLS[i].name == this.active_tool) return _config2.default.TOOLS[i];
			}

			//something wrong - select first tool
			this.active_tool = _config2.default.TOOLS[0].name;
			return _config2.default.TOOLS[0];
		}

		/**
   * used strings: 
   * "Fill", "Square", "Circle", "Radial", "Anti aliasing", "Circle", "Strict", "Burn"
   */

	}, {
		key: 'show_action_attributes',
		value: function show_action_attributes() {
			var _this = this;
			var target_id = "action_attributes";

			document.getElementById(target_id).innerHTML = "";

			for (var k in this.action_data().attributes) {
				var item = this.action_data().attributes[k];

				var title = k[0].toUpperCase() + k.slice(1);
				title = title.replace("_", " ");

				var itemDom = document.createElement('span');
				itemDom.className = 'item ' + k;
				document.getElementById(target_id).appendChild(itemDom);

				if (typeof item == 'boolean') {
					//boolean - true, false

					var element = document.createElement('button');
					element.type = 'button';
					element.className = 'block-2';
					element.id = k;
					element.innerHTML = title;
					if (item == true) {
						element.className = 'active trn';
						element.dataset.param = false;
					} else {
						element.className = 'trn';
						element.dataset.param = true;
					}
					//event
					element.addEventListener('click', function (event) {
						//toggle boolean
						var new_value = JSON.parse(this.dataset.param);
						_this.action_data().attributes[this.id] = new_value;
						_this.show_action_attributes();

						if (_this.action_data().on_update != undefined) {
							//send event
							var moduleKey = _this.action_data().name;
							var functionName = _this.action_data().on_update;
							_this.tools_modules[moduleKey][functionName]();
						}
					});

					itemDom.appendChild(element);
				} else if (typeof item == 'number') {
					//numbers

					var elementTitle = document.createElement('span');
					elementTitle.innerHTML = title + ': ';

					var elementInput = document.createElement('input');
					elementInput.type = 'number';
					elementInput.id = k;
					elementInput.value = item;
					elementInput.addEventListener('keyup', function (event) {
						//validate number
						var value = parseInt(this.value);
						if (isNaN(value) || value < 1) {
							value = 1;
							_this.action_data().attributes[this.id] = value;
							_this.show_action_attributes();
						}
						if (value > 100 && this.id == 'power') {
							//max 100
							value = 100;
							_this.action_data().attributes[this.id] = value;
							_this.show_action_attributes();
						}
						_this.action_data().attributes[this.id] = value;
					});
					elementInput.addEventListener('change', function (event) {
						//validate number
						var value = parseInt(this.value);
						_this.action_data().attributes[this.id] = value;
					});

					var elementPlus = document.createElement('button');
					elementPlus.type = 'button';
					elementPlus.id = k;
					elementPlus.innerHTML = '+';
					elementPlus.dataset.target = k;
					elementPlus.addEventListener('click', function (event) {
						//increase
						var value = document.getElementById(this.dataset.target).value;
						value = Math.abs(parseInt(value));

						if (value >= 500) value = value + 100;else if (value >= 100) value = value + 50;else if (value >= 10) value = value + 10;else if (value >= 5) value = value + 5;else value = value + 1;

						if (value > 100 && this.id == 'power') {
							//max 100
							value = 100;
						}

						_this.action_data().attributes[this.id] = value;
						_this.show_action_attributes();
					});

					var elementMinus = document.createElement('button');
					elementMinus.type = 'button';
					elementMinus.id = k;
					elementMinus.innerHTML = '-';
					elementMinus.dataset.target = k;
					elementMinus.addEventListener('click', function (event) {
						//decrease
						var value = document.getElementById(this.dataset.target).value;
						value = Math.abs(parseInt(value));

						if (value > 500) value = value - 100;else if (value > 100) value = value - 50;else if (value > 10) value = value - 10;else if (value > 5) value = value - 5;else value = value - 1;
						value = Math.max(value, 1);

						_this.action_data().attributes[this.id] = value;
						_this.show_action_attributes();
					});

					itemDom.appendChild(elementTitle);
					itemDom.appendChild(elementInput);
					itemDom.appendChild(elementPlus);
					itemDom.appendChild(elementMinus);
				} else if ((typeof item === 'undefined' ? 'undefined' : _typeof(item)) == 'object') {
					//select

					var elementTitle = document.createElement('span');
					elementTitle.innerHTML = title + ': ';

					var selectList = document.createElement("select");
					selectList.id = k;
					for (var j in item.values) {
						var option = document.createElement("option");
						if (item.value == item.values[j]) {
							option.selected = 'selected';
						}
						option.className = 'trn';
						option.name = item.values[j];
						option.value = item.values[j];
						option.text = item.values[j];
						selectList.appendChild(option);
					}
					//event
					selectList.addEventListener('change', function (event) {
						_this.action_data().attributes[this.id].value = this.value;
						_this.show_action_attributes();
					});

					itemDom.appendChild(elementTitle);
					itemDom.appendChild(selectList);
				} else if (typeof item == 'string' && item[0] == '#') {
					//color

					var elementTitle = document.createElement('span');
					elementTitle.innerHTML = title + ': ';

					var elementInput = document.createElement('input');
					elementInput.type = 'color';
					elementInput.id = k;
					elementInput.value = item;

					elementInput.addEventListener('keyup', function (event) {
						_this.action_data().attributes[this.id] = this.value;
					});
					elementInput.addEventListener('change', function (event) {
						_this.action_data().attributes[this.id] = this.value;
					});

					itemDom.appendChild(elementTitle);
					itemDom.appendChild(elementInput);
				} else {
					_alertifyMin2.default.error('Error: unsupported attribute type:' + (typeof item === 'undefined' ? 'undefined' : _typeof(item)) + ', ' + k);
				}
			}

			if (_config2.default.LANG != 'en') {
				//retranslate
				this.Help_translate.translate(_config2.default.LANG);
			}
		}
	}]);

	return GUI_tools_class;
}();

exports.default = GUI_tools_class;

/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * jQuery JavaScript Library v3.3.1
 * https://jquery.com/
 *
 * Includes Sizzle.js
 * https://sizzlejs.com/
 *
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2018-01-20T17:24Z
 */
( function( global, factory ) {

	"use strict";

	if ( typeof module === "object" && typeof module.exports === "object" ) {

		// For CommonJS and CommonJS-like environments where a proper `window`
		// is present, execute the factory and get jQuery.
		// For environments that do not have a `window` with a `document`
		// (such as Node.js), expose a factory as module.exports.
		// This accentuates the need for the creation of a real `window`.
		// e.g. var jQuery = require("jquery")(window);
		// See ticket #14549 for more info.
		module.exports = global.document ?
			factory( global, true ) :
			function( w ) {
				if ( !w.document ) {
					throw new Error( "jQuery requires a window with a document" );
				}
				return factory( w );
			};
	} else {
		factory( global );
	}

// Pass this if window is not defined yet
} )( typeof window !== "undefined" ? window : this, function( window, noGlobal ) {

// Edge <= 12 - 13+, Firefox <=18 - 45+, IE 10 - 11, Safari 5.1 - 9+, iOS 6 - 9.1
// throw exceptions when non-strict code (e.g., ASP.NET 4.5) accesses strict mode
// arguments.callee.caller (trac-13335). But as of jQuery 3.0 (2016), strict mode should be common
// enough that all such attempts are guarded in a try block.
"use strict";

var arr = [];

var document = window.document;

var getProto = Object.getPrototypeOf;

var slice = arr.slice;

var concat = arr.concat;

var push = arr.push;

var indexOf = arr.indexOf;

var class2type = {};

var toString = class2type.toString;

var hasOwn = class2type.hasOwnProperty;

var fnToString = hasOwn.toString;

var ObjectFunctionString = fnToString.call( Object );

var support = {};

var isFunction = function isFunction( obj ) {

      // Support: Chrome <=57, Firefox <=52
      // In some browsers, typeof returns "function" for HTML <object> elements
      // (i.e., `typeof document.createElement( "object" ) === "function"`).
      // We don't want to classify *any* DOM node as a function.
      return typeof obj === "function" && typeof obj.nodeType !== "number";
  };


var isWindow = function isWindow( obj ) {
		return obj != null && obj === obj.window;
	};




	var preservedScriptAttributes = {
		type: true,
		src: true,
		noModule: true
	};

	function DOMEval( code, doc, node ) {
		doc = doc || document;

		var i,
			script = doc.createElement( "script" );

		script.text = code;
		if ( node ) {
			for ( i in preservedScriptAttributes ) {
				if ( node[ i ] ) {
					script[ i ] = node[ i ];
				}
			}
		}
		doc.head.appendChild( script ).parentNode.removeChild( script );
	}


function toType( obj ) {
	if ( obj == null ) {
		return obj + "";
	}

	// Support: Android <=2.3 only (functionish RegExp)
	return typeof obj === "object" || typeof obj === "function" ?
		class2type[ toString.call( obj ) ] || "object" :
		typeof obj;
}
/* global Symbol */
// Defining this global in .eslintrc.json would create a danger of using the global
// unguarded in another place, it seems safer to define global only for this module



var
	version = "3.3.1",

	// Define a local copy of jQuery
	jQuery = function( selector, context ) {

		// The jQuery object is actually just the init constructor 'enhanced'
		// Need init if jQuery is called (just allow error to be thrown if not included)
		return new jQuery.fn.init( selector, context );
	},

	// Support: Android <=4.0 only
	// Make sure we trim BOM and NBSP
	rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;

jQuery.fn = jQuery.prototype = {

	// The current version of jQuery being used
	jquery: version,

	constructor: jQuery,

	// The default length of a jQuery object is 0
	length: 0,

	toArray: function() {
		return slice.call( this );
	},

	// Get the Nth element in the matched element set OR
	// Get the whole matched element set as a clean array
	get: function( num ) {

		// Return all the elements in a clean array
		if ( num == null ) {
			return slice.call( this );
		}

		// Return just the one element from the set
		return num < 0 ? this[ num + this.length ] : this[ num ];
	},

	// Take an array of elements and push it onto the stack
	// (returning the new matched element set)
	pushStack: function( elems ) {

		// Build a new jQuery matched element set
		var ret = jQuery.merge( this.constructor(), elems );

		// Add the old object onto the stack (as a reference)
		ret.prevObject = this;

		// Return the newly-formed element set
		return ret;
	},

	// Execute a callback for every element in the matched set.
	each: function( callback ) {
		return jQuery.each( this, callback );
	},

	map: function( callback ) {
		return this.pushStack( jQuery.map( this, function( elem, i ) {
			return callback.call( elem, i, elem );
		} ) );
	},

	slice: function() {
		return this.pushStack( slice.apply( this, arguments ) );
	},

	first: function() {
		return this.eq( 0 );
	},

	last: function() {
		return this.eq( -1 );
	},

	eq: function( i ) {
		var len = this.length,
			j = +i + ( i < 0 ? len : 0 );
		return this.pushStack( j >= 0 && j < len ? [ this[ j ] ] : [] );
	},

	end: function() {
		return this.prevObject || this.constructor();
	},

	// For internal use only.
	// Behaves like an Array's method, not like a jQuery method.
	push: push,
	sort: arr.sort,
	splice: arr.splice
};

jQuery.extend = jQuery.fn.extend = function() {
	var options, name, src, copy, copyIsArray, clone,
		target = arguments[ 0 ] || {},
		i = 1,
		length = arguments.length,
		deep = false;

	// Handle a deep copy situation
	if ( typeof target === "boolean" ) {
		deep = target;

		// Skip the boolean and the target
		target = arguments[ i ] || {};
		i++;
	}

	// Handle case when target is a string or something (possible in deep copy)
	if ( typeof target !== "object" && !isFunction( target ) ) {
		target = {};
	}

	// Extend jQuery itself if only one argument is passed
	if ( i === length ) {
		target = this;
		i--;
	}

	for ( ; i < length; i++ ) {

		// Only deal with non-null/undefined values
		if ( ( options = arguments[ i ] ) != null ) {

			// Extend the base object
			for ( name in options ) {
				src = target[ name ];
				copy = options[ name ];

				// Prevent never-ending loop
				if ( target === copy ) {
					continue;
				}

				// Recurse if we're merging plain objects or arrays
				if ( deep && copy && ( jQuery.isPlainObject( copy ) ||
					( copyIsArray = Array.isArray( copy ) ) ) ) {

					if ( copyIsArray ) {
						copyIsArray = false;
						clone = src && Array.isArray( src ) ? src : [];

					} else {
						clone = src && jQuery.isPlainObject( src ) ? src : {};
					}

					// Never move original objects, clone them
					target[ name ] = jQuery.extend( deep, clone, copy );

				// Don't bring in undefined values
				} else if ( copy !== undefined ) {
					target[ name ] = copy;
				}
			}
		}
	}

	// Return the modified object
	return target;
};

jQuery.extend( {

	// Unique for each copy of jQuery on the page
	expando: "jQuery" + ( version + Math.random() ).replace( /\D/g, "" ),

	// Assume jQuery is ready without the ready module
	isReady: true,

	error: function( msg ) {
		throw new Error( msg );
	},

	noop: function() {},

	isPlainObject: function( obj ) {
		var proto, Ctor;

		// Detect obvious negatives
		// Use toString instead of jQuery.type to catch host objects
		if ( !obj || toString.call( obj ) !== "[object Object]" ) {
			return false;
		}

		proto = getProto( obj );

		// Objects with no prototype (e.g., `Object.create( null )`) are plain
		if ( !proto ) {
			return true;
		}

		// Objects with prototype are plain iff they were constructed by a global Object function
		Ctor = hasOwn.call( proto, "constructor" ) && proto.constructor;
		return typeof Ctor === "function" && fnToString.call( Ctor ) === ObjectFunctionString;
	},

	isEmptyObject: function( obj ) {

		/* eslint-disable no-unused-vars */
		// See https://github.com/eslint/eslint/issues/6125
		var name;

		for ( name in obj ) {
			return false;
		}
		return true;
	},

	// Evaluates a script in a global context
	globalEval: function( code ) {
		DOMEval( code );
	},

	each: function( obj, callback ) {
		var length, i = 0;

		if ( isArrayLike( obj ) ) {
			length = obj.length;
			for ( ; i < length; i++ ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		} else {
			for ( i in obj ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		}

		return obj;
	},

	// Support: Android <=4.0 only
	trim: function( text ) {
		return text == null ?
			"" :
			( text + "" ).replace( rtrim, "" );
	},

	// results is for internal usage only
	makeArray: function( arr, results ) {
		var ret = results || [];

		if ( arr != null ) {
			if ( isArrayLike( Object( arr ) ) ) {
				jQuery.merge( ret,
					typeof arr === "string" ?
					[ arr ] : arr
				);
			} else {
				push.call( ret, arr );
			}
		}

		return ret;
	},

	inArray: function( elem, arr, i ) {
		return arr == null ? -1 : indexOf.call( arr, elem, i );
	},

	// Support: Android <=4.0 only, PhantomJS 1 only
	// push.apply(_, arraylike) throws on ancient WebKit
	merge: function( first, second ) {
		var len = +second.length,
			j = 0,
			i = first.length;

		for ( ; j < len; j++ ) {
			first[ i++ ] = second[ j ];
		}

		first.length = i;

		return first;
	},

	grep: function( elems, callback, invert ) {
		var callbackInverse,
			matches = [],
			i = 0,
			length = elems.length,
			callbackExpect = !invert;

		// Go through the array, only saving the items
		// that pass the validator function
		for ( ; i < length; i++ ) {
			callbackInverse = !callback( elems[ i ], i );
			if ( callbackInverse !== callbackExpect ) {
				matches.push( elems[ i ] );
			}
		}

		return matches;
	},

	// arg is for internal usage only
	map: function( elems, callback, arg ) {
		var length, value,
			i = 0,
			ret = [];

		// Go through the array, translating each of the items to their new values
		if ( isArrayLike( elems ) ) {
			length = elems.length;
			for ( ; i < length; i++ ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}

		// Go through every key on the object,
		} else {
			for ( i in elems ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}
		}

		// Flatten any nested arrays
		return concat.apply( [], ret );
	},

	// A global GUID counter for objects
	guid: 1,

	// jQuery.support is not used in Core but other projects attach their
	// properties to it so it needs to exist.
	support: support
} );

if ( typeof Symbol === "function" ) {
	jQuery.fn[ Symbol.iterator ] = arr[ Symbol.iterator ];
}

// Populate the class2type map
jQuery.each( "Boolean Number String Function Array Date RegExp Object Error Symbol".split( " " ),
function( i, name ) {
	class2type[ "[object " + name + "]" ] = name.toLowerCase();
} );

function isArrayLike( obj ) {

	// Support: real iOS 8.2 only (not reproducible in simulator)
	// `in` check used to prevent JIT error (gh-2145)
	// hasOwn isn't used here due to false negatives
	// regarding Nodelist length in IE
	var length = !!obj && "length" in obj && obj.length,
		type = toType( obj );

	if ( isFunction( obj ) || isWindow( obj ) ) {
		return false;
	}

	return type === "array" || length === 0 ||
		typeof length === "number" && length > 0 && ( length - 1 ) in obj;
}
var Sizzle =
/*!
 * Sizzle CSS Selector Engine v2.3.3
 * https://sizzlejs.com/
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2016-08-08
 */
(function( window ) {

var i,
	support,
	Expr,
	getText,
	isXML,
	tokenize,
	compile,
	select,
	outermostContext,
	sortInput,
	hasDuplicate,

	// Local document vars
	setDocument,
	document,
	docElem,
	documentIsHTML,
	rbuggyQSA,
	rbuggyMatches,
	matches,
	contains,

	// Instance-specific data
	expando = "sizzle" + 1 * new Date(),
	preferredDoc = window.document,
	dirruns = 0,
	done = 0,
	classCache = createCache(),
	tokenCache = createCache(),
	compilerCache = createCache(),
	sortOrder = function( a, b ) {
		if ( a === b ) {
			hasDuplicate = true;
		}
		return 0;
	},

	// Instance methods
	hasOwn = ({}).hasOwnProperty,
	arr = [],
	pop = arr.pop,
	push_native = arr.push,
	push = arr.push,
	slice = arr.slice,
	// Use a stripped-down indexOf as it's faster than native
	// https://jsperf.com/thor-indexof-vs-for/5
	indexOf = function( list, elem ) {
		var i = 0,
			len = list.length;
		for ( ; i < len; i++ ) {
			if ( list[i] === elem ) {
				return i;
			}
		}
		return -1;
	},

	booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",

	// Regular expressions

	// http://www.w3.org/TR/css3-selectors/#whitespace
	whitespace = "[\\x20\\t\\r\\n\\f]",

	// http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier
	identifier = "(?:\\\\.|[\\w-]|[^\0-\\xa0])+",

	// Attribute selectors: http://www.w3.org/TR/selectors/#attribute-selectors
	attributes = "\\[" + whitespace + "*(" + identifier + ")(?:" + whitespace +
		// Operator (capture 2)
		"*([*^$|!~]?=)" + whitespace +
		// "Attribute values must be CSS identifiers [capture 5] or strings [capture 3 or capture 4]"
		"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + identifier + "))|)" + whitespace +
		"*\\]",

	pseudos = ":(" + identifier + ")(?:\\((" +
		// To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:
		// 1. quoted (capture 3; capture 4 or capture 5)
		"('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" +
		// 2. simple (capture 6)
		"((?:\\\\.|[^\\\\()[\\]]|" + attributes + ")*)|" +
		// 3. anything else (capture 2)
		".*" +
		")\\)|)",

	// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
	rwhitespace = new RegExp( whitespace + "+", "g" ),
	rtrim = new RegExp( "^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g" ),

	rcomma = new RegExp( "^" + whitespace + "*," + whitespace + "*" ),
	rcombinators = new RegExp( "^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace + "*" ),

	rattributeQuotes = new RegExp( "=" + whitespace + "*([^\\]'\"]*?)" + whitespace + "*\\]", "g" ),

	rpseudo = new RegExp( pseudos ),
	ridentifier = new RegExp( "^" + identifier + "$" ),

	matchExpr = {
		"ID": new RegExp( "^#(" + identifier + ")" ),
		"CLASS": new RegExp( "^\\.(" + identifier + ")" ),
		"TAG": new RegExp( "^(" + identifier + "|[*])" ),
		"ATTR": new RegExp( "^" + attributes ),
		"PSEUDO": new RegExp( "^" + pseudos ),
		"CHILD": new RegExp( "^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" + whitespace +
			"*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace +
			"*(\\d+)|))" + whitespace + "*\\)|)", "i" ),
		"bool": new RegExp( "^(?:" + booleans + ")$", "i" ),
		// For use in libraries implementing .is()
		// We use this for POS matching in `select`
		"needsContext": new RegExp( "^" + whitespace + "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" +
			whitespace + "*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i" )
	},

	rinputs = /^(?:input|select|textarea|button)$/i,
	rheader = /^h\d$/i,

	rnative = /^[^{]+\{\s*\[native \w/,

	// Easily-parseable/retrievable ID or TAG or CLASS selectors
	rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,

	rsibling = /[+~]/,

	// CSS escapes
	// http://www.w3.org/TR/CSS21/syndata.html#escaped-characters
	runescape = new RegExp( "\\\\([\\da-f]{1,6}" + whitespace + "?|(" + whitespace + ")|.)", "ig" ),
	funescape = function( _, escaped, escapedWhitespace ) {
		var high = "0x" + escaped - 0x10000;
		// NaN means non-codepoint
		// Support: Firefox<24
		// Workaround erroneous numeric interpretation of +"0x"
		return high !== high || escapedWhitespace ?
			escaped :
			high < 0 ?
				// BMP codepoint
				String.fromCharCode( high + 0x10000 ) :
				// Supplemental Plane codepoint (surrogate pair)
				String.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );
	},

	// CSS string/identifier serialization
	// https://drafts.csswg.org/cssom/#common-serializing-idioms
	rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,
	fcssescape = function( ch, asCodePoint ) {
		if ( asCodePoint ) {

			// U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER
			if ( ch === "\0" ) {
				return "\uFFFD";
			}

			// Control characters and (dependent upon position) numbers get escaped as code points
			return ch.slice( 0, -1 ) + "\\" + ch.charCodeAt( ch.length - 1 ).toString( 16 ) + " ";
		}

		// Other potentially-special ASCII characters get backslash-escaped
		return "\\" + ch;
	},

	// Used for iframes
	// See setDocument()
	// Removing the function wrapper causes a "Permission Denied"
	// error in IE
	unloadHandler = function() {
		setDocument();
	},

	disabledAncestor = addCombinator(
		function( elem ) {
			return elem.disabled === true && ("form" in elem || "label" in elem);
		},
		{ dir: "parentNode", next: "legend" }
	);

// Optimize for push.apply( _, NodeList )
try {
	push.apply(
		(arr = slice.call( preferredDoc.childNodes )),
		preferredDoc.childNodes
	);
	// Support: Android<4.0
	// Detect silently failing push.apply
	arr[ preferredDoc.childNodes.length ].nodeType;
} catch ( e ) {
	push = { apply: arr.length ?

		// Leverage slice if possible
		function( target, els ) {
			push_native.apply( target, slice.call(els) );
		} :

		// Support: IE<9
		// Otherwise append directly
		function( target, els ) {
			var j = target.length,
				i = 0;
			// Can't trust NodeList.length
			while ( (target[j++] = els[i++]) ) {}
			target.length = j - 1;
		}
	};
}

function Sizzle( selector, context, results, seed ) {
	var m, i, elem, nid, match, groups, newSelector,
		newContext = context && context.ownerDocument,

		// nodeType defaults to 9, since context defaults to document
		nodeType = context ? context.nodeType : 9;

	results = results || [];

	// Return early from calls with invalid selector or context
	if ( typeof selector !== "string" || !selector ||
		nodeType !== 1 && nodeType !== 9 && nodeType !== 11 ) {

		return results;
	}

	// Try to shortcut find operations (as opposed to filters) in HTML documents
	if ( !seed ) {

		if ( ( context ? context.ownerDocument || context : preferredDoc ) !== document ) {
			setDocument( context );
		}
		context = context || document;

		if ( documentIsHTML ) {

			// If the selector is sufficiently simple, try using a "get*By*" DOM method
			// (excepting DocumentFragment context, where the methods don't exist)
			if ( nodeType !== 11 && (match = rquickExpr.exec( selector )) ) {

				// ID selector
				if ( (m = match[1]) ) {

					// Document context
					if ( nodeType === 9 ) {
						if ( (elem = context.getElementById( m )) ) {

							// Support: IE, Opera, Webkit
							// TODO: identify versions
							// getElementById can match elements by name instead of ID
							if ( elem.id === m ) {
								results.push( elem );
								return results;
							}
						} else {
							return results;
						}

					// Element context
					} else {

						// Support: IE, Opera, Webkit
						// TODO: identify versions
						// getElementById can match elements by name instead of ID
						if ( newContext && (elem = newContext.getElementById( m )) &&
							contains( context, elem ) &&
							elem.id === m ) {

							results.push( elem );
							return results;
						}
					}

				// Type selector
				} else if ( match[2] ) {
					push.apply( results, context.getElementsByTagName( selector ) );
					return results;

				// Class selector
				} else if ( (m = match[3]) && support.getElementsByClassName &&
					context.getElementsByClassName ) {

					push.apply( results, context.getElementsByClassName( m ) );
					return results;
				}
			}

			// Take advantage of querySelectorAll
			if ( support.qsa &&
				!compilerCache[ selector + " " ] &&
				(!rbuggyQSA || !rbuggyQSA.test( selector )) ) {

				if ( nodeType !== 1 ) {
					newContext = context;
					newSelector = selector;

				// qSA looks outside Element context, which is not what we want
				// Thanks to Andrew Dupont for this workaround technique
				// Support: IE <=8
				// Exclude object elements
				} else if ( context.nodeName.toLowerCase() !== "object" ) {

					// Capture the context ID, setting it first if necessary
					if ( (nid = context.getAttribute( "id" )) ) {
						nid = nid.replace( rcssescape, fcssescape );
					} else {
						context.setAttribute( "id", (nid = expando) );
					}

					// Prefix every selector in the list
					groups = tokenize( selector );
					i = groups.length;
					while ( i-- ) {
						groups[i] = "#" + nid + " " + toSelector( groups[i] );
					}
					newSelector = groups.join( "," );

					// Expand context for sibling selectors
					newContext = rsibling.test( selector ) && testContext( context.parentNode ) ||
						context;
				}

				if ( newSelector ) {
					try {
						push.apply( results,
							newContext.querySelectorAll( newSelector )
						);
						return results;
					} catch ( qsaError ) {
					} finally {
						if ( nid === expando ) {
							context.removeAttribute( "id" );
						}
					}
				}
			}
		}
	}

	// All others
	return select( selector.replace( rtrim, "$1" ), context, results, seed );
}

/**
 * Create key-value caches of limited size
 * @returns {function(string, object)} Returns the Object data after storing it on itself with
 *	property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)
 *	deleting the oldest entry
 */
function createCache() {
	var keys = [];

	function cache( key, value ) {
		// Use (key + " ") to avoid collision with native prototype properties (see Issue #157)
		if ( keys.push( key + " " ) > Expr.cacheLength ) {
			// Only keep the most recent entries
			delete cache[ keys.shift() ];
		}
		return (cache[ key + " " ] = value);
	}
	return cache;
}

/**
 * Mark a function for special use by Sizzle
 * @param {Function} fn The function to mark
 */
function markFunction( fn ) {
	fn[ expando ] = true;
	return fn;
}

/**
 * Support testing using an element
 * @param {Function} fn Passed the created element and returns a boolean result
 */
function assert( fn ) {
	var el = document.createElement("fieldset");

	try {
		return !!fn( el );
	} catch (e) {
		return false;
	} finally {
		// Remove from its parent by default
		if ( el.parentNode ) {
			el.parentNode.removeChild( el );
		}
		// release memory in IE
		el = null;
	}
}

/**
 * Adds the same handler for all of the specified attrs
 * @param {String} attrs Pipe-separated list of attributes
 * @param {Function} handler The method that will be applied
 */
function addHandle( attrs, handler ) {
	var arr = attrs.split("|"),
		i = arr.length;

	while ( i-- ) {
		Expr.attrHandle[ arr[i] ] = handler;
	}
}

/**
 * Checks document order of two siblings
 * @param {Element} a
 * @param {Element} b
 * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b
 */
function siblingCheck( a, b ) {
	var cur = b && a,
		diff = cur && a.nodeType === 1 && b.nodeType === 1 &&
			a.sourceIndex - b.sourceIndex;

	// Use IE sourceIndex if available on both nodes
	if ( diff ) {
		return diff;
	}

	// Check if b follows a
	if ( cur ) {
		while ( (cur = cur.nextSibling) ) {
			if ( cur === b ) {
				return -1;
			}
		}
	}

	return a ? 1 : -1;
}

/**
 * Returns a function to use in pseudos for input types
 * @param {String} type
 */
function createInputPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return name === "input" && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for buttons
 * @param {String} type
 */
function createButtonPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return (name === "input" || name === "button") && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for :enabled/:disabled
 * @param {Boolean} disabled true for :disabled; false for :enabled
 */
function createDisabledPseudo( disabled ) {

	// Known :disabled false positives: fieldset[disabled] > legend:nth-of-type(n+2) :can-disable
	return function( elem ) {

		// Only certain elements can match :enabled or :disabled
		// https://html.spec.whatwg.org/multipage/scripting.html#selector-enabled
		// https://html.spec.whatwg.org/multipage/scripting.html#selector-disabled
		if ( "form" in elem ) {

			// Check for inherited disabledness on relevant non-disabled elements:
			// * listed form-associated elements in a disabled fieldset
			//   https://html.spec.whatwg.org/multipage/forms.html#category-listed
			//   https://html.spec.whatwg.org/multipage/forms.html#concept-fe-disabled
			// * option elements in a disabled optgroup
			//   https://html.spec.whatwg.org/multipage/forms.html#concept-option-disabled
			// All such elements have a "form" property.
			if ( elem.parentNode && elem.disabled === false ) {

				// Option elements defer to a parent optgroup if present
				if ( "label" in elem ) {
					if ( "label" in elem.parentNode ) {
						return elem.parentNode.disabled === disabled;
					} else {
						return elem.disabled === disabled;
					}
				}

				// Support: IE 6 - 11
				// Use the isDisabled shortcut property to check for disabled fieldset ancestors
				return elem.isDisabled === disabled ||

					// Where there is no isDisabled, check manually
					/* jshint -W018 */
					elem.isDisabled !== !disabled &&
						disabledAncestor( elem ) === disabled;
			}

			return elem.disabled === disabled;

		// Try to winnow out elements that can't be disabled before trusting the disabled property.
		// Some victims get caught in our net (label, legend, menu, track), but it shouldn't
		// even exist on them, let alone have a boolean value.
		} else if ( "label" in elem ) {
			return elem.disabled === disabled;
		}

		// Remaining elements are neither :enabled nor :disabled
		return false;
	};
}

/**
 * Returns a function to use in pseudos for positionals
 * @param {Function} fn
 */
function createPositionalPseudo( fn ) {
	return markFunction(function( argument ) {
		argument = +argument;
		return markFunction(function( seed, matches ) {
			var j,
				matchIndexes = fn( [], seed.length, argument ),
				i = matchIndexes.length;

			// Match elements found at the specified indexes
			while ( i-- ) {
				if ( seed[ (j = matchIndexes[i]) ] ) {
					seed[j] = !(matches[j] = seed[j]);
				}
			}
		});
	});
}

/**
 * Checks a node for validity as a Sizzle context
 * @param {Element|Object=} context
 * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value
 */
function testContext( context ) {
	return context && typeof context.getElementsByTagName !== "undefined" && context;
}

// Expose support vars for convenience
support = Sizzle.support = {};

/**
 * Detects XML nodes
 * @param {Element|Object} elem An element or a document
 * @returns {Boolean} True iff elem is a non-HTML XML node
 */
isXML = Sizzle.isXML = function( elem ) {
	// documentElement is verified for cases where it doesn't yet exist
	// (such as loading iframes in IE - #4833)
	var documentElement = elem && (elem.ownerDocument || elem).documentElement;
	return documentElement ? documentElement.nodeName !== "HTML" : false;
};

/**
 * Sets document-related variables once based on the current document
 * @param {Element|Object} [doc] An element or document object to use to set the document
 * @returns {Object} Returns the current document
 */
setDocument = Sizzle.setDocument = function( node ) {
	var hasCompare, subWindow,
		doc = node ? node.ownerDocument || node : preferredDoc;

	// Return early if doc is invalid or already selected
	if ( doc === document || doc.nodeType !== 9 || !doc.documentElement ) {
		return document;
	}

	// Update global variables
	document = doc;
	docElem = document.documentElement;
	documentIsHTML = !isXML( document );

	// Support: IE 9-11, Edge
	// Accessing iframe documents after unload throws "permission denied" errors (jQuery #13936)
	if ( preferredDoc !== document &&
		(subWindow = document.defaultView) && subWindow.top !== subWindow ) {

		// Support: IE 11, Edge
		if ( subWindow.addEventListener ) {
			subWindow.addEventListener( "unload", unloadHandler, false );

		// Support: IE 9 - 10 only
		} else if ( subWindow.attachEvent ) {
			subWindow.attachEvent( "onunload", unloadHandler );
		}
	}

	/* Attributes
	---------------------------------------------------------------------- */

	// Support: IE<8
	// Verify that getAttribute really returns attributes and not properties
	// (excepting IE8 booleans)
	support.attributes = assert(function( el ) {
		el.className = "i";
		return !el.getAttribute("className");
	});

	/* getElement(s)By*
	---------------------------------------------------------------------- */

	// Check if getElementsByTagName("*") returns only elements
	support.getElementsByTagName = assert(function( el ) {
		el.appendChild( document.createComment("") );
		return !el.getElementsByTagName("*").length;
	});

	// Support: IE<9
	support.getElementsByClassName = rnative.test( document.getElementsByClassName );

	// Support: IE<10
	// Check if getElementById returns elements by name
	// The broken getElementById methods don't pick up programmatically-set names,
	// so use a roundabout getElementsByName test
	support.getById = assert(function( el ) {
		docElem.appendChild( el ).id = expando;
		return !document.getElementsByName || !document.getElementsByName( expando ).length;
	});

	// ID filter and find
	if ( support.getById ) {
		Expr.filter["ID"] = function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				return elem.getAttribute("id") === attrId;
			};
		};
		Expr.find["ID"] = function( id, context ) {
			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
				var elem = context.getElementById( id );
				return elem ? [ elem ] : [];
			}
		};
	} else {
		Expr.filter["ID"] =  function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				var node = typeof elem.getAttributeNode !== "undefined" &&
					elem.getAttributeNode("id");
				return node && node.value === attrId;
			};
		};

		// Support: IE 6 - 7 only
		// getElementById is not reliable as a find shortcut
		Expr.find["ID"] = function( id, context ) {
			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
				var node, i, elems,
					elem = context.getElementById( id );

				if ( elem ) {

					// Verify the id attribute
					node = elem.getAttributeNode("id");
					if ( node && node.value === id ) {
						return [ elem ];
					}

					// Fall back on getElementsByName
					elems = context.getElementsByName( id );
					i = 0;
					while ( (elem = elems[i++]) ) {
						node = elem.getAttributeNode("id");
						if ( node && node.value === id ) {
							return [ elem ];
						}
					}
				}

				return [];
			}
		};
	}

	// Tag
	Expr.find["TAG"] = support.getElementsByTagName ?
		function( tag, context ) {
			if ( typeof context.getElementsByTagName !== "undefined" ) {
				return context.getElementsByTagName( tag );

			// DocumentFragment nodes don't have gEBTN
			} else if ( support.qsa ) {
				return context.querySelectorAll( tag );
			}
		} :

		function( tag, context ) {
			var elem,
				tmp = [],
				i = 0,
				// By happy coincidence, a (broken) gEBTN appears on DocumentFragment nodes too
				results = context.getElementsByTagName( tag );

			// Filter out possible comments
			if ( tag === "*" ) {
				while ( (elem = results[i++]) ) {
					if ( elem.nodeType === 1 ) {
						tmp.push( elem );
					}
				}

				return tmp;
			}
			return results;
		};

	// Class
	Expr.find["CLASS"] = support.getElementsByClassName && function( className, context ) {
		if ( typeof context.getElementsByClassName !== "undefined" && documentIsHTML ) {
			return context.getElementsByClassName( className );
		}
	};

	/* QSA/matchesSelector
	---------------------------------------------------------------------- */

	// QSA and matchesSelector support

	// matchesSelector(:active) reports false when true (IE9/Opera 11.5)
	rbuggyMatches = [];

	// qSa(:focus) reports false when true (Chrome 21)
	// We allow this because of a bug in IE8/9 that throws an error
	// whenever `document.activeElement` is accessed on an iframe
	// So, we allow :focus to pass through QSA all the time to avoid the IE error
	// See https://bugs.jquery.com/ticket/13378
	rbuggyQSA = [];

	if ( (support.qsa = rnative.test( document.querySelectorAll )) ) {
		// Build QSA regex
		// Regex strategy adopted from Diego Perini
		assert(function( el ) {
			// Select is set to empty string on purpose
			// This is to test IE's treatment of not explicitly
			// setting a boolean content attribute,
			// since its presence should be enough
			// https://bugs.jquery.com/ticket/12359
			docElem.appendChild( el ).innerHTML = "<a id='" + expando + "'></a>" +
				"<select id='" + expando + "-\r\\' msallowcapture=''>" +
				"<option selected=''></option></select>";

			// Support: IE8, Opera 11-12.16
			// Nothing should be selected when empty strings follow ^= or $= or *=
			// The test attribute must be unknown in Opera but "safe" for WinRT
			// https://msdn.microsoft.com/en-us/library/ie/hh465388.aspx#attribute_section
			if ( el.querySelectorAll("[msallowcapture^='']").length ) {
				rbuggyQSA.push( "[*^$]=" + whitespace + "*(?:''|\"\")" );
			}

			// Support: IE8
			// Boolean attributes and "value" are not treated correctly
			if ( !el.querySelectorAll("[selected]").length ) {
				rbuggyQSA.push( "\\[" + whitespace + "*(?:value|" + booleans + ")" );
			}

			// Support: Chrome<29, Android<4.4, Safari<7.0+, iOS<7.0+, PhantomJS<1.9.8+
			if ( !el.querySelectorAll( "[id~=" + expando + "-]" ).length ) {
				rbuggyQSA.push("~=");
			}

			// Webkit/Opera - :checked should return selected option elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			// IE8 throws error here and will not see later tests
			if ( !el.querySelectorAll(":checked").length ) {
				rbuggyQSA.push(":checked");
			}

			// Support: Safari 8+, iOS 8+
			// https://bugs.webkit.org/show_bug.cgi?id=136851
			// In-page `selector#id sibling-combinator selector` fails
			if ( !el.querySelectorAll( "a#" + expando + "+*" ).length ) {
				rbuggyQSA.push(".#.+[+~]");
			}
		});

		assert(function( el ) {
			el.innerHTML = "<a href='' disabled='disabled'></a>" +
				"<select disabled='disabled'><option/></select>";

			// Support: Windows 8 Native Apps
			// The type and name attributes are restricted during .innerHTML assignment
			var input = document.createElement("input");
			input.setAttribute( "type", "hidden" );
			el.appendChild( input ).setAttribute( "name", "D" );

			// Support: IE8
			// Enforce case-sensitivity of name attribute
			if ( el.querySelectorAll("[name=d]").length ) {
				rbuggyQSA.push( "name" + whitespace + "*[*^$|!~]?=" );
			}

			// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
			// IE8 throws error here and will not see later tests
			if ( el.querySelectorAll(":enabled").length !== 2 ) {
				rbuggyQSA.push( ":enabled", ":disabled" );
			}

			// Support: IE9-11+
			// IE's :disabled selector does not pick up the children of disabled fieldsets
			docElem.appendChild( el ).disabled = true;
			if ( el.querySelectorAll(":disabled").length !== 2 ) {
				rbuggyQSA.push( ":enabled", ":disabled" );
			}

			// Opera 10-11 does not throw on post-comma invalid pseudos
			el.querySelectorAll("*,:x");
			rbuggyQSA.push(",.*:");
		});
	}

	if ( (support.matchesSelector = rnative.test( (matches = docElem.matches ||
		docElem.webkitMatchesSelector ||
		docElem.mozMatchesSelector ||
		docElem.oMatchesSelector ||
		docElem.msMatchesSelector) )) ) {

		assert(function( el ) {
			// Check to see if it's possible to do matchesSelector
			// on a disconnected node (IE 9)
			support.disconnectedMatch = matches.call( el, "*" );

			// This should fail with an exception
			// Gecko does not error, returns false instead
			matches.call( el, "[s!='']:x" );
			rbuggyMatches.push( "!=", pseudos );
		});
	}

	rbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join("|") );
	rbuggyMatches = rbuggyMatches.length && new RegExp( rbuggyMatches.join("|") );

	/* Contains
	---------------------------------------------------------------------- */
	hasCompare = rnative.test( docElem.compareDocumentPosition );

	// Element contains another
	// Purposefully self-exclusive
	// As in, an element does not contain itself
	contains = hasCompare || rnative.test( docElem.contains ) ?
		function( a, b ) {
			var adown = a.nodeType === 9 ? a.documentElement : a,
				bup = b && b.parentNode;
			return a === bup || !!( bup && bup.nodeType === 1 && (
				adown.contains ?
					adown.contains( bup ) :
					a.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16
			));
		} :
		function( a, b ) {
			if ( b ) {
				while ( (b = b.parentNode) ) {
					if ( b === a ) {
						return true;
					}
				}
			}
			return false;
		};

	/* Sorting
	---------------------------------------------------------------------- */

	// Document order sorting
	sortOrder = hasCompare ?
	function( a, b ) {

		// Flag for duplicate removal
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		// Sort on method existence if only one input has compareDocumentPosition
		var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;
		if ( compare ) {
			return compare;
		}

		// Calculate position if both inputs belong to the same document
		compare = ( a.ownerDocument || a ) === ( b.ownerDocument || b ) ?
			a.compareDocumentPosition( b ) :

			// Otherwise we know they are disconnected
			1;

		// Disconnected nodes
		if ( compare & 1 ||
			(!support.sortDetached && b.compareDocumentPosition( a ) === compare) ) {

			// Choose the first element that is related to our preferred document
			if ( a === document || a.ownerDocument === preferredDoc && contains(preferredDoc, a) ) {
				return -1;
			}
			if ( b === document || b.ownerDocument === preferredDoc && contains(preferredDoc, b) ) {
				return 1;
			}

			// Maintain original order
			return sortInput ?
				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
				0;
		}

		return compare & 4 ? -1 : 1;
	} :
	function( a, b ) {
		// Exit early if the nodes are identical
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		var cur,
			i = 0,
			aup = a.parentNode,
			bup = b.parentNode,
			ap = [ a ],
			bp = [ b ];

		// Parentless nodes are either documents or disconnected
		if ( !aup || !bup ) {
			return a === document ? -1 :
				b === document ? 1 :
				aup ? -1 :
				bup ? 1 :
				sortInput ?
				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
				0;

		// If the nodes are siblings, we can do a quick check
		} else if ( aup === bup ) {
			return siblingCheck( a, b );
		}

		// Otherwise we need full lists of their ancestors for comparison
		cur = a;
		while ( (cur = cur.parentNode) ) {
			ap.unshift( cur );
		}
		cur = b;
		while ( (cur = cur.parentNode) ) {
			bp.unshift( cur );
		}

		// Walk down the tree looking for a discrepancy
		while ( ap[i] === bp[i] ) {
			i++;
		}

		return i ?
			// Do a sibling check if the nodes have a common ancestor
			siblingCheck( ap[i], bp[i] ) :

			// Otherwise nodes in our document sort first
			ap[i] === preferredDoc ? -1 :
			bp[i] === preferredDoc ? 1 :
			0;
	};

	return document;
};

Sizzle.matches = function( expr, elements ) {
	return Sizzle( expr, null, null, elements );
};

Sizzle.matchesSelector = function( elem, expr ) {
	// Set document vars if needed
	if ( ( elem.ownerDocument || elem ) !== document ) {
		setDocument( elem );
	}

	// Make sure that attribute selectors are quoted
	expr = expr.replace( rattributeQuotes, "='$1']" );

	if ( support.matchesSelector && documentIsHTML &&
		!compilerCache[ expr + " " ] &&
		( !rbuggyMatches || !rbuggyMatches.test( expr ) ) &&
		( !rbuggyQSA     || !rbuggyQSA.test( expr ) ) ) {

		try {
			var ret = matches.call( elem, expr );

			// IE 9's matchesSelector returns false on disconnected nodes
			if ( ret || support.disconnectedMatch ||
					// As well, disconnected nodes are said to be in a document
					// fragment in IE 9
					elem.document && elem.document.nodeType !== 11 ) {
				return ret;
			}
		} catch (e) {}
	}

	return Sizzle( expr, document, null, [ elem ] ).length > 0;
};

Sizzle.contains = function( context, elem ) {
	// Set document vars if needed
	if ( ( context.ownerDocument || context ) !== document ) {
		setDocument( context );
	}
	return contains( context, elem );
};

Sizzle.attr = function( elem, name ) {
	// Set document vars if needed
	if ( ( elem.ownerDocument || elem ) !== document ) {
		setDocument( elem );
	}

	var fn = Expr.attrHandle[ name.toLowerCase() ],
		// Don't get fooled by Object.prototype properties (jQuery #13807)
		val = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?
			fn( elem, name, !documentIsHTML ) :
			undefined;

	return val !== undefined ?
		val :
		support.attributes || !documentIsHTML ?
			elem.getAttribute( name ) :
			(val = elem.getAttributeNode(name)) && val.specified ?
				val.value :
				null;
};

Sizzle.escape = function( sel ) {
	return (sel + "").replace( rcssescape, fcssescape );
};

Sizzle.error = function( msg ) {
	throw new Error( "Syntax error, unrecognized expression: " + msg );
};

/**
 * Document sorting and removing duplicates
 * @param {ArrayLike} results
 */
Sizzle.uniqueSort = function( results ) {
	var elem,
		duplicates = [],
		j = 0,
		i = 0;

	// Unless we *know* we can detect duplicates, assume their presence
	hasDuplicate = !support.detectDuplicates;
	sortInput = !support.sortStable && results.slice( 0 );
	results.sort( sortOrder );

	if ( hasDuplicate ) {
		while ( (elem = results[i++]) ) {
			if ( elem === results[ i ] ) {
				j = duplicates.push( i );
			}
		}
		while ( j-- ) {
			results.splice( duplicates[ j ], 1 );
		}
	}

	// Clear input after sorting to release objects
	// See https://github.com/jquery/sizzle/pull/225
	sortInput = null;

	return results;
};

/**
 * Utility function for retrieving the text value of an array of DOM nodes
 * @param {Array|Element} elem
 */
getText = Sizzle.getText = function( elem ) {
	var node,
		ret = "",
		i = 0,
		nodeType = elem.nodeType;

	if ( !nodeType ) {
		// If no nodeType, this is expected to be an array
		while ( (node = elem[i++]) ) {
			// Do not traverse comment nodes
			ret += getText( node );
		}
	} else if ( nodeType === 1 || nodeType === 9 || nodeType === 11 ) {
		// Use textContent for elements
		// innerText usage removed for consistency of new lines (jQuery #11153)
		if ( typeof elem.textContent === "string" ) {
			return elem.textContent;
		} else {
			// Traverse its children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				ret += getText( elem );
			}
		}
	} else if ( nodeType === 3 || nodeType === 4 ) {
		return elem.nodeValue;
	}
	// Do not include comment or processing instruction nodes

	return ret;
};

Expr = Sizzle.selectors = {

	// Can be adjusted by the user
	cacheLength: 50,

	createPseudo: markFunction,

	match: matchExpr,

	attrHandle: {},

	find: {},

	relative: {
		">": { dir: "parentNode", first: true },
		" ": { dir: "parentNode" },
		"+": { dir: "previousSibling", first: true },
		"~": { dir: "previousSibling" }
	},

	preFilter: {
		"ATTR": function( match ) {
			match[1] = match[1].replace( runescape, funescape );

			// Move the given value to match[3] whether quoted or unquoted
			match[3] = ( match[3] || match[4] || match[5] || "" ).replace( runescape, funescape );

			if ( match[2] === "~=" ) {
				match[3] = " " + match[3] + " ";
			}

			return match.slice( 0, 4 );
		},

		"CHILD": function( match ) {
			/* matches from matchExpr["CHILD"]
				1 type (only|nth|...)
				2 what (child|of-type)
				3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
				4 xn-component of xn+y argument ([+-]?\d*n|)
				5 sign of xn-component
				6 x of xn-component
				7 sign of y-component
				8 y of y-component
			*/
			match[1] = match[1].toLowerCase();

			if ( match[1].slice( 0, 3 ) === "nth" ) {
				// nth-* requires argument
				if ( !match[3] ) {
					Sizzle.error( match[0] );
				}

				// numeric x and y parameters for Expr.filter.CHILD
				// remember that false/true cast respectively to 0/1
				match[4] = +( match[4] ? match[5] + (match[6] || 1) : 2 * ( match[3] === "even" || match[3] === "odd" ) );
				match[5] = +( ( match[7] + match[8] ) || match[3] === "odd" );

			// other types prohibit arguments
			} else if ( match[3] ) {
				Sizzle.error( match[0] );
			}

			return match;
		},

		"PSEUDO": function( match ) {
			var excess,
				unquoted = !match[6] && match[2];

			if ( matchExpr["CHILD"].test( match[0] ) ) {
				return null;
			}

			// Accept quoted arguments as-is
			if ( match[3] ) {
				match[2] = match[4] || match[5] || "";

			// Strip excess characters from unquoted arguments
			} else if ( unquoted && rpseudo.test( unquoted ) &&
				// Get excess from tokenize (recursively)
				(excess = tokenize( unquoted, true )) &&
				// advance to the next closing parenthesis
				(excess = unquoted.indexOf( ")", unquoted.length - excess ) - unquoted.length) ) {

				// excess is a negative index
				match[0] = match[0].slice( 0, excess );
				match[2] = unquoted.slice( 0, excess );
			}

			// Return only captures needed by the pseudo filter method (type and argument)
			return match.slice( 0, 3 );
		}
	},

	filter: {

		"TAG": function( nodeNameSelector ) {
			var nodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();
			return nodeNameSelector === "*" ?
				function() { return true; } :
				function( elem ) {
					return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
				};
		},

		"CLASS": function( className ) {
			var pattern = classCache[ className + " " ];

			return pattern ||
				(pattern = new RegExp( "(^|" + whitespace + ")" + className + "(" + whitespace + "|$)" )) &&
				classCache( className, function( elem ) {
					return pattern.test( typeof elem.className === "string" && elem.className || typeof elem.getAttribute !== "undefined" && elem.getAttribute("class") || "" );
				});
		},

		"ATTR": function( name, operator, check ) {
			return function( elem ) {
				var result = Sizzle.attr( elem, name );

				if ( result == null ) {
					return operator === "!=";
				}
				if ( !operator ) {
					return true;
				}

				result += "";

				return operator === "=" ? result === check :
					operator === "!=" ? result !== check :
					operator === "^=" ? check && result.indexOf( check ) === 0 :
					operator === "*=" ? check && result.indexOf( check ) > -1 :
					operator === "$=" ? check && result.slice( -check.length ) === check :
					operator === "~=" ? ( " " + result.replace( rwhitespace, " " ) + " " ).indexOf( check ) > -1 :
					operator === "|=" ? result === check || result.slice( 0, check.length + 1 ) === check + "-" :
					false;
			};
		},

		"CHILD": function( type, what, argument, first, last ) {
			var simple = type.slice( 0, 3 ) !== "nth",
				forward = type.slice( -4 ) !== "last",
				ofType = what === "of-type";

			return first === 1 && last === 0 ?

				// Shortcut for :nth-*(n)
				function( elem ) {
					return !!elem.parentNode;
				} :

				function( elem, context, xml ) {
					var cache, uniqueCache, outerCache, node, nodeIndex, start,
						dir = simple !== forward ? "nextSibling" : "previousSibling",
						parent = elem.parentNode,
						name = ofType && elem.nodeName.toLowerCase(),
						useCache = !xml && !ofType,
						diff = false;

					if ( parent ) {

						// :(first|last|only)-(child|of-type)
						if ( simple ) {
							while ( dir ) {
								node = elem;
								while ( (node = node[ dir ]) ) {
									if ( ofType ?
										node.nodeName.toLowerCase() === name :
										node.nodeType === 1 ) {

										return false;
									}
								}
								// Reverse direction for :only-* (if we haven't yet done so)
								start = dir = type === "only" && !start && "nextSibling";
							}
							return true;
						}

						start = [ forward ? parent.firstChild : parent.lastChild ];

						// non-xml :nth-child(...) stores cache data on `parent`
						if ( forward && useCache ) {

							// Seek `elem` from a previously-cached index

							// ...in a gzip-friendly way
							node = parent;
							outerCache = node[ expando ] || (node[ expando ] = {});

							// Support: IE <9 only
							// Defend against cloned attroperties (jQuery gh-1709)
							uniqueCache = outerCache[ node.uniqueID ] ||
								(outerCache[ node.uniqueID ] = {});

							cache = uniqueCache[ type ] || [];
							nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
							diff = nodeIndex && cache[ 2 ];
							node = nodeIndex && parent.childNodes[ nodeIndex ];

							while ( (node = ++nodeIndex && node && node[ dir ] ||

								// Fallback to seeking `elem` from the start
								(diff = nodeIndex = 0) || start.pop()) ) {

								// When found, cache indexes on `parent` and break
								if ( node.nodeType === 1 && ++diff && node === elem ) {
									uniqueCache[ type ] = [ dirruns, nodeIndex, diff ];
									break;
								}
							}

						} else {
							// Use previously-cached element index if available
							if ( useCache ) {
								// ...in a gzip-friendly way
								node = elem;
								outerCache = node[ expando ] || (node[ expando ] = {});

								// Support: IE <9 only
								// Defend against cloned attroperties (jQuery gh-1709)
								uniqueCache = outerCache[ node.uniqueID ] ||
									(outerCache[ node.uniqueID ] = {});

								cache = uniqueCache[ type ] || [];
								nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
								diff = nodeIndex;
							}

							// xml :nth-child(...)
							// or :nth-last-child(...) or :nth(-last)?-of-type(...)
							if ( diff === false ) {
								// Use the same loop as above to seek `elem` from the start
								while ( (node = ++nodeIndex && node && node[ dir ] ||
									(diff = nodeIndex = 0) || start.pop()) ) {

									if ( ( ofType ?
										node.nodeName.toLowerCase() === name :
										node.nodeType === 1 ) &&
										++diff ) {

										// Cache the index of each encountered element
										if ( useCache ) {
											outerCache = node[ expando ] || (node[ expando ] = {});

											// Support: IE <9 only
											// Defend against cloned attroperties (jQuery gh-1709)
											uniqueCache = outerCache[ node.uniqueID ] ||
												(outerCache[ node.uniqueID ] = {});

											uniqueCache[ type ] = [ dirruns, diff ];
										}

										if ( node === elem ) {
											break;
										}
									}
								}
							}
						}

						// Incorporate the offset, then check against cycle size
						diff -= last;
						return diff === first || ( diff % first === 0 && diff / first >= 0 );
					}
				};
		},

		"PSEUDO": function( pseudo, argument ) {
			// pseudo-class names are case-insensitive
			// http://www.w3.org/TR/selectors/#pseudo-classes
			// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
			// Remember that setFilters inherits from pseudos
			var args,
				fn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||
					Sizzle.error( "unsupported pseudo: " + pseudo );

			// The user may use createPseudo to indicate that
			// arguments are needed to create the filter function
			// just as Sizzle does
			if ( fn[ expando ] ) {
				return fn( argument );
			}

			// But maintain support for old signatures
			if ( fn.length > 1 ) {
				args = [ pseudo, pseudo, "", argument ];
				return Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?
					markFunction(function( seed, matches ) {
						var idx,
							matched = fn( seed, argument ),
							i = matched.length;
						while ( i-- ) {
							idx = indexOf( seed, matched[i] );
							seed[ idx ] = !( matches[ idx ] = matched[i] );
						}
					}) :
					function( elem ) {
						return fn( elem, 0, args );
					};
			}

			return fn;
		}
	},

	pseudos: {
		// Potentially complex pseudos
		"not": markFunction(function( selector ) {
			// Trim the selector passed to compile
			// to avoid treating leading and trailing
			// spaces as combinators
			var input = [],
				results = [],
				matcher = compile( selector.replace( rtrim, "$1" ) );

			return matcher[ expando ] ?
				markFunction(function( seed, matches, context, xml ) {
					var elem,
						unmatched = matcher( seed, null, xml, [] ),
						i = seed.length;

					// Match elements unmatched by `matcher`
					while ( i-- ) {
						if ( (elem = unmatched[i]) ) {
							seed[i] = !(matches[i] = elem);
						}
					}
				}) :
				function( elem, context, xml ) {
					input[0] = elem;
					matcher( input, null, xml, results );
					// Don't keep the element (issue #299)
					input[0] = null;
					return !results.pop();
				};
		}),

		"has": markFunction(function( selector ) {
			return function( elem ) {
				return Sizzle( selector, elem ).length > 0;
			};
		}),

		"contains": markFunction(function( text ) {
			text = text.replace( runescape, funescape );
			return function( elem ) {
				return ( elem.textContent || elem.innerText || getText( elem ) ).indexOf( text ) > -1;
			};
		}),

		// "Whether an element is represented by a :lang() selector
		// is based solely on the element's language value
		// being equal to the identifier C,
		// or beginning with the identifier C immediately followed by "-".
		// The matching of C against the element's language value is performed case-insensitively.
		// The identifier C does not have to be a valid language name."
		// http://www.w3.org/TR/selectors/#lang-pseudo
		"lang": markFunction( function( lang ) {
			// lang value must be a valid identifier
			if ( !ridentifier.test(lang || "") ) {
				Sizzle.error( "unsupported lang: " + lang );
			}
			lang = lang.replace( runescape, funescape ).toLowerCase();
			return function( elem ) {
				var elemLang;
				do {
					if ( (elemLang = documentIsHTML ?
						elem.lang :
						elem.getAttribute("xml:lang") || elem.getAttribute("lang")) ) {

						elemLang = elemLang.toLowerCase();
						return elemLang === lang || elemLang.indexOf( lang + "-" ) === 0;
					}
				} while ( (elem = elem.parentNode) && elem.nodeType === 1 );
				return false;
			};
		}),

		// Miscellaneous
		"target": function( elem ) {
			var hash = window.location && window.location.hash;
			return hash && hash.slice( 1 ) === elem.id;
		},

		"root": function( elem ) {
			return elem === docElem;
		},

		"focus": function( elem ) {
			return elem === document.activeElement && (!document.hasFocus || document.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);
		},

		// Boolean properties
		"enabled": createDisabledPseudo( false ),
		"disabled": createDisabledPseudo( true ),

		"checked": function( elem ) {
			// In CSS3, :checked should return both checked and selected elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			var nodeName = elem.nodeName.toLowerCase();
			return (nodeName === "input" && !!elem.checked) || (nodeName === "option" && !!elem.selected);
		},

		"selected": function( elem ) {
			// Accessing this property makes selected-by-default
			// options in Safari work properly
			if ( elem.parentNode ) {
				elem.parentNode.selectedIndex;
			}

			return elem.selected === true;
		},

		// Contents
		"empty": function( elem ) {
			// http://www.w3.org/TR/selectors/#empty-pseudo
			// :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),
			//   but not by others (comment: 8; processing instruction: 7; etc.)
			// nodeType < 6 works because attributes (2) do not appear as children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				if ( elem.nodeType < 6 ) {
					return false;
				}
			}
			return true;
		},

		"parent": function( elem ) {
			return !Expr.pseudos["empty"]( elem );
		},

		// Element/input types
		"header": function( elem ) {
			return rheader.test( elem.nodeName );
		},

		"input": function( elem ) {
			return rinputs.test( elem.nodeName );
		},

		"button": function( elem ) {
			var name = elem.nodeName.toLowerCase();
			return name === "input" && elem.type === "button" || name === "button";
		},

		"text": function( elem ) {
			var attr;
			return elem.nodeName.toLowerCase() === "input" &&
				elem.type === "text" &&

				// Support: IE<8
				// New HTML5 attribute values (e.g., "search") appear with elem.type === "text"
				( (attr = elem.getAttribute("type")) == null || attr.toLowerCase() === "text" );
		},

		// Position-in-collection
		"first": createPositionalPseudo(function() {
			return [ 0 ];
		}),

		"last": createPositionalPseudo(function( matchIndexes, length ) {
			return [ length - 1 ];
		}),

		"eq": createPositionalPseudo(function( matchIndexes, length, argument ) {
			return [ argument < 0 ? argument + length : argument ];
		}),

		"even": createPositionalPseudo(function( matchIndexes, length ) {
			var i = 0;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"odd": createPositionalPseudo(function( matchIndexes, length ) {
			var i = 1;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"lt": createPositionalPseudo(function( matchIndexes, length, argument ) {
			var i = argument < 0 ? argument + length : argument;
			for ( ; --i >= 0; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"gt": createPositionalPseudo(function( matchIndexes, length, argument ) {
			var i = argument < 0 ? argument + length : argument;
			for ( ; ++i < length; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		})
	}
};

Expr.pseudos["nth"] = Expr.pseudos["eq"];

// Add button/input type pseudos
for ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {
	Expr.pseudos[ i ] = createInputPseudo( i );
}
for ( i in { submit: true, reset: true } ) {
	Expr.pseudos[ i ] = createButtonPseudo( i );
}

// Easy API for creating new setFilters
function setFilters() {}
setFilters.prototype = Expr.filters = Expr.pseudos;
Expr.setFilters = new setFilters();

tokenize = Sizzle.tokenize = function( selector, parseOnly ) {
	var matched, match, tokens, type,
		soFar, groups, preFilters,
		cached = tokenCache[ selector + " " ];

	if ( cached ) {
		return parseOnly ? 0 : cached.slice( 0 );
	}

	soFar = selector;
	groups = [];
	preFilters = Expr.preFilter;

	while ( soFar ) {

		// Comma and first run
		if ( !matched || (match = rcomma.exec( soFar )) ) {
			if ( match ) {
				// Don't consume trailing commas as valid
				soFar = soFar.slice( match[0].length ) || soFar;
			}
			groups.push( (tokens = []) );
		}

		matched = false;

		// Combinators
		if ( (match = rcombinators.exec( soFar )) ) {
			matched = match.shift();
			tokens.push({
				value: matched,
				// Cast descendant combinators to space
				type: match[0].replace( rtrim, " " )
			});
			soFar = soFar.slice( matched.length );
		}

		// Filters
		for ( type in Expr.filter ) {
			if ( (match = matchExpr[ type ].exec( soFar )) && (!preFilters[ type ] ||
				(match = preFilters[ type ]( match ))) ) {
				matched = match.shift();
				tokens.push({
					value: matched,
					type: type,
					matches: match
				});
				soFar = soFar.slice( matched.length );
			}
		}

		if ( !matched ) {
			break;
		}
	}

	// Return the length of the invalid excess
	// if we're just parsing
	// Otherwise, throw an error or return tokens
	return parseOnly ?
		soFar.length :
		soFar ?
			Sizzle.error( selector ) :
			// Cache the tokens
			tokenCache( selector, groups ).slice( 0 );
};

function toSelector( tokens ) {
	var i = 0,
		len = tokens.length,
		selector = "";
	for ( ; i < len; i++ ) {
		selector += tokens[i].value;
	}
	return selector;
}

function addCombinator( matcher, combinator, base ) {
	var dir = combinator.dir,
		skip = combinator.next,
		key = skip || dir,
		checkNonElements = base && key === "parentNode",
		doneName = done++;

	return combinator.first ?
		// Check against closest ancestor/preceding element
		function( elem, context, xml ) {
			while ( (elem = elem[ dir ]) ) {
				if ( elem.nodeType === 1 || checkNonElements ) {
					return matcher( elem, context, xml );
				}
			}
			return false;
		} :

		// Check against all ancestor/preceding elements
		function( elem, context, xml ) {
			var oldCache, uniqueCache, outerCache,
				newCache = [ dirruns, doneName ];

			// We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching
			if ( xml ) {
				while ( (elem = elem[ dir ]) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						if ( matcher( elem, context, xml ) ) {
							return true;
						}
					}
				}
			} else {
				while ( (elem = elem[ dir ]) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						outerCache = elem[ expando ] || (elem[ expando ] = {});

						// Support: IE <9 only
						// Defend against cloned attroperties (jQuery gh-1709)
						uniqueCache = outerCache[ elem.uniqueID ] || (outerCache[ elem.uniqueID ] = {});

						if ( skip && skip === elem.nodeName.toLowerCase() ) {
							elem = elem[ dir ] || elem;
						} else if ( (oldCache = uniqueCache[ key ]) &&
							oldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {

							// Assign to newCache so results back-propagate to previous elements
							return (newCache[ 2 ] = oldCache[ 2 ]);
						} else {
							// Reuse newcache so results back-propagate to previous elements
							uniqueCache[ key ] = newCache;

							// A match means we're done; a fail means we have to keep checking
							if ( (newCache[ 2 ] = matcher( elem, context, xml )) ) {
								return true;
							}
						}
					}
				}
			}
			return false;
		};
}

function elementMatcher( matchers ) {
	return matchers.length > 1 ?
		function( elem, context, xml ) {
			var i = matchers.length;
			while ( i-- ) {
				if ( !matchers[i]( elem, context, xml ) ) {
					return false;
				}
			}
			return true;
		} :
		matchers[0];
}

function multipleContexts( selector, contexts, results ) {
	var i = 0,
		len = contexts.length;
	for ( ; i < len; i++ ) {
		Sizzle( selector, contexts[i], results );
	}
	return results;
}

function condense( unmatched, map, filter, context, xml ) {
	var elem,
		newUnmatched = [],
		i = 0,
		len = unmatched.length,
		mapped = map != null;

	for ( ; i < len; i++ ) {
		if ( (elem = unmatched[i]) ) {
			if ( !filter || filter( elem, context, xml ) ) {
				newUnmatched.push( elem );
				if ( mapped ) {
					map.push( i );
				}
			}
		}
	}

	return newUnmatched;
}

function setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {
	if ( postFilter && !postFilter[ expando ] ) {
		postFilter = setMatcher( postFilter );
	}
	if ( postFinder && !postFinder[ expando ] ) {
		postFinder = setMatcher( postFinder, postSelector );
	}
	return markFunction(function( seed, results, context, xml ) {
		var temp, i, elem,
			preMap = [],
			postMap = [],
			preexisting = results.length,

			// Get initial elements from seed or context
			elems = seed || multipleContexts( selector || "*", context.nodeType ? [ context ] : context, [] ),

			// Prefilter to get matcher input, preserving a map for seed-results synchronization
			matcherIn = preFilter && ( seed || !selector ) ?
				condense( elems, preMap, preFilter, context, xml ) :
				elems,

			matcherOut = matcher ?
				// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
				postFinder || ( seed ? preFilter : preexisting || postFilter ) ?

					// ...intermediate processing is necessary
					[] :

					// ...otherwise use results directly
					results :
				matcherIn;

		// Find primary matches
		if ( matcher ) {
			matcher( matcherIn, matcherOut, context, xml );
		}

		// Apply postFilter
		if ( postFilter ) {
			temp = condense( matcherOut, postMap );
			postFilter( temp, [], context, xml );

			// Un-match failing elements by moving them back to matcherIn
			i = temp.length;
			while ( i-- ) {
				if ( (elem = temp[i]) ) {
					matcherOut[ postMap[i] ] = !(matcherIn[ postMap[i] ] = elem);
				}
			}
		}

		if ( seed ) {
			if ( postFinder || preFilter ) {
				if ( postFinder ) {
					// Get the final matcherOut by condensing this intermediate into postFinder contexts
					temp = [];
					i = matcherOut.length;
					while ( i-- ) {
						if ( (elem = matcherOut[i]) ) {
							// Restore matcherIn since elem is not yet a final match
							temp.push( (matcherIn[i] = elem) );
						}
					}
					postFinder( null, (matcherOut = []), temp, xml );
				}

				// Move matched elements from seed to results to keep them synchronized
				i = matcherOut.length;
				while ( i-- ) {
					if ( (elem = matcherOut[i]) &&
						(temp = postFinder ? indexOf( seed, elem ) : preMap[i]) > -1 ) {

						seed[temp] = !(results[temp] = elem);
					}
				}
			}

		// Add elements to results, through postFinder if defined
		} else {
			matcherOut = condense(
				matcherOut === results ?
					matcherOut.splice( preexisting, matcherOut.length ) :
					matcherOut
			);
			if ( postFinder ) {
				postFinder( null, results, matcherOut, xml );
			} else {
				push.apply( results, matcherOut );
			}
		}
	});
}

function matcherFromTokens( tokens ) {
	var checkContext, matcher, j,
		len = tokens.length,
		leadingRelative = Expr.relative[ tokens[0].type ],
		implicitRelative = leadingRelative || Expr.relative[" "],
		i = leadingRelative ? 1 : 0,

		// The foundational matcher ensures that elements are reachable from top-level context(s)
		matchContext = addCombinator( function( elem ) {
			return elem === checkContext;
		}, implicitRelative, true ),
		matchAnyContext = addCombinator( function( elem ) {
			return indexOf( checkContext, elem ) > -1;
		}, implicitRelative, true ),
		matchers = [ function( elem, context, xml ) {
			var ret = ( !leadingRelative && ( xml || context !== outermostContext ) ) || (
				(checkContext = context).nodeType ?
					matchContext( elem, context, xml ) :
					matchAnyContext( elem, context, xml ) );
			// Avoid hanging onto element (issue #299)
			checkContext = null;
			return ret;
		} ];

	for ( ; i < len; i++ ) {
		if ( (matcher = Expr.relative[ tokens[i].type ]) ) {
			matchers = [ addCombinator(elementMatcher( matchers ), matcher) ];
		} else {
			matcher = Expr.filter[ tokens[i].type ].apply( null, tokens[i].matches );

			// Return special upon seeing a positional matcher
			if ( matcher[ expando ] ) {
				// Find the next relative operator (if any) for proper handling
				j = ++i;
				for ( ; j < len; j++ ) {
					if ( Expr.relative[ tokens[j].type ] ) {
						break;
					}
				}
				return setMatcher(
					i > 1 && elementMatcher( matchers ),
					i > 1 && toSelector(
						// If the preceding token was a descendant combinator, insert an implicit any-element `*`
						tokens.slice( 0, i - 1 ).concat({ value: tokens[ i - 2 ].type === " " ? "*" : "" })
					).replace( rtrim, "$1" ),
					matcher,
					i < j && matcherFromTokens( tokens.slice( i, j ) ),
					j < len && matcherFromTokens( (tokens = tokens.slice( j )) ),
					j < len && toSelector( tokens )
				);
			}
			matchers.push( matcher );
		}
	}

	return elementMatcher( matchers );
}

function matcherFromGroupMatchers( elementMatchers, setMatchers ) {
	var bySet = setMatchers.length > 0,
		byElement = elementMatchers.length > 0,
		superMatcher = function( seed, context, xml, results, outermost ) {
			var elem, j, matcher,
				matchedCount = 0,
				i = "0",
				unmatched = seed && [],
				setMatched = [],
				contextBackup = outermostContext,
				// We must always have either seed elements or outermost context
				elems = seed || byElement && Expr.find["TAG"]( "*", outermost ),
				// Use integer dirruns iff this is the outermost matcher
				dirrunsUnique = (dirruns += contextBackup == null ? 1 : Math.random() || 0.1),
				len = elems.length;

			if ( outermost ) {
				outermostContext = context === document || context || outermost;
			}

			// Add elements passing elementMatchers directly to results
			// Support: IE<9, Safari
			// Tolerate NodeList properties (IE: "length"; Safari: <number>) matching elements by id
			for ( ; i !== len && (elem = elems[i]) != null; i++ ) {
				if ( byElement && elem ) {
					j = 0;
					if ( !context && elem.ownerDocument !== document ) {
						setDocument( elem );
						xml = !documentIsHTML;
					}
					while ( (matcher = elementMatchers[j++]) ) {
						if ( matcher( elem, context || document, xml) ) {
							results.push( elem );
							break;
						}
					}
					if ( outermost ) {
						dirruns = dirrunsUnique;
					}
				}

				// Track unmatched elements for set filters
				if ( bySet ) {
					// They will have gone through all possible matchers
					if ( (elem = !matcher && elem) ) {
						matchedCount--;
					}

					// Lengthen the array for every element, matched or not
					if ( seed ) {
						unmatched.push( elem );
					}
				}
			}

			// `i` is now the count of elements visited above, and adding it to `matchedCount`
			// makes the latter nonnegative.
			matchedCount += i;

			// Apply set filters to unmatched elements
			// NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`
			// equals `i`), unless we didn't visit _any_ elements in the above loop because we have
			// no element matchers and no seed.
			// Incrementing an initially-string "0" `i` allows `i` to remain a string only in that
			// case, which will result in a "00" `matchedCount` that differs from `i` but is also
			// numerically zero.
			if ( bySet && i !== matchedCount ) {
				j = 0;
				while ( (matcher = setMatchers[j++]) ) {
					matcher( unmatched, setMatched, context, xml );
				}

				if ( seed ) {
					// Reintegrate element matches to eliminate the need for sorting
					if ( matchedCount > 0 ) {
						while ( i-- ) {
							if ( !(unmatched[i] || setMatched[i]) ) {
								setMatched[i] = pop.call( results );
							}
						}
					}

					// Discard index placeholder values to get only actual matches
					setMatched = condense( setMatched );
				}

				// Add matches to results
				push.apply( results, setMatched );

				// Seedless set matches succeeding multiple successful matchers stipulate sorting
				if ( outermost && !seed && setMatched.length > 0 &&
					( matchedCount + setMatchers.length ) > 1 ) {

					Sizzle.uniqueSort( results );
				}
			}

			// Override manipulation of globals by nested matchers
			if ( outermost ) {
				dirruns = dirrunsUnique;
				outermostContext = contextBackup;
			}

			return unmatched;
		};

	return bySet ?
		markFunction( superMatcher ) :
		superMatcher;
}

compile = Sizzle.compile = function( selector, match /* Internal Use Only */ ) {
	var i,
		setMatchers = [],
		elementMatchers = [],
		cached = compilerCache[ selector + " " ];

	if ( !cached ) {
		// Generate a function of recursive functions that can be used to check each element
		if ( !match ) {
			match = tokenize( selector );
		}
		i = match.length;
		while ( i-- ) {
			cached = matcherFromTokens( match[i] );
			if ( cached[ expando ] ) {
				setMatchers.push( cached );
			} else {
				elementMatchers.push( cached );
			}
		}

		// Cache the compiled function
		cached = compilerCache( selector, matcherFromGroupMatchers( elementMatchers, setMatchers ) );

		// Save selector and tokenization
		cached.selector = selector;
	}
	return cached;
};

/**
 * A low-level selection function that works with Sizzle's compiled
 *  selector functions
 * @param {String|Function} selector A selector or a pre-compiled
 *  selector function built with Sizzle.compile
 * @param {Element} context
 * @param {Array} [results]
 * @param {Array} [seed] A set of elements to match against
 */
select = Sizzle.select = function( selector, context, results, seed ) {
	var i, tokens, token, type, find,
		compiled = typeof selector === "function" && selector,
		match = !seed && tokenize( (selector = compiled.selector || selector) );

	results = results || [];

	// Try to minimize operations if there is only one selector in the list and no seed
	// (the latter of which guarantees us context)
	if ( match.length === 1 ) {

		// Reduce context if the leading compound selector is an ID
		tokens = match[0] = match[0].slice( 0 );
		if ( tokens.length > 2 && (token = tokens[0]).type === "ID" &&
				context.nodeType === 9 && documentIsHTML && Expr.relative[ tokens[1].type ] ) {

			context = ( Expr.find["ID"]( token.matches[0].replace(runescape, funescape), context ) || [] )[0];
			if ( !context ) {
				return results;

			// Precompiled matchers will still verify ancestry, so step up a level
			} else if ( compiled ) {
				context = context.parentNode;
			}

			selector = selector.slice( tokens.shift().value.length );
		}

		// Fetch a seed set for right-to-left matching
		i = matchExpr["needsContext"].test( selector ) ? 0 : tokens.length;
		while ( i-- ) {
			token = tokens[i];

			// Abort if we hit a combinator
			if ( Expr.relative[ (type = token.type) ] ) {
				break;
			}
			if ( (find = Expr.find[ type ]) ) {
				// Search, expanding context for leading sibling combinators
				if ( (seed = find(
					token.matches[0].replace( runescape, funescape ),
					rsibling.test( tokens[0].type ) && testContext( context.parentNode ) || context
				)) ) {

					// If seed is empty or no tokens remain, we can return early
					tokens.splice( i, 1 );
					selector = seed.length && toSelector( tokens );
					if ( !selector ) {
						push.apply( results, seed );
						return results;
					}

					break;
				}
			}
		}
	}

	// Compile and execute a filtering function if one is not provided
	// Provide `match` to avoid retokenization if we modified the selector above
	( compiled || compile( selector, match ) )(
		seed,
		context,
		!documentIsHTML,
		results,
		!context || rsibling.test( selector ) && testContext( context.parentNode ) || context
	);
	return results;
};

// One-time assignments

// Sort stability
support.sortStable = expando.split("").sort( sortOrder ).join("") === expando;

// Support: Chrome 14-35+
// Always assume duplicates if they aren't passed to the comparison function
support.detectDuplicates = !!hasDuplicate;

// Initialize against the default document
setDocument();

// Support: Webkit<537.32 - Safari 6.0.3/Chrome 25 (fixed in Chrome 27)
// Detached nodes confoundingly follow *each other*
support.sortDetached = assert(function( el ) {
	// Should return 1, but returns 4 (following)
	return el.compareDocumentPosition( document.createElement("fieldset") ) & 1;
});

// Support: IE<8
// Prevent attribute/property "interpolation"
// https://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx
if ( !assert(function( el ) {
	el.innerHTML = "<a href='#'></a>";
	return el.firstChild.getAttribute("href") === "#" ;
}) ) {
	addHandle( "type|href|height|width", function( elem, name, isXML ) {
		if ( !isXML ) {
			return elem.getAttribute( name, name.toLowerCase() === "type" ? 1 : 2 );
		}
	});
}

// Support: IE<9
// Use defaultValue in place of getAttribute("value")
if ( !support.attributes || !assert(function( el ) {
	el.innerHTML = "<input/>";
	el.firstChild.setAttribute( "value", "" );
	return el.firstChild.getAttribute( "value" ) === "";
}) ) {
	addHandle( "value", function( elem, name, isXML ) {
		if ( !isXML && elem.nodeName.toLowerCase() === "input" ) {
			return elem.defaultValue;
		}
	});
}

// Support: IE<9
// Use getAttributeNode to fetch booleans when getAttribute lies
if ( !assert(function( el ) {
	return el.getAttribute("disabled") == null;
}) ) {
	addHandle( booleans, function( elem, name, isXML ) {
		var val;
		if ( !isXML ) {
			return elem[ name ] === true ? name.toLowerCase() :
					(val = elem.getAttributeNode( name )) && val.specified ?
					val.value :
				null;
		}
	});
}

return Sizzle;

})( window );



jQuery.find = Sizzle;
jQuery.expr = Sizzle.selectors;

// Deprecated
jQuery.expr[ ":" ] = jQuery.expr.pseudos;
jQuery.uniqueSort = jQuery.unique = Sizzle.uniqueSort;
jQuery.text = Sizzle.getText;
jQuery.isXMLDoc = Sizzle.isXML;
jQuery.contains = Sizzle.contains;
jQuery.escapeSelector = Sizzle.escape;




var dir = function( elem, dir, until ) {
	var matched = [],
		truncate = until !== undefined;

	while ( ( elem = elem[ dir ] ) && elem.nodeType !== 9 ) {
		if ( elem.nodeType === 1 ) {
			if ( truncate && jQuery( elem ).is( until ) ) {
				break;
			}
			matched.push( elem );
		}
	}
	return matched;
};


var siblings = function( n, elem ) {
	var matched = [];

	for ( ; n; n = n.nextSibling ) {
		if ( n.nodeType === 1 && n !== elem ) {
			matched.push( n );
		}
	}

	return matched;
};


var rneedsContext = jQuery.expr.match.needsContext;



function nodeName( elem, name ) {

  return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();

};
var rsingleTag = ( /^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i );



// Implement the identical functionality for filter and not
function winnow( elements, qualifier, not ) {
	if ( isFunction( qualifier ) ) {
		return jQuery.grep( elements, function( elem, i ) {
			return !!qualifier.call( elem, i, elem ) !== not;
		} );
	}

	// Single element
	if ( qualifier.nodeType ) {
		return jQuery.grep( elements, function( elem ) {
			return ( elem === qualifier ) !== not;
		} );
	}

	// Arraylike of elements (jQuery, arguments, Array)
	if ( typeof qualifier !== "string" ) {
		return jQuery.grep( elements, function( elem ) {
			return ( indexOf.call( qualifier, elem ) > -1 ) !== not;
		} );
	}

	// Filtered directly for both simple and complex selectors
	return jQuery.filter( qualifier, elements, not );
}

jQuery.filter = function( expr, elems, not ) {
	var elem = elems[ 0 ];

	if ( not ) {
		expr = ":not(" + expr + ")";
	}

	if ( elems.length === 1 && elem.nodeType === 1 ) {
		return jQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [];
	}

	return jQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {
		return elem.nodeType === 1;
	} ) );
};

jQuery.fn.extend( {
	find: function( selector ) {
		var i, ret,
			len = this.length,
			self = this;

		if ( typeof selector !== "string" ) {
			return this.pushStack( jQuery( selector ).filter( function() {
				for ( i = 0; i < len; i++ ) {
					if ( jQuery.contains( self[ i ], this ) ) {
						return true;
					}
				}
			} ) );
		}

		ret = this.pushStack( [] );

		for ( i = 0; i < len; i++ ) {
			jQuery.find( selector, self[ i ], ret );
		}

		return len > 1 ? jQuery.uniqueSort( ret ) : ret;
	},
	filter: function( selector ) {
		return this.pushStack( winnow( this, selector || [], false ) );
	},
	not: function( selector ) {
		return this.pushStack( winnow( this, selector || [], true ) );
	},
	is: function( selector ) {
		return !!winnow(
			this,

			// If this is a positional/relative selector, check membership in the returned set
			// so $("p:first").is("p:last") won't return true for a doc with two "p".
			typeof selector === "string" && rneedsContext.test( selector ) ?
				jQuery( selector ) :
				selector || [],
			false
		).length;
	}
} );


// Initialize a jQuery object


// A central reference to the root jQuery(document)
var rootjQuery,

	// A simple way to check for HTML strings
	// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
	// Strict HTML recognition (#11290: must start with <)
	// Shortcut simple #id case for speed
	rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,

	init = jQuery.fn.init = function( selector, context, root ) {
		var match, elem;

		// HANDLE: $(""), $(null), $(undefined), $(false)
		if ( !selector ) {
			return this;
		}

		// Method init() accepts an alternate rootjQuery
		// so migrate can support jQuery.sub (gh-2101)
		root = root || rootjQuery;

		// Handle HTML strings
		if ( typeof selector === "string" ) {
			if ( selector[ 0 ] === "<" &&
				selector[ selector.length - 1 ] === ">" &&
				selector.length >= 3 ) {

				// Assume that strings that start and end with <> are HTML and skip the regex check
				match = [ null, selector, null ];

			} else {
				match = rquickExpr.exec( selector );
			}

			// Match html or make sure no context is specified for #id
			if ( match && ( match[ 1 ] || !context ) ) {

				// HANDLE: $(html) -> $(array)
				if ( match[ 1 ] ) {
					context = context instanceof jQuery ? context[ 0 ] : context;

					// Option to run scripts is true for back-compat
					// Intentionally let the error be thrown if parseHTML is not present
					jQuery.merge( this, jQuery.parseHTML(
						match[ 1 ],
						context && context.nodeType ? context.ownerDocument || context : document,
						true
					) );

					// HANDLE: $(html, props)
					if ( rsingleTag.test( match[ 1 ] ) && jQuery.isPlainObject( context ) ) {
						for ( match in context ) {

							// Properties of context are called as methods if possible
							if ( isFunction( this[ match ] ) ) {
								this[ match ]( context[ match ] );

							// ...and otherwise set as attributes
							} else {
								this.attr( match, context[ match ] );
							}
						}
					}

					return this;

				// HANDLE: $(#id)
				} else {
					elem = document.getElementById( match[ 2 ] );

					if ( elem ) {

						// Inject the element directly into the jQuery object
						this[ 0 ] = elem;
						this.length = 1;
					}
					return this;
				}

			// HANDLE: $(expr, $(...))
			} else if ( !context || context.jquery ) {
				return ( context || root ).find( selector );

			// HANDLE: $(expr, context)
			// (which is just equivalent to: $(context).find(expr)
			} else {
				return this.constructor( context ).find( selector );
			}

		// HANDLE: $(DOMElement)
		} else if ( selector.nodeType ) {
			this[ 0 ] = selector;
			this.length = 1;
			return this;

		// HANDLE: $(function)
		// Shortcut for document ready
		} else if ( isFunction( selector ) ) {
			return root.ready !== undefined ?
				root.ready( selector ) :

				// Execute immediately if ready is not present
				selector( jQuery );
		}

		return jQuery.makeArray( selector, this );
	};

// Give the init function the jQuery prototype for later instantiation
init.prototype = jQuery.fn;

// Initialize central reference
rootjQuery = jQuery( document );


var rparentsprev = /^(?:parents|prev(?:Until|All))/,

	// Methods guaranteed to produce a unique set when starting from a unique set
	guaranteedUnique = {
		children: true,
		contents: true,
		next: true,
		prev: true
	};

jQuery.fn.extend( {
	has: function( target ) {
		var targets = jQuery( target, this ),
			l = targets.length;

		return this.filter( function() {
			var i = 0;
			for ( ; i < l; i++ ) {
				if ( jQuery.contains( this, targets[ i ] ) ) {
					return true;
				}
			}
		} );
	},

	closest: function( selectors, context ) {
		var cur,
			i = 0,
			l = this.length,
			matched = [],
			targets = typeof selectors !== "string" && jQuery( selectors );

		// Positional selectors never match, since there's no _selection_ context
		if ( !rneedsContext.test( selectors ) ) {
			for ( ; i < l; i++ ) {
				for ( cur = this[ i ]; cur && cur !== context; cur = cur.parentNode ) {

					// Always skip document fragments
					if ( cur.nodeType < 11 && ( targets ?
						targets.index( cur ) > -1 :

						// Don't pass non-elements to Sizzle
						cur.nodeType === 1 &&
							jQuery.find.matchesSelector( cur, selectors ) ) ) {

						matched.push( cur );
						break;
					}
				}
			}
		}

		return this.pushStack( matched.length > 1 ? jQuery.uniqueSort( matched ) : matched );
	},

	// Determine the position of an element within the set
	index: function( elem ) {

		// No argument, return index in parent
		if ( !elem ) {
			return ( this[ 0 ] && this[ 0 ].parentNode ) ? this.first().prevAll().length : -1;
		}

		// Index in selector
		if ( typeof elem === "string" ) {
			return indexOf.call( jQuery( elem ), this[ 0 ] );
		}

		// Locate the position of the desired element
		return indexOf.call( this,

			// If it receives a jQuery object, the first element is used
			elem.jquery ? elem[ 0 ] : elem
		);
	},

	add: function( selector, context ) {
		return this.pushStack(
			jQuery.uniqueSort(
				jQuery.merge( this.get(), jQuery( selector, context ) )
			)
		);
	},

	addBack: function( selector ) {
		return this.add( selector == null ?
			this.prevObject : this.prevObject.filter( selector )
		);
	}
} );

function sibling( cur, dir ) {
	while ( ( cur = cur[ dir ] ) && cur.nodeType !== 1 ) {}
	return cur;
}

jQuery.each( {
	parent: function( elem ) {
		var parent = elem.parentNode;
		return parent && parent.nodeType !== 11 ? parent : null;
	},
	parents: function( elem ) {
		return dir( elem, "parentNode" );
	},
	parentsUntil: function( elem, i, until ) {
		return dir( elem, "parentNode", until );
	},
	next: function( elem ) {
		return sibling( elem, "nextSibling" );
	},
	prev: function( elem ) {
		return sibling( elem, "previousSibling" );
	},
	nextAll: function( elem ) {
		return dir( elem, "nextSibling" );
	},
	prevAll: function( elem ) {
		return dir( elem, "previousSibling" );
	},
	nextUntil: function( elem, i, until ) {
		return dir( elem, "nextSibling", until );
	},
	prevUntil: function( elem, i, until ) {
		return dir( elem, "previousSibling", until );
	},
	siblings: function( elem ) {
		return siblings( ( elem.parentNode || {} ).firstChild, elem );
	},
	children: function( elem ) {
		return siblings( elem.firstChild );
	},
	contents: function( elem ) {
        if ( nodeName( elem, "iframe" ) ) {
            return elem.contentDocument;
        }

        // Support: IE 9 - 11 only, iOS 7 only, Android Browser <=4.3 only
        // Treat the template element as a regular one in browsers that
        // don't support it.
        if ( nodeName( elem, "template" ) ) {
            elem = elem.content || elem;
        }

        return jQuery.merge( [], elem.childNodes );
	}
}, function( name, fn ) {
	jQuery.fn[ name ] = function( until, selector ) {
		var matched = jQuery.map( this, fn, until );

		if ( name.slice( -5 ) !== "Until" ) {
			selector = until;
		}

		if ( selector && typeof selector === "string" ) {
			matched = jQuery.filter( selector, matched );
		}

		if ( this.length > 1 ) {

			// Remove duplicates
			if ( !guaranteedUnique[ name ] ) {
				jQuery.uniqueSort( matched );
			}

			// Reverse order for parents* and prev-derivatives
			if ( rparentsprev.test( name ) ) {
				matched.reverse();
			}
		}

		return this.pushStack( matched );
	};
} );
var rnothtmlwhite = ( /[^\x20\t\r\n\f]+/g );



// Convert String-formatted options into Object-formatted ones
function createOptions( options ) {
	var object = {};
	jQuery.each( options.match( rnothtmlwhite ) || [], function( _, flag ) {
		object[ flag ] = true;
	} );
	return object;
}

/*
 * Create a callback list using the following parameters:
 *
 *	options: an optional list of space-separated options that will change how
 *			the callback list behaves or a more traditional option object
 *
 * By default a callback list will act like an event callback list and can be
 * "fired" multiple times.
 *
 * Possible options:
 *
 *	once:			will ensure the callback list can only be fired once (like a Deferred)
 *
 *	memory:			will keep track of previous values and will call any callback added
 *					after the list has been fired right away with the latest "memorized"
 *					values (like a Deferred)
 *
 *	unique:			will ensure a callback can only be added once (no duplicate in the list)
 *
 *	stopOnFalse:	interrupt callings when a callback returns false
 *
 */
jQuery.Callbacks = function( options ) {

	// Convert options from String-formatted to Object-formatted if needed
	// (we check in cache first)
	options = typeof options === "string" ?
		createOptions( options ) :
		jQuery.extend( {}, options );

	var // Flag to know if list is currently firing
		firing,

		// Last fire value for non-forgettable lists
		memory,

		// Flag to know if list was already fired
		fired,

		// Flag to prevent firing
		locked,

		// Actual callback list
		list = [],

		// Queue of execution data for repeatable lists
		queue = [],

		// Index of currently firing callback (modified by add/remove as needed)
		firingIndex = -1,

		// Fire callbacks
		fire = function() {

			// Enforce single-firing
			locked = locked || options.once;

			// Execute callbacks for all pending executions,
			// respecting firingIndex overrides and runtime changes
			fired = firing = true;
			for ( ; queue.length; firingIndex = -1 ) {
				memory = queue.shift();
				while ( ++firingIndex < list.length ) {

					// Run callback and check for early termination
					if ( list[ firingIndex ].apply( memory[ 0 ], memory[ 1 ] ) === false &&
						options.stopOnFalse ) {

						// Jump to end and forget the data so .add doesn't re-fire
						firingIndex = list.length;
						memory = false;
					}
				}
			}

			// Forget the data if we're done with it
			if ( !options.memory ) {
				memory = false;
			}

			firing = false;

			// Clean up if we're done firing for good
			if ( locked ) {

				// Keep an empty list if we have data for future add calls
				if ( memory ) {
					list = [];

				// Otherwise, this object is spent
				} else {
					list = "";
				}
			}
		},

		// Actual Callbacks object
		self = {

			// Add a callback or a collection of callbacks to the list
			add: function() {
				if ( list ) {

					// If we have memory from a past run, we should fire after adding
					if ( memory && !firing ) {
						firingIndex = list.length - 1;
						queue.push( memory );
					}

					( function add( args ) {
						jQuery.each( args, function( _, arg ) {
							if ( isFunction( arg ) ) {
								if ( !options.unique || !self.has( arg ) ) {
									list.push( arg );
								}
							} else if ( arg && arg.length && toType( arg ) !== "string" ) {

								// Inspect recursively
								add( arg );
							}
						} );
					} )( arguments );

					if ( memory && !firing ) {
						fire();
					}
				}
				return this;
			},

			// Remove a callback from the list
			remove: function() {
				jQuery.each( arguments, function( _, arg ) {
					var index;
					while ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {
						list.splice( index, 1 );

						// Handle firing indexes
						if ( index <= firingIndex ) {
							firingIndex--;
						}
					}
				} );
				return this;
			},

			// Check if a given callback is in the list.
			// If no argument is given, return whether or not list has callbacks attached.
			has: function( fn ) {
				return fn ?
					jQuery.inArray( fn, list ) > -1 :
					list.length > 0;
			},

			// Remove all callbacks from the list
			empty: function() {
				if ( list ) {
					list = [];
				}
				return this;
			},

			// Disable .fire and .add
			// Abort any current/pending executions
			// Clear all callbacks and values
			disable: function() {
				locked = queue = [];
				list = memory = "";
				return this;
			},
			disabled: function() {
				return !list;
			},

			// Disable .fire
			// Also disable .add unless we have memory (since it would have no effect)
			// Abort any pending executions
			lock: function() {
				locked = queue = [];
				if ( !memory && !firing ) {
					list = memory = "";
				}
				return this;
			},
			locked: function() {
				return !!locked;
			},

			// Call all callbacks with the given context and arguments
			fireWith: function( context, args ) {
				if ( !locked ) {
					args = args || [];
					args = [ context, args.slice ? args.slice() : args ];
					queue.push( args );
					if ( !firing ) {
						fire();
					}
				}
				return this;
			},

			// Call all the callbacks with the given arguments
			fire: function() {
				self.fireWith( this, arguments );
				return this;
			},

			// To know if the callbacks have already been called at least once
			fired: function() {
				return !!fired;
			}
		};

	return self;
};


function Identity( v ) {
	return v;
}
function Thrower( ex ) {
	throw ex;
}

function adoptValue( value, resolve, reject, noValue ) {
	var method;

	try {

		// Check for promise aspect first to privilege synchronous behavior
		if ( value && isFunction( ( method = value.promise ) ) ) {
			method.call( value ).done( resolve ).fail( reject );

		// Other thenables
		} else if ( value && isFunction( ( method = value.then ) ) ) {
			method.call( value, resolve, reject );

		// Other non-thenables
		} else {

			// Control `resolve` arguments by letting Array#slice cast boolean `noValue` to integer:
			// * false: [ value ].slice( 0 ) => resolve( value )
			// * true: [ value ].slice( 1 ) => resolve()
			resolve.apply( undefined, [ value ].slice( noValue ) );
		}

	// For Promises/A+, convert exceptions into rejections
	// Since jQuery.when doesn't unwrap thenables, we can skip the extra checks appearing in
	// Deferred#then to conditionally suppress rejection.
	} catch ( value ) {

		// Support: Android 4.0 only
		// Strict mode functions invoked without .call/.apply get global-object context
		reject.apply( undefined, [ value ] );
	}
}

jQuery.extend( {

	Deferred: function( func ) {
		var tuples = [

				// action, add listener, callbacks,
				// ... .then handlers, argument index, [final state]
				[ "notify", "progress", jQuery.Callbacks( "memory" ),
					jQuery.Callbacks( "memory" ), 2 ],
				[ "resolve", "done", jQuery.Callbacks( "once memory" ),
					jQuery.Callbacks( "once memory" ), 0, "resolved" ],
				[ "reject", "fail", jQuery.Callbacks( "once memory" ),
					jQuery.Callbacks( "once memory" ), 1, "rejected" ]
			],
			state = "pending",
			promise = {
				state: function() {
					return state;
				},
				always: function() {
					deferred.done( arguments ).fail( arguments );
					return this;
				},
				"catch": function( fn ) {
					return promise.then( null, fn );
				},

				// Keep pipe for back-compat
				pipe: function( /* fnDone, fnFail, fnProgress */ ) {
					var fns = arguments;

					return jQuery.Deferred( function( newDefer ) {
						jQuery.each( tuples, function( i, tuple ) {

							// Map tuples (progress, done, fail) to arguments (done, fail, progress)
							var fn = isFunction( fns[ tuple[ 4 ] ] ) && fns[ tuple[ 4 ] ];

							// deferred.progress(function() { bind to newDefer or newDefer.notify })
							// deferred.done(function() { bind to newDefer or newDefer.resolve })
							// deferred.fail(function() { bind to newDefer or newDefer.reject })
							deferred[ tuple[ 1 ] ]( function() {
								var returned = fn && fn.apply( this, arguments );
								if ( returned && isFunction( returned.promise ) ) {
									returned.promise()
										.progress( newDefer.notify )
										.done( newDefer.resolve )
										.fail( newDefer.reject );
								} else {
									newDefer[ tuple[ 0 ] + "With" ](
										this,
										fn ? [ returned ] : arguments
									);
								}
							} );
						} );
						fns = null;
					} ).promise();
				},
				then: function( onFulfilled, onRejected, onProgress ) {
					var maxDepth = 0;
					function resolve( depth, deferred, handler, special ) {
						return function() {
							var that = this,
								args = arguments,
								mightThrow = function() {
									var returned, then;

									// Support: Promises/A+ section 2.3.3.3.3
									// https://promisesaplus.com/#point-59
									// Ignore double-resolution attempts
									if ( depth < maxDepth ) {
										return;
									}

									returned = handler.apply( that, args );

									// Support: Promises/A+ section 2.3.1
									// https://promisesaplus.com/#point-48
									if ( returned === deferred.promise() ) {
										throw new TypeError( "Thenable self-resolution" );
									}

									// Support: Promises/A+ sections 2.3.3.1, 3.5
									// https://promisesaplus.com/#point-54
									// https://promisesaplus.com/#point-75
									// Retrieve `then` only once
									then = returned &&

										// Support: Promises/A+ section 2.3.4
										// https://promisesaplus.com/#point-64
										// Only check objects and functions for thenability
										( typeof returned === "object" ||
											typeof returned === "function" ) &&
										returned.then;

									// Handle a returned thenable
									if ( isFunction( then ) ) {

										// Special processors (notify) just wait for resolution
										if ( special ) {
											then.call(
												returned,
												resolve( maxDepth, deferred, Identity, special ),
												resolve( maxDepth, deferred, Thrower, special )
											);

										// Normal processors (resolve) also hook into progress
										} else {

											// ...and disregard older resolution values
											maxDepth++;

											then.call(
												returned,
												resolve( maxDepth, deferred, Identity, special ),
												resolve( maxDepth, deferred, Thrower, special ),
												resolve( maxDepth, deferred, Identity,
													deferred.notifyWith )
											);
										}

									// Handle all other returned values
									} else {

										// Only substitute handlers pass on context
										// and multiple values (non-spec behavior)
										if ( handler !== Identity ) {
											that = undefined;
											args = [ returned ];
										}

										// Process the value(s)
										// Default process is resolve
										( special || deferred.resolveWith )( that, args );
									}
								},

								// Only normal processors (resolve) catch and reject exceptions
								process = special ?
									mightThrow :
									function() {
										try {
											mightThrow();
										} catch ( e ) {

											if ( jQuery.Deferred.exceptionHook ) {
												jQuery.Deferred.exceptionHook( e,
													process.stackTrace );
											}

											// Support: Promises/A+ section 2.3.3.3.4.1
											// https://promisesaplus.com/#point-61
											// Ignore post-resolution exceptions
											if ( depth + 1 >= maxDepth ) {

												// Only substitute handlers pass on context
												// and multiple values (non-spec behavior)
												if ( handler !== Thrower ) {
													that = undefined;
													args = [ e ];
												}

												deferred.rejectWith( that, args );
											}
										}
									};

							// Support: Promises/A+ section 2.3.3.3.1
							// https://promisesaplus.com/#point-57
							// Re-resolve promises immediately to dodge false rejection from
							// subsequent errors
							if ( depth ) {
								process();
							} else {

								// Call an optional hook to record the stack, in case of exception
								// since it's otherwise lost when execution goes async
								if ( jQuery.Deferred.getStackHook ) {
									process.stackTrace = jQuery.Deferred.getStackHook();
								}
								window.setTimeout( process );
							}
						};
					}

					return jQuery.Deferred( function( newDefer ) {

						// progress_handlers.add( ... )
						tuples[ 0 ][ 3 ].add(
							resolve(
								0,
								newDefer,
								isFunction( onProgress ) ?
									onProgress :
									Identity,
								newDefer.notifyWith
							)
						);

						// fulfilled_handlers.add( ... )
						tuples[ 1 ][ 3 ].add(
							resolve(
								0,
								newDefer,
								isFunction( onFulfilled ) ?
									onFulfilled :
									Identity
							)
						);

						// rejected_handlers.add( ... )
						tuples[ 2 ][ 3 ].add(
							resolve(
								0,
								newDefer,
								isFunction( onRejected ) ?
									onRejected :
									Thrower
							)
						);
					} ).promise();
				},

				// Get a promise for this deferred
				// If obj is provided, the promise aspect is added to the object
				promise: function( obj ) {
					return obj != null ? jQuery.extend( obj, promise ) : promise;
				}
			},
			deferred = {};

		// Add list-specific methods
		jQuery.each( tuples, function( i, tuple ) {
			var list = tuple[ 2 ],
				stateString = tuple[ 5 ];

			// promise.progress = list.add
			// promise.done = list.add
			// promise.fail = list.add
			promise[ tuple[ 1 ] ] = list.add;

			// Handle state
			if ( stateString ) {
				list.add(
					function() {

						// state = "resolved" (i.e., fulfilled)
						// state = "rejected"
						state = stateString;
					},

					// rejected_callbacks.disable
					// fulfilled_callbacks.disable
					tuples[ 3 - i ][ 2 ].disable,

					// rejected_handlers.disable
					// fulfilled_handlers.disable
					tuples[ 3 - i ][ 3 ].disable,

					// progress_callbacks.lock
					tuples[ 0 ][ 2 ].lock,

					// progress_handlers.lock
					tuples[ 0 ][ 3 ].lock
				);
			}

			// progress_handlers.fire
			// fulfilled_handlers.fire
			// rejected_handlers.fire
			list.add( tuple[ 3 ].fire );

			// deferred.notify = function() { deferred.notifyWith(...) }
			// deferred.resolve = function() { deferred.resolveWith(...) }
			// deferred.reject = function() { deferred.rejectWith(...) }
			deferred[ tuple[ 0 ] ] = function() {
				deferred[ tuple[ 0 ] + "With" ]( this === deferred ? undefined : this, arguments );
				return this;
			};

			// deferred.notifyWith = list.fireWith
			// deferred.resolveWith = list.fireWith
			// deferred.rejectWith = list.fireWith
			deferred[ tuple[ 0 ] + "With" ] = list.fireWith;
		} );

		// Make the deferred a promise
		promise.promise( deferred );

		// Call given func if any
		if ( func ) {
			func.call( deferred, deferred );
		}

		// All done!
		return deferred;
	},

	// Deferred helper
	when: function( singleValue ) {
		var

			// count of uncompleted subordinates
			remaining = arguments.length,

			// count of unprocessed arguments
			i = remaining,

			// subordinate fulfillment data
			resolveContexts = Array( i ),
			resolveValues = slice.call( arguments ),

			// the master Deferred
			master = jQuery.Deferred(),

			// subordinate callback factory
			updateFunc = function( i ) {
				return function( value ) {
					resolveContexts[ i ] = this;
					resolveValues[ i ] = arguments.length > 1 ? slice.call( arguments ) : value;
					if ( !( --remaining ) ) {
						master.resolveWith( resolveContexts, resolveValues );
					}
				};
			};

		// Single- and empty arguments are adopted like Promise.resolve
		if ( remaining <= 1 ) {
			adoptValue( singleValue, master.done( updateFunc( i ) ).resolve, master.reject,
				!remaining );

			// Use .then() to unwrap secondary thenables (cf. gh-3000)
			if ( master.state() === "pending" ||
				isFunction( resolveValues[ i ] && resolveValues[ i ].then ) ) {

				return master.then();
			}
		}

		// Multiple arguments are aggregated like Promise.all array elements
		while ( i-- ) {
			adoptValue( resolveValues[ i ], updateFunc( i ), master.reject );
		}

		return master.promise();
	}
} );


// These usually indicate a programmer mistake during development,
// warn about them ASAP rather than swallowing them by default.
var rerrorNames = /^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;

jQuery.Deferred.exceptionHook = function( error, stack ) {

	// Support: IE 8 - 9 only
	// Console exists when dev tools are open, which can happen at any time
	if ( window.console && window.console.warn && error && rerrorNames.test( error.name ) ) {
		window.console.warn( "jQuery.Deferred exception: " + error.message, error.stack, stack );
	}
};




jQuery.readyException = function( error ) {
	window.setTimeout( function() {
		throw error;
	} );
};




// The deferred used on DOM ready
var readyList = jQuery.Deferred();

jQuery.fn.ready = function( fn ) {

	readyList
		.then( fn )

		// Wrap jQuery.readyException in a function so that the lookup
		// happens at the time of error handling instead of callback
		// registration.
		.catch( function( error ) {
			jQuery.readyException( error );
		} );

	return this;
};

jQuery.extend( {

	// Is the DOM ready to be used? Set to true once it occurs.
	isReady: false,

	// A counter to track how many items to wait for before
	// the ready event fires. See #6781
	readyWait: 1,

	// Handle when the DOM is ready
	ready: function( wait ) {

		// Abort if there are pending holds or we're already ready
		if ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {
			return;
		}

		// Remember that the DOM is ready
		jQuery.isReady = true;

		// If a normal DOM Ready event fired, decrement, and wait if need be
		if ( wait !== true && --jQuery.readyWait > 0 ) {
			return;
		}

		// If there are functions bound, to execute
		readyList.resolveWith( document, [ jQuery ] );
	}
} );

jQuery.ready.then = readyList.then;

// The ready event handler and self cleanup method
function completed() {
	document.removeEventListener( "DOMContentLoaded", completed );
	window.removeEventListener( "load", completed );
	jQuery.ready();
}

// Catch cases where $(document).ready() is called
// after the browser event has already occurred.
// Support: IE <=9 - 10 only
// Older IE sometimes signals "interactive" too soon
if ( document.readyState === "complete" ||
	( document.readyState !== "loading" && !document.documentElement.doScroll ) ) {

	// Handle it asynchronously to allow scripts the opportunity to delay ready
	window.setTimeout( jQuery.ready );

} else {

	// Use the handy event callback
	document.addEventListener( "DOMContentLoaded", completed );

	// A fallback to window.onload, that will always work
	window.addEventListener( "load", completed );
}




// Multifunctional method to get and set values of a collection
// The value/s can optionally be executed if it's a function
var access = function( elems, fn, key, value, chainable, emptyGet, raw ) {
	var i = 0,
		len = elems.length,
		bulk = key == null;

	// Sets many values
	if ( toType( key ) === "object" ) {
		chainable = true;
		for ( i in key ) {
			access( elems, fn, i, key[ i ], true, emptyGet, raw );
		}

	// Sets one value
	} else if ( value !== undefined ) {
		chainable = true;

		if ( !isFunction( value ) ) {
			raw = true;
		}

		if ( bulk ) {

			// Bulk operations run against the entire set
			if ( raw ) {
				fn.call( elems, value );
				fn = null;

			// ...except when executing function values
			} else {
				bulk = fn;
				fn = function( elem, key, value ) {
					return bulk.call( jQuery( elem ), value );
				};
			}
		}

		if ( fn ) {
			for ( ; i < len; i++ ) {
				fn(
					elems[ i ], key, raw ?
					value :
					value.call( elems[ i ], i, fn( elems[ i ], key ) )
				);
			}
		}
	}

	if ( chainable ) {
		return elems;
	}

	// Gets
	if ( bulk ) {
		return fn.call( elems );
	}

	return len ? fn( elems[ 0 ], key ) : emptyGet;
};


// Matches dashed string for camelizing
var rmsPrefix = /^-ms-/,
	rdashAlpha = /-([a-z])/g;

// Used by camelCase as callback to replace()
function fcamelCase( all, letter ) {
	return letter.toUpperCase();
}

// Convert dashed to camelCase; used by the css and data modules
// Support: IE <=9 - 11, Edge 12 - 15
// Microsoft forgot to hump their vendor prefix (#9572)
function camelCase( string ) {
	return string.replace( rmsPrefix, "ms-" ).replace( rdashAlpha, fcamelCase );
}
var acceptData = function( owner ) {

	// Accepts only:
	//  - Node
	//    - Node.ELEMENT_NODE
	//    - Node.DOCUMENT_NODE
	//  - Object
	//    - Any
	return owner.nodeType === 1 || owner.nodeType === 9 || !( +owner.nodeType );
};




function Data() {
	this.expando = jQuery.expando + Data.uid++;
}

Data.uid = 1;

Data.prototype = {

	cache: function( owner ) {

		// Check if the owner object already has a cache
		var value = owner[ this.expando ];

		// If not, create one
		if ( !value ) {
			value = {};

			// We can accept data for non-element nodes in modern browsers,
			// but we should not, see #8335.
			// Always return an empty object.
			if ( acceptData( owner ) ) {

				// If it is a node unlikely to be stringify-ed or looped over
				// use plain assignment
				if ( owner.nodeType ) {
					owner[ this.expando ] = value;

				// Otherwise secure it in a non-enumerable property
				// configurable must be true to allow the property to be
				// deleted when data is removed
				} else {
					Object.defineProperty( owner, this.expando, {
						value: value,
						configurable: true
					} );
				}
			}
		}

		return value;
	},
	set: function( owner, data, value ) {
		var prop,
			cache = this.cache( owner );

		// Handle: [ owner, key, value ] args
		// Always use camelCase key (gh-2257)
		if ( typeof data === "string" ) {
			cache[ camelCase( data ) ] = value;

		// Handle: [ owner, { properties } ] args
		} else {

			// Copy the properties one-by-one to the cache object
			for ( prop in data ) {
				cache[ camelCase( prop ) ] = data[ prop ];
			}
		}
		return cache;
	},
	get: function( owner, key ) {
		return key === undefined ?
			this.cache( owner ) :

			// Always use camelCase key (gh-2257)
			owner[ this.expando ] && owner[ this.expando ][ camelCase( key ) ];
	},
	access: function( owner, key, value ) {

		// In cases where either:
		//
		//   1. No key was specified
		//   2. A string key was specified, but no value provided
		//
		// Take the "read" path and allow the get method to determine
		// which value to return, respectively either:
		//
		//   1. The entire cache object
		//   2. The data stored at the key
		//
		if ( key === undefined ||
				( ( key && typeof key === "string" ) && value === undefined ) ) {

			return this.get( owner, key );
		}

		// When the key is not a string, or both a key and value
		// are specified, set or extend (existing objects) with either:
		//
		//   1. An object of properties
		//   2. A key and value
		//
		this.set( owner, key, value );

		// Since the "set" path can have two possible entry points
		// return the expected data based on which path was taken[*]
		return value !== undefined ? value : key;
	},
	remove: function( owner, key ) {
		var i,
			cache = owner[ this.expando ];

		if ( cache === undefined ) {
			return;
		}

		if ( key !== undefined ) {

			// Support array or space separated string of keys
			if ( Array.isArray( key ) ) {

				// If key is an array of keys...
				// We always set camelCase keys, so remove that.
				key = key.map( camelCase );
			} else {
				key = camelCase( key );

				// If a key with the spaces exists, use it.
				// Otherwise, create an array by matching non-whitespace
				key = key in cache ?
					[ key ] :
					( key.match( rnothtmlwhite ) || [] );
			}

			i = key.length;

			while ( i-- ) {
				delete cache[ key[ i ] ];
			}
		}

		// Remove the expando if there's no more data
		if ( key === undefined || jQuery.isEmptyObject( cache ) ) {

			// Support: Chrome <=35 - 45
			// Webkit & Blink performance suffers when deleting properties
			// from DOM nodes, so set to undefined instead
			// https://bugs.chromium.org/p/chromium/issues/detail?id=378607 (bug restricted)
			if ( owner.nodeType ) {
				owner[ this.expando ] = undefined;
			} else {
				delete owner[ this.expando ];
			}
		}
	},
	hasData: function( owner ) {
		var cache = owner[ this.expando ];
		return cache !== undefined && !jQuery.isEmptyObject( cache );
	}
};
var dataPriv = new Data();

var dataUser = new Data();



//	Implementation Summary
//
//	1. Enforce API surface and semantic compatibility with 1.9.x branch
//	2. Improve the module's maintainability by reducing the storage
//		paths to a single mechanism.
//	3. Use the same single mechanism to support "private" and "user" data.
//	4. _Never_ expose "private" data to user code (TODO: Drop _data, _removeData)
//	5. Avoid exposing implementation details on user objects (eg. expando properties)
//	6. Provide a clear path for implementation upgrade to WeakMap in 2014

var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,
	rmultiDash = /[A-Z]/g;

function getData( data ) {
	if ( data === "true" ) {
		return true;
	}

	if ( data === "false" ) {
		return false;
	}

	if ( data === "null" ) {
		return null;
	}

	// Only convert to a number if it doesn't change the string
	if ( data === +data + "" ) {
		return +data;
	}

	if ( rbrace.test( data ) ) {
		return JSON.parse( data );
	}

	return data;
}

function dataAttr( elem, key, data ) {
	var name;

	// If nothing was found internally, try to fetch any
	// data from the HTML5 data-* attribute
	if ( data === undefined && elem.nodeType === 1 ) {
		name = "data-" + key.replace( rmultiDash, "-$&" ).toLowerCase();
		data = elem.getAttribute( name );

		if ( typeof data === "string" ) {
			try {
				data = getData( data );
			} catch ( e ) {}

			// Make sure we set the data so it isn't changed later
			dataUser.set( elem, key, data );
		} else {
			data = undefined;
		}
	}
	return data;
}

jQuery.extend( {
	hasData: function( elem ) {
		return dataUser.hasData( elem ) || dataPriv.hasData( elem );
	},

	data: function( elem, name, data ) {
		return dataUser.access( elem, name, data );
	},

	removeData: function( elem, name ) {
		dataUser.remove( elem, name );
	},

	// TODO: Now that all calls to _data and _removeData have been replaced
	// with direct calls to dataPriv methods, these can be deprecated.
	_data: function( elem, name, data ) {
		return dataPriv.access( elem, name, data );
	},

	_removeData: function( elem, name ) {
		dataPriv.remove( elem, name );
	}
} );

jQuery.fn.extend( {
	data: function( key, value ) {
		var i, name, data,
			elem = this[ 0 ],
			attrs = elem && elem.attributes;

		// Gets all values
		if ( key === undefined ) {
			if ( this.length ) {
				data = dataUser.get( elem );

				if ( elem.nodeType === 1 && !dataPriv.get( elem, "hasDataAttrs" ) ) {
					i = attrs.length;
					while ( i-- ) {

						// Support: IE 11 only
						// The attrs elements can be null (#14894)
						if ( attrs[ i ] ) {
							name = attrs[ i ].name;
							if ( name.indexOf( "data-" ) === 0 ) {
								name = camelCase( name.slice( 5 ) );
								dataAttr( elem, name, data[ name ] );
							}
						}
					}
					dataPriv.set( elem, "hasDataAttrs", true );
				}
			}

			return data;
		}

		// Sets multiple values
		if ( typeof key === "object" ) {
			return this.each( function() {
				dataUser.set( this, key );
			} );
		}

		return access( this, function( value ) {
			var data;

			// The calling jQuery object (element matches) is not empty
			// (and therefore has an element appears at this[ 0 ]) and the
			// `value` parameter was not undefined. An empty jQuery object
			// will result in `undefined` for elem = this[ 0 ] which will
			// throw an exception if an attempt to read a data cache is made.
			if ( elem && value === undefined ) {

				// Attempt to get data from the cache
				// The key will always be camelCased in Data
				data = dataUser.get( elem, key );
				if ( data !== undefined ) {
					return data;
				}

				// Attempt to "discover" the data in
				// HTML5 custom data-* attrs
				data = dataAttr( elem, key );
				if ( data !== undefined ) {
					return data;
				}

				// We tried really hard, but the data doesn't exist.
				return;
			}

			// Set the data...
			this.each( function() {

				// We always store the camelCased key
				dataUser.set( this, key, value );
			} );
		}, null, value, arguments.length > 1, null, true );
	},

	removeData: function( key ) {
		return this.each( function() {
			dataUser.remove( this, key );
		} );
	}
} );


jQuery.extend( {
	queue: function( elem, type, data ) {
		var queue;

		if ( elem ) {
			type = ( type || "fx" ) + "queue";
			queue = dataPriv.get( elem, type );

			// Speed up dequeue by getting out quickly if this is just a lookup
			if ( data ) {
				if ( !queue || Array.isArray( data ) ) {
					queue = dataPriv.access( elem, type, jQuery.makeArray( data ) );
				} else {
					queue.push( data );
				}
			}
			return queue || [];
		}
	},

	dequeue: function( elem, type ) {
		type = type || "fx";

		var queue = jQuery.queue( elem, type ),
			startLength = queue.length,
			fn = queue.shift(),
			hooks = jQuery._queueHooks( elem, type ),
			next = function() {
				jQuery.dequeue( elem, type );
			};

		// If the fx queue is dequeued, always remove the progress sentinel
		if ( fn === "inprogress" ) {
			fn = queue.shift();
			startLength--;
		}

		if ( fn ) {

			// Add a progress sentinel to prevent the fx queue from being
			// automatically dequeued
			if ( type === "fx" ) {
				queue.unshift( "inprogress" );
			}

			// Clear up the last queue stop function
			delete hooks.stop;
			fn.call( elem, next, hooks );
		}

		if ( !startLength && hooks ) {
			hooks.empty.fire();
		}
	},

	// Not public - generate a queueHooks object, or return the current one
	_queueHooks: function( elem, type ) {
		var key = type + "queueHooks";
		return dataPriv.get( elem, key ) || dataPriv.access( elem, key, {
			empty: jQuery.Callbacks( "once memory" ).add( function() {
				dataPriv.remove( elem, [ type + "queue", key ] );
			} )
		} );
	}
} );

jQuery.fn.extend( {
	queue: function( type, data ) {
		var setter = 2;

		if ( typeof type !== "string" ) {
			data = type;
			type = "fx";
			setter--;
		}

		if ( arguments.length < setter ) {
			return jQuery.queue( this[ 0 ], type );
		}

		return data === undefined ?
			this :
			this.each( function() {
				var queue = jQuery.queue( this, type, data );

				// Ensure a hooks for this queue
				jQuery._queueHooks( this, type );

				if ( type === "fx" && queue[ 0 ] !== "inprogress" ) {
					jQuery.dequeue( this, type );
				}
			} );
	},
	dequeue: function( type ) {
		return this.each( function() {
			jQuery.dequeue( this, type );
		} );
	},
	clearQueue: function( type ) {
		return this.queue( type || "fx", [] );
	},

	// Get a promise resolved when queues of a certain type
	// are emptied (fx is the type by default)
	promise: function( type, obj ) {
		var tmp,
			count = 1,
			defer = jQuery.Deferred(),
			elements = this,
			i = this.length,
			resolve = function() {
				if ( !( --count ) ) {
					defer.resolveWith( elements, [ elements ] );
				}
			};

		if ( typeof type !== "string" ) {
			obj = type;
			type = undefined;
		}
		type = type || "fx";

		while ( i-- ) {
			tmp = dataPriv.get( elements[ i ], type + "queueHooks" );
			if ( tmp && tmp.empty ) {
				count++;
				tmp.empty.add( resolve );
			}
		}
		resolve();
		return defer.promise( obj );
	}
} );
var pnum = ( /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/ ).source;

var rcssNum = new RegExp( "^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i" );


var cssExpand = [ "Top", "Right", "Bottom", "Left" ];

var isHiddenWithinTree = function( elem, el ) {

		// isHiddenWithinTree might be called from jQuery#filter function;
		// in that case, element will be second argument
		elem = el || elem;

		// Inline style trumps all
		return elem.style.display === "none" ||
			elem.style.display === "" &&

			// Otherwise, check computed style
			// Support: Firefox <=43 - 45
			// Disconnected elements can have computed display: none, so first confirm that elem is
			// in the document.
			jQuery.contains( elem.ownerDocument, elem ) &&

			jQuery.css( elem, "display" ) === "none";
	};

var swap = function( elem, options, callback, args ) {
	var ret, name,
		old = {};

	// Remember the old values, and insert the new ones
	for ( name in options ) {
		old[ name ] = elem.style[ name ];
		elem.style[ name ] = options[ name ];
	}

	ret = callback.apply( elem, args || [] );

	// Revert the old values
	for ( name in options ) {
		elem.style[ name ] = old[ name ];
	}

	return ret;
};




function adjustCSS( elem, prop, valueParts, tween ) {
	var adjusted, scale,
		maxIterations = 20,
		currentValue = tween ?
			function() {
				return tween.cur();
			} :
			function() {
				return jQuery.css( elem, prop, "" );
			},
		initial = currentValue(),
		unit = valueParts && valueParts[ 3 ] || ( jQuery.cssNumber[ prop ] ? "" : "px" ),

		// Starting value computation is required for potential unit mismatches
		initialInUnit = ( jQuery.cssNumber[ prop ] || unit !== "px" && +initial ) &&
			rcssNum.exec( jQuery.css( elem, prop ) );

	if ( initialInUnit && initialInUnit[ 3 ] !== unit ) {

		// Support: Firefox <=54
		// Halve the iteration target value to prevent interference from CSS upper bounds (gh-2144)
		initial = initial / 2;

		// Trust units reported by jQuery.css
		unit = unit || initialInUnit[ 3 ];

		// Iteratively approximate from a nonzero starting point
		initialInUnit = +initial || 1;

		while ( maxIterations-- ) {

			// Evaluate and update our best guess (doubling guesses that zero out).
			// Finish if the scale equals or crosses 1 (making the old*new product non-positive).
			jQuery.style( elem, prop, initialInUnit + unit );
			if ( ( 1 - scale ) * ( 1 - ( scale = currentValue() / initial || 0.5 ) ) <= 0 ) {
				maxIterations = 0;
			}
			initialInUnit = initialInUnit / scale;

		}

		initialInUnit = initialInUnit * 2;
		jQuery.style( elem, prop, initialInUnit + unit );

		// Make sure we update the tween properties later on
		valueParts = valueParts || [];
	}

	if ( valueParts ) {
		initialInUnit = +initialInUnit || +initial || 0;

		// Apply relative offset (+=/-=) if specified
		adjusted = valueParts[ 1 ] ?
			initialInUnit + ( valueParts[ 1 ] + 1 ) * valueParts[ 2 ] :
			+valueParts[ 2 ];
		if ( tween ) {
			tween.unit = unit;
			tween.start = initialInUnit;
			tween.end = adjusted;
		}
	}
	return adjusted;
}


var defaultDisplayMap = {};

function getDefaultDisplay( elem ) {
	var temp,
		doc = elem.ownerDocument,
		nodeName = elem.nodeName,
		display = defaultDisplayMap[ nodeName ];

	if ( display ) {
		return display;
	}

	temp = doc.body.appendChild( doc.createElement( nodeName ) );
	display = jQuery.css( temp, "display" );

	temp.parentNode.removeChild( temp );

	if ( display === "none" ) {
		display = "block";
	}
	defaultDisplayMap[ nodeName ] = display;

	return display;
}

function showHide( elements, show ) {
	var display, elem,
		values = [],
		index = 0,
		length = elements.length;

	// Determine new display value for elements that need to change
	for ( ; index < length; index++ ) {
		elem = elements[ index ];
		if ( !elem.style ) {
			continue;
		}

		display = elem.style.display;
		if ( show ) {

			// Since we force visibility upon cascade-hidden elements, an immediate (and slow)
			// check is required in this first loop unless we have a nonempty display value (either
			// inline or about-to-be-restored)
			if ( display === "none" ) {
				values[ index ] = dataPriv.get( elem, "display" ) || null;
				if ( !values[ index ] ) {
					elem.style.display = "";
				}
			}
			if ( elem.style.display === "" && isHiddenWithinTree( elem ) ) {
				values[ index ] = getDefaultDisplay( elem );
			}
		} else {
			if ( display !== "none" ) {
				values[ index ] = "none";

				// Remember what we're overwriting
				dataPriv.set( elem, "display", display );
			}
		}
	}

	// Set the display of the elements in a second loop to avoid constant reflow
	for ( index = 0; index < length; index++ ) {
		if ( values[ index ] != null ) {
			elements[ index ].style.display = values[ index ];
		}
	}

	return elements;
}

jQuery.fn.extend( {
	show: function() {
		return showHide( this, true );
	},
	hide: function() {
		return showHide( this );
	},
	toggle: function( state ) {
		if ( typeof state === "boolean" ) {
			return state ? this.show() : this.hide();
		}

		return this.each( function() {
			if ( isHiddenWithinTree( this ) ) {
				jQuery( this ).show();
			} else {
				jQuery( this ).hide();
			}
		} );
	}
} );
var rcheckableType = ( /^(?:checkbox|radio)$/i );

var rtagName = ( /<([a-z][^\/\0>\x20\t\r\n\f]+)/i );

var rscriptType = ( /^$|^module$|\/(?:java|ecma)script/i );



// We have to close these tags to support XHTML (#13200)
var wrapMap = {

	// Support: IE <=9 only
	option: [ 1, "<select multiple='multiple'>", "</select>" ],

	// XHTML parsers do not magically insert elements in the
	// same way that tag soup parsers do. So we cannot shorten
	// this by omitting <tbody> or other required elements.
	thead: [ 1, "<table>", "</table>" ],
	col: [ 2, "<table><colgroup>", "</colgroup></table>" ],
	tr: [ 2, "<table><tbody>", "</tbody></table>" ],
	td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],

	_default: [ 0, "", "" ]
};

// Support: IE <=9 only
wrapMap.optgroup = wrapMap.option;

wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
wrapMap.th = wrapMap.td;


function getAll( context, tag ) {

	// Support: IE <=9 - 11 only
	// Use typeof to avoid zero-argument method invocation on host objects (#15151)
	var ret;

	if ( typeof context.getElementsByTagName !== "undefined" ) {
		ret = context.getElementsByTagName( tag || "*" );

	} else if ( typeof context.querySelectorAll !== "undefined" ) {
		ret = context.querySelectorAll( tag || "*" );

	} else {
		ret = [];
	}

	if ( tag === undefined || tag && nodeName( context, tag ) ) {
		return jQuery.merge( [ context ], ret );
	}

	return ret;
}


// Mark scripts as having already been evaluated
function setGlobalEval( elems, refElements ) {
	var i = 0,
		l = elems.length;

	for ( ; i < l; i++ ) {
		dataPriv.set(
			elems[ i ],
			"globalEval",
			!refElements || dataPriv.get( refElements[ i ], "globalEval" )
		);
	}
}


var rhtml = /<|&#?\w+;/;

function buildFragment( elems, context, scripts, selection, ignored ) {
	var elem, tmp, tag, wrap, contains, j,
		fragment = context.createDocumentFragment(),
		nodes = [],
		i = 0,
		l = elems.length;

	for ( ; i < l; i++ ) {
		elem = elems[ i ];

		if ( elem || elem === 0 ) {

			// Add nodes directly
			if ( toType( elem ) === "object" ) {

				// Support: Android <=4.0 only, PhantomJS 1 only
				// push.apply(_, arraylike) throws on ancient WebKit
				jQuery.merge( nodes, elem.nodeType ? [ elem ] : elem );

			// Convert non-html into a text node
			} else if ( !rhtml.test( elem ) ) {
				nodes.push( context.createTextNode( elem ) );

			// Convert html into DOM nodes
			} else {
				tmp = tmp || fragment.appendChild( context.createElement( "div" ) );

				// Deserialize a standard representation
				tag = ( rtagName.exec( elem ) || [ "", "" ] )[ 1 ].toLowerCase();
				wrap = wrapMap[ tag ] || wrapMap._default;
				tmp.innerHTML = wrap[ 1 ] + jQuery.htmlPrefilter( elem ) + wrap[ 2 ];

				// Descend through wrappers to the right content
				j = wrap[ 0 ];
				while ( j-- ) {
					tmp = tmp.lastChild;
				}

				// Support: Android <=4.0 only, PhantomJS 1 only
				// push.apply(_, arraylike) throws on ancient WebKit
				jQuery.merge( nodes, tmp.childNodes );

				// Remember the top-level container
				tmp = fragment.firstChild;

				// Ensure the created nodes are orphaned (#12392)
				tmp.textContent = "";
			}
		}
	}

	// Remove wrapper from fragment
	fragment.textContent = "";

	i = 0;
	while ( ( elem = nodes[ i++ ] ) ) {

		// Skip elements already in the context collection (trac-4087)
		if ( selection && jQuery.inArray( elem, selection ) > -1 ) {
			if ( ignored ) {
				ignored.push( elem );
			}
			continue;
		}

		contains = jQuery.contains( elem.ownerDocument, elem );

		// Append to fragment
		tmp = getAll( fragment.appendChild( elem ), "script" );

		// Preserve script evaluation history
		if ( contains ) {
			setGlobalEval( tmp );
		}

		// Capture executables
		if ( scripts ) {
			j = 0;
			while ( ( elem = tmp[ j++ ] ) ) {
				if ( rscriptType.test( elem.type || "" ) ) {
					scripts.push( elem );
				}
			}
		}
	}

	return fragment;
}


( function() {
	var fragment = document.createDocumentFragment(),
		div = fragment.appendChild( document.createElement( "div" ) ),
		input = document.createElement( "input" );

	// Support: Android 4.0 - 4.3 only
	// Check state lost if the name is set (#11217)
	// Support: Windows Web Apps (WWA)
	// `name` and `type` must use .setAttribute for WWA (#14901)
	input.setAttribute( "type", "radio" );
	input.setAttribute( "checked", "checked" );
	input.setAttribute( "name", "t" );

	div.appendChild( input );

	// Support: Android <=4.1 only
	// Older WebKit doesn't clone checked state correctly in fragments
	support.checkClone = div.cloneNode( true ).cloneNode( true ).lastChild.checked;

	// Support: IE <=11 only
	// Make sure textarea (and checkbox) defaultValue is properly cloned
	div.innerHTML = "<textarea>x</textarea>";
	support.noCloneChecked = !!div.cloneNode( true ).lastChild.defaultValue;
} )();
var documentElement = document.documentElement;



var
	rkeyEvent = /^key/,
	rmouseEvent = /^(?:mouse|pointer|contextmenu|drag|drop)|click/,
	rtypenamespace = /^([^.]*)(?:\.(.+)|)/;

function returnTrue() {
	return true;
}

function returnFalse() {
	return false;
}

// Support: IE <=9 only
// See #13393 for more info
function safeActiveElement() {
	try {
		return document.activeElement;
	} catch ( err ) { }
}

function on( elem, types, selector, data, fn, one ) {
	var origFn, type;

	// Types can be a map of types/handlers
	if ( typeof types === "object" ) {

		// ( types-Object, selector, data )
		if ( typeof selector !== "string" ) {

			// ( types-Object, data )
			data = data || selector;
			selector = undefined;
		}
		for ( type in types ) {
			on( elem, type, selector, data, types[ type ], one );
		}
		return elem;
	}

	if ( data == null && fn == null ) {

		// ( types, fn )
		fn = selector;
		data = selector = undefined;
	} else if ( fn == null ) {
		if ( typeof selector === "string" ) {

			// ( types, selector, fn )
			fn = data;
			data = undefined;
		} else {

			// ( types, data, fn )
			fn = data;
			data = selector;
			selector = undefined;
		}
	}
	if ( fn === false ) {
		fn = returnFalse;
	} else if ( !fn ) {
		return elem;
	}

	if ( one === 1 ) {
		origFn = fn;
		fn = function( event ) {

			// Can use an empty set, since event contains the info
			jQuery().off( event );
			return origFn.apply( this, arguments );
		};

		// Use same guid so caller can remove using origFn
		fn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );
	}
	return elem.each( function() {
		jQuery.event.add( this, types, fn, data, selector );
	} );
}

/*
 * Helper functions for managing events -- not part of the public interface.
 * Props to Dean Edwards' addEvent library for many of the ideas.
 */
jQuery.event = {

	global: {},

	add: function( elem, types, handler, data, selector ) {

		var handleObjIn, eventHandle, tmp,
			events, t, handleObj,
			special, handlers, type, namespaces, origType,
			elemData = dataPriv.get( elem );

		// Don't attach events to noData or text/comment nodes (but allow plain objects)
		if ( !elemData ) {
			return;
		}

		// Caller can pass in an object of custom data in lieu of the handler
		if ( handler.handler ) {
			handleObjIn = handler;
			handler = handleObjIn.handler;
			selector = handleObjIn.selector;
		}

		// Ensure that invalid selectors throw exceptions at attach time
		// Evaluate against documentElement in case elem is a non-element node (e.g., document)
		if ( selector ) {
			jQuery.find.matchesSelector( documentElement, selector );
		}

		// Make sure that the handler has a unique ID, used to find/remove it later
		if ( !handler.guid ) {
			handler.guid = jQuery.guid++;
		}

		// Init the element's event structure and main handler, if this is the first
		if ( !( events = elemData.events ) ) {
			events = elemData.events = {};
		}
		if ( !( eventHandle = elemData.handle ) ) {
			eventHandle = elemData.handle = function( e ) {

				// Discard the second event of a jQuery.event.trigger() and
				// when an event is called after a page has unloaded
				return typeof jQuery !== "undefined" && jQuery.event.triggered !== e.type ?
					jQuery.event.dispatch.apply( elem, arguments ) : undefined;
			};
		}

		// Handle multiple events separated by a space
		types = ( types || "" ).match( rnothtmlwhite ) || [ "" ];
		t = types.length;
		while ( t-- ) {
			tmp = rtypenamespace.exec( types[ t ] ) || [];
			type = origType = tmp[ 1 ];
			namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

			// There *must* be a type, no attaching namespace-only handlers
			if ( !type ) {
				continue;
			}

			// If event changes its type, use the special event handlers for the changed type
			special = jQuery.event.special[ type ] || {};

			// If selector defined, determine special event api type, otherwise given type
			type = ( selector ? special.delegateType : special.bindType ) || type;

			// Update special based on newly reset type
			special = jQuery.event.special[ type ] || {};

			// handleObj is passed to all event handlers
			handleObj = jQuery.extend( {
				type: type,
				origType: origType,
				data: data,
				handler: handler,
				guid: handler.guid,
				selector: selector,
				needsContext: selector && jQuery.expr.match.needsContext.test( selector ),
				namespace: namespaces.join( "." )
			}, handleObjIn );

			// Init the event handler queue if we're the first
			if ( !( handlers = events[ type ] ) ) {
				handlers = events[ type ] = [];
				handlers.delegateCount = 0;

				// Only use addEventListener if the special events handler returns false
				if ( !special.setup ||
					special.setup.call( elem, data, namespaces, eventHandle ) === false ) {

					if ( elem.addEventListener ) {
						elem.addEventListener( type, eventHandle );
					}
				}
			}

			if ( special.add ) {
				special.add.call( elem, handleObj );

				if ( !handleObj.handler.guid ) {
					handleObj.handler.guid = handler.guid;
				}
			}

			// Add to the element's handler list, delegates in front
			if ( selector ) {
				handlers.splice( handlers.delegateCount++, 0, handleObj );
			} else {
				handlers.push( handleObj );
			}

			// Keep track of which events have ever been used, for event optimization
			jQuery.event.global[ type ] = true;
		}

	},

	// Detach an event or set of events from an element
	remove: function( elem, types, handler, selector, mappedTypes ) {

		var j, origCount, tmp,
			events, t, handleObj,
			special, handlers, type, namespaces, origType,
			elemData = dataPriv.hasData( elem ) && dataPriv.get( elem );

		if ( !elemData || !( events = elemData.events ) ) {
			return;
		}

		// Once for each type.namespace in types; type may be omitted
		types = ( types || "" ).match( rnothtmlwhite ) || [ "" ];
		t = types.length;
		while ( t-- ) {
			tmp = rtypenamespace.exec( types[ t ] ) || [];
			type = origType = tmp[ 1 ];
			namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

			// Unbind all events (on this namespace, if provided) for the element
			if ( !type ) {
				for ( type in events ) {
					jQuery.event.remove( elem, type + types[ t ], handler, selector, true );
				}
				continue;
			}

			special = jQuery.event.special[ type ] || {};
			type = ( selector ? special.delegateType : special.bindType ) || type;
			handlers = events[ type ] || [];
			tmp = tmp[ 2 ] &&
				new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" );

			// Remove matching events
			origCount = j = handlers.length;
			while ( j-- ) {
				handleObj = handlers[ j ];

				if ( ( mappedTypes || origType === handleObj.origType ) &&
					( !handler || handler.guid === handleObj.guid ) &&
					( !tmp || tmp.test( handleObj.namespace ) ) &&
					( !selector || selector === handleObj.selector ||
						selector === "**" && handleObj.selector ) ) {
					handlers.splice( j, 1 );

					if ( handleObj.selector ) {
						handlers.delegateCount--;
					}
					if ( special.remove ) {
						special.remove.call( elem, handleObj );
					}
				}
			}

			// Remove generic event handler if we removed something and no more handlers exist
			// (avoids potential for endless recursion during removal of special event handlers)
			if ( origCount && !handlers.length ) {
				if ( !special.teardown ||
					special.teardown.call( elem, namespaces, elemData.handle ) === false ) {

					jQuery.removeEvent( elem, type, elemData.handle );
				}

				delete events[ type ];
			}
		}

		// Remove data and the expando if it's no longer used
		if ( jQuery.isEmptyObject( events ) ) {
			dataPriv.remove( elem, "handle events" );
		}
	},

	dispatch: function( nativeEvent ) {

		// Make a writable jQuery.Event from the native event object
		var event = jQuery.event.fix( nativeEvent );

		var i, j, ret, matched, handleObj, handlerQueue,
			args = new Array( arguments.length ),
			handlers = ( dataPriv.get( this, "events" ) || {} )[ event.type ] || [],
			special = jQuery.event.special[ event.type ] || {};

		// Use the fix-ed jQuery.Event rather than the (read-only) native event
		args[ 0 ] = event;

		for ( i = 1; i < arguments.length; i++ ) {
			args[ i ] = arguments[ i ];
		}

		event.delegateTarget = this;

		// Call the preDispatch hook for the mapped type, and let it bail if desired
		if ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {
			return;
		}

		// Determine handlers
		handlerQueue = jQuery.event.handlers.call( this, event, handlers );

		// Run delegates first; they may want to stop propagation beneath us
		i = 0;
		while ( ( matched = handlerQueue[ i++ ] ) && !event.isPropagationStopped() ) {
			event.currentTarget = matched.elem;

			j = 0;
			while ( ( handleObj = matched.handlers[ j++ ] ) &&
				!event.isImmediatePropagationStopped() ) {

				// Triggered event must either 1) have no namespace, or 2) have namespace(s)
				// a subset or equal to those in the bound event (both can have no namespace).
				if ( !event.rnamespace || event.rnamespace.test( handleObj.namespace ) ) {

					event.handleObj = handleObj;
					event.data = handleObj.data;

					ret = ( ( jQuery.event.special[ handleObj.origType ] || {} ).handle ||
						handleObj.handler ).apply( matched.elem, args );

					if ( ret !== undefined ) {
						if ( ( event.result = ret ) === false ) {
							event.preventDefault();
							event.stopPropagation();
						}
					}
				}
			}
		}

		// Call the postDispatch hook for the mapped type
		if ( special.postDispatch ) {
			special.postDispatch.call( this, event );
		}

		return event.result;
	},

	handlers: function( event, handlers ) {
		var i, handleObj, sel, matchedHandlers, matchedSelectors,
			handlerQueue = [],
			delegateCount = handlers.delegateCount,
			cur = event.target;

		// Find delegate handlers
		if ( delegateCount &&

			// Support: IE <=9
			// Black-hole SVG <use> instance trees (trac-13180)
			cur.nodeType &&

			// Support: Firefox <=42
			// Suppress spec-violating clicks indicating a non-primary pointer button (trac-3861)
			// https://www.w3.org/TR/DOM-Level-3-Events/#event-type-click
			// Support: IE 11 only
			// ...but not arrow key "clicks" of radio inputs, which can have `button` -1 (gh-2343)
			!( event.type === "click" && event.button >= 1 ) ) {

			for ( ; cur !== this; cur = cur.parentNode || this ) {

				// Don't check non-elements (#13208)
				// Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)
				if ( cur.nodeType === 1 && !( event.type === "click" && cur.disabled === true ) ) {
					matchedHandlers = [];
					matchedSelectors = {};
					for ( i = 0; i < delegateCount; i++ ) {
						handleObj = handlers[ i ];

						// Don't conflict with Object.prototype properties (#13203)
						sel = handleObj.selector + " ";

						if ( matchedSelectors[ sel ] === undefined ) {
							matchedSelectors[ sel ] = handleObj.needsContext ?
								jQuery( sel, this ).index( cur ) > -1 :
								jQuery.find( sel, this, null, [ cur ] ).length;
						}
						if ( matchedSelectors[ sel ] ) {
							matchedHandlers.push( handleObj );
						}
					}
					if ( matchedHandlers.length ) {
						handlerQueue.push( { elem: cur, handlers: matchedHandlers } );
					}
				}
			}
		}

		// Add the remaining (directly-bound) handlers
		cur = this;
		if ( delegateCount < handlers.length ) {
			handlerQueue.push( { elem: cur, handlers: handlers.slice( delegateCount ) } );
		}

		return handlerQueue;
	},

	addProp: function( name, hook ) {
		Object.defineProperty( jQuery.Event.prototype, name, {
			enumerable: true,
			configurable: true,

			get: isFunction( hook ) ?
				function() {
					if ( this.originalEvent ) {
							return hook( this.originalEvent );
					}
				} :
				function() {
					if ( this.originalEvent ) {
							return this.originalEvent[ name ];
					}
				},

			set: function( value ) {
				Object.defineProperty( this, name, {
					enumerable: true,
					configurable: true,
					writable: true,
					value: value
				} );
			}
		} );
	},

	fix: function( originalEvent ) {
		return originalEvent[ jQuery.expando ] ?
			originalEvent :
			new jQuery.Event( originalEvent );
	},

	special: {
		load: {

			// Prevent triggered image.load events from bubbling to window.load
			noBubble: true
		},
		focus: {

			// Fire native event if possible so blur/focus sequence is correct
			trigger: function() {
				if ( this !== safeActiveElement() && this.focus ) {
					this.focus();
					return false;
				}
			},
			delegateType: "focusin"
		},
		blur: {
			trigger: function() {
				if ( this === safeActiveElement() && this.blur ) {
					this.blur();
					return false;
				}
			},
			delegateType: "focusout"
		},
		click: {

			// For checkbox, fire native event so checked state will be right
			trigger: function() {
				if ( this.type === "checkbox" && this.click && nodeName( this, "input" ) ) {
					this.click();
					return false;
				}
			},

			// For cross-browser consistency, don't fire native .click() on links
			_default: function( event ) {
				return nodeName( event.target, "a" );
			}
		},

		beforeunload: {
			postDispatch: function( event ) {

				// Support: Firefox 20+
				// Firefox doesn't alert if the returnValue field is not set.
				if ( event.result !== undefined && event.originalEvent ) {
					event.originalEvent.returnValue = event.result;
				}
			}
		}
	}
};

jQuery.removeEvent = function( elem, type, handle ) {

	// This "if" is needed for plain objects
	if ( elem.removeEventListener ) {
		elem.removeEventListener( type, handle );
	}
};

jQuery.Event = function( src, props ) {

	// Allow instantiation without the 'new' keyword
	if ( !( this instanceof jQuery.Event ) ) {
		return new jQuery.Event( src, props );
	}

	// Event object
	if ( src && src.type ) {
		this.originalEvent = src;
		this.type = src.type;

		// Events bubbling up the document may have been marked as prevented
		// by a handler lower down the tree; reflect the correct value.
		this.isDefaultPrevented = src.defaultPrevented ||
				src.defaultPrevented === undefined &&

				// Support: Android <=2.3 only
				src.returnValue === false ?
			returnTrue :
			returnFalse;

		// Create target properties
		// Support: Safari <=6 - 7 only
		// Target should not be a text node (#504, #13143)
		this.target = ( src.target && src.target.nodeType === 3 ) ?
			src.target.parentNode :
			src.target;

		this.currentTarget = src.currentTarget;
		this.relatedTarget = src.relatedTarget;

	// Event type
	} else {
		this.type = src;
	}

	// Put explicitly provided properties onto the event object
	if ( props ) {
		jQuery.extend( this, props );
	}

	// Create a timestamp if incoming event doesn't have one
	this.timeStamp = src && src.timeStamp || Date.now();

	// Mark it as fixed
	this[ jQuery.expando ] = true;
};

// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
// https://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
jQuery.Event.prototype = {
	constructor: jQuery.Event,
	isDefaultPrevented: returnFalse,
	isPropagationStopped: returnFalse,
	isImmediatePropagationStopped: returnFalse,
	isSimulated: false,

	preventDefault: function() {
		var e = this.originalEvent;

		this.isDefaultPrevented = returnTrue;

		if ( e && !this.isSimulated ) {
			e.preventDefault();
		}
	},
	stopPropagation: function() {
		var e = this.originalEvent;

		this.isPropagationStopped = returnTrue;

		if ( e && !this.isSimulated ) {
			e.stopPropagation();
		}
	},
	stopImmediatePropagation: function() {
		var e = this.originalEvent;

		this.isImmediatePropagationStopped = returnTrue;

		if ( e && !this.isSimulated ) {
			e.stopImmediatePropagation();
		}

		this.stopPropagation();
	}
};

// Includes all common event props including KeyEvent and MouseEvent specific props
jQuery.each( {
	altKey: true,
	bubbles: true,
	cancelable: true,
	changedTouches: true,
	ctrlKey: true,
	detail: true,
	eventPhase: true,
	metaKey: true,
	pageX: true,
	pageY: true,
	shiftKey: true,
	view: true,
	"char": true,
	charCode: true,
	key: true,
	keyCode: true,
	button: true,
	buttons: true,
	clientX: true,
	clientY: true,
	offsetX: true,
	offsetY: true,
	pointerId: true,
	pointerType: true,
	screenX: true,
	screenY: true,
	targetTouches: true,
	toElement: true,
	touches: true,

	which: function( event ) {
		var button = event.button;

		// Add which for key events
		if ( event.which == null && rkeyEvent.test( event.type ) ) {
			return event.charCode != null ? event.charCode : event.keyCode;
		}

		// Add which for click: 1 === left; 2 === middle; 3 === right
		if ( !event.which && button !== undefined && rmouseEvent.test( event.type ) ) {
			if ( button & 1 ) {
				return 1;
			}

			if ( button & 2 ) {
				return 3;
			}

			if ( button & 4 ) {
				return 2;
			}

			return 0;
		}

		return event.which;
	}
}, jQuery.event.addProp );

// Create mouseenter/leave events using mouseover/out and event-time checks
// so that event delegation works in jQuery.
// Do the same for pointerenter/pointerleave and pointerover/pointerout
//
// Support: Safari 7 only
// Safari sends mouseenter too often; see:
// https://bugs.chromium.org/p/chromium/issues/detail?id=470258
// for the description of the bug (it existed in older Chrome versions as well).
jQuery.each( {
	mouseenter: "mouseover",
	mouseleave: "mouseout",
	pointerenter: "pointerover",
	pointerleave: "pointerout"
}, function( orig, fix ) {
	jQuery.event.special[ orig ] = {
		delegateType: fix,
		bindType: fix,

		handle: function( event ) {
			var ret,
				target = this,
				related = event.relatedTarget,
				handleObj = event.handleObj;

			// For mouseenter/leave call the handler if related is outside the target.
			// NB: No relatedTarget if the mouse left/entered the browser window
			if ( !related || ( related !== target && !jQuery.contains( target, related ) ) ) {
				event.type = handleObj.origType;
				ret = handleObj.handler.apply( this, arguments );
				event.type = fix;
			}
			return ret;
		}
	};
} );

jQuery.fn.extend( {

	on: function( types, selector, data, fn ) {
		return on( this, types, selector, data, fn );
	},
	one: function( types, selector, data, fn ) {
		return on( this, types, selector, data, fn, 1 );
	},
	off: function( types, selector, fn ) {
		var handleObj, type;
		if ( types && types.preventDefault && types.handleObj ) {

			// ( event )  dispatched jQuery.Event
			handleObj = types.handleObj;
			jQuery( types.delegateTarget ).off(
				handleObj.namespace ?
					handleObj.origType + "." + handleObj.namespace :
					handleObj.origType,
				handleObj.selector,
				handleObj.handler
			);
			return this;
		}
		if ( typeof types === "object" ) {

			// ( types-object [, selector] )
			for ( type in types ) {
				this.off( type, selector, types[ type ] );
			}
			return this;
		}
		if ( selector === false || typeof selector === "function" ) {

			// ( types [, fn] )
			fn = selector;
			selector = undefined;
		}
		if ( fn === false ) {
			fn = returnFalse;
		}
		return this.each( function() {
			jQuery.event.remove( this, types, fn, selector );
		} );
	}
} );


var

	/* eslint-disable max-len */

	// See https://github.com/eslint/eslint/issues/3229
	rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\/\0>\x20\t\r\n\f]*)[^>]*)\/>/gi,

	/* eslint-enable */

	// Support: IE <=10 - 11, Edge 12 - 13 only
	// In IE/Edge using regex groups here causes severe slowdowns.
	// See https://connect.microsoft.com/IE/feedback/details/1736512/
	rnoInnerhtml = /<script|<style|<link/i,

	// checked="checked" or checked
	rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,
	rcleanScript = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;

// Prefer a tbody over its parent table for containing new rows
function manipulationTarget( elem, content ) {
	if ( nodeName( elem, "table" ) &&
		nodeName( content.nodeType !== 11 ? content : content.firstChild, "tr" ) ) {

		return jQuery( elem ).children( "tbody" )[ 0 ] || elem;
	}

	return elem;
}

// Replace/restore the type attribute of script elements for safe DOM manipulation
function disableScript( elem ) {
	elem.type = ( elem.getAttribute( "type" ) !== null ) + "/" + elem.type;
	return elem;
}
function restoreScript( elem ) {
	if ( ( elem.type || "" ).slice( 0, 5 ) === "true/" ) {
		elem.type = elem.type.slice( 5 );
	} else {
		elem.removeAttribute( "type" );
	}

	return elem;
}

function cloneCopyEvent( src, dest ) {
	var i, l, type, pdataOld, pdataCur, udataOld, udataCur, events;

	if ( dest.nodeType !== 1 ) {
		return;
	}

	// 1. Copy private data: events, handlers, etc.
	if ( dataPriv.hasData( src ) ) {
		pdataOld = dataPriv.access( src );
		pdataCur = dataPriv.set( dest, pdataOld );
		events = pdataOld.events;

		if ( events ) {
			delete pdataCur.handle;
			pdataCur.events = {};

			for ( type in events ) {
				for ( i = 0, l = events[ type ].length; i < l; i++ ) {
					jQuery.event.add( dest, type, events[ type ][ i ] );
				}
			}
		}
	}

	// 2. Copy user data
	if ( dataUser.hasData( src ) ) {
		udataOld = dataUser.access( src );
		udataCur = jQuery.extend( {}, udataOld );

		dataUser.set( dest, udataCur );
	}
}

// Fix IE bugs, see support tests
function fixInput( src, dest ) {
	var nodeName = dest.nodeName.toLowerCase();

	// Fails to persist the checked state of a cloned checkbox or radio button.
	if ( nodeName === "input" && rcheckableType.test( src.type ) ) {
		dest.checked = src.checked;

	// Fails to return the selected option to the default selected state when cloning options
	} else if ( nodeName === "input" || nodeName === "textarea" ) {
		dest.defaultValue = src.defaultValue;
	}
}

function domManip( collection, args, callback, ignored ) {

	// Flatten any nested arrays
	args = concat.apply( [], args );

	var fragment, first, scripts, hasScripts, node, doc,
		i = 0,
		l = collection.length,
		iNoClone = l - 1,
		value = args[ 0 ],
		valueIsFunction = isFunction( value );

	// We can't cloneNode fragments that contain checked, in WebKit
	if ( valueIsFunction ||
			( l > 1 && typeof value === "string" &&
				!support.checkClone && rchecked.test( value ) ) ) {
		return collection.each( function( index ) {
			var self = collection.eq( index );
			if ( valueIsFunction ) {
				args[ 0 ] = value.call( this, index, self.html() );
			}
			domManip( self, args, callback, ignored );
		} );
	}

	if ( l ) {
		fragment = buildFragment( args, collection[ 0 ].ownerDocument, false, collection, ignored );
		first = fragment.firstChild;

		if ( fragment.childNodes.length === 1 ) {
			fragment = first;
		}

		// Require either new content or an interest in ignored elements to invoke the callback
		if ( first || ignored ) {
			scripts = jQuery.map( getAll( fragment, "script" ), disableScript );
			hasScripts = scripts.length;

			// Use the original fragment for the last item
			// instead of the first because it can end up
			// being emptied incorrectly in certain situations (#8070).
			for ( ; i < l; i++ ) {
				node = fragment;

				if ( i !== iNoClone ) {
					node = jQuery.clone( node, true, true );

					// Keep references to cloned scripts for later restoration
					if ( hasScripts ) {

						// Support: Android <=4.0 only, PhantomJS 1 only
						// push.apply(_, arraylike) throws on ancient WebKit
						jQuery.merge( scripts, getAll( node, "script" ) );
					}
				}

				callback.call( collection[ i ], node, i );
			}

			if ( hasScripts ) {
				doc = scripts[ scripts.length - 1 ].ownerDocument;

				// Reenable scripts
				jQuery.map( scripts, restoreScript );

				// Evaluate executable scripts on first document insertion
				for ( i = 0; i < hasScripts; i++ ) {
					node = scripts[ i ];
					if ( rscriptType.test( node.type || "" ) &&
						!dataPriv.access( node, "globalEval" ) &&
						jQuery.contains( doc, node ) ) {

						if ( node.src && ( node.type || "" ).toLowerCase()  !== "module" ) {

							// Optional AJAX dependency, but won't run scripts if not present
							if ( jQuery._evalUrl ) {
								jQuery._evalUrl( node.src );
							}
						} else {
							DOMEval( node.textContent.replace( rcleanScript, "" ), doc, node );
						}
					}
				}
			}
		}
	}

	return collection;
}

function remove( elem, selector, keepData ) {
	var node,
		nodes = selector ? jQuery.filter( selector, elem ) : elem,
		i = 0;

	for ( ; ( node = nodes[ i ] ) != null; i++ ) {
		if ( !keepData && node.nodeType === 1 ) {
			jQuery.cleanData( getAll( node ) );
		}

		if ( node.parentNode ) {
			if ( keepData && jQuery.contains( node.ownerDocument, node ) ) {
				setGlobalEval( getAll( node, "script" ) );
			}
			node.parentNode.removeChild( node );
		}
	}

	return elem;
}

jQuery.extend( {
	htmlPrefilter: function( html ) {
		return html.replace( rxhtmlTag, "<$1></$2>" );
	},

	clone: function( elem, dataAndEvents, deepDataAndEvents ) {
		var i, l, srcElements, destElements,
			clone = elem.cloneNode( true ),
			inPage = jQuery.contains( elem.ownerDocument, elem );

		// Fix IE cloning issues
		if ( !support.noCloneChecked && ( elem.nodeType === 1 || elem.nodeType === 11 ) &&
				!jQuery.isXMLDoc( elem ) ) {

			// We eschew Sizzle here for performance reasons: https://jsperf.com/getall-vs-sizzle/2
			destElements = getAll( clone );
			srcElements = getAll( elem );

			for ( i = 0, l = srcElements.length; i < l; i++ ) {
				fixInput( srcElements[ i ], destElements[ i ] );
			}
		}

		// Copy the events from the original to the clone
		if ( dataAndEvents ) {
			if ( deepDataAndEvents ) {
				srcElements = srcElements || getAll( elem );
				destElements = destElements || getAll( clone );

				for ( i = 0, l = srcElements.length; i < l; i++ ) {
					cloneCopyEvent( srcElements[ i ], destElements[ i ] );
				}
			} else {
				cloneCopyEvent( elem, clone );
			}
		}

		// Preserve script evaluation history
		destElements = getAll( clone, "script" );
		if ( destElements.length > 0 ) {
			setGlobalEval( destElements, !inPage && getAll( elem, "script" ) );
		}

		// Return the cloned set
		return clone;
	},

	cleanData: function( elems ) {
		var data, elem, type,
			special = jQuery.event.special,
			i = 0;

		for ( ; ( elem = elems[ i ] ) !== undefined; i++ ) {
			if ( acceptData( elem ) ) {
				if ( ( data = elem[ dataPriv.expando ] ) ) {
					if ( data.events ) {
						for ( type in data.events ) {
							if ( special[ type ] ) {
								jQuery.event.remove( elem, type );

							// This is a shortcut to avoid jQuery.event.remove's overhead
							} else {
								jQuery.removeEvent( elem, type, data.handle );
							}
						}
					}

					// Support: Chrome <=35 - 45+
					// Assign undefined instead of using delete, see Data#remove
					elem[ dataPriv.expando ] = undefined;
				}
				if ( elem[ dataUser.expando ] ) {

					// Support: Chrome <=35 - 45+
					// Assign undefined instead of using delete, see Data#remove
					elem[ dataUser.expando ] = undefined;
				}
			}
		}
	}
} );

jQuery.fn.extend( {
	detach: function( selector ) {
		return remove( this, selector, true );
	},

	remove: function( selector ) {
		return remove( this, selector );
	},

	text: function( value ) {
		return access( this, function( value ) {
			return value === undefined ?
				jQuery.text( this ) :
				this.empty().each( function() {
					if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
						this.textContent = value;
					}
				} );
		}, null, value, arguments.length );
	},

	append: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
				var target = manipulationTarget( this, elem );
				target.appendChild( elem );
			}
		} );
	},

	prepend: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
				var target = manipulationTarget( this, elem );
				target.insertBefore( elem, target.firstChild );
			}
		} );
	},

	before: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.parentNode ) {
				this.parentNode.insertBefore( elem, this );
			}
		} );
	},

	after: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.parentNode ) {
				this.parentNode.insertBefore( elem, this.nextSibling );
			}
		} );
	},

	empty: function() {
		var elem,
			i = 0;

		for ( ; ( elem = this[ i ] ) != null; i++ ) {
			if ( elem.nodeType === 1 ) {

				// Prevent memory leaks
				jQuery.cleanData( getAll( elem, false ) );

				// Remove any remaining nodes
				elem.textContent = "";
			}
		}

		return this;
	},

	clone: function( dataAndEvents, deepDataAndEvents ) {
		dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
		deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;

		return this.map( function() {
			return jQuery.clone( this, dataAndEvents, deepDataAndEvents );
		} );
	},

	html: function( value ) {
		return access( this, function( value ) {
			var elem = this[ 0 ] || {},
				i = 0,
				l = this.length;

			if ( value === undefined && elem.nodeType === 1 ) {
				return elem.innerHTML;
			}

			// See if we can take a shortcut and just use innerHTML
			if ( typeof value === "string" && !rnoInnerhtml.test( value ) &&
				!wrapMap[ ( rtagName.exec( value ) || [ "", "" ] )[ 1 ].toLowerCase() ] ) {

				value = jQuery.htmlPrefilter( value );

				try {
					for ( ; i < l; i++ ) {
						elem = this[ i ] || {};

						// Remove element nodes and prevent memory leaks
						if ( elem.nodeType === 1 ) {
							jQuery.cleanData( getAll( elem, false ) );
							elem.innerHTML = value;
						}
					}

					elem = 0;

				// If using innerHTML throws an exception, use the fallback method
				} catch ( e ) {}
			}

			if ( elem ) {
				this.empty().append( value );
			}
		}, null, value, arguments.length );
	},

	replaceWith: function() {
		var ignored = [];

		// Make the changes, replacing each non-ignored context element with the new content
		return domManip( this, arguments, function( elem ) {
			var parent = this.parentNode;

			if ( jQuery.inArray( this, ignored ) < 0 ) {
				jQuery.cleanData( getAll( this ) );
				if ( parent ) {
					parent.replaceChild( elem, this );
				}
			}

		// Force callback invocation
		}, ignored );
	}
} );

jQuery.each( {
	appendTo: "append",
	prependTo: "prepend",
	insertBefore: "before",
	insertAfter: "after",
	replaceAll: "replaceWith"
}, function( name, original ) {
	jQuery.fn[ name ] = function( selector ) {
		var elems,
			ret = [],
			insert = jQuery( selector ),
			last = insert.length - 1,
			i = 0;

		for ( ; i <= last; i++ ) {
			elems = i === last ? this : this.clone( true );
			jQuery( insert[ i ] )[ original ]( elems );

			// Support: Android <=4.0 only, PhantomJS 1 only
			// .get() because push.apply(_, arraylike) throws on ancient WebKit
			push.apply( ret, elems.get() );
		}

		return this.pushStack( ret );
	};
} );
var rnumnonpx = new RegExp( "^(" + pnum + ")(?!px)[a-z%]+$", "i" );

var getStyles = function( elem ) {

		// Support: IE <=11 only, Firefox <=30 (#15098, #14150)
		// IE throws on elements created in popups
		// FF meanwhile throws on frame elements through "defaultView.getComputedStyle"
		var view = elem.ownerDocument.defaultView;

		if ( !view || !view.opener ) {
			view = window;
		}

		return view.getComputedStyle( elem );
	};

var rboxStyle = new RegExp( cssExpand.join( "|" ), "i" );



( function() {

	// Executing both pixelPosition & boxSizingReliable tests require only one layout
	// so they're executed at the same time to save the second computation.
	function computeStyleTests() {

		// This is a singleton, we need to execute it only once
		if ( !div ) {
			return;
		}

		container.style.cssText = "position:absolute;left:-11111px;width:60px;" +
			"margin-top:1px;padding:0;border:0";
		div.style.cssText =
			"position:relative;display:block;box-sizing:border-box;overflow:scroll;" +
			"margin:auto;border:1px;padding:1px;" +
			"width:60%;top:1%";
		documentElement.appendChild( container ).appendChild( div );

		var divStyle = window.getComputedStyle( div );
		pixelPositionVal = divStyle.top !== "1%";

		// Support: Android 4.0 - 4.3 only, Firefox <=3 - 44
		reliableMarginLeftVal = roundPixelMeasures( divStyle.marginLeft ) === 12;

		// Support: Android 4.0 - 4.3 only, Safari <=9.1 - 10.1, iOS <=7.0 - 9.3
		// Some styles come back with percentage values, even though they shouldn't
		div.style.right = "60%";
		pixelBoxStylesVal = roundPixelMeasures( divStyle.right ) === 36;

		// Support: IE 9 - 11 only
		// Detect misreporting of content dimensions for box-sizing:border-box elements
		boxSizingReliableVal = roundPixelMeasures( divStyle.width ) === 36;

		// Support: IE 9 only
		// Detect overflow:scroll screwiness (gh-3699)
		div.style.position = "absolute";
		scrollboxSizeVal = div.offsetWidth === 36 || "absolute";

		documentElement.removeChild( container );

		// Nullify the div so it wouldn't be stored in the memory and
		// it will also be a sign that checks already performed
		div = null;
	}

	function roundPixelMeasures( measure ) {
		return Math.round( parseFloat( measure ) );
	}

	var pixelPositionVal, boxSizingReliableVal, scrollboxSizeVal, pixelBoxStylesVal,
		reliableMarginLeftVal,
		container = document.createElement( "div" ),
		div = document.createElement( "div" );

	// Finish early in limited (non-browser) environments
	if ( !div.style ) {
		return;
	}

	// Support: IE <=9 - 11 only
	// Style of cloned element affects source element cloned (#8908)
	div.style.backgroundClip = "content-box";
	div.cloneNode( true ).style.backgroundClip = "";
	support.clearCloneStyle = div.style.backgroundClip === "content-box";

	jQuery.extend( support, {
		boxSizingReliable: function() {
			computeStyleTests();
			return boxSizingReliableVal;
		},
		pixelBoxStyles: function() {
			computeStyleTests();
			return pixelBoxStylesVal;
		},
		pixelPosition: function() {
			computeStyleTests();
			return pixelPositionVal;
		},
		reliableMarginLeft: function() {
			computeStyleTests();
			return reliableMarginLeftVal;
		},
		scrollboxSize: function() {
			computeStyleTests();
			return scrollboxSizeVal;
		}
	} );
} )();


function curCSS( elem, name, computed ) {
	var width, minWidth, maxWidth, ret,

		// Support: Firefox 51+
		// Retrieving style before computed somehow
		// fixes an issue with getting wrong values
		// on detached elements
		style = elem.style;

	computed = computed || getStyles( elem );

	// getPropertyValue is needed for:
	//   .css('filter') (IE 9 only, #12537)
	//   .css('--customProperty) (#3144)
	if ( computed ) {
		ret = computed.getPropertyValue( name ) || computed[ name ];

		if ( ret === "" && !jQuery.contains( elem.ownerDocument, elem ) ) {
			ret = jQuery.style( elem, name );
		}

		// A tribute to the "awesome hack by Dean Edwards"
		// Android Browser returns percentage for some values,
		// but width seems to be reliably pixels.
		// This is against the CSSOM draft spec:
		// https://drafts.csswg.org/cssom/#resolved-values
		if ( !support.pixelBoxStyles() && rnumnonpx.test( ret ) && rboxStyle.test( name ) ) {

			// Remember the original values
			width = style.width;
			minWidth = style.minWidth;
			maxWidth = style.maxWidth;

			// Put in the new values to get a computed value out
			style.minWidth = style.maxWidth = style.width = ret;
			ret = computed.width;

			// Revert the changed values
			style.width = width;
			style.minWidth = minWidth;
			style.maxWidth = maxWidth;
		}
	}

	return ret !== undefined ?

		// Support: IE <=9 - 11 only
		// IE returns zIndex value as an integer.
		ret + "" :
		ret;
}


function addGetHookIf( conditionFn, hookFn ) {

	// Define the hook, we'll check on the first run if it's really needed.
	return {
		get: function() {
			if ( conditionFn() ) {

				// Hook not needed (or it's not possible to use it due
				// to missing dependency), remove it.
				delete this.get;
				return;
			}

			// Hook needed; redefine it so that the support test is not executed again.
			return ( this.get = hookFn ).apply( this, arguments );
		}
	};
}


var

	// Swappable if display is none or starts with table
	// except "table", "table-cell", or "table-caption"
	// See here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
	rdisplayswap = /^(none|table(?!-c[ea]).+)/,
	rcustomProp = /^--/,
	cssShow = { position: "absolute", visibility: "hidden", display: "block" },
	cssNormalTransform = {
		letterSpacing: "0",
		fontWeight: "400"
	},

	cssPrefixes = [ "Webkit", "Moz", "ms" ],
	emptyStyle = document.createElement( "div" ).style;

// Return a css property mapped to a potentially vendor prefixed property
function vendorPropName( name ) {

	// Shortcut for names that are not vendor prefixed
	if ( name in emptyStyle ) {
		return name;
	}

	// Check for vendor prefixed names
	var capName = name[ 0 ].toUpperCase() + name.slice( 1 ),
		i = cssPrefixes.length;

	while ( i-- ) {
		name = cssPrefixes[ i ] + capName;
		if ( name in emptyStyle ) {
			return name;
		}
	}
}

// Return a property mapped along what jQuery.cssProps suggests or to
// a vendor prefixed property.
function finalPropName( name ) {
	var ret = jQuery.cssProps[ name ];
	if ( !ret ) {
		ret = jQuery.cssProps[ name ] = vendorPropName( name ) || name;
	}
	return ret;
}

function setPositiveNumber( elem, value, subtract ) {

	// Any relative (+/-) values have already been
	// normalized at this point
	var matches = rcssNum.exec( value );
	return matches ?

		// Guard against undefined "subtract", e.g., when used as in cssHooks
		Math.max( 0, matches[ 2 ] - ( subtract || 0 ) ) + ( matches[ 3 ] || "px" ) :
		value;
}

function boxModelAdjustment( elem, dimension, box, isBorderBox, styles, computedVal ) {
	var i = dimension === "width" ? 1 : 0,
		extra = 0,
		delta = 0;

	// Adjustment may not be necessary
	if ( box === ( isBorderBox ? "border" : "content" ) ) {
		return 0;
	}

	for ( ; i < 4; i += 2 ) {

		// Both box models exclude margin
		if ( box === "margin" ) {
			delta += jQuery.css( elem, box + cssExpand[ i ], true, styles );
		}

		// If we get here with a content-box, we're seeking "padding" or "border" or "margin"
		if ( !isBorderBox ) {

			// Add padding
			delta += jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );

			// For "border" or "margin", add border
			if ( box !== "padding" ) {
				delta += jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );

			// But still keep track of it otherwise
			} else {
				extra += jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
			}

		// If we get here with a border-box (content + padding + border), we're seeking "content" or
		// "padding" or "margin"
		} else {

			// For "content", subtract padding
			if ( box === "content" ) {
				delta -= jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );
			}

			// For "content" or "padding", subtract border
			if ( box !== "margin" ) {
				delta -= jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
			}
		}
	}

	// Account for positive content-box scroll gutter when requested by providing computedVal
	if ( !isBorderBox && computedVal >= 0 ) {

		// offsetWidth/offsetHeight is a rounded sum of content, padding, scroll gutter, and border
		// Assuming integer scroll gutter, subtract the rest and round down
		delta += Math.max( 0, Math.ceil(
			elem[ "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 ) ] -
			computedVal -
			delta -
			extra -
			0.5
		) );
	}

	return delta;
}

function getWidthOrHeight( elem, dimension, extra ) {

	// Start with computed style
	var styles = getStyles( elem ),
		val = curCSS( elem, dimension, styles ),
		isBorderBox = jQuery.css( elem, "boxSizing", false, styles ) === "border-box",
		valueIsBorderBox = isBorderBox;

	// Support: Firefox <=54
	// Return a confounding non-pixel value or feign ignorance, as appropriate.
	if ( rnumnonpx.test( val ) ) {
		if ( !extra ) {
			return val;
		}
		val = "auto";
	}

	// Check for style in case a browser which returns unreliable values
	// for getComputedStyle silently falls back to the reliable elem.style
	valueIsBorderBox = valueIsBorderBox &&
		( support.boxSizingReliable() || val === elem.style[ dimension ] );

	// Fall back to offsetWidth/offsetHeight when value is "auto"
	// This happens for inline elements with no explicit setting (gh-3571)
	// Support: Android <=4.1 - 4.3 only
	// Also use offsetWidth/offsetHeight for misreported inline dimensions (gh-3602)
	if ( val === "auto" ||
		!parseFloat( val ) && jQuery.css( elem, "display", false, styles ) === "inline" ) {

		val = elem[ "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 ) ];

		// offsetWidth/offsetHeight provide border-box values
		valueIsBorderBox = true;
	}

	// Normalize "" and auto
	val = parseFloat( val ) || 0;

	// Adjust for the element's box model
	return ( val +
		boxModelAdjustment(
			elem,
			dimension,
			extra || ( isBorderBox ? "border" : "content" ),
			valueIsBorderBox,
			styles,

			// Provide the current computed size to request scroll gutter calculation (gh-3589)
			val
		)
	) + "px";
}

jQuery.extend( {

	// Add in style property hooks for overriding the default
	// behavior of getting and setting a style property
	cssHooks: {
		opacity: {
			get: function( elem, computed ) {
				if ( computed ) {

					// We should always get a number back from opacity
					var ret = curCSS( elem, "opacity" );
					return ret === "" ? "1" : ret;
				}
			}
		}
	},

	// Don't automatically add "px" to these possibly-unitless properties
	cssNumber: {
		"animationIterationCount": true,
		"columnCount": true,
		"fillOpacity": true,
		"flexGrow": true,
		"flexShrink": true,
		"fontWeight": true,
		"lineHeight": true,
		"opacity": true,
		"order": true,
		"orphans": true,
		"widows": true,
		"zIndex": true,
		"zoom": true
	},

	// Add in properties whose names you wish to fix before
	// setting or getting the value
	cssProps: {},

	// Get and set the style property on a DOM Node
	style: function( elem, name, value, extra ) {

		// Don't set styles on text and comment nodes
		if ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {
			return;
		}

		// Make sure that we're working with the right name
		var ret, type, hooks,
			origName = camelCase( name ),
			isCustomProp = rcustomProp.test( name ),
			style = elem.style;

		// Make sure that we're working with the right name. We don't
		// want to query the value if it is a CSS custom property
		// since they are user-defined.
		if ( !isCustomProp ) {
			name = finalPropName( origName );
		}

		// Gets hook for the prefixed version, then unprefixed version
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// Check if we're setting a value
		if ( value !== undefined ) {
			type = typeof value;

			// Convert "+=" or "-=" to relative numbers (#7345)
			if ( type === "string" && ( ret = rcssNum.exec( value ) ) && ret[ 1 ] ) {
				value = adjustCSS( elem, name, ret );

				// Fixes bug #9237
				type = "number";
			}

			// Make sure that null and NaN values aren't set (#7116)
			if ( value == null || value !== value ) {
				return;
			}

			// If a number was passed in, add the unit (except for certain CSS properties)
			if ( type === "number" ) {
				value += ret && ret[ 3 ] || ( jQuery.cssNumber[ origName ] ? "" : "px" );
			}

			// background-* props affect original clone's values
			if ( !support.clearCloneStyle && value === "" && name.indexOf( "background" ) === 0 ) {
				style[ name ] = "inherit";
			}

			// If a hook was provided, use that value, otherwise just set the specified value
			if ( !hooks || !( "set" in hooks ) ||
				( value = hooks.set( elem, value, extra ) ) !== undefined ) {

				if ( isCustomProp ) {
					style.setProperty( name, value );
				} else {
					style[ name ] = value;
				}
			}

		} else {

			// If a hook was provided get the non-computed value from there
			if ( hooks && "get" in hooks &&
				( ret = hooks.get( elem, false, extra ) ) !== undefined ) {

				return ret;
			}

			// Otherwise just get the value from the style object
			return style[ name ];
		}
	},

	css: function( elem, name, extra, styles ) {
		var val, num, hooks,
			origName = camelCase( name ),
			isCustomProp = rcustomProp.test( name );

		// Make sure that we're working with the right name. We don't
		// want to modify the value if it is a CSS custom property
		// since they are user-defined.
		if ( !isCustomProp ) {
			name = finalPropName( origName );
		}

		// Try prefixed name followed by the unprefixed name
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// If a hook was provided get the computed value from there
		if ( hooks && "get" in hooks ) {
			val = hooks.get( elem, true, extra );
		}

		// Otherwise, if a way to get the computed value exists, use that
		if ( val === undefined ) {
			val = curCSS( elem, name, styles );
		}

		// Convert "normal" to computed value
		if ( val === "normal" && name in cssNormalTransform ) {
			val = cssNormalTransform[ name ];
		}

		// Make numeric if forced or a qualifier was provided and val looks numeric
		if ( extra === "" || extra ) {
			num = parseFloat( val );
			return extra === true || isFinite( num ) ? num || 0 : val;
		}

		return val;
	}
} );

jQuery.each( [ "height", "width" ], function( i, dimension ) {
	jQuery.cssHooks[ dimension ] = {
		get: function( elem, computed, extra ) {
			if ( computed ) {

				// Certain elements can have dimension info if we invisibly show them
				// but it must have a current display style that would benefit
				return rdisplayswap.test( jQuery.css( elem, "display" ) ) &&

					// Support: Safari 8+
					// Table columns in Safari have non-zero offsetWidth & zero
					// getBoundingClientRect().width unless display is changed.
					// Support: IE <=11 only
					// Running getBoundingClientRect on a disconnected node
					// in IE throws an error.
					( !elem.getClientRects().length || !elem.getBoundingClientRect().width ) ?
						swap( elem, cssShow, function() {
							return getWidthOrHeight( elem, dimension, extra );
						} ) :
						getWidthOrHeight( elem, dimension, extra );
			}
		},

		set: function( elem, value, extra ) {
			var matches,
				styles = getStyles( elem ),
				isBorderBox = jQuery.css( elem, "boxSizing", false, styles ) === "border-box",
				subtract = extra && boxModelAdjustment(
					elem,
					dimension,
					extra,
					isBorderBox,
					styles
				);

			// Account for unreliable border-box dimensions by comparing offset* to computed and
			// faking a content-box to get border and padding (gh-3699)
			if ( isBorderBox && support.scrollboxSize() === styles.position ) {
				subtract -= Math.ceil(
					elem[ "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 ) ] -
					parseFloat( styles[ dimension ] ) -
					boxModelAdjustment( elem, dimension, "border", false, styles ) -
					0.5
				);
			}

			// Convert to pixels if value adjustment is needed
			if ( subtract && ( matches = rcssNum.exec( value ) ) &&
				( matches[ 3 ] || "px" ) !== "px" ) {

				elem.style[ dimension ] = value;
				value = jQuery.css( elem, dimension );
			}

			return setPositiveNumber( elem, value, subtract );
		}
	};
} );

jQuery.cssHooks.marginLeft = addGetHookIf( support.reliableMarginLeft,
	function( elem, computed ) {
		if ( computed ) {
			return ( parseFloat( curCSS( elem, "marginLeft" ) ) ||
				elem.getBoundingClientRect().left -
					swap( elem, { marginLeft: 0 }, function() {
						return elem.getBoundingClientRect().left;
					} )
				) + "px";
		}
	}
);

// These hooks are used by animate to expand properties
jQuery.each( {
	margin: "",
	padding: "",
	border: "Width"
}, function( prefix, suffix ) {
	jQuery.cssHooks[ prefix + suffix ] = {
		expand: function( value ) {
			var i = 0,
				expanded = {},

				// Assumes a single number if not a string
				parts = typeof value === "string" ? value.split( " " ) : [ value ];

			for ( ; i < 4; i++ ) {
				expanded[ prefix + cssExpand[ i ] + suffix ] =
					parts[ i ] || parts[ i - 2 ] || parts[ 0 ];
			}

			return expanded;
		}
	};

	if ( prefix !== "margin" ) {
		jQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;
	}
} );

jQuery.fn.extend( {
	css: function( name, value ) {
		return access( this, function( elem, name, value ) {
			var styles, len,
				map = {},
				i = 0;

			if ( Array.isArray( name ) ) {
				styles = getStyles( elem );
				len = name.length;

				for ( ; i < len; i++ ) {
					map[ name[ i ] ] = jQuery.css( elem, name[ i ], false, styles );
				}

				return map;
			}

			return value !== undefined ?
				jQuery.style( elem, name, value ) :
				jQuery.css( elem, name );
		}, name, value, arguments.length > 1 );
	}
} );


function Tween( elem, options, prop, end, easing ) {
	return new Tween.prototype.init( elem, options, prop, end, easing );
}
jQuery.Tween = Tween;

Tween.prototype = {
	constructor: Tween,
	init: function( elem, options, prop, end, easing, unit ) {
		this.elem = elem;
		this.prop = prop;
		this.easing = easing || jQuery.easing._default;
		this.options = options;
		this.start = this.now = this.cur();
		this.end = end;
		this.unit = unit || ( jQuery.cssNumber[ prop ] ? "" : "px" );
	},
	cur: function() {
		var hooks = Tween.propHooks[ this.prop ];

		return hooks && hooks.get ?
			hooks.get( this ) :
			Tween.propHooks._default.get( this );
	},
	run: function( percent ) {
		var eased,
			hooks = Tween.propHooks[ this.prop ];

		if ( this.options.duration ) {
			this.pos = eased = jQuery.easing[ this.easing ](
				percent, this.options.duration * percent, 0, 1, this.options.duration
			);
		} else {
			this.pos = eased = percent;
		}
		this.now = ( this.end - this.start ) * eased + this.start;

		if ( this.options.step ) {
			this.options.step.call( this.elem, this.now, this );
		}

		if ( hooks && hooks.set ) {
			hooks.set( this );
		} else {
			Tween.propHooks._default.set( this );
		}
		return this;
	}
};

Tween.prototype.init.prototype = Tween.prototype;

Tween.propHooks = {
	_default: {
		get: function( tween ) {
			var result;

			// Use a property on the element directly when it is not a DOM element,
			// or when there is no matching style property that exists.
			if ( tween.elem.nodeType !== 1 ||
				tween.elem[ tween.prop ] != null && tween.elem.style[ tween.prop ] == null ) {
				return tween.elem[ tween.prop ];
			}

			// Passing an empty string as a 3rd parameter to .css will automatically
			// attempt a parseFloat and fallback to a string if the parse fails.
			// Simple values such as "10px" are parsed to Float;
			// complex values such as "rotate(1rad)" are returned as-is.
			result = jQuery.css( tween.elem, tween.prop, "" );

			// Empty strings, null, undefined and "auto" are converted to 0.
			return !result || result === "auto" ? 0 : result;
		},
		set: function( tween ) {

			// Use step hook for back compat.
			// Use cssHook if its there.
			// Use .style if available and use plain properties where available.
			if ( jQuery.fx.step[ tween.prop ] ) {
				jQuery.fx.step[ tween.prop ]( tween );
			} else if ( tween.elem.nodeType === 1 &&
				( tween.elem.style[ jQuery.cssProps[ tween.prop ] ] != null ||
					jQuery.cssHooks[ tween.prop ] ) ) {
				jQuery.style( tween.elem, tween.prop, tween.now + tween.unit );
			} else {
				tween.elem[ tween.prop ] = tween.now;
			}
		}
	}
};

// Support: IE <=9 only
// Panic based approach to setting things on disconnected nodes
Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
	set: function( tween ) {
		if ( tween.elem.nodeType && tween.elem.parentNode ) {
			tween.elem[ tween.prop ] = tween.now;
		}
	}
};

jQuery.easing = {
	linear: function( p ) {
		return p;
	},
	swing: function( p ) {
		return 0.5 - Math.cos( p * Math.PI ) / 2;
	},
	_default: "swing"
};

jQuery.fx = Tween.prototype.init;

// Back compat <1.8 extension point
jQuery.fx.step = {};




var
	fxNow, inProgress,
	rfxtypes = /^(?:toggle|show|hide)$/,
	rrun = /queueHooks$/;

function schedule() {
	if ( inProgress ) {
		if ( document.hidden === false && window.requestAnimationFrame ) {
			window.requestAnimationFrame( schedule );
		} else {
			window.setTimeout( schedule, jQuery.fx.interval );
		}

		jQuery.fx.tick();
	}
}

// Animations created synchronously will run synchronously
function createFxNow() {
	window.setTimeout( function() {
		fxNow = undefined;
	} );
	return ( fxNow = Date.now() );
}

// Generate parameters to create a standard animation
function genFx( type, includeWidth ) {
	var which,
		i = 0,
		attrs = { height: type };

	// If we include width, step value is 1 to do all cssExpand values,
	// otherwise step value is 2 to skip over Left and Right
	includeWidth = includeWidth ? 1 : 0;
	for ( ; i < 4; i += 2 - includeWidth ) {
		which = cssExpand[ i ];
		attrs[ "margin" + which ] = attrs[ "padding" + which ] = type;
	}

	if ( includeWidth ) {
		attrs.opacity = attrs.width = type;
	}

	return attrs;
}

function createTween( value, prop, animation ) {
	var tween,
		collection = ( Animation.tweeners[ prop ] || [] ).concat( Animation.tweeners[ "*" ] ),
		index = 0,
		length = collection.length;
	for ( ; index < length; index++ ) {
		if ( ( tween = collection[ index ].call( animation, prop, value ) ) ) {

			// We're done with this property
			return tween;
		}
	}
}

function defaultPrefilter( elem, props, opts ) {
	var prop, value, toggle, hooks, oldfire, propTween, restoreDisplay, display,
		isBox = "width" in props || "height" in props,
		anim = this,
		orig = {},
		style = elem.style,
		hidden = elem.nodeType && isHiddenWithinTree( elem ),
		dataShow = dataPriv.get( elem, "fxshow" );

	// Queue-skipping animations hijack the fx hooks
	if ( !opts.queue ) {
		hooks = jQuery._queueHooks( elem, "fx" );
		if ( hooks.unqueued == null ) {
			hooks.unqueued = 0;
			oldfire = hooks.empty.fire;
			hooks.empty.fire = function() {
				if ( !hooks.unqueued ) {
					oldfire();
				}
			};
		}
		hooks.unqueued++;

		anim.always( function() {

			// Ensure the complete handler is called before this completes
			anim.always( function() {
				hooks.unqueued--;
				if ( !jQuery.queue( elem, "fx" ).length ) {
					hooks.empty.fire();
				}
			} );
		} );
	}

	// Detect show/hide animations
	for ( prop in props ) {
		value = props[ prop ];
		if ( rfxtypes.test( value ) ) {
			delete props[ prop ];
			toggle = toggle || value === "toggle";
			if ( value === ( hidden ? "hide" : "show" ) ) {

				// Pretend to be hidden if this is a "show" and
				// there is still data from a stopped show/hide
				if ( value === "show" && dataShow && dataShow[ prop ] !== undefined ) {
					hidden = true;

				// Ignore all other no-op show/hide data
				} else {
					continue;
				}
			}
			orig[ prop ] = dataShow && dataShow[ prop ] || jQuery.style( elem, prop );
		}
	}

	// Bail out if this is a no-op like .hide().hide()
	propTween = !jQuery.isEmptyObject( props );
	if ( !propTween && jQuery.isEmptyObject( orig ) ) {
		return;
	}

	// Restrict "overflow" and "display" styles during box animations
	if ( isBox && elem.nodeType === 1 ) {

		// Support: IE <=9 - 11, Edge 12 - 15
		// Record all 3 overflow attributes because IE does not infer the shorthand
		// from identically-valued overflowX and overflowY and Edge just mirrors
		// the overflowX value there.
		opts.overflow = [ style.overflow, style.overflowX, style.overflowY ];

		// Identify a display type, preferring old show/hide data over the CSS cascade
		restoreDisplay = dataShow && dataShow.display;
		if ( restoreDisplay == null ) {
			restoreDisplay = dataPriv.get( elem, "display" );
		}
		display = jQuery.css( elem, "display" );
		if ( display === "none" ) {
			if ( restoreDisplay ) {
				display = restoreDisplay;
			} else {

				// Get nonempty value(s) by temporarily forcing visibility
				showHide( [ elem ], true );
				restoreDisplay = elem.style.display || restoreDisplay;
				display = jQuery.css( elem, "display" );
				showHide( [ elem ] );
			}
		}

		// Animate inline elements as inline-block
		if ( display === "inline" || display === "inline-block" && restoreDisplay != null ) {
			if ( jQuery.css( elem, "float" ) === "none" ) {

				// Restore the original display value at the end of pure show/hide animations
				if ( !propTween ) {
					anim.done( function() {
						style.display = restoreDisplay;
					} );
					if ( restoreDisplay == null ) {
						display = style.display;
						restoreDisplay = display === "none" ? "" : display;
					}
				}
				style.display = "inline-block";
			}
		}
	}

	if ( opts.overflow ) {
		style.overflow = "hidden";
		anim.always( function() {
			style.overflow = opts.overflow[ 0 ];
			style.overflowX = opts.overflow[ 1 ];
			style.overflowY = opts.overflow[ 2 ];
		} );
	}

	// Implement show/hide animations
	propTween = false;
	for ( prop in orig ) {

		// General show/hide setup for this element animation
		if ( !propTween ) {
			if ( dataShow ) {
				if ( "hidden" in dataShow ) {
					hidden = dataShow.hidden;
				}
			} else {
				dataShow = dataPriv.access( elem, "fxshow", { display: restoreDisplay } );
			}

			// Store hidden/visible for toggle so `.stop().toggle()` "reverses"
			if ( toggle ) {
				dataShow.hidden = !hidden;
			}

			// Show elements before animating them
			if ( hidden ) {
				showHide( [ elem ], true );
			}

			/* eslint-disable no-loop-func */

			anim.done( function() {

			/* eslint-enable no-loop-func */

				// The final step of a "hide" animation is actually hiding the element
				if ( !hidden ) {
					showHide( [ elem ] );
				}
				dataPriv.remove( elem, "fxshow" );
				for ( prop in orig ) {
					jQuery.style( elem, prop, orig[ prop ] );
				}
			} );
		}

		// Per-property setup
		propTween = createTween( hidden ? dataShow[ prop ] : 0, prop, anim );
		if ( !( prop in dataShow ) ) {
			dataShow[ prop ] = propTween.start;
			if ( hidden ) {
				propTween.end = propTween.start;
				propTween.start = 0;
			}
		}
	}
}

function propFilter( props, specialEasing ) {
	var index, name, easing, value, hooks;

	// camelCase, specialEasing and expand cssHook pass
	for ( index in props ) {
		name = camelCase( index );
		easing = specialEasing[ name ];
		value = props[ index ];
		if ( Array.isArray( value ) ) {
			easing = value[ 1 ];
			value = props[ index ] = value[ 0 ];
		}

		if ( index !== name ) {
			props[ name ] = value;
			delete props[ index ];
		}

		hooks = jQuery.cssHooks[ name ];
		if ( hooks && "expand" in hooks ) {
			value = hooks.expand( value );
			delete props[ name ];

			// Not quite $.extend, this won't overwrite existing keys.
			// Reusing 'index' because we have the correct "name"
			for ( index in value ) {
				if ( !( index in props ) ) {
					props[ index ] = value[ index ];
					specialEasing[ index ] = easing;
				}
			}
		} else {
			specialEasing[ name ] = easing;
		}
	}
}

function Animation( elem, properties, options ) {
	var result,
		stopped,
		index = 0,
		length = Animation.prefilters.length,
		deferred = jQuery.Deferred().always( function() {

			// Don't match elem in the :animated selector
			delete tick.elem;
		} ),
		tick = function() {
			if ( stopped ) {
				return false;
			}
			var currentTime = fxNow || createFxNow(),
				remaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),

				// Support: Android 2.3 only
				// Archaic crash bug won't allow us to use `1 - ( 0.5 || 0 )` (#12497)
				temp = remaining / animation.duration || 0,
				percent = 1 - temp,
				index = 0,
				length = animation.tweens.length;

			for ( ; index < length; index++ ) {
				animation.tweens[ index ].run( percent );
			}

			deferred.notifyWith( elem, [ animation, percent, remaining ] );

			// If there's more to do, yield
			if ( percent < 1 && length ) {
				return remaining;
			}

			// If this was an empty animation, synthesize a final progress notification
			if ( !length ) {
				deferred.notifyWith( elem, [ animation, 1, 0 ] );
			}

			// Resolve the animation and report its conclusion
			deferred.resolveWith( elem, [ animation ] );
			return false;
		},
		animation = deferred.promise( {
			elem: elem,
			props: jQuery.extend( {}, properties ),
			opts: jQuery.extend( true, {
				specialEasing: {},
				easing: jQuery.easing._default
			}, options ),
			originalProperties: properties,
			originalOptions: options,
			startTime: fxNow || createFxNow(),
			duration: options.duration,
			tweens: [],
			createTween: function( prop, end ) {
				var tween = jQuery.Tween( elem, animation.opts, prop, end,
						animation.opts.specialEasing[ prop ] || animation.opts.easing );
				animation.tweens.push( tween );
				return tween;
			},
			stop: function( gotoEnd ) {
				var index = 0,

					// If we are going to the end, we want to run all the tweens
					// otherwise we skip this part
					length = gotoEnd ? animation.tweens.length : 0;
				if ( stopped ) {
					return this;
				}
				stopped = true;
				for ( ; index < length; index++ ) {
					animation.tweens[ index ].run( 1 );
				}

				// Resolve when we played the last frame; otherwise, reject
				if ( gotoEnd ) {
					deferred.notifyWith( elem, [ animation, 1, 0 ] );
					deferred.resolveWith( elem, [ animation, gotoEnd ] );
				} else {
					deferred.rejectWith( elem, [ animation, gotoEnd ] );
				}
				return this;
			}
		} ),
		props = animation.props;

	propFilter( props, animation.opts.specialEasing );

	for ( ; index < length; index++ ) {
		result = Animation.prefilters[ index ].call( animation, elem, props, animation.opts );
		if ( result ) {
			if ( isFunction( result.stop ) ) {
				jQuery._queueHooks( animation.elem, animation.opts.queue ).stop =
					result.stop.bind( result );
			}
			return result;
		}
	}

	jQuery.map( props, createTween, animation );

	if ( isFunction( animation.opts.start ) ) {
		animation.opts.start.call( elem, animation );
	}

	// Attach callbacks from options
	animation
		.progress( animation.opts.progress )
		.done( animation.opts.done, animation.opts.complete )
		.fail( animation.opts.fail )
		.always( animation.opts.always );

	jQuery.fx.timer(
		jQuery.extend( tick, {
			elem: elem,
			anim: animation,
			queue: animation.opts.queue
		} )
	);

	return animation;
}

jQuery.Animation = jQuery.extend( Animation, {

	tweeners: {
		"*": [ function( prop, value ) {
			var tween = this.createTween( prop, value );
			adjustCSS( tween.elem, prop, rcssNum.exec( value ), tween );
			return tween;
		} ]
	},

	tweener: function( props, callback ) {
		if ( isFunction( props ) ) {
			callback = props;
			props = [ "*" ];
		} else {
			props = props.match( rnothtmlwhite );
		}

		var prop,
			index = 0,
			length = props.length;

		for ( ; index < length; index++ ) {
			prop = props[ index ];
			Animation.tweeners[ prop ] = Animation.tweeners[ prop ] || [];
			Animation.tweeners[ prop ].unshift( callback );
		}
	},

	prefilters: [ defaultPrefilter ],

	prefilter: function( callback, prepend ) {
		if ( prepend ) {
			Animation.prefilters.unshift( callback );
		} else {
			Animation.prefilters.push( callback );
		}
	}
} );

jQuery.speed = function( speed, easing, fn ) {
	var opt = speed && typeof speed === "object" ? jQuery.extend( {}, speed ) : {
		complete: fn || !fn && easing ||
			isFunction( speed ) && speed,
		duration: speed,
		easing: fn && easing || easing && !isFunction( easing ) && easing
	};

	// Go to the end state if fx are off
	if ( jQuery.fx.off ) {
		opt.duration = 0;

	} else {
		if ( typeof opt.duration !== "number" ) {
			if ( opt.duration in jQuery.fx.speeds ) {
				opt.duration = jQuery.fx.speeds[ opt.duration ];

			} else {
				opt.duration = jQuery.fx.speeds._default;
			}
		}
	}

	// Normalize opt.queue - true/undefined/null -> "fx"
	if ( opt.queue == null || opt.queue === true ) {
		opt.queue = "fx";
	}

	// Queueing
	opt.old = opt.complete;

	opt.complete = function() {
		if ( isFunction( opt.old ) ) {
			opt.old.call( this );
		}

		if ( opt.queue ) {
			jQuery.dequeue( this, opt.queue );
		}
	};

	return opt;
};

jQuery.fn.extend( {
	fadeTo: function( speed, to, easing, callback ) {

		// Show any hidden elements after setting opacity to 0
		return this.filter( isHiddenWithinTree ).css( "opacity", 0 ).show()

			// Animate to the value specified
			.end().animate( { opacity: to }, speed, easing, callback );
	},
	animate: function( prop, speed, easing, callback ) {
		var empty = jQuery.isEmptyObject( prop ),
			optall = jQuery.speed( speed, easing, callback ),
			doAnimation = function() {

				// Operate on a copy of prop so per-property easing won't be lost
				var anim = Animation( this, jQuery.extend( {}, prop ), optall );

				// Empty animations, or finishing resolves immediately
				if ( empty || dataPriv.get( this, "finish" ) ) {
					anim.stop( true );
				}
			};
			doAnimation.finish = doAnimation;

		return empty || optall.queue === false ?
			this.each( doAnimation ) :
			this.queue( optall.queue, doAnimation );
	},
	stop: function( type, clearQueue, gotoEnd ) {
		var stopQueue = function( hooks ) {
			var stop = hooks.stop;
			delete hooks.stop;
			stop( gotoEnd );
		};

		if ( typeof type !== "string" ) {
			gotoEnd = clearQueue;
			clearQueue = type;
			type = undefined;
		}
		if ( clearQueue && type !== false ) {
			this.queue( type || "fx", [] );
		}

		return this.each( function() {
			var dequeue = true,
				index = type != null && type + "queueHooks",
				timers = jQuery.timers,
				data = dataPriv.get( this );

			if ( index ) {
				if ( data[ index ] && data[ index ].stop ) {
					stopQueue( data[ index ] );
				}
			} else {
				for ( index in data ) {
					if ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {
						stopQueue( data[ index ] );
					}
				}
			}

			for ( index = timers.length; index--; ) {
				if ( timers[ index ].elem === this &&
					( type == null || timers[ index ].queue === type ) ) {

					timers[ index ].anim.stop( gotoEnd );
					dequeue = false;
					timers.splice( index, 1 );
				}
			}

			// Start the next in the queue if the last step wasn't forced.
			// Timers currently will call their complete callbacks, which
			// will dequeue but only if they were gotoEnd.
			if ( dequeue || !gotoEnd ) {
				jQuery.dequeue( this, type );
			}
		} );
	},
	finish: function( type ) {
		if ( type !== false ) {
			type = type || "fx";
		}
		return this.each( function() {
			var index,
				data = dataPriv.get( this ),
				queue = data[ type + "queue" ],
				hooks = data[ type + "queueHooks" ],
				timers = jQuery.timers,
				length = queue ? queue.length : 0;

			// Enable finishing flag on private data
			data.finish = true;

			// Empty the queue first
			jQuery.queue( this, type, [] );

			if ( hooks && hooks.stop ) {
				hooks.stop.call( this, true );
			}

			// Look for any active animations, and finish them
			for ( index = timers.length; index--; ) {
				if ( timers[ index ].elem === this && timers[ index ].queue === type ) {
					timers[ index ].anim.stop( true );
					timers.splice( index, 1 );
				}
			}

			// Look for any animations in the old queue and finish them
			for ( index = 0; index < length; index++ ) {
				if ( queue[ index ] && queue[ index ].finish ) {
					queue[ index ].finish.call( this );
				}
			}

			// Turn off finishing flag
			delete data.finish;
		} );
	}
} );

jQuery.each( [ "toggle", "show", "hide" ], function( i, name ) {
	var cssFn = jQuery.fn[ name ];
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return speed == null || typeof speed === "boolean" ?
			cssFn.apply( this, arguments ) :
			this.animate( genFx( name, true ), speed, easing, callback );
	};
} );

// Generate shortcuts for custom animations
jQuery.each( {
	slideDown: genFx( "show" ),
	slideUp: genFx( "hide" ),
	slideToggle: genFx( "toggle" ),
	fadeIn: { opacity: "show" },
	fadeOut: { opacity: "hide" },
	fadeToggle: { opacity: "toggle" }
}, function( name, props ) {
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return this.animate( props, speed, easing, callback );
	};
} );

jQuery.timers = [];
jQuery.fx.tick = function() {
	var timer,
		i = 0,
		timers = jQuery.timers;

	fxNow = Date.now();

	for ( ; i < timers.length; i++ ) {
		timer = timers[ i ];

		// Run the timer and safely remove it when done (allowing for external removal)
		if ( !timer() && timers[ i ] === timer ) {
			timers.splice( i--, 1 );
		}
	}

	if ( !timers.length ) {
		jQuery.fx.stop();
	}
	fxNow = undefined;
};

jQuery.fx.timer = function( timer ) {
	jQuery.timers.push( timer );
	jQuery.fx.start();
};

jQuery.fx.interval = 13;
jQuery.fx.start = function() {
	if ( inProgress ) {
		return;
	}

	inProgress = true;
	schedule();
};

jQuery.fx.stop = function() {
	inProgress = null;
};

jQuery.fx.speeds = {
	slow: 600,
	fast: 200,

	// Default speed
	_default: 400
};


// Based off of the plugin by Clint Helfers, with permission.
// https://web.archive.org/web/20100324014747/http://blindsignals.com/index.php/2009/07/jquery-delay/
jQuery.fn.delay = function( time, type ) {
	time = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;
	type = type || "fx";

	return this.queue( type, function( next, hooks ) {
		var timeout = window.setTimeout( next, time );
		hooks.stop = function() {
			window.clearTimeout( timeout );
		};
	} );
};


( function() {
	var input = document.createElement( "input" ),
		select = document.createElement( "select" ),
		opt = select.appendChild( document.createElement( "option" ) );

	input.type = "checkbox";

	// Support: Android <=4.3 only
	// Default value for a checkbox should be "on"
	support.checkOn = input.value !== "";

	// Support: IE <=11 only
	// Must access selectedIndex to make default options select
	support.optSelected = opt.selected;

	// Support: IE <=11 only
	// An input loses its value after becoming a radio
	input = document.createElement( "input" );
	input.value = "t";
	input.type = "radio";
	support.radioValue = input.value === "t";
} )();


var boolHook,
	attrHandle = jQuery.expr.attrHandle;

jQuery.fn.extend( {
	attr: function( name, value ) {
		return access( this, jQuery.attr, name, value, arguments.length > 1 );
	},

	removeAttr: function( name ) {
		return this.each( function() {
			jQuery.removeAttr( this, name );
		} );
	}
} );

jQuery.extend( {
	attr: function( elem, name, value ) {
		var ret, hooks,
			nType = elem.nodeType;

		// Don't get/set attributes on text, comment and attribute nodes
		if ( nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		// Fallback to prop when attributes are not supported
		if ( typeof elem.getAttribute === "undefined" ) {
			return jQuery.prop( elem, name, value );
		}

		// Attribute hooks are determined by the lowercase version
		// Grab necessary hook if one is defined
		if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {
			hooks = jQuery.attrHooks[ name.toLowerCase() ] ||
				( jQuery.expr.match.bool.test( name ) ? boolHook : undefined );
		}

		if ( value !== undefined ) {
			if ( value === null ) {
				jQuery.removeAttr( elem, name );
				return;
			}

			if ( hooks && "set" in hooks &&
				( ret = hooks.set( elem, value, name ) ) !== undefined ) {
				return ret;
			}

			elem.setAttribute( name, value + "" );
			return value;
		}

		if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {
			return ret;
		}

		ret = jQuery.find.attr( elem, name );

		// Non-existent attributes return null, we normalize to undefined
		return ret == null ? undefined : ret;
	},

	attrHooks: {
		type: {
			set: function( elem, value ) {
				if ( !support.radioValue && value === "radio" &&
					nodeName( elem, "input" ) ) {
					var val = elem.value;
					elem.setAttribute( "type", value );
					if ( val ) {
						elem.value = val;
					}
					return value;
				}
			}
		}
	},

	removeAttr: function( elem, value ) {
		var name,
			i = 0,

			// Attribute names can contain non-HTML whitespace characters
			// https://html.spec.whatwg.org/multipage/syntax.html#attributes-2
			attrNames = value && value.match( rnothtmlwhite );

		if ( attrNames && elem.nodeType === 1 ) {
			while ( ( name = attrNames[ i++ ] ) ) {
				elem.removeAttribute( name );
			}
		}
	}
} );

// Hooks for boolean attributes
boolHook = {
	set: function( elem, value, name ) {
		if ( value === false ) {

			// Remove boolean attributes when set to false
			jQuery.removeAttr( elem, name );
		} else {
			elem.setAttribute( name, name );
		}
		return name;
	}
};

jQuery.each( jQuery.expr.match.bool.source.match( /\w+/g ), function( i, name ) {
	var getter = attrHandle[ name ] || jQuery.find.attr;

	attrHandle[ name ] = function( elem, name, isXML ) {
		var ret, handle,
			lowercaseName = name.toLowerCase();

		if ( !isXML ) {

			// Avoid an infinite loop by temporarily removing this function from the getter
			handle = attrHandle[ lowercaseName ];
			attrHandle[ lowercaseName ] = ret;
			ret = getter( elem, name, isXML ) != null ?
				lowercaseName :
				null;
			attrHandle[ lowercaseName ] = handle;
		}
		return ret;
	};
} );




var rfocusable = /^(?:input|select|textarea|button)$/i,
	rclickable = /^(?:a|area)$/i;

jQuery.fn.extend( {
	prop: function( name, value ) {
		return access( this, jQuery.prop, name, value, arguments.length > 1 );
	},

	removeProp: function( name ) {
		return this.each( function() {
			delete this[ jQuery.propFix[ name ] || name ];
		} );
	}
} );

jQuery.extend( {
	prop: function( elem, name, value ) {
		var ret, hooks,
			nType = elem.nodeType;

		// Don't get/set properties on text, comment and attribute nodes
		if ( nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {

			// Fix name and attach hooks
			name = jQuery.propFix[ name ] || name;
			hooks = jQuery.propHooks[ name ];
		}

		if ( value !== undefined ) {
			if ( hooks && "set" in hooks &&
				( ret = hooks.set( elem, value, name ) ) !== undefined ) {
				return ret;
			}

			return ( elem[ name ] = value );
		}

		if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {
			return ret;
		}

		return elem[ name ];
	},

	propHooks: {
		tabIndex: {
			get: function( elem ) {

				// Support: IE <=9 - 11 only
				// elem.tabIndex doesn't always return the
				// correct value when it hasn't been explicitly set
				// https://web.archive.org/web/20141116233347/http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/
				// Use proper attribute retrieval(#12072)
				var tabindex = jQuery.find.attr( elem, "tabindex" );

				if ( tabindex ) {
					return parseInt( tabindex, 10 );
				}

				if (
					rfocusable.test( elem.nodeName ) ||
					rclickable.test( elem.nodeName ) &&
					elem.href
				) {
					return 0;
				}

				return -1;
			}
		}
	},

	propFix: {
		"for": "htmlFor",
		"class": "className"
	}
} );

// Support: IE <=11 only
// Accessing the selectedIndex property
// forces the browser to respect setting selected
// on the option
// The getter ensures a default option is selected
// when in an optgroup
// eslint rule "no-unused-expressions" is disabled for this code
// since it considers such accessions noop
if ( !support.optSelected ) {
	jQuery.propHooks.selected = {
		get: function( elem ) {

			/* eslint no-unused-expressions: "off" */

			var parent = elem.parentNode;
			if ( parent && parent.parentNode ) {
				parent.parentNode.selectedIndex;
			}
			return null;
		},
		set: function( elem ) {

			/* eslint no-unused-expressions: "off" */

			var parent = elem.parentNode;
			if ( parent ) {
				parent.selectedIndex;

				if ( parent.parentNode ) {
					parent.parentNode.selectedIndex;
				}
			}
		}
	};
}

jQuery.each( [
	"tabIndex",
	"readOnly",
	"maxLength",
	"cellSpacing",
	"cellPadding",
	"rowSpan",
	"colSpan",
	"useMap",
	"frameBorder",
	"contentEditable"
], function() {
	jQuery.propFix[ this.toLowerCase() ] = this;
} );




	// Strip and collapse whitespace according to HTML spec
	// https://infra.spec.whatwg.org/#strip-and-collapse-ascii-whitespace
	function stripAndCollapse( value ) {
		var tokens = value.match( rnothtmlwhite ) || [];
		return tokens.join( " " );
	}


function getClass( elem ) {
	return elem.getAttribute && elem.getAttribute( "class" ) || "";
}

function classesToArray( value ) {
	if ( Array.isArray( value ) ) {
		return value;
	}
	if ( typeof value === "string" ) {
		return value.match( rnothtmlwhite ) || [];
	}
	return [];
}

jQuery.fn.extend( {
	addClass: function( value ) {
		var classes, elem, cur, curValue, clazz, j, finalValue,
			i = 0;

		if ( isFunction( value ) ) {
			return this.each( function( j ) {
				jQuery( this ).addClass( value.call( this, j, getClass( this ) ) );
			} );
		}

		classes = classesToArray( value );

		if ( classes.length ) {
			while ( ( elem = this[ i++ ] ) ) {
				curValue = getClass( elem );
				cur = elem.nodeType === 1 && ( " " + stripAndCollapse( curValue ) + " " );

				if ( cur ) {
					j = 0;
					while ( ( clazz = classes[ j++ ] ) ) {
						if ( cur.indexOf( " " + clazz + " " ) < 0 ) {
							cur += clazz + " ";
						}
					}

					// Only assign if different to avoid unneeded rendering.
					finalValue = stripAndCollapse( cur );
					if ( curValue !== finalValue ) {
						elem.setAttribute( "class", finalValue );
					}
				}
			}
		}

		return this;
	},

	removeClass: function( value ) {
		var classes, elem, cur, curValue, clazz, j, finalValue,
			i = 0;

		if ( isFunction( value ) ) {
			return this.each( function( j ) {
				jQuery( this ).removeClass( value.call( this, j, getClass( this ) ) );
			} );
		}

		if ( !arguments.length ) {
			return this.attr( "class", "" );
		}

		classes = classesToArray( value );

		if ( classes.length ) {
			while ( ( elem = this[ i++ ] ) ) {
				curValue = getClass( elem );

				// This expression is here for better compressibility (see addClass)
				cur = elem.nodeType === 1 && ( " " + stripAndCollapse( curValue ) + " " );

				if ( cur ) {
					j = 0;
					while ( ( clazz = classes[ j++ ] ) ) {

						// Remove *all* instances
						while ( cur.indexOf( " " + clazz + " " ) > -1 ) {
							cur = cur.replace( " " + clazz + " ", " " );
						}
					}

					// Only assign if different to avoid unneeded rendering.
					finalValue = stripAndCollapse( cur );
					if ( curValue !== finalValue ) {
						elem.setAttribute( "class", finalValue );
					}
				}
			}
		}

		return this;
	},

	toggleClass: function( value, stateVal ) {
		var type = typeof value,
			isValidValue = type === "string" || Array.isArray( value );

		if ( typeof stateVal === "boolean" && isValidValue ) {
			return stateVal ? this.addClass( value ) : this.removeClass( value );
		}

		if ( isFunction( value ) ) {
			return this.each( function( i ) {
				jQuery( this ).toggleClass(
					value.call( this, i, getClass( this ), stateVal ),
					stateVal
				);
			} );
		}

		return this.each( function() {
			var className, i, self, classNames;

			if ( isValidValue ) {

				// Toggle individual class names
				i = 0;
				self = jQuery( this );
				classNames = classesToArray( value );

				while ( ( className = classNames[ i++ ] ) ) {

					// Check each className given, space separated list
					if ( self.hasClass( className ) ) {
						self.removeClass( className );
					} else {
						self.addClass( className );
					}
				}

			// Toggle whole class name
			} else if ( value === undefined || type === "boolean" ) {
				className = getClass( this );
				if ( className ) {

					// Store className if set
					dataPriv.set( this, "__className__", className );
				}

				// If the element has a class name or if we're passed `false`,
				// then remove the whole classname (if there was one, the above saved it).
				// Otherwise bring back whatever was previously saved (if anything),
				// falling back to the empty string if nothing was stored.
				if ( this.setAttribute ) {
					this.setAttribute( "class",
						className || value === false ?
						"" :
						dataPriv.get( this, "__className__" ) || ""
					);
				}
			}
		} );
	},

	hasClass: function( selector ) {
		var className, elem,
			i = 0;

		className = " " + selector + " ";
		while ( ( elem = this[ i++ ] ) ) {
			if ( elem.nodeType === 1 &&
				( " " + stripAndCollapse( getClass( elem ) ) + " " ).indexOf( className ) > -1 ) {
					return true;
			}
		}

		return false;
	}
} );




var rreturn = /\r/g;

jQuery.fn.extend( {
	val: function( value ) {
		var hooks, ret, valueIsFunction,
			elem = this[ 0 ];

		if ( !arguments.length ) {
			if ( elem ) {
				hooks = jQuery.valHooks[ elem.type ] ||
					jQuery.valHooks[ elem.nodeName.toLowerCase() ];

				if ( hooks &&
					"get" in hooks &&
					( ret = hooks.get( elem, "value" ) ) !== undefined
				) {
					return ret;
				}

				ret = elem.value;

				// Handle most common string cases
				if ( typeof ret === "string" ) {
					return ret.replace( rreturn, "" );
				}

				// Handle cases where value is null/undef or number
				return ret == null ? "" : ret;
			}

			return;
		}

		valueIsFunction = isFunction( value );

		return this.each( function( i ) {
			var val;

			if ( this.nodeType !== 1 ) {
				return;
			}

			if ( valueIsFunction ) {
				val = value.call( this, i, jQuery( this ).val() );
			} else {
				val = value;
			}

			// Treat null/undefined as ""; convert numbers to string
			if ( val == null ) {
				val = "";

			} else if ( typeof val === "number" ) {
				val += "";

			} else if ( Array.isArray( val ) ) {
				val = jQuery.map( val, function( value ) {
					return value == null ? "" : value + "";
				} );
			}

			hooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];

			// If set returns undefined, fall back to normal setting
			if ( !hooks || !( "set" in hooks ) || hooks.set( this, val, "value" ) === undefined ) {
				this.value = val;
			}
		} );
	}
} );

jQuery.extend( {
	valHooks: {
		option: {
			get: function( elem ) {

				var val = jQuery.find.attr( elem, "value" );
				return val != null ?
					val :

					// Support: IE <=10 - 11 only
					// option.text throws exceptions (#14686, #14858)
					// Strip and collapse whitespace
					// https://html.spec.whatwg.org/#strip-and-collapse-whitespace
					stripAndCollapse( jQuery.text( elem ) );
			}
		},
		select: {
			get: function( elem ) {
				var value, option, i,
					options = elem.options,
					index = elem.selectedIndex,
					one = elem.type === "select-one",
					values = one ? null : [],
					max = one ? index + 1 : options.length;

				if ( index < 0 ) {
					i = max;

				} else {
					i = one ? index : 0;
				}

				// Loop through all the selected options
				for ( ; i < max; i++ ) {
					option = options[ i ];

					// Support: IE <=9 only
					// IE8-9 doesn't update selected after form reset (#2551)
					if ( ( option.selected || i === index ) &&

							// Don't return options that are disabled or in a disabled optgroup
							!option.disabled &&
							( !option.parentNode.disabled ||
								!nodeName( option.parentNode, "optgroup" ) ) ) {

						// Get the specific value for the option
						value = jQuery( option ).val();

						// We don't need an array for one selects
						if ( one ) {
							return value;
						}

						// Multi-Selects return an array
						values.push( value );
					}
				}

				return values;
			},

			set: function( elem, value ) {
				var optionSet, option,
					options = elem.options,
					values = jQuery.makeArray( value ),
					i = options.length;

				while ( i-- ) {
					option = options[ i ];

					/* eslint-disable no-cond-assign */

					if ( option.selected =
						jQuery.inArray( jQuery.valHooks.option.get( option ), values ) > -1
					) {
						optionSet = true;
					}

					/* eslint-enable no-cond-assign */
				}

				// Force browsers to behave consistently when non-matching value is set
				if ( !optionSet ) {
					elem.selectedIndex = -1;
				}
				return values;
			}
		}
	}
} );

// Radios and checkboxes getter/setter
jQuery.each( [ "radio", "checkbox" ], function() {
	jQuery.valHooks[ this ] = {
		set: function( elem, value ) {
			if ( Array.isArray( value ) ) {
				return ( elem.checked = jQuery.inArray( jQuery( elem ).val(), value ) > -1 );
			}
		}
	};
	if ( !support.checkOn ) {
		jQuery.valHooks[ this ].get = function( elem ) {
			return elem.getAttribute( "value" ) === null ? "on" : elem.value;
		};
	}
} );




// Return jQuery for attributes-only inclusion


support.focusin = "onfocusin" in window;


var rfocusMorph = /^(?:focusinfocus|focusoutblur)$/,
	stopPropagationCallback = function( e ) {
		e.stopPropagation();
	};

jQuery.extend( jQuery.event, {

	trigger: function( event, data, elem, onlyHandlers ) {

		var i, cur, tmp, bubbleType, ontype, handle, special, lastElement,
			eventPath = [ elem || document ],
			type = hasOwn.call( event, "type" ) ? event.type : event,
			namespaces = hasOwn.call( event, "namespace" ) ? event.namespace.split( "." ) : [];

		cur = lastElement = tmp = elem = elem || document;

		// Don't do events on text and comment nodes
		if ( elem.nodeType === 3 || elem.nodeType === 8 ) {
			return;
		}

		// focus/blur morphs to focusin/out; ensure we're not firing them right now
		if ( rfocusMorph.test( type + jQuery.event.triggered ) ) {
			return;
		}

		if ( type.indexOf( "." ) > -1 ) {

			// Namespaced trigger; create a regexp to match event type in handle()
			namespaces = type.split( "." );
			type = namespaces.shift();
			namespaces.sort();
		}
		ontype = type.indexOf( ":" ) < 0 && "on" + type;

		// Caller can pass in a jQuery.Event object, Object, or just an event type string
		event = event[ jQuery.expando ] ?
			event :
			new jQuery.Event( type, typeof event === "object" && event );

		// Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)
		event.isTrigger = onlyHandlers ? 2 : 3;
		event.namespace = namespaces.join( "." );
		event.rnamespace = event.namespace ?
			new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" ) :
			null;

		// Clean up the event in case it is being reused
		event.result = undefined;
		if ( !event.target ) {
			event.target = elem;
		}

		// Clone any incoming data and prepend the event, creating the handler arg list
		data = data == null ?
			[ event ] :
			jQuery.makeArray( data, [ event ] );

		// Allow special events to draw outside the lines
		special = jQuery.event.special[ type ] || {};
		if ( !onlyHandlers && special.trigger && special.trigger.apply( elem, data ) === false ) {
			return;
		}

		// Determine event propagation path in advance, per W3C events spec (#9951)
		// Bubble up to document, then to window; watch for a global ownerDocument var (#9724)
		if ( !onlyHandlers && !special.noBubble && !isWindow( elem ) ) {

			bubbleType = special.delegateType || type;
			if ( !rfocusMorph.test( bubbleType + type ) ) {
				cur = cur.parentNode;
			}
			for ( ; cur; cur = cur.parentNode ) {
				eventPath.push( cur );
				tmp = cur;
			}

			// Only add window if we got to document (e.g., not plain obj or detached DOM)
			if ( tmp === ( elem.ownerDocument || document ) ) {
				eventPath.push( tmp.defaultView || tmp.parentWindow || window );
			}
		}

		// Fire handlers on the event path
		i = 0;
		while ( ( cur = eventPath[ i++ ] ) && !event.isPropagationStopped() ) {
			lastElement = cur;
			event.type = i > 1 ?
				bubbleType :
				special.bindType || type;

			// jQuery handler
			handle = ( dataPriv.get( cur, "events" ) || {} )[ event.type ] &&
				dataPriv.get( cur, "handle" );
			if ( handle ) {
				handle.apply( cur, data );
			}

			// Native handler
			handle = ontype && cur[ ontype ];
			if ( handle && handle.apply && acceptData( cur ) ) {
				event.result = handle.apply( cur, data );
				if ( event.result === false ) {
					event.preventDefault();
				}
			}
		}
		event.type = type;

		// If nobody prevented the default action, do it now
		if ( !onlyHandlers && !event.isDefaultPrevented() ) {

			if ( ( !special._default ||
				special._default.apply( eventPath.pop(), data ) === false ) &&
				acceptData( elem ) ) {

				// Call a native DOM method on the target with the same name as the event.
				// Don't do default actions on window, that's where global variables be (#6170)
				if ( ontype && isFunction( elem[ type ] ) && !isWindow( elem ) ) {

					// Don't re-trigger an onFOO event when we call its FOO() method
					tmp = elem[ ontype ];

					if ( tmp ) {
						elem[ ontype ] = null;
					}

					// Prevent re-triggering of the same event, since we already bubbled it above
					jQuery.event.triggered = type;

					if ( event.isPropagationStopped() ) {
						lastElement.addEventListener( type, stopPropagationCallback );
					}

					elem[ type ]();

					if ( event.isPropagationStopped() ) {
						lastElement.removeEventListener( type, stopPropagationCallback );
					}

					jQuery.event.triggered = undefined;

					if ( tmp ) {
						elem[ ontype ] = tmp;
					}
				}
			}
		}

		return event.result;
	},

	// Piggyback on a donor event to simulate a different one
	// Used only for `focus(in | out)` events
	simulate: function( type, elem, event ) {
		var e = jQuery.extend(
			new jQuery.Event(),
			event,
			{
				type: type,
				isSimulated: true
			}
		);

		jQuery.event.trigger( e, null, elem );
	}

} );

jQuery.fn.extend( {

	trigger: function( type, data ) {
		return this.each( function() {
			jQuery.event.trigger( type, data, this );
		} );
	},
	triggerHandler: function( type, data ) {
		var elem = this[ 0 ];
		if ( elem ) {
			return jQuery.event.trigger( type, data, elem, true );
		}
	}
} );


// Support: Firefox <=44
// Firefox doesn't have focus(in | out) events
// Related ticket - https://bugzilla.mozilla.org/show_bug.cgi?id=687787
//
// Support: Chrome <=48 - 49, Safari <=9.0 - 9.1
// focus(in | out) events fire after focus & blur events,
// which is spec violation - http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent-event-order
// Related ticket - https://bugs.chromium.org/p/chromium/issues/detail?id=449857
if ( !support.focusin ) {
	jQuery.each( { focus: "focusin", blur: "focusout" }, function( orig, fix ) {

		// Attach a single capturing handler on the document while someone wants focusin/focusout
		var handler = function( event ) {
			jQuery.event.simulate( fix, event.target, jQuery.event.fix( event ) );
		};

		jQuery.event.special[ fix ] = {
			setup: function() {
				var doc = this.ownerDocument || this,
					attaches = dataPriv.access( doc, fix );

				if ( !attaches ) {
					doc.addEventListener( orig, handler, true );
				}
				dataPriv.access( doc, fix, ( attaches || 0 ) + 1 );
			},
			teardown: function() {
				var doc = this.ownerDocument || this,
					attaches = dataPriv.access( doc, fix ) - 1;

				if ( !attaches ) {
					doc.removeEventListener( orig, handler, true );
					dataPriv.remove( doc, fix );

				} else {
					dataPriv.access( doc, fix, attaches );
				}
			}
		};
	} );
}
var location = window.location;

var nonce = Date.now();

var rquery = ( /\?/ );



// Cross-browser xml parsing
jQuery.parseXML = function( data ) {
	var xml;
	if ( !data || typeof data !== "string" ) {
		return null;
	}

	// Support: IE 9 - 11 only
	// IE throws on parseFromString with invalid input.
	try {
		xml = ( new window.DOMParser() ).parseFromString( data, "text/xml" );
	} catch ( e ) {
		xml = undefined;
	}

	if ( !xml || xml.getElementsByTagName( "parsererror" ).length ) {
		jQuery.error( "Invalid XML: " + data );
	}
	return xml;
};


var
	rbracket = /\[\]$/,
	rCRLF = /\r?\n/g,
	rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,
	rsubmittable = /^(?:input|select|textarea|keygen)/i;

function buildParams( prefix, obj, traditional, add ) {
	var name;

	if ( Array.isArray( obj ) ) {

		// Serialize array item.
		jQuery.each( obj, function( i, v ) {
			if ( traditional || rbracket.test( prefix ) ) {

				// Treat each array item as a scalar.
				add( prefix, v );

			} else {

				// Item is non-scalar (array or object), encode its numeric index.
				buildParams(
					prefix + "[" + ( typeof v === "object" && v != null ? i : "" ) + "]",
					v,
					traditional,
					add
				);
			}
		} );

	} else if ( !traditional && toType( obj ) === "object" ) {

		// Serialize object item.
		for ( name in obj ) {
			buildParams( prefix + "[" + name + "]", obj[ name ], traditional, add );
		}

	} else {

		// Serialize scalar item.
		add( prefix, obj );
	}
}

// Serialize an array of form elements or a set of
// key/values into a query string
jQuery.param = function( a, traditional ) {
	var prefix,
		s = [],
		add = function( key, valueOrFunction ) {

			// If value is a function, invoke it and use its return value
			var value = isFunction( valueOrFunction ) ?
				valueOrFunction() :
				valueOrFunction;

			s[ s.length ] = encodeURIComponent( key ) + "=" +
				encodeURIComponent( value == null ? "" : value );
		};

	// If an array was passed in, assume that it is an array of form elements.
	if ( Array.isArray( a ) || ( a.jquery && !jQuery.isPlainObject( a ) ) ) {

		// Serialize the form elements
		jQuery.each( a, function() {
			add( this.name, this.value );
		} );

	} else {

		// If traditional, encode the "old" way (the way 1.3.2 or older
		// did it), otherwise encode params recursively.
		for ( prefix in a ) {
			buildParams( prefix, a[ prefix ], traditional, add );
		}
	}

	// Return the resulting serialization
	return s.join( "&" );
};

jQuery.fn.extend( {
	serialize: function() {
		return jQuery.param( this.serializeArray() );
	},
	serializeArray: function() {
		return this.map( function() {

			// Can add propHook for "elements" to filter or add form elements
			var elements = jQuery.prop( this, "elements" );
			return elements ? jQuery.makeArray( elements ) : this;
		} )
		.filter( function() {
			var type = this.type;

			// Use .is( ":disabled" ) so that fieldset[disabled] works
			return this.name && !jQuery( this ).is( ":disabled" ) &&
				rsubmittable.test( this.nodeName ) && !rsubmitterTypes.test( type ) &&
				( this.checked || !rcheckableType.test( type ) );
		} )
		.map( function( i, elem ) {
			var val = jQuery( this ).val();

			if ( val == null ) {
				return null;
			}

			if ( Array.isArray( val ) ) {
				return jQuery.map( val, function( val ) {
					return { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
				} );
			}

			return { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
		} ).get();
	}
} );


var
	r20 = /%20/g,
	rhash = /#.*$/,
	rantiCache = /([?&])_=[^&]*/,
	rheaders = /^(.*?):[ \t]*([^\r\n]*)$/mg,

	// #7653, #8125, #8152: local protocol detection
	rlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/,
	rnoContent = /^(?:GET|HEAD)$/,
	rprotocol = /^\/\//,

	/* Prefilters
	 * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)
	 * 2) These are called:
	 *    - BEFORE asking for a transport
	 *    - AFTER param serialization (s.data is a string if s.processData is true)
	 * 3) key is the dataType
	 * 4) the catchall symbol "*" can be used
	 * 5) execution will start with transport dataType and THEN continue down to "*" if needed
	 */
	prefilters = {},

	/* Transports bindings
	 * 1) key is the dataType
	 * 2) the catchall symbol "*" can be used
	 * 3) selection will start with transport dataType and THEN go to "*" if needed
	 */
	transports = {},

	// Avoid comment-prolog char sequence (#10098); must appease lint and evade compression
	allTypes = "*/".concat( "*" ),

	// Anchor tag for parsing the document origin
	originAnchor = document.createElement( "a" );
	originAnchor.href = location.href;

// Base "constructor" for jQuery.ajaxPrefilter and jQuery.ajaxTransport
function addToPrefiltersOrTransports( structure ) {

	// dataTypeExpression is optional and defaults to "*"
	return function( dataTypeExpression, func ) {

		if ( typeof dataTypeExpression !== "string" ) {
			func = dataTypeExpression;
			dataTypeExpression = "*";
		}

		var dataType,
			i = 0,
			dataTypes = dataTypeExpression.toLowerCase().match( rnothtmlwhite ) || [];

		if ( isFunction( func ) ) {

			// For each dataType in the dataTypeExpression
			while ( ( dataType = dataTypes[ i++ ] ) ) {

				// Prepend if requested
				if ( dataType[ 0 ] === "+" ) {
					dataType = dataType.slice( 1 ) || "*";
					( structure[ dataType ] = structure[ dataType ] || [] ).unshift( func );

				// Otherwise append
				} else {
					( structure[ dataType ] = structure[ dataType ] || [] ).push( func );
				}
			}
		}
	};
}

// Base inspection function for prefilters and transports
function inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR ) {

	var inspected = {},
		seekingTransport = ( structure === transports );

	function inspect( dataType ) {
		var selected;
		inspected[ dataType ] = true;
		jQuery.each( structure[ dataType ] || [], function( _, prefilterOrFactory ) {
			var dataTypeOrTransport = prefilterOrFactory( options, originalOptions, jqXHR );
			if ( typeof dataTypeOrTransport === "string" &&
				!seekingTransport && !inspected[ dataTypeOrTransport ] ) {

				options.dataTypes.unshift( dataTypeOrTransport );
				inspect( dataTypeOrTransport );
				return false;
			} else if ( seekingTransport ) {
				return !( selected = dataTypeOrTransport );
			}
		} );
		return selected;
	}

	return inspect( options.dataTypes[ 0 ] ) || !inspected[ "*" ] && inspect( "*" );
}

// A special extend for ajax options
// that takes "flat" options (not to be deep extended)
// Fixes #9887
function ajaxExtend( target, src ) {
	var key, deep,
		flatOptions = jQuery.ajaxSettings.flatOptions || {};

	for ( key in src ) {
		if ( src[ key ] !== undefined ) {
			( flatOptions[ key ] ? target : ( deep || ( deep = {} ) ) )[ key ] = src[ key ];
		}
	}
	if ( deep ) {
		jQuery.extend( true, target, deep );
	}

	return target;
}

/* Handles responses to an ajax request:
 * - finds the right dataType (mediates between content-type and expected dataType)
 * - returns the corresponding response
 */
function ajaxHandleResponses( s, jqXHR, responses ) {

	var ct, type, finalDataType, firstDataType,
		contents = s.contents,
		dataTypes = s.dataTypes;

	// Remove auto dataType and get content-type in the process
	while ( dataTypes[ 0 ] === "*" ) {
		dataTypes.shift();
		if ( ct === undefined ) {
			ct = s.mimeType || jqXHR.getResponseHeader( "Content-Type" );
		}
	}

	// Check if we're dealing with a known content-type
	if ( ct ) {
		for ( type in contents ) {
			if ( contents[ type ] && contents[ type ].test( ct ) ) {
				dataTypes.unshift( type );
				break;
			}
		}
	}

	// Check to see if we have a response for the expected dataType
	if ( dataTypes[ 0 ] in responses ) {
		finalDataType = dataTypes[ 0 ];
	} else {

		// Try convertible dataTypes
		for ( type in responses ) {
			if ( !dataTypes[ 0 ] || s.converters[ type + " " + dataTypes[ 0 ] ] ) {
				finalDataType = type;
				break;
			}
			if ( !firstDataType ) {
				firstDataType = type;
			}
		}

		// Or just use first one
		finalDataType = finalDataType || firstDataType;
	}

	// If we found a dataType
	// We add the dataType to the list if needed
	// and return the corresponding response
	if ( finalDataType ) {
		if ( finalDataType !== dataTypes[ 0 ] ) {
			dataTypes.unshift( finalDataType );
		}
		return responses[ finalDataType ];
	}
}

/* Chain conversions given the request and the original response
 * Also sets the responseXXX fields on the jqXHR instance
 */
function ajaxConvert( s, response, jqXHR, isSuccess ) {
	var conv2, current, conv, tmp, prev,
		converters = {},

		// Work with a copy of dataTypes in case we need to modify it for conversion
		dataTypes = s.dataTypes.slice();

	// Create converters map with lowercased keys
	if ( dataTypes[ 1 ] ) {
		for ( conv in s.converters ) {
			converters[ conv.toLowerCase() ] = s.converters[ conv ];
		}
	}

	current = dataTypes.shift();

	// Convert to each sequential dataType
	while ( current ) {

		if ( s.responseFields[ current ] ) {
			jqXHR[ s.responseFields[ current ] ] = response;
		}

		// Apply the dataFilter if provided
		if ( !prev && isSuccess && s.dataFilter ) {
			response = s.dataFilter( response, s.dataType );
		}

		prev = current;
		current = dataTypes.shift();

		if ( current ) {

			// There's only work to do if current dataType is non-auto
			if ( current === "*" ) {

				current = prev;

			// Convert response if prev dataType is non-auto and differs from current
			} else if ( prev !== "*" && prev !== current ) {

				// Seek a direct converter
				conv = converters[ prev + " " + current ] || converters[ "* " + current ];

				// If none found, seek a pair
				if ( !conv ) {
					for ( conv2 in converters ) {

						// If conv2 outputs current
						tmp = conv2.split( " " );
						if ( tmp[ 1 ] === current ) {

							// If prev can be converted to accepted input
							conv = converters[ prev + " " + tmp[ 0 ] ] ||
								converters[ "* " + tmp[ 0 ] ];
							if ( conv ) {

								// Condense equivalence converters
								if ( conv === true ) {
									conv = converters[ conv2 ];

								// Otherwise, insert the intermediate dataType
								} else if ( converters[ conv2 ] !== true ) {
									current = tmp[ 0 ];
									dataTypes.unshift( tmp[ 1 ] );
								}
								break;
							}
						}
					}
				}

				// Apply converter (if not an equivalence)
				if ( conv !== true ) {

					// Unless errors are allowed to bubble, catch and return them
					if ( conv && s.throws ) {
						response = conv( response );
					} else {
						try {
							response = conv( response );
						} catch ( e ) {
							return {
								state: "parsererror",
								error: conv ? e : "No conversion from " + prev + " to " + current
							};
						}
					}
				}
			}
		}
	}

	return { state: "success", data: response };
}

jQuery.extend( {

	// Counter for holding the number of active queries
	active: 0,

	// Last-Modified header cache for next request
	lastModified: {},
	etag: {},

	ajaxSettings: {
		url: location.href,
		type: "GET",
		isLocal: rlocalProtocol.test( location.protocol ),
		global: true,
		processData: true,
		async: true,
		contentType: "application/x-www-form-urlencoded; charset=UTF-8",

		/*
		timeout: 0,
		data: null,
		dataType: null,
		username: null,
		password: null,
		cache: null,
		throws: false,
		traditional: false,
		headers: {},
		*/

		accepts: {
			"*": allTypes,
			text: "text/plain",
			html: "text/html",
			xml: "application/xml, text/xml",
			json: "application/json, text/javascript"
		},

		contents: {
			xml: /\bxml\b/,
			html: /\bhtml/,
			json: /\bjson\b/
		},

		responseFields: {
			xml: "responseXML",
			text: "responseText",
			json: "responseJSON"
		},

		// Data converters
		// Keys separate source (or catchall "*") and destination types with a single space
		converters: {

			// Convert anything to text
			"* text": String,

			// Text to html (true = no transformation)
			"text html": true,

			// Evaluate text as a json expression
			"text json": JSON.parse,

			// Parse text as xml
			"text xml": jQuery.parseXML
		},

		// For options that shouldn't be deep extended:
		// you can add your own custom options here if
		// and when you create one that shouldn't be
		// deep extended (see ajaxExtend)
		flatOptions: {
			url: true,
			context: true
		}
	},

	// Creates a full fledged settings object into target
	// with both ajaxSettings and settings fields.
	// If target is omitted, writes into ajaxSettings.
	ajaxSetup: function( target, settings ) {
		return settings ?

			// Building a settings object
			ajaxExtend( ajaxExtend( target, jQuery.ajaxSettings ), settings ) :

			// Extending ajaxSettings
			ajaxExtend( jQuery.ajaxSettings, target );
	},

	ajaxPrefilter: addToPrefiltersOrTransports( prefilters ),
	ajaxTransport: addToPrefiltersOrTransports( transports ),

	// Main method
	ajax: function( url, options ) {

		// If url is an object, simulate pre-1.5 signature
		if ( typeof url === "object" ) {
			options = url;
			url = undefined;
		}

		// Force options to be an object
		options = options || {};

		var transport,

			// URL without anti-cache param
			cacheURL,

			// Response headers
			responseHeadersString,
			responseHeaders,

			// timeout handle
			timeoutTimer,

			// Url cleanup var
			urlAnchor,

			// Request state (becomes false upon send and true upon completion)
			completed,

			// To know if global events are to be dispatched
			fireGlobals,

			// Loop variable
			i,

			// uncached part of the url
			uncached,

			// Create the final options object
			s = jQuery.ajaxSetup( {}, options ),

			// Callbacks context
			callbackContext = s.context || s,

			// Context for global events is callbackContext if it is a DOM node or jQuery collection
			globalEventContext = s.context &&
				( callbackContext.nodeType || callbackContext.jquery ) ?
					jQuery( callbackContext ) :
					jQuery.event,

			// Deferreds
			deferred = jQuery.Deferred(),
			completeDeferred = jQuery.Callbacks( "once memory" ),

			// Status-dependent callbacks
			statusCode = s.statusCode || {},

			// Headers (they are sent all at once)
			requestHeaders = {},
			requestHeadersNames = {},

			// Default abort message
			strAbort = "canceled",

			// Fake xhr
			jqXHR = {
				readyState: 0,

				// Builds headers hashtable if needed
				getResponseHeader: function( key ) {
					var match;
					if ( completed ) {
						if ( !responseHeaders ) {
							responseHeaders = {};
							while ( ( match = rheaders.exec( responseHeadersString ) ) ) {
								responseHeaders[ match[ 1 ].toLowerCase() ] = match[ 2 ];
							}
						}
						match = responseHeaders[ key.toLowerCase() ];
					}
					return match == null ? null : match;
				},

				// Raw string
				getAllResponseHeaders: function() {
					return completed ? responseHeadersString : null;
				},

				// Caches the header
				setRequestHeader: function( name, value ) {
					if ( completed == null ) {
						name = requestHeadersNames[ name.toLowerCase() ] =
							requestHeadersNames[ name.toLowerCase() ] || name;
						requestHeaders[ name ] = value;
					}
					return this;
				},

				// Overrides response content-type header
				overrideMimeType: function( type ) {
					if ( completed == null ) {
						s.mimeType = type;
					}
					return this;
				},

				// Status-dependent callbacks
				statusCode: function( map ) {
					var code;
					if ( map ) {
						if ( completed ) {

							// Execute the appropriate callbacks
							jqXHR.always( map[ jqXHR.status ] );
						} else {

							// Lazy-add the new callbacks in a way that preserves old ones
							for ( code in map ) {
								statusCode[ code ] = [ statusCode[ code ], map[ code ] ];
							}
						}
					}
					return this;
				},

				// Cancel the request
				abort: function( statusText ) {
					var finalText = statusText || strAbort;
					if ( transport ) {
						transport.abort( finalText );
					}
					done( 0, finalText );
					return this;
				}
			};

		// Attach deferreds
		deferred.promise( jqXHR );

		// Add protocol if not provided (prefilters might expect it)
		// Handle falsy url in the settings object (#10093: consistency with old signature)
		// We also use the url parameter if available
		s.url = ( ( url || s.url || location.href ) + "" )
			.replace( rprotocol, location.protocol + "//" );

		// Alias method option to type as per ticket #12004
		s.type = options.method || options.type || s.method || s.type;

		// Extract dataTypes list
		s.dataTypes = ( s.dataType || "*" ).toLowerCase().match( rnothtmlwhite ) || [ "" ];

		// A cross-domain request is in order when the origin doesn't match the current origin.
		if ( s.crossDomain == null ) {
			urlAnchor = document.createElement( "a" );

			// Support: IE <=8 - 11, Edge 12 - 15
			// IE throws exception on accessing the href property if url is malformed,
			// e.g. http://example.com:80x/
			try {
				urlAnchor.href = s.url;

				// Support: IE <=8 - 11 only
				// Anchor's host property isn't correctly set when s.url is relative
				urlAnchor.href = urlAnchor.href;
				s.crossDomain = originAnchor.protocol + "//" + originAnchor.host !==
					urlAnchor.protocol + "//" + urlAnchor.host;
			} catch ( e ) {

				// If there is an error parsing the URL, assume it is crossDomain,
				// it can be rejected by the transport if it is invalid
				s.crossDomain = true;
			}
		}

		// Convert data if not already a string
		if ( s.data && s.processData && typeof s.data !== "string" ) {
			s.data = jQuery.param( s.data, s.traditional );
		}

		// Apply prefilters
		inspectPrefiltersOrTransports( prefilters, s, options, jqXHR );

		// If request was aborted inside a prefilter, stop there
		if ( completed ) {
			return jqXHR;
		}

		// We can fire global events as of now if asked to
		// Don't fire events if jQuery.event is undefined in an AMD-usage scenario (#15118)
		fireGlobals = jQuery.event && s.global;

		// Watch for a new set of requests
		if ( fireGlobals && jQuery.active++ === 0 ) {
			jQuery.event.trigger( "ajaxStart" );
		}

		// Uppercase the type
		s.type = s.type.toUpperCase();

		// Determine if request has content
		s.hasContent = !rnoContent.test( s.type );

		// Save the URL in case we're toying with the If-Modified-Since
		// and/or If-None-Match header later on
		// Remove hash to simplify url manipulation
		cacheURL = s.url.replace( rhash, "" );

		// More options handling for requests with no content
		if ( !s.hasContent ) {

			// Remember the hash so we can put it back
			uncached = s.url.slice( cacheURL.length );

			// If data is available and should be processed, append data to url
			if ( s.data && ( s.processData || typeof s.data === "string" ) ) {
				cacheURL += ( rquery.test( cacheURL ) ? "&" : "?" ) + s.data;

				// #9682: remove data so that it's not used in an eventual retry
				delete s.data;
			}

			// Add or update anti-cache param if needed
			if ( s.cache === false ) {
				cacheURL = cacheURL.replace( rantiCache, "$1" );
				uncached = ( rquery.test( cacheURL ) ? "&" : "?" ) + "_=" + ( nonce++ ) + uncached;
			}

			// Put hash and anti-cache on the URL that will be requested (gh-1732)
			s.url = cacheURL + uncached;

		// Change '%20' to '+' if this is encoded form body content (gh-2658)
		} else if ( s.data && s.processData &&
			( s.contentType || "" ).indexOf( "application/x-www-form-urlencoded" ) === 0 ) {
			s.data = s.data.replace( r20, "+" );
		}

		// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
		if ( s.ifModified ) {
			if ( jQuery.lastModified[ cacheURL ] ) {
				jqXHR.setRequestHeader( "If-Modified-Since", jQuery.lastModified[ cacheURL ] );
			}
			if ( jQuery.etag[ cacheURL ] ) {
				jqXHR.setRequestHeader( "If-None-Match", jQuery.etag[ cacheURL ] );
			}
		}

		// Set the correct header, if data is being sent
		if ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {
			jqXHR.setRequestHeader( "Content-Type", s.contentType );
		}

		// Set the Accepts header for the server, depending on the dataType
		jqXHR.setRequestHeader(
			"Accept",
			s.dataTypes[ 0 ] && s.accepts[ s.dataTypes[ 0 ] ] ?
				s.accepts[ s.dataTypes[ 0 ] ] +
					( s.dataTypes[ 0 ] !== "*" ? ", " + allTypes + "; q=0.01" : "" ) :
				s.accepts[ "*" ]
		);

		// Check for headers option
		for ( i in s.headers ) {
			jqXHR.setRequestHeader( i, s.headers[ i ] );
		}

		// Allow custom headers/mimetypes and early abort
		if ( s.beforeSend &&
			( s.beforeSend.call( callbackContext, jqXHR, s ) === false || completed ) ) {

			// Abort if not done already and return
			return jqXHR.abort();
		}

		// Aborting is no longer a cancellation
		strAbort = "abort";

		// Install callbacks on deferreds
		completeDeferred.add( s.complete );
		jqXHR.done( s.success );
		jqXHR.fail( s.error );

		// Get transport
		transport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );

		// If no transport, we auto-abort
		if ( !transport ) {
			done( -1, "No Transport" );
		} else {
			jqXHR.readyState = 1;

			// Send global event
			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxSend", [ jqXHR, s ] );
			}

			// If request was aborted inside ajaxSend, stop there
			if ( completed ) {
				return jqXHR;
			}

			// Timeout
			if ( s.async && s.timeout > 0 ) {
				timeoutTimer = window.setTimeout( function() {
					jqXHR.abort( "timeout" );
				}, s.timeout );
			}

			try {
				completed = false;
				transport.send( requestHeaders, done );
			} catch ( e ) {

				// Rethrow post-completion exceptions
				if ( completed ) {
					throw e;
				}

				// Propagate others as results
				done( -1, e );
			}
		}

		// Callback for when everything is done
		function done( status, nativeStatusText, responses, headers ) {
			var isSuccess, success, error, response, modified,
				statusText = nativeStatusText;

			// Ignore repeat invocations
			if ( completed ) {
				return;
			}

			completed = true;

			// Clear timeout if it exists
			if ( timeoutTimer ) {
				window.clearTimeout( timeoutTimer );
			}

			// Dereference transport for early garbage collection
			// (no matter how long the jqXHR object will be used)
			transport = undefined;

			// Cache response headers
			responseHeadersString = headers || "";

			// Set readyState
			jqXHR.readyState = status > 0 ? 4 : 0;

			// Determine if successful
			isSuccess = status >= 200 && status < 300 || status === 304;

			// Get response data
			if ( responses ) {
				response = ajaxHandleResponses( s, jqXHR, responses );
			}

			// Convert no matter what (that way responseXXX fields are always set)
			response = ajaxConvert( s, response, jqXHR, isSuccess );

			// If successful, handle type chaining
			if ( isSuccess ) {

				// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
				if ( s.ifModified ) {
					modified = jqXHR.getResponseHeader( "Last-Modified" );
					if ( modified ) {
						jQuery.lastModified[ cacheURL ] = modified;
					}
					modified = jqXHR.getResponseHeader( "etag" );
					if ( modified ) {
						jQuery.etag[ cacheURL ] = modified;
					}
				}

				// if no content
				if ( status === 204 || s.type === "HEAD" ) {
					statusText = "nocontent";

				// if not modified
				} else if ( status === 304 ) {
					statusText = "notmodified";

				// If we have data, let's convert it
				} else {
					statusText = response.state;
					success = response.data;
					error = response.error;
					isSuccess = !error;
				}
			} else {

				// Extract error from statusText and normalize for non-aborts
				error = statusText;
				if ( status || !statusText ) {
					statusText = "error";
					if ( status < 0 ) {
						status = 0;
					}
				}
			}

			// Set data for the fake xhr object
			jqXHR.status = status;
			jqXHR.statusText = ( nativeStatusText || statusText ) + "";

			// Success/Error
			if ( isSuccess ) {
				deferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );
			} else {
				deferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );
			}

			// Status-dependent callbacks
			jqXHR.statusCode( statusCode );
			statusCode = undefined;

			if ( fireGlobals ) {
				globalEventContext.trigger( isSuccess ? "ajaxSuccess" : "ajaxError",
					[ jqXHR, s, isSuccess ? success : error ] );
			}

			// Complete
			completeDeferred.fireWith( callbackContext, [ jqXHR, statusText ] );

			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxComplete", [ jqXHR, s ] );

				// Handle the global AJAX counter
				if ( !( --jQuery.active ) ) {
					jQuery.event.trigger( "ajaxStop" );
				}
			}
		}

		return jqXHR;
	},

	getJSON: function( url, data, callback ) {
		return jQuery.get( url, data, callback, "json" );
	},

	getScript: function( url, callback ) {
		return jQuery.get( url, undefined, callback, "script" );
	}
} );

jQuery.each( [ "get", "post" ], function( i, method ) {
	jQuery[ method ] = function( url, data, callback, type ) {

		// Shift arguments if data argument was omitted
		if ( isFunction( data ) ) {
			type = type || callback;
			callback = data;
			data = undefined;
		}

		// The url can be an options object (which then must have .url)
		return jQuery.ajax( jQuery.extend( {
			url: url,
			type: method,
			dataType: type,
			data: data,
			success: callback
		}, jQuery.isPlainObject( url ) && url ) );
	};
} );


jQuery._evalUrl = function( url ) {
	return jQuery.ajax( {
		url: url,

		// Make this explicit, since user can override this through ajaxSetup (#11264)
		type: "GET",
		dataType: "script",
		cache: true,
		async: false,
		global: false,
		"throws": true
	} );
};


jQuery.fn.extend( {
	wrapAll: function( html ) {
		var wrap;

		if ( this[ 0 ] ) {
			if ( isFunction( html ) ) {
				html = html.call( this[ 0 ] );
			}

			// The elements to wrap the target around
			wrap = jQuery( html, this[ 0 ].ownerDocument ).eq( 0 ).clone( true );

			if ( this[ 0 ].parentNode ) {
				wrap.insertBefore( this[ 0 ] );
			}

			wrap.map( function() {
				var elem = this;

				while ( elem.firstElementChild ) {
					elem = elem.firstElementChild;
				}

				return elem;
			} ).append( this );
		}

		return this;
	},

	wrapInner: function( html ) {
		if ( isFunction( html ) ) {
			return this.each( function( i ) {
				jQuery( this ).wrapInner( html.call( this, i ) );
			} );
		}

		return this.each( function() {
			var self = jQuery( this ),
				contents = self.contents();

			if ( contents.length ) {
				contents.wrapAll( html );

			} else {
				self.append( html );
			}
		} );
	},

	wrap: function( html ) {
		var htmlIsFunction = isFunction( html );

		return this.each( function( i ) {
			jQuery( this ).wrapAll( htmlIsFunction ? html.call( this, i ) : html );
		} );
	},

	unwrap: function( selector ) {
		this.parent( selector ).not( "body" ).each( function() {
			jQuery( this ).replaceWith( this.childNodes );
		} );
		return this;
	}
} );


jQuery.expr.pseudos.hidden = function( elem ) {
	return !jQuery.expr.pseudos.visible( elem );
};
jQuery.expr.pseudos.visible = function( elem ) {
	return !!( elem.offsetWidth || elem.offsetHeight || elem.getClientRects().length );
};




jQuery.ajaxSettings.xhr = function() {
	try {
		return new window.XMLHttpRequest();
	} catch ( e ) {}
};

var xhrSuccessStatus = {

		// File protocol always yields status code 0, assume 200
		0: 200,

		// Support: IE <=9 only
		// #1450: sometimes IE returns 1223 when it should be 204
		1223: 204
	},
	xhrSupported = jQuery.ajaxSettings.xhr();

support.cors = !!xhrSupported && ( "withCredentials" in xhrSupported );
support.ajax = xhrSupported = !!xhrSupported;

jQuery.ajaxTransport( function( options ) {
	var callback, errorCallback;

	// Cross domain only allowed if supported through XMLHttpRequest
	if ( support.cors || xhrSupported && !options.crossDomain ) {
		return {
			send: function( headers, complete ) {
				var i,
					xhr = options.xhr();

				xhr.open(
					options.type,
					options.url,
					options.async,
					options.username,
					options.password
				);

				// Apply custom fields if provided
				if ( options.xhrFields ) {
					for ( i in options.xhrFields ) {
						xhr[ i ] = options.xhrFields[ i ];
					}
				}

				// Override mime type if needed
				if ( options.mimeType && xhr.overrideMimeType ) {
					xhr.overrideMimeType( options.mimeType );
				}

				// X-Requested-With header
				// For cross-domain requests, seeing as conditions for a preflight are
				// akin to a jigsaw puzzle, we simply never set it to be sure.
				// (it can always be set on a per-request basis or even using ajaxSetup)
				// For same-domain requests, won't change header if already provided.
				if ( !options.crossDomain && !headers[ "X-Requested-With" ] ) {
					headers[ "X-Requested-With" ] = "XMLHttpRequest";
				}

				// Set headers
				for ( i in headers ) {
					xhr.setRequestHeader( i, headers[ i ] );
				}

				// Callback
				callback = function( type ) {
					return function() {
						if ( callback ) {
							callback = errorCallback = xhr.onload =
								xhr.onerror = xhr.onabort = xhr.ontimeout =
									xhr.onreadystatechange = null;

							if ( type === "abort" ) {
								xhr.abort();
							} else if ( type === "error" ) {

								// Support: IE <=9 only
								// On a manual native abort, IE9 throws
								// errors on any property access that is not readyState
								if ( typeof xhr.status !== "number" ) {
									complete( 0, "error" );
								} else {
									complete(

										// File: protocol always yields status 0; see #8605, #14207
										xhr.status,
										xhr.statusText
									);
								}
							} else {
								complete(
									xhrSuccessStatus[ xhr.status ] || xhr.status,
									xhr.statusText,

									// Support: IE <=9 only
									// IE9 has no XHR2 but throws on binary (trac-11426)
									// For XHR2 non-text, let the caller handle it (gh-2498)
									( xhr.responseType || "text" ) !== "text"  ||
									typeof xhr.responseText !== "string" ?
										{ binary: xhr.response } :
										{ text: xhr.responseText },
									xhr.getAllResponseHeaders()
								);
							}
						}
					};
				};

				// Listen to events
				xhr.onload = callback();
				errorCallback = xhr.onerror = xhr.ontimeout = callback( "error" );

				// Support: IE 9 only
				// Use onreadystatechange to replace onabort
				// to handle uncaught aborts
				if ( xhr.onabort !== undefined ) {
					xhr.onabort = errorCallback;
				} else {
					xhr.onreadystatechange = function() {

						// Check readyState before timeout as it changes
						if ( xhr.readyState === 4 ) {

							// Allow onerror to be called first,
							// but that will not handle a native abort
							// Also, save errorCallback to a variable
							// as xhr.onerror cannot be accessed
							window.setTimeout( function() {
								if ( callback ) {
									errorCallback();
								}
							} );
						}
					};
				}

				// Create the abort callback
				callback = callback( "abort" );

				try {

					// Do send the request (this may raise an exception)
					xhr.send( options.hasContent && options.data || null );
				} catch ( e ) {

					// #14683: Only rethrow if this hasn't been notified as an error yet
					if ( callback ) {
						throw e;
					}
				}
			},

			abort: function() {
				if ( callback ) {
					callback();
				}
			}
		};
	}
} );




// Prevent auto-execution of scripts when no explicit dataType was provided (See gh-2432)
jQuery.ajaxPrefilter( function( s ) {
	if ( s.crossDomain ) {
		s.contents.script = false;
	}
} );

// Install script dataType
jQuery.ajaxSetup( {
	accepts: {
		script: "text/javascript, application/javascript, " +
			"application/ecmascript, application/x-ecmascript"
	},
	contents: {
		script: /\b(?:java|ecma)script\b/
	},
	converters: {
		"text script": function( text ) {
			jQuery.globalEval( text );
			return text;
		}
	}
} );

// Handle cache's special case and crossDomain
jQuery.ajaxPrefilter( "script", function( s ) {
	if ( s.cache === undefined ) {
		s.cache = false;
	}
	if ( s.crossDomain ) {
		s.type = "GET";
	}
} );

// Bind script tag hack transport
jQuery.ajaxTransport( "script", function( s ) {

	// This transport only deals with cross domain requests
	if ( s.crossDomain ) {
		var script, callback;
		return {
			send: function( _, complete ) {
				script = jQuery( "<script>" ).prop( {
					charset: s.scriptCharset,
					src: s.url
				} ).on(
					"load error",
					callback = function( evt ) {
						script.remove();
						callback = null;
						if ( evt ) {
							complete( evt.type === "error" ? 404 : 200, evt.type );
						}
					}
				);

				// Use native DOM manipulation to avoid our domManip AJAX trickery
				document.head.appendChild( script[ 0 ] );
			},
			abort: function() {
				if ( callback ) {
					callback();
				}
			}
		};
	}
} );




var oldCallbacks = [],
	rjsonp = /(=)\?(?=&|$)|\?\?/;

// Default jsonp settings
jQuery.ajaxSetup( {
	jsonp: "callback",
	jsonpCallback: function() {
		var callback = oldCallbacks.pop() || ( jQuery.expando + "_" + ( nonce++ ) );
		this[ callback ] = true;
		return callback;
	}
} );

// Detect, normalize options and install callbacks for jsonp requests
jQuery.ajaxPrefilter( "json jsonp", function( s, originalSettings, jqXHR ) {

	var callbackName, overwritten, responseContainer,
		jsonProp = s.jsonp !== false && ( rjsonp.test( s.url ) ?
			"url" :
			typeof s.data === "string" &&
				( s.contentType || "" )
					.indexOf( "application/x-www-form-urlencoded" ) === 0 &&
				rjsonp.test( s.data ) && "data"
		);

	// Handle iff the expected data type is "jsonp" or we have a parameter to set
	if ( jsonProp || s.dataTypes[ 0 ] === "jsonp" ) {

		// Get callback name, remembering preexisting value associated with it
		callbackName = s.jsonpCallback = isFunction( s.jsonpCallback ) ?
			s.jsonpCallback() :
			s.jsonpCallback;

		// Insert callback into url or form data
		if ( jsonProp ) {
			s[ jsonProp ] = s[ jsonProp ].replace( rjsonp, "$1" + callbackName );
		} else if ( s.jsonp !== false ) {
			s.url += ( rquery.test( s.url ) ? "&" : "?" ) + s.jsonp + "=" + callbackName;
		}

		// Use data converter to retrieve json after script execution
		s.converters[ "script json" ] = function() {
			if ( !responseContainer ) {
				jQuery.error( callbackName + " was not called" );
			}
			return responseContainer[ 0 ];
		};

		// Force json dataType
		s.dataTypes[ 0 ] = "json";

		// Install callback
		overwritten = window[ callbackName ];
		window[ callbackName ] = function() {
			responseContainer = arguments;
		};

		// Clean-up function (fires after converters)
		jqXHR.always( function() {

			// If previous value didn't exist - remove it
			if ( overwritten === undefined ) {
				jQuery( window ).removeProp( callbackName );

			// Otherwise restore preexisting value
			} else {
				window[ callbackName ] = overwritten;
			}

			// Save back as free
			if ( s[ callbackName ] ) {

				// Make sure that re-using the options doesn't screw things around
				s.jsonpCallback = originalSettings.jsonpCallback;

				// Save the callback name for future use
				oldCallbacks.push( callbackName );
			}

			// Call if it was a function and we have a response
			if ( responseContainer && isFunction( overwritten ) ) {
				overwritten( responseContainer[ 0 ] );
			}

			responseContainer = overwritten = undefined;
		} );

		// Delegate to script
		return "script";
	}
} );




// Support: Safari 8 only
// In Safari 8 documents created via document.implementation.createHTMLDocument
// collapse sibling forms: the second one becomes a child of the first one.
// Because of that, this security measure has to be disabled in Safari 8.
// https://bugs.webkit.org/show_bug.cgi?id=137337
support.createHTMLDocument = ( function() {
	var body = document.implementation.createHTMLDocument( "" ).body;
	body.innerHTML = "<form></form><form></form>";
	return body.childNodes.length === 2;
} )();


// Argument "data" should be string of html
// context (optional): If specified, the fragment will be created in this context,
// defaults to document
// keepScripts (optional): If true, will include scripts passed in the html string
jQuery.parseHTML = function( data, context, keepScripts ) {
	if ( typeof data !== "string" ) {
		return [];
	}
	if ( typeof context === "boolean" ) {
		keepScripts = context;
		context = false;
	}

	var base, parsed, scripts;

	if ( !context ) {

		// Stop scripts or inline event handlers from being executed immediately
		// by using document.implementation
		if ( support.createHTMLDocument ) {
			context = document.implementation.createHTMLDocument( "" );

			// Set the base href for the created document
			// so any parsed elements with URLs
			// are based on the document's URL (gh-2965)
			base = context.createElement( "base" );
			base.href = document.location.href;
			context.head.appendChild( base );
		} else {
			context = document;
		}
	}

	parsed = rsingleTag.exec( data );
	scripts = !keepScripts && [];

	// Single tag
	if ( parsed ) {
		return [ context.createElement( parsed[ 1 ] ) ];
	}

	parsed = buildFragment( [ data ], context, scripts );

	if ( scripts && scripts.length ) {
		jQuery( scripts ).remove();
	}

	return jQuery.merge( [], parsed.childNodes );
};


/**
 * Load a url into a page
 */
jQuery.fn.load = function( url, params, callback ) {
	var selector, type, response,
		self = this,
		off = url.indexOf( " " );

	if ( off > -1 ) {
		selector = stripAndCollapse( url.slice( off ) );
		url = url.slice( 0, off );
	}

	// If it's a function
	if ( isFunction( params ) ) {

		// We assume that it's the callback
		callback = params;
		params = undefined;

	// Otherwise, build a param string
	} else if ( params && typeof params === "object" ) {
		type = "POST";
	}

	// If we have elements to modify, make the request
	if ( self.length > 0 ) {
		jQuery.ajax( {
			url: url,

			// If "type" variable is undefined, then "GET" method will be used.
			// Make value of this field explicit since
			// user can override it through ajaxSetup method
			type: type || "GET",
			dataType: "html",
			data: params
		} ).done( function( responseText ) {

			// Save response for use in complete callback
			response = arguments;

			self.html( selector ?

				// If a selector was specified, locate the right elements in a dummy div
				// Exclude scripts to avoid IE 'Permission Denied' errors
				jQuery( "<div>" ).append( jQuery.parseHTML( responseText ) ).find( selector ) :

				// Otherwise use the full result
				responseText );

		// If the request succeeds, this function gets "data", "status", "jqXHR"
		// but they are ignored because response was set above.
		// If it fails, this function gets "jqXHR", "status", "error"
		} ).always( callback && function( jqXHR, status ) {
			self.each( function() {
				callback.apply( this, response || [ jqXHR.responseText, status, jqXHR ] );
			} );
		} );
	}

	return this;
};




// Attach a bunch of functions for handling common AJAX events
jQuery.each( [
	"ajaxStart",
	"ajaxStop",
	"ajaxComplete",
	"ajaxError",
	"ajaxSuccess",
	"ajaxSend"
], function( i, type ) {
	jQuery.fn[ type ] = function( fn ) {
		return this.on( type, fn );
	};
} );




jQuery.expr.pseudos.animated = function( elem ) {
	return jQuery.grep( jQuery.timers, function( fn ) {
		return elem === fn.elem;
	} ).length;
};




jQuery.offset = {
	setOffset: function( elem, options, i ) {
		var curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition,
			position = jQuery.css( elem, "position" ),
			curElem = jQuery( elem ),
			props = {};

		// Set position first, in-case top/left are set even on static elem
		if ( position === "static" ) {
			elem.style.position = "relative";
		}

		curOffset = curElem.offset();
		curCSSTop = jQuery.css( elem, "top" );
		curCSSLeft = jQuery.css( elem, "left" );
		calculatePosition = ( position === "absolute" || position === "fixed" ) &&
			( curCSSTop + curCSSLeft ).indexOf( "auto" ) > -1;

		// Need to be able to calculate position if either
		// top or left is auto and position is either absolute or fixed
		if ( calculatePosition ) {
			curPosition = curElem.position();
			curTop = curPosition.top;
			curLeft = curPosition.left;

		} else {
			curTop = parseFloat( curCSSTop ) || 0;
			curLeft = parseFloat( curCSSLeft ) || 0;
		}

		if ( isFunction( options ) ) {

			// Use jQuery.extend here to allow modification of coordinates argument (gh-1848)
			options = options.call( elem, i, jQuery.extend( {}, curOffset ) );
		}

		if ( options.top != null ) {
			props.top = ( options.top - curOffset.top ) + curTop;
		}
		if ( options.left != null ) {
			props.left = ( options.left - curOffset.left ) + curLeft;
		}

		if ( "using" in options ) {
			options.using.call( elem, props );

		} else {
			curElem.css( props );
		}
	}
};

jQuery.fn.extend( {

	// offset() relates an element's border box to the document origin
	offset: function( options ) {

		// Preserve chaining for setter
		if ( arguments.length ) {
			return options === undefined ?
				this :
				this.each( function( i ) {
					jQuery.offset.setOffset( this, options, i );
				} );
		}

		var rect, win,
			elem = this[ 0 ];

		if ( !elem ) {
			return;
		}

		// Return zeros for disconnected and hidden (display: none) elements (gh-2310)
		// Support: IE <=11 only
		// Running getBoundingClientRect on a
		// disconnected node in IE throws an error
		if ( !elem.getClientRects().length ) {
			return { top: 0, left: 0 };
		}

		// Get document-relative position by adding viewport scroll to viewport-relative gBCR
		rect = elem.getBoundingClientRect();
		win = elem.ownerDocument.defaultView;
		return {
			top: rect.top + win.pageYOffset,
			left: rect.left + win.pageXOffset
		};
	},

	// position() relates an element's margin box to its offset parent's padding box
	// This corresponds to the behavior of CSS absolute positioning
	position: function() {
		if ( !this[ 0 ] ) {
			return;
		}

		var offsetParent, offset, doc,
			elem = this[ 0 ],
			parentOffset = { top: 0, left: 0 };

		// position:fixed elements are offset from the viewport, which itself always has zero offset
		if ( jQuery.css( elem, "position" ) === "fixed" ) {

			// Assume position:fixed implies availability of getBoundingClientRect
			offset = elem.getBoundingClientRect();

		} else {
			offset = this.offset();

			// Account for the *real* offset parent, which can be the document or its root element
			// when a statically positioned element is identified
			doc = elem.ownerDocument;
			offsetParent = elem.offsetParent || doc.documentElement;
			while ( offsetParent &&
				( offsetParent === doc.body || offsetParent === doc.documentElement ) &&
				jQuery.css( offsetParent, "position" ) === "static" ) {

				offsetParent = offsetParent.parentNode;
			}
			if ( offsetParent && offsetParent !== elem && offsetParent.nodeType === 1 ) {

				// Incorporate borders into its offset, since they are outside its content origin
				parentOffset = jQuery( offsetParent ).offset();
				parentOffset.top += jQuery.css( offsetParent, "borderTopWidth", true );
				parentOffset.left += jQuery.css( offsetParent, "borderLeftWidth", true );
			}
		}

		// Subtract parent offsets and element margins
		return {
			top: offset.top - parentOffset.top - jQuery.css( elem, "marginTop", true ),
			left: offset.left - parentOffset.left - jQuery.css( elem, "marginLeft", true )
		};
	},

	// This method will return documentElement in the following cases:
	// 1) For the element inside the iframe without offsetParent, this method will return
	//    documentElement of the parent window
	// 2) For the hidden or detached element
	// 3) For body or html element, i.e. in case of the html node - it will return itself
	//
	// but those exceptions were never presented as a real life use-cases
	// and might be considered as more preferable results.
	//
	// This logic, however, is not guaranteed and can change at any point in the future
	offsetParent: function() {
		return this.map( function() {
			var offsetParent = this.offsetParent;

			while ( offsetParent && jQuery.css( offsetParent, "position" ) === "static" ) {
				offsetParent = offsetParent.offsetParent;
			}

			return offsetParent || documentElement;
		} );
	}
} );

// Create scrollLeft and scrollTop methods
jQuery.each( { scrollLeft: "pageXOffset", scrollTop: "pageYOffset" }, function( method, prop ) {
	var top = "pageYOffset" === prop;

	jQuery.fn[ method ] = function( val ) {
		return access( this, function( elem, method, val ) {

			// Coalesce documents and windows
			var win;
			if ( isWindow( elem ) ) {
				win = elem;
			} else if ( elem.nodeType === 9 ) {
				win = elem.defaultView;
			}

			if ( val === undefined ) {
				return win ? win[ prop ] : elem[ method ];
			}

			if ( win ) {
				win.scrollTo(
					!top ? val : win.pageXOffset,
					top ? val : win.pageYOffset
				);

			} else {
				elem[ method ] = val;
			}
		}, method, val, arguments.length );
	};
} );

// Support: Safari <=7 - 9.1, Chrome <=37 - 49
// Add the top/left cssHooks using jQuery.fn.position
// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
// Blink bug: https://bugs.chromium.org/p/chromium/issues/detail?id=589347
// getComputedStyle returns percent when specified for top/left/bottom/right;
// rather than make the css module depend on the offset module, just check for it here
jQuery.each( [ "top", "left" ], function( i, prop ) {
	jQuery.cssHooks[ prop ] = addGetHookIf( support.pixelPosition,
		function( elem, computed ) {
			if ( computed ) {
				computed = curCSS( elem, prop );

				// If curCSS returns percentage, fallback to offset
				return rnumnonpx.test( computed ) ?
					jQuery( elem ).position()[ prop ] + "px" :
					computed;
			}
		}
	);
} );


// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods
jQuery.each( { Height: "height", Width: "width" }, function( name, type ) {
	jQuery.each( { padding: "inner" + name, content: type, "": "outer" + name },
		function( defaultExtra, funcName ) {

		// Margin is only for outerHeight, outerWidth
		jQuery.fn[ funcName ] = function( margin, value ) {
			var chainable = arguments.length && ( defaultExtra || typeof margin !== "boolean" ),
				extra = defaultExtra || ( margin === true || value === true ? "margin" : "border" );

			return access( this, function( elem, type, value ) {
				var doc;

				if ( isWindow( elem ) ) {

					// $( window ).outerWidth/Height return w/h including scrollbars (gh-1729)
					return funcName.indexOf( "outer" ) === 0 ?
						elem[ "inner" + name ] :
						elem.document.documentElement[ "client" + name ];
				}

				// Get document width or height
				if ( elem.nodeType === 9 ) {
					doc = elem.documentElement;

					// Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height],
					// whichever is greatest
					return Math.max(
						elem.body[ "scroll" + name ], doc[ "scroll" + name ],
						elem.body[ "offset" + name ], doc[ "offset" + name ],
						doc[ "client" + name ]
					);
				}

				return value === undefined ?

					// Get width or height on the element, requesting but not forcing parseFloat
					jQuery.css( elem, type, extra ) :

					// Set width or height on the element
					jQuery.style( elem, type, value, extra );
			}, type, chainable ? margin : undefined, chainable );
		};
	} );
} );


jQuery.each( ( "blur focus focusin focusout resize scroll click dblclick " +
	"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " +
	"change select submit keydown keypress keyup contextmenu" ).split( " " ),
	function( i, name ) {

	// Handle event binding
	jQuery.fn[ name ] = function( data, fn ) {
		return arguments.length > 0 ?
			this.on( name, null, data, fn ) :
			this.trigger( name );
	};
} );

jQuery.fn.extend( {
	hover: function( fnOver, fnOut ) {
		return this.mouseenter( fnOver ).mouseleave( fnOut || fnOver );
	}
} );




jQuery.fn.extend( {

	bind: function( types, data, fn ) {
		return this.on( types, null, data, fn );
	},
	unbind: function( types, fn ) {
		return this.off( types, null, fn );
	},

	delegate: function( selector, types, data, fn ) {
		return this.on( types, selector, data, fn );
	},
	undelegate: function( selector, types, fn ) {

		// ( namespace ) or ( selector, types [, fn] )
		return arguments.length === 1 ?
			this.off( selector, "**" ) :
			this.off( types, selector || "**", fn );
	}
} );

// Bind a function to a context, optionally partially applying any
// arguments.
// jQuery.proxy is deprecated to promote standards (specifically Function#bind)
// However, it is not slated for removal any time soon
jQuery.proxy = function( fn, context ) {
	var tmp, args, proxy;

	if ( typeof context === "string" ) {
		tmp = fn[ context ];
		context = fn;
		fn = tmp;
	}

	// Quick check to determine if target is callable, in the spec
	// this throws a TypeError, but we will just return undefined.
	if ( !isFunction( fn ) ) {
		return undefined;
	}

	// Simulated bind
	args = slice.call( arguments, 2 );
	proxy = function() {
		return fn.apply( context || this, args.concat( slice.call( arguments ) ) );
	};

	// Set the guid of unique handler to the same of original handler, so it can be removed
	proxy.guid = fn.guid = fn.guid || jQuery.guid++;

	return proxy;
};

jQuery.holdReady = function( hold ) {
	if ( hold ) {
		jQuery.readyWait++;
	} else {
		jQuery.ready( true );
	}
};
jQuery.isArray = Array.isArray;
jQuery.parseJSON = JSON.parse;
jQuery.nodeName = nodeName;
jQuery.isFunction = isFunction;
jQuery.isWindow = isWindow;
jQuery.camelCase = camelCase;
jQuery.type = toType;

jQuery.now = Date.now;

jQuery.isNumeric = function( obj ) {

	// As of jQuery 3.0, isNumeric is limited to
	// strings and numbers (primitives or objects)
	// that can be coerced to finite numbers (gh-2662)
	var type = jQuery.type( obj );
	return ( type === "number" || type === "string" ) &&

		// parseFloat NaNs numeric-cast false positives ("")
		// ...but misinterprets leading-number strings, particularly hex literals ("0x...")
		// subtraction forces infinities to NaN
		!isNaN( obj - parseFloat( obj ) );
};




// Register as a named AMD module, since jQuery can be concatenated with other
// files that may use define, but not via a proper concatenation script that
// understands anonymous AMD modules. A named AMD is safest and most robust
// way to register. Lowercase jquery is used because AMD module names are
// derived from file names, and jQuery is normally delivered in a lowercase
// file name. Do this after creating the global so that if an AMD module wants
// to call noConflict to hide this version of jQuery, it will work.

// Note that for maximum portability, libraries that are not jQuery should
// declare themselves as anonymous modules, and avoid setting a global if an
// AMD loader is present. jQuery is a special case. For more information, see
// https://github.com/jrburke/requirejs/wiki/Updating-existing-libraries#wiki-anon

if ( true ) {
	!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function() {
		return jQuery;
	}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
}




var

	// Map over jQuery in case of overwrite
	_jQuery = window.jQuery,

	// Map over the $ in case of overwrite
	_$ = window.$;

jQuery.noConflict = function( deep ) {
	if ( window.$ === jQuery ) {
		window.$ = _$;
	}

	if ( deep && window.jQuery === jQuery ) {
		window.jQuery = _jQuery;
	}

	return jQuery;
};

// Expose jQuery and $ identifiers, even in AMD
// (#7102#comment:10, https://github.com/jquery/jquery/pull/557)
// and CommonJS for browser emulators (#13566)
if ( !noGlobal ) {
	window.jQuery = window.$ = jQuery;
}




return jQuery;
} );


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($) {

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _helpers = __webpack_require__(4);

var _helpers2 = _interopRequireDefault(_helpers);

var _jqueryTranslate = __webpack_require__(38);

var _jqueryTranslate2 = _interopRequireDefault(_jqueryTranslate);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var instance = null;

var Help_translate_class = function () {
	function Help_translate_class() {
		_classCallCheck(this, Help_translate_class);

		//singleton
		if (instance) {
			return instance;
		}
		instance = this;

		this.Helper = new _helpers2.default();
		this.translations = {};

		this.load_translations();
	}

	//change language


	_createClass(Help_translate_class, [{
		key: 'translate',
		value: function translate(lang_code) {
			if (lang_code == undefined) {
				lang_code = this.Helper.getCookie('language');
				if (!lang_code) {
					return;
				}
			}

			if (lang_code != undefined && lang_code != _config2.default.LANG) {
				//save cookie
				this.Helper.setCookie('language', lang_code);
			}

			var first = this.translations[Object.keys(this.translations)[0]];

			if (first[lang_code] != undefined || lang_code == 'en') {
				//translate
				$('body').translate({ lang: lang_code, t: this.translations });
				_config2.default.LANG = lang_code;
			} else {
				_alertifyMin2.default.error('Translate error, can not find dictionary: ' + lang_code);
			}
		}
	}, {
		key: 'load_translations',
		value: function load_translations() {
			var _this = this;
			var modules_context = __webpack_require__(39);
			modules_context.keys().forEach(function (key) {
				if (key.indexOf('Base' + '/') < 0 && key.indexOf('empty') < 0) {
					var moduleKey = key.replace('./', '').replace('.json', '');
					var classObj = modules_context(key);

					for (var i in classObj) {
						if (_this.translations[i] == undefined) {
							_this.translations[i] = {
								en: i
							};
						}
						_this.translations[i][moduleKey] = classObj[i];
					}
				}
			});
		}
	}]);

	return Help_translate_class;
}();

exports.default = Help_translate_class;
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(14)))

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseGui = __webpack_require__(7);

var _baseGui2 = _interopRequireDefault(_baseGui);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _popup = __webpack_require__(3);

var _popup2 = _interopRequireDefault(_popup);

var _helpers = __webpack_require__(4);

var _helpers2 = _interopRequireDefault(_helpers);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var instance = null;

var Image_trim_class = function () {
	function Image_trim_class() {
		_classCallCheck(this, Image_trim_class);

		//singleton
		if (instance) {
			return instance;
		}
		instance = this;

		this.Base_layers = new _baseLayers2.default();
		this.Base_gui = new _baseGui2.default();
		this.Helper = new _helpers2.default();
		this.Dialog = new _popup2.default();

		this.set_events();
	}

	_createClass(Image_trim_class, [{
		key: 'set_events',
		value: function set_events() {
			var _this = this;

			document.addEventListener('keydown', function (event) {
				var code = event.keyCode;
				if (event.target.type == 'text' || event.target.tagName == 'INPUT' || event.target.type == 'textarea') return;

				if (code == 84) {
					//trim
					_this.trim();
					event.preventDefault();
				}
			}, false);
		}
	}, {
		key: 'trim',
		value: function trim() {
			var _this = this;

			var removeWhiteColor = false;
			if (_config2.default.TRANSPARENCY == false) removeWhiteColor = true;

			var settings = {
				title: 'Trim',
				params: [{ name: "trim_all", title: "Trim everything:", value: true }, { name: "trim_layer", title: "Trim layer:", value: true }, {}, //gap
				{ name: "remove_white", title: "Trim white color?", value: removeWhiteColor }],
				on_finish: function on_finish(params) {
					window.State.save();
					if (params.trim_layer == true) _this.trim_layer(_config2.default.layer.id, params.remove_white);
					if (params.trim_all == true) _this.trim_all(params.remove_white);
				}
			};
			this.Dialog.show(settings);
		}
	}, {
		key: 'trim_layer',
		value: function trim_layer(layer_id) {
			var removeWhiteColor = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

			var layer = this.Base_layers.get_layer(layer_id);

			if (_config2.default.layer.type != 'image') {
				_alertifyMin2.default.error('Skip - layer must be image.');
				return false;
			}

			var trim = this.get_trim_info(layer_id, removeWhiteColor);
			trim = trim.relative;

			if (layer.type == 'image') {
				//if image was streched
				var width_ratio = layer.width / layer.width_original;
				var height_ratio = layer.height / layer.height_original;

				//create smaller canvas
				var canvas = document.createElement('canvas');
				var ctx = canvas.getContext("2d");
				canvas.width = trim.width / width_ratio;
				canvas.height = trim.height / height_ratio;

				//cut required part
				ctx.translate(-trim.left / width_ratio, -trim.top / height_ratio);
				canvas.getContext("2d").drawImage(layer.link, 0, 0);
				ctx.translate(0, 0);
				this.Base_layers.update_layer_image(canvas, layer.id);

				//update attributes
				layer.width = Math.ceil(canvas.width * width_ratio);
				layer.height = Math.ceil(canvas.height * height_ratio);
				layer.x += trim.left;
				layer.y += trim.top;
				layer.width_original = canvas.width;
				layer.height_original = canvas.height;
			}

			_config2.default.need_render = true;
		}
	}, {
		key: 'trim_all',
		value: function trim_all() {
			var removeWhiteColor = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

			var all_top = _config2.default.HEIGHT;
			var all_left = _config2.default.WIDTH;
			var all_bottom = _config2.default.HEIGHT;
			var all_right = _config2.default.WIDTH;

			if (removeWhiteColor == undefined) {
				removeWhiteColor = false;
				if (_config2.default.TRANSPARENCY == false) {
					removeWhiteColor = true;
				}
			}

			//collect info
			for (var i = 0; i < _config2.default.layers.length; i++) {
				var layer = _config2.default.layers[i];

				if (layer.width == null || layer.height == null || layer.x == null || layer.y == null) {
					//layer without dimensions
					var trim_info = this.get_trim_info(layer.id, removeWhiteColor);

					all_top = Math.min(all_top, trim_info.top);
					all_left = Math.min(all_left, trim_info.left);
					all_bottom = Math.min(all_bottom, trim_info.bottom);
					all_right = Math.min(all_right, trim_info.right);
				} else {
					all_top = Math.min(all_top, layer.y);
					all_left = Math.min(all_left, layer.x);
					all_bottom = Math.min(all_bottom, _config2.default.HEIGHT - layer.height - layer.y);
					all_right = Math.min(all_right, _config2.default.WIDTH - layer.width - layer.x);
				}
			}

			//move every layer
			for (var i = 0; i < _config2.default.layers.length; i++) {
				var layer = _config2.default.layers[i];
				if (layer.x == null || layer.y == null || layer.type == null) continue;

				layer.x = layer.x - all_left;
				layer.y = layer.y - all_top;
			}

			//resize
			_config2.default.WIDTH = _config2.default.WIDTH - all_left - all_right;
			_config2.default.HEIGHT = _config2.default.HEIGHT - all_top - all_bottom;
			if (_config2.default.WIDTH < 1) _config2.default.WIDTH = 1;
			if (_config2.default.HEIGHT < 1) _config2.default.HEIGHT = 1;

			this.Base_gui.prepare_canvas();
			_config2.default.need_render = true;
		}

		/**
   * get painted area coords
   * 
   * @param {int} layer_id
   * @param {boolean} trim_white
   * @returns {object} keys: top, left, botom, right, width, height, relative
   */

	}, {
		key: 'get_trim_info',
		value: function get_trim_info(layer_id, trim_white) {
			if (trim_white == undefined) {
				trim_white = false;
				if (_config2.default.TRANSPARENCY == false) {
					trim_white = true;
				}
			}
			var layer = this.Base_layers.get_layer(layer_id);

			var canvas = this.Base_layers.convert_layer_to_canvas(layer_id, null, false);
			var ctx = canvas.getContext("2d");
			var img = ctx.getImageData(0, 0, canvas.width, canvas.height);
			var imgData = img.data;

			var top = 0;
			var left = 0;
			var bottom = 0;
			var right = 0;
			if (trim_white == undefined) trim_white = true;
			//check top
			main1: for (var y = 0; y < img.height; y++) {
				for (var x = 0; x < img.width; x++) {
					var k = y * (img.width * 4) + x * 4;
					if (imgData[k + 3] == 0) continue; //transparent 
					if (trim_white == true && imgData[k] == 255 && imgData[k + 1] == 255 && imgData[k + 2] == 255) continue; //white
					break main1;
				}
				top++;
			}
			//check left
			main2: for (var x = 0; x < img.width; x++) {
				for (var y = 0; y < img.height; y++) {
					var k = y * (img.width * 4) + x * 4;
					if (imgData[k + 3] == 0) continue; //transparent 
					if (trim_white == true && imgData[k] == 255 && imgData[k + 1] == 255 && imgData[k + 2] == 255) continue; //white
					break main2;
				}
				left++;
			}
			//check bottom
			main3: for (var y = img.height - 1; y >= 0; y--) {
				for (var x = img.width - 1; x >= 0; x--) {
					var k = y * (img.width * 4) + x * 4;
					if (imgData[k + 3] == 0) continue; //transparent 
					if (trim_white == true && imgData[k] == 255 && imgData[k + 1] == 255 && imgData[k + 2] == 255) continue; //white
					break main3;
				}
				bottom++;
			}
			//check right
			main4: for (var x = img.width - 1; x >= 0; x--) {
				for (var y = img.height - 1; y >= 0; y--) {
					var k = y * (img.width * 4) + x * 4;
					if (imgData[k + 3] == 0) continue; //transparent 
					if (trim_white == true && imgData[k] == 255 && imgData[k + 1] == 255 && imgData[k + 2] == 255) continue; //white
					break main4;
				}
				right++;
			}

			var top_rel = top - layer.y;
			var left_rel = left - layer.x;
			var bottom_rel = bottom - (_config2.default.HEIGHT - layer.y - layer.height);
			var right_rel = right - (_config2.default.WIDTH - layer.x - layer.width);

			return {
				top: top,
				left: left,
				bottom: bottom,
				right: right,
				width: canvas.width - left - right,
				height: canvas.height - top - bottom,
				relative: {
					top: top_rel,
					left: left_rel,
					bottom: bottom_rel,
					right: right_rel,
					width: canvas.width - left - right,
					height: canvas.height - top - bottom
				}
			};
		}
	}]);

	return Image_trim_class;
}();

exports.default = Image_trim_class;

/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * miniPaint - https://github.com/viliusle/miniPaint
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * author: Vilius L.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _baseGui = __webpack_require__(7);

var _baseGui2 = _interopRequireDefault(_baseGui);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var instance = null;

/**
 * Undo state class. Supports multiple levels undo.
 */

var Base_state_class = function () {
	function Base_state_class() {
		_classCallCheck(this, Base_state_class);

		//singleton
		if (instance) {
			return instance;
		}
		instance = this;

		this.Base_layers = new _baseLayers2.default();
		this.Base_gui = new _baseGui2.default();
		this.layers_archive = [];
		this.levels = 3;
		this.levels_optimal = 3;
		this.enabled = true;

		this.set_events();
	}

	_createClass(Base_state_class, [{
		key: 'set_events',
		value: function set_events() {
			var _this = this;

			document.addEventListener('keydown', function (event) {
				var code = event.keyCode;
				if (event.target.type == 'text' || event.target.tagName == 'INPUT' || event.target.type == 'textarea') return;

				if (code == 90 && (event.ctrlKey == true || event.metaKey)) {
					//undo
					_this.undo();
				}
			}, false);
		}
	}, {
		key: 'save',
		value: function save() {

			this.optimize();

			if (this.enabled == false) {
				return;
			}

			//move previous
			this.layers_archive.unshift(null);
			if (this.layers_archive.length > this.levels) {
				//remove element, that is too far in history - saving memory here
				this.layers_archive.splice(-1, 1);
			}

			//general
			this.layers_archive[0] = {
				width: _config2.default.WIDTH,
				height: _config2.default.HEIGHT,
				layer_active: _config2.default.layer.id
			};

			//layers
			this.layers_archive[0].layers = [];
			for (var i in _config2.default.layers) {
				var layer = {};
				for (var j in _config2.default.layers[i]) {
					if (j[0] == '_' || j == 'link_canvas') {
						//private data
						continue;
					}

					layer[j] = _config2.default.layers[i][j];
				}
				layer = JSON.parse(JSON.stringify(layer));
				this.layers_archive[0].layers.push(layer);
			}

			//image data
			this.layers_archive[0].data = [];
			for (var i in _config2.default.layers) {
				if (_config2.default.layers[i].type != 'image') continue;

				this.layers_archive[0].data.push({
					id: _config2.default.layers[i].id,
					data: _config2.default.layers[i].link.cloneNode(true) //@todo - optimize, avoid duplicating data
				});
			}
		}

		/**
   * supports multiple levels undo system
   */

	}, {
		key: 'undo',
		value: function undo() {
			if (this.enabled == false || this.layers_archive[0] == undefined) {
				//not saved yet
				_alertifyMin2.default.error('Undo is not available.');
				return false;
			}

			var data = this.layers_archive[0];

			//set attributes
			if (_config2.default.WIDTH != parseInt(data.width) || _config2.default.HEIGHT != parseInt(data.height)) {
				_config2.default.WIDTH = parseInt(data.width);
				_config2.default.HEIGHT = parseInt(data.height);
				this.Base_gui.prepare_canvas();
			}
			this.Base_layers.reset_layers();

			for (var i in data.layers) {
				var value = data.layers[i];

				if (value.type == 'image') {
					//add image data
					value.link = null;
					for (var j in data.data) {
						if (data.data[j].id == value.id) {
							value.data = data.data[j].data;
						}
					}
				}

				this.Base_layers.insert(value, false);
			}

			if (_config2.default.WIDTH != parseInt(data.width) || _config2.default.HEIGHT != parseInt(data.height)) {
				_config2.default.WIDTH = parseInt(data.width);
				_config2.default.HEIGHT = parseInt(data.height);
				this.Base_gui.prepare_canvas();
			}

			this.Base_layers.select(data.layer_active);
			this.layers_archive.shift(); //remove used state
		}

		/**
   * try save, optimize memory, find optimal undo level count.
   */

	}, {
		key: 'optimize',
		value: function optimize() {
			var megapixels = _config2.default.WIDTH * _config2.default.HEIGHT / 1024 / 1024;
			var images = 0;
			for (var i in _config2.default.layers) {
				if (_config2.default.layers[i].type == 'image') {
					images++;
				}
			}
			var total_megapx = megapixels * images;

			if (total_megapx > 100) {
				//high dimensions - undo disabled
				if (this.enabled == true) _alertifyMin2.default.warning('Undo disabled.');
				this.enabled = false;
				this.layers_archive = [];
			} else {
				//enabled
				if (this.enabled == false) _alertifyMin2.default.success('Undo enabled.');
				this.enabled = true;

				if (total_megapx > 50) {
					//1 undo level
					if (this.levels > 1) _alertifyMin2.default.warning('Undo levels changed to 1.');
					this.levels = 1;
					this.layers_archive = [this.layers_archive[0]];
				} else {
					//OK
					if (this.levels == 1) _alertifyMin2.default.success('Undo levels restored to ' + this.levels);
					this.levels = this.levels_optimal;
				}
			}
		}
	}]);

	return Base_state_class;
}();

exports.default = Base_state_class;

/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _baseGui = __webpack_require__(7);

var _baseGui2 = _interopRequireDefault(_baseGui);

var _popup = __webpack_require__(3);

var _popup2 = _interopRequireDefault(_popup);

var _helpers = __webpack_require__(4);

var _helpers2 = _interopRequireDefault(_helpers);

var _clipboard = __webpack_require__(71);

var _clipboard2 = _interopRequireDefault(_clipboard);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

var _exif = __webpack_require__(72);

var _exif2 = _interopRequireDefault(_exif);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var instance = null;

/** 
 * manages files / open
 * 
 * @author ViliusL
 */

var File_open_class = function () {
	function File_open_class() {
		_classCallCheck(this, File_open_class);

		//singleton
		if (instance) {
			return instance;
		}
		instance = this;

		var _this = this;
		this.POP = new _popup2.default();
		this.Base_layers = new _baseLayers2.default();
		this.Base_gui = new _baseGui2.default();
		this.Helper = new _helpers2.default();

		//clipboard class
		this.Clipboard_class = new _clipboard2.default(function (data, w, h) {
			_this.on_paste(data, w, h);
		});

		this.events();

		this.maybe_file_open_url_handler();
	}

	_createClass(File_open_class, [{
		key: 'events',
		value: function events() {
			var _this = this;

			window.ondrop = function (e) {
				//drop
				e.preventDefault();
				_this.open_handler(e);
			};
			window.ondragover = function (e) {
				e.preventDefault();
			};
		}
	}, {
		key: 'on_paste',
		value: function on_paste(data, width, height) {
			var new_layer = {
				name: 'Paste',
				type: 'image',
				data: data
			};
			this.Base_layers.insert(new_layer);
		}
	}, {
		key: 'open_file',
		value: function open_file() {
			var _this = this;

			_alertifyMin2.default.success('You can also drag and drop items into browser.');

			document.getElementById("tmp").innerHTML = '';
			var a = document.createElement('input');
			a.setAttribute("id", "file_open");
			a.type = 'file';
			a.multiple = 'multiple';
			document.getElementById("tmp").appendChild(a);
			document.getElementById('file_open').addEventListener('change', function (e) {
				_this.open_handler(e);
			}, false);

			//force click
			document.querySelector('#file_open').click();
		}
	}, {
		key: 'open_dir',
		value: function open_dir() {
			var _this = this;

			document.getElementById("tmp").innerHTML = '';
			var a = document.createElement('input');
			a.setAttribute("id", "file_open_dir");
			a.type = 'file';
			a.webkitdirectory = 'webkitdirectory';
			document.getElementById("tmp").appendChild(a);
			document.getElementById('file_open_dir').addEventListener('change', function (e) {
				_this.open_handler(e);
			}, false);

			//force click
			document.querySelector('#file_open_dir').click();
		}

		/**
   * opens data URLs, like: "data:image/png;base64,xxxxxx"
   * 
   * data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACCAYAAABytg0kAAAAG0lEQVQYV2N89+7df0FBQQbG/////3///j0DAF9wCsg9spQfAAAAAElFTkSuQmCC
   */

	}, {
		key: 'open_data_url',
		value: function open_data_url() {
			var _this = this;

			var settings = {
				title: 'Open data URL',
				params: [{ name: "data", title: "Data URL:", type: "textarea", value: "" }],
				on_finish: function on_finish(params) {
					window.State.save();
					_this.file_open_data_url_handler(params.data);
				}
			};
			this.POP.show(settings);
		}
	}, {
		key: 'file_open_data_url_handler',
		value: function file_open_data_url_handler(data) {
			var _this = this;
			if (data == '') return;

			var img = new Image();
			img.crossOrigin = "Anonymous";
			img.onload = function () {
				var new_layer = {
					name: "Data URL",
					type: 'image',
					link: img,
					width: img.width,
					height: img.height,
					width_original: img.width,
					height_original: img.height
				};
				_this.Base_layers.insert(new_layer);
				_this.Base_layers.autoresize(img.width, img.height);
				img.onload = function () {
					_config2.default.need_render = true;
				};
			};
			img.onerror = function (ex) {
				_alertifyMin2.default.error('Sorry, image could not be loaded. Try copy image and paste it.');
			};
			img.src = data;
		}
	}, {
		key: 'open_url',
		value: function open_url() {
			var _this = this;

			var settings = {
				title: 'Open URL',
				params: [{ name: "url", title: "URL:", value: "" }],
				on_finish: function on_finish(params) {
					window.State.save();
					_this.file_open_url_handler(params);
				}
			};
			this.POP.show(settings);
		}
	}, {
		key: 'open_handler',
		value: function open_handler(e) {
			var _this = this;
			var files = e.target.files;

			window.State.save();
			var auto_increment = this.Base_layers.auto_increment;

			if (files == undefined) {
				//drag and drop
				files = e.dataTransfer.files;
			}

			//sort
			var orders = [];
			for (var i = 0, f; i < files.length; i++) {
				orders.push(files[i].name);
			}
			orders.sort();
			var order_map = [];
			for (var i in orders) {
				order_map[orders[i]] = parseInt(i);
			}

			for (var i = 0, f; i < files.length; i++) {
				f = files[i];
				if (!f.type.match('image.*') && !f.name.match('.json')) {
					_alertifyMin2.default.error('Wrong file type, must be image or json.');
					continue;
				}
				if (files.length == 1) this.SAVE_NAME = f.name.split('.')[f.name.split('.').length - 2];

				var FR = new FileReader();
				FR.file = files[i];

				FR.onload = function (event) {
					if (this.file.type.match('image.*')) {
						var order = auto_increment + order_map[this.file.name];
						//image
						var new_layer = {
							name: this.file.name,
							type: 'image',
							data: event.target.result,
							order: order
						};
						_this.Base_layers.insert(new_layer);
						_this.extract_exif(this.file);
					} else {
						//json
						var responce = _this.load_json(event.target.result);
						if (responce === true) {
							return false;
						}
					}
				};
				if (f.type == "text/plain") FR.readAsText(f);else if (f.name.match('.json')) FR.readAsText(f);else FR.readAsDataURL(f);
			}
		}

		/**
   * check if url has url params, for example: http://viliusle.github.io/miniPaint/?image=http://i.imgur.com/ATda8Ae.jpg
   */

	}, {
		key: 'maybe_file_open_url_handler',
		value: function maybe_file_open_url_handler() {
			var url_params = this.Helper.get_url_parameters();
			if (url_params.image != undefined) {
				//found params - try to load it
				var data = {
					url: url_params.image
				};
				this.file_open_url_handler(data);
			}
		}

		//handler for open url. Example url: http://i.imgur.com/ATda8Ae.jpg

	}, {
		key: 'file_open_url_handler',
		value: function file_open_url_handler(user_response) {
			var _this = this;
			var url = user_response.url;
			if (url == '') return;

			var layer_name = url.replace(/^.*[\\\/]/, '');

			var img = new Image();
			img.crossOrigin = "Anonymous";
			img.onload = function () {
				var new_layer = {
					name: layer_name,
					type: 'image',
					link: img,
					width: img.width,
					height: img.height,
					width_original: img.width,
					height_original: img.height
				};
				img.onload = function () {
					_config2.default.need_render = true;
				};
				_this.Base_layers.insert(new_layer);
				_this.Base_layers.autoresize(img.width, img.height);
			};
			img.onerror = function (ex) {
				_alertifyMin2.default.error('Sorry, image could not be loaded. Try copy image and paste it.');
			};
			img.src = url;
		}
	}, {
		key: 'load_json',
		value: function load_json(data) {
			var json = JSON.parse(data);
			if (json.info.version == undefined) {
				json.info.version = "3";
			}
			if (json.info.version < "4") {
				//convert from v3 to v4
				for (var i in json.layers) {
					//layers data
					json.layers[i].id = parseInt(i) + 1;
					json.layers[i].opacity = json.layers[i].opacity * 100 || 100;
					json.layers[i].type = "image";
					json.layers[i].width = json.info.width;
					json.layers[i].height = json.info.height;
					json.layers[i].visible = json.layers[i].visible == true; //convert to boolean
					delete json.layers[i].title;
				}
				json.data = [];
				for (var i in json.image_data) {
					//image data
					var new_id = null;
					for (var j in json.layers) {
						if (json.layers[j].name == json.image_data[i].name) {
							new_id = json.layers[j].id;
						}
					}
					if (new_id == null) continue;
					json.data.push({
						id: new_id,
						data: json.image_data[i].data
					});
				}
			}

			//set attributes
			_config2.default.ZOOM = 1;
			_config2.default.WIDTH = parseInt(json.info.width);
			_config2.default.HEIGHT = parseInt(json.info.height);
			this.Base_layers.reset_layers();
			this.Base_gui.prepare_canvas();

			for (var i in json.layers) {
				var value = json.layers[i];

				if (value.type == 'image') {
					//add image data
					value.link = null;
					for (var j in json.data) {
						if (json.data[j].id == value.id) {
							value.data = json.data[j].data;
						}
					}
				}

				this.Base_layers.insert(value, false);
			}
			if (json.info.layer_active != undefined) {
				this.Base_layers.select(json.info.layer_active);
			}
		}
	}, {
		key: 'extract_exif',
		value: function extract_exif(object) {
			var exif_data = {
				general: [],
				exif: []
			};

			//exif data
			_exif2.default.getData(object, function () {
				exif_data.exif = this.exifdata;
				delete this.exifdata.thumbnail;
			});

			//general
			if (object.name != undefined) exif_data.general.Name = object.name;
			if (object.size != undefined) exif_data.general.Size = this.Helper.number_format(object.size / 1000, 2) + ' KB';
			if (object.type != undefined) exif_data.general.Type = object.type;
			if (object.lastModified != undefined) exif_data.general['Last modified'] = this.Helper.format_time(object.lastModified);

			//save
			_config2.default.layer._exif = exif_data;
		}
	}]);

	return File_open_class;
}();

exports.default = File_open_class;

/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _baseSelection = __webpack_require__(12);

var _baseSelection2 = _interopRequireDefault(_baseSelection);

var _guiTools = __webpack_require__(13);

var _guiTools2 = _interopRequireDefault(_guiTools);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var instance = null;

var Selection_class = function (_Base_tools_class) {
	_inherits(Selection_class, _Base_tools_class);

	function Selection_class(ctx) {
		_classCallCheck(this, Selection_class);

		//singleton
		var _this2 = _possibleConstructorReturn(this, (Selection_class.__proto__ || Object.getPrototypeOf(Selection_class)).call(this));

		if (instance) {
			var _ret;

			return _ret = instance, _possibleConstructorReturn(_this2, _ret);
		}
		instance = _this2;

		var _this = _this2;

		_this2.Base_layers = new _baseLayers2.default();
		_this2.ctx = ctx;
		_this2.name = 'selection';
		_this2.type = null;
		_this2.tmpCanvas = null;
		_this2.tmpCanvasCtx = null;
		_this2.selection_coords_from = null;
		_this2.selection = {
			x: null,
			y: null,
			width: null,
			height: null
		};

		var sel_config = {
			enable_background: true,
			enable_borders: true,
			enable_controlls: false,
			data_function: function data_function() {
				return _this.selection;
			}
		};
		_this2.Base_selection = new _baseSelection2.default(ctx, sel_config, _this2.name);
		_this2.GUI_tools = new _guiTools2.default();
		return _this2;
	}

	_createClass(Selection_class, [{
		key: 'load',
		value: function load() {
			var _this = this;

			//events
			document.addEventListener('mousedown', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousedown(e);
			});
			document.addEventListener('mousemove', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousemove(e);
			});
			document.addEventListener('mouseup', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mouseup(e);
			});
			document.addEventListener('keydown', function (e) {
				var code = e.keyCode;
				if (e.target.type == 'text' || e.target.tagName == 'INPUT' || e.target.type == 'textarea') return;

				if (code == 27) {
					//escape
					_this.on_leave();
				}
				if (code == 46) {
					//delete
					if (_config2.default.TOOL.name == _this.name) {
						window.State.save();
						_this.delete_selection();
					}
				}
				if (code == 65 && (e.ctrlKey == true || e.metaKey)) {
					//A
					e.preventDefault();
					_this.select_all();
				}
			}, false);
		}
	}, {
		key: 'mousedown',
		value: function mousedown(e) {
			var mouse = this.get_mouse_info(e);
			var layer = _config2.default.layer;
			if (mouse.valid == false || mouse.click_valid == false) return;

			if (_config2.default.layer.type != 'image') {
				_alertifyMin2.default.error('Layer must be image, convert it to raster to apply this tool.');
				return;
			}

			if (this.selection.width != null && this.selection.height != null && mouse.x > this.selection.x && mouse.x < this.selection.x + this.selection.width && mouse.y > this.selection.y && mouse.y < this.selection.y + this.selection.height && layer.width == layer.width_original && layer.height == layer.height_original) {
				//move
				this.type = 'move';

				if (this.tmpCanvas == null) {
					this.init_tmp_canvas();

					//register tmp canvas for faster redraw
					_config2.default.layer.link_canvas = this.tmpCanvas;
					_config2.default.need_render = true;
				}
			} else {
				//save last translation?
				if (this.selection.width != null && this.selection.height != null) {
					this.save_translate();
				}

				//create new selection
				this.selection = {
					x: mouse.x,
					y: mouse.y,
					width: 0,
					height: 0
				};
				this.type = 'create';
				this.selection_coords_from = { x: mouse.x, y: mouse.y };
			}
		}
	}, {
		key: 'mousemove',
		value: function mousemove(e) {
			var mouse = this.get_mouse_info(e);
			if (mouse.is_drag == false) return;
			if (e.type == 'mousedown' && (mouse.valid == false || mouse.click_valid == false) || _config2.default.layer.type != 'image') {
				return;
			}
			if (this.selection_coords_from === null) {
				return;
			}
			if (this.type == 'create') {
				//create new selection
				this.selection.width = mouse.x - mouse.click_x;
				this.selection.height = mouse.y - mouse.click_y;
				_config2.default.need_render = true;
			} else {
				//move selection
				var selection = this.selection;
				var layer = _config2.default.layer;
				var x = this.selection.x + (mouse.x - mouse.last_x);
				var y = this.selection.y + (mouse.y - mouse.last_y);
				var width = Math.ceil(selection.width);
				var height = Math.ceil(selection.height);
				var from_x = this.selection_coords_from.x;
				var from_y = this.selection_coords_from.y;

				this.Base_selection.set_selection(x, y, null, null);

				//move data
				this.tmpCanvasCtx.clearRect(0, 0, layer.width, layer.height);
				this.tmpCanvasCtx.drawImage(layer.link, 0, 0, layer.width, layer.height);
				this.tmpCanvasCtx.clearRect(from_x - layer.x, from_y - layer.y, selection.width, selection.height);
				this.tmpCanvasCtx.drawImage(layer.link, Math.round(from_x - layer.x), Math.round(from_y - layer.y), width, height, Math.round(selection.x - layer.x), Math.round(selection.y - layer.y), width, height);

				//draw draft preview
				_config2.default.need_render = true;
			}
		}
	}, {
		key: 'mouseup',
		value: function mouseup(e) {
			var mouse = this.get_mouse_info(e);

			if (e.type == 'mousedown' && mouse.click_valid == false || _config2.default.layer.type != 'image') {
				return;
			}

			var width = mouse.x - this.selection.x;
			var height = mouse.y - this.selection.y;

			if (width == 0 || height == 0) {
				//cancel selection
				this.on_leave();
				return;
			}

			if (this.selection.width != null && this.selection.height != null) {
				//make sure coords not negative
				var details = this.selection;
				var x = details.x;
				var y = details.y;
				if (details.width < 0) {
					x = x + details.width;
					this.selection_coords_from.x = x;
				}
				if (details.height < 0) {
					y = y + details.height;
					this.selection_coords_from.y = y;
				}
				this.selection = {
					x: x,
					y: y,
					width: Math.abs(details.width),
					height: Math.abs(details.height)
				};
				_config2.default.need_render = true;
			}
		}
	}, {
		key: 'select_all',
		value: function select_all() {
			if (_config2.default.layer.type != 'image') {
				_alertifyMin2.default.error('Layer must be image, convert it to raster to apply this tool.');
				return;
			}
			if (_config2.default.TOOL.name != 'selection') {
				this.GUI_tools.activate_tool(this.name);
			}

			this.selection = {
				x: 0,
				y: 0,
				width: _config2.default.WIDTH,
				height: _config2.default.HEIGHT
			};
			_config2.default.need_render = true;
		}
	}, {
		key: 'render',
		value: function render(ctx, layer) {
			//nothing
		}
	}, {
		key: 'save_translate',
		value: function save_translate() {
			if (this.tmpCanvas == null) return;

			delete _config2.default.layer.link_canvas;
			this.Base_layers.update_layer_image(this.tmpCanvas);

			this.reset_tmp_canvas();
			_config2.default.need_render = true;
		}
	}, {
		key: 'delete_selection',
		value: function delete_selection() {
			var selection = this.selection;
			var layer = _config2.default.layer;

			if (_config2.default.layer.type != 'image') {
				_alertifyMin2.default.error('Layer must be image, convert it to raster to apply this tool.');
				return;
			}

			if (selection == null) {
				_alertifyMin2.default.error('Nothing is selected.');
				return;
			}

			this.init_tmp_canvas();

			var mouse_x = selection.x - layer.x;
			var mouse_y = selection.y - layer.y;

			//adapt to origin size
			mouse_x = this.adaptSize(mouse_x, 'width');
			mouse_y = this.adaptSize(mouse_y, 'height');
			selection.width = this.adaptSize(selection.width, 'width');
			selection.height = this.adaptSize(selection.height, 'height');

			//do erase
			this.tmpCanvasCtx.clearRect(mouse_x, mouse_y, selection.width, selection.height);

			this.Base_layers.update_layer_image(this.tmpCanvas);
			this.selection = {
				x: null,
				y: null,
				width: null,
				height: null
			};
			this.Base_selection.reset_selection();
			this.reset_tmp_canvas();

			delete _config2.default.layer.link_canvas;
			this.reset_tmp_canvas();
		}
	}, {
		key: 'init_tmp_canvas',
		value: function init_tmp_canvas() {
			this.tmpCanvas = document.createElement('canvas');
			this.tmpCanvasCtx = this.tmpCanvas.getContext("2d");
			this.tmpCanvas.width = _config2.default.layer.width_original;
			this.tmpCanvas.height = _config2.default.layer.height_original;
			this.tmpCanvasCtx.drawImage(_config2.default.layer.link, 0, 0);
		}
	}, {
		key: 'on_leave',
		value: function on_leave() {
			this.selection = {
				x: null,
				y: null,
				width: null,
				height: null
			};
			this.Base_selection.reset_selection();
			delete _config2.default.layer.link_canvas;
			this.reset_tmp_canvas();
		}
	}, {
		key: 'clear_selection',
		value: function clear_selection() {
			this.on_leave();
		}
	}, {
		key: 'reset_tmp_canvas',
		value: function reset_tmp_canvas() {
			if (this.tmpCanvas == null) return;
			this.tmpCanvas.width = 1;
			this.tmpCanvas.height = 1;
			this.tmpCanvas = null;
			this.tmpCanvasCtx = null;
		}
	}]);

	return Selection_class;
}(_baseTools2.default);

;
exports.default = Selection_class;

/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Layer_raster_class = function () {
	function Layer_raster_class() {
		_classCallCheck(this, Layer_raster_class);

		this.Base_layers = new _baseLayers2.default();
	}

	_createClass(Layer_raster_class, [{
		key: 'raster',
		value: function raster() {
			var canvas = this.Base_layers.convert_layer_to_canvas();
			var current_layer = _config2.default.layer;
			var current_id = current_layer.id;

			if (_config2.default.layer.type == 'image') {
				_alertifyMin2.default.error('Layer is already image.');
				return;
			}

			window.State.save();

			//show
			var params = {
				type: 'image',
				name: _config2.default.layer.name + ' + raster',
				data: canvas.toDataURL("image/png"),
				x: parseInt(canvas.dataset.x),
				y: parseInt(canvas.dataset.y),
				width: canvas.width,
				height: canvas.height,
				opacity: current_layer.opacity
			};
			this.Base_layers.insert(params, false);

			this.Base_layers.delete(current_id);
		}
	}]);

	return Layer_raster_class;
}();

exports.default = Layer_raster_class;

/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($) {

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _open = __webpack_require__(18);

var _open2 = _interopRequireDefault(_open);

var _popup = __webpack_require__(3);

var _popup2 = _interopRequireDefault(_popup);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/** 
 * manages iamge search on https://pixabay.com/en/service/about/api/
 */
var File_search_media_class = function () {
	function File_search_media_class() {
		_classCallCheck(this, File_search_media_class);

		this.File_open = new _open2.default();
		this.POP = new _popup2.default();
		this.cache = [];
	}

	/**
  * Image search api
  * 
  * @param {string} query
  * @param {array} data
  */


	_createClass(File_search_media_class, [{
		key: 'search',
		value: function search() {
			var query = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
			var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

			var _this = this;
			var html = '';

			var key = _config2.default.pixabay_key;
			key = key.split("").reverse().join("");

			if (data.length > 0) {
				for (var i in data) {
					html += '<div class="item pointer">';
					html += '<img class="displayBlock" alt="" src="' + data[i].previewURL + '" data-url="' + data[i].webformatURL + '" />';
					html += '</div>';
				}
				//fix for last line
				html += '<div class="item"></div>';
				html += '<div class="item"></div>';
				html += '<div class="item"></div>';
				html += '<div class="item"></div>';
			}

			var settings = {
				title: 'Search',
				comment: 'Powred by <a class="grey" href="https://pixabay.com/">pixabay.com</a>.',
				className: 'wide',
				params: [{ name: "query", title: "Keyword:", value: query }],
				on_load: function on_load(params) {
					var node = document.createElement("div");
					node.classList.add('flex-container');
					node.innerHTML = html;
					document.querySelector('#popup #dialog_content').appendChild(node);
					//events
					var targets = document.querySelectorAll('#popup .item img');
					for (var i = 0; i < targets.length; i++) {
						targets[i].addEventListener('click', function (event) {
							//we have click
							window.State.save();
							this.dataset.url = this.dataset.url.replace('_640.', '_960.');
							var data = {
								url: this.dataset.url
							};
							_this.File_open.file_open_url_handler(data);
						});
					}
				},
				on_finish: function on_finish(params) {
					if (params.query == '') return;

					if (_this.cache[params.query] != undefined) {
						//using cache

						setTimeout(function () {
							//only call same fuction after all handlers finishes
							var data = _this.cache[params.query];
							if (parseInt(data.totalHits) == 0) {
								_alertifyMin2.default.error('Your search did not match any images.');
							}
							_this.search(params.query, data.hits);
						}, 100);
					} else {
						//query to service
						var URL = "https://pixabay.com/api/?key=" + key + "&per_page=50&q=" + encodeURIComponent(params.query);
						$.getJSON(URL, function (data) {
							_this.cache[params.query] = data;

							if (parseInt(data.totalHits) == 0) {
								_alertifyMin2.default.error('Your search did not match any images.');
							}
							_this.search(params.query, data.hits);
						}).fail(function () {
							_alertifyMin2.default.error('Error connecting to service.');
						});
					}
				}
			};
			this.POP.show(settings);
		}
	}]);

	return File_search_media_class;
}();

exports.default = File_search_media_class;
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(14)))

/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * miniPaint - https://github.com/viliusle/miniPaint
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * author: Vilius L.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var instance = null;

var template = '\n\t<div class="canvas_preview_wrapper">\n\t\t<div class="transparent-grid" id="canvas_preview_background"></div>\n\t\t<canvas width="188" height="100" class="transparent" id="canvas_preview"></canvas>\n\t</div>\n\t<div class="details">\n\t\t<input title="Zoom out" class="layer_add" id="zoom_less" type="button" value="-" />\n\t\t<input title="Reset zoom level" class="layer_add" id="zoom_100" type="button" value="100%" />\n\t\t<input title="Zoom in" class="layer_add" id="zoom_more" type="button" value="+" />\n\t\t<input class="layer_add" id="zoom_fit" type="button" value="Fit" />\n\t</div>\n\t<input id="zoom_range" type="range" value="100" min="50" max="1000" step="50" /> \n';

/**
 * GUI class responsible for rendering preview on right sidebar
 */

var GUI_preview_class = function () {
	function GUI_preview_class(GUI_class) {
		_classCallCheck(this, GUI_preview_class);

		//singleton
		if (instance) {
			return instance;
		}
		instance = this;
		document.getElementById('toggle_preview').innerHTML = template;

		// preview mini window size on right sidebar
		this.PREVIEW_SIZE = { w: 188, h: 100 };

		this.zoom_data = {
			x: 0,
			y: 0,
			move_pos: null
		};

		this.mouse_pressed = false;
		this.canvas_preview = null;
		if (GUI_class != undefined) {
			this.GUI = GUI_class;
		}
		this.Base_layers = new _baseLayers2.default();
	}

	_createClass(GUI_preview_class, [{
		key: 'render_main_preview',
		value: function render_main_preview() {
			this.canvas_preview = document.getElementById("canvas_preview").getContext("2d");

			this.prepare_canvas();
			_config2.default.need_render = true;
			this.set_events();
		}
	}, {
		key: 'set_events',
		value: function set_events() {
			var _this = this;

			document.addEventListener('mousedown', function (e) {
				_this.mouse_pressed = true;
			}, false);
			document.addEventListener('mouseup', function (e) {
				_this.mouse_pressed = false;
			}, false);
			document.getElementById('zoom_range').addEventListener('input', function (e) {
				_this.set_center_zoom();
				_this.zoom(this.value);
			}, false);
			document.getElementById('zoom_range').addEventListener('change', function (e) {
				//IE11
				if (this.value != _config2.default.ZOOM * 100) {
					_this.set_center_zoom();
					_this.zoom(this.value);
				}
			}, false);
			document.getElementById('zoom_less').addEventListener('click', function (e) {
				_this.set_center_zoom();
				_this.zoom(-1);
			}, false);
			document.getElementById('zoom_100').addEventListener('click', function (e) {
				_this.zoom(100);
			}, false);
			document.getElementById('zoom_more').addEventListener('click', function (e) {
				_this.set_center_zoom();
				_this.zoom(+1);
			}, false);
			document.getElementById('zoom_fit').addEventListener('click', function (e) {
				_this.zoom_auto();
			}, false);
			document.getElementById('main_wrapper').addEventListener('wheel', function (e) {
				//zoom with mouse scroll
				e.preventDefault();
				_this.zoom_data.x = e.offsetX;
				_this.zoom_data.y = e.offsetY;
				var delta = Math.max(-1, Math.min(1, e.wheelDelta || -e.detail || -e.deltaY));
				if (delta > 0) _this.zoom(+1, e);else _this.zoom(-1, e);
			}, false);
			window.addEventListener('resize', function (e) {
				//resize
				_config2.default.need_render = true;
			}, false);
			document.getElementById("canvas_preview").addEventListener('mousedown', function (e) {
				//change zoom offset
				_this.set_zoom_position(e);
			}, false);
			document.getElementById("canvas_preview").addEventListener('mousemove', function (e) {
				//change zoom offset
				if (_this.mouse_pressed == false) return;
				_this.set_zoom_position(e);
			}, false);
		}
	}, {
		key: 'prepare_canvas',
		value: function prepare_canvas() {
			this.canvas_preview.webkitImageSmoothingEnabled = false;
			this.canvas_preview.msImageSmoothingEnabled = false;
			this.canvas_preview.imageSmoothingEnabled = false;
			this.GUI.render_canvas_background('canvas_preview', 8);
		}
	}, {
		key: 'render_preview_active_zone',
		value: function render_preview_active_zone() {
			if (this.canvas_preview == undefined) {
				this.canvas_preview = document.getElementById("canvas_preview").getContext("2d");
			}

			//active zone
			var visible_w = _config2.default.visible_width / _config2.default.ZOOM;
			var visible_h = _config2.default.visible_height / _config2.default.ZOOM;

			var mini_rect_w = this.PREVIEW_SIZE.w * visible_w / _config2.default.WIDTH;
			var mini_rect_h = this.PREVIEW_SIZE.h * visible_h / _config2.default.HEIGHT;

			var start_pos = this.Base_layers.get_world_coords(0, 0);
			var mini_rect_x = start_pos.x / _config2.default.WIDTH * this.PREVIEW_SIZE.w;
			var mini_rect_y = start_pos.y / _config2.default.HEIGHT * this.PREVIEW_SIZE.h;

			//validate
			mini_rect_x = Math.max(0, mini_rect_x);
			mini_rect_y = Math.max(0, mini_rect_y);
			mini_rect_w = Math.min(this.PREVIEW_SIZE.w - 1, mini_rect_w);
			mini_rect_h = Math.min(this.PREVIEW_SIZE.h - 1, mini_rect_h);
			if (mini_rect_x + mini_rect_w > this.PREVIEW_SIZE.w) mini_rect_x = this.PREVIEW_SIZE.w - mini_rect_w;
			if (mini_rect_y + mini_rect_h > this.PREVIEW_SIZE.h) mini_rect_y = this.PREVIEW_SIZE.h - mini_rect_h;

			if (mini_rect_x == 0 && mini_rect_y == 0 && mini_rect_w == this.PREVIEW_SIZE.w - 1 && mini_rect_h == this.PREVIEW_SIZE.h - 1) {
				//everything is visible
				return;
			}

			//draw selected area in preview canvas
			this.canvas_preview.lineWidth = 1;
			this.canvas_preview.beginPath();
			this.canvas_preview.rect(Math.round(mini_rect_x) + 0.5, Math.round(mini_rect_y) + 0.5, mini_rect_w, mini_rect_h);
			this.canvas_preview.fillStyle = "rgba(0, 255, 0, 0.3)";
			this.canvas_preview.strokeStyle = "#00ff00";
			this.canvas_preview.fill();
			this.canvas_preview.stroke();
		}
	}, {
		key: 'zoom',
		value: function zoom(recalc) {
			if (recalc != undefined) {
				//zoom-in or zoom-out
				if (recalc == 1 || recalc == -1) {
					//fix
					if (_config2.default.ZOOM > 1 && _config2.default.ZOOM < 1.5) {
						_config2.default.ZOOM = 1;
					}
					if (_config2.default.ZOOM > 0.9 && _config2.default.ZOOM < 1) {
						_config2.default.ZOOM = 1;
					}

					//calc step
					if (recalc < 0) {
						//down
						if (_config2.default.ZOOM > 3) {
							//infinity -> 300%
							_config2.default.ZOOM -= 1;
						} else if (_config2.default.ZOOM > 1) {
							//300% -> 100%
							_config2.default.ZOOM -= 0.5;
						} else if (_config2.default.ZOOM > 0.1) {
							//100% -> 10%
							_config2.default.ZOOM -= 0.1;
						} else {
							//10% -> 1%
							_config2.default.ZOOM -= 0.01;
						}
					} else {
						//up
						if (_config2.default.ZOOM < 0.1) {
							//1% -> 10%
							_config2.default.ZOOM += 0.01;
						} else if (_config2.default.ZOOM < 1) {
							//10% -> 100%
							_config2.default.ZOOM += 0.1;
						} else if (_config2.default.ZOOM < 3) {
							//100% -> 300%
							_config2.default.ZOOM += 0.5;
						} else {
							//300% -> more
							_config2.default.ZOOM += 1;
						}
					}
				} else {
					//zoom using exact value
					_config2.default.ZOOM = recalc / 100;
				}
				_config2.default.ZOOM = Math.round(_config2.default.ZOOM * 100) / 100;
				_config2.default.ZOOM = Math.max(_config2.default.ZOOM, 0.01);
				_config2.default.ZOOM = Math.min(_config2.default.ZOOM, 500);
			}

			document.getElementById("zoom_100").value = Math.round(_config2.default.ZOOM * 100) + '%';
			document.getElementById("zoom_range").value = _config2.default.ZOOM * 100;

			_config2.default.need_render = true;
			this.GUI.prepare_canvas();
			return true;
		}
	}, {
		key: 'zoom_auto',
		value: function zoom_auto(only_increase) {
			var container = document.getElementById('main_wrapper');
			var page_w = container.clientWidth;
			var page_h = container.clientHeight;

			var best_width = page_w / _config2.default.WIDTH;
			var best_height = page_h / _config2.default.HEIGHT;
			var best_zoom = null;

			best_zoom = Math.min(best_width, best_height);

			if (only_increase != undefined && best_zoom > 1) {
				return false;
			}

			this.zoom(Math.min(best_width, best_height) * 100);
		}
	}, {
		key: 'set_center_zoom',
		value: function set_center_zoom() {
			this.zoom_data.x = _config2.default.visible_width / 2;
			this.zoom_data.y = _config2.default.visible_height / 2;
		}
	}, {
		key: 'set_zoom_position',
		value: function set_zoom_position(e) {
			var visible_w = _config2.default.visible_width / _config2.default.ZOOM;
			var visible_h = _config2.default.visible_height / _config2.default.ZOOM;
			var mini_w = this.PREVIEW_SIZE.w * visible_w / _config2.default.WIDTH;
			var mini_h = this.PREVIEW_SIZE.h * visible_h / _config2.default.HEIGHT;

			var change_x = (e.offsetX - mini_w / 2) / this.PREVIEW_SIZE.w * _config2.default.WIDTH;
			var change_y = (e.offsetY - mini_h / 2) / this.PREVIEW_SIZE.h * _config2.default.HEIGHT;

			var zoom_data = this.zoom_data;
			zoom_data.move_pos = {};
			zoom_data.move_pos.x = change_x;
			zoom_data.move_pos.y = change_y;

			_config2.default.need_render = true;
		}
	}]);

	return GUI_preview_class;
}();

exports.default = GUI_preview_class;

/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _popup = __webpack_require__(3);

var _popup2 = _interopRequireDefault(_popup);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Layer_rename_class = function () {
	function Layer_rename_class() {
		_classCallCheck(this, Layer_rename_class);

		this.Base_layers = new _baseLayers2.default();
		this.POP = new _popup2.default();
	}

	_createClass(Layer_rename_class, [{
		key: 'rename',
		value: function rename() {
			var id = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

			var _this = this;

			var settings = {
				title: 'Rename',
				params: [{ name: "name", title: "Name:", value: _config2.default.layer.name }],
				on_load: function on_load() {
					document.querySelector('#pop_data_name').select();
				},
				on_finish: function on_finish(params) {
					window.State.save();
					if (id == null) var link = _config2.default.layer;else var link = _this.Base_layers.get_layer(id);
					link.name = params.name;
					_this.Base_layers.refresh_gui();
					_config2.default.need_render = true;
				}
			};
			this.POP.show(settings);
		}
	}]);

	return Layer_rename_class;
}();

exports.default = Layer_rename_class;

/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _helpers = __webpack_require__(4);

var _helpers2 = _interopRequireDefault(_helpers);

var _popup = __webpack_require__(3);

var _popup2 = _interopRequireDefault(_popup);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

var _canvasToBlobMin = __webpack_require__(123);

var _canvasToBlobMin2 = _interopRequireDefault(_canvasToBlobMin);

var _FileSaverMin = __webpack_require__(124);

var _FileSaverMin2 = _interopRequireDefault(_FileSaverMin);

var _gif = __webpack_require__(127);

var _gif2 = _interopRequireDefault(_gif);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var instance = null;

/** 
 * manages files / save
 * 
 * @author ViliusL
 */

var File_save_class = function () {
	function File_save_class() {
		_classCallCheck(this, File_save_class);

		//singleton
		if (instance) {
			return instance;
		}
		instance = this;

		this.Base_layers = new _baseLayers2.default();
		this.Helper = new _helpers2.default();
		this.POP = new _popup2.default();

		this.set_events();

		//save types config
		this.SAVE_TYPES = ["PNG - Portable Network Graphics", "JPG - JPG/JPEG Format", "JSON - Full layers data", //aka PSD
		"GIF - Graphics Interchange Format", //animated GIF
		"WEBP - Weppy File Format", //chrome only
		"BMP - Windows Bitmap"];
	}

	_createClass(File_save_class, [{
		key: 'set_events',
		value: function set_events() {
			var _this = this;

			document.addEventListener('keydown', function (event) {
				var code = event.keyCode;
				if (event.target.type == 'text' || event.target.tagName == 'INPUT' || event.target.type == 'textarea') return;

				if (code == 83) {
					//save
					_this.save();
					event.preventDefault();
				}
			}, false);
		}
	}, {
		key: 'save',
		value: function save() {
			var _this = this;
			this.POP.hide();

			//find default format
			var save_default = this.SAVE_TYPES[0]; //png
			if (this.Helper.getCookie('save_default') == 'jpg') save_default = this.SAVE_TYPES[1]; //jpg

			var calc_size_value = false;
			var calc_size = false;
			if (_config2.default.WIDTH * _config2.default.HEIGHT < 1000000) {
				calc_size_value = true;
				calc_size = true;
			}

			var file_name = _config2.default.layers[0].name;
			var parts = file_name.split('.');
			if (parts.length > 1) file_name = parts[parts.length - 2];
			file_name = file_name.replace(/ /g, "-");

			var settings = {
				title: 'Save as',
				params: [{ name: "name", title: "File name:", value: file_name }, { name: "type", title: "Save as type:", values: this.SAVE_TYPES, value: save_default }, { name: "quality", title: "JPG, WEBP quality:", value: 90, range: [1, 100] }, {}, //gap
				{ title: "File size:", html: '<span id="file_size">-</span>' }, { name: "calc_size", title: "Show file size:", value: calc_size_value }, { name: "layers", title: "Save layers:", values: ['All', 'Selected'] }, { name: "delay", title: "Gif delay:", value: 400 }],
				on_change: function on_change(params, canvas_preview, w, h) {
					_this.save_dialog_onchange(params);
				},
				on_finish: function on_finish(params) {
					_this.save_action(params);
				}
			};
			this.POP.show(settings);

			document.getElementById("pop_data_name").select();

			if (calc_size == true) {
				//calc size once
				this.save_dialog_onchange(null);
			}
		}
	}, {
		key: 'save_data_url',
		value: function save_data_url() {
			var max = 10 * 1000 * 1000;
			if (_config2.default.WIDTH * _config2.default.WIDTH > 10 * 1000 * 1000) {
				_alertifyMin2.default.error('Size is too big, max ' + this.Helper.number_format(max, 0) + ' pixels.');
				return;
			}

			var canvas = document.createElement('canvas');
			var ctx = canvas.getContext("2d");
			canvas.width = _config2.default.WIDTH;
			canvas.height = _config2.default.HEIGHT;

			this.disable_canvas_smooth(ctx);

			//ask data
			this.Base_layers.convert_layers_to_canvas(ctx);
			var data_url = canvas.toDataURL();

			max = 1 * 1000 * 1000;
			if (data_url.length > max) {
				_alertifyMin2.default.error('Size is too big, max ' + this.Helper.number_format(max, 0) + ' bytes.');
				return;
			}

			var settings = {
				title: 'Data URL',
				params: [{ name: "url", title: "URL:", type: "textarea", value: data_url }]
			};
			this.POP.show(settings);
		}
	}, {
		key: 'update_file_size',
		value: function update_file_size(file_size) {
			if (typeof file_size == 'string') {
				document.getElementById('file_size').innerHTML = file_size;
				return;
			}

			if (file_size > 1024 * 1024) file_size = this.Helper.number_format(file_size / 1024 / 1024, 2) + ' MB';else if (file_size > 1024) file_size = this.Helper.number_format(file_size / 1024, 2) + ' KB';else file_size = file_size + ' B';
			document.getElementById('file_size').innerHTML = file_size;
		}

		//activated on save dialog parameters change - used for calculating file size

	}, {
		key: 'save_dialog_onchange',
		value: function save_dialog_onchange(object) {
			var _this = this;
			this.update_file_size('...');

			var user_response = this.POP.get_params();

			var quality = parseInt(user_response.quality);
			if (quality > 100 || quality < 1 || isNaN(quality) == true) quality = 90;
			quality = quality / 100;

			//detect type
			var type = user_response.type;
			var parts = type.split(" ");
			type = parts[0];

			var only_one_layer = null;
			if (user_response.layers == 'All') only_one_layer = false;else only_one_layer = true;

			if (user_response.calc_size == false) {
				document.getElementById('file_size').innerHTML = '-';
				return;
			}

			if (type != 'JSON' && type != 'GIF') {
				//create temp canvas
				var canvas = document.createElement('canvas');
				var ctx = canvas.getContext("2d");
				canvas.width = _config2.default.WIDTH;
				canvas.height = _config2.default.HEIGHT;
				this.disable_canvas_smooth(ctx);

				//ask data
				if (only_one_layer == true && type != 'GIF' && _config2.default.layer.type != null) {
					//only current layer !!!
					var layer = _config2.default.layer;

					var initial_x = null;
					var initial_y = null;
					if (layer.x != null && layer.y != null && layer.width != null && layer.height != null) {
						//change position to top left corner
						initial_x = layer.x;
						initial_y = layer.y;
						layer.x = 0;
						layer.y = 0;

						canvas.width = layer.width;
						canvas.height = layer.height;
					}

					this.Base_layers.convert_layers_to_canvas(ctx, layer.id);

					if (initial_x != null && initial_x != null) {
						//restore position
						layer.x = initial_x;
						layer.y = initial_y;
					}
				} else {
					this.Base_layers.convert_layers_to_canvas(ctx);
				}
			}

			if (type != 'JSON' && (type == 'JPG' || _config2.default.TRANSPARENCY == false)) {
				//add white background
				ctx.globalCompositeOperation = 'destination-over';
				this.fillCanvasBackground(ctx, '#ffffff');
				ctx.globalCompositeOperation = 'source-over';
			}

			//calc size
			if (type == 'PNG') {
				//png
				canvas.toBlob(function (blob) {
					_this.update_file_size(blob.size);
				});
			} else if (type == 'JPG') {
				//jpg
				canvas.toBlob(function (blob) {
					_this.update_file_size(blob.size);
				}, "image/jpeg", quality);
			} else if (type == 'WEBP') {
				//WEBP - new format for chrome only
				var data_header = "image/webp";

				//check support
				if (this.check_format_support(canvas, data_header, false) == false) {
					this.update_file_size('-');
					return;
				}

				canvas.toBlob(function (blob) {
					_this.update_file_size(blob.size);
				}, data_header, quality);
			} else if (type == 'BMP') {
				//bmp
				var data_header = "image/bmp";

				//check support
				if (this.check_format_support(canvas, data_header, false) == false) {
					this.update_file_size('-');
					return;
				}

				canvas.toBlob(function (blob) {
					_this.update_file_size(blob.size);
				}, data_header);
			} else if (type == 'JSON') {
				//json
				var data_json = this.export_as_json();

				var blob = new Blob([data_json], { type: "text/plain" });
				this.update_file_size(blob.size);
			} else if (type == 'GIF') {
				//gif
				this.update_file_size('-');
			}
		}
	}, {
		key: 'save_action',
		value: function save_action(user_response) {
			var fname = user_response.name;
			var only_one_layer = null;
			if (user_response.layers == 'All') only_one_layer = false;else only_one_layer = true;

			var quality = parseInt(user_response.quality);
			if (quality > 100 || quality < 1 || isNaN(quality) == true) quality = 90;
			quality = quality / 100;

			var delay = parseInt(user_response.delay);
			if (delay < 0 || isNaN(delay) == true) delay = 400;

			//detect type
			var type = user_response.type;
			var parts = type.split(" ");
			type = parts[0];

			if (this.Helper.strpos(fname, '.png') !== false) type = 'PNG';else if (this.Helper.strpos(fname, '.jpg') !== false) type = 'JPG';else if (this.Helper.strpos(fname, '.json') !== false) type = 'JSON';else if (this.Helper.strpos(fname, '.bmp') !== false) type = 'BMP';else if (this.Helper.strpos(fname, '.webp') !== false) type = 'WEBP';

			//save type as cookie
			var save_default = this.SAVE_TYPES[0]; //png
			if (this.Helper.getCookie('save_default') == 'jpg') save_default = this.SAVE_TYPES[1]; //jpg
			if (user_response.type != save_default && user_response.type == this.SAVE_TYPES[0]) this.Helper.setCookie('save_default', 'png');else if (user_response.type != save_default && user_response.type == this.SAVE_TYPES[1]) this.Helper.setCookie('save_default', 'jpg');

			if (type != 'JSON') {
				//create temp canvas
				var canvas = document.createElement('canvas');
				var ctx = canvas.getContext("2d");
				canvas.width = _config2.default.WIDTH;
				canvas.height = _config2.default.HEIGHT;
				this.disable_canvas_smooth(ctx);

				//ask data
				if (only_one_layer == true && type != 'GIF' && _config2.default.layer.type != null) {
					//only current layer !!!
					var layer = _config2.default.layer;

					var initial_x = null;
					var initial_y = null;
					if (layer.x != null && layer.y != null && layer.width != null && layer.height != null) {
						//change position to top left corner
						initial_x = layer.x;
						initial_y = layer.y;
						layer.x = 0;
						layer.y = 0;

						canvas.width = layer.width;
						canvas.height = layer.height;
					}

					this.Base_layers.convert_layers_to_canvas(ctx, layer.id);

					if (initial_x != null && initial_x != null) {
						//restore position
						layer.x = initial_x;
						layer.y = initial_y;
					}
				} else {
					this.Base_layers.convert_layers_to_canvas(ctx);
				}
			}

			if (type != 'JSON' && (type == 'JPG' || _config2.default.TRANSPARENCY == false)) {
				//add white background
				ctx.globalCompositeOperation = 'destination-over';
				this.fillCanvasBackground(ctx, '#ffffff');
				ctx.globalCompositeOperation = 'source-over';
			}

			if (type == 'PNG') {
				//png - default format
				if (this.Helper.strpos(fname, '.png') == false) fname = fname + ".png";

				//simple save example
				//var link = document.createElement('a');
				//link.download = fname;
				//link.href = canvas.toDataURL();
				//link.click();

				//save using lib
				canvas.toBlob(function (blob) {
					_FileSaverMin2.default.saveAs(blob, fname);
				});
			} else if (type == 'JPG') {
				//jpg
				if (this.Helper.strpos(fname, '.jpg') == false) fname = fname + ".jpg";

				canvas.toBlob(function (blob) {
					_FileSaverMin2.default.saveAs(blob, fname);
				}, "image/jpeg", quality);
			} else if (type == 'WEBP') {
				//WEBP - new format for chrome only
				if (this.Helper.strpos(fname, '.webp') == false) fname = fname + ".webp";
				var data_header = "image/webp";

				//check support
				if (this.check_format_support(canvas, data_header) == false) return false;

				canvas.toBlob(function (blob) {
					_FileSaverMin2.default.saveAs(blob, fname);
				}, data_header, quality);
			} else if (type == 'BMP') {
				//bmp
				if (this.Helper.strpos(fname, '.bmp') == false) fname = fname + ".bmp";
				var data_header = "image/bmp";

				//check support
				if (this.check_format_support(canvas, data_header) == false) return false;

				canvas.toBlob(function (blob) {
					_FileSaverMin2.default.saveAs(blob, fname);
				}, data_header);
			} else if (type == 'JSON') {
				//json - full data with layers
				if (this.Helper.strpos(fname, '.json') == false) fname = fname + ".json";

				var data_json = this.export_as_json();

				var blob = new Blob([data_json], { type: "text/plain" });
				//var data = window.URL.createObjectURL(blob); //html5
				_FileSaverMin2.default.saveAs(blob, fname);
			} else if (type == 'GIF') {
				//gif
				var cores = navigator.hardwareConcurrency || 4;
				var gif_settings = {
					workers: cores,
					quality: 10, //1-30, lower is better
					repeat: 0,
					width: _config2.default.WIDTH,
					height: _config2.default.HEIGHT,
					dither: 'FloydSteinberg-serpentine',
					workerScript: './src/js/libs/gifjs/gif.worker.js'
				};
				if (_config2.default.TRANSPARENCY == true) {
					gif_settings.transparent = 'rgba(0,0,0,0)';
				}
				var gif = new _gif2.default(gif_settings);

				//add frames
				for (var i = 0; i < _config2.default.layers.length; i++) {
					if (_config2.default.layers[i].visible == false) continue;

					ctx.clearRect(0, 0, _config2.default.WIDTH, _config2.default.HEIGHT);
					if (_config2.default.TRANSPARENCY == false) {
						this.fillCanvasBackground(ctx, '#ffffff');
					}
					this.Base_layers.convert_layers_to_canvas(ctx, _config2.default.layers[i].id);

					gif.addFrame(ctx, { copy: true, delay: delay });
				}
				gif.render();
				gif.on('finished', function (blob) {
					_FileSaverMin2.default.saveAs(blob, fname);
				});
			}
		}
	}, {
		key: 'fillCanvasBackground',
		value: function fillCanvasBackground(ctx, color) {
			var width = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _config2.default.WIDTH;
			var height = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : _config2.default.HEIGHT;

			ctx.beginPath();
			ctx.rect(0, 0, width, height);
			ctx.fillStyle = color;
			ctx.fill();
		}
	}, {
		key: 'check_format_support',
		value: function check_format_support(canvas, data_header, show_error) {
			var data = canvas.toDataURL(data_header);
			var actualType = data.replace(/^data:([^;]*).*/, '$1');

			if (data_header != actualType && data_header != "text/plain") {
				if (show_error == undefined || show_error == true) {
					//error - no support
					_alertifyMin2.default.error('Your browser does not support this format.');
				}
				return false;
			}
			return true;
		}
	}, {
		key: 'export_as_json',
		value: function export_as_json() {
			var export_data = {};

			//get date
			var today = new Date();
			var yyyy = today.getFullYear();
			var mm = today.getMonth() + 1; //January is 0!
			var dd = today.getDate();
			if (dd < 10) dd = '0' + dd;
			if (mm < 10) mm = '0' + mm;
			var today = yyyy + '-' + mm + '-' + dd;

			//data
			var export_data = {};
			export_data.info = {
				width: _config2.default.WIDTH,
				height: _config2.default.HEIGHT,
				about: 'Image data with multi-layers. Can be opened using miniPaint - ' + 'https://github.com/viliusle/miniPaint',
				date: today,
				version: "4.0.1",
				layer_active: _config2.default.layer.id
			};

			//layers
			export_data.layers = [];
			for (var i in _config2.default.layers) {
				var layer = {};
				for (var j in _config2.default.layers[i]) {
					if (j[0] == '_' || j == 'link_canvas') {
						//private data
						continue;
					}

					layer[j] = _config2.default.layers[i][j];
				}
				export_data.layers.push(layer);
			}

			//image data
			export_data.data = [];
			for (var i in _config2.default.layers) {
				if (_config2.default.layers[i].type != 'image') continue;

				var canvas = document.createElement('canvas');
				canvas.width = _config2.default.layers[i].width_original;
				canvas.height = _config2.default.layers[i].height_original;
				this.disable_canvas_smooth(canvas.getContext("2d"));

				canvas.getContext('2d').drawImage(_config2.default.layers[i].link, 0, 0);

				var data_tmp = canvas.toDataURL("image/png");
				export_data.data.push({
					id: _config2.default.layers[i].id,
					data: data_tmp
				});
				canvas.width = 1;
				canvas.height = 1;
			}

			return JSON.stringify(export_data, null, "\t");
		}
	}, {
		key: 'disable_canvas_smooth',
		value: function disable_canvas_smooth(ctx) {
			ctx.webkitImageSmoothingEnabled = false;
			ctx.oImageSmoothingEnabled = false;
			ctx.msImageSmoothingEnabled = false;
			ctx.imageSmoothingEnabled = false;
		}
	}]);

	return File_save_class;
}();

exports.default = File_save_class;

/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(26);


/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(27);

__webpack_require__(30);

__webpack_require__(32);

__webpack_require__(34);

__webpack_require__(36);

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseGui = __webpack_require__(7);

var _baseGui2 = _interopRequireDefault(_baseGui);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseState = __webpack_require__(17);

var _baseState2 = _interopRequireDefault(_baseState);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * miniPaint - https://github.com/viliusle/miniPaint
 * author: Vilius L.
 */

//css
window.onload = function (e) {
	//initiate app
	var Layers = new _baseLayers2.default();
	var Base_tools = new _baseTools2.default(true);
	var GUI = new _baseGui2.default();
	var Base_state = new _baseState2.default();

	//register as global for quick or external access
	window.Layers = Layers;
	window.State = Base_state; // window.State.save();

	//render all
	GUI.load_modules();
	GUI.load_default_values();
	GUI.render_main_gui();

	Layers.init();
};
//js

/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(28);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(11)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {
	// When the styles change, update the <style> tags
	if(!content.locals) {
		module.hot.accept("!!../../node_modules/css-loader/index.js??ref--0-1!./reset.css", function() {
			var newContent = require("!!../../node_modules/css-loader/index.js??ref--0-1!./reset.css");
			if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
			update(newContent);
		});
	}
	// When the module is disposed, remove the <style> tags
	module.hot.dispose(function() { update(); });
}

/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(10)(undefined);
// imports


// module
exports.push([module.i, "*{box-sizing:border-box;background-repeat:no-repeat}:root{--background-color:#424f5a;--background-color-medium:hsla(0,0%,100%,.2);--background-color-light:hsla(0,0%,100%,.3);--background-color-lightest:hsla(0,0%,100%,.5);--background-color-border:rgba(0,0,0,.5);--background-color-active:#419147;--text-color:#000}body{margin:0;padding:0;padding-top:30px;background-color:#424f5a;background-color:var(--background-color);font-size:13px;font-family:Arial,Helvetica,sans-serif;color:#000;color:var(--text-color);line-height:1.4;font-weight:400;overflow:hidden}canvas{outline:none;-webkit-touch-callout:none;-webkit-user-select:none;-khtml-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;-webkit-tap-highlight-color:rgba(255,255,255,0);image-rendering:optimizeSpeed;image-rendering:-moz-crisp-edges;image-rendering:-webkit-optimize-contrast;image-rendering:-o-crisp-edges;image-rendering:pixelated;-ms-interpolation-mode:nearest-neighbor}img{border:none}td,th{vertical-align:top}table{border:0;margin:0;padding:0;vertical-align:baseline;border-collapse:collapse;border-spacing:0;width:100%}hr{border-color:rgba(0,0,0,.3);border-bottom:0}input[type=button],input[type=number],input[type=text],select,textarea{border:1px solid #393939;padding:3px 5px;font-size:13px}input:disabled{opacity:.3}select{padding:2px 4px}input[type=range]{margin-left:0;width:100%}input[type=button]{background:#ddd}input[type=button]:disabled{visibility:hidden}button{border-radius:0;cursor:pointer}label{display:inline-block;vertical-align:top;margin-top:7px}::-webkit-scrollbar{width:12px;height:12px}::-webkit-scrollbar-track-piece{background:rgba(0,0,0,.3)}::-webkit-scrollbar-thumb{background:rgba(0,0,0,.6)}@supports (zoom:2){input[type=checkbox],input[type=radio]{zoom:1.5}}@supports not (zoom:2){input[type=checkbox],input[type=radio]{transform:scale(1.5);margin:8px}}", ""]);

// exports


/***/ }),
/* 29 */
/***/ (function(module, exports) {


/**
 * When source maps are enabled, `style-loader` uses a link element with a data-uri to
 * embed the css on the page. This breaks all relative urls because now they are relative to a
 * bundle instead of the current page.
 *
 * One solution is to only use full urls, but that may be impossible.
 *
 * Instead, this function "fixes" the relative urls to be absolute according to the current page location.
 *
 * A rudimentary test suite is located at `test/fixUrls.js` and can be run via the `npm test` command.
 *
 */

module.exports = function (css) {
  // get current location
  var location = typeof window !== "undefined" && window.location;

  if (!location) {
    throw new Error("fixUrls requires window.location");
  }

	// blank or null?
	if (!css || typeof css !== "string") {
	  return css;
  }

  var baseUrl = location.protocol + "//" + location.host;
  var currentDir = baseUrl + location.pathname.replace(/\/[^\/]*$/, "/");

	// convert each url(...)
	/*
	This regular expression is just a way to recursively match brackets within
	a string.

	 /url\s*\(  = Match on the word "url" with any whitespace after it and then a parens
	   (  = Start a capturing group
	     (?:  = Start a non-capturing group
	         [^)(]  = Match anything that isn't a parentheses
	         |  = OR
	         \(  = Match a start parentheses
	             (?:  = Start another non-capturing groups
	                 [^)(]+  = Match anything that isn't a parentheses
	                 |  = OR
	                 \(  = Match a start parentheses
	                     [^)(]*  = Match anything that isn't a parentheses
	                 \)  = Match a end parentheses
	             )  = End Group
              *\) = Match anything and then a close parens
          )  = Close non-capturing group
          *  = Match anything
       )  = Close capturing group
	 \)  = Match a close parens

	 /gi  = Get all matches, not the first.  Be case insensitive.
	 */
	var fixedCss = css.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi, function(fullMatch, origUrl) {
		// strip quotes (if they exist)
		var unquotedOrigUrl = origUrl
			.trim()
			.replace(/^"(.*)"$/, function(o, $1){ return $1; })
			.replace(/^'(.*)'$/, function(o, $1){ return $1; });

		// already a full url? no change
		if (/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/)/i.test(unquotedOrigUrl)) {
		  return fullMatch;
		}

		// convert the url to a full url
		var newUrl;

		if (unquotedOrigUrl.indexOf("//") === 0) {
		  	//TODO: should we add protocol?
			newUrl = unquotedOrigUrl;
		} else if (unquotedOrigUrl.indexOf("/") === 0) {
			// path should be relative to the base url
			newUrl = baseUrl + unquotedOrigUrl; // already starts with '/'
		} else {
			// path should be relative to current directory
			newUrl = currentDir + unquotedOrigUrl.replace(/^\.\//, ""); // Strip leading './'
		}

		// send back the fixed url(...)
		return "url(" + JSON.stringify(newUrl) + ")";
	});

	// send back the fixed css
	return fixedCss;
};


/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(31);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(11)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {
	// When the styles change, update the <style> tags
	if(!content.locals) {
		module.hot.accept("!!../../node_modules/css-loader/index.js??ref--0-1!./layout.css", function() {
			var newContent = require("!!../../node_modules/css-loader/index.js??ref--0-1!./layout.css");
			if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
			update(newContent);
		});
	}
	// When the module is disposed, remove the <style> tags
	module.hot.dispose(function() { update(); });
}

/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(10)(undefined);
// imports


// module
exports.push([module.i, ".wrapper{height:calc(100vh - 30px);margin:0;position:relative;overflow:hidden}.toggle{cursor:pointer}.hidden{display:none}.pointer{cursor:pointer}.clear{clear:both}.displayBlock{display:block}.bold{font-weight:700}.left{float:left}.right{float:right}.grey{color:grey}.external{padding-right:15px}.external:after{position:absolute;content:\"\";width:10px;height:10px;margin-left:5px;background:url(images/sprites.png) no-repeat -700px 0;opacity:.3}.noselect{-webkit-touch-callout:none;-webkit-user-select:none;-khtml-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.block{background-color:hsla(0,0%,100%,.2);background-color:var(--background-color-medium);border:1px solid rgba(0,0,0,.5);border:1px solid var(--background-color-border);padding:5px;margin-bottom:10px;user-select:none}.block:last-child{margin-bottom:0}.block h2{position:relative;margin:-5px -5px 10px;padding:2px 5px;font-size:110%;background-color:hsla(0,0%,100%,.3);background-color:var(--background-color-light);border-bottom:#555}.block h2:after{position:absolute;content:\"\";height:0;left:0;right:0;bottom:-2px;border-top:1px solid #aaa}.block h2.toggle:before{position:absolute;content:\"\";width:0;height:0;right:10px;top:10px;border-style:solid;border-width:0 5px 6px;border-color:transparent transparent #333}.block h2.toggled:before{border-width:6px 5px 0;border-color:#333 transparent transparent}.error{padding:20px;margin:10px;border:1px solid red;background-color:#fff;width:500px}.error,.logo{font-weight:700}.logo{position:relative;display:inline-block;float:left;height:30px;padding:5px 5px 5px 36px;margin:5px;text-decoration:none;color:#fff}.logo:after{position:absolute;content:\"\";left:0;top:0;width:31px;height:30px;background:url(images/sprites.png) -50px -100px no-repeat}.about-logo,.logo:hover:after{animation:shake .82s cubic-bezier(.36,.07,.19,.97)}.about-logo{margin-left:22%}.about-name{font-size:15px;color:#006900;font-weight:700}@keyframes shake{10%,90%{transform:translate(2px)}20%,80%{transform:translate(5px)}30%,50%,70%{transform:translate(0)}40%,60%{transform:translate(6px)}}.submenu{height:40px;background-color:hsla(0,0%,100%,.2);background-color:var(--background-color-medium);overflow:hidden}.attributes{float:left;width:calc(100% - 115px);height:30px;margin-top:5px;padding:3px 10px 0;border:0}.attributes .item{display:inline-block;margin-right:20px}.attributes input[type=number]{width:60px;margin-right:5px}.attributes button{display:inline-block;padding:3px 10px;border:1px solid #444;background-color:transparent;margin-right:5px}.attributes button:hover{background-color:hsla(0,0%,100%,.3);background-color:var(--background-color-light)}.attributes button.active{background-color:#419147;background-color:var(--background-color-active)}.sidebar_left{position:absolute;left:0;top:45px;width:40px;padding:0 5px;background-color:var(--background-color-medium)}.sidebar_left .item{display:block;background-color:hsla(0,0%,100%,.2);background-color:var(--background-color-medium);background-image:url(images/sprites.png);background-repeat:no-repeat;height:25px;margin:5px 0;overflow:hidden;cursor:pointer}.sidebar_left .item:hover{background-color:hsla(0,0%,100%,.5);background-color:var(--background-color-lightest)}.sidebar_left .item.active{background-color:#419147;background-color:var(--background-color-active)}.sidebar_left .select{background-position:-342px 2px}.sidebar_left .selection{background-position:-43px -47px}.sidebar_left .magic_wand{background-position:-294px -48px}.sidebar_left .brush{background-position:5px 3px}.sidebar_left .erase{background-position:-444px 3px}.sidebar_left .fill{background-position:-145px 2px}.sidebar_left .pick_color{background-position:-644px 3px}.sidebar_left .pencil{background-position:-594px 3px}.sidebar_left .line{background-position:-193px -46px}.sidebar_left .text{background-position:-394px 4px}.sidebar_left .rectangle{background-position:-94px -45px}.sidebar_left .circle{background-position:-547px 2px}.sidebar_left .blur{background-position:-41px 2px}.sidebar_left .sharpen{background-position:6px -47px}.sidebar_left .desaturate{background-position:-195px 3px}.sidebar_left .bulge_pinch{background-position:-93px 5px}.sidebar_left .clone{background-position:-493px 2px}.sidebar_left .gradient{background-position:-243px 5px}.sidebar_left .crop{background-position:-294px 3px}.sidebar_left .animation{background-position:-244px -47px}.sidebar_left .media{background-position:-145px -47px}@media screen and (max-width:550px){#sidebar_left{left:-110px}}.sidebar_right{position:absolute;z-index:2;display:flex;flex-direction:column;right:5px;top:45px;width:200px;height:calc(100vh - 80px);background-color:#424f5a;background-color:var(--background-color);transition:.2s}.sidebar_right.active{right:0!important}.sidebar_right .block.layers{flex:1;overflow-y:auto}.canvas_preview_wrapper{position:relative;height:100px;margin-bottom:10px}.preview canvas{cursor:pointer}.details input{padding:5px 10px}.color_area{border:1px solid #444;width:100%;height:40px;cursor:pointer}.colors .content{margin-top:10px}.main_color_alt{border:1px solid #393939;margin-top:10px;width:100%;height:40px}.main_color_rgb{margin-top:10px}.main_color_rgb div{display:inline-block;width:calc(50% - 3px);vertical-align:top}.hex,.main_color_rgb span{display:inline-block;font-weight:700;width:35px}.main_color_rgb input{width:50px}.main_color_rgb .red{color:#a00}.main_color_rgb .green{color:#0a0}.main_color_rgb .blue{color:#00a}.main_color_rgb .alpha{color:#333}.color_hex{width:calc(100% - 41px)}#all_colors{padding:3px 0 3px 3px}#all_colors,.layers_list{margin-top:10px}.layers_arrow{float:right;margin-left:5px;background-color:hsla(0,0%,100%,.2);background-color:var(--background-color-medium);color:#000;font-size:12px}.layer_add,.layers_arrow{display:inline-block;padding:1px 8px;border:1px solid #444;text-decoration:none}.layer_add{background-color:#419147;background-color:var(--background-color-active);cursor:pointer}.layers_list .item{margin-bottom:2px}.layers_list .layer_name{display:block;padding:1px 5px 3px;height:19px;background-color:#989898;border:1px solid #393939;border-radius:3px;cursor:pointer;overflow:hidden;font-size:12px;color:#333;white-space:nowrap}.layers_list .item.active .layer_name{background-color:#419147;background-color:var(--background-color-active)}.layers_list .visibility{float:left;cursor:pointer;padding:0 3px;margin-right:5px;width:20px;height:19px;background:url(\"images/sprites.png\") no-repeat -148px -99px;opacity:.1}.layers_list .visible{opacity:.4}.layers_list .delete{float:right;cursor:pointer;padding:0 3px;width:12px;height:19px;margin-left:5px;background:url(\"images/sprites.png\") no-repeat -100px -96px}.layers_list .filters{margin-bottom:5px}.layers_list .filter{margin-bottom:2px;margin-left:30px;opacity:.7}.layers_list .filter .layer_name{position:relative}.layers_list .filter .layer_name:after{position:absolute;content:\"fx\";right:-4px;top:1px;bottom:0;width:20px}.sidebar_right .label{display:inline-block;width:60px}.sidebar_right button.extra{border:1px solid #444;background-color:var(--background-color-medium)}.info .toggle.toggled,.toggle-full.toggle.toggled{margin-bottom:-3px}.block.details .row{clear:both;margin-bottom:2px}.block.details input{width:70px;padding:3px 5px}.block.details select{width:calc(100% - 70px);height:23px}.block.details button{height:23px;border:1px solid #444;background-color:var(--background-color-medium)}.block.details button.reset{width:25px;overflow:hidden;opacity:.3;background-image:url(images/sprites.png);background-repeat:no-repeat;background-position:-747px 2px;color:transparent}.block.details button.active{background-color:var(--background-color-active)}@media screen and (max-width:700px){.sidebar_right{right:-200px}.sidebar_right.active{box-shadow:-5px 0 10px 0 rgba(0,0,0,.75)}}.main_wrapper{height:calc(100vh - 80px);margin:5px 210px 5px 45px;overflow:hidden}.canvas_wrapper{position:relative}.canvas_wrapper canvas{position:absolute;border:1px solid #393939;box-sizing:content-box}#mouse{position:absolute;pointer-events:none;width:10px;height:10px;z-index:10}#mouse.circle,#mouse.rect{border:1px solid rgba(0,0,0,.5)}#mouse.circle{border-radius:50%}.transparent-grid{width:100%;height:100%;position:absolute;pointer-events:none;background:url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAQElEQVQ4T2N89+7dfwYigKCgIBGqGBgYRw3EGU6jYYgzaIZAsvn//z9ROeX9+/fE5ZRRA3GG02gY4s4pgz7ZAAAnSWvHPkHXaAAAAABJRU5ErkJggg==\") repeat 0 0;z-index:1;image-rendering:optimizeSpeed;image-rendering:-moz-crisp-edges;image-rendering:-webkit-optimize-contrast;image-rendering:-o-crisp-edges;image-rendering:pixelated;-ms-interpolation-mode:nearest-neighbor}.transparent-grid.white{background:#fff}.transparent-grid.green{background:#5be471}.transparent-grid.grey{background:#dfdfdf}canvas{position:relative;z-index:2}#canvas_back{position:absolute;background-color:#fff;outline:none}#canvas_grid{pointer-events:none}.group{border:1px solid #888;margin:5px 0;padding:5px 8px}.flex-container{display:flex;flex-wrap:wrap}.flex-container .item{flex:auto;margin:2px 0;width:150px}.flex-container .item:empty{height:0;border:none}@media screen and (max-width:700px){body{padding-top:50px}.main_wrapper{margin-right:5px}}@media screen and (max-width:550px){.canvas_wrapper{margin-left:0}}", ""]);

// exports


/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(33);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(11)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {
	// When the styles change, update the <style> tags
	if(!content.locals) {
		module.hot.accept("!!../../node_modules/css-loader/index.js??ref--0-1!./menu.css", function() {
			var newContent = require("!!../../node_modules/css-loader/index.js??ref--0-1!./menu.css");
			if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
			update(newContent);
		});
	}
	// When the module is disposed, remove the <style> tags
	module.hot.dispose(function() { update(); });
}

/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(10)(undefined);
// imports


// module
exports.push([module.i, ".mobile_menu{display:none;position:absolute;width:100%;top:0}.left_mobile_menu,.right_mobile_menu{position:absolute;width:50px;height:50px;background:url(\"images/sprites.png\") no-repeat 11px -86px;filter:invert(1);display:block;top:0;z-index:200;border:0;outline:0;cursor:pointer}.left_mobile_menu{left:0}.right_mobile_menu{right:0}.ddsmoothmenu{position:fixed;top:0;left:0;font:12px Arial,sans-serif;background:#2d2d2d;width:100%;padding-left:10px;z-index:100}.ddsmoothmenu ul{z-index:100;margin:0;padding:0;list-style-type:none;height:30px}.ddsmoothmenu ul li{position:relative;display:inline-block;float:left;color:#2d2b2b;height:100%}.ddsmoothmenu ul ul li a{width:100%}.ddsmoothmenu .rightarrowclass{display:none!important}.ddsmoothmenu ul li a{display:inline-block;color:#2d2d2d;text-decoration:none;color:#ccc;text-align:center;padding:7px 10px 8px!important}.ddsmoothmenu ul ul li a{padding-right:25px!important}.ddsmoothmenu ul li a.selected{background-color:#fff!important;color:#2d2b2b}.ddsmoothmenu ul li ul li a.selected{background-color:#e4ebf8!important}.ddsmoothmenu ul li a:hover{background-color:#e4ebf8;color:#2d2d2d}.ddsmoothmenu .hide_ul,.ddsmoothmenu ul li ul{position:absolute;left:-3000px;display:none;visibility:hidden;border:1px solid #5680c1;border-top:0}.ddsmoothmenu ul li ul{margin-left:-1px;height:auto;min-width:140px;width:auto!important;top:30px!important}.ddsmoothmenu ul li ul li{display:list-item;background:#fff;float:none;height:auto;width:100%}.ddsmoothmenu ul li ul li a{text-align:left}.ddsmoothmenu ul li ul li ul{top:0;border-top:1px solid #5680c1}.ddsmoothmenu ul li ul li a{padding-left:5px;padding-right:5px;margin:0;color:#2d2d2d;white-space:nowrap}.ddsmoothmenu ul li ul li ul{top:0!important}.ddsmoothmenu .downarrowclass{position:absolute;top:12px;right:7px}.ddsmoothmenu .ddshadow{position:absolute;left:0;top:0;width:0;height:0;background-color:#ccc}.ddsmoothmenu .mid-line{background-color:red;border-top:1px solid #e5e5e5;font-size:0;padding:0 8px}.ddsmoothmenu ul li ul li.more>a{position:relative}.ddsmoothmenu ul li ul li.more>a:before{position:absolute;content:\">\";right:9px;width:5px;height:14px;transform:scaleY(2);color:gray}.ddsmoothmenu ul li ul li ul{left:calc(100% + 1px)!important}.ddsmoothmenu .dots:after{content:\" ...\"}.ddsmoothmenu a[data-key]:after{position:absolute;content:attr(data-key) \" \";color:#aaa;font-size:12px;margin-left:8px;right:10px}@media screen and (max-width:700px){.mobile_menu{display:block}.left_mobile_menu{display:none}.ddsmoothmenu{height:50px}.ddsmoothmenu ul{width:calc(100% - 50px);height:50px}.ddsmoothmenu>ul>li>a{height:50px;padding-top:15px!important}.ddsmoothmenu ul li ul{top:50px!important}.ddsmoothmenu ul li ul li{height:auto}.ddsmoothmenu ul li ul li a{height:30px}}@media screen and (max-width:550px){.ddsmoothmenu{padding-left:0}.ddsmoothmenu ul{width:calc(100% - 50px)}.ddsmoothmenu>ul>li{width:14.28571%}.ddsmoothmenu>ul>li>a{width:100%;padding-left:3px!important;padding-right:3px!important;overflow:hidden}.left_mobile_menu{display:block}}", ""]);

// exports


/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(35);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(11)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {
	// When the styles change, update the <style> tags
	if(!content.locals) {
		module.hot.accept("!!../../node_modules/css-loader/index.js??ref--0-1!./print.css", function() {
			var newContent = require("!!../../node_modules/css-loader/index.js??ref--0-1!./print.css");
			if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
			update(newContent);
		});
	}
	// When the module is disposed, remove the <style> tags
	module.hot.dispose(function() { update(); });
}

/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(10)(undefined);
// imports


// module
exports.push([module.i, "@media print{body{background:none!important;background:#fff;background-color:#fff;font-family:Arial,Helvetica,Verdana;width:auto!important;padding:5px!important;font-size:12px}.ddsmoothmenu,.menu,.sidebar_left,.sidebar_right,.submenu,progress{display:none;height:0;width:0}.main_wrapper{margin:0;padding:0}canvas{position:absolute;top:0;left:0}.canvas_wrapper canvas,canvas{border:0}}", ""]);

// exports


/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(37);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(11)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {
	// When the styles change, update the <style> tags
	if(!content.locals) {
		module.hot.accept("!!../../../css-loader/index.js??ref--0-1!./alertify.min.css", function() {
			var newContent = require("!!../../../css-loader/index.js??ref--0-1!./alertify.min.css");
			if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
			update(newContent);
		});
	}
	// When the module is disposed, remove the <style> tags
	module.hot.dispose(function() { update(); });
}

/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(10)(undefined);
// imports


// module
exports.push([module.i, ".alertify .ajs-dimmer{margin:0;background-color:#252525;opacity:.5}.alertify .ajs-dimmer,.alertify .ajs-modal{position:fixed;z-index:1981;top:0;right:0;bottom:0;left:0;padding:0}.alertify .ajs-modal{overflow-y:auto}.alertify .ajs-dialog{position:relative;margin:5% auto;min-height:110px;max-width:500px;padding:24px 24px 0;outline:0;background-color:#fff}.alertify .ajs-dialog.ajs-capture:before{content:\"\";position:absolute;top:0;right:0;bottom:0;left:0;display:block;z-index:1}.alertify .ajs-reset{position:absolute!important;display:inline!important;width:0!important;height:0!important;opacity:0!important}.alertify .ajs-commands{position:absolute;right:4px;margin:-14px 24px 0 0;z-index:2}.alertify .ajs-commands button{display:none;width:10px;height:10px;margin-left:10px;padding:10px;border:0;background-color:transparent;background-repeat:no-repeat;background-position:50%;cursor:pointer}.alertify .ajs-commands button.ajs-close{background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAKCAYAAACNMs+9AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABZ0RVh0Q3JlYXRpb24gVGltZQAwNy8xMy8xNOrZqugAAAAcdEVYdFNvZnR3YXJlAEFkb2JlIEZpcmV3b3JrcyBDUzbovLKMAAAAh0lEQVQYlY2QsQ0EIQwEB9cBAR1CJUaI/gigDnwR6NBL/7/xWLNrZ2b8EwGotVpr7eOitWa1VjugiNB7R1UPrKrWe0dEAHBbXUqxMQbeewDmnHjvyTm7C3zDwAUd9c63YQdUVdu6EAJzzquz7HXvTiklt+H9DQFYaxFjvDqllFyMkbXWvfpXHjJrWFgdBq/hAAAAAElFTkSuQmCC)}.alertify .ajs-commands button.ajs-maximize{background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAKCAYAAACNMs+9AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABZ0RVh0Q3JlYXRpb24gVGltZQAwNy8xMy8xNOrZqugAAAAcdEVYdFNvZnR3YXJlAEFkb2JlIEZpcmV3b3JrcyBDUzbovLKMAAAAOUlEQVQYlWP8//8/AzGAhYGBgaG4uBiv6t7eXkYmooxjYGAgWiELsvHYFMCcRX2rSXcjoSBiJDbAAeD+EGu+8BZcAAAAAElFTkSuQmCC)}.alertify .ajs-header{margin:-24px;margin-bottom:0;padding:16px 24px;background-color:#fff}.alertify .ajs-body{min-height:56px}.alertify .ajs-body .ajs-content{padding:16px 24px 16px 16px}.alertify .ajs-footer{padding:4px;margin-left:-24px;margin-right:-24px;min-height:43px;background-color:#fff}.alertify .ajs-footer .ajs-buttons.ajs-primary{text-align:right}.alertify .ajs-footer .ajs-buttons.ajs-primary .ajs-button{margin:4px}.alertify .ajs-footer .ajs-buttons.ajs-auxiliary{float:left;clear:none;text-align:left}.alertify .ajs-footer .ajs-buttons.ajs-auxiliary .ajs-button{margin:4px}.alertify .ajs-footer .ajs-buttons .ajs-button{min-width:88px;min-height:35px}.alertify .ajs-handle{position:absolute;display:none;width:10px;height:10px;right:0;bottom:0;z-index:1;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAKCAYAAACNMs+9AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABZ0RVh0Q3JlYXRpb24gVGltZQAwNy8xMS8xNEDQYmMAAAAcdEVYdFNvZnR3YXJlAEFkb2JlIEZpcmV3b3JrcyBDUzbovLKMAAAAQ0lEQVQYlaXNMQoAIAxD0dT7H657l0KX3iJuUlBUNOsPPCGJm7VDp6ryeMxMuDsAQH7owW3pyn3RS26iKxERMLN3ugOaAkaL3sWVigAAAABJRU5ErkJggg==);-webkit-transform:scaleX(1);transform:scaleX(1);cursor:se-resize}.alertify.ajs-no-overflow .ajs-body .ajs-content{overflow:hidden!important}.alertify.ajs-no-padding.ajs-maximized .ajs-body .ajs-content{left:0;right:0;padding:0}.alertify.ajs-no-padding:not(.ajs-maximized) .ajs-body{margin-left:-24px;margin-right:-24px}.alertify.ajs-no-padding:not(.ajs-maximized) .ajs-body .ajs-content{padding:0}.alertify.ajs-no-padding.ajs-resizable .ajs-body .ajs-content{left:0;right:0}.alertify.ajs-closable .ajs-commands button.ajs-close,.alertify.ajs-maximizable .ajs-commands button.ajs-maximize,.alertify.ajs-maximizable .ajs-commands button.ajs-restore{display:inline-block}.alertify.ajs-maximized .ajs-dialog{width:100%!important;height:100%!important;max-width:none!important;margin:0 auto!important;top:0!important;left:0!important}.alertify.ajs-maximized.ajs-modeless .ajs-modal{position:fixed!important;min-height:100%!important;max-height:none!important;margin:0!important}.alertify.ajs-maximized .ajs-commands button.ajs-maximize{background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAKCAYAAACNMs+9AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABZ0RVh0Q3JlYXRpb24gVGltZQAwNy8xMy8xNOrZqugAAAAcdEVYdFNvZnR3YXJlAEFkb2JlIEZpcmV3b3JrcyBDUzbovLKMAAAASklEQVQYlZWQ0QkAMQhDtXRincOZX78KVtrDCwgqJNEoIB3MPLj7lRUROlpyVXGzby6zWuY+kz6tj5sBMTMAyVV3/595RbOh3cAXsww1raeiOcoAAAAASUVORK5CYII=)}.alertify.ajs-maximized .ajs-dialog,.alertify.ajs-resizable .ajs-dialog{padding:0}.alertify.ajs-maximized .ajs-commands,.alertify.ajs-resizable .ajs-commands{margin:14px 24px 0 0}.alertify.ajs-maximized .ajs-header,.alertify.ajs-resizable .ajs-header{position:absolute;top:0;left:0;right:0;margin:0;padding:16px 24px}.alertify.ajs-maximized .ajs-body,.alertify.ajs-resizable .ajs-body{min-height:224px;display:inline-block}.alertify.ajs-maximized .ajs-body .ajs-content,.alertify.ajs-resizable .ajs-body .ajs-content{position:absolute;top:50px;right:24px;bottom:50px;left:24px;overflow:auto}.alertify.ajs-maximized .ajs-footer,.alertify.ajs-resizable .ajs-footer{position:absolute;left:0;right:0;bottom:0;margin:0}.alertify.ajs-resizable:not(.ajs-maximized) .ajs-dialog{min-width:548px}.alertify.ajs-resizable:not(.ajs-maximized) .ajs-handle{display:block}.alertify.ajs-movable:not(.ajs-maximized) .ajs-header{cursor:move}.alertify.ajs-modeless .ajs-dimmer,.alertify.ajs-modeless .ajs-reset{display:none}.alertify.ajs-modeless .ajs-modal{overflow:visible;max-width:none;max-height:0}.alertify.ajs-modeless.ajs-pinnable .ajs-commands button.ajs-pin{display:inline-block;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAKCAYAAACNMs+9AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABZ0RVh0Q3JlYXRpb24gVGltZQAwNy8xMy8xNOrZqugAAAAcdEVYdFNvZnR3YXJlAEFkb2JlIEZpcmV3b3JrcyBDUzbovLKMAAAAQklEQVQYlcWPMQ4AIAwCqU9u38GbcbHRWN1MvKQDhQFMEpKImGJA0gCgnYw0V0rwxseg5erT4oSkQVI5d9f+e9+xA0NbLpWfitPXAAAAAElFTkSuQmCC)}.alertify.ajs-modeless.ajs-unpinned .ajs-modal{position:absolute}.alertify.ajs-modeless.ajs-unpinned .ajs-commands button.ajs-pin{background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAKCAYAAACNMs+9AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABZ0RVh0Q3JlYXRpb24gVGltZQAwNy8xMy8xNOrZqugAAAAcdEVYdFNvZnR3YXJlAEFkb2JlIEZpcmV3b3JrcyBDUzbovLKMAAAAO0lEQVQYlWP8//8/AzGAiShV6AqLi4txGs+CLoBLMYbC3t5eRmyaWfBZhwwYkX2NTxPRvibKjRhW4wMAhxkYGbLu3pEAAAAASUVORK5CYII=)}.alertify.ajs-modeless:not(.ajs-unpinned) .ajs-body{max-height:500px;overflow:auto}.alertify.ajs-basic .ajs-header{opacity:0}.alertify.ajs-basic .ajs-footer{visibility:hidden}.alertify.ajs-frameless .ajs-header{position:absolute;top:0;left:0;right:0;min-height:60px;margin:0;padding:0;opacity:0;z-index:1}.alertify.ajs-frameless .ajs-footer{display:none}.alertify.ajs-frameless .ajs-body .ajs-content{position:absolute;top:0;right:0;bottom:0;left:0}.alertify.ajs-frameless:not(.ajs-resizable) .ajs-dialog{padding-top:0}.alertify.ajs-frameless:not(.ajs-resizable) .ajs-dialog .ajs-commands{margin-top:0}.ajs-no-overflow{overflow:hidden!important;outline:0}.ajs-no-overflow.ajs-fixed{position:fixed;top:0;right:0;bottom:0;left:0;overflow-y:scroll!important}.ajs-no-selection,.ajs-no-selection *{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}@media screen and (max-width:568px){.alertify .ajs-dialog{min-width:150px}.alertify:not(.ajs-maximized) .ajs-modal{padding:0 5%}.alertify:not(.ajs-maximized).ajs-resizable .ajs-dialog{min-width:0;min-width:auto}}@-moz-document url-prefix(){.alertify button:focus{outline:1px dotted #3593d2}}.alertify .ajs-dimmer,.alertify .ajs-modal{-webkit-transform:translateZ(0);transform:translateZ(0);-webkit-transition-property:opacity,visibility;transition-property:opacity,visibility;-webkit-transition-timing-function:linear;transition-timing-function:linear;-webkit-transition-duration:.25s;transition-duration:.25s}.alertify.ajs-hidden .ajs-dimmer,.alertify.ajs-hidden .ajs-modal{visibility:hidden;opacity:0}.alertify.ajs-in:not(.ajs-hidden) .ajs-dialog{-webkit-animation-duration:.5s;animation-duration:.5s}.alertify.ajs-out.ajs-hidden .ajs-dialog{-webkit-animation-duration:.25s;animation-duration:.25s}.alertify .ajs-dialog.ajs-shake{-webkit-animation-name:ajs-shake;animation-name:ajs-shake;-webkit-animation-duration:.1s;animation-duration:.1s;-webkit-animation-fill-mode:both;animation-fill-mode:both}@-webkit-keyframes ajs-shake{0%,to{-webkit-transform:translateZ(0);transform:translateZ(0)}10%,30%,50%,70%,90%{-webkit-transform:translate3d(-10px,0,0);transform:translate3d(-10px,0,0)}20%,40%,60%,80%{-webkit-transform:translate3d(10px,0,0);transform:translate3d(10px,0,0)}}@keyframes ajs-shake{0%,to{-webkit-transform:translateZ(0);transform:translateZ(0)}10%,30%,50%,70%,90%{-webkit-transform:translate3d(-10px,0,0);transform:translate3d(-10px,0,0)}20%,40%,60%,80%{-webkit-transform:translate3d(10px,0,0);transform:translate3d(10px,0,0)}}.alertify.ajs-slide.ajs-in:not(.ajs-hidden) .ajs-dialog{-webkit-animation-name:ajs-slideIn;animation-name:ajs-slideIn;-webkit-animation-timing-function:cubic-bezier(.175,.885,.32,1.275);animation-timing-function:cubic-bezier(.175,.885,.32,1.275)}.alertify.ajs-slide.ajs-out.ajs-hidden .ajs-dialog{-webkit-animation-name:ajs-slideOut;animation-name:ajs-slideOut;-webkit-animation-timing-function:cubic-bezier(.6,-.28,.735,.045);animation-timing-function:cubic-bezier(.6,-.28,.735,.045)}.alertify.ajs-zoom.ajs-in:not(.ajs-hidden) .ajs-dialog{-webkit-animation-name:ajs-zoomIn;animation-name:ajs-zoomIn}.alertify.ajs-zoom.ajs-out.ajs-hidden .ajs-dialog{-webkit-animation-name:ajs-zoomOut;animation-name:ajs-zoomOut}.alertify.ajs-fade.ajs-in:not(.ajs-hidden) .ajs-dialog{-webkit-animation-name:ajs-fadeIn;animation-name:ajs-fadeIn}.alertify.ajs-fade.ajs-out.ajs-hidden .ajs-dialog{-webkit-animation-name:ajs-fadeOut;animation-name:ajs-fadeOut}.alertify.ajs-pulse.ajs-in:not(.ajs-hidden) .ajs-dialog{-webkit-animation-name:ajs-pulseIn;animation-name:ajs-pulseIn}.alertify.ajs-pulse.ajs-out.ajs-hidden .ajs-dialog{-webkit-animation-name:ajs-pulseOut;animation-name:ajs-pulseOut}.alertify.ajs-flipx.ajs-in:not(.ajs-hidden) .ajs-dialog{-webkit-animation-name:ajs-flipInX;animation-name:ajs-flipInX}.alertify.ajs-flipx.ajs-out.ajs-hidden .ajs-dialog{-webkit-animation-name:ajs-flipOutX;animation-name:ajs-flipOutX}.alertify.ajs-flipy.ajs-in:not(.ajs-hidden) .ajs-dialog{-webkit-animation-name:ajs-flipInY;animation-name:ajs-flipInY}.alertify.ajs-flipy.ajs-out.ajs-hidden .ajs-dialog{-webkit-animation-name:ajs-flipOutY;animation-name:ajs-flipOutY}@-webkit-keyframes ajs-pulseIn{0%,20%,40%,60%,80%,to{-webkit-transition-timing-function:cubic-bezier(.215,.61,.355,1);transition-timing-function:cubic-bezier(.215,.61,.355,1)}0%{opacity:0;-webkit-transform:scale3d(.3,.3,.3);transform:scale3d(.3,.3,.3)}20%{-webkit-transform:scale3d(1.1,1.1,1.1);transform:scale3d(1.1,1.1,1.1)}40%{-webkit-transform:scale3d(.9,.9,.9);transform:scale3d(.9,.9,.9)}60%{opacity:1;-webkit-transform:scale3d(1.03,1.03,1.03);transform:scale3d(1.03,1.03,1.03)}80%{-webkit-transform:scale3d(.97,.97,.97);transform:scale3d(.97,.97,.97)}to{opacity:1;-webkit-transform:scaleX(1);transform:scaleX(1)}}@keyframes ajs-pulseIn{0%,20%,40%,60%,80%,to{-webkit-transition-timing-function:cubic-bezier(.215,.61,.355,1);transition-timing-function:cubic-bezier(.215,.61,.355,1)}0%{opacity:0;-webkit-transform:scale3d(.3,.3,.3);transform:scale3d(.3,.3,.3)}20%{-webkit-transform:scale3d(1.1,1.1,1.1);transform:scale3d(1.1,1.1,1.1)}40%{-webkit-transform:scale3d(.9,.9,.9);transform:scale3d(.9,.9,.9)}60%{opacity:1;-webkit-transform:scale3d(1.03,1.03,1.03);transform:scale3d(1.03,1.03,1.03)}80%{-webkit-transform:scale3d(.97,.97,.97);transform:scale3d(.97,.97,.97)}to{opacity:1;-webkit-transform:scaleX(1);transform:scaleX(1)}}@-webkit-keyframes ajs-pulseOut{20%{-webkit-transform:scale3d(.9,.9,.9);transform:scale3d(.9,.9,.9)}50%,55%{opacity:1;-webkit-transform:scale3d(1.1,1.1,1.1);transform:scale3d(1.1,1.1,1.1)}to{opacity:0;-webkit-transform:scale3d(.3,.3,.3);transform:scale3d(.3,.3,.3)}}@keyframes ajs-pulseOut{20%{-webkit-transform:scale3d(.9,.9,.9);transform:scale3d(.9,.9,.9)}50%,55%{opacity:1;-webkit-transform:scale3d(1.1,1.1,1.1);transform:scale3d(1.1,1.1,1.1)}to{opacity:0;-webkit-transform:scale3d(.3,.3,.3);transform:scale3d(.3,.3,.3)}}@-webkit-keyframes ajs-zoomIn{0%{opacity:0;-webkit-transform:scale3d(.25,.25,.25);transform:scale3d(.25,.25,.25)}to{opacity:1;-webkit-transform:scaleX(1);transform:scaleX(1)}}@keyframes ajs-zoomIn{0%{opacity:0;-webkit-transform:scale3d(.25,.25,.25);transform:scale3d(.25,.25,.25)}to{opacity:1;-webkit-transform:scaleX(1);transform:scaleX(1)}}@-webkit-keyframes ajs-zoomOut{0%{opacity:1;-webkit-transform:scaleX(1);transform:scaleX(1)}to{opacity:0;-webkit-transform:scale3d(.25,.25,.25);transform:scale3d(.25,.25,.25)}}@keyframes ajs-zoomOut{0%{opacity:1;-webkit-transform:scaleX(1);transform:scaleX(1)}to{opacity:0;-webkit-transform:scale3d(.25,.25,.25);transform:scale3d(.25,.25,.25)}}@-webkit-keyframes ajs-fadeIn{0%{opacity:0}to{opacity:1}}@keyframes ajs-fadeIn{0%{opacity:0}to{opacity:1}}@-webkit-keyframes ajs-fadeOut{0%{opacity:1}to{opacity:0}}@keyframes ajs-fadeOut{0%{opacity:1}to{opacity:0}}@-webkit-keyframes ajs-flipInX{0%{-webkit-transform:perspective(400px) rotateX(90deg);transform:perspective(400px) rotateX(90deg);-webkit-transition-timing-function:ease-in;transition-timing-function:ease-in;opacity:0}40%{-webkit-transform:perspective(400px) rotateX(-20deg);transform:perspective(400px) rotateX(-20deg);-webkit-transition-timing-function:ease-in;transition-timing-function:ease-in}60%{-webkit-transform:perspective(400px) rotateX(10deg);transform:perspective(400px) rotateX(10deg);opacity:1}80%{-webkit-transform:perspective(400px) rotateX(-5deg);transform:perspective(400px) rotateX(-5deg)}to{-webkit-transform:perspective(400px);transform:perspective(400px)}}@keyframes ajs-flipInX{0%{-webkit-transform:perspective(400px) rotateX(90deg);transform:perspective(400px) rotateX(90deg);-webkit-transition-timing-function:ease-in;transition-timing-function:ease-in;opacity:0}40%{-webkit-transform:perspective(400px) rotateX(-20deg);transform:perspective(400px) rotateX(-20deg);-webkit-transition-timing-function:ease-in;transition-timing-function:ease-in}60%{-webkit-transform:perspective(400px) rotateX(10deg);transform:perspective(400px) rotateX(10deg);opacity:1}80%{-webkit-transform:perspective(400px) rotateX(-5deg);transform:perspective(400px) rotateX(-5deg)}to{-webkit-transform:perspective(400px);transform:perspective(400px)}}@-webkit-keyframes ajs-flipOutX{0%{-webkit-transform:perspective(400px);transform:perspective(400px)}30%{-webkit-transform:perspective(400px) rotateX(-20deg);transform:perspective(400px) rotateX(-20deg);opacity:1}to{-webkit-transform:perspective(400px) rotateX(90deg);transform:perspective(400px) rotateX(90deg);opacity:0}}@keyframes ajs-flipOutX{0%{-webkit-transform:perspective(400px);transform:perspective(400px)}30%{-webkit-transform:perspective(400px) rotateX(-20deg);transform:perspective(400px) rotateX(-20deg);opacity:1}to{-webkit-transform:perspective(400px) rotateX(90deg);transform:perspective(400px) rotateX(90deg);opacity:0}}@-webkit-keyframes ajs-flipInY{0%{-webkit-transform:perspective(400px) rotateY(90deg);transform:perspective(400px) rotateY(90deg);-webkit-transition-timing-function:ease-in;transition-timing-function:ease-in;opacity:0}40%{-webkit-transform:perspective(400px) rotateY(-20deg);transform:perspective(400px) rotateY(-20deg);-webkit-transition-timing-function:ease-in;transition-timing-function:ease-in}60%{-webkit-transform:perspective(400px) rotateY(10deg);transform:perspective(400px) rotateY(10deg);opacity:1}80%{-webkit-transform:perspective(400px) rotateY(-5deg);transform:perspective(400px) rotateY(-5deg)}to{-webkit-transform:perspective(400px);transform:perspective(400px)}}@keyframes ajs-flipInY{0%{-webkit-transform:perspective(400px) rotateY(90deg);transform:perspective(400px) rotateY(90deg);-webkit-transition-timing-function:ease-in;transition-timing-function:ease-in;opacity:0}40%{-webkit-transform:perspective(400px) rotateY(-20deg);transform:perspective(400px) rotateY(-20deg);-webkit-transition-timing-function:ease-in;transition-timing-function:ease-in}60%{-webkit-transform:perspective(400px) rotateY(10deg);transform:perspective(400px) rotateY(10deg);opacity:1}80%{-webkit-transform:perspective(400px) rotateY(-5deg);transform:perspective(400px) rotateY(-5deg)}to{-webkit-transform:perspective(400px);transform:perspective(400px)}}@-webkit-keyframes ajs-flipOutY{0%{-webkit-transform:perspective(400px);transform:perspective(400px)}30%{-webkit-transform:perspective(400px) rotateY(-15deg);transform:perspective(400px) rotateY(-15deg);opacity:1}to{-webkit-transform:perspective(400px) rotateY(90deg);transform:perspective(400px) rotateY(90deg);opacity:0}}@keyframes ajs-flipOutY{0%{-webkit-transform:perspective(400px);transform:perspective(400px)}30%{-webkit-transform:perspective(400px) rotateY(-15deg);transform:perspective(400px) rotateY(-15deg);opacity:1}to{-webkit-transform:perspective(400px) rotateY(90deg);transform:perspective(400px) rotateY(90deg);opacity:0}}@-webkit-keyframes ajs-slideIn{0%{margin-top:-100%}to{margin-top:5%}}@keyframes ajs-slideIn{0%{margin-top:-100%}to{margin-top:5%}}@-webkit-keyframes ajs-slideOut{0%{margin-top:5%}to{margin-top:-100%}}@keyframes ajs-slideOut{0%{margin-top:5%}to{margin-top:-100%}}.alertify-notifier{position:fixed;width:0;overflow:visible;z-index:1982}.alertify-notifier,.alertify-notifier .ajs-message{-webkit-transform:translateZ(0);transform:translateZ(0)}.alertify-notifier .ajs-message{position:relative;width:260px;max-height:0;padding:0;opacity:0;margin:0;-webkit-transition-duration:.25s;transition-duration:.25s;-webkit-transition-timing-function:linear;transition-timing-function:linear}.alertify-notifier .ajs-message.ajs-visible{-webkit-transition-duration:.5s;transition-duration:.5s;-webkit-transition-timing-function:cubic-bezier(.175,.885,.32,1.275);transition-timing-function:cubic-bezier(.175,.885,.32,1.275);opacity:1;max-height:100%;padding:15px;margin-top:10px}.alertify-notifier .ajs-message.ajs-success{background:rgba(91,189,114,.95)}.alertify-notifier .ajs-message.ajs-error{background:rgba(217,92,92,.95)}.alertify-notifier .ajs-message.ajs-warning{background:hsla(54,86%,92%,.95)}.alertify-notifier .ajs-message .ajs-close{position:absolute;top:0;right:0;width:16px;height:16px;cursor:pointer;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAABGdBTUEAALGPC/xhBQAAAFBJREFUGBl1j0EKADEIA+ve/P9f9bh1hEihNBfjVCO1v7RKVqJK4h8gM5cAPR42AkQEpSXPwMTyoi13n5N9YqJehm3Fnr7nL1D0ZEbD5OubGyC7a9gx+9eNAAAAAElFTkSuQmCC);background-repeat:no-repeat;background-position:50%;background-color:rgba(0,0,0,.5);border-top-right-radius:2px}.alertify-notifier.ajs-top{top:10px}.alertify-notifier.ajs-bottom{bottom:10px}.alertify-notifier.ajs-right{right:10px}.alertify-notifier.ajs-right .ajs-message{right:-320px}.alertify-notifier.ajs-right .ajs-message.ajs-visible{right:290px}.alertify-notifier.ajs-left{left:10px}.alertify-notifier.ajs-left .ajs-message{left:-300px}.alertify-notifier.ajs-left .ajs-message.ajs-visible{left:0}.alertify-notifier.ajs-center{left:50%}.alertify-notifier.ajs-center .ajs-message{-webkit-transform:translateX(-50%);transform:translateX(-50%)}.alertify-notifier.ajs-center .ajs-message.ajs-visible{left:50%;-webkit-transition-timing-function:cubic-bezier(.57,.43,.1,.65);transition-timing-function:cubic-bezier(.57,.43,.1,.65)}.alertify-notifier.ajs-center.ajs-top .ajs-message{top:-300px}.alertify-notifier.ajs-center.ajs-top .ajs-message.ajs-visible{top:0}.alertify-notifier.ajs-center.ajs-bottom .ajs-message{bottom:-300px}.alertify-notifier.ajs-center.ajs-bottom .ajs-message.ajs-visible{bottom:0}", ""]);

// exports


/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(jQuery) {

// https://github.com/jorgejeferson/translate.js/tree/39be8237666a76035fc210a28d8e431f1416579e
(function ($) {
	$.fn.translate = function (options) {
		var that = this; //a reference to ourselves
		var settings = {
			css: "trn",
			attrs: ["alt", "placeholder", "title"],
			lang: "pt",
			langDefault: "pt"
		};
		settings = $.extend(settings, options || {});
		if (settings.css.lastIndexOf(".", 0) !== 0) {
			//doesn't start with '.'
			settings.css = "." + settings.css;
		}
		var t = settings.t;
		//public methods
		this.lang = function (l) {
			if (l) {
				settings.lang = l;
				this.translate(settings); //translate everything
			}
			return settings.lang;
		};
		this.get = function (index) {
			var res = index;

			try {
				res = t[index][settings.lang];
			} catch (err) {
				//not found, return index
				return index;
			}
			if (res) {
				return res;
			} else {
				return index;
			}
		};
		this.g = this.get;
		//main
		this.find(settings.css).each(function (i) {
			var $this = $(this);

			var trn_key = $this.attr("data-trn-key");
			if (!trn_key) {
				trn_key = $this.html();
				$this.attr("data-trn-key", trn_key);
			}
			// Filtering attr
			$.each(this.attributes, function () {
				if ($.inArray(this.name, settings.attrs) !== -1) {
					var trn_attr_key = $this.attr("data-trn-attr");
					if (!trn_attr_key) {
						trn_attr_key = $this.attr(this.name);
						$this.attr("data-trn-attr", trn_attr_key);
					}
					$this.attr(this.name, that.get(trn_attr_key));
				}
			});
			$this.html(that.get(trn_key));
		});
		return this;
	};
})(jQuery);
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(14)))

/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

var map = {
	"./de.json": 40,
	"./empty.json": 41,
	"./es.json": 42,
	"./fr.json": 43,
	"./it.json": 44,
	"./ja.json": 45,
	"./ko.json": 46,
	"./lt.json": 47,
	"./pt.json": 48,
	"./ru.json": 49,
	"./tr.json": 50,
	"./zh.json": 51
};
function webpackContext(req) {
	return __webpack_require__(webpackContextResolve(req));
};
function webpackContextResolve(req) {
	var id = map[req];
	if(!(id + 1)) // check for number or string
		throw new Error("Cannot find module '" + req + "'.");
	return id;
};
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = 39;

/***/ }),
/* 40 */
/***/ (function(module, exports) {

module.exports = {"2d":"2d","480p":"480p","About":"Über","Active":"Aktiv","Advanced":"Fortgeschritten","All":"Alle","Alpha:":"Alpha:","Anonymous":"Anonym","Anti aliasing":"Kantenglättung","Arial":"Arial","Arrow":"Pfeil","Author:":"Autor:","Auto adjust colors":"Stellen Sie die Farben automatisch ein","Average:":"Durchschnittlich:","BMP - Windows Bitmap":"BMP - Windows-Bitmap","Base":"Base","Basic":"Basic","Black and White":"Schwarz und weiß","Blue":"Blau","Blue channel:":"Blauer Kanal:","Blue:":"Blau:","Blur Radius:":"Weichzeichner-Radius:","Blur power:":"Weichzeichner:","Blur tool":"Weichzeichner","Bold":"Fett gedruckt","Bold Italic":"Fett Kursiv","Borders":"Grenzen","Box Blur":"Box Unschärfe","Box blur":"Box Unschärfe","Brightness":"Helligkeit","Brightness:":"Helligkeit:","Brush":"Bürste","Bulge/Pinch tool":"Ausbuchtung / Pinch-Werkzeug","Burn":"Brennen","CSS filters":"CSS-Filter","Can not animate 1 layer.":"1 Schicht kann nicht animiert werden.","Can not find previous layer.":"Die vorherige Ebene kann nicht gefunden werden.","Cancel":"Stornieren","Center":"Center","Center x:":"Mitte x:","Center y:":"Mitte y:","Center:":"Center:","Channel:":"Kanal:","Circle":"Kreis","Clear":"klar","Clone count:":"Klonanzahl:","Clone tool":"Klonwerkzeug","Cloned edges":"Klonierte Kanten","Color #":"Farbe #","Color Zoom":"Farbzoom","Color alpha value can not be zero.":"Farb-Alpha-Wert kann nicht Null sein.","Color corrections":"Farbkorrekturen","Color palette":"Farbpalette","Color to alpha":"Farbe zu Alpha","Color zoom":"Farbzoom","Color:":"Farbe:","Colors":"Farben","Colors:":"Farben:","Composition":"Zusammensetzung","Composition:":"Zusammensetzung:","Content fill":"Inhalt ausfüllen","Contrast":"Kontrast","Contrast:":"Kontrast:","Convert to raster":"In Raster konvertieren","Copy selection":"Auswahl kopieren","Copy:":"Kopieren:","Courier":"Kurier","Crop":"Ernte","Ctrl+V":"Strg + V","Ctrl-P":"Strg-P","Current":"Strom","Curve":"Kurve","Custom":"Brauch","Data URL":"Daten-URL","Data URL:":"Daten-URL:","Decrease color depth":"Verringern Sie die Farbtiefe","Default":"Standard","Degree:":"Grad:","Del":"Del","Delete":"Löschen","Delete selection":"Auswahl löschen","Denoise":"Denoise","Desaturate":"Entsättigen","Description:":"Beschreibung:","Differences":"Unterschiede","Differences Down":"Unterschiede nach unten","Dither":"Dither","Dithering:":"Dithering:","Dominant color:":"Dominierende Farbe:","Dot Screen":"Punkt-Bildschirm","Down":"Nieder","Duplicate":"Duplikat","Edge":"Kante","Edit":"Bearbeiten","Edit text":"Text bearbeiten","Edit text...":"Text bearbeiten...","Effects":"Auswirkungen","Email:":"Email:","Emboss":"Prägen","Empty selection":"Leere Auswahl","Empty selection or type not image.":"Leere Auswahl oder geben Sie kein Bild ein.","English":"Englisch","Enrich":"Bereichern","Erase":"Löschen","Erase on rotate object is disabled. Sorry.":"Das Objekt \"Erase on rotate\" ist deaktiviert. Es tut uns leid.","Error":"Error","Error connecting to service.":"Fehler beim Verbinden mit dem Dienst.","Error: can not load image.":"Fehler: Bild kann nicht geladen werden.","Error: missing details event target":"Fehler: Details zum Ereignis fehlen","Error: unsupported attribute type:":"Fehler: nicht unterstützter Attributtyp:","Error: wrong key:":"Fehler: falscher Schlüssel:","Español":"Español","Expand edges":"Kanten erweitern","Exponent:":"Exponent:","Factor:":"Faktor:","File":"Datei","File name:":"Dateiname:","File size:":"Dateigröße:","Fill":"Füllen","Fit":"Passen","Fit window":"Fenster einpassen","Flatten Image":"Bild abflachen","Flip":"Flip","FloydSteinberg-serpentine":"FloydSteinberg-Serpentin","French":"Französisch","Full HD, 1080p":"Volles HD, 1080p","GIF - Graphics Interchange Format":"GIF - Graphics Interchange Format","Gap:":"Spalt:","Gaussian Blur":"Gaußscher Weichzeichner","German":"Deutsche","Gif delay:":"Gif Verzögerung:","GitHub:":"GitHub:","Gradient":"Gradient","Gradient Radius:":"Gradient Radius:","Grains":"Körner","Gray":"Grau","Grayscale":"Graustufen","Green":"Grün","Green channel:":"Grüner Kanal:","Green:":"Grün:","Greyscale:":"Graustufen:","Grid":"Gitter","Grid on/off":"Raster ein / aus","H Radius:":"H Radius:","Heatmap":"Heatmap","Height (%):":"Höhe (%):","Height:":"Höhe:","Help":"Hilfe","Helvetica":"Helvetica","Hermite":"Hermite","Hex:":"Verhexen:","Histogram":"Histogramm","Histogram:":"Histogramm:","Horizontal":"Horizontal","Horizontal blur:":"Horizontale Unschärfe:","Hue Rotate":"Farbton drehen","Hue:":"Farbton:","Image":"Bild","Image data with multi-layers. Can be opened using miniPaint -":"Bilddaten mit mehreren Ebenen. Kann mit miniPaint geöffnet werden -","Impact":"Auswirkung","Information":"Information","Insert:":"Einfügen:","Italiano":"Italienisch","Italic":"Kursiv","JPG - JPG/JPEG Format":"JPG - JPG / JPEG Format","JPG, WEBP quality:":"JPG, WEBP Qualität:","JSON - Full layers data":"JSON - Vollständige Layer-Daten","Japanese":"japanisch","Key-points":"Schlüsselpunkte","Keyboard Shortcuts":"Tastatürkürzel","Keyword:":"Stichwort:","Korean":"Koreanisch","Language":"Sprache","Last modified":"Zuletzt bearbeitet","Layer details":"Layerdetails","Layer is already image.":"Die Ebene ist bereits ein Bild.","Layer must be image, convert it to raster to apply this tool.":"Die Ebene muss ein Bild sein, wandeln Sie sie in ein Raster um, um dieses Werkzeug anzuwenden.","Layers":"Lagen","Layers:":"Lagen:","Left":"Links","Level:":"Niveau:","Levels:":"Ebenen:","Lietuvių":"Lietuvių","Line":"Linie","Lum:":"Lum:","Luminance:":"Leuchtdichte:","Magic Wand Tool":"Zauberstab-Werkzeug","Merge Down":"Abwärts zusammenführen","Merged":"Zusammengeführt","Mode:":"Modus:","Module function not found.":"Modulfunktion nicht gefunden.","Modules class not found:":"Modulklasse nicht gefunden:","Mosaic":"Mosaik","Mouse:":"Maus:","Move":"Bewegung","Move down":"Sich abwärts bewegen","Move up":"Nach oben gehen","Name:":"Name:","Needs at least 2 layers.":"Benötigt mindestens 2 Schichten.","Negative":"Negativ","New":"Neu","New file":"Neue Datei","New from selection":"Neu von Auswahl","New layer":"Neue Schicht","New width can not be smaller then current width":"Die neue Breite darf nicht kleiner als die aktuelle Breite sein","Normal":"Normal","Nothing is selected.":"Nichts ist ausgewählt.","Offset X:":"Offset X:","Offset Y:":"Offset Y:","Oil":"Öl","Ok":"OK","Online image editor.":"Online Bildbearbeitung.","Opacity":"Opazität","Opacity:":"Opazität:","Open":"Öffnen","Open Data URL":"Öffnen Sie die Daten-URL","Open Directory":"Verzeichnis öffnen","Open File":"Datei öffnen","Open URL":"Öffne URL","Open data URL":"Öffnen Sie die Daten-URL","Original size":"Originalgröße","PNG - Portable Network Graphics":"PNG - Portable Netzwerkgrafik","Palette":"Palette","Parameter #1:":"Parameter # 1:","Parameter #2:":"Parameter # 2:","Paste":"Einfügen","Pencil":"Bleistift","Percentage:":"Prozentsatz:","Pick Color":"Farbe wählen","Pixels:":"Pixel:","Play animation":"Animation abspielen","Portuguese":"Portugiesisch","Power:":"Leistung:","Powred by  pixabay.com .":"Powred von pixabay.com.","Pre-Blur:":"Vor Weichzeichnen:","Preview":"Vorschau","Previous":"Bisherige","Previous layer must be image, convert it to raster to apply this tool.":"Die vorherige Ebene muss ein Bild sein, wandeln Sie sie in ein Raster um, um dieses Werkzeug anzuwenden.","Print":"Drucken","Quality:":"Qualität:","Quick load":"Schnell laden","Quick save":"Schnellspeichern","Radial":"Radial","Radial gradient":"Radialer Verlauf","Radius:":"Radius:","Range:":"Angebot:","Rectangle":"Rechteck","Red":"rot","Red channel:":"Roter Kanal:","Red:":"Rot:","Rename":"Umbenennen","Replace Color":"Farbe ersetzen","Replace color":"Farbe ersetzen","Replacement:":"Ersatz:","Report issues":"Probleme melden","Resample - Hermite":"Resample - Hermite","Reset":"Zurücksetzen","Reset zoom level":"Zoomstufe zurücksetzen","Resize":"Größe ändern","Resized as background":"Größe als Hintergrund","Resolution:":"Auflösung:","Restore alpha":"Alpha wiederherstellen","Right":"Recht","Right angle:":"Rechter Winkel:","Rotate":"Drehen","Rotate is not supported on this type of object. Convert to raster?":"Drehen wird bei diesem Objekttyp nicht unterstützt. In Raster konvertieren?","Rotate left":"Nach links drehen","Rotate:":"Drehen:","Russian":"Russisch","Sat:":"Sa:","Saturate":"Sättigen","Saturation:":"Sättigung:","Save":"sparen","Save as":"Speichern als","Save as data URL":"Als Daten-URL speichern","Save as type:":"Speichern unter:","Save layers:":"Ebenen speichern:","Save resolution:":"Auflösung speichern:","Scroll down":"Runterscrollen","Scroll up":"Hochscrollen","Search":"Suche","Search images":"Bilder suchen","Select all":"Wählen Sie Alle","Select object tool":"Wählen Sie das Objektwerkzeug aus","Selected":"Ausgewählt","Selection":"Auswahl","Sensitivity:":"Empfindlichkeit:","Sepia":"Sepia","Settings":"die Einstellungen","Shadow":"Schatten","Shadow:":"Schatten:","Sharpen":"Schärfen","Sharpen tool":"Werkzeug schärfen","Sharpen:":"Schärfen:","Show / Hide":"Anzeigen Ausblenden","Show file size:":"Dateigröße anzeigen:","Simple":"Einfach","Size":"Größe","Size is too big, max":"Größe ist zu groß, max","Size:":"Größe:","Skip - layer must be image.":"Überspringen - Ebene muss ein Bild sein.","Solarize":"Solarisieren","Sorry, image could not be loaded. Try copy image and paste it.":"Entschuldigung, Bild konnte nicht geladen werden. Versuchen Sie, das Bild zu kopieren und einzufügen.","Sorry, image is too big, max 5 MB.":"Entschuldigung, das Bild ist zu groß, maximal 5 MB.","Source is empty, right click on image to save source position.":"Die Quelle ist leer, klicken Sie mit der rechten Maustaste auf das Bild, um die Quellposition zu speichern.","Sprites":"Sprites","Square":"Platz","Strength:":"Stärke:","Strict":"Streng","Stroke":"Schlaganfall","Stroke:":"Schlaganfall:","Target:":"Ziel:","Text":"Text","Text example":"Textbeispiel","Text:":"Text:","There are no layers behind.":"Es gibt keine Schichten dahinter.","There is only 1 layer.":"Es gibt nur 1 Schicht.","Tilt Shift":"Neigung Verschiebung","Times New Roman":"Times New Roman","Toggle":"Umschalten","Tools":"Werkzeuge","Tools class not found:":"Tools-Klasse nicht gefunden:","Total pixels:":"Gesamtpixel:","Translate":"Übersetzen","Translate error, can not find dictionary:":"Fehler übersetzen, Wörterbuch nicht finden:","Transparency background:":"Transparenz Hintergrund:","Transparent:":"Transparent:","Trim":"Trimmen","Trim everything:":"Alles zurechtschneiden:","Trim layer:":"Trim-Ebene:","Trim white color?":"Trim weiße Farbe?","Turkish":"Türkisch","Undo":"Rückgängig machen","Undo disabled.":"Rückgängig deaktiviert","Undo enabled.":"Rückgängig machen","Undo is not available.":"Rückgängig ist nicht verfügbar.","Undo levels changed to 1.":"Ebenen rückgängig machen, die auf 1 geändert wurden.","Undo levels restored to":"Rückgängigmachen von Ebenen, auf die wiederhergestellt wird","Unique colors:":"Einzigartige Farben:","Up":"Oben","Use Ctrl+V keyboard shortcut to paste from Clipboard.":"Verwenden Sie die Tastenkombination Strg + V zum Einfügen aus der Zwischenablage.","V Radius:":"V-Radius:","Verdana":"Verdana","Version:":"Ausführung:","Vertical":"Vertikal","Vertical blur:":"Vertikale Unschärfe:","Vibrance":"Dynamik","Vignette":"Vignette","ViliusL":"ViliusL","Vintage":"Jahrgang","Visible:":"Sichtbar:","WEBP - Weppy File Format":"WEBP - Weppy Dateiformat","Website:":"Webseite:","Width (%):":"Breite (%):","Width:":"Breite:","Wrong file type, must be image or json.":"Falscher Dateityp, muss image oder json sein.","X end:":"X Ende:","X position:":"X-Position:","X start:":"X Start:","Y end:":"Y Ende:","Y position:":"Y-Position:","Y start:":"Y Start:","You can also drag and drop items into browser.":"Sie können Objekte auch per Drag & Drop in den Browser ziehen.","Your browser does not support canvas or JavaScript is not enabled.":"Ihr Browser unterstützt kein Canvas oder JavaScript ist nicht aktiviert.","Your browser does not support this format.":"Ihr Browser unterstützt dieses Format nicht.","Your search did not match any images.":"Ihre Suche hat keine Bilder gefunden.","Zoom":"Zoomen","Zoom Blur":"Zoom Unschärfe","Zoom In":"Hineinzoomen","Zoom Out":"Rauszoomen","Zoom blur":"Zoomunschärfe","Zoom in":"Hineinzoomen","Zoom out":"Rauszoomen","Zoom:":"Zoomen:"}

/***/ }),
/* 41 */
/***/ (function(module, exports) {

module.exports = {"2d":"","480p":"","About":"","Active":"","Advanced":"","All":"","Alpha:":"","Anonymous":"","Anti aliasing":"","Arial":"","Arrow":"","Author:":"","Auto adjust colors":"","Average:":"","BMP - Windows Bitmap":"","Base":"","Basic":"","Black and White":"","Blue":"","Blue channel:":"","Blue:":"","Blur Radius:":"","Blur power:":"","Blur tool":"","Bold":"","Bold Italic":"","Borders":"","Box Blur":"","Box blur":"","Brightness":"","Brightness:":"","Brush":"","Bulge/Pinch tool":"","Burn":"","CSS filters":"","Can not animate 1 layer.":"","Can not find previous layer.":"","Cancel":"","Center":"","Center x:":"","Center y:":"","Center:":"","Channel:":"","Circle":"","Clear":"","Clone count:":"","Clone tool":"","Cloned edges":"","Color #":"","Color Zoom":"","Color alpha value can not be zero.":"","Color corrections":"","Color palette":"","Color to alpha":"","Color zoom":"","Color:":"","Colors":"","Colors:":"","Composition":"","Composition:":"","Content fill":"","Contrast":"","Contrast:":"","Convert to raster":"","Copy selection":"","Copy:":"","Courier":"","Crop":"","Ctrl+V":"","Ctrl-P":"","Current":"","Curve":"","Custom":"","Data URL":"","Data URL:":"","Decrease color depth":"","Default":"","Degree:":"","Del":"","Delete":"","Delete selection":"","Denoise":"","Desaturate":"","Description:":"","Differences":"","Differences Down":"","Dither":"","Dithering:":"","Dominant color:":"","Dot Screen":"","Down":"","Duplicate":"","Edge":"","Edit":"","Edit text":"","Edit text...":"","Effects":"","Email:":"","Emboss":"","Empty selection":"","Empty selection or type not image.":"","English":"","Enrich":"","Erase":"","Erase on rotate object is disabled. Sorry.":"","Error":"","Error connecting to service.":"","Error: can not load image.":"","Error: missing details event target":"","Error: unsupported attribute type:":"","Error: wrong key:":"","Español":"","Expand edges":"","Exponent:":"","Factor:":"","File":"","File name:":"","File size:":"","Fill":"","Fit":"","Fit window":"","Flatten Image":"","Flip":"","FloydSteinberg-serpentine":"","French":"","Full HD, 1080p":"","GIF - Graphics Interchange Format":"","Gap:":"","Gaussian Blur":"","German":"","Gif delay:":"","GitHub:":"","Gradient":"","Gradient Radius:":"","Grains":"","Gray":"","Grayscale":"","Green":"","Green channel:":"","Green:":"","Greyscale:":"","Grid":"","Grid on/off":"","H Radius:":"","Heatmap":"","Height (%):":"","Height:":"","Help":"","Helvetica":"","Hermite":"","Hex:":"","Histogram":"","Histogram:":"","Horizontal":"","Horizontal blur:":"","Hue Rotate":"","Hue:":"","Image":"","Image data with multi-layers. Can be opened using miniPaint -":"","Impact":"","Information":"","Insert:":"","Italiano":"","Italic":"","JPG - JPG/JPEG Format":"","JPG, WEBP quality:":"","JSON - Full layers data":"","Japanese":"","Key-points":"","Keyboard Shortcuts":"","Keyword:":"","Korean":"","Language":"","Last modified":"","Layer details":"","Layer is already image.":"","Layer must be image, convert it to raster to apply this tool.":"","Layers":"","Layers:":"","Left":"","Level:":"","Levels:":"","Lietuvių":"","Line":"","Lum:":"","Luminance:":"","Magic Wand Tool":"","Merge Down":"","Merged":"","Mode:":"","Module function not found.":"","Modules class not found:":"","Mosaic":"","Mouse:":"","Move":"","Move down":"","Move up":"","Name:":"","Needs at least 2 layers.":"","Negative":"","New":"","New file":"","New from selection":"","New layer":"","New width can not be smaller then current width":"","Normal":"","Nothing is selected.":"","Offset X:":"","Offset Y:":"","Oil":"","Ok":"","Online image editor.":"","Opacity":"","Opacity:":"","Open":"","Open Data URL":"","Open Directory":"","Open File":"","Open URL":"","Open data URL":"","Original size":"","PNG - Portable Network Graphics":"","Palette":"","Parameter #1:":"","Parameter #2:":"","Paste":"","Pencil":"","Percentage:":"","Pick Color":"","Pixels:":"","Play animation":"","Portuguese":"","Power:":"","Powred by  pixabay.com .":"","Pre-Blur:":"","Preview":"","Previous":"","Previous layer must be image, convert it to raster to apply this tool.":"","Print":"","Quality:":"","Quick load":"","Quick save":"","Radial":"","Radial gradient":"","Radius:":"","Range:":"","Rectangle":"","Red":"","Red channel:":"","Red:":"","Rename":"","Replace Color":"","Replace color":"","Replacement:":"","Report issues":"","Resample - Hermite":"","Reset":"","Reset zoom level":"","Resize":"","Resized as background":"","Resolution:":"","Restore alpha":"","Right":"","Right angle:":"","Rotate":"","Rotate is not supported on this type of object. Convert to raster?":"","Rotate left":"","Rotate:":"","Russian":"","Sat:":"","Saturate":"","Saturation:":"","Save":"","Save as":"","Save as data URL":"","Save as type:":"","Save layers:":"","Save resolution:":"","Scroll down":"","Scroll up":"","Search":"","Search images":"","Select all":"","Select object tool":"","Selected":"","Selection":"","Sensitivity:":"","Sepia":"","Settings":"","Shadow":"","Shadow:":"","Sharpen":"","Sharpen tool":"","Sharpen:":"","Show / Hide":"","Show file size:":"","Simple":"","Size":"","Size is too big, max":"","Size:":"","Skip - layer must be image.":"","Solarize":"","Sorry, image could not be loaded. Try copy image and paste it.":"","Sorry, image is too big, max 5 MB.":"","Source is empty, right click on image to save source position.":"","Sprites":"","Square":"","Strength:":"","Strict":"","Stroke":"","Stroke:":"","Target:":"","Text":"","Text example":"","Text:":"","There are no layers behind.":"","There is only 1 layer.":"","Tilt Shift":"","Times New Roman":"","Toggle":"","Tools":"","Tools class not found:":"","Total pixels:":"","Translate":"","Translate error, can not find dictionary:":"","Transparency background:":"","Transparent:":"","Trim":"","Trim everything:":"","Trim layer:":"","Trim white color?":"","Turkish":"","Undo":"","Undo disabled.":"","Undo enabled.":"","Undo is not available.":"","Undo levels changed to 1.":"","Undo levels restored to":"","Unique colors:":"","Up":"","Use Ctrl+V keyboard shortcut to paste from Clipboard.":"","V Radius:":"","Verdana":"","Version:":"","Vertical":"","Vertical blur:":"","Vibrance":"","Vignette":"","ViliusL":"","Vintage":"","Visible:":"","WEBP - Weppy File Format":"","Website:":"","Width (%):":"","Width:":"","Wrong file type, must be image or json.":"","X end:":"","X position:":"","X start:":"","Y end:":"","Y position:":"","Y start:":"","You can also drag and drop items into browser.":"","Your browser does not support canvas or JavaScript is not enabled.":"","Your browser does not support this format.":"","Your search did not match any images.":"","Zoom":"","Zoom Blur":"","Zoom In":"","Zoom Out":"","Zoom blur":"","Zoom in":"","Zoom out":"","Zoom:":""}

/***/ }),
/* 42 */
/***/ (function(module, exports) {

module.exports = {"2d":"2d","480p":"480p","About":"Acerca de","Active":"Activo","Advanced":"Avanzado","All":"Todas","Alpha:":"Alfa:","Anonymous":"Anónimo","Anti aliasing":"Anti aliasing","Arial":"Arial","Arrow":"Flecha","Author:":"Autor:","Auto adjust colors":"Ajuste automático de colores","Average:":"Promedio:","BMP - Windows Bitmap":"BMP - Mapa de bits de Windows","Base":"Base","Basic":"BASIC","Black and White":"En blanco y negro","Blue":"Azul","Blue channel:":"Canal azul:","Blue:":"Azul:","Blur Radius:":"Blur Radio:","Blur power:":"Desenfoque de poder:","Blur tool":"Herramienta de desenfoque","Bold":"Negrita","Bold Italic":"Negrita cursiva","Borders":"Bordes","Box Blur":"Caja de desenfoque","Box blur":"Caja de desenfoque","Brightness":"Brillo","Brightness:":"Brillo:","Brush":"Cepillo","Bulge/Pinch tool":"Herramienta de abombamiento / pellizco","Burn":"Quemar","CSS filters":"Filtros CSS","Can not animate 1 layer.":"No se puede animar 1 capa.","Can not find previous layer.":"No se puede encontrar la capa anterior.","Cancel":"Cancelar","Center":"Centrar","Center x:":"Centro x:","Center y:":"Centro y:","Center:":"Centrar:","Channel:":"Canal:","Circle":"Circulo","Clear":"Claro","Clone count:":"Recuento de clones","Clone tool":"Herramienta de clonación","Cloned edges":"Bordes clonados","Color #":"Color #","Color Zoom":"Zoom de color","Color alpha value can not be zero.":"El valor alfa del color no puede ser cero.","Color corrections":"Correcciones de color","Color palette":"Paleta de color","Color to alpha":"Color a alfa","Color zoom":"Zoom a color","Color:":"Color:","Colors":"Colores","Colors:":"Colores:","Composition":"Composición","Composition:":"Composición:","Content fill":"Relleno de contenido","Contrast":"Contraste","Contrast:":"Contraste:","Convert to raster":"Convertir a trama","Copy selection":"Copiar selección","Copy:":"Dupdo:","Courier":"mensajero","Crop":"Cultivo","Ctrl+V":"Ctrl + V","Ctrl-P":"Ctrl-P","Current":"Corriente","Curve":"Curva","Custom":"Personalizado","Data URL":"URL de datos","Data URL:":"URL de datos:","Decrease color depth":"Disminuir la profundidad de color","Default":"Defecto","Degree:":"La licenciatura:","Del":"Del","Delete":"Borrar","Delete selection":"Eliminar selección","Denoise":"Denoise","Desaturate":"Desaturar","Description:":"Descripción:","Differences":"Diferencias","Differences Down":"Diferencias hacia abajo","Dither":"Vacilar","Dithering:":"Dithering:","Dominant color:":"Color dominante:","Dot Screen":"Pantalla de puntos","Down":"Abajo","Duplicate":"Duplicar","Edge":"Borde","Edit":"Editar","Edit text":"Editar texto","Edit text...":"Editar texto...","Effects":"Efectos","Email:":"Email:","Emboss":"Realzar","Empty selection":"Selección vacía","Empty selection or type not image.":"Vaciar selección o escribir no imagen.","English":"Inglés","Enrich":"Enriquecer","Erase":"Borrar","Erase on rotate object is disabled. Sorry.":"Borrar en rotar objeto está deshabilitado. Lo siento.","Error":"Error","Error connecting to service.":"Error al conectarse al servicio.","Error: can not load image.":"Error: no se puede cargar la imagen.","Error: missing details event target":"Error: falta el objetivo del evento de detalles","Error: unsupported attribute type:":"Error: tipo de atributo no soportado:","Error: wrong key:":"Error: clave incorrecta:","Español":"English","Expand edges":"Expandir bordes","Exponent:":"Exponente:","Factor:":"Factor:","File":"Archivo","File name:":"Nombre del archivo:","File size:":"Tamaño del archivo:","Fill":"Llenar","Fit":"Ajuste","Fit window":"Ajustar ventana","Flatten Image":"Imagen aplanada","Flip":"Dar la vuelta","FloydSteinberg-serpentine":"FloydSteinberg-serpentina","French":"francés","Full HD, 1080p":"Full HD, 1080p","GIF - Graphics Interchange Format":"GIF - Formato de intercambio de gráficos","Gap:":"Brecha:","Gaussian Blur":"Desenfoque gaussiano","German":"alemán","Gif delay:":"Retraso Gif:","GitHub:":"GitHub:","Gradient":"Gradiente","Gradient Radius:":"Radio de gradiente:","Grains":"Granos","Gray":"gris","Grayscale":"Escala de grises","Green":"Verde","Green channel:":"Canal verde:","Green:":"Verde:","Greyscale:":"Escala de grises:","Grid":"Cuadrícula","Grid on/off":"Grid on / off","H Radius:":"H Radio:","Heatmap":"Mapa de calor","Height (%):":"Altura (%):","Height:":"Altura:","Help":"Ayuda","Helvetica":"Helvética","Hermite":"Hermite","Hex:":"Maleficio:","Histogram":"Histograma","Histogram:":"Histograma:","Horizontal":"Horizontal","Horizontal blur:":"Desenfoque horizontal:","Hue Rotate":"Hue Rotate","Hue:":"Matiz:","Image":"Imagen","Image data with multi-layers. Can be opened using miniPaint -":"Datos de imagen con varias capas. Se puede abrir usando miniPaint -","Impact":"Impacto","Information":"Información","Insert:":"Insertar:","Italiano":"Italiano","Italic":"Itálico","JPG - JPG/JPEG Format":"JPG - Formato JPG / JPEG","JPG, WEBP quality:":"JPG, calidad de WEBP:","JSON - Full layers data":"JSON: datos de capas completas","Japanese":"japonés","Key-points":"Puntos clave","Keyboard Shortcuts":"Atajos de teclado","Keyword:":"Palabra clave:","Korean":"coreano","Language":"Idioma","Last modified":"Última modificación","Layer details":"Detalles de la capa","Layer is already image.":"Layer ya es imagen.","Layer must be image, convert it to raster to apply this tool.":"La capa debe ser una imagen, conviértala a raster para aplicar esta herramienta.","Layers":"Capas","Layers:":"Capas:","Left":"Izquierda","Level:":"Nivel:","Levels:":"Niveles:","Lietuvių":"Lietuvių","Line":"Línea","Lum:":"Lum:","Luminance:":"Luminancia:","Magic Wand Tool":"Varita mágica","Merge Down":"Fusionar","Merged":"Fusionado","Mode:":"Modo:","Module function not found.":"Función del módulo no encontrada.","Modules class not found:":"Clase de módulos no encontrada:","Mosaic":"Mosaico","Mouse:":"Ratón:","Move":"Movimiento","Move down":"Mover hacia abajo","Move up":"Ascender","Name:":"Nombre:","Needs at least 2 layers.":"Necesita al menos 2 capas","Negative":"Negativo","New":"Nuevo","New file":"Archivo nuevo","New from selection":"Nuevo de la selección","New layer":"Nueva capa","New width can not be smaller then current width":"El nuevo ancho no puede ser más pequeño que el ancho actual","Normal":"Normal","Nothing is selected.":"Nada está seleccionado.","Offset X:":"Compensación X:","Offset Y:":"Desplazamiento Y:","Oil":"Petróleo","Ok":"De acuerdo","Online image editor.":"Editor de imágenes en línea","Opacity":"Opacidad","Opacity:":"Opacidad:","Open":"Abierto","Open Data URL":"URL de datos abiertos","Open Directory":"Directorio abierto","Open File":"Abrir documento","Open URL":"URL abierta","Open data URL":"URL de datos abiertos","Original size":"Tamaño original","PNG - Portable Network Graphics":"PNG - Gráficos de red portátiles","Palette":"Paleta","Parameter #1:":"Parámetro # 1:","Parameter #2:":"Parámetro # 2:","Paste":"Pegar","Pencil":"Lápiz","Percentage:":"Porcentaje:","Pick Color":"Elegir color","Pixels:":"Píxeles:","Play animation":"Reproducir animación","Portuguese":"portugués","Power:":"Poder:","Powred by  pixabay.com .":"Desarrollado por pixabay.com.","Pre-Blur:":"Pre-desenfoque:","Preview":"Avance","Previous":"Anterior","Previous layer must be image, convert it to raster to apply this tool.":"La capa anterior debe ser una imagen, conviértala a raster para aplicar esta herramienta.","Print":"Impresión","Quality:":"Calidad:","Quick load":"Carga rápida","Quick save":"Guardado rápido","Radial":"Radial","Radial gradient":"Gradiente radial","Radius:":"Radio:","Range:":"Distancia:","Rectangle":"Rectángulo","Red":"rojo","Red channel:":"Canal rojo:","Red:":"Rojo:","Rename":"Rebautizar","Replace Color":"Reemplazar color","Replace color":"Reemplazar color","Replacement:":"Reemplazo:","Report issues":"Informar problemas","Resample - Hermite":"Remuestreo - Hermite","Reset":"Reiniciar","Reset zoom level":"Restablecer nivel de zoom","Resize":"Cambiar el tamaño","Resized as background":"Redimensionado como fondo","Resolution:":"Resolución:","Restore alpha":"Restaurar alfa","Right":"Derecha","Right angle:":"Ángulo recto:","Rotate":"Girar","Rotate is not supported on this type of object. Convert to raster?":"Girar no es compatible con este tipo de objeto. Convertir a raster?","Rotate left":"Girar a la izquierda","Rotate:":"Girar:","Russian":"ruso","Sat:":"Sab:","Saturate":"Saturar","Saturation:":"Saturación:","Save":"Salvar","Save as":"Guardar como","Save as data URL":"Guardar como URL de datos","Save as type:":"Guardar como tipo:","Save layers:":"Guardar capas:","Save resolution:":"Guardar resolución:","Scroll down":"Desplazarse hacia abajo","Scroll up":"Desplazarse hacia arriba","Search":"Buscar","Search images":"Buscar imágenes","Select all":"Seleccionar todo","Select object tool":"Seleccionar herramienta de objeto","Selected":"Seleccionado","Selection":"Selección","Sensitivity:":"Sensibilidad:","Sepia":"Sepia","Settings":"Configuraciones","Shadow":"Sombra","Shadow:":"Sombra:","Sharpen":"Afilar","Sharpen tool":"Afilar la herramienta","Sharpen:":"Afilar:","Show / Hide":"Mostrar ocultar","Show file size:":"Mostrar tamaño de archivo:","Simple":"Sencillo","Size":"tamaño","Size is too big, max":"El tamaño es demasiado grande, máximo","Size:":"Tamaño:","Skip - layer must be image.":"Omitir: la capa debe ser una imagen.","Solarize":"Solarizar","Sorry, image could not be loaded. Try copy image and paste it.":"Lo sentimos, la imagen no se pudo cargar. Intenta copiar la imagen y pégala.","Sorry, image is too big, max 5 MB.":"Lo sentimos, la imagen es demasiado grande, máximo 5 MB.","Source is empty, right click on image to save source position.":"La fuente está vacía, haga clic derecho en la imagen para guardar la posición de la fuente.","Sprites":"Sprites","Square":"Cuadrado","Strength:":"Fuerza:","Strict":"Estricto","Stroke":"Carrera","Stroke:":"Carrera:","Target:":"Objetivo:","Text":"Texto","Text example":"Ejemplo de texto","Text:":"Texto:","There are no layers behind.":"No hay capas detrás","There is only 1 layer.":"Solo hay 1 capa","Tilt Shift":"Cambio de inclinación","Times New Roman":"Times New Roman","Toggle":"Palanca","Tools":"Herramientas","Tools class not found:":"Clase de herramientas no encontradas:","Total pixels:":"Píxeles totales:","Translate":"Traducir","Translate error, can not find dictionary:":"Error de traducción, no se puede encontrar el diccionario:","Transparency background:":"Fondo de transparencia:","Transparent:":"Transparente:","Trim":"Recortar","Trim everything:":"Recortar todo:","Trim layer:":"Capa de ajuste:","Trim white color?":"Recortar el color blanco?","Turkish":"turco","Undo":"Deshacer","Undo disabled.":"Deshabilitar.","Undo enabled.":"Deshacer habilitado.","Undo is not available.":"Deshacer no está disponible.","Undo levels changed to 1.":"Los niveles de deshacer cambiaron a 1.","Undo levels restored to":"Deshace los niveles restaurados a","Unique colors:":"Colores únicos:","Up":"Arriba","Use Ctrl+V keyboard shortcut to paste from Clipboard.":"Use el atajo de teclado Ctrl + V para pegar desde el Portapapeles.","V Radius:":"V Radio:","Verdana":"Verdana","Version:":"Versión:","Vertical":"Vertical","Vertical blur:":"Desenfoque vertical:","Vibrance":"Vibrance","Vignette":"Viñeta","ViliusL":"ViliusL","Vintage":"Vendimia","Visible:":"Visible:","WEBP - Weppy File Format":"WEBP - Formato de archivo Weppy","Website:":"Sitio web:","Width (%):":"Ancho (%):","Width:":"Anchura:","Wrong file type, must be image or json.":"Tipo de archivo incorrecto, debe ser imagen o json.","X end:":"X final:","X position:":"Posición X:","X start:":"X inicio:","Y end:":"Final de Y:","Y position:":"Posición Y:","Y start:":"Y comienza:","You can also drag and drop items into browser.":"También puede arrastrar y soltar elementos en el navegador.","Your browser does not support canvas or JavaScript is not enabled.":"Su navegador no admite lienzo o JavaScript no está habilitado.","Your browser does not support this format.":"Su navegador no es compatible con este formato.","Your search did not match any images.":"Su búsqueda no coincide con ninguna imagen.","Zoom":"Enfocar","Zoom Blur":"Desenfoque de zoom","Zoom In":"Acercarse","Zoom Out":"Disminuir el zoom","Zoom blur":"Borroso de zoom","Zoom in":"Acercarse","Zoom out":"Disminuir el zoom","Zoom:":"Enfocar:"}

/***/ }),
/* 43 */
/***/ (function(module, exports) {

module.exports = {"2d":"2d","480p":"480p","About":"A propos","Active":"actif","Advanced":"Avancé","All":"Tout","Alpha:":"Alpha :","Anonymous":"Anonyme","Anti aliasing":"Anticrénelage","Arial":"Arial","Arrow":"Flèche","Author:":"Auteur :","Auto adjust colors":"Ajuster automatiquement les couleurs","Average:":"Moyenne :","BMP - Windows Bitmap":"BMP - Windows Bitmap","Base":"Base","Basic":"Basique","Black and White":"Noir et blanc","Blue":"Bleu","Blue channel:":"Niveau de bleu :","Blue:":"Bleu:","Blur Radius:":"Rayon de floutage :","Blur power:":"Puissance de flou:","Blur tool":"Flou","Bold":"Gras","Bold Italic":"Gras Italique","Borders":"Cadres","Box Blur":"Box Blur","Box blur":"Box flou","Brightness":"Luminosité","Brightness:":"Luminosité :","Brush":"Pinceau","Bulge/Pinch tool":"Déformer / Bosse","Burn":"Brûler","CSS filters":"Filtres CSS","Can not animate 1 layer.":"Impossible d'animer une couche.","Can not find previous layer.":"Impossible de trouver la couche précédente.","Cancel":"Annuler","Center":"Centre","Center x:":"Centrage x :","Center y:":"Centrage y :","Center:":"Centre :","Channel:":"Niveau :","Circle":"Cercle","Clear":"Effacer","Clone count:":"Nombre de clones:","Clone tool":"Tampon de clonage","Cloned edges":"Bords clonés","Color #":"Couleur #","Color Zoom":"Eclat","Color alpha value can not be zero.":"La valeur alpha de la couleur ne peut pas être nulle.","Color corrections":"Correction des couleurs","Color palette":"Palette de couleurs","Color to alpha":"Rendre transparent","Color zoom":"Zoom couleur","Color:":"Couleur :","Colors":"Couleurs","Colors:":"Couleurs :","Composition":"Composition","Composition:":"Composition :","Content fill":"Remplissage de contenu","Contrast":"Contraste","Contrast:":"Contraste :","Convert to raster":"Convertir en raster","Copy selection":"Copier","Copy:":"Copie:","Courier":"Courier","Crop":"Rogner selon la sélection","Ctrl+V":"Ctrl + V","Ctrl-P":"Ctrl-P","Current":"Actuel","Curve":"Courbe","Custom":"Personnalisé","Data URL":"URL de données","Data URL:":"URL de données:","Decrease color depth":"Postériser","Default":"Défaut","Degree:":"Degré:","Del":"Supp","Delete":"Supprimer","Delete selection":"Effacer la sélection","Denoise":"Réduire le bruit","Desaturate":"Désaturer","Description:":"Description :","Differences":"Détection des bords","Differences Down":"Détection des bords...","Dither":"Ajouter du bruit","Dithering:":"Trame :","Dominant color:":"Couleur dominante:","Dot Screen":"Demi-teinte","Down":"Vers le bas","Duplicate":"Dupliquer","Edge":"Détection des bords","Edit":"Edition","Edit text":"Éditer le texte","Edit text...":"Éditer le texte...","Effects":"Effets","Email:":"Email :","Emboss":"Embossage","Empty selection":"Sélection vide","Empty selection or type not image.":"Sélection vide ou tapez pas d'image.","English":"Anglais","Enrich":"Améliorer la netteté","Erase":"Gomme","Erase on rotate object is disabled. Sorry.":"L'effacement à la rotation de l'objet est désactivé. Pardon.","Error":"Erreur","Error connecting to service.":"Erreur lors de la connexion au service.","Error: can not load image.":"Erreur: impossible de charger l'image.","Error: missing details event target":"Erreur: cible des événements manquants de détails","Error: unsupported attribute type:":"Erreur: type d'attribut non pris en charge:","Error: wrong key:":"Erreur: mauvaise clé:","Español":"Espagnol","Expand edges":"Développer les bords","Exponent:":"Exposant :","Factor:":"Facteur :","File":"Fichier","File name:":"Nom de fichier :","File size:":"Taille du fichier :","Fill":"Remplir","Fit":"Fenêtre","Fit window":"Remplir la fenêtre","Flatten Image":"Fusionner tous les calques","Flip":"Retourner","FloydSteinberg-serpentine":"FloydSteinberg-serpentine","French":"Français","Full HD, 1080p":"Full HD, 1080p","GIF - Graphics Interchange Format":"GIF - Format d'échange de graphiques","Gap:":"Ecart :","Gaussian Blur":"Flou gaussien","German":"Allemand","Gif delay:":"Gif délai:","GitHub:":"GitHub :","Gradient":"Dégradé","Gradient Radius:":"Rayon du dégradé :","Grains":"Grains","Gray":"Gris","Grayscale":"Niveaux de gris","Green":"Vert","Green channel:":"Niveau de vert :","Green:":"Vert:","Greyscale:":"Noir et blanc :","Grid":"Grille","Grid on/off":"Grille activée / désactivée","H Radius:":"Rayon H :","Heatmap":"Zones chaudes","Height (%):":"Hauteur (%) :","Height:":"Hauteur :","Help":"Aide","Helvetica":"Helvetica","Hermite":"Hermite","Hex:":"Hex:","Histogram":"Histogramme","Histogram:":"Histogramme :","Horizontal":"Horizontalement","Horizontal blur:":"Flou horizontal:","Hue Rotate":"Hue Rotate","Hue:":"Teinte :","Image":"Image","Image data with multi-layers. Can be opened using miniPaint -":"Données d'image avec plusieurs couches. Peut être ouvert en utilisant miniPaint -","Impact":"Impact","Information":"Informations","Insert:":"Insérer:","Italiano":"Italien","Italic":"Italique","JPG - JPG/JPEG Format":"JPG - Format JPG/JPEG","JPG, WEBP quality:":"JPG, qualité WEBP:","JSON - Full layers data":"JSON - Données avec tous les calques","Japanese":"Japonais","Key-points":"Points clés","Keyboard Shortcuts":"Raccourcis clavier","Keyword:":"Mot-clé:","Korean":"Coréen","Language":"Langue","Last modified":"Dernière mise à jour","Layer details":"Détails de la couche","Layer is already image.":"Le calque est déjà l'image.","Layer must be image, convert it to raster to apply this tool.":"Le calque doit être image, le convertir en raster pour appliquer cet outil.","Layers":"Calques","Layers:":"Couches:","Left":"à gauche","Level:":"Niveau :","Levels:":"Niveau :","Lietuvių":"Lituanien","Line":"Ligne","Lum:":"Lum:","Luminance:":"Luminance :","Magic Wand Tool":"Baguette magique","Merge Down":"Fusionner avec le calque inférieur","Merged":"Fusionné","Mode:":"Mode :","Module function not found.":"Fonction du module introuvable.","Modules class not found:":"Classe de modules introuvable:","Mosaic":"Mosaïque","Mouse:":"Souris :","Move":"Déplacer","Move down":"Déplacer vers le bas","Move up":"Déplacer vers le haut","Name:":"Nom :","Needs at least 2 layers.":"Nécessite au moins 2 couches.","Negative":"Négatif","New":"Nouveau...","New file":"Nouveau fichier","New from selection":"Nouveau à partir de la sélection","New layer":"Nouveau calque","New width can not be smaller then current width":"La nouvelle largeur ne peut pas être plus petite que la largeur actuelle","Normal":"Normal","Nothing is selected.":"Rien n'est sélectionné.","Offset X:":"Décalage X:","Offset Y:":"Décalage Y:","Oil":"Peinture à l'huile","Ok":"OK","Online image editor.":"Éditeur d'image en ligne.","Opacity":"Opacité","Opacity:":"Opacité:","Open":"Ouvrir","Open Data URL":"URL de données ouvertes","Open Directory":"Ouvrir le répertoire","Open File":"Fichier ouvert","Open URL":"Ouvrir depuis le Web","Open data URL":"URL de données ouvertes","Original size":"Format original","PNG - Portable Network Graphics":"PNG - Portable Network Graphics","Palette":"Palette","Parameter #1:":"Paramètre n ° 1:","Parameter #2:":"Paramètre n ° 2:","Paste":"Coller","Pencil":"Crayon","Percentage:":"Pourcentage:","Pick Color":"Sélecteur de couleurs","Pixels:":"Pixels :","Play animation":"Jouer l'animation","Portuguese":"Portugais","Power:":"<abbr title='Tolérance'>Tol.</abbr> :","Powred by  pixabay.com .":"Powred par pixabay.com.","Pre-Blur:":"Flou :","Preview":"Aperçu","Previous":"précédent","Previous layer must be image, convert it to raster to apply this tool.":"La couche précédente doit être une image, la convertir en raster pour appliquer cet outil.","Print":"Imprimer","Quality:":"Qualité :","Quick load":"Chargement rapide","Quick save":"Sauvegarde rapide","Radial":"Radial","Radial gradient":"Gradient radial","Radius:":"Rayon :","Range:":"Gamme :","Rectangle":"Rectangle","Red":"Rouge","Red channel:":"Niveau de rouge :","Red:":"Rouge:","Rename":"Renommer","Replace Color":"Remplacer une couleur","Replace color":"Remplacer une couleur","Replacement:":"Remplacement :","Report issues":"Signaler un problème","Resample - Hermite":"Rééchantillonnage","Reset":"Réinitialiser","Reset zoom level":"Réinitialiser le niveau de zoom","Resize":"Redimensionner","Resized as background":"Redimensionné comme arrière-plan","Resolution:":"Taille :","Restore alpha":"Restaurer le niveau alpha","Right":"à droite","Right angle:":"Angle droit:","Rotate":"Faire pivoter","Rotate is not supported on this type of object. Convert to raster?":"La rotation n'est pas prise en charge sur ce type d'objet. Convertir en raster?","Rotate left":"Faire pivoter à gauche","Rotate:":"Tourner:","Russian":"Russe","Sat:":"Sam:","Saturate":"Saturer","Saturation:":"Saturation :","Save":"Enregistrer","Save as":"Enregistrer sous","Save as data URL":"Enregistrer comme URL de données","Save as type:":"Enregistrer comme type :","Save layers:":"Enregistrer les calques :","Save resolution:":"Se souvenir de la taille :","Scroll down":"Défiler vers le bas","Scroll up":"Défiler","Search":"Chercher","Search images":"Rechercher des images","Select all":"Sélectionner tout","Select object tool":"Déplacer les pixels sélectionnés","Selected":"Choisi","Selection":"Sélection","Sensitivity:":"Sensibilité :","Sepia":"Vieille photo","Settings":"Paramètres","Shadow":"Ombre","Shadow:":"Ombre :","Sharpen":"Améliorer la netteté","Sharpen tool":"Netteté","Sharpen:":"Netteté :","Show / Hide":"Montrer / Cacher","Show file size:":"Calculer la taille du fichier :","Simple":"Simple","Size":"Taille","Size is too big, max":"La taille est trop grande, max","Size:":"Taille :","Skip - layer must be image.":"Skip-layer doit être image.","Solarize":"Solariser","Sorry, image could not be loaded. Try copy image and paste it.":"Désolé, l'image n'a pas pu être chargée. Essayez de la copier dans le presse-papier et de la coller à la place.","Sorry, image is too big, max 5 MB.":"Désolé, l'image est trop grande (5MB max).","Source is empty, right click on image to save source position.":"La source est vide, faites un clic droit sur l'image pour sauvegarder la position de la source.","Sprites":"Sprites","Square":"Carré","Strength:":"Force :","Strict":"Strict","Stroke":"Contour","Stroke:":"Accident vasculaire cérébral:","Target:":"Cible :","Text":"Texte","Text example":"Exemple de texte","Text:":"Texte :","There are no layers behind.":"Il n'y a pas de couches derrière.","There is only 1 layer.":"Il n'y a qu'une seule couche.","Tilt Shift":"Flou artistique","Times New Roman":"Times New Roman","Toggle":"Basculer","Tools":"Outils","Tools class not found:":"Classe d'outils introuvable:","Total pixels:":"Nombre de pixels :","Translate":"Traduire","Translate error, can not find dictionary:":"Erreur de traduction, impossible de trouver le dictionnaire :","Transparency background:":"Fond de transparence:","Transparent:":"Transparence :","Trim":"Rogner l'image","Trim everything:":"Coupez tout:","Trim layer:":"Couche de garniture:","Trim white color?":"Taillez la couleur blanche?","Turkish":"Turc","Undo":"Annuler","Undo disabled.":"Annuler désactivé.","Undo enabled.":"Annuler activé.","Undo is not available.":"Annuler n'est pas disponible.","Undo levels changed to 1.":"Les niveaux d'annulation ont été changés en 1.","Undo levels restored to":"Annuler les niveaux restitués à","Unique colors:":"Couleurs uniques :","Up":"Vers le haut","Use Ctrl+V keyboard shortcut to paste from Clipboard.":"Utilisez le raccourci clavier Ctrl + V pour coller à partir du Presse-papiers.","V Radius:":"Rayon V :","Verdana":"Verdana","Version:":"Version:","Vertical":"Verticalement","Vertical blur:":"Flou vertical:","Vibrance":"Vibrance","Vignette":"Vignette","ViliusL":"ViliusL","Vintage":"Vintage","Visible:":"Visible :","WEBP - Weppy File Format":"WEBP - Weppy File Format","Website:":"Site Internet:","Width (%):":"Largeur (%) :","Width:":"Largeur :","Wrong file type, must be image or json.":"Mauvais type de fichier, image ou json attendu.","X end:":"Fin X :","X position:":"Position x :","X start:":"Début X :","Y end:":"Fin Y :","Y position:":"Position y :","Y start:":"Début Y :","You can also drag and drop items into browser.":"Vous pouvez également faire glisser et déposer des éléments dans le navigateur.","Your browser does not support canvas or JavaScript is not enabled.":"Votre navigateur ne supporte pas le canevas ou JavaScript n'est pas activé.","Your browser does not support this format.":"Votre navigateur ne supporte pas ce format.","Your search did not match any images.":"Votre recherche ne correspond à aucune image.","Zoom":"Zoom","Zoom Blur":"Zoom Flou","Zoom In":"Agrandir","Zoom Out":"Réduire","Zoom blur":"Zoom flou","Zoom in":"Zoomer","Zoom out":"Dézoomer","Zoom:":"Zoom :"}

/***/ }),
/* 44 */
/***/ (function(module, exports) {

module.exports = {"2d":"2d","480p":"480p","About":"Di","Active":"Attivo","Advanced":"Avanzate","All":"Tutti","Alpha:":"Alfa:","Anonymous":"Anonimo","Anti aliasing":"Anti aliasing","Arial":"Arial","Arrow":"Freccia","Author:":"Autore:","Auto adjust colors":"Regola automaticamente i colori","Average:":"Media:","BMP - Windows Bitmap":"BMP - Bitmap di Windows","Base":"Base","Basic":"Di base","Black and White":"Bianco e nero","Blue":"Blu","Blue channel:":"Canale blu:","Blue:":"Blu:","Blur Radius:":"Sfocatura raggio:","Blur power:":"Sfocatura:","Blur tool":"Strumento di sfocatura","Bold":"Grassetto","Bold Italic":"Italico grassetto","Borders":"frontiere","Box Blur":"Box Blur","Box blur":"Scatola sfocatura","Brightness":"Luminosità","Brightness:":"Luminosità:","Brush":"Spazzola","Bulge/Pinch tool":"Bulge / Pinch tool","Burn":"Bruciare","CSS filters":"Filtri CSS","Can not animate 1 layer.":"Impossibile animare 1 livello.","Can not find previous layer.":"Impossibile trovare il livello precedente.","Cancel":"Annulla","Center":"Centro","Center x:":"Centro x:","Center y:":"Centro y:","Center:":"Centro:","Channel:":"Canale:","Circle":"Cerchio","Clear":"Chiaro","Clone count:":"Conteggio dei cloni:","Clone tool":"Strumento clone","Cloned edges":"Bordi clonati","Color #":"Colore #","Color Zoom":"Zoom a colori","Color alpha value can not be zero.":"Il valore alfa del colore non può essere zero.","Color corrections":"Correzioni di colore","Color palette":"Palette dei colori","Color to alpha":"Colore ad alfa","Color zoom":"Zoom a colori","Color:":"Colore:","Colors":"Colori","Colors:":"Colori:","Composition":"Composizione","Composition:":"Composizione:","Content fill":"Riempimento del contenuto","Contrast":"Contrasto","Contrast:":"Contrasto:","Convert to raster":"Converti in raster","Copy selection":"Copia selezione","Copy:":"Copia:","Courier":"Corriere","Crop":"raccolto","Ctrl+V":"Ctrl + V","Ctrl-P":"Ctrl-P","Current":"attuale","Curve":"Curva","Custom":"costume","Data URL":"URL dei dati","Data URL:":"URL dei dati:","Decrease color depth":"Diminuisci la profondità del colore","Default":"Predefinito","Degree:":"Grado:","Del":"del","Delete":"Elimina","Delete selection":"Elimina selezione","Denoise":"Denoise","Desaturate":"Togli saturazione","Description:":"Descrizione:","Differences":"differenze","Differences Down":"Differenze giù","Dither":"oscillare","Dithering:":"dithering:","Dominant color:":"Colore dominante:","Dot Screen":"Schermo a punti","Down":"Giù","Duplicate":"Duplicare","Edge":"Bordo","Edit":"modificare","Edit text":"Modifica il testo","Edit text...":"Modifica il testo...","Effects":"effetti","Email:":"E-mail:","Emboss":"rilievo","Empty selection":"Selezione vuota","Empty selection or type not image.":"Selezione vuota o tipo non immagine.","English":"Inglese","Enrich":"Arricchire","Erase":"Cancellare","Erase on rotate object is disabled. Sorry.":"Cancella su ruotare l'oggetto è disabilitato. Scusate.","Error":"Errore","Error connecting to service.":"Errore durante la connessione al servizio.","Error: can not load image.":"Errore: impossibile caricare l'immagine.","Error: missing details event target":"Errore: manca il bersaglio dell'evento dettagli","Error: unsupported attribute type:":"Errore: tipo di attributo non supportato:","Error: wrong key:":"Errore: chiave errata:","Español":"Español","Expand edges":"Espandi i bordi","Exponent:":"Esponente:","Factor:":"Fattore:","File":"File","File name:":"Nome del file:","File size:":"Dimensione del file:","Fill":"Riempire","Fit":"In forma","Fit window":"Finestra adatta","Flatten Image":"Immagine piatta","Flip":"Flip","FloydSteinberg-serpentine":"FloydSteinberg-serpentina","French":"francese","Full HD, 1080p":"Full HD, 1080p","GIF - Graphics Interchange Format":"GIF - Graphics Interchange Format","Gap:":"Gap:","Gaussian Blur":"Sfocatura gaussiana","German":"Tedesco","Gif delay:":"Ritardo Gif:","GitHub:":"GitHub:","Gradient":"Pendenza","Gradient Radius:":"Raggio di pendenza:","Grains":"Grani","Gray":"Grigio","Grayscale":"Scala di grigi","Green":"verde","Green channel:":"Canale Verde:","Green:":"Verde:","Greyscale:":"Scala di grigi:","Grid":"Griglia","Grid on/off":"Griglia on / off","H Radius:":"Raggio H:","Heatmap":"Mappa di calore","Height (%):":"Altezza (%):","Height:":"Altezza:","Help":"Aiuto","Helvetica":"Helvetica","Hermite":"Hermite","Hex:":"Esadecimale:","Histogram":"Istogramma","Histogram:":"Istogramma:","Horizontal":"Orizzontale","Horizontal blur:":"Sfocatura orizzontale:","Hue Rotate":"Tonalità Ruota","Hue:":"Hue:","Image":"Immagine","Image data with multi-layers. Can be opened using miniPaint -":"Dati immagine con multi-layer. Può essere aperto usando miniPaint -","Impact":"urto","Information":"Informazione","Insert:":"Inserire:","Italiano":"Italiano","Italic":"Corsivo","JPG - JPG/JPEG Format":"JPG - Formato JPG / JPEG","JPG, WEBP quality:":"JPG, qualità WEBP:","JSON - Full layers data":"JSON - Dati a strati completi","Japanese":"giapponese","Key-points":"Punti chiave","Keyboard Shortcuts":"Tasti rapidi","Keyword:":"Parola chiave:","Korean":"coreano","Language":"linguaggio","Last modified":"Ultima modifica","Layer details":"Dettagli del livello","Layer is already image.":"Il livello è già immagine.","Layer must be image, convert it to raster to apply this tool.":"Il livello deve essere un'immagine, convertirlo in raster per applicare questo strumento.","Layers":"Livelli","Layers:":"strati:","Left":"Sinistra","Level:":"Livello:","Levels:":"livelli:","Lietuvių":"Lietuvių","Line":"Linea","Lum:":"Lum:","Luminance:":"Luminance:","Magic Wand Tool":"Strumento bacchetta magica","Merge Down":"Unisci giù","Merged":"Fusione","Mode:":"Modalità:","Module function not found.":"Funzione del modulo non trovata.","Modules class not found:":"Classe di moduli non trovata:","Mosaic":"Mosaico","Mouse:":"Topo:","Move":"Mossa","Move down":"Abbassati","Move up":"Andare avanti","Name:":"Nome:","Needs at least 2 layers.":"Ha bisogno di almeno 2 strati.","Negative":"Negativo","New":"Nuovo","New file":"Nuovo file","New from selection":"Novità dalla selezione","New layer":"Nuovo strato","New width can not be smaller then current width":"La nuova larghezza non può essere più piccola della larghezza attuale","Normal":"Normale","Nothing is selected.":"Niente è selezionato.","Offset X:":"Offset X:","Offset Y:":"Offset Y:","Oil":"Olio","Ok":"Ok","Online image editor.":"Editor di immagini online","Opacity":"Opacità","Opacity:":"Opacità:","Open":"Aperto","Open Data URL":"Apri URL dati","Open Directory":"Apri Directory","Open File":"Apri il file","Open URL":"Apri URL","Open data URL":"Apri l'URL dei dati","Original size":"Misura originale","PNG - Portable Network Graphics":"PNG - Portable Network Graphics","Palette":"Tavolozza","Parameter #1:":"Parametro n. 1:","Parameter #2:":"Parametro n. 2:","Paste":"Incolla","Pencil":"Matita","Percentage:":"Percentuale:","Pick Color":"Scegli colore","Pixels:":"pixel:","Play animation":"Riproduci animazione","Portuguese":"portoghese","Power:":"Energia:","Powred by  pixabay.com .":"Powred di pixabay.com.","Pre-Blur:":"Pre-Blur:","Preview":"Anteprima","Previous":"Precedente","Previous layer must be image, convert it to raster to apply this tool.":"Il livello precedente deve essere un'immagine, convertirlo in raster per applicare questo strumento.","Print":"Stampare","Quality:":"Qualità:","Quick load":"Carico rapido","Quick save":"Salvataggio veloce","Radial":"Radiale","Radial gradient":"Gradiente radiale","Radius:":"Raggio:","Range:":"Gamma:","Rectangle":"Rettangolo","Red":"Rosso","Red channel:":"Canale Rosso:","Red:":"Rosso:","Rename":"Rinominare","Replace Color":"Sostituisci colore","Replace color":"Sostituisci colore","Replacement:":"Sostituzione:","Report issues":"Segnala problemi","Resample - Hermite":"Ricampionare - Hermite","Reset":"Reset","Reset zoom level":"Reimposta il livello di zoom","Resize":"Ridimensiona","Resized as background":"Ridimensionato come sfondo","Resolution:":"Risoluzione:","Restore alpha":"Ripristina alpha","Right":"Destra","Right angle:":"Angolo retto:","Rotate":"Ruotare","Rotate is not supported on this type of object. Convert to raster?":"Ruota non è supportato su questo tipo di oggetto. Converti in raster?","Rotate left":"Gira a sinistra","Rotate:":"Ruotare:","Russian":"russo","Sat:":"Sat:","Saturate":"Saturare","Saturation:":"Saturazione:","Save":"Salvare","Save as":"Salva come","Save as data URL":"Salva come URL dei dati","Save as type:":"Salva come tipo:","Save layers:":"Salva livelli:","Save resolution:":"Salva risoluzione:","Scroll down":"Scorri verso il basso","Scroll up":"Scorrere verso l'alto","Search":"Ricerca","Search images":"Cerca immagini","Select all":"Seleziona tutto","Select object tool":"Seleziona lo strumento oggetto","Selected":"Selezionato","Selection":"Selezione","Sensitivity:":"sensibilità:","Sepia":"nero di seppia","Settings":"impostazioni","Shadow":"Ombra","Shadow:":"Ombra:","Sharpen":"Affilare","Sharpen tool":"Affila lo strumento","Sharpen:":"Affilare:","Show / Hide":"Mostra nascondi","Show file size:":"Mostra la dimensione del file:","Simple":"Semplice","Size":"Dimensione","Size is too big, max":"La dimensione è troppo grande, max","Size:":"Dimensione:","Skip - layer must be image.":"Salta: il livello deve essere un'immagine.","Solarize":"solarizzare","Sorry, image could not be loaded. Try copy image and paste it.":"Spiacenti, l'immagine non può essere caricata. Prova a copiare l'immagine e incollarla.","Sorry, image is too big, max 5 MB.":"Siamo spiacenti, l'immagine è troppo grande, max 5 MB.","Source is empty, right click on image to save source position.":"L'origine è vuota, fare clic con il tasto destro sull'immagine per salvare la posizione della fonte.","Sprites":"sprites","Square":"Piazza","Strength:":"Forza:","Strict":"Rigoroso","Stroke":"Ictus","Stroke:":"Ictus:","Target:":"Bersaglio:","Text":"Testo","Text example":"Esempio di testo","Text:":"Testo:","There are no layers behind.":"Non ci sono strati dietro.","There is only 1 layer.":"C'è solo 1 strato.","Tilt Shift":"Tilt Shift","Times New Roman":"Times New Roman","Toggle":"Toggle","Tools":"Utensili","Tools class not found:":"Classe di strumenti non trovata:","Total pixels:":"Pixel totali:","Translate":"Tradurre","Translate error, can not find dictionary:":"Traduci errore, impossibile trovare il dizionario:","Transparency background:":"Sfondo della trasparenza:","Transparent:":"Trasparente:","Trim":"tagliare","Trim everything:":"Taglia tutto:","Trim layer:":"Strato di rifinitura:","Trim white color?":"Tagliare il colore bianco?","Turkish":"Turco","Undo":"Disfare","Undo disabled.":"Annulla disabilitato.","Undo enabled.":"Annulla abilitato.","Undo is not available.":"Annulla non è disponibile.","Undo levels changed to 1.":"Annulla i livelli modificati in 1.","Undo levels restored to":"Annulla i livelli ripristinati in","Unique colors:":"Colori unici:","Up":"Su","Use Ctrl+V keyboard shortcut to paste from Clipboard.":"Usa la scorciatoia da tastiera Ctrl + V per incollare dagli Appunti.","V Radius:":"V raggio:","Verdana":"Verdana","Version:":"Versione:","Vertical":"Verticale","Vertical blur:":"Sfocatura verticale:","Vibrance":"Vibrance","Vignette":"vignette","ViliusL":"ViliusL","Vintage":"Vintage ▾","Visible:":"Visibile:","WEBP - Weppy File Format":"WEBP - Formato file Weppy","Website:":"Sito web:","Width (%):":"Larghezza (%):","Width:":"Larghezza:","Wrong file type, must be image or json.":"Tipo di file errato, deve essere immagine o json.","X end:":"X fine:","X position:":"Posizione X:","X start:":"X inizio:","Y end:":"Fine Y:","Y position:":"Posizione Y:","Y start:":"Y inizio:","You can also drag and drop items into browser.":"Puoi anche trascinare gli oggetti nel browser.","Your browser does not support canvas or JavaScript is not enabled.":"Il tuo browser non supporta canvas o JavaScript non è abilitato.","Your browser does not support this format.":"Il tuo browser non supporta questo formato.","Your search did not match any images.":"La tua ricerca non corrisponde ad alcuna immagine.","Zoom":"Zoom","Zoom Blur":"Zoom sfocatura","Zoom In":"Ingrandire","Zoom Out":"Zoom indietro","Zoom blur":"Sfocatura dello zoom","Zoom in":"Ingrandire","Zoom out":"Zoom indietro","Zoom:":"Zoom:"}

/***/ }),
/* 45 */
/***/ (function(module, exports) {

module.exports = {"2d":"2d","480p":"480p","About":"約","Active":"アクティブ","Advanced":"上級","All":"すべて","Alpha:":"アルファ：","Anonymous":"匿名","Anti aliasing":"アンチエイリアシング","Arial":"Arial","Arrow":"矢印","Author:":"著者：","Auto adjust colors":"色を自動調整する","Average:":"平均：","BMP - Windows Bitmap":"BMP  -  Windowsビットマップ","Base":"ベース","Basic":"ベーシック","Black and White":"黒と白","Blue":"青","Blue channel:":"ブルーチャンネル：","Blue:":"青：","Blur Radius:":"ぼかし半径：","Blur power:":"ぼかしパワー：","Blur tool":"ぼかしツール","Bold":"大胆な","Bold Italic":"ボールドイタリック","Borders":"罫線","Box Blur":"ボックスのぼかし","Box blur":"ボックスボケ","Brightness":"輝度","Brightness:":"輝度：","Brush":"みがきます","Bulge/Pinch tool":"バルジ/ピンチツール","Burn":"燃やす","CSS filters":"CSSフィルタ","Can not animate 1 layer.":"1つのレイヤーをアニメートできません。","Can not find previous layer.":"以前のレイヤーが見つかりません。","Cancel":"キャンセル","Center":"センター","Center x:":"センターx：","Center y:":"センターy：","Center:":"センター：","Channel:":"チャネル：","Circle":"サークル","Clear":"クリア","Clone count:":"クローン数：","Clone tool":"クローンツール","Cloned edges":"クローンエッジ","Color #":"色 ＃","Color Zoom":"カラーズーム","Color alpha value can not be zero.":"色のアルファ値はゼロにすることはできません。","Color corrections":"色補正","Color palette":"カラーパレット","Color to alpha":"カラーからアルファ","Color zoom":"カラーズーム","Color:":"色：","Colors":"色","Colors:":"色：","Composition":"組成","Composition:":"組成：","Content fill":"コンテンツの埋め込み","Contrast":"コントラスト","Contrast:":"コントラスト：","Convert to raster":"ラスタに変換する","Copy selection":"選択コピー","Copy:":"コピー：","Courier":"宅配便","Crop":"作物","Ctrl+V":"Ctrl + V","Ctrl-P":"Ctrl-P","Current":"現在","Curve":"曲線","Custom":"カスタム","Data URL":"データURL","Data URL:":"データURL：","Decrease color depth":"色深度を減らす","Default":"デフォルト","Degree:":"度：","Del":"デル","Delete":"削除","Delete selection":"選択を削除する","Denoise":"デノアーズ","Desaturate":"不飽和化する","Description:":"説明：","Differences":"相違点","Differences Down":"相違点","Dither":"ディザ","Dithering:":"ディザリング：","Dominant color:":"支配的な色：","Dot Screen":"ドットスクリーン","Down":"ダウン","Duplicate":"重複","Edge":"エッジ","Edit":"編集","Edit text":"テキストを編集する","Edit text...":"テキストを編集...","Effects":"エフェクト","Email:":"Eメール：","Emboss":"エンボス","Empty selection":"空の選択","Empty selection or type not image.":"空の選択またはタイプではない画像。","English":"英語","Enrich":"エンリッチ","Erase":"消去する","Erase on rotate object is disabled. Sorry.":"回転オブジェクトの消去が無効になっています。ごめんなさい。","Error":"エラー","Error connecting to service.":"サービスに接続中にエラーが発生しました。","Error: can not load image.":"エラー：画像を読み込めません。","Error: missing details event target":"エラー：詳細イベントターゲットがありません","Error: unsupported attribute type:":"エラー：サポートされていない属性タイプ：","Error: wrong key:":"エラー：間違ったキー：","Español":"スペイン語","Expand edges":"エッジを開く","Exponent:":"指数：","Factor:":"因子：","File":"ファイル","File name:":"ファイル名：","File size:":"ファイルサイズ：","Fill":"塗りつぶす","Fit":"フィット","Fit window":"ウィンドウに合わせる","Flatten Image":"画像を平ら","Flip":"フリップ","FloydSteinberg-serpentine":"FloydSteinberg-蛇紋文字","French":"フランス語","Full HD, 1080p":"フルHD、1080p","GIF - Graphics Interchange Format":"GIF  - グラフィックスインターチェンジ形式","Gap:":"ギャップ：","Gaussian Blur":"ガウスぼかし","German":"ドイツ人","Gif delay:":"GIF遅延：","GitHub:":"GitHub：","Gradient":"勾配","Gradient Radius:":"勾配半径：","Grains":"穀類","Gray":"グレー","Grayscale":"グレースケール","Green":"緑","Green channel:":"グリーンチャネル：","Green:":"緑：","Greyscale:":"グレースケール：","Grid":"グリッド","Grid on/off":"グリッドのオン/オフ","H Radius:":"H半径：","Heatmap":"ヒートマップ","Height (%):":"高さ （％）：","Height:":"高さ：","Help":"助けて","Helvetica":"ヘルベチカ","Hermite":"エルミート","Hex:":"16進数：","Histogram":"ヒストグラム","Histogram:":"ヒストグラム：","Horizontal":"水平","Horizontal blur:":"水平ブラー：","Hue Rotate":"色相回転","Hue:":"色相：","Image":"画像","Image data with multi-layers. Can be opened using miniPaint -":"マルチレイヤーの画像データ。 miniPaintを使用して開くことができます -","Impact":"影響","Information":"情報","Insert:":"インサート：","Italiano":"イタリア語","Italic":"イタリック","JPG - JPG/JPEG Format":"JPG  -  JPG / JPEG形式","JPG, WEBP quality:":"JPG、WEBP品質：","JSON - Full layers data":"JSON  - フルレイヤーデータ","Japanese":"日本語","Key-points":"キーポイント","Keyboard Shortcuts":"キーボードショートカット","Keyword:":"キーワード：","Korean":"韓国語","Language":"言語","Last modified":"最終更新日","Layer details":"レイヤの詳細","Layer is already image.":"レイヤは既に画像です。","Layer must be image, convert it to raster to apply this tool.":"レイヤはイメージでなければならず、このツールを適用するにはラスタに変換する必要があります。","Layers":"レイヤー","Layers:":"レイヤー：","Left":"左","Level:":"レベル：","Levels:":"レベル：","Lietuvių":"Lietuvių","Line":"ライン","Lum:":"Lum：","Luminance:":"輝度：","Magic Wand Tool":"マジックワンドツール","Merge Down":"マージダウン","Merged":"合併","Mode:":"モード：","Module function not found.":"モジュール機能が見つかりません。","Modules class not found:":"モジュールクラスが見つかりません：","Mosaic":"モザイク","Mouse:":"マウス：","Move":"移動","Move down":"下に移動","Move up":"上がる","Name:":"名：","Needs at least 2 layers.":"少なくとも2つの層が必要です。","Negative":"負","New":"新しい","New file":"新しいファイル","New from selection":"新しい選択から","New layer":"新しいレイヤー","New width can not be smaller then current width":"新しい幅は現在の幅より小さくすることはできません","Normal":"ノーマル","Nothing is selected.":"何も選択されていません。","Offset X:":"オフセットX：","Offset Y:":"オフセットY：","Oil":"油","Ok":"OK","Online image editor.":"オンラインイメージエディタ。","Opacity":"不透明度","Opacity:":"不透明度：","Open":"開いた","Open Data URL":"公開データURL","Open Directory":"オープンディレクトリ","Open File":"ファイルを開く","Open URL":"URLを開く","Open data URL":"公開データURL","Original size":"オリジナルサイズ","PNG - Portable Network Graphics":"PNG  - ポータブルネットワークグラフィックス","Palette":"パレット","Parameter #1:":"パラメータ＃1：","Parameter #2:":"パラメータ＃2：","Paste":"ペースト","Pencil":"鉛筆","Percentage:":"パーセンテージ：","Pick Color":"ピックカラー","Pixels:":"ピクセル：","Play animation":"アニメーションを再生する","Portuguese":"ポルトガル","Power:":"力：","Powred by  pixabay.com .":"pixabay.comのPowred","Pre-Blur:":"プリブラー：","Preview":"プレビュー","Previous":"前","Previous layer must be image, convert it to raster to apply this tool.":"前のレイヤーはイメージでなければならず、このツールを適用するにはラスターに変換する必要があります。","Print":"印刷","Quality:":"品質：","Quick load":"クイックロード","Quick save":"クイックセーブ","Radial":"ラジアル","Radial gradient":"放射グラジエント","Radius:":"半径：","Range:":"範囲：","Rectangle":"矩形","Red":"赤","Red channel:":"赤いチャンネル：","Red:":"赤：","Rename":"名前を変更する","Replace Color":"色を置き換える","Replace color":"色を交換する","Replacement:":"置換：","Report issues":"レポートの問題","Resample - Hermite":"リサンプル - エルミート","Reset":"リセット","Reset zoom level":"ズームレベルのリセット","Resize":"サイズを変更する","Resized as background":"背景としてサイズ変更","Resolution:":"解決：","Restore alpha":"アルファを復元する","Right":"右","Right angle:":"直角：","Rotate":"回転する","Rotate is not supported on this type of object. Convert to raster?":"このタイプのオブジェクトでは、回転はサポートされていません。ラスタに変換しますか？","Rotate left":"左に回転","Rotate:":"回転：","Russian":"ロシア","Sat:":"土：","Saturate":"飽和","Saturation:":"飽和：","Save":"セーブ","Save as":"名前を付けて保存","Save as data URL":"データURLとして保存","Save as type:":"タイプとして保存：","Save layers:":"レイヤーを保存：","Save resolution:":"解像度を保存：","Scroll down":"下へスクロール","Scroll up":"スクロールアップする","Search":"サーチ","Search images":"画像を検索する","Select all":"すべて選択","Select object tool":"オブジェクトツールを選択","Selected":"選択された","Selection":"選択","Sensitivity:":"感度：","Sepia":"セピア","Settings":"設定","Shadow":"影","Shadow:":"影：","Sharpen":"シャープ","Sharpen tool":"シャープツール","Sharpen:":"シャープ：","Show / Hide":"表示/非表示","Show file size:":"ファイルサイズを表示：","Simple":"シンプル","Size":"サイズ","Size is too big, max":"サイズが大きすぎます","Size:":"サイズ：","Skip - layer must be image.":"スキップ - レイヤはイメージでなければなりません。","Solarize":"ソラリゼーション","Sorry, image could not be loaded. Try copy image and paste it.":"申し訳ありませんが、画像を読み込めませんでした。イメージをコピーして貼り付けてみてください。","Sorry, image is too big, max 5 MB.":"申し訳ありませんが、イメージが大きすぎます（最大5 MB）。","Source is empty, right click on image to save source position.":"ソースは空です。イメージを右クリックするとソースの位置が保存されます。","Sprites":"スプライト","Square":"平方","Strength:":"力：","Strict":"厳格","Stroke":"ストローク","Stroke:":"ストローク：","Target:":"ターゲット：","Text":"テキスト","Text example":"テキストの例","Text:":"テキスト：","There are no layers behind.":"後ろに層がありません。","There is only 1 layer.":"レイヤーは1つしかありません。","Tilt Shift":"チルトシフト","Times New Roman":"Times New Roman","Toggle":"トグル","Tools":"ツール","Tools class not found:":"ツールクラスが見つかりません：","Total pixels:":"合計ピクセル数：","Translate":"翻訳","Translate error, can not find dictionary:":"翻訳エラー、辞書が見つかりません：","Transparency background:":"透明性の背景：","Transparent:":"トランスペアレント：","Trim":"トリム","Trim everything:":"すべてをトリム：","Trim layer:":"トリムレイヤー：","Trim white color?":"白い色をトリム？","Turkish":"トルコ語","Undo":"元に戻す","Undo disabled.":"元に戻すことはできません。","Undo enabled.":"取り消しが有効になっています。","Undo is not available.":"元に戻すことはできません。","Undo levels changed to 1.":"元に戻すレベルが1に変更されました。","Undo levels restored to":"元に戻すレベルを元に戻す","Unique colors:":"ユニークな色：","Up":"アップ","Use Ctrl+V keyboard shortcut to paste from Clipboard.":"Ctrl + Vキーボードショートカットを使用してクリップボードから貼り付けます。","V Radius:":"V半径：","Verdana":"ヴェルダナ","Version:":"バージョン：","Vertical":"垂直","Vertical blur:":"垂直方向のぼかし：","Vibrance":"バイブランス","Vignette":"ビネット","ViliusL":"ViliusL","Vintage":"ビンテージ","Visible:":"表示：","WEBP - Weppy File Format":"WEBP  - ウィピーファイルフォーマット","Website:":"ウェブサイト：","Width (%):":"幅（％）：","Width:":"幅：","Wrong file type, must be image or json.":"間違ったファイルタイプです。画像またはjsonでなければなりません。","X end:":"X end：","X position:":"X位置：","X start:":"Xスタート：","Y end:":"Y end：","Y position:":"Y位置：","Y start:":"Y開始：","You can also drag and drop items into browser.":"アイテムをブラウザにドラッグアンドドロップすることもできます。","Your browser does not support canvas or JavaScript is not enabled.":"ブラウザがキャンバスをサポートしていないか、JavaScriptが有効になっていません。","Your browser does not support this format.":"お使いのブラウザはこの形式をサポートしていません。","Your search did not match any images.":"あなたの検索はどの画像にも一致しませんでした。","Zoom":"ズーム","Zoom Blur":"ズームぼかし","Zoom In":"ズームイン","Zoom Out":"ズームアウトする","Zoom blur":"ズームブラー","Zoom in":"ズームイン","Zoom out":"ズームアウトする","Zoom:":"ズーム："}

/***/ }),
/* 46 */
/***/ (function(module, exports) {

module.exports = {"2d":"2d","480p":"480p","About":"약","Active":"유효한","Advanced":"많은","All":"모든","Alpha:":"알파 :","Anonymous":"익명","Anti aliasing":"안티 앨리어싱","Arial":"Arial","Arrow":"화살","Author:":"저자:","Auto adjust colors":"색상 자동 조정","Average:":"평균:","BMP - Windows Bitmap":"BMP - Windows 비트 맵","Base":"베이스","Basic":"기본","Black and White":"검정색과 흰색","Blue":"푸른","Blue channel:":"파란색 채널 :","Blue:":"푸른:","Blur Radius:":"흐리게 반경 :","Blur power:":"흐림 효과 :","Blur tool":"블러 도구","Bold":"대담한","Bold Italic":"굵은 기울임 꼴","Borders":"테두리","Box Blur":"상자 흐림 효과","Box blur":"상자 흐림 효과","Brightness":"명도","Brightness:":"명도:","Brush":"브러시","Bulge/Pinch tool":"벌지 / 핀치 도구","Burn":"화상","CSS filters":"CSS 필터","Can not animate 1 layer.":"1 개의 레이어를 애니메이션으로 만들 수 없습니다.","Can not find previous layer.":"이전 레이어를 찾을 수 없습니다.","Cancel":"취소","Center":"센터","Center x:":"센터 x :","Center y:":"센터 y :","Center:":"센터:","Channel:":"채널:","Circle":"원","Clear":"명확한","Clone count:":"클론 횟수 :","Clone tool":"복제 도구","Cloned edges":"복제 된 가장자리","Color #":"색깔 #","Color Zoom":"색상 확대 / 축소","Color alpha value can not be zero.":"색상 알파 값은 0 일 수 없습니다.","Color corrections":"색상 보정","Color palette":"색상 팔레트","Color to alpha":"알파에서 색상으로","Color zoom":"색상 확대 / 축소","Color:":"색깔:","Colors":"그림 물감","Colors:":"그림 물감:","Composition":"구성","Composition:":"구성:","Content fill":"콘텐츠 채우기","Contrast":"대조","Contrast:":"대조:","Convert to raster":"래스터로 변환","Copy selection":"선택 항목 복사","Copy:":"부:","Courier":"급사","Crop":"수확고","Ctrl+V":"Ctrl + V","Ctrl-P":"Ctrl-P","Current":"흐름","Curve":"곡선","Custom":"관습","Data URL":"데이터 URL","Data URL:":"데이터 URL :","Decrease color depth":"색상 심도 감소","Default":"태만","Degree:":"정도:","Del":"델","Delete":"지우다","Delete selection":"선택 항목 삭제","Denoise":"데니스 이스","Desaturate":"불포화","Description:":"기술:","Differences":"차이점","Differences Down":"차이점","Dither":"떨림","Dithering:":"디더링 :","Dominant color:":"주된 색깔 :","Dot Screen":"도트 스크린","Down":"하위","Duplicate":"복제","Edge":"가장자리","Edit":"편집하다","Edit text":"텍스트 수정","Edit text...":"텍스트 수정 ...","Effects":"효과","Email:":"이메일:","Emboss":"엠보싱","Empty selection":"빈 선택","Empty selection or type not image.":"이미지를 선택하지 않거나 입력하지 마십시오.","English":"영어","Enrich":"높이다","Erase":"삭제","Erase on rotate object is disabled. Sorry.":"회전 객체에서 지우기가 비활성화됩니다. 죄송합니다.","Error":"오류","Error connecting to service.":"서비스에 연결하는 중 오류가 발생했습니다.","Error: can not load image.":"오류 : 이미지를로드 할 수 없습니다.","Error: missing details event target":"오류 : 세부 정보 이벤트 대상이 누락되었습니다.","Error: unsupported attribute type:":"오류 : 지원되지 않는 속성 유형 :","Error: wrong key:":"오류 : 잘못된 키 :","Español":"스페인어","Expand edges":"가장자리 확장","Exponent:":"멱지수:","Factor:":"인자:","File":"파일","File name:":"파일 이름:","File size:":"파일 크기 :","Fill":"가득 따르다","Fit":"적당한","Fit window":"창에 맞추기","Flatten Image":"납작한 이미지","Flip":"튀기다","FloydSteinberg-serpentine":"FloydSteinberg- 사문석","French":"프랑스 국민","Full HD, 1080p":"풀 HD, 1080p","GIF - Graphics Interchange Format":"GIF - 그래픽 교환 형식","Gap:":"갭:","Gaussian Blur":"가우스 흐림","German":"독일 사람","Gif delay:":"GIF 지연 :","GitHub:":"GitHub :","Gradient":"구배","Gradient Radius:":"기울기 반경 :","Grains":"작살","Gray":"회색","Grayscale":"그레이 스케일","Green":"녹색","Green channel:":"녹색 통로:","Green:":"녹색:","Greyscale:":"그레이 스케일 :","Grid":"그리드","Grid on/off":"그리드 켜기 / 끄기","H Radius:":"H 반경 :","Heatmap":"히트 맵","Height (%):":"높이 (%) :","Height:":"신장:","Help":"도움","Helvetica":"헬 베티 카","Hermite":"허 마이트","Hex:":"마녀:","Histogram":"히스토그램","Histogram:":"히스토그램 :","Horizontal":"수평","Horizontal blur:":"가로 흐리게 :","Hue Rotate":"색조 회전","Hue:":"색조:","Image":"영상","Image data with multi-layers. Can be opened using miniPaint -":"다중 레이어가있는 이미지 데이터. miniPaint를 사용하여 열 수 있습니다 -","Impact":"충격","Information":"정보","Insert:":"끼워 넣다:","Italiano":"이탈리아어","Italic":"이탤릭체","JPG - JPG/JPEG Format":"JPG - JPG / JPEG 형식","JPG, WEBP quality:":"JPG, WEBP 품질 :","JSON - Full layers data":"JSON - 전체 레이어 데이터","Japanese":"일본어","Key-points":"키 포인트","Keyboard Shortcuts":"키보드 단축키","Keyword:":"예어:","Korean":"한국어","Language":"언어","Last modified":"최종 수정일","Layer details":"레이어 세부 정보","Layer is already image.":"레이어는 이미 이미지입니다.","Layer must be image, convert it to raster to apply this tool.":"레이어는 이미지 여야하며이 도구를 적용하려면 래스터로 변환해야합니다.","Layers":"레이어","Layers:":"레이어 :","Left":"왼쪽","Level:":"수평:","Levels:":"레벨 :","Lietuvių":"Lietuvių","Line":"선","Lum:":"Lum :","Luminance:":"휘도 :","Magic Wand Tool":"마법 지팡이 도구","Merge Down":"병합","Merged":"병합 됨","Mode:":"방법:","Module function not found.":"모듈 기능을 찾을 수 없습니다.","Modules class not found:":"모듈 클래스를 찾을 수 없음 :","Mosaic":"모자이크","Mouse:":"쥐:","Move":"움직임","Move down":"아래로 이동","Move up":"이동","Name:":"이름:","Needs at least 2 layers.":"최소한 2 개의 레이어가 필요합니다.","Negative":"부정","New":"새로운","New file":"새로운 파일","New from selection":"선택 항목의 새로운 기능","New layer":"새 레이어","New width can not be smaller then current width":"새 너비는 현재 너비보다 작을 수 없습니다.","Normal":"표준","Nothing is selected.":"아무것도 선택되지 않았습니다.","Offset X:":"오프셋 X :","Offset Y:":"오프셋 Y :","Oil":"기름","Ok":"승인","Online image editor.":"온라인 이미지 편집기.","Opacity":"불투명","Opacity:":"불투명:","Open":"열다","Open Data URL":"공개 데이터 URL","Open Directory":"오픈 디렉토리","Open File":"파일 열기","Open URL":"URL 열기","Open data URL":"공개 데이터 URL","Original size":"원본 크기","PNG - Portable Network Graphics":"PNG - 휴대용 네트워크 그래픽","Palette":"팔레트","Parameter #1:":"매개 변수 # 1 :","Parameter #2:":"매개 변수 # 2 :","Paste":"풀","Pencil":"연필","Percentage:":"백분율:","Pick Color":"색상 선택","Pixels:":"픽셀 :","Play animation":"애니메이션 재생","Portuguese":"포르투갈 인","Power:":"힘:","Powred by  pixabay.com .":"pixabay.com의 Powred.","Pre-Blur:":"사전 흐림 효과 :","Preview":"시사","Previous":"너무 이른","Previous layer must be image, convert it to raster to apply this tool.":"이전 레이어는 이미지 여야하며이 도구를 적용하려면 래스터로 변환해야합니다.","Print":"인쇄","Quality:":"품질:","Quick load":"빠른로드","Quick save":"빠른 저장","Radial":"방사형","Radial gradient":"방사형 그래디언트","Radius:":"반지름:","Range:":"범위:","Rectangle":"구형","Red":"빨간","Red channel:":"적색 통로:","Red:":"빨간:","Rename":"이름 바꾸기","Replace Color":"색상 바꾸기","Replace color":"색상 바꾸기","Replacement:":"바꿔 놓음:","Report issues":"문제 신고","Resample - Hermite":"리 샘플 - Hermite","Reset":"다시 놓기","Reset zoom level":"확대 / 축소 레벨 재설정","Resize":"크기 조정","Resized as background":"배경으로 크기 조정","Resolution:":"해결:","Restore alpha":"알파 복원","Right":"권리","Right angle:":"직각:","Rotate":"회전","Rotate is not supported on this type of object. Convert to raster?":"회전은이 유형의 객체에서 지원되지 않습니다. 래스터로 변환 하시겠습니까?","Rotate left":"왼쪽으로 회전","Rotate:":"회전 :","Russian":"러시아인","Sat:":"토 :","Saturate":"가득한","Saturation:":"포화:","Save":"구하다","Save as":"다른 이름으로 저장","Save as data URL":"데이터 URL로 저장","Save as type:":"유형으로 저장 :","Save layers:":"레이어 저장 :","Save resolution:":"해상도 절약 :","Scroll down":"아래로 스크롤","Scroll up":"스크롤","Search":"수색","Search images":"이미지 검색","Select all":"모두 선택","Select object tool":"오브젝트 도구 선택","Selected":"선택된","Selection":"선택","Sensitivity:":"감광도:","Sepia":"세피아","Settings":"설정","Shadow":"그림자","Shadow:":"그림자:","Sharpen":"갈다","Sharpen tool":"선명 도구","Sharpen:":"갈다:","Show / Hide":"표시 / 숨기기","Show file size:":"파일 크기 표시 :","Simple":"단순한","Size":"크기","Size is too big, max":"크기가 너무 큽니다.","Size:":"크기:","Skip - layer must be image.":"건너 뛰기 - 레이어가 이미지 여야합니다.","Solarize":"솔라 이즈","Sorry, image could not be loaded. Try copy image and paste it.":"죄송합니다. 이미지를로드 할 수 없습니다. 이미지 복사 및 붙여 넣기를 시도하십시오.","Sorry, image is too big, max 5 MB.":"죄송합니다. 이미지가 너무 크고 최대 5MB입니다.","Source is empty, right click on image to save source position.":"소스가 비어 있습니다. 소스 위치를 저장하려면 이미지를 마우스 오른쪽 버튼으로 클릭하십시오.","Sprites":"스프라이트","Square":"광장","Strength:":"힘:","Strict":"엄격한","Stroke":"행정","Stroke:":"행정:","Target:":"목표:","Text":"본문","Text example":"텍스트 예제","Text:":"본문:","There are no layers behind.":"뒤에 레이어가 없습니다.","There is only 1 layer.":"단 하나의 레이어가 있습니다.","Tilt Shift":"경사 변화","Times New Roman":"Times New Roman","Toggle":"비녀장","Tools":"도구들","Tools class not found:":"도구 클래스를 찾을 수 없음 :","Total pixels:":"총 픽셀 수 :","Translate":"옮기다","Translate error, can not find dictionary:":"번역 오류, 사전을 찾을 수 없음 :","Transparency background:":"투명도 배경 :","Transparent:":"투명한:","Trim":"손질","Trim everything:":"모든 것을 다듬습니다 :","Trim layer:":"레이어 다듬기 :","Trim white color?":"흰색을 다듬을까요?","Turkish":"터키어","Undo":"끄르다","Undo disabled.":"실행 취소가 해제되었습니다.","Undo enabled.":"실행 취소가 활성화되었습니다.","Undo is not available.":"실행 취소를 사용할 수 없습니다.","Undo levels changed to 1.":"실행 취소 수준이 1로 변경되었습니다.","Undo levels restored to":"복원 된 실행 취소 수준","Unique colors:":"독특한 색상 :","Up":"쪽으로","Use Ctrl+V keyboard shortcut to paste from Clipboard.":"Ctrl + V 키보드 단축키를 사용하여 클립 보드에서 붙여 넣기하십시오.","V Radius:":"V 반경 :","Verdana":"Verdana","Version:":"번역:","Vertical":"수직선","Vertical blur:":"수직 흐림 효과 :","Vibrance":"활기찬","Vignette":"삽화","ViliusL":"ViliusL","Vintage":"포도 수확","Visible:":"명백한:","WEBP - Weppy File Format":"WEBP - 위피 파일 형식","Website:":"웹 사이트 :","Width (%):":"너비 (%) :","Width:":"폭:","Wrong file type, must be image or json.":"잘못된 파일 유형. 이미지 또는 json이어야합니다.","X end:":"X 끝 :","X position:":"X 위치 :","X start:":"X 시작 :","Y end:":"Y 끝 :","Y position:":"Y 위치 :","Y start:":"Y 시작 :","You can also drag and drop items into browser.":"항목을 브라우저로 끌어다 놓을 수도 있습니다.","Your browser does not support canvas or JavaScript is not enabled.":"브라우저가 캔버스를 지원하지 않거나 JavaScript가 활성화되어 있지 않습니다.","Your browser does not support this format.":"브라우저가이 형식을 지원하지 않습니다.","Your search did not match any images.":"검색어와 일치하는 이미지가 없습니다.","Zoom":"줌","Zoom Blur":"줌 블러","Zoom In":"확대","Zoom Out":"축소","Zoom blur":"줌 흐림 효과","Zoom in":"확대","Zoom out":"축소","Zoom:":"줌:"}

/***/ }),
/* 47 */
/***/ (function(module, exports) {

module.exports = {"2d":"2d","480p":"480p","About":"Apie","Active":"Aktyvus","Advanced":"Pažangus","All":"Visi","Alpha:":"Alfa:","Anonymous":"Anoniminis","Anti aliasing":"Sulieti","Arial":"Arial","Arrow":"Rodyklė","Author:":"Autorius:","Auto adjust colors":"Sureguliuoti spalvas","Average:":"Vidurkis:","BMP - Windows Bitmap":"BMP - Windows Bitmap","Base":"Bazė","Basic":"Paprastas","Black and White":"Juoda ir balta","Blue":"Mėlynas","Blue channel:":"Mėlyna kanalas:","Blue:":"Mėlyna:","Blur Radius:":"Migla spindulys:","Blur power:":"Blur stiprumas:","Blur tool":"Migla įrankis","Bold":"Bold","Bold Italic":"Bold Italic","Borders":"Ribojasi","Box Blur":"Box Blur","Box blur":"Langelis blur","Brightness":"Ryškumas","Brightness:":"Ryškumas:","Brush":"Šepetys","Bulge/Pinch tool":"Bumbulas/Žiupsnelis","Burn":"Deginti","CSS filters":"CSS filtrai","Can not animate 1 layer.":"Negalima animuoti 1 sluoksniu.","Can not find previous layer.":"Negaliu rasti ankstesnio sluoksnio.","Cancel":"Atšaukti","Center":"Centras","Center x:":"Centras x:","Center y:":"Centras y:","Center:":"Centras:","Channel:":"Kanalas:","Circle":"Ratas","Clear":"Aiškus","Clone count:":"Klonų skaičius:","Clone tool":"Klonas įrankis","Cloned edges":"Klonuoti kraštai","Color #":"Spalva #","Color Zoom":"Spalvų mastelio keitimas","Color alpha value can not be zero.":"Spalvų alfa vertė negali būti lygi nuliui.","Color corrections":"Spalvų korekcijos","Color palette":"Spalvų paletė","Color to alpha":"Spalva alfa","Color zoom":"Spalvų priartinimas","Color:":"Spalva:","Colors":"Spalvos","Colors:":"Spalvos:","Composition":"Kompozicija","Composition:":"Sudėtis:","Content fill":"Turinio užpildymas","Contrast":"Kontrastas","Contrast:":"Kontrastas:","Convert to raster":"Konvertuoti į rastrą","Copy selection":"Kopijuoti pasirinkimą","Copy:":"Kopijuoti:","Courier":"Courier","Crop":"Iškirpti","Ctrl+V":"Ctrl + v","Ctrl-P":"Ctrl-p","Current":"Dabartinis","Curve":"Kreivė","Custom":"Kitas","Data URL":"Duomenų adresas","Data URL:":"Duomenų adresas:","Decrease color depth":"Sumažinti spalvų gylį","Default":"Numatytas","Degree:":"Laipsnis:","Del":"Del","Delete":"Ištrinti","Delete selection":"Ištrinti pasirinkimą","Denoise":"Sumažinti triukšmą","Desaturate":"Sumažinti ryškumą","Description:":"Aprašymas:","Differences":"Skirtumai","Differences Down":"Skirtumai žemyn","Dither":"Papildymas","Dithering:":"Papildymu:","Dominant color:":"Dominuojanti spalva:","Dot Screen":"Taškų ekranas","Down":"Žemyn","Duplicate":"Pasikartojantis","Edge":"Kraštas","Edit":"Redaguoti","Edit text":"Redaguoti tekstą","Edit text...":"Redaguoti tekstą ...","Effects":"Efektai","Email:":"El. paštas:","Emboss":"Įspausti","Empty selection":"Tuščias pasirinkimas","Empty selection or type not image.":"Tuščias pasirinkimas arba įveskite ne vaizdą.","English":"Anglų","Enrich":"Praturtinti","Erase":"Ištrinti","Erase on rotate object is disabled. Sorry.":"Ištrinti objektą pasukti yra išjungtas. atsiprašau","Error":"Klaida","Error connecting to service.":"Klaida prisijungiant prie paslaugos.","Error: can not load image.":"Klaida: negalima įkelti paveikslėlio.","Error: missing details event target":"Klaida: trūksta detalių įvykio tikslo","Error: unsupported attribute type:":"Klaida: nepalaikomas atributo tipas:","Error: wrong key:":"Klaida: klaidingas raktas:","Español":"Español","Expand edges":"Išskleiskite kraštus","Exponent:":"Eksponentė:","Factor:":"Veiksnys:","File":"Failas","File name:":"Failo pavadinimas:","File size:":"Failo dydis:","Fill":"Pildyti","Fit":"Talpinti","Fit window":"Tinkamas langas","Flatten Image":"Išlyginti vaizdą","Flip":"Apversti","FloydSteinberg-serpentine":"Floydsteinberg-serpentinas","French":"Prancūzų kalba","Full HD, 1080p":"Full HD, 1080p","GIF - Graphics Interchange Format":"Gif - grafikos mainų formatas","Gap:":"Atotrūkis:","Gaussian Blur":"Gauso suliejimo","German":"Vokiečių kalba","Gif delay:":"Gif delsimas:","GitHub:":"Github:","Gradient":"Gradientas","Gradient Radius:":"Gradientas spindulys:","Grains":"Grūdėtumas","Gray":"Pilkas","Grayscale":"Pelės skalė","Green":"Žalias","Green channel:":"Žalias kanalas:","Green:":"Žalias:","Greyscale:":"Pilkieji pustoniai:","Grid":"Tinklelis","Grid on/off":"Tinklelis","H Radius:":"H spindulys:","Heatmap":"Spalvinė diagrama","Height (%):":"Aukštis (%):","Height:":"Aukštis:","Help":"Pagalba","Helvetica":"Helvetica","Hermite":"Hermite","Hex:":"Hex:","Histogram":"Histograma","Histogram:":"Histograma:","Horizontal":"Horizontali","Horizontal blur:":"Horizontalus miglotas vaizdas:","Hue Rotate":"Atspalvis pasukti","Hue:":"Atspalvis:","Image":"Vaizdas","Image data with multi-layers. Can be opened using miniPaint -":"Vaizdo duomenys su kelių sluoksnių. gali būti atidarytas naudojant minipaint -","Impact":"Poveikis","Information":"Informacija","Insert:":"Įdėti:","Italiano":"Italų kalba","Italic":"Italic","JPG - JPG/JPEG Format":"JPG - JPG/JPEG formatas","JPG, WEBP quality:":"Jpg, webp kokybės:","JSON - Full layers data":"JSON - sluoksnių duomenys","Japanese":"Japonų kalba","Key-points":"Pagrindiniai klausimai","Keyboard Shortcuts":"Klaviatūros nuorodos","Keyword:":"Raktinis žodis:","Korean":"Korėjiečių kalba","Language":"Kalba","Last modified":"Paskutinį kartą keistas","Layer details":"Sluoksnio detalės","Layer is already image.":"Sluoksnis jau yra vaizdas.","Layer must be image, convert it to raster to apply this tool.":"Sluoksnis turi būti įvaizdis, paversti jį rastru, kad pritaikytų šį įrankį.","Layers":"Sluoksniai","Layers:":"Sluoksniai:","Left":"Kairėje","Level:":"Lygis:","Levels:":"Lygiais:","Lietuvių":"Lietuvių","Line":"Linija","Lum:":"Lum:","Luminance:":"Skaisčio:","Magic Wand Tool":"Stebuklinga lazdelė","Merge Down":"Sujungti žemyn","Merged":"Sujungta","Mode:":"Režimas:","Module function not found.":"Modulio funkcija nerasta.","Modules class not found:":"Modulio klasė nerasta:","Mosaic":"Mozaika","Mouse:":"Pelė:","Move":"Perkelti","Move down":"Judėti žemyn","Move up":"Perkelti","Name:":"Vardas:","Needs at least 2 layers.":"Reikia bent 2 sluoksnius.","Negative":"Neigiamas","New":"Naujas","New file":"Naujas failas","New from selection":"Nauja iš pasirinkimo","New layer":"Nauja sluoksnis","New width can not be smaller then current width":"Naujas plotis negali būti mažesnis nei dabartinis plotis","Normal":"Normalus","Nothing is selected.":"Niekas nėra pasirinktas.","Offset X:":"Nuokrypis x:","Offset Y:":"Kompensuoti:","Oil":"Aliejus","Ok":"Gerai","Online image editor.":"Internetinis vaizdo redaktorius.","Opacity":"Nepermatomumas","Opacity:":"Nepermatomumas:","Open":"Atidaryti","Open Data URL":"Atidaryti duomenų URL","Open Directory":"Atidaryti katalogą","Open File":"Atidaryti failą","Open URL":"Atidaryti url","Open data URL":"Atidaryti duomenų url","Original size":"Originalus dydis","PNG - Portable Network Graphics":"PNG - portable network graphics","Palette":"Paletė","Parameter #1:":"Parametras Nr. 1:","Parameter #2:":"Parametras # 2:","Paste":"Įkelti","Pencil":"Pieštukas","Percentage:":"Procentas:","Pick Color":"Pasirinkite spalvą","Pixels:":"Taškai:","Play animation":"Groti animaciją","Portuguese":"Portugalų","Power:":"Galia:","Powred by  pixabay.com .":"Powred by pixabay.com.","Pre-Blur:":"Migla:","Preview":"Peržiūrėti","Previous":"Ankstesnis","Previous layer must be image, convert it to raster to apply this tool.":"Ankstesnis sluoksnis turi būti vaizdas, konvertuoti jį į rastrą, kad būtų taikomas šis įrankis.","Print":"Spausdinti","Quality:":"Kokybė:","Quick load":"Greitas įkrovimas","Quick save":"Greitas išsaugojimas","Radial":"Radialinis","Radial gradient":"Radialinis gradientas","Radius:":"Spindulys:","Range:":"Kategorijos:","Rectangle":"Stačiakampis","Red":"Raudonas","Red channel:":"Raudonasis kanalas:","Red:":"Raudona:","Rename":"Pervadinti","Replace Color":"Pakeiskite spalvą","Replace color":"Pakeiskite spalvą","Replacement:":"Pakeitimas:","Report issues":"Pranešti apie problemas","Resample - Hermite":"Resample - hermite","Reset":"Atstatyti","Reset zoom level":"Atstatyti mastelį","Resize":"Keisti dydį","Resized as background":"Pakeista kaip fonas","Resolution:":"Rezoliucija:","Restore alpha":"Atkurti alfa","Right":"Teisingai","Right angle:":"Dešinysis kampas:","Rotate":"Sukti","Rotate is not supported on this type of object. Convert to raster?":"Šio tipo objektuose nepavyksta pakeisti rotacijos. konvertuoti į rastrą?","Rotate left":"Pasukti į kairę","Rotate:":"Pasukti:","Russian":"Rusų kalba","Sat:":"Sat:","Saturate":"Saturate","Saturation:":"Spalvingumas:","Save":"Išsaugoti","Save as":"Išsaugoti kaip","Save as data URL":"Išsaugoti kaip duomenų URL","Save as type:":"Išsaugoti kaip:","Save layers:":"Išsaugoti sluoksnius:","Save resolution:":"Išsaugoti rezoliuciją:","Scroll down":"Slinkti žemyn","Scroll up":"Slinkite aukštyn","Search":"Paieška","Search images":"Ieškoti vaizdų","Select all":"Pasirinkti viską","Select object tool":"Pasirinkite objektas įrankis","Selected":"Pasirinkti","Selection":"Pasirinkimas","Sensitivity:":"Jautrumas:","Sepia":"Sepia","Settings":"Nustatymai","Shadow":"Šešėlis","Shadow:":"Šešėlis:","Sharpen":"Pagaląsti","Sharpen tool":"Paryškinti nuorodą","Sharpen:":"Paryškinti:","Show / Hide":"Rodyti Slėpti","Show file size:":"Rodyti failo dydį:","Simple":"Paprastas","Size":"Dydis","Size is too big, max":"Dydis yra per didelis, maks","Size:":"Dydis:","Skip - layer must be image.":"Praleisti - sluoksnis turi būti vaizdas.","Solarize":"Soliarizacija","Sorry, image could not be loaded. Try copy image and paste it.":"Deja, vaizdas negali būti įkeltas. pabandykite kopijuoti nuotrauką ir įklijuoti ją.","Sorry, image is too big, max 5 MB.":"Atsiprašome, vaizdas yra per didelis, daugiausiai 5 MB.","Source is empty, right click on image to save source position.":"Šaltinis yra tuščias, dešiniuoju pelės mygtuku spustelėkite vaizdą, kad išsaugotumėte šaltinio poziciją.","Sprites":"Sprites","Square":"Langelis","Strength:":"Jėga:","Strict":"Griežtas","Stroke":"Insultas","Stroke:":"Insultas:","Target:":"Tikslas:","Text":"Tekstas","Text example":"Teksto pavyzdys","Text:":"Tekstas:","There are no layers behind.":"Už sluoksnių nėra.","There is only 1 layer.":"Yra tik 1 sluoksnis.","Tilt Shift":"Tento perkelimas","Times New Roman":"Times New Roman","Toggle":"Perjungti","Tools":"Įrankiai","Tools class not found:":"Įrankių klasė nerasta:","Total pixels:":"Iš viso taškų:","Translate":"Versti","Translate error, can not find dictionary:":"Versti klaidą, negali rasti žodyną:","Transparency background:":"Skaidrumo fonas:","Transparent:":"Skaidri:","Trim":"Apkarpyti","Trim everything:":"Trim viską:","Trim layer:":"Trim sluoksnis:","Trim white color?":"Trim balta spalva?","Turkish":"Turkų kalba","Undo":"Anuliuoti","Undo disabled.":"Atšaukti išjungta.","Undo enabled.":"Atšaukti įjungta.","Undo is not available.":"Atšaukti negalima.","Undo levels changed to 1.":"Atšaukti lygiai pakeista į 1.","Undo levels restored to":"Atšaukti lygius atkurti","Unique colors:":"Unikalios spalvos:","Up":"Aukštyn","Use Ctrl+V keyboard shortcut to paste from Clipboard.":"Naudokite \"ctrl + v\" spartieji klavišai, kuriuos norite įklijuoti iš iškarpinės.","V Radius:":"V spindulys:","Verdana":"Verdana","Version:":"Versija:","Vertical":"Vertikalus","Vertical blur:":"Vertikalus plyšimas:","Vibrance":"Rezonansas","Vignette":"Vinjetė","ViliusL":"Viliusl","Vintage":"Senoviškas","Visible:":"Matomas:","WEBP - Weppy File Format":"WEBP - weppy failo formatas","Website:":"Interneto svetainė:","Width (%):":"Plotis (%):","Width:":"Plotis:","Wrong file type, must be image or json.":"Neteisingas failo tipas, turi būti paveikslėlis arba json.","X end:":"X pabaiga:","X position:":"X pozicija:","X start:":"X pradžia::","Y end:":"Y pabaiga:","Y position:":"Y pozicija:","Y start:":"Y pradžia:","You can also drag and drop items into browser.":"Taip pat galite vilkti elementus į naršyklę.","Your browser does not support canvas or JavaScript is not enabled.":"Jūsų naršyklė nepalaiko drobės ar javascript nėra įjungtas.","Your browser does not support this format.":"Jūsų naršyklė nepalaiko šio formato.","Your search did not match any images.":"Jūsų paieška neatitiko jokių vaizdų.","Zoom":"Zoom","Zoom Blur":"Zoom Blur","Zoom In":"Priartinti","Zoom Out":"Nutolinti","Zoom blur":"Padidinti blur","Zoom in":"Priartinti","Zoom out":"Nutolinti","Zoom:":"Priartinimas:"}

/***/ }),
/* 48 */
/***/ (function(module, exports) {

module.exports = {"2d":"2d","480p":"480p","About":"Sobre","Active":"Ativo","Advanced":"Avançado","All":"Todos","Alpha:":"Alfa:","Anonymous":"Anônimo","Anti aliasing":"Anti-aliasing","Arial":"Arial","Arrow":"Flecha","Author:":"Autor:","Auto adjust colors":"Cores de ajuste automático","Average:":"Média:","BMP - Windows Bitmap":"BMP - Bitmap do Windows","Base":"Base","Basic":"Básico","Black and White":"Preto e branco","Blue":"Azul","Blue channel:":"Canal azul:","Blue:":"Azul:","Blur Radius:":"Blur Radius:","Blur power:":"Blur power:","Blur tool":"Ferramenta de desfoque","Bold":"Negrito","Bold Italic":"Negrito itálico","Borders":"Fronteiras","Box Blur":"Borrão de caixa","Box blur":"Borrão de caixa","Brightness":"Brilho","Brightness:":"Brilho:","Brush":"Escova","Bulge/Pinch tool":"Ferramenta Bulge / Pinch","Burn":"Queimar","CSS filters":"Filtros CSS","Can not animate 1 layer.":"Não é possível animar 1 camada.","Can not find previous layer.":"Não é possível encontrar a camada anterior.","Cancel":"Cancelar","Center":"Centro","Center x:":"Centro x:","Center y:":"Centro y:","Center:":"Centro:","Channel:":"Canal:","Circle":"Círculo","Clear":"Claro","Clone count:":"Contagem de clones:","Clone tool":"Ferramenta de clonagem","Cloned edges":"Bordas clonadas","Color #":"Cor #","Color Zoom":"Zoom de cor","Color alpha value can not be zero.":"O valor alpha colorido não pode ser zero.","Color corrections":"Correções de cores","Color palette":"Paleta de cores","Color to alpha":"Cor para alfa","Color zoom":"Zoom de cor","Color:":"Cor:","Colors":"Cores","Colors:":"Cores:","Composition":"Composição","Composition:":"Composição:","Content fill":"Preenchimento de conteúdo","Contrast":"Contraste","Contrast:":"Contraste:","Convert to raster":"Converter em raster","Copy selection":"Seleção de cópia","Copy:":"Cópia de:","Courier":"Correio","Crop":"Colheita","Ctrl+V":"Ctrl + V","Ctrl-P":"Ctrl-P","Current":"Atual","Curve":"Curva","Custom":"personalizadas","Data URL":"URL de dados","Data URL:":"URL de dados:","Decrease color depth":"Diminuir a profundidade de cor","Default":"Padrão","Degree:":"Grau:","Del":"Del","Delete":"Excluir","Delete selection":"Eliminar seleção","Denoise":"Denoise","Desaturate":"Desaturar","Description:":"Descrição:","Differences":"Diferenças","Differences Down":"Diferenças para baixo","Dither":"Dither","Dithering:":"Dithering:","Dominant color:":"Cor dominante:","Dot Screen":"Tela de ponto","Down":"Baixa","Duplicate":"Duplicado","Edge":"Beira","Edit":"Editar","Edit text":"Editar texto","Edit text...":"Editar texto...","Effects":"Efeitos","Email:":"O email:","Emboss":"Em relevo","Empty selection":"Seleção vazia","Empty selection or type not image.":"Seleção vazia ou não digite imagem.","English":"Inglês","Enrich":"Enriquecer","Erase":"Apagar","Erase on rotate object is disabled. Sorry.":"Apagar no objeto rotativo está desabilitado. Desculpa.","Error":"Erro","Error connecting to service.":"Erro ao conectar-se ao serviço.","Error: can not load image.":"Erro: não é possível carregar a imagem.","Error: missing details event target":"Erro: detalhes faltantes alvo do evento","Error: unsupported attribute type:":"Erro: tipo de atributo não suportado:","Error: wrong key:":"Erro: chave errada:","Español":"Español","Expand edges":"Expandir bordas","Exponent:":"Expoente:","Factor:":"Fator:","File":"Arquivo","File name:":"Nome do arquivo:","File size:":"Tamanho do arquivo:","Fill":"Preencher","Fit":"Em forma","Fit window":"Janela de ajuste","Flatten Image":"Achatar imagem","Flip":"Giro","FloydSteinberg-serpentine":"FloydSteinberg-serpentine","French":"francês","Full HD, 1080p":"Full HD, 1080p","GIF - Graphics Interchange Format":"GIF - Graphics Interchange Format","Gap:":"Gap:","Gaussian Blur":"Gaussian Blur","German":"alemão","Gif delay:":"Retardo GIF:","GitHub:":"GitHub:","Gradient":"Gradiente","Gradient Radius:":"Radiação de gradiente:","Grains":"Grãos","Gray":"cinzento","Grayscale":"Escala de cinza","Green":"Verde","Green channel:":"Canal verde:","Green:":"Verde:","Greyscale:":"Greyscale:","Grid":"Grade","Grid on/off":"Grid on / off","H Radius:":"H Radius:","Heatmap":"Mapa de calor","Height (%):":"Altura (%):","Height:":"Altura:","Help":"Socorro","Helvetica":"helvética","Hermite":"Hermite","Hex:":"Hex:","Histogram":"Histograma","Histogram:":"Histograma:","Horizontal":"Horizontal","Horizontal blur:":"Desfoque horizontal:","Hue Rotate":"Hue Rotate","Hue:":"Matiz:","Image":"Imagem","Image data with multi-layers. Can be opened using miniPaint -":"Dados de imagem com várias camadas. Pode ser aberto usando o miniPaint -","Impact":"Impacto","Information":"Em formação","Insert:":"Inserir:","Italiano":"Italiano","Italic":"itálico","JPG - JPG/JPEG Format":"JPG - Formato JPG / JPEG","JPG, WEBP quality:":"JPG, qualidade WEBP:","JSON - Full layers data":"JSON - Dados de camadas completas","Japanese":"japonês","Key-points":"Pontos chave","Keyboard Shortcuts":"Atalhos do teclado","Keyword:":"Palavra-chave:","Korean":"coreano","Language":"Língua","Last modified":"Última modificação","Layer details":"Detalhes da camada","Layer is already image.":"Layer já é imagem.","Layer must be image, convert it to raster to apply this tool.":"A camada deve ser imagem, converta-a em raster para aplicar esta ferramenta.","Layers":"Camadas","Layers:":"Camadas:","Left":"Esquerda","Level:":"Nível:","Levels:":"Níveis:","Lietuvių":"Lietuvių","Line":"Linha","Lum:":"Lum:","Luminance:":"Luminância:","Magic Wand Tool":"Varinha mágica","Merge Down":"Fusionar","Merged":"Mesclado","Mode:":"Modo:","Module function not found.":"Função do módulo não encontrada.","Modules class not found:":"Classe de módulos não encontrada:","Mosaic":"mosaico","Mouse:":"Rato:","Move":"Mover","Move down":"Mover para baixo","Move up":"Subir","Name:":"Nome:","Needs at least 2 layers.":"Precisa de pelo menos 2 camadas.","Negative":"Negativo","New":"Novo","New file":"Novo arquivo","New from selection":"Novo da seleção","New layer":"Nova camada","New width can not be smaller then current width":"A nova largura não pode ser menor do que a largura atual","Normal":"Normal","Nothing is selected.":"Nada é selecionado.","Offset X:":"Offset X:","Offset Y:":"Offset Y:","Oil":"Óleo","Ok":"Está bem","Online image editor.":"Editor de imagens on-line.","Opacity":"Opacidade","Opacity:":"Opacidade:","Open":"Aberto","Open Data URL":"Abrir URL de dados","Open Directory":"Diretório aberto","Open File":"Abrir arquivo","Open URL":"Url aberta","Open data URL":"Abrir URL de dados","Original size":"Tamanho original","PNG - Portable Network Graphics":"PNG - Gráficos de rede portátil","Palette":"Paleta","Parameter #1:":"Parâmetro # 1:","Parameter #2:":"Parâmetro # 2:","Paste":"Colar","Pencil":"Lápis","Percentage:":"Percentagem:","Pick Color":"Escolha a cor","Pixels:":"Píxeis:","Play animation":"Jogue animação","Portuguese":"Português","Power:":"Poder:","Powred by  pixabay.com .":"Powred by pixabay.com.","Pre-Blur:":"Pré-borrão:","Preview":"Visualização","Previous":"Anterior","Previous layer must be image, convert it to raster to apply this tool.":"A camada anterior deve ser imagem, convertê-la em raster para aplicar esta ferramenta.","Print":"Impressão","Quality:":"Qualidade:","Quick load":"Carga rápida","Quick save":"Salvamento rapido","Radial":"Radial","Radial gradient":"Gradiente radial","Radius:":"Raio:","Range:":"Alcance:","Rectangle":"Retângulo","Red":"Vermelho","Red channel:":"Canal vermelho:","Red:":"Vermelho:","Rename":"Renomear","Replace Color":"Substituir cor","Replace color":"Substitua a cor","Replacement:":"Substituição:","Report issues":"Relatar problemas","Resample - Hermite":"Resmplemento - Hermite","Reset":"Restabelecer","Reset zoom level":"Redefinir o nível de zoom","Resize":"Redimensionar","Resized as background":"Redimensionado como plano de fundo","Resolution:":"Resolução:","Restore alpha":"Restaurar alfa","Right":"Certo","Right angle:":"Ângulo certo:","Rotate":"Girar","Rotate is not supported on this type of object. Convert to raster?":"Rotate não é suportado neste tipo de objeto. Converter em raster?","Rotate left":"Vire à esquerda","Rotate:":"Girar:","Russian":"russo","Sat:":"Sentou:","Saturate":"Saturar","Saturation:":"Saturação:","Save":"Salve ","Save as":"Salvar como","Save as data URL":"Salvar como URL de dados","Save as type:":"Salvar como tipo:","Save layers:":"Salvar camadas:","Save resolution:":"Salvar resolução:","Scroll down":"Rolar para baixo","Scroll up":"Deslize para cima","Search":"Pesquisa","Search images":"Pesquisar imagens","Select all":"Selecionar tudo","Select object tool":"Selecione a ferramenta de objeto","Selected":"Selecionado","Selection":"Seleção","Sensitivity:":"Sensibilidade:","Sepia":"Sépia","Settings":"Configurações","Shadow":"Sombra","Shadow:":"Sombra:","Sharpen":"Sharpen","Sharpen tool":"Ferramenta Sharpen","Sharpen:":"Sharpen:","Show / Hide":"Aparecer esconder","Show file size:":"Mostrar tamanho do arquivo:","Simple":"Simples","Size":"Tamanho","Size is too big, max":"O tamanho é muito grande, máximo","Size:":"Tamanho:","Skip - layer must be image.":"Skip - layer deve ser imagem.","Solarize":"Solarize","Sorry, image could not be loaded. Try copy image and paste it.":"Desculpe, a imagem não pôde ser carregada. Tente copiar imagem e cole-a.","Sorry, image is too big, max 5 MB.":"Desculpe, a imagem é muito grande, no máximo 5 MB.","Source is empty, right click on image to save source position.":"A fonte está vazia, clique com o botão direito do mouse na imagem para salvar a posição da fonte.","Sprites":"Sprites","Square":"Quadrado","Strength:":"Força:","Strict":"Rigoroso","Stroke":"Acidente vascular encefálico","Stroke:":"Acidente vascular encefálico:","Target:":"Alvo:","Text":"Texto","Text example":"Exemplo de texto","Text:":"Texto:","There are no layers behind.":"Não há camadas atrás.","There is only 1 layer.":"Existe apenas uma camada.","Tilt Shift":"Tilt Shift","Times New Roman":"Times New Roman","Toggle":"Alternancia","Tools":"Ferramentas","Tools class not found:":"Classe de ferramentas não encontrada:","Total pixels:":"Total de pixels:","Translate":"Traduzir","Translate error, can not find dictionary:":"Traduzir erro, não encontrar dicionário:","Transparency background:":"Fundo de transparência:","Transparent:":"Transparente:","Trim":"aparar","Trim everything:":"Apare tudo:","Trim layer:":"Trim layer:","Trim white color?":"Trim cor branca?","Turkish":"turco","Undo":"Desfazer","Undo disabled.":"Desfazer desativado.","Undo enabled.":"Desfazer habilitado.","Undo is not available.":"Desfazer não está disponível.","Undo levels changed to 1.":"Desfazer níveis alterados para 1.","Undo levels restored to":"Desfazer níveis restaurados para","Unique colors:":"Cores únicas:","Up":"Acima","Use Ctrl+V keyboard shortcut to paste from Clipboard.":"Use o atalho de teclado Ctrl + V para colar da área de transferência.","V Radius:":"V Radius:","Verdana":"Verdana","Version:":"Versão:","Vertical":"Vertical","Vertical blur:":"Borrão vertical:","Vibrance":"Vibração","Vignette":"Vinheta","ViliusL":"ViliusL","Vintage":"Vintage","Visible:":"Visível:","WEBP - Weppy File Format":"WEBP - Formato de Arquivo Weppy","Website:":"Local na rede Internet:","Width (%):":"Largura (%):","Width:":"Largura:","Wrong file type, must be image or json.":"Tipo de arquivo errado, deve ser imagem ou json.","X end:":"X final:","X position:":"Posição X:","X start:":"X start:","Y end:":"Y final:","Y position:":"Posição Y:","Y start:":"Y começar:","You can also drag and drop items into browser.":"Você também pode arrastar e soltar itens no navegador.","Your browser does not support canvas or JavaScript is not enabled.":"Seu navegador não é compatível com tela ou o JavaScript não está habilitado.","Your browser does not support this format.":"Seu navegador não suporta este formato.","Your search did not match any images.":"Sua pesquisa não corresponde a nenhuma imagem.","Zoom":"Zoom","Zoom Blur":"Zoom de zoom","Zoom In":"Mais Zoom","Zoom Out":"Reduzir o zoom","Zoom blur":"Zoom de zoom","Zoom in":"Mais Zoom","Zoom out":"Reduzir o zoom","Zoom:":"Zoom:"}

/***/ }),
/* 49 */
/***/ (function(module, exports) {

module.exports = {"2d":"2d","480p":"480p","About":"Около","Active":"активный","Advanced":"продвинутый","All":"Все","Alpha:":"Альфа:","Anonymous":"анонимное","Anti aliasing":"Сглаживание","Arial":"Arial","Arrow":"Стрела","Author:":"Автор:","Auto adjust colors":"Автоматическая настройка цветов","Average:":"В среднем:","BMP - Windows Bitmap":"BMP - битмап Windows","Base":"База","Basic":"основной","Black and White":"Черное и белое","Blue":"синий","Blue channel:":"Голубой канал:","Blue:":"Синий:","Blur Radius:":"Радиус размытия:","Blur power:":"Размытие:","Blur tool":"Инструмент размытия","Bold":"Жирный","Bold Italic":"Жирный курсив","Borders":"Границы","Box Blur":"Размытие ящика","Box blur":"Размытие коробки","Brightness":"яркость","Brightness:":"Яркость:","Brush":"Щетка","Bulge/Pinch tool":"Инструмент для выемки / зажима","Burn":"жечь","CSS filters":"Фильтры CSS","Can not animate 1 layer.":"Невозможно оживить 1 слой.","Can not find previous layer.":"Не удается найти предыдущий слой.","Cancel":"Отмена","Center":"Центр","Center x:":"Центр x:","Center y:":"Центр y:","Center:":"Центр:","Channel:":"Источник:","Circle":"Круг","Clear":"Очистить","Clone count:":"Количество клонов:","Clone tool":"Инструмент клонирования","Cloned edges":"Клонированные края","Color #":"Цвет #","Color Zoom":"Цветное увеличение","Color alpha value can not be zero.":"Значение цветной альфа не может быть равно нулю.","Color corrections":"Коррекция цвета","Color palette":"Цветовая палитра","Color to alpha":"Цвет в альфа","Color zoom":"Цветное увеличение","Color:":"Цвет:","Colors":"Цвета","Colors:":"Цвета:","Composition":"Состав","Composition:":"Состав:","Content fill":"Контент заполняется","Contrast":"контрастировать","Contrast:":"Контраст:","Convert to raster":"Преобразовать в растровый","Copy selection":"Выбор копии","Copy:":"Копирование:","Courier":"курьер","Crop":"урожай","Ctrl+V":"Ctrl + V,","Ctrl-P":"Ctrl-P","Current":"Текущий","Curve":"кривая","Custom":"изготовленный на заказ","Data URL":"URL-адрес данных","Data URL:":"URL-адрес данных:","Decrease color depth":"Уменьшить глубину цвета","Default":"По умолчанию","Degree:":"Степень:","Del":"Del","Delete":"Удалить","Delete selection":"Удалить выделение","Denoise":"Denoise","Desaturate":"Обесцвечивание","Description:":"Описание:","Differences":"Различия","Differences Down":"Разница вниз","Dither":"трястись","Dithering:":"Смешение:","Dominant color:":"Доминирующий цвет:","Dot Screen":"Точечный экран","Down":"вниз","Duplicate":"дублировать","Edge":"край","Edit":"редактировать","Edit text":"Редактировать текст","Edit text...":"Редактировать текст...","Effects":"Последствия","Email:":"Эл. адрес:","Emboss":"выбивать","Empty selection":"Пустой выбор","Empty selection or type not image.":"Пустой выбор или введите не изображение.","English":"английский","Enrich":"обогащать","Erase":"стирать","Erase on rotate object is disabled. Sorry.":"Стереть объект поворота отключен. Сожалею.","Error":"ошибка","Error connecting to service.":"Ошибка подключения к сервису.","Error: can not load image.":"Ошибка: невозможно загрузить изображение.","Error: missing details event target":"Ошибка: отсутствует цель события","Error: unsupported attribute type:":"Ошибка: неподдерживаемый тип атрибута:","Error: wrong key:":"Ошибка: неправильный ключ:","Español":"Español","Expand edges":"Развернуть края","Exponent:":"Экспонент:","Factor:":"фактор:","File":"файл","File name:":"Имя файла:","File size:":"Размер файла:","Fill":"заполнить","Fit":"Поместиться","Fit window":"Окно для установки","Flatten Image":"Свести изображение","Flip":"кувырок","FloydSteinberg-serpentine":"FloydSteinberg-змеевик","French":"Французский","Full HD, 1080p":"Full HD, 1080p","GIF - Graphics Interchange Format":"GIF - формат обмена графикой","Gap:":"Gap:","Gaussian Blur":"Гауссовское размытие","German":"Немецкий","Gif delay:":"Задержка Gif:","GitHub:":"GitHub:","Gradient":"градиент","Gradient Radius:":"Радиус градиента:","Grains":"зерна","Gray":"Серый","Grayscale":"Оттенки серого","Green":"зеленый","Green channel:":"Зеленый коридор:","Green:":"Зеленый цвет:","Greyscale:":"Оттенки серого:","Grid":"сетка","Grid on/off":"Включение / выключение сетки","H Radius:":"H Радиус:","Heatmap":"Тепловая карта","Height (%):":"Высота (%):","Height:":"Высота:","Help":"Помогите","Helvetica":"Helvetica","Hermite":"Эрмита","Hex:":"Hex:","Histogram":"Гистограмма","Histogram:":"Гистограмма:","Horizontal":"горизонтальный","Horizontal blur:":"Горизонтальное размытие:","Hue Rotate":"Оттенок","Hue:":"Оттенок:","Image":"Образ","Image data with multi-layers. Can be opened using miniPaint -":"Данные изображения с несколькими слоями. Может быть открыт с помощью miniPaint -","Impact":"Влияние","Information":"Информация","Insert:":"Вставка:","Italiano":"Italiano","Italic":"курсивный","JPG - JPG/JPEG Format":"JPG - формат JPG / JPEG","JPG, WEBP quality:":"JPG, WEBP качество:","JSON - Full layers data":"JSON - данные с полными слоями","Japanese":"Японский","Key-points":"Ключевые пункты","Keyboard Shortcuts":"Горячие клавиши","Keyword:":"Ключевое слово:","Korean":"Корейский","Language":"язык","Last modified":"Последнее изменение","Layer details":"Детали слоя","Layer is already image.":"Слой уже является изображением.","Layer must be image, convert it to raster to apply this tool.":"Слой должен быть изображением, преобразовать его в растр, чтобы применить этот инструмент.","Layers":"Слои","Layers:":"Слои:","Left":"Оставил","Level:":"Уровень:","Levels:":"Уровни:","Lietuvių":"Lietuvių","Line":"Линия","Lum:":"Lum:","Luminance:":"Luminance:","Magic Wand Tool":"Инструмент волшебной палочки","Merge Down":"Слить","Merged":"Объединенное","Mode:":"Режим:","Module function not found.":"Функция модуля не найдена.","Modules class not found:":"Класс модулей не найден:","Mosaic":"мозаика","Mouse:":"Мышь:","Move":"Переехать","Move down":"Переместить вниз","Move up":"Переместить вверх","Name:":"Имя:","Needs at least 2 layers.":"Требуется не менее 2 слоев.","Negative":"отрицательный","New":"новый","New file":"Новый файл","New from selection":"Новое от выбора","New layer":"Новый слой","New width can not be smaller then current width":"Новая ширина не может быть меньше текущей ширины","Normal":"Нормальный","Nothing is selected.":"Ничего не выбрано.","Offset X:":"Смещение X:","Offset Y:":"Смещение Y:","Oil":"масло","Ok":"ОК","Online image editor.":"Редактор онлайн-изображений.","Opacity":"помутнение","Opacity:":"Непрозрачность:","Open":"открыто","Open Data URL":"Открыть URL-адрес данных","Open Directory":"Открыть каталог","Open File":"Открыть файл","Open URL":"Открыть URL-адрес","Open data URL":"Открыть URL-адрес данных","Original size":"Оригинальный размер","PNG - Portable Network Graphics":"PNG - портативная сетевая графика","Palette":"палитра","Parameter #1:":"Параметр №1:","Parameter #2:":"Параметр №2:","Paste":"Вставить","Pencil":"Карандаш","Percentage:":"Процент:","Pick Color":"Выберите цвет","Pixels:":"Пиксели:","Play animation":"Игровая анимация","Portuguese":"португальский","Power:":"Мощность:","Powred by  pixabay.com .":"Поражается pixabay.com.","Pre-Blur:":"Pre-Размытие:","Preview":"предварительный просмотр","Previous":"предыдущий","Previous layer must be image, convert it to raster to apply this tool.":"Предыдущий слой должен быть изображением, преобразовать его в растр, чтобы применить этот инструмент.","Print":"Распечатать","Quality:":"Качественный:","Quick load":"Быстрая нагрузка","Quick save":"Быстрое сохранение","Radial":"радиальный","Radial gradient":"Радиальный градиент","Radius:":"Радиус:","Range:":"Ассортимент:","Rectangle":"Прямоугольник","Red":"красный","Red channel:":"Красный канал:","Red:":"Красный:","Rename":"переименовывать","Replace Color":"Заменить цвет","Replace color":"Заменить цвет","Replacement:":"Замена:","Report issues":"Проблемы с отчетами","Resample - Hermite":"Resample - Эрмит","Reset":"Сброс","Reset zoom level":"Сбросить уровень масштабирования","Resize":"Изменение размера","Resized as background":"Изменилось в качестве фона","Resolution:":"Разрешение:","Restore alpha":"Восстановить альфа","Right":"Правильно","Right angle:":"Прямой угол:","Rotate":"Поворот","Rotate is not supported on this type of object. Convert to raster?":"Поворот на этом типе объекта не поддерживается. Конвертировать в растр?","Rotate left":"Поверните влево","Rotate:":"Поворот:","Russian":"русский","Sat:":"Сидел:","Saturate":"насыщать","Saturation:":"Насыщенность:","Save":"Сохранить","Save as":"Сохранить как","Save as data URL":"Сохранить как URL-адрес данных","Save as type:":"Сохранить как тип:","Save layers:":"Сохранить слои:","Save resolution:":"Сохранить разрешение:","Scroll down":"Прокрутить вниз","Scroll up":"Прокрутка вверх","Search":"Поиск","Search images":"Поиск изображений","Select all":"Выбрать все","Select object tool":"Выберите инструмент объекта","Selected":"выбранный","Selection":"выбор","Sensitivity:":"Чувствительность:","Sepia":"Сепия","Settings":"настройки","Shadow":"Тень","Shadow:":"Тень:","Sharpen":"точить","Sharpen tool":"Инструмент «Резкость»","Sharpen:":"Резкость:","Show / Hide":"Показать спрятать","Show file size:":"Показать размер файла:","Simple":"просто","Size":"Размер","Size is too big, max":"Размер слишком большой, макс.","Size:":"Размер:","Skip - layer must be image.":"Пропуск - слой должен быть изображением.","Solarize":"передержать","Sorry, image could not be loaded. Try copy image and paste it.":"К сожалению, изображение не может быть загружено. Попробуйте скопировать изображение и вставьте его.","Sorry, image is too big, max 5 MB.":"К сожалению, изображение слишком велико, не более 5 МБ.","Source is empty, right click on image to save source position.":"Источник пуст, щелкните правой кнопкой мыши по изображению, чтобы сохранить исходную позицию.","Sprites":"Спрайты","Square":"Квадрат","Strength:":"Прочность:","Strict":"строгий","Stroke":"Инсульт","Stroke:":"Инсульт:","Target:":"Цель:","Text":"Текст","Text example":"Пример текста","Text:":"Текст:","There are no layers behind.":"Позади нет слоев.","There is only 1 layer.":"Есть только 1 слой.","Tilt Shift":"Сдвиг наклона","Times New Roman":"Times New Roman","Toggle":"тумблер","Tools":"инструменты","Tools class not found:":"Класс инструментов не найден:","Total pixels:":"Всего пикселей:","Translate":"Переведите","Translate error, can not find dictionary:":"Перевести ошибку, не найти словарь:","Transparency background:":"Прозрачный фон:","Transparent:":"Прозрачный:","Trim":"Отделка","Trim everything:":"Обрежьте все:","Trim layer:":"Обрезной слой:","Trim white color?":"Обрезать белый цвет?","Turkish":"турецкий","Undo":"расстегивать","Undo disabled.":"Отменить.","Undo enabled.":"Отменить.","Undo is not available.":"Отмена недоступна.","Undo levels changed to 1.":"Уровни отмены отменены на 1.","Undo levels restored to":"Уровни отмены отменены","Unique colors:":"Уникальные цвета:","Up":"вверх","Use Ctrl+V keyboard shortcut to paste from Clipboard.":"Используйте комбинацию клавиш Ctrl + V для вставки из буфера обмена.","V Radius:":"V Радиус:","Verdana":"Verdana","Version:":"Версия:","Vertical":"вертикальный","Vertical blur:":"Вертикальное размытие:","Vibrance":"вибрация","Vignette":"Виньетка","ViliusL":"ViliusL","Vintage":"марочный","Visible:":"Видимых:","WEBP - Weppy File Format":"WEBP - Формат файла Weppy","Website:":"Веб-сайт:","Width (%):":"Ширина (%):","Width:":"Ширина:","Wrong file type, must be image or json.":"Неверный тип файла должен быть изображением или json.","X end:":"X конец:","X position:":"X позиция:","X start:":"Начало X:","Y end:":"Y конец:","Y position:":"Y позиция:","Y start:":"Начало работы:","You can also drag and drop items into browser.":"Вы также можете перетаскивать элементы в браузер.","Your browser does not support canvas or JavaScript is not enabled.":"Ваш браузер не поддерживает холст или JavaScript не включен.","Your browser does not support this format.":"Ваш браузер не поддерживает этот формат.","Your search did not match any images.":"Ваш поиск не соответствовал изображениям.","Zoom":"Увеличить","Zoom Blur":"Zoom Blur","Zoom In":"Приблизить","Zoom Out":"Уменьшить","Zoom blur":"Масштабирование","Zoom in":"Приблизить","Zoom out":"Уменьшить","Zoom:":"Zoom:"}

/***/ }),
/* 50 */
/***/ (function(module, exports) {

module.exports = {"2d":"2d","480p":"480p","About":"hakkında","Active":"Aktif","Advanced":"ileri","All":"Herşey","Alpha:":"Alfa:","Anonymous":"Anonim","Anti aliasing":"Örtüşme önleme","Arial":"Arial","Arrow":"Ok","Author:":"Yazar:","Auto adjust colors":"Renkleri otomatik ayarla","Average:":"Ortalama:","BMP - Windows Bitmap":"BMP - Windows Bitmap","Base":"baz","Basic":"Temel","Black and White":"Siyah ve beyaz","Blue":"Mavi","Blue channel:":"Mavi kanal:","Blue:":"Mavi:","Blur Radius:":"Bulanıklaştırma Yarıçapı:","Blur power:":"Blur gücü:","Blur tool":"Bulanıklık aracı","Bold":"cesur","Bold Italic":"Kalın italik","Borders":"Sınırlar","Box Blur":"Kutu bulanıklığı","Box blur":"Kutu bulanıklığı","Brightness":"Parlaklık","Brightness:":"Parlaklık:","Brush":"Fırça","Bulge/Pinch tool":"Bulge / Sıkma aleti","Burn":"Yanmak","CSS filters":"CSS filtreleri","Can not animate 1 layer.":"1 katmana canlandırma yapılamıyor.","Can not find previous layer.":"Önceki katmanı bulamıyorum.","Cancel":"İptal etmek","Center":"merkez","Center x:":"Merkez x:","Center y:":"Merkez y:","Center:":"merkez:","Channel:":"Kanal:","Circle":"Daire","Clear":"Açık","Clone count:":"Klon sayısı:","Clone tool":"Klon aracı","Cloned edges":"Klonlanmış kenarlar","Color #":"Renk #","Color Zoom":"Renkli Zoom","Color alpha value can not be zero.":"Renkli alfa değeri sıfır olamaz.","Color corrections":"Renk düzeltmeleri","Color palette":"Renk paleti","Color to alpha":"Alfanın renkleri","Color zoom":"Renkli yakınlaştırma","Color:":"Renk:","Colors":"Renkler","Colors:":"Renkler:","Composition":"bileştirme, kompozisyon","Composition:":"Bileştirme, kompozisyon:","Content fill":"İçerik doldurma","Contrast":"Kontrast","Contrast:":"Kontrast:","Convert to raster":"Rastera dönüştürün","Copy selection":"Seçimi kopyala","Copy:":"Kopya:","Courier":"Kurye","Crop":"ekin","Ctrl+V":"Ctrl + V","Ctrl-P":"Ctrl-P","Current":"şimdiki","Curve":"eğri","Custom":"görenek","Data URL":"Veri URL'si","Data URL:":"Veri URL'si:","Decrease color depth":"Renk derinliğini azalt","Default":"Varsayılan","Degree:":"Derece:","Del":"Del","Delete":"silmek","Delete selection":"Seçimi sil","Denoise":"Denoise","Desaturate":"Desaturate","Description:":"Açıklama:","Differences":"farklılıklar","Differences Down":"Farklar Aşağı","Dither":"titreme","Dithering:":"taklidi:","Dominant color:":"Hakim renk:","Dot Screen":"Nokta Ekranı","Down":"Aşağı","Duplicate":"Çift","Edge":"kenar","Edit":"Düzenle","Edit text":"Metni düzenle","Edit text...":"Metni düzenle...","Effects":"Etkileri","Email:":"E-posta:","Emboss":"kabartma yapmak","Empty selection":"Boş seçim","Empty selection or type not image.":"Boş seçim veya resim değil yazın.","English":"ingilizce","Enrich":"Zenginleştirmek","Erase":"silmek","Erase on rotate object is disabled. Sorry.":"Döndürme nesnesinde silme devre dışı. Afedersiniz.","Error":"Hata","Error connecting to service.":"Hizmete bağlanırken hata oluştu.","Error: can not load image.":"Hata: resim yüklenemiyor.","Error: missing details event target":"Hata: eksik olan ayrıntılar etkinlik hedefi","Error: unsupported attribute type:":"Hata: desteklenmeyen özellik türü:","Error: wrong key:":"Hata: yanlış anahtar:","Español":"Español","Expand edges":"Kenarları genişlet","Exponent:":"Üs:","Factor:":"Faktör:","File":"Dosya","File name:":"Dosya adı:","File size:":"Dosya boyutu:","Fill":"doldurmak","Fit":"Fit","Fit window":"Pencereye sığdır","Flatten Image":"Resmi Düzleştir","Flip":"fiske","FloydSteinberg-serpentine":"FloydSteinberg-serpantin","French":"Fransızca","Full HD, 1080p":"Tam HD, 1080p","GIF - Graphics Interchange Format":"GIF - Grafik Değişim Biçimi","Gap:":"boşluk:","Gaussian Blur":"Gauss Bulanıklığı","German":"Almanca","Gif delay:":"Gif gecikmesi:","GitHub:":"GitHub:","Gradient":"meyil","Gradient Radius:":"Gradyan Yarıçapı:","Grains":"Taneler","Gray":"Gri","Grayscale":"Gri tonlama","Green":"Yeşil","Green channel:":"Yeşil kanal:","Green:":"Yeşil:","Greyscale:":"Gri tonlama:","Grid":"Kafes","Grid on/off":"Izgara açık / kapalı","H Radius:":"H Radius:","Heatmap":"Sıcaklık haritası","Height (%):":"Yükseklik (%):","Height:":"Yükseklik:","Help":"yardım et","Helvetica":"Helvetica","Hermite":"Hermite","Hex:":"hex:","Histogram":"Histogram","Histogram:":"Histogram:","Horizontal":"Yatay","Horizontal blur:":"Yatay bulanıklık:","Hue Rotate":"Ton Döndür","Hue:":"Ton:","Image":"görüntü","Image data with multi-layers. Can be opened using miniPaint -":"Çok katmanlı görüntü verileri. MiniPaint ile açılabilir -","Impact":"darbe","Information":"Bilgi","Insert:":"ekle:","Italiano":"Italiano","Italic":"İtalik","JPG - JPG/JPEG Format":"JPG - JPG / JPEG Biçimi","JPG, WEBP quality:":"JPG, WEBP kalitesi:","JSON - Full layers data":"JSON - Tam katmanlı veriler","Japanese":"Japonca","Key-points":"Anahtar noktaları","Keyboard Shortcuts":"Klavye kısayolları","Keyword:":"Anahtar kelime:","Korean":"Koreli","Language":"Dil","Last modified":"Son düzenleme","Layer details":"Katman ayrıntıları","Layer is already image.":"Tabaka zaten görüntü.","Layer must be image, convert it to raster to apply this tool.":"Katman görüntü olmalı, onu uygulamak için rastgele dönüştürmelidir.","Layers":"Katmanlar","Layers:":"Katmanlar:","Left":"Ayrıldı","Level:":"Seviye:","Levels:":"Seviyeleri:","Lietuvių":"Litvanya","Line":"Hat","Lum:":"Lum:","Luminance:":"Parlaklık:","Magic Wand Tool":"Sihirli değnek aracı","Merge Down":"Aşağı Birleştir","Merged":"Birleştirilmiş","Mode:":"Mod:","Module function not found.":"Modül işlevi bulunamadı.","Modules class not found:":"Modüller sınıf bulunamadı:","Mosaic":"Mozaik","Mouse:":"Fare:","Move":"Hareket","Move down":"Aşağı inmek","Move up":"Yukarı çık","Name:":"Adı:","Needs at least 2 layers.":"En az 2 kat gerekir.","Negative":"Negatif","New":"Yeni","New file":"Yeni dosya","New from selection":"Seçimden yeni","New layer":"Yeni katman","New width can not be smaller then current width":"Yeni genişlik o andaki genişlikten daha küçük olamaz","Normal":"Normal","Nothing is selected.":"Hiçbir şey seçilmedi.","Offset X:":"Ofset X:","Offset Y:":"Ofset Y:","Oil":"Sıvı yağ","Ok":"Tamam","Online image editor.":"Çevrimiçi görüntü düzenleyici.","Opacity":"opaklık","Opacity:":"Saydamlık:","Open":"Açık","Open Data URL":"Açık Veri URL'si","Open Directory":"Açık sözlük","Open File":"Açık dosya","Open URL":"Link aç","Open data URL":"Açık veri URL'si","Original size":"Orijinal boyut","PNG - Portable Network Graphics":"PNG - Taşınabilir Ağ Grafikleri","Palette":"palet","Parameter #1:":"Parametre # 1:","Parameter #2:":"Parametre # 2:","Paste":"Yapıştırmak","Pencil":"Kalem","Percentage:":"Yüzde:","Pick Color":"Renk seç","Pixels:":"Piksel:","Play animation":"Animasyonu oynat","Portuguese":"Portekizce","Power:":"Güç:","Powred by  pixabay.com .":"Pixabay.com tarafından çekildi.","Pre-Blur:":"Ön Bulanıklık:","Preview":"Ön izleme","Previous":"Önceki","Previous layer must be image, convert it to raster to apply this tool.":"Önceki katman resim olmalıdır, bu aracı uygulamak için raster haline getirin.","Print":"baskı","Quality:":"Kalite:","Quick load":"Hızlı yükleme","Quick save":"Hızlı kaydet","Radial":"Radyal","Radial gradient":"Radyal degrade","Radius:":"radius:","Range:":"aralık:","Rectangle":"Dikdörtgen","Red":"Kırmızı","Red channel:":"Kırmızı kanal:","Red:":"Kırmızı:","Rename":"Adını değiştirmek","Replace Color":"Renk Değiştir","Replace color":"Rengi değiştir","Replacement:":"Değiştirme:","Report issues":"Sorunları bildir","Resample - Hermite":"Resample - Hermite","Reset":"Reset","Reset zoom level":"Zum düzeyini sıfırla","Resize":"yeniden boyutlandırma","Resized as background":"Arka plan olarak yeniden boyutlandırıldı","Resolution:":"Çözüm:","Restore alpha":"Alfa geri yükle","Right":"Sağ","Right angle:":"Doğru açı:","Rotate":"Döndürme","Rotate is not supported on this type of object. Convert to raster?":"Döndürme, bu tür nesne üzerinde desteklenmiyor. Rastere dönüştürün?","Rotate left":"Sola dön","Rotate:":"Dönüşümlü:","Russian":"Rusça","Sat:":"Oturdu:","Saturate":"bombalamak","Saturation:":"Doyma:","Save":"Kayıt etmek","Save as":"Farklı kaydet","Save as data URL":"Veri URL'si olarak kaydet","Save as type:":"Türünü kaydet:","Save layers:":"Katmanları kaydet:","Save resolution:":"Çözünürlüğü kaydet:","Scroll down":"Aşağı kaydır","Scroll up":"Yukarı kaydırmak","Search":"Arama","Search images":"Resimleri ara","Select all":"Hepsini seç","Select object tool":"Nesne aracını seçin","Selected":"seçilmiş","Selection":"seçim","Sensitivity:":"Duyarlılık:","Sepia":"Sepya","Settings":"Ayarlar","Shadow":"Gölge","Shadow:":"Gölge:","Sharpen":"keskinleştirmek","Sharpen tool":"Aleti keskinleştir","Sharpen:":"keskinleştir:","Show / Hide":"Göster / gizle","Show file size:":"Dosya boyutunu göster:","Simple":"Basit","Size":"Boyut","Size is too big, max":"Boyut çok büyük, maks.","Size:":"Boyut:","Skip - layer must be image.":"Atlama - katman resim olmalıdır.","Solarize":"güneşte bırakmak","Sorry, image could not be loaded. Try copy image and paste it.":"Üzgünüz, resim yüklenemedi. Resmi kopyala ve yapıştırmayı deneyin.","Sorry, image is too big, max 5 MB.":"Maalesef, resim çok büyük, maksimum 5 MB.","Source is empty, right click on image to save source position.":"Kaynak boş, kaynağı konumunu kaydetmek için görüntüye sağ tıklayın.","Sprites":"Spritelar","Square":"Kare","Strength:":"Sertlik:","Strict":"sıkı","Stroke":"inme","Stroke:":"İnme:","Target:":"Hedef:","Text":"Metin","Text example":"Tipik örnek","Text:":"Metin:","There are no layers behind.":"Arkada hiçbir katman yok.","There is only 1 layer.":"Sadece bir tabaka var.","Tilt Shift":"Eğim Kaydırma","Times New Roman":"Times New Roman","Toggle":"geçiş","Tools":"Araçlar","Tools class not found:":"Araçlar sınıfı bulunamadı:","Total pixels:":"Toplam piksel:","Translate":"Çevirmek","Translate error, can not find dictionary:":"Çeviri hatası, sözlük bulunamadı:","Transparency background:":"Şeffaflık arka planı:","Transparent:":"Şeffaf:","Trim":"düzeltmek","Trim everything:":"Her şeyi silmelisin:","Trim layer:":"Döşeme tabakası:","Trim white color?":"Beyaz rengini keser misin?","Turkish":"Türk","Undo":"Geri alma","Undo disabled.":"Geri alınıyor devre dışı.","Undo enabled.":"Devre dışı bırakıldı.","Undo is not available.":"Geri al mevcut değil.","Undo levels changed to 1.":"Geri alma seviyeleri 1 olarak değiştirildi.","Undo levels restored to":"Geri yüklenen geri alma seviyeleri","Unique colors:":"Eşsiz renkler:","Up":"yukarı","Use Ctrl+V keyboard shortcut to paste from Clipboard.":"Pano'dan yapıştırmak için Ctrl + V klavye kısayolunu kullanın.","V Radius:":"V Yarıçapı:","Verdana":"Verdana","Version:":"Versiyon:","Vertical":"Dikey","Vertical blur:":"Dikey bulanıklık:","Vibrance":"Titreşim","Vignette":"skeç","ViliusL":"ViliusL","Vintage":"bağbozumu","Visible:":"Gözle görülür:","WEBP - Weppy File Format":"WEBP - Weppy Dosya Biçimi","Website:":"Web sitesi:","Width (%):":"Genişlik (%):","Width:":"Genişlik:","Wrong file type, must be image or json.":"Yanlış dosya türü, resim veya json olmalı.","X end:":"X sonu:","X position:":"X konumu:","X start:":"X start:","Y end:":"Sonum:","Y position:":"Y pozisyonu:","Y start:":"Y başlatın:","You can also drag and drop items into browser.":"Ayrıca öğeleri tarayıcıya sürükleyip bırakabilirsiniz.","Your browser does not support canvas or JavaScript is not enabled.":"Tarayıcınız tuvali desteklemiyor veya JavaScript etkin değil.","Your browser does not support this format.":"Tarayıcınız bu biçimi desteklemiyor.","Your search did not match any images.":"Aramanız herhangi bir resimle eşleşmedi.","Zoom":"yakınlaştırma","Zoom Blur":"Zum Bulanıklığı","Zoom In":"Yakınlaştır","Zoom Out":"Uzaklaştır","Zoom blur":"Yakınlaştırma bulanıklığı","Zoom in":"Yakınlaştır","Zoom out":"Uzaklaştır","Zoom:":"zum:"}

/***/ }),
/* 51 */
/***/ (function(module, exports) {

module.exports = {"2d":"2D","480p":"480P","About":"关于","Active":"活性","Advanced":"高级","All":"所有","Alpha:":"Α：","Anonymous":"匿名","Anti aliasing":"消除锯齿","Arial":"宋体","Arrow":"箭头","Author:":"作者：","Auto adjust colors":"自动调整颜色","Average:":"平均：","BMP - Windows Bitmap":"BMP  -  Windows位图","Base":"基础","Basic":"基本","Black and White":"黑与白","Blue":"蓝色","Blue channel:":"蓝色通道：","Blue:":"蓝色：","Blur Radius:":"模糊半径：","Blur power:":"模糊力量：","Blur tool":"模糊工具","Bold":"胆大","Bold Italic":"加粗斜体","Borders":"国界","Box Blur":"框模糊","Box blur":"框模糊","Brightness":"亮度","Brightness:":"亮度：","Brush":"刷","Bulge/Pinch tool":"凸出/捏合工具","Burn":"烧伤","CSS filters":"CSS过滤器","Can not animate 1 layer.":"不能动画1层。","Can not find previous layer.":"找不到以前的图层。","Cancel":"取消","Center":"中央","Center x:":"中心x：","Center y:":"中心y：","Center:":"中央：","Channel:":"渠道：","Circle":"圈","Clear":"明确","Clone count:":"克隆数：","Clone tool":"克隆工具","Cloned edges":"克隆的边缘","Color #":"颜色＃","Color Zoom":"颜色缩放","Color alpha value can not be zero.":"颜色alpha值不能为零。","Color corrections":"颜色更正","Color palette":"调色板","Color to alpha":"颜色到阿尔法","Color zoom":"彩色变焦","Color:":"颜色：","Colors":"颜色","Colors:":"颜色：","Composition":"组成","Composition:":"组成：","Content fill":"内容填写","Contrast":"对比","Contrast:":"对比：","Convert to raster":"转换为光栅","Copy selection":"复制选择","Copy:":"复制：","Courier":"信使","Crop":"作物","Ctrl+V":"按Ctrl + V","Ctrl-P":"按Ctrl-P","Current":"当前","Curve":"曲线","Custom":"习惯","Data URL":"数据网址","Data URL:":"数据网址：","Decrease color depth":"减少颜色深度","Default":"默认","Degree:":"度：","Del":"德尔","Delete":"删除","Delete selection":"删除选择","Denoise":"降噪","Desaturate":"去色","Description:":"描述：","Differences":"差异","Differences Down":"差异下降","Dither":"抖动","Dithering:":"抖动：","Dominant color:":"主色：","Dot Screen":"点屏幕","Down":"下","Duplicate":"重复","Edge":"边缘","Edit":"编辑","Edit text":"编辑文字","Edit text...":"编辑文字...","Effects":"效果","Email:":"电子邮件：","Emboss":"浮雕","Empty selection":"空的选择","Empty selection or type not image.":"空的选择或输入不是图像。","English":"英语","Enrich":"丰富","Erase":"抹去","Erase on rotate object is disabled. Sorry.":"旋转对象上的擦除被禁用。抱歉。","Error":"错误","Error connecting to service.":"连接到服务时出错。","Error: can not load image.":"错误：无法加载图像。","Error: missing details event target":"错误：缺少详细信息事件目标","Error: unsupported attribute type:":"错误：不支持的属性类型：","Error: wrong key:":"错误：错误的键：","Español":"西班牙语","Expand edges":"展开边缘","Exponent:":"指数：","Factor:":"因子：","File":"文件","File name:":"文件名：","File size:":"文件大小：","Fill":"填","Fit":"适合","Fit window":"适合的窗口","Flatten Image":"拼合图像","Flip":"翻动","FloydSteinberg-serpentine":"FloydSteinberg蛇形","French":"法国","Full HD, 1080p":"全高清，1080p","GIF - Graphics Interchange Format":"GIF  - 图形交换格式","Gap:":"间隙：","Gaussian Blur":"高斯模糊","German":"德语","Gif delay:":"Gif延迟：","GitHub:":"GitHub的：","Gradient":"梯度","Gradient Radius:":"渐变半径：","Grains":"谷物","Gray":"灰色","Grayscale":"灰度","Green":"绿色","Green channel:":"绿色通道：","Green:":"绿色：","Greyscale:":"灰度：","Grid":"格","Grid on/off":"网格开/关","H Radius:":"H半径：","Heatmap":"热图","Height (%):":"身高（％）：","Height:":"高度：","Help":"帮帮我","Helvetica":"黑体","Hermite":"埃尔米特","Hex:":"十六进制：","Histogram":"直方图","Histogram:":"柱状图：","Horizontal":"横","Horizontal blur:":"水平模糊：","Hue Rotate":"色调旋转","Hue:":"色调：","Image":"图片","Image data with multi-layers. Can be opened using miniPaint -":"图像数据与多层。可以使用miniPaint打开 -","Impact":"碰撞","Information":"信息","Insert:":"插：","Italiano":"意大利语","Italic":"斜体","JPG - JPG/JPEG Format":"JPG  -  JPG / JPEG格式","JPG, WEBP quality:":"JPG，WEBP质量：","JSON - Full layers data":"JSON  - 全层数据","Japanese":"日本","Key-points":"关键点","Keyboard Shortcuts":"键盘快捷键","Keyword:":"关键词：","Korean":"朝鲜的","Language":"语言","Last modified":"上一次更改","Layer details":"图层细节","Layer is already image.":"图层已经是图像。","Layer must be image, convert it to raster to apply this tool.":"图层必须是图像，将其转换为栅格来应用此工具。","Layers":"图层","Layers:":"图层：","Left":"剩下","Level:":"水平：","Levels:":"级别：","Lietuvių":"立陶宛ų","Line":"线","Lum:":"绥：","Luminance:":"亮度：","Magic Wand Tool":"魔术棒工具","Merge Down":"合并下来","Merged":"合并的","Mode:":"模式：","Module function not found.":"找不到模块功能。","Modules class not found:":"找不到模块类：","Mosaic":"镶嵌","Mouse:":"老鼠：","Move":"移动","Move down":"下移","Move up":"提升","Name:":"名称：","Needs at least 2 layers.":"至少需要2层。","Negative":"负","New":"新","New file":"新文件","New from selection":"新的选择","New layer":"新的图层","New width can not be smaller then current width":"新的宽度不能小于当前的宽度","Normal":"正常","Nothing is selected.":"没有选择。","Offset X:":"偏移量X：","Offset Y:":"偏移Y：","Oil":"油","Ok":"好","Online image editor.":"在线图像编辑器。","Opacity":"不透明度","Opacity:":"不透明度：","Open":"打开","Open Data URL":"打开数据网址","Open Directory":"打开目录","Open File":"打开文件","Open URL":"打开网址","Open data URL":"打开数据网址","Original size":"原始尺寸","PNG - Portable Network Graphics":"PNG  - 便携式网络图形","Palette":"调色板","Parameter #1:":"参数＃1：","Parameter #2:":"参数＃2：","Paste":"糊","Pencil":"铅笔","Percentage:":"百分比：","Pick Color":"选择颜色","Pixels:":"像素：","Play animation":"播放动画","Portuguese":"葡萄牙语","Power:":"功率：","Powred by  pixabay.com .":"pixabay.com粉丝。","Pre-Blur:":"预模糊：","Preview":"预习","Previous":"以前","Previous layer must be image, convert it to raster to apply this tool.":"上一层必须是图像，将其转换为栅格来应用此工具。","Print":"打印","Quality:":"质量：","Quick load":"快速加载","Quick save":"快速保存","Radial":"径向","Radial gradient":"径向渐变","Radius:":"半径：","Range:":"范围：","Rectangle":"长方形","Red":"红","Red channel:":"红色通道：","Red:":"红：","Rename":"改名","Replace Color":"替换颜色","Replace color":"替换颜色","Replacement:":"替代：","Report issues":"报告问题","Resample - Hermite":"重新取样 -  Hermite","Reset":"重启","Reset zoom level":"重置缩放级别","Resize":"调整","Resized as background":"调整为背景","Resolution:":"解析度：","Restore alpha":"恢复阿尔法","Right":"对","Right angle:":"直角：","Rotate":"旋转","Rotate is not supported on this type of object. Convert to raster?":"这种类型的对象不支持旋转。转换为光栅？","Rotate left":"向左旋转","Rotate:":"旋转：","Russian":"俄语","Sat:":"星期六：","Saturate":"饱和","Saturation:":"饱和：","Save":"保存","Save as":"另存为","Save as data URL":"另存为数据网址","Save as type:":"另存为类型：","Save layers:":"保存图层：","Save resolution:":"保存分辨率：","Scroll down":"向下滚动","Scroll up":"向上滑动","Search":"搜索","Search images":"搜索图片","Select all":"全选","Select object tool":"选择对象工具","Selected":"选","Selection":"选择","Sensitivity:":"灵敏度：","Sepia":"乌贼","Settings":"设置","Shadow":"阴影","Shadow:":"阴影：","Sharpen":"削尖","Sharpen tool":"锐化工具","Sharpen:":"锐化：","Show / Hide":"显示隐藏","Show file size:":"显示文件大小：","Simple":"简单","Size":"尺寸","Size is too big, max":"尺寸太大，最大","Size:":"尺寸：","Skip - layer must be image.":"跳过 - 图层必须是图像。","Solarize":"曝光过度","Sorry, image could not be loaded. Try copy image and paste it.":"对不起，图片无法加载。尝试复制图像并粘贴。","Sorry, image is too big, max 5 MB.":"对不起，图片太大，最大5 MB。","Source is empty, right click on image to save source position.":"源是空的，右键点击图像保存源位置。","Sprites":"精灵","Square":"广场","Strength:":"强度：","Strict":"严格","Stroke":"行程","Stroke:":"行程：","Target:":"目标：","Text":"文本","Text example":"文本示例","Text:":"文本：","There are no layers behind.":"背后没有层。","There is only 1 layer.":"只有1层。","Tilt Shift":"倾斜移位","Times New Roman":"英语字体格式一种","Toggle":"切换","Tools":"工具","Tools class not found:":"找不到工具类：","Total pixels:":"总像素数：","Translate":"翻译","Translate error, can not find dictionary:":"翻译错误，找不到字典：","Transparency background:":"透明背景：","Transparent:":"透明：","Trim":"修剪","Trim everything:":"修剪一切：","Trim layer:":"修剪图层：","Trim white color?":"修剪白色的颜色？","Turkish":"土耳其","Undo":"解开","Undo disabled.":"撤消禁用。","Undo enabled.":"撤消启用。","Undo is not available.":"撤消不可用。","Undo levels changed to 1.":"撤消级别更改为1。","Undo levels restored to":"撤消级别恢复到","Unique colors:":"独特的颜色：","Up":"向上","Use Ctrl+V keyboard shortcut to paste from Clipboard.":"使用Ctrl + V键盘快捷键从剪贴板粘贴。","V Radius:":"V半径：","Verdana":"宋体","Version:":"版：","Vertical":"垂直","Vertical blur:":"垂直迷离：","Vibrance":"鲜艳","Vignette":"小插图","ViliusL":"ViliusL","Vintage":"酿酒","Visible:":"可见：","WEBP - Weppy File Format":"WEBP  -  Weppy文件格式","Website:":"网站：","Width (%):":"宽度（％）：","Width:":"宽度：","Wrong file type, must be image or json.":"错误的文件类型，必须是图像或JSON。","X end:":"X结束：","X position:":"X位置：","X start:":"X开始：","Y end:":"Y结束：","Y position:":"Y位置：","Y start:":"Y开始：","You can also drag and drop items into browser.":"您也可以将项目拖放到浏览器中。","Your browser does not support canvas or JavaScript is not enabled.":"您的浏览器不支持画布或JavaScript未启用。","Your browser does not support this format.":"您的浏览器不支持这种格式。","Your search did not match any images.":"您的搜索与任何图片都不匹配。","Zoom":"放大","Zoom Blur":"变焦模糊","Zoom In":"放大","Zoom Out":"缩小","Zoom blur":"变焦模糊","Zoom in":"放大","Zoom out":"缩小","Zoom:":"放大："}

/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

var map = {
	"./animation.js": 53,
	"./blur.js": 57,
	"./borders.js": 58,
	"./brush.js": 59,
	"./bulge_pinch.js": 60,
	"./circle.js": 61,
	"./clone.js": 62,
	"./crop.js": 63,
	"./desaturate.js": 64,
	"./erase.js": 65,
	"./fill.js": 66,
	"./gradient.js": 67,
	"./line.js": 68,
	"./magic_wand.js": 69,
	"./media.js": 70,
	"./pencil.js": 73,
	"./pick_color.js": 74,
	"./rectangle.js": 75,
	"./select.js": 76,
	"./selection.js": 19,
	"./sharpen.js": 77,
	"./text.js": 78
};
function webpackContext(req) {
	return __webpack_require__(webpackContextResolve(req));
};
function webpackContextResolve(req) {
	var id = map[req];
	if(!(id + 1)) // check for number or string
		throw new Error("Cannot find module '" + req + "'.");
	return id;
};
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = 52;

/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _guiTools = __webpack_require__(13);

var _guiTools2 = _interopRequireDefault(_guiTools);

var _baseGui = __webpack_require__(7);

var _baseGui2 = _interopRequireDefault(_baseGui);

var _baseSelection = __webpack_require__(12);

var _baseSelection2 = _interopRequireDefault(_baseSelection);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var instance = null;

var Animation_class = function (_Base_tools_class) {
	_inherits(Animation_class, _Base_tools_class);

	function Animation_class(ctx) {
		_classCallCheck(this, Animation_class);

		var _this2 = _possibleConstructorReturn(this, (Animation_class.__proto__ || Object.getPrototypeOf(Animation_class)).call(this));

		_this2.Base_layers = new _baseLayers2.default();
		_this2.GUI_tools = new _guiTools2.default();
		_this2.Base_gui = new _baseGui2.default();
		_this2.name = 'animation';
		_this2.intervalID = null;
		_this2.index = 0;

		_this2.disable_selection(ctx);
		return _this2;
	}

	_createClass(Animation_class, [{
		key: 'load',
		value: function load() {
			//nothing
		}
	}, {
		key: 'render',
		value: function render(ctx, layer) {}
		//nothing


		/**
   * disable_selection
   */

	}, {
		key: 'disable_selection',
		value: function disable_selection(ctx) {
			var sel_config = {
				enable_background: false,
				enable_borders: false,
				enable_controlls: false,
				data_function: function data_function() {
					return null;
				}
			};
			this.Base_selection = new _baseSelection2.default(ctx, sel_config, this.name);
		}
	}, {
		key: 'on_params_update',
		value: function on_params_update() {
			var params = this.getParams();
			if (_config2.default.layers.length == 1) {
				_alertifyMin2.default.error('Can not animate 1 layer.');
				return;
			}

			if (params.play == true) {
				this.start(params.delay);
			} else {
				this.stop();
			}
		}
	}, {
		key: 'on_leave',
		value: function on_leave() {
			this.stop();
		}
	}, {
		key: 'start',
		value: function start(delay) {
			var _this = this;
			delay = parseInt(delay);
			if (delay < 0) delay = 50;

			this.intervalID = window.setInterval(function () {
				_this.play(_this);
			}, delay);
		}
	}, {
		key: 'stop',
		value: function stop() {
			var params = this.getParams();
			if (this.intervalID == null) return;

			clearInterval(this.intervalID);
			params.play = false;
			this.index = 0;
			this.GUI_tools.show_action_attributes();

			//make all visible
			for (var i in _config2.default.layers) {
				_config2.default.layers[i].visible = true;
			}

			this.Base_gui.GUI_layers.render_layers();
			_config2.default.need_render = true;
		}
	}, {
		key: 'play',
		value: function play(_this) {

			for (var i in _config2.default.layers) {
				_config2.default.layers[i].visible = false;
			}

			//show 1
			if (_config2.default.layers[this.index] != undefined) {
				_this.Base_layers.toggle_visibility(_config2.default.layers[this.index].id);
			}

			//change index
			if (_config2.default.layers[this.index + 1] != undefined) {
				this.index++;
			} else {
				this.index = 0;
			}
		}
	}]);

	return Animation_class;
}(_baseTools2.default);

;
exports.default = Animation_class;

/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(55);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(11)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {
	// When the styles change, update the <style> tags
	if(!content.locals) {
		module.hot.accept("!!../../node_modules/css-loader/index.js??ref--0-1!./popup.css", function() {
			var newContent = require("!!../../node_modules/css-loader/index.js??ref--0-1!./popup.css");
			if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
			update(newContent);
		});
	}
	// When the module is disposed, remove the <style> tags
	module.hot.dispose(function() { update(); });
}

/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(10)(undefined);
// imports


// module
exports.push([module.i, "#popup{position:fixed;display:none;top:20vh;left:calc(50% - 500px / 2);background-color:#7a838b;border:1px solid rgba(0,0,0,.5);border:1px solid var(--background-color-border);width:500px;max-width:100%;max-height:80vh;margin:0 auto;padding:10px;box-shadow:0 0 20px rgba(0,0,0,.5);z-index:100;overflow-y:auto;font-size:13px;overflow-y:scroll}#popup.wide{top:15vh;width:800px;left:calc(50% - 800px / 2)}#popup a{color:navy}#popup h2{margin:-10px -10px 5px;padding:6px 10px;font-size:18px;background-color:hsla(0,0%,100%,.3);background-color:var(--background-color-light)}#popup .buttons{text-align:center;margin-top:20px;margin-bottom:5px}#popup td,#popup th{height:25px}#popup td{vertical-align:middle}#popup th{text-align:left;padding:5px 5px 5px 0;width:130px}#popup textarea{color:#000;width:100%;border:1px solid #393939;padding-left:5px}#popup .button{margin:0 3px;background-color:hsla(0,0%,100%,.2);background-color:var(--background-color-medium);min-width:60px;border:1px solid rgba(0,0,0,.5);border:1px solid var(--background-color-border);padding:5px 10px}#popup input[type=number],#popup input[type=text],#popup textarea{width:100%}#popup input[type=number]{width:100px}#popup input[type=checkbox],#popup input[type=radio]{margin-left:0}#popup label span{color:#444}#popup .checkbox label{margin-top:5px;color:#444}@media screen and (max-width:500px){#popup{left:0;width:100%}#canvas_preview_container{clear:both}}@media screen and (max-height:650px){#popup{top:0;max-height:100vh}#canvas_preview_container{clear:both}}", ""]);

// exports


/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});
//handles zoom and pan
//https://stackoverflow.com/questions/44009094/how-to-bound-image-pan-when-zooming-html-canvas/44015705#44015705
var zoomView = function () {
	var matrix = [1, 0, 0, 1, 0, 0]; // current view transform
	var invMatrix = [1, 0, 0, 1, 0, 0]; // current inverse view transform
	var m = matrix; // alias
	var im = invMatrix; // alias
	var scale = 1; // current scale
	var bounds = {
		topLeft: 0,
		left: 0,
		right: 200,
		bottom: 200
	};
	var useConstraint = true; // if true then limit pan and zoom to 
	// keep bounds within the current context

	var maxScale = 1;
	var workPoint1 = { x: 0, y: 0 };
	var workPoint2 = { x: 0, y: 0 };
	var wp1 = workPoint1; // alias
	var wp2 = workPoint2; // alias
	var ctx;
	var pos = { // current position of origin
		x: 0,
		y: 0
	};
	var dirty = true;
	var API = {
		canvasDefault: function canvasDefault() {
			ctx.setTransform(1, 0, 0, 1, 0, 0);
		},
		apply: function apply() {
			if (dirty) {
				this.update();
			}
			ctx.setTransform(m[0], m[1], m[2], m[3], m[4], m[5]);
		},
		getScale: function getScale() {
			return scale;
		},
		getMaxScale: function getMaxScale() {
			return maxScale;
		},

		matrix: matrix, // expose the matrix
		invMatrix: invMatrix, // expose the inverse matrix
		update: function update() {
			// call to update transforms
			dirty = false;
			m[3] = m[0] = scale;
			m[1] = m[2] = 0;
			m[4] = pos.x;
			m[5] = pos.y;
			if (useConstraint) {
				this.constrain();
			}
			this.invScale = 1 / scale;
			// calculate the inverse transformation
			var cross = m[0] * m[3] - m[1] * m[2];
			im[0] = m[3] / cross;
			im[1] = -m[1] / cross;
			im[2] = -m[2] / cross;
			im[3] = m[0] / cross;
		},
		constrain: function constrain() {
			maxScale = Math.min(ctx.canvas.width / (bounds.right - bounds.left), ctx.canvas.height / (bounds.bottom - bounds.top));
			if (scale < maxScale) {
				m[0] = m[3] = scale = maxScale;
			}
			wp1.x = bounds.left;
			wp1.y = bounds.top;
			this.toScreen(wp1, wp2);
			if (wp2.x > 0) {
				m[4] = pos.x -= wp2.x;
			}
			if (wp2.y > 0) {
				m[5] = pos.y -= wp2.y;
			}
			wp1.x = bounds.right;
			wp1.y = bounds.bottom;
			this.toScreen(wp1, wp2);
			if (wp2.x < ctx.canvas.width) {
				m[4] = pos.x -= wp2.x - ctx.canvas.width;
			}
			if (wp2.y < ctx.canvas.height) {
				m[5] = pos.y -= wp2.y - ctx.canvas.height;
			}
		},
		toWorld: function toWorld(from_x, from_y) {
			// convert screen to world coords
			var xx, yy;
			var pointW = {};
			if (dirty) {
				this.update();
			}
			xx = from_x - m[4];
			yy = from_y - m[5];
			pointW.x = xx * im[0] + yy * im[2];
			pointW.y = xx * im[1] + yy * im[3];
			return pointW;
		},
		toScreen: function toScreen(from) {
			var point = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
			// convert world coords to screen coords
			if (dirty) {
				this.update();
			}
			point.x = from.x * m[0] + from.y * m[2] + m[4];
			point.y = from.x * m[1] + from.y * m[3] + m[5];
			return point;
		},
		scaleAt: function scaleAt(x_from, y_from, amount) {
			// at in screen coords
			if (dirty) {
				this.update();
			}
			scale *= amount;
			pos.x = x_from - (x_from - pos.x) * amount;
			pos.y = y_from - (y_from - pos.y) * amount;
			dirty = true;
		},
		move: function move(move_x, move_y) {
			// move is in screen coords
			pos.x += move_x;
			pos.y += move_y;
			dirty = true;
		},
		setContext: function setContext(context) {
			ctx = context;
			dirty = true;
		},
		setBounds: function setBounds(top, left, right, bottom) {
			bounds.top = top;
			bounds.left = left;
			bounds.right = right;
			bounds.bottom = bottom;
			useConstraint = true;
			dirty = true;
		}
	};
	return API;
}();

exports.default = zoomView;

/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

var _imagefilters = __webpack_require__(6);

var _imagefilters2 = _interopRequireDefault(_imagefilters);

var _helpers = __webpack_require__(4);

var _helpers2 = _interopRequireDefault(_helpers);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Blur_class = function (_Base_tools_class) {
	_inherits(Blur_class, _Base_tools_class);

	function Blur_class(ctx) {
		_classCallCheck(this, Blur_class);

		var _this2 = _possibleConstructorReturn(this, (Blur_class.__proto__ || Object.getPrototypeOf(Blur_class)).call(this));

		_this2.Base_layers = new _baseLayers2.default();
		_this2.Helper = new _helpers2.default();
		_this2.ctx = ctx;
		_this2.name = 'blur';
		_this2.tmpCanvas = null;
		_this2.tmpCanvasCtx = null;
		_this2.started = false;
		return _this2;
	}

	_createClass(Blur_class, [{
		key: 'load',
		value: function load() {
			var _this = this;

			//mouse events
			document.addEventListener('mousedown', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousedown(e);
			});
			document.addEventListener('mousemove', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousemove(e);

				//mouse cursor
				var mouse = _this.get_mouse_info(e);
				var params = _this.getParams();
				_this.show_mouse_cursor(mouse.x, mouse.y, params.size, 'circle');
			});
			document.addEventListener('mouseup', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mouseup(e);
			});
		}
	}, {
		key: 'mousedown',
		value: function mousedown(e) {
			this.started = false;
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();
			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}
			if (_config2.default.layer.type != 'image') {
				_alertifyMin2.default.error('Layer must be image, convert it to raster to apply this tool.');
				return;
			}
			if (_config2.default.layer.rotate || 0 > 0) {
				_alertifyMin2.default.error('Erase on rotate object is disabled. Sorry.');
				return;
			}
			this.started = true;
			window.State.save();

			//get canvas from layer
			this.tmpCanvas = document.createElement('canvas');
			this.tmpCanvasCtx = this.tmpCanvas.getContext("2d");
			this.tmpCanvas.width = _config2.default.layer.width_original;
			this.tmpCanvas.height = _config2.default.layer.height_original;
			this.tmpCanvasCtx.drawImage(_config2.default.layer.link, 0, 0);

			//do blur
			this.blur_general('click', mouse, params.size, params.strength);

			//register tmp canvas for faster redraw
			_config2.default.layer.link_canvas = this.tmpCanvas;
			_config2.default.need_render = true;
		}
	}, {
		key: 'mousemove',
		value: function mousemove(e) {
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();
			if (mouse.is_drag == false) return;
			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}
			if (this.started == false) {
				return;
			}

			//do blur
			this.blur_general('move', mouse, params.size, params.strength);

			//draw draft preview
			_config2.default.need_render = true;
		}
	}, {
		key: 'mouseup',
		value: function mouseup(e) {
			if (this.started == false) {
				return;
			}
			delete _config2.default.layer.link_canvas;

			this.Base_layers.update_layer_image(this.tmpCanvas);

			//decrease memory
			this.tmpCanvas.width = 1;
			this.tmpCanvas.height = 1;
			this.tmpCanvas = null;
			this.tmpCanvasCtx = null;
		}
	}, {
		key: 'blur_general',
		value: function blur_general(type, mouse, size, strength) {
			var ctx = this.tmpCanvasCtx;
			var mouse_x = Math.round(mouse.x) - _config2.default.layer.x;
			var mouse_y = Math.round(mouse.y) - _config2.default.layer.y;

			//adapt to origin size
			mouse_x = this.adaptSize(mouse_x, 'width');
			mouse_y = this.adaptSize(mouse_y, 'height');
			var size_w = this.adaptSize(size, 'width');
			var size_h = this.adaptSize(size, 'height');

			//find center
			var center_x = mouse_x - Math.round(size_w / 2);
			var center_y = mouse_y - Math.round(size_h / 2);

			//convert float coords to integers
			center_x = Math.round(center_x);
			center_y = Math.round(center_y);
			mouse_x = Math.round(mouse_x);
			mouse_y = Math.round(mouse_y);

			if (type == 'move') {
				strength = strength / 2;
				if (strength < 1) strength = 1;
			}

			var imageData = ctx.getImageData(center_x, center_y, size_w, size_h);
			var filtered = _imagefilters2.default.StackBlur(imageData, strength); //add effect
			this.Helper.image_round(this.tmpCanvasCtx, mouse_x, mouse_y, size_w, size_h, filtered);
		}
	}]);

	return Blur_class;
}(_baseTools2.default);

exports.default = Blur_class;

/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Borders_class = function (_Base_tools_class) {
	_inherits(Borders_class, _Base_tools_class);

	function Borders_class(ctx) {
		_classCallCheck(this, Borders_class);

		var _this = _possibleConstructorReturn(this, (Borders_class.__proto__ || Object.getPrototypeOf(Borders_class)).call(this));

		_this.Base_layers = new _baseLayers2.default();
		_this.ctx = ctx;
		_this.name = 'borders';
		_this.layer = {};
		return _this;
	}

	_createClass(Borders_class, [{
		key: 'load',
		value: function load() {
			//nothing
		}
	}, {
		key: 'render',
		value: function render(ctx, layer) {
			var params = layer.params;
			var size = params.size;
			var width = parseInt(_config2.default.WIDTH);
			var height = parseInt(_config2.default.HEIGHT);

			ctx.save();

			//set styles
			ctx.strokeStyle = layer.color;
			ctx.lineWidth = size;

			if (params.shadow === true) {
				//with shadow
				ctx.beginPath();
				ctx.shadowColor = layer.color;
				ctx.shadowBlur = size * _config2.default.ZOOM;
				ctx.rect(-size / 2, -size / 2, width + size, height + size);
				ctx.stroke();
				ctx.stroke();
				ctx.stroke();
			} else {
				ctx.beginPath();
				ctx.rect(0, 0, width, height);
				ctx.stroke();
			}
			ctx.restore();
		}
	}]);

	return Borders_class;
}(_baseTools2.default);

;
exports.default = Borders_class;

/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Brush_class = function (_Base_tools_class) {
	_inherits(Brush_class, _Base_tools_class);

	function Brush_class(ctx) {
		_classCallCheck(this, Brush_class);

		var _this2 = _possibleConstructorReturn(this, (Brush_class.__proto__ || Object.getPrototypeOf(Brush_class)).call(this));

		_this2.Base_layers = new _baseLayers2.default();
		_this2.ctx = ctx;
		_this2.name = 'brush';
		_this2.data = [];
		_this2.layer = {};
		_this2.params_hash = false;
		return _this2;
	}

	_createClass(Brush_class, [{
		key: 'load',
		value: function load() {
			var _this = this;

			//events
			document.addEventListener('mousedown', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousedown(e);
			});
			document.addEventListener('mousemove', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousemove(e);

				//mouse cursor
				var mouse = _this.get_mouse_info(e);
				var params = _this.getParams();
				_this.show_mouse_cursor(mouse.x, mouse.y, params.size, 'circle');
			});
			document.addEventListener('mouseup', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mouseup(e);
			});
		}
	}, {
		key: 'mousedown',
		value: function mousedown(e) {
			var mouse = this.get_mouse_info(e);
			if (mouse.valid == false || mouse.click_valid == false) return;

			window.State.save();

			var params_hash = this.get_params_hash();

			if (_config2.default.layer.type != this.name || params_hash != this.params_hash) {
				//register new object - current layer is not ours or params changed
				this.data = [];
				this.layer = {
					type: this.name,
					data: this.data,
					params: this.clone(this.getParams()),
					status: 'draft',
					render_function: [this.name, 'render'],
					width: null,
					height: null,
					rotate: null
				};
				this.Base_layers.insert(this.layer);
				this.params_hash = params_hash;
			} else {
				//continue adding layer data, just register break
				this.data.push(null);
			}
		}
	}, {
		key: 'mousemove',
		value: function mousemove(e) {
			var mouse = this.get_mouse_info(e);
			if (mouse.is_drag == false) return;
			if (mouse.valid == false || mouse.click_valid == false) {
				this.data.push(null);
				return;
			}

			var max_speed = 20;
			var power = 2; //how speed affects size
			var params = this.getParams();

			//detect line size
			var size = params.size;
			var new_size = size;
			if (params.smart_brush == true) {
				new_size = size + size / max_speed * mouse.speed_average * power;
				new_size = Math.max(new_size, size / 4);
				new_size = Math.round(new_size);
			}

			//more data
			this.data.push([mouse.x - _config2.default.layer.x, mouse.y - _config2.default.layer.y, new_size]);
			this.Base_layers.render();
		}
	}, {
		key: 'mouseup',
		value: function mouseup(e) {
			var mouse = this.get_mouse_info(e);
			if (mouse.valid == false || mouse.click_valid == false) {
				_config2.default.layer.status = null;
				return;
			}

			//more data
			this.data.push([mouse.x - _config2.default.layer.x, mouse.y - _config2.default.layer.y]);
			_config2.default.layer.status = null;
			this.Base_layers.render();
		}
	}, {
		key: 'render',
		value: function render(ctx, layer) {
			if (layer.data.length == 0) return;

			var params = layer.params;
			var size = params.size;

			//set styles
			ctx.fillStyle = layer.color;
			ctx.strokeStyle = layer.color;
			ctx.lineWidth = params.size;
			ctx.lineCap = 'round';

			ctx.translate(layer.x, layer.y);

			//draw
			var data = layer.data;
			var n = data.length;
			var size = params.size;
			ctx.beginPath();
			ctx.moveTo(data[0][0], data[0][1]);
			for (var i = 1; i < n; i++) {
				if (data[i] === null) {
					//break
					ctx.beginPath();
				} else {
					//line
					ctx.lineWidth = data[i][2];

					if (data[i - 1] == null) {
						//exception - point
						ctx.arc(data[i][0], data[i][1], size / 2, 0, 2 * Math.PI, false);
						ctx.fill();
					} else {
						//lines
						ctx.lineWidth = data[i][2];
						ctx.beginPath();
						ctx.moveTo(data[i - 1][0], data[i - 1][1]);
						ctx.lineTo(data[i][0], data[i][1]);
						ctx.stroke();
					}
				}
			}
			if (n == 1 || data[1] == null) {
				//point
				ctx.beginPath();
				ctx.arc(data[0][0], data[0][1], size / 2, 0, 2 * Math.PI, false);
				ctx.fill();
			}

			ctx.translate(-layer.x, -layer.y);
		}
	}]);

	return Brush_class;
}(_baseTools2.default);

;
exports.default = Brush_class;

/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

var _glfx = __webpack_require__(9);

var _glfx2 = _interopRequireDefault(_glfx);

var _helpers = __webpack_require__(4);

var _helpers2 = _interopRequireDefault(_helpers);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var BulgePinch_class = function (_Base_tools_class) {
	_inherits(BulgePinch_class, _Base_tools_class);

	function BulgePinch_class(ctx) {
		_classCallCheck(this, BulgePinch_class);

		var _this2 = _possibleConstructorReturn(this, (BulgePinch_class.__proto__ || Object.getPrototypeOf(BulgePinch_class)).call(this));

		_this2.Base_layers = new _baseLayers2.default();
		_this2.fx_filter = false;
		_this2.Helper = new _helpers2.default();
		_this2.ctx = ctx;
		_this2.name = 'bulge_pinch';
		_this2.tmpCanvas = null;
		_this2.tmpCanvasCtx = null;
		_this2.started = false;
		return _this2;
	}

	_createClass(BulgePinch_class, [{
		key: 'load',
		value: function load() {
			var _this = this;

			//mouse events
			document.addEventListener('mousedown', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousedown(e);
			});
			document.addEventListener('mousemove', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;

				//mouse cursor
				var mouse = _this.get_mouse_info(e);
				var params = _this.getParams();
				_this.show_mouse_cursor(mouse.x, mouse.y, params.radius, 'circle');
			});
			document.addEventListener('mouseup', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mouseup(e);
			});
		}
	}, {
		key: 'mousedown',
		value: function mousedown(e) {
			this.started = false;
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();
			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}
			if (_config2.default.layer.type != 'image') {
				_alertifyMin2.default.error('Layer must be image, convert it to raster to apply this tool.');
				return;
			}
			this.started = true;
			window.State.save();

			//get canvas from layer
			this.tmpCanvas = document.createElement('canvas');
			this.tmpCanvasCtx = this.tmpCanvas.getContext("2d");
			this.tmpCanvas.width = _config2.default.layer.width_original;
			this.tmpCanvas.height = _config2.default.layer.height_original;
			this.tmpCanvasCtx.drawImage(_config2.default.layer.link, 0, 0);

			//apply
			this.bulgePinch_general(mouse, params.power, params.radius, params.bulge);

			//register tmp canvas for faster redraw
			_config2.default.layer.link_canvas = this.tmpCanvas;
			_config2.default.need_render = true;
		}
	}, {
		key: 'mouseup',
		value: function mouseup(e) {
			if (this.started == false) {
				return;
			}
			delete _config2.default.layer.link_canvas;

			this.Base_layers.update_layer_image(this.tmpCanvas);

			//decrease memory
			this.tmpCanvas.width = 1;
			this.tmpCanvas.height = 1;
			this.tmpCanvas = null;
			this.tmpCanvasCtx = null;
		}
	}, {
		key: 'bulgePinch_general',
		value: function bulgePinch_general(mouse, power, radius, bulge) {
			if (this.fx_filter == false) {
				//init glfx lib
				this.fx_filter = _glfx2.default.canvas();
			}

			var ctx = this.tmpCanvasCtx;
			var mouse_x = Math.round(mouse.x) - _config2.default.layer.x;
			var mouse_y = Math.round(mouse.y) - _config2.default.layer.y;

			//adapt to origin size
			mouse_x = this.adaptSize(mouse_x, 'width');
			mouse_y = this.adaptSize(mouse_y, 'height');

			//convert float coords to integers
			mouse_x = Math.round(mouse_x);
			mouse_y = Math.round(mouse_y);

			power = power / 100;
			if (power > 1) {
				//max 100%
				power = 1;
			}

			if (bulge == false) power = -1 * power;

			var texture = this.fx_filter.texture(this.tmpCanvas);
			this.fx_filter.draw(texture).bulgePinch(mouse_x, mouse_y, radius, power).update(); //effect
			this.tmpCanvasCtx.clearRect(0, 0, this.tmpCanvas.width, this.tmpCanvas.height);
			this.tmpCanvasCtx.drawImage(this.fx_filter, 0, 0);
		}
	}]);

	return BulgePinch_class;
}(_baseTools2.default);

exports.default = BulgePinch_class;

/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Circle_class = function (_Base_tools_class) {
	_inherits(Circle_class, _Base_tools_class);

	function Circle_class(ctx) {
		_classCallCheck(this, Circle_class);

		var _this2 = _possibleConstructorReturn(this, (Circle_class.__proto__ || Object.getPrototypeOf(Circle_class)).call(this));

		_this2.Base_layers = new _baseLayers2.default();
		_this2.ctx = ctx;
		_this2.name = 'circle';
		_this2.layer = {};
		return _this2;
	}

	_createClass(Circle_class, [{
		key: 'load',
		value: function load() {
			var _this = this;

			//events
			document.addEventListener('mousedown', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousedown(e);
			});
			document.addEventListener('mousemove', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousemove(e);
			});
			document.addEventListener('mouseup', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mouseup(e);
			});
		}
	}, {
		key: 'mousedown',
		value: function mousedown(e) {
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();
			if (mouse.valid == false || mouse.click_valid == false) return;

			window.State.save();

			//register new object - current layer is not ours or params changed
			this.layer = {
				type: this.name,
				params: this.clone(this.getParams()),
				render_function: [this.name, 'render'],
				status: 'draft',
				x: mouse.x,
				y: mouse.y,
				data: {
					center_x: mouse.x,
					center_y: mouse.y
				}
			};
			if (params.circle == true) {
				//disable rotate
				this.layer.rotate = null;
			}
			this.Base_layers.insert(this.layer);
		}
	}, {
		key: 'mousemove',
		value: function mousemove(e) {
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();

			if (mouse.is_drag == false) return;
			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}

			var width = mouse.x - this.layer.x;
			var height = mouse.y - this.layer.y;
			if (params.circle == true) {
				width = Math.round(Math.sqrt(width * width + height * height));
				height = width;
			}

			//more data
			_config2.default.layer.x = this.layer.data.center_x - width;
			_config2.default.layer.y = this.layer.data.center_y - height;
			_config2.default.layer.width = width * 2;
			_config2.default.layer.height = height * 2;
			this.Base_layers.render();
		}
	}, {
		key: 'mouseup',
		value: function mouseup(e) {
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();

			if (mouse.valid == false || mouse.click_valid == false) {
				_config2.default.layer.status = null;
				return;
			}

			var width = mouse.x - this.layer.x;
			var height = mouse.y - this.layer.y;
			if (params.circle == true) {
				width = Math.round(Math.sqrt(width * width + height * height));
				height = width;
			}

			if (width == 0 && height == 0) {
				//same coordinates - cancel
				this.Base_layers.delete(_config2.default.layer.id);
				return;
			}

			//more data
			_config2.default.layer.x = this.layer.data.center_x - width;
			_config2.default.layer.y = this.layer.data.center_y - height;
			_config2.default.layer.width = width * 2;
			_config2.default.layer.height = height * 2;
			_config2.default.layer.status = null;
			this.Base_layers.render();
		}
	}, {
		key: 'render',
		value: function render(ctx, layer) {
			var params = layer.params;
			var rotateSupport = true;

			ctx.save();

			//set styles
			ctx.fillStyle = layer.color;
			ctx.strokeStyle = layer.color;
			ctx.lineWidth = params.size;

			var dist_x = layer.width;
			var dist_y = layer.height;

			if (rotateSupport == false) {
				this.ellipse_by_center(ctx, layer.x + Math.round(layer.width / 2), layer.y + Math.round(layer.height / 2), dist_x, dist_y, params.fill);
			} else {
				ctx.translate(layer.x + layer.width / 2, layer.y + layer.height / 2);
				ctx.rotate(layer.rotate * Math.PI / 180);
				this.ellipse_by_center(ctx, -layer.width / 2 + Math.round(layer.width / 2), -layer.height / 2 + Math.round(layer.height / 2), dist_x, dist_y, params.fill);
			}

			ctx.restore();
		}
	}, {
		key: 'ellipse_by_center',
		value: function ellipse_by_center(ctx, cx, cy, w, h, fill) {
			this.ellipse(ctx, cx - w / 2.0, cy - h / 2.0, w, h, fill);
		}
	}, {
		key: 'ellipse',
		value: function ellipse(ctx, x, y, w, h, fill) {
			var kappa = .5522848,
			    ox = w / 2 * kappa,
			    // control point offset horizontal
			oy = h / 2 * kappa,
			    // control point offset vertical
			xe = x + w,
			    // x-end
			ye = y + h,
			    // y-end
			xm = x + w / 2,
			    // x-middle
			ym = y + h / 2; // y-middle

			ctx.beginPath();
			ctx.moveTo(x, ym);
			ctx.bezierCurveTo(x, ym - oy, xm - ox, y, xm, y);
			ctx.bezierCurveTo(xm + ox, y, xe, ym - oy, xe, ym);
			ctx.bezierCurveTo(xe, ym + oy, xm + ox, ye, xm, ye);
			ctx.bezierCurveTo(xm - ox, ye, x, ym + oy, x, ym);
			ctx.closePath();
			if (fill == undefined || fill == false) ctx.stroke();else ctx.fill();
		}
	}]);

	return Circle_class;
}(_baseTools2.default);

;
exports.default = Circle_class;

/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _raster = __webpack_require__(20);

var _raster2 = _interopRequireDefault(_raster);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Clone_class = function (_Base_tools_class) {
	_inherits(Clone_class, _Base_tools_class);

	function Clone_class(ctx) {
		_classCallCheck(this, Clone_class);

		var _this2 = _possibleConstructorReturn(this, (Clone_class.__proto__ || Object.getPrototypeOf(Clone_class)).call(this));

		_this2.Base_layers = new _baseLayers2.default();
		_this2.Layer_raster = new _raster2.default();
		_this2.ctx = ctx;
		_this2.name = 'clone';
		_this2.tmpCanvas = null;
		_this2.tmpCanvasCtx = null;
		_this2.started = false;
		_this2.clone_coords = null;
		return _this2;
	}

	_createClass(Clone_class, [{
		key: 'load',
		value: function load() {
			var _this = this;

			//mouse events
			document.addEventListener('mousedown', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousedown(e);
			});
			document.addEventListener('mousemove', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousemove(e);

				//mouse cursor
				var mouse = _this.get_mouse_info(e);
				var params = _this.getParams();
				_this.show_mouse_cursor(mouse.x, mouse.y, params.size, 'circle');
			});
			document.addEventListener('mouseup', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mouseup(e);
			});
			document.addEventListener('contextmenu', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mouseRightClick(e);
			});
		}
	}, {
		key: 'on_params_update',
		value: function on_params_update() {
			var params = this.getParams();
			var strict_element = document.getElementById('strict');

			if (params.circle == false) {
				//hide strict controlls
				strict_element.style.display = 'none';
			} else {
				//show strict controlls
				strict_element.style.display = 'block';
			}
		}
	}, {
		key: 'mouseRightClick',
		value: function mouseRightClick(e) {
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();

			if (mouse.valid == true) {
				e.preventDefault();
			}
			if (params.source_layer.value == 'Previous' && _config2.default.layer.type === null) {
				this.Layer_raster.raster();
			}
			if (_config2.default.layer.type != 'image') {
				_alertifyMin2.default.error('Layer must be image, convert it to raster to apply this tool.');
				return;
			}
			if (_config2.default.layer.rotate || 0 > 0) {
				_alertifyMin2.default.error('Erase on rotate object is disabled. Sorry.');
				return;
			}
			if (e.which == 3 && mouse.valid == true) {
				//right click - save coords

				var mouse_x = this.adaptSize(mouse.x, 'width');
				var mouse_y = this.adaptSize(mouse.y, 'height');

				this.clone_coords = {
					x: mouse_x,
					y: mouse_y
				};
			}
		}
	}, {
		key: 'mousedown',
		value: function mousedown(e) {
			this.started = false;
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();
			var layer = _config2.default.layer;
			var previous_layer = this.Base_layers.find_previous(_config2.default.layer.id);

			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}

			if (params.source_layer.value == 'Previous' && _config2.default.layer.type === null) {
				this.Layer_raster.raster();
			}
			if (_config2.default.layer.type != 'image') {
				_alertifyMin2.default.error('Layer must be image, convert it to raster to apply this tool.');
				return;
			}
			if (_config2.default.layer.rotate || 0 > 0) {
				_alertifyMin2.default.error('Erase on rotate object is disabled. Sorry.');
				return;
			}
			if (this.clone_coords === null) {
				_alertifyMin2.default.error('Source is empty, right click on image to save source position.');
				return;
			}
			if (layer.width != layer.width_original || layer.height != layer.height_original) {
				_alertifyMin2.default.error('Clone tool disabled for resized image. Sorry.');
				return;
			}
			if (params.source_layer.value == 'Previous' && (previous_layer.width != previous_layer.width_original || previous_layer.height != previous_layer.height_original)) {
				_alertifyMin2.default.error('Clone tool disabled for resized image. Sorry.');
				return;
			}
			if (params.source_layer.value == 'Previous') {
				if (previous_layer == null) {
					_alertifyMin2.default.error('Can not find previous layer.');
					return;
				}
				if (previous_layer.type != 'image') {
					_alertifyMin2.default.error('Previous layer must be image, convert it to raster to apply this tool.');
					return;
				}
			}
			this.started = true;
			window.State.save();

			//get canvas from layer
			this.tmpCanvas = document.createElement('canvas');
			this.tmpCanvasCtx = this.tmpCanvas.getContext("2d");
			this.tmpCanvas.width = _config2.default.layer.width_original;
			this.tmpCanvas.height = _config2.default.layer.height_original;
			this.tmpCanvasCtx.drawImage(_config2.default.layer.link, 0, 0);

			//clone
			this.clone_general(this.tmpCanvas, this.tmpCanvas, 'click', mouse);

			//register tmp canvas for progress redraw
			_config2.default.layer.link_canvas = this.tmpCanvas;
			_config2.default.need_render = true;
		}
	}, {
		key: 'mousemove',
		value: function mousemove(e) {
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();

			if (mouse.is_drag == false) return;
			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}
			if (this.started == false) {
				return;
			}

			//clone
			this.clone_general(this.tmpCanvas, this.tmpCanvas, 'move', mouse);

			//draw draft preview
			_config2.default.need_render = true;
		}
	}, {
		key: 'mouseup',
		value: function mouseup(e) {
			if (this.started == false) {
				return;
			}
			delete _config2.default.layer.link_canvas;

			this.Base_layers.update_layer_image(this.tmpCanvas);

			//decrease memory
			this.tmpCanvas.width = 1;
			this.tmpCanvas.height = 1;
			this.tmpCanvas = null;
			this.tmpCanvasCtx = null;
		}
	}, {
		key: 'clone_general',
		value: function clone_general(canvas_from, canvas_to, type, mouse) {
			var params = this.getParams();

			var mouse_x = Math.round(mouse.x) - _config2.default.layer.x;
			var mouse_y = Math.round(mouse.y) - _config2.default.layer.y;
			var half = Math.round(params.size / 2);

			//adapt to origin size
			mouse_x = this.adaptSize(mouse_x, 'width');
			mouse_y = this.adaptSize(mouse_y, 'height');

			//convert float coords to integers
			mouse_x = Math.round(mouse_x);
			mouse_y = Math.round(mouse_y);

			//create source canvas
			var canvas_source = document.createElement("canvas");
			var ctx_source = canvas_source.getContext("2d");
			var w = Math.ceil(params.size);
			var h = Math.ceil(params.size);
			canvas_source.width = w;
			canvas_source.height = h;

			//add data
			var x_from = Math.round(this.clone_coords.x - (mouse.click_x - mouse_x));
			var y_from = Math.round(this.clone_coords.y - (mouse.click_y - mouse_y));
			if (params.anti_aliasing == false) {
				ctx_source.arc(half, half, half, 0, Math.PI * 2, false);
				ctx_source.clip();
			}
			if (params.source_layer.value == 'Previous') {
				var previous_layer = this.Base_layers.find_previous(_config2.default.layer.id);

				x_from = Math.round(this.clone_coords.x - (mouse.click_x - mouse_x)) - previous_layer.x + _config2.default.layer.x;
				y_from = Math.round(this.clone_coords.y - (mouse.click_y - mouse_y)) - previous_layer.y + _config2.default.layer.y;

				ctx_source.drawImage(previous_layer.link, x_from - half, y_from - half, w, h, 0, 0, w, h);
			} else {
				ctx_source.drawImage(canvas_from, x_from - half, y_from - half, w, h, 0, 0, w, h);
			}

			//apply anti aliasing
			if (params.anti_aliasing == true) {
				var gradient = ctx_source.createRadialGradient(half, half, 0, half, half, half + 1);
				gradient.addColorStop(0, 'white');
				gradient.addColorStop(0.3, 'white');
				gradient.addColorStop(1, 'transparent');
				ctx_source.fillStyle = gradient;

				ctx_source.globalCompositeOperation = 'destination-in';
				ctx_source.fillRect(0, 0, params.size, params.size);
				ctx_source.globalCompositeOperation = 'source-over';
			}

			//finish
			canvas_to.getContext("2d").drawImage(canvas_source, mouse_x - half, mouse_y - half);
		}
	}]);

	return Clone_class;
}(_baseTools2.default);

exports.default = Clone_class;

/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _guiTools = __webpack_require__(13);

var _guiTools2 = _interopRequireDefault(_guiTools);

var _baseGui = __webpack_require__(7);

var _baseGui2 = _interopRequireDefault(_baseGui);

var _baseSelection = __webpack_require__(12);

var _baseSelection2 = _interopRequireDefault(_baseSelection);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Crop_class = function (_Base_tools_class) {
	_inherits(Crop_class, _Base_tools_class);

	function Crop_class(ctx) {
		_classCallCheck(this, Crop_class);

		var _this2 = _possibleConstructorReturn(this, (Crop_class.__proto__ || Object.getPrototypeOf(Crop_class)).call(this));

		var _this = _this2;
		_this2.Base_layers = new _baseLayers2.default();
		_this2.Base_gui = new _baseGui2.default();
		_this2.GUI_tools = new _guiTools2.default();
		_this2.ctx = ctx;
		_this2.name = 'crop';
		_this2.selection = {
			x: null,
			y: null,
			width: null,
			height: null
		};
		var sel_config = {
			enable_background: true,
			enable_borders: true,
			enable_controlls: true,
			data_function: function data_function() {
				return _this.selection;
			}
		};
		_this2.Base_selection = new _baseSelection2.default(ctx, sel_config, _this2.name);
		return _this2;
	}

	_createClass(Crop_class, [{
		key: 'load',
		value: function load() {
			var _this = this;

			//events
			document.addEventListener('mousedown', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousedown(e);
			});
			document.addEventListener('mousemove', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousemove(e);
			});
			document.addEventListener('mouseup', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mouseup(e);
			});
		}
	}, {
		key: 'mousedown',
		value: function mousedown(e) {
			var mouse = this.get_mouse_info(e);
			if (mouse.valid == false || mouse.click_valid == false) return;

			if (this.Base_selection.mouse_lock !== null) {
				return;
			}

			//create new selection
			this.Base_selection.set_selection(mouse.x, mouse.y, 0, 0);
		}
	}, {
		key: 'mousemove',
		value: function mousemove(e) {
			var mouse = this.get_mouse_info(e);
			if (mouse.is_drag == false) {
				return;
			}
			if (e.type == 'mousedown' && (mouse.valid == false || mouse.click_valid == false)) {
				return;
			}
			if (this.Base_selection.mouse_lock !== null) {
				return;
			}

			var width = mouse.x - mouse.click_x;
			var height = mouse.y - mouse.click_y;

			this.Base_selection.set_selection(null, null, width, height);
		}
	}, {
		key: 'mouseup',
		value: function mouseup(e) {
			var mouse = this.get_mouse_info(e);

			if (e.type == 'mousedown' && mouse.click_valid == false) {
				return;
			}

			var width = mouse.x - this.selection.x;
			var height = mouse.y - this.selection.y;

			if (width == 0 || height == 0) {
				//cancel selection
				this.Base_selection.reset_selection();
				_config2.default.need_render = true;
				return;
			}

			if (this.selection.width != null) {
				//make sure coords not negative
				var details = this.selection;
				var x = details.x;
				var y = details.y;
				if (details.width < 0) {
					x = x + details.width;
				}
				if (details.height < 0) {
					y = y + details.height;
				}
				this.selection = {
					x: x,
					y: y,
					width: Math.abs(details.width),
					height: Math.abs(details.height)
				};
			}

			//controll boundaries
			if (this.selection.x < 0) {
				this.selection.width += this.selection.x;
				this.selection.x = 0;
			}
			if (this.selection.y < 0) {
				this.selection.height += this.selection.y;
				this.selection.y = 0;
			}
			if (this.selection.x + this.selection.width > _config2.default.WIDTH) {
				this.selection.width = _config2.default.WIDTH - this.selection.x;
			}
			if (this.selection.y + this.selection.height > _config2.default.HEIGHT) {
				this.selection.height = _config2.default.HEIGHT - this.selection.y;
			}

			_config2.default.need_render = true;
		}
	}, {
		key: 'render',
		value: function render(ctx, layer) {}
		//nothing


		/**
   * do actual crop
   */

	}, {
		key: 'on_params_update',
		value: function on_params_update() {
			var params = this.getParams();
			var selection = this.selection;
			params.crop = true;
			this.GUI_tools.show_action_attributes();

			if (selection.width == null || selection.width == 0 || selection.height == 0) {
				_alertifyMin2.default.error('Empty selection');
				return;
			}

			window.State.save();

			//controll boundaries
			selection.x = Math.max(selection.x, 0);
			selection.y = Math.max(selection.y, 0);
			selection.width = Math.min(selection.width, _config2.default.WIDTH);
			selection.height = Math.min(selection.height, _config2.default.HEIGHT);

			for (var i in _config2.default.layers) {
				var link = _config2.default.layers[i];
				if (link.type == null) continue;

				//move
				link.x -= parseInt(selection.x);
				link.y -= parseInt(selection.y);

				if (link.type == 'image') {
					//also remove unvisible data
					var left = 0;
					if (link.x < 0) left = -link.x;
					var top = 0;
					if (link.y < 0) top = -link.y;
					var right = 0;
					if (link.x + link.width > selection.width) right = link.x + link.width - selection.width;
					var bottom = 0;
					if (link.y + link.height > selection.height) bottom = link.y + link.height - selection.height;
					var width = link.width - left - right;
					var height = link.height - top - bottom;

					//if image was streched
					var width_ratio = link.width / link.width_original;
					var height_ratio = link.height / link.height_original;

					//create smaller canvas
					var canvas = document.createElement('canvas');
					var ctx = canvas.getContext("2d");
					canvas.width = width / width_ratio;
					canvas.height = height / height_ratio;

					//cut required part
					ctx.translate(-left / width_ratio, -top / height_ratio);
					canvas.getContext("2d").drawImage(link.link, 0, 0);
					ctx.translate(0, 0);
					this.Base_layers.update_layer_image(canvas, link.id);

					//update attributes
					link.width = Math.ceil(canvas.width * width_ratio);
					link.height = Math.ceil(canvas.height * height_ratio);
					link.x += left;
					link.y += top;
					link.width_original = canvas.width;
					link.height_original = canvas.height;
				}
			}

			_config2.default.WIDTH = parseInt(selection.width);
			_config2.default.HEIGHT = parseInt(selection.height);

			this.Base_gui.prepare_canvas();
			this.selection = {
				x: null,
				y: null,
				width: null,
				height: null
			};
			this.Base_selection.reset_selection();
		}
	}, {
		key: 'on_leave',
		value: function on_leave() {
			this.Base_selection.reset_selection();
		}
	}]);

	return Crop_class;
}(_baseTools2.default);

exports.default = Crop_class;

/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

var _imagefilters = __webpack_require__(6);

var _imagefilters2 = _interopRequireDefault(_imagefilters);

var _helpers = __webpack_require__(4);

var _helpers2 = _interopRequireDefault(_helpers);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Desaturate_class = function (_Base_tools_class) {
	_inherits(Desaturate_class, _Base_tools_class);

	function Desaturate_class(ctx) {
		_classCallCheck(this, Desaturate_class);

		var _this2 = _possibleConstructorReturn(this, (Desaturate_class.__proto__ || Object.getPrototypeOf(Desaturate_class)).call(this));

		_this2.Base_layers = new _baseLayers2.default();
		_this2.Helper = new _helpers2.default();
		_this2.ctx = ctx;
		_this2.name = 'desaturate';
		_this2.tmpCanvas = null;
		_this2.tmpCanvasCtx = null;
		_this2.started = false;
		return _this2;
	}

	_createClass(Desaturate_class, [{
		key: 'load',
		value: function load() {
			var _this = this;

			//mouse events
			document.addEventListener('mousedown', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousedown(e);
			});
			document.addEventListener('mousemove', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousemove(e);

				//mouse cursor
				var mouse = _this.get_mouse_info(e);
				var params = _this.getParams();
				_this.show_mouse_cursor(mouse.x, mouse.y, params.size, 'circle');
			});
			document.addEventListener('mouseup', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mouseup(e);
			});
		}
	}, {
		key: 'mousedown',
		value: function mousedown(e) {
			this.started = false;
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();
			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}
			if (_config2.default.layer.type != 'image') {
				_alertifyMin2.default.error('Layer must be image, convert it to raster to apply this tool.');
				return;
			}
			if (_config2.default.layer.rotate || 0 > 0) {
				_alertifyMin2.default.error('Erase on rotate object is disabled. Sorry.');
				return;
			}
			this.started = true;
			window.State.save();

			//get canvas from layer
			this.tmpCanvas = document.createElement('canvas');
			this.tmpCanvasCtx = this.tmpCanvas.getContext("2d");
			this.tmpCanvas.width = _config2.default.layer.width_original;
			this.tmpCanvas.height = _config2.default.layer.height_original;

			this.tmpCanvasCtx.drawImage(_config2.default.layer.link, 0, 0);

			//do desaturate
			this.desaturate_general('click', mouse, params.size, params.anti_aliasing);

			//register tmp canvas for faster redraw
			_config2.default.layer.link_canvas = this.tmpCanvas;
			_config2.default.need_render = true;
		}
	}, {
		key: 'mousemove',
		value: function mousemove(e) {
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();
			if (mouse.is_drag == false) return;
			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}
			if (this.started == false) {
				return;
			}

			//do desaturate
			this.desaturate_general('move', mouse, params.size, params.anti_aliasing);

			//draw draft preview
			_config2.default.need_render = true;
		}
	}, {
		key: 'mouseup',
		value: function mouseup(e) {
			if (this.started == false) {
				return;
			}
			delete _config2.default.layer.link_canvas;

			this.Base_layers.update_layer_image(this.tmpCanvas);

			//decrease memory
			this.tmpCanvas.width = 1;
			this.tmpCanvas.height = 1;
			this.tmpCanvas = null;
			this.tmpCanvasCtx = null;
		}
	}, {
		key: 'desaturate_general',
		value: function desaturate_general(type, mouse, size, anti_aliasing) {
			var ctx = this.tmpCanvasCtx;
			var mouse_x = Math.round(mouse.x) - _config2.default.layer.x;
			var mouse_y = Math.round(mouse.y) - _config2.default.layer.y;

			//adapt to origin size
			mouse_x = this.adaptSize(mouse_x, 'width');
			mouse_y = this.adaptSize(mouse_y, 'height');
			var size_w = this.adaptSize(size, 'width');
			var size_h = this.adaptSize(size, 'height');

			//find center
			var center_x = mouse_x - Math.round(size_w / 2);
			var center_y = mouse_y - Math.round(size_h / 2);

			//convert float coords to integers
			center_x = Math.round(center_x);
			center_y = Math.round(center_y);
			mouse_x = Math.round(mouse_x);
			mouse_y = Math.round(mouse_y);

			var imageData = ctx.getImageData(center_x, center_y, size_w, size_h);
			var filtered = _imagefilters2.default.GrayScale(imageData); //add effect
			this.Helper.image_round(this.tmpCanvasCtx, mouse_x, mouse_y, size_w, size_h, filtered, anti_aliasing);
		}
	}]);

	return Desaturate_class;
}(_baseTools2.default);

exports.default = Desaturate_class;

/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Erase_class = function (_Base_tools_class) {
	_inherits(Erase_class, _Base_tools_class);

	function Erase_class(ctx) {
		_classCallCheck(this, Erase_class);

		var _this2 = _possibleConstructorReturn(this, (Erase_class.__proto__ || Object.getPrototypeOf(Erase_class)).call(this));

		_this2.Base_layers = new _baseLayers2.default();
		_this2.ctx = ctx;
		_this2.name = 'erase';
		_this2.tmpCanvas = null;
		_this2.tmpCanvasCtx = null;
		_this2.started = false;
		return _this2;
	}

	_createClass(Erase_class, [{
		key: 'load',
		value: function load() {
			var _this = this;

			//mouse events
			document.addEventListener('mousedown', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousedown(e);
			});
			document.addEventListener('mousemove', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousemove(e);

				//mouse cursor
				var mouse = _this.get_mouse_info(e);
				var params = _this.getParams();
				if (params.circle == true) _this.show_mouse_cursor(mouse.x, mouse.y, params.size, 'circle');else _this.show_mouse_cursor(mouse.x, mouse.y, params.size, 'rect');
			});
			document.addEventListener('mouseup', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mouseup(e);
			});
		}
	}, {
		key: 'on_params_update',
		value: function on_params_update() {
			var params = this.getParams();
			var strict_element = document.querySelector('.attributes #strict');

			if (params.circle == false) {
				//hide strict controlls
				strict_element.style.display = 'none';
			} else {
				//show strict controlls
				strict_element.style.display = 'block';
			}
		}
	}, {
		key: 'mousedown',
		value: function mousedown(e) {
			this.started = false;
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();
			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}
			if (_config2.default.layer.type != 'image') {
				_alertifyMin2.default.error('Layer must be image, convert it to raster to apply this tool.');
				return;
			}
			if (_config2.default.layer.rotate || 0 > 0) {
				_alertifyMin2.default.error('Erase on rotate object is disabled. Sorry.');
				return;
			}
			this.started = true;
			window.State.save();

			//get canvas from layer
			this.tmpCanvas = document.createElement('canvas');
			this.tmpCanvasCtx = this.tmpCanvas.getContext("2d");
			this.tmpCanvas.width = _config2.default.layer.width_original;
			this.tmpCanvas.height = _config2.default.layer.height_original;
			this.tmpCanvasCtx.drawImage(_config2.default.layer.link, 0, 0);

			this.tmpCanvasCtx.scale(_config2.default.layer.width_original / _config2.default.layer.width, _config2.default.layer.height_original / _config2.default.layer.height);

			//do erase
			this.erase_general(this.tmpCanvasCtx, 'click', mouse, params.size, params.strict, params.circle);

			//register tmp canvas for faster redraw
			_config2.default.layer.link_canvas = this.tmpCanvas;
			_config2.default.need_render = true;
		}
	}, {
		key: 'mousemove',
		value: function mousemove(e) {
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();
			if (mouse.is_drag == false) return;
			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}
			if (this.started == false) {
				return;
			}
			if (mouse.click_x == mouse.x && mouse.click_y == mouse.y) {
				//same coordinates
				return;
			}

			//do erase
			this.erase_general(this.tmpCanvasCtx, 'move', mouse, params.size, params.strict, params.circle);

			//draw draft preview
			_config2.default.need_render = true;
		}
	}, {
		key: 'mouseup',
		value: function mouseup(e) {
			if (this.started == false) {
				return;
			}
			delete _config2.default.layer.link_canvas;

			this.Base_layers.update_layer_image(this.tmpCanvas);

			//decrease memory
			this.tmpCanvas.width = 1;
			this.tmpCanvas.height = 1;
			this.tmpCanvas = null;
			this.tmpCanvasCtx = null;
		}
	}, {
		key: 'erase_general',
		value: function erase_general(ctx, type, mouse, size, strict, is_circle) {
			var mouse_x = Math.round(mouse.x) - _config2.default.layer.x;
			var mouse_y = Math.round(mouse.y) - _config2.default.layer.y;
			var alpha = _config2.default.ALPHA;
			var mouse_last_x = parseInt(mouse.last_x) - _config2.default.layer.x;
			var mouse_last_y = parseInt(mouse.last_y) - _config2.default.layer.y;

			ctx.beginPath();
			ctx.lineWidth = size;
			ctx.lineCap = 'round';
			ctx.lineJoin = 'round';
			if (alpha < 255) ctx.strokeStyle = "rgba(255, 255, 255, " + alpha / 255 / 10 + ")";else ctx.strokeStyle = "rgba(255, 255, 255, 1)";

			if (is_circle == false) {
				//rectangle
				var size_half = Math.ceil(size / 2);
				if (size == 1) {
					//single cell mode
					mouse_x = Math.floor(mouse.x) - _config2.default.layer.x;
					mouse_y = Math.floor(mouse.y) - _config2.default.layer.y;
					size_half = 0;
				}
				ctx.save();
				ctx.globalCompositeOperation = 'destination-out';
				ctx.fillStyle = "rgba(255, 255, 255, " + alpha / 255 + ")";
				ctx.fillRect(mouse_x - size_half, mouse_y - size_half, size, size);
				ctx.restore();
			} else {
				//circle
				ctx.save();

				if (strict == false) {
					var radgrad = ctx.createRadialGradient(mouse_x, mouse_y, size / 8, mouse_x, mouse_y, size / 2);
					if (type == 'click') radgrad.addColorStop(0, "rgba(255, 255, 255, " + alpha / 255 + ")");else if (type == 'move') radgrad.addColorStop(0, "rgba(255, 255, 255, " + alpha / 255 / 2 + ")");
					radgrad.addColorStop(1, "rgba(255, 255, 255, 0)");
				}

				//set Composite
				ctx.globalCompositeOperation = 'destination-out';
				if (strict == true) ctx.fillStyle = "rgba(255, 255, 255, " + alpha / 255 + ")";else ctx.fillStyle = radgrad;
				ctx.beginPath();
				ctx.arc(mouse_x, mouse_y, size / 2, 0, Math.PI * 2, true);
				ctx.fill();
				ctx.restore();
			}

			//extra work if mouse moving fast
			if (type == 'move' && is_circle == true && mouse_last_x != false && mouse_last_y != false) {
				if (strict == false && is_circle == true) {
					var radgrad = ctx.createRadialGradient(mouse_x, mouse_y, size / 10, mouse_x, mouse_y, size / 2);
					if (alpha < 255) radgrad.addColorStop(0, "rgba(255, 255, 255, " + alpha / 255 / 10 + ")");else radgrad.addColorStop(0, "rgba(255, 255, 255, 1)");
					radgrad.addColorStop(1, "rgba(255, 255, 255, 0)");
					ctx.strokeStyle = radgrad;
				}

				ctx.save();
				ctx.globalCompositeOperation = 'destination-out';

				ctx.beginPath();
				ctx.moveTo(mouse_last_x, mouse_last_y);
				ctx.lineTo(mouse_x, mouse_y);
				ctx.stroke();

				ctx.restore();
			}
		}
	}]);

	return Erase_class;
}(_baseTools2.default);

exports.default = Erase_class;

/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _helpers = __webpack_require__(4);

var _helpers2 = _interopRequireDefault(_helpers);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Fill_class = function (_Base_tools_class) {
	_inherits(Fill_class, _Base_tools_class);

	function Fill_class(ctx) {
		_classCallCheck(this, Fill_class);

		var _this2 = _possibleConstructorReturn(this, (Fill_class.__proto__ || Object.getPrototypeOf(Fill_class)).call(this));

		_this2.Base_layers = new _baseLayers2.default();
		_this2.Helper = new _helpers2.default();
		_this2.ctx = ctx;
		_this2.name = 'fill';
		return _this2;
	}

	_createClass(Fill_class, [{
		key: 'load',
		value: function load() {
			var _this = this;

			//mouse events
			document.addEventListener('mousedown', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousedown(e);
			});
		}
	}, {
		key: 'mousedown',
		value: function mousedown(e) {
			var mouse = this.get_mouse_info(e);
			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}
			if (_config2.default.layer.rotate || 0 > 0) {
				_alertifyMin2.default.error('Erase on rotate object is disabled. Sorry.');
				return;
			}

			window.State.save();

			this.fill(mouse);
		}
	}, {
		key: 'fill',
		value: function fill(mouse) {
			var params = this.getParams();

			if (_config2.default.layer.type != 'image' && _config2.default.layer.type !== null) {
				_alertifyMin2.default.error('Layer must be image, convert it to raster to apply this tool.');
				return;
			}
			if (_config2.default.ALPHA == 0) {
				_alertifyMin2.default.error('Color alpha value can not be zero.');
				return;
			}

			//get canvas from layer
			var canvas = document.createElement('canvas');
			var ctx = canvas.getContext("2d");
			if (_config2.default.layer.type !== null) {
				canvas.width = _config2.default.layer.width_original;
				canvas.height = _config2.default.layer.height_original;
				ctx.drawImage(_config2.default.layer.link, 0, 0);
			} else {
				canvas.width = _config2.default.WIDTH;
				canvas.height = _config2.default.HEIGHT;
			}

			var mouse_x = Math.round(mouse.x) - _config2.default.layer.x;
			var mouse_y = Math.round(mouse.y) - _config2.default.layer.y;

			//adapt to origin size
			mouse_x = this.adaptSize(mouse_x, 'width');
			mouse_y = this.adaptSize(mouse_y, 'height');

			//convert float coords to integers
			mouse_x = Math.round(mouse_x);
			mouse_y = Math.round(mouse_y);

			var color_to = this.Helper.hex2rgb(_config2.default.COLOR);
			color_to.a = _config2.default.ALPHA;

			//change
			this.fill_general(ctx, _config2.default.WIDTH, _config2.default.HEIGHT, mouse_x, mouse_y, color_to, params.power, params.anti_aliasing, params.contiguous);

			if (_config2.default.layer.type != null) {
				//update
				this.Base_layers.update_layer_image(canvas);
			} else {
				//create new
				var params = [];
				params.type = 'image';
				params.name = 'Fill';
				params.data = canvas.toDataURL("image/png");
				params.x = parseInt(canvas.dataset.x) || 0;
				params.y = parseInt(canvas.dataset.y) || 0;
				params.width = canvas.width;
				params.height = canvas.height;
				this.Base_layers.insert(params);
			}
		}
	}, {
		key: 'fill_general',
		value: function fill_general(context, W, H, x, y, color_to, sensitivity, anti_aliasing) {
			var contiguous = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : false;

			sensitivity = sensitivity * 255 / 100; //convert to 0-255 interval
			x = parseInt(x);
			y = parseInt(y);
			var canvasTemp = document.createElement('canvas');
			canvasTemp.width = W;
			canvasTemp.height = H;
			var ctxTemp = canvasTemp.getContext("2d");

			ctxTemp.rect(0, 0, W, H);
			ctxTemp.fillStyle = "rgba(255, 255, 255, 0)";
			ctxTemp.fill();

			var img_tmp = ctxTemp.getImageData(0, 0, W, H);
			var imgData_tmp = img_tmp.data;

			var img = context.getImageData(0, 0, W, H);
			var imgData = img.data;
			var k = y * (img.width * 4) + x * 4;
			var dx = [0, -1, +1, 0];
			var dy = [-1, 0, 0, +1];
			var color_from = {
				r: imgData[k + 0],
				g: imgData[k + 1],
				b: imgData[k + 2],
				a: imgData[k + 3]
			};
			if (color_from.r == color_to.r && color_from.g == color_to.g && color_from.b == color_to.b && color_from.a == color_to.a) {
				return false;
			}

			if (contiguous == false) {
				//check only nearest pixels
				var stack = [];
				stack.push([x, y]);
				while (stack.length > 0) {
					var curPoint = stack.pop();
					for (var i = 0; i < 4; i++) {
						var nextPointX = curPoint[0] + dx[i];
						var nextPointY = curPoint[1] + dy[i];
						if (nextPointX < 0 || nextPointY < 0 || nextPointX >= W || nextPointY >= H) continue;
						var k = (nextPointY * W + nextPointX) * 4;
						if (imgData_tmp[k + 3] != 0) continue; //already parsed

						//check
						if (Math.abs(imgData[k + 0] - color_from.r) <= sensitivity && Math.abs(imgData[k + 1] - color_from.g) <= sensitivity && Math.abs(imgData[k + 2] - color_from.b) <= sensitivity && Math.abs(imgData[k + 3] - color_from.a) <= sensitivity) {

							//fill pixel
							imgData_tmp[k] = color_to.r; //r
							imgData_tmp[k + 1] = color_to.g; //g
							imgData_tmp[k + 2] = color_to.b; //b
							imgData_tmp[k + 3] = color_to.a; //a

							stack.push([nextPointX, nextPointY]);
						}
					}
				}
			} else {
				//global mode - contiguous
				for (var i = 0; i < imgData.length; i += 4) {
					if (imgData[i + 3] == 0) continue; //transparent

					//imgData[i] + 0.7152 * imgData[i + 1] + 0.0722 * imgData[i + 2]);

					for (var j = 0; j < 4; j++) {
						var k = i + j;

						if (Math.abs(imgData[k] - color_from.r) <= sensitivity && Math.abs(imgData[k + 1] - color_from.g) <= sensitivity && Math.abs(imgData[k + 2] - color_from.b) <= sensitivity && Math.abs(imgData[k + 3] - color_from.a) <= sensitivity) {
							imgData_tmp[k] = color_to.r; //r
							imgData_tmp[k + 1] = color_to.g; //g
							imgData_tmp[k + 2] = color_to.b; //b
							imgData_tmp[k + 3] = color_to.a; //a
						}
					}
				}
			}

			ctxTemp.putImageData(img_tmp, 0, 0);
			if (anti_aliasing == true) {
				context.shadowColor = "rgba(" + color_to.r + ", " + color_to.g + ", " + color_to.b + ", " + color_to.a / 255 + ")";
				context.shadowBlur = 5;
			}
			context.drawImage(canvasTemp, 0, 0);
		}
	}]);

	return Fill_class;
}(_baseTools2.default);

exports.default = Fill_class;

/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _helpers = __webpack_require__(4);

var _helpers2 = _interopRequireDefault(_helpers);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Gradient_class = function (_Base_tools_class) {
	_inherits(Gradient_class, _Base_tools_class);

	function Gradient_class(ctx) {
		_classCallCheck(this, Gradient_class);

		var _this2 = _possibleConstructorReturn(this, (Gradient_class.__proto__ || Object.getPrototypeOf(Gradient_class)).call(this));

		_this2.Base_layers = new _baseLayers2.default();
		_this2.Helper = new _helpers2.default();
		_this2.ctx = ctx;
		_this2.name = 'gradient';
		_this2.layer = {};
		return _this2;
	}

	_createClass(Gradient_class, [{
		key: 'load',
		value: function load() {
			var _this = this;

			//events
			document.addEventListener('mousedown', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousedown(e);
			});
			document.addEventListener('mousemove', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousemove(e);
			});
			document.addEventListener('mouseup', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mouseup(e);
			});
		}
	}, {
		key: 'mousedown',
		value: function mousedown(e) {
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();
			if (mouse.valid == false || mouse.click_valid == false) return;

			var name = this.name;
			if (params.radial == true) {
				name = 'Radial gradient';
			}

			window.State.save();

			//register new object - current layer is not ours or params changed
			this.layer = {
				type: this.name,
				name: this.Helper.ucfirst(name) + ' #' + this.Base_layers.auto_increment,
				params: this.clone(this.getParams()),
				status: 'draft',
				render_function: [this.name, 'render'],
				x: mouse.x,
				y: mouse.y,
				rotate: null,
				data: {
					center_x: mouse.x,
					center_y: mouse.y
				}
			};
			this.Base_layers.insert(this.layer);
		}
	}, {
		key: 'mousemove',
		value: function mousemove(e) {
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();
			if (mouse.is_drag == false) return;
			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}

			var width = mouse.x - this.layer.x;
			var height = mouse.y - this.layer.y;

			if (params.radial == true) {
				_config2.default.layer.x = this.layer.data.center_x - width;
				_config2.default.layer.y = this.layer.data.center_y - height;
				_config2.default.layer.width = width * 2;
				_config2.default.layer.height = height * 2;
			} else {
				_config2.default.layer.width = width;
				_config2.default.layer.height = height;
			}

			this.Base_layers.render();
		}
	}, {
		key: 'mouseup',
		value: function mouseup(e) {
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();
			if (mouse.valid == false || mouse.click_valid == false) {
				_config2.default.layer.status = null;
				return;
			}

			var width = mouse.x - this.layer.x;
			var height = mouse.y - this.layer.y;

			if (width == 0 && height == 0) {
				//same coordinates - cancel
				this.Base_layers.delete(_config2.default.layer.id);
				return;
			}

			if (params.radial == true) {
				_config2.default.layer.x = this.layer.data.center_x - width;
				_config2.default.layer.y = this.layer.data.center_y - height;
				_config2.default.layer.width = width * 2;
				_config2.default.layer.height = height * 2;
			} else {
				_config2.default.layer.width = width;
				_config2.default.layer.height = height;
			}
			_config2.default.layer.status = null;

			this.Base_layers.render();
		}
	}, {
		key: 'render',
		value: function render(ctx, layer) {
			if (layer.width == 0 && layer.height == 0) return;

			var params = layer.params;
			var power = params.radial_power;
			var alpha = params.alpha / 100 * 255;
			var color1 = params.color_1;
			var color2 = params.color_2;
			var radial = params.radial;

			var color2_rgb = this.Helper.hex2rgb(color2);

			var width = layer.x + layer.width - 1;
			var height = layer.y + layer.height - 1;

			if (radial == false) {
				//linear
				ctx.rect(0, 0, _config2.default.WIDTH, _config2.default.HEIGHT);
				var grd = ctx.createLinearGradient(layer.x, layer.y, width, height);

				grd.addColorStop(0, color1);
				grd.addColorStop(1, "rgba(" + color2_rgb.r + ", " + color2_rgb.g + ", " + color2_rgb.b + ", " + alpha / 255 + ")");
				ctx.fillStyle = grd;
				ctx.fill();
			} else {
				//radial
				var dist_x = layer.width;
				var dist_y = layer.height;
				var center_x = layer.x + Math.round(layer.width / 2);
				var center_y = layer.y + Math.round(layer.height / 2);
				var distance = Math.sqrt(dist_x * dist_x + dist_y * dist_y);
				var radgrad = ctx.createRadialGradient(center_x, center_y, distance * power / 100, center_x, center_y, distance);

				radgrad.addColorStop(0, color1);
				radgrad.addColorStop(1, "rgba(" + color2_rgb.r + ", " + color2_rgb.g + ", " + color2_rgb.b + ", " + alpha / 255 + ")");
				ctx.fillStyle = radgrad;
				ctx.fillRect(0, 0, _config2.default.WIDTH, _config2.default.HEIGHT);
			}
		}
	}]);

	return Gradient_class;
}(_baseTools2.default);

exports.default = Gradient_class;

/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Line_class = function (_Base_tools_class) {
	_inherits(Line_class, _Base_tools_class);

	function Line_class(ctx) {
		_classCallCheck(this, Line_class);

		var _this2 = _possibleConstructorReturn(this, (Line_class.__proto__ || Object.getPrototypeOf(Line_class)).call(this));

		_this2.Base_layers = new _baseLayers2.default();
		_this2.ctx = ctx;
		_this2.name = 'line';
		_this2.layer = {};
		return _this2;
	}

	_createClass(Line_class, [{
		key: 'load',
		value: function load() {
			var _this = this;

			//events
			document.addEventListener('mousedown', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousedown(e);
			});
			document.addEventListener('mousemove', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousemove(e);
			});
			document.addEventListener('mouseup', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mouseup(e);
			});
		}
	}, {
		key: 'mousedown',
		value: function mousedown(e) {
			var mouse = this.get_mouse_info(e);
			if (mouse.valid == false || mouse.click_valid == false) return;

			window.State.save();

			//register new object - current layer is not ours or params changed
			this.layer = {
				type: this.name,
				params: this.clone(this.getParams()),
				status: 'draft',
				render_function: [this.name, 'render'],
				x: mouse.x,
				y: mouse.y,
				rotate: null
			};
			this.Base_layers.insert(this.layer);
		}
	}, {
		key: 'mousemove',
		value: function mousemove(e) {
			var mouse = this.get_mouse_info(e);
			if (mouse.is_drag == false) return;
			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}

			var width = mouse.x - this.layer.x;
			var height = mouse.y - this.layer.y;
			if (e.ctrlKey == true || e.metaKey) {
				//one direction only
				if (Math.abs(width) < Math.abs(height)) width = 1;else height = 1;
			}

			//more data
			_config2.default.layer.width = width;
			_config2.default.layer.height = height;
			this.Base_layers.render();
		}
	}, {
		key: 'mouseup',
		value: function mouseup(e) {
			var mouse = this.get_mouse_info(e);
			if (mouse.valid == false || mouse.click_valid == false) {
				_config2.default.layer.status = null;
				return;
			}

			var width = mouse.x - this.layer.x;
			var height = mouse.y - this.layer.y;

			if (width == 0 && height == 0) {
				//same coordinates - cancel
				this.Base_layers.delete(_config2.default.layer.id);
				return;
			}

			if (e.ctrlKey == true || e.metaKey) {
				//one direction only
				if (Math.abs(width) < Math.abs(height)) width = 1;else height = 1;
			}

			//more data
			_config2.default.layer.width = width;
			_config2.default.layer.height = height;
			_config2.default.layer.status = null;
			this.Base_layers.render();
		}
	}, {
		key: 'render',
		value: function render(ctx, layer) {
			if (layer.width == 0 && layer.height == 0) return;

			var params = layer.params;
			var type = params.type.value;

			//set styles
			ctx.fillStyle = layer.color;
			ctx.strokeStyle = layer.color;
			ctx.lineWidth = params.size;
			ctx.lineCap = 'round';

			var width = layer.x + layer.width - 1;
			var height = layer.y + layer.height - 1;

			if (type == 'Simple') {
				//draw line
				ctx.beginPath();
				ctx.moveTo(layer.x + 0.5, layer.y + 0.5);
				ctx.lineTo(width + 0.5, height + 0.5);
				ctx.stroke();
			} else if (type == 'Arrow') {
				var headlen = params.size * 5;
				if (headlen < 15) headlen = 15;
				this.arrow(ctx, layer.x + 0.5, layer.y + 0.5, width + 0.5, height + 0.5, headlen);
			} else if (type == 'Curve') {
				//not supported
			}
		}
	}, {
		key: 'arrow',
		value: function arrow(ctx, fromx, fromy, tox, toy, headlen) {
			if (headlen == undefined) headlen = 10; // length of head in pixels
			var dx = tox - fromx;
			var dy = toy - fromy;
			var angle = Math.atan2(dy, dx);
			ctx.beginPath();
			ctx.moveTo(fromx, fromy);
			ctx.lineTo(tox, toy);
			ctx.stroke();
			ctx.beginPath();
			ctx.moveTo(tox - headlen * Math.cos(angle - Math.PI / 6), toy - headlen * Math.sin(angle - Math.PI / 6));
			ctx.lineTo(tox, toy);
			ctx.lineTo(tox - headlen * Math.cos(angle + Math.PI / 6), toy - headlen * Math.sin(angle + Math.PI / 6));
			ctx.stroke();
		}
	}]);

	return Line_class;
}(_baseTools2.default);

exports.default = Line_class;

/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Magic_wand_class = function (_Base_tools_class) {
	_inherits(Magic_wand_class, _Base_tools_class);

	function Magic_wand_class(ctx) {
		_classCallCheck(this, Magic_wand_class);

		var _this2 = _possibleConstructorReturn(this, (Magic_wand_class.__proto__ || Object.getPrototypeOf(Magic_wand_class)).call(this));

		_this2.Base_layers = new _baseLayers2.default();
		_this2.ctx = ctx;
		_this2.name = 'magic_wand';
		return _this2;
	}

	_createClass(Magic_wand_class, [{
		key: 'load',
		value: function load() {
			var _this = this;

			//mouse events
			document.addEventListener('mousedown', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousedown(e);
			});
		}
	}, {
		key: 'mousedown',
		value: function mousedown(e) {
			var mouse = this.get_mouse_info(e);
			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}
			if (_config2.default.layer.rotate || 0 > 0) {
				_alertifyMin2.default.error('Erase on rotate object is disabled. Sorry.');
				return;
			}

			window.State.save();

			this.magic_wand(mouse);
		}
	}, {
		key: 'magic_wand',
		value: function magic_wand(mouse) {
			var params = this.getParams();

			if (_config2.default.layer.type != 'image') {
				_alertifyMin2.default.error('Layer must be image, convert it to raster to apply this tool.');
				return;
			}

			//get canvas from layer
			var canvas = document.createElement('canvas');
			var ctx = canvas.getContext("2d");
			canvas.width = _config2.default.layer.width_original;
			canvas.height = _config2.default.layer.height_original;
			ctx.drawImage(_config2.default.layer.link, 0, 0);

			var mouse_x = Math.round(mouse.x) - _config2.default.layer.x;
			var mouse_y = Math.round(mouse.y) - _config2.default.layer.y;

			//adapt to origin size
			mouse_x = this.adaptSize(mouse_x, 'width');
			mouse_y = this.adaptSize(mouse_y, 'height');

			//convert float coords to integers
			mouse_x = Math.round(mouse_x);
			mouse_y = Math.round(mouse_y);

			//change
			this.magic_wand_general(ctx, _config2.default.WIDTH, _config2.default.HEIGHT, mouse_x, mouse_y, params.power, params.anti_aliasing, params.contiguous);

			this.Base_layers.update_layer_image(canvas);
		}

		/**
   * apply magic wand
   * 
   * @param {ctx} context
   * @param {int} W
   * @param {int} H
   * @param {int} x
   * @param {int} y
   * @param {int} sensitivity max 100
   * @param {Boolean} anti_aliasing
   */

	}, {
		key: 'magic_wand_general',
		value: function magic_wand_general(context, W, H, x, y, sensitivity, anti_aliasing) {
			var contiguous = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : false;

			sensitivity = sensitivity * 255 / 100; //convert to 0-255 interval
			x = parseInt(x);
			y = parseInt(y);
			var canvasTemp = document.createElement('canvas');
			canvasTemp.width = W;
			canvasTemp.height = H;
			var ctxTemp = canvasTemp.getContext("2d");

			ctxTemp.rect(0, 0, W, H);
			ctxTemp.fillStyle = "rgba(255, 255, 255, 0)";
			ctxTemp.fill();

			var img_tmp = ctxTemp.getImageData(0, 0, W, H);
			var imgData_tmp = img_tmp.data;

			var img = context.getImageData(0, 0, W, H);
			var imgData = img.data;
			var k = y * (img.width * 4) + x * 4;
			var dx = [0, -1, +1, 0];
			var dy = [-1, 0, 0, +1];
			var color_to = {
				r: 255,
				g: 255,
				b: 255,
				a: 255
			};
			var color_from = {
				r: imgData[k + 0],
				g: imgData[k + 1],
				b: imgData[k + 2],
				a: imgData[k + 3]
			};
			if (color_from.r == color_to.r && color_from.g == color_to.g && color_from.b == color_to.b && color_from.a == 0) {
				return false;
			}
			if (contiguous == false) {
				//check only nearest pixels
				var stack = [];
				stack.push([x, y]);
				while (stack.length > 0) {
					var curPoint = stack.pop();
					for (var i = 0; i < 4; i++) {
						var nextPointX = curPoint[0] + dx[i];
						var nextPointY = curPoint[1] + dy[i];
						if (nextPointX < 0 || nextPointY < 0 || nextPointX >= W || nextPointY >= H) continue;
						var k = (nextPointY * W + nextPointX) * 4;
						if (imgData_tmp[k + 3] != 0) continue; //already parsed

						if (Math.abs(imgData[k] - color_from.r) <= sensitivity && Math.abs(imgData[k + 1] - color_from.g) <= sensitivity && Math.abs(imgData[k + 2] - color_from.b) <= sensitivity && Math.abs(imgData[k + 3] - color_from.a) <= sensitivity) {
							imgData_tmp[k] = color_to.r; //r
							imgData_tmp[k + 1] = color_to.g; //g
							imgData_tmp[k + 2] = color_to.b; //b
							imgData_tmp[k + 3] = color_to.a; //a

							stack.push([nextPointX, nextPointY]);
						}
					}
				}
			} else {
				//global mode - contiguous
				for (var i = 0; i < imgData.length; i += 4) {
					if (imgData[i + 3] == 0) continue; //transparent

					//imgData[i] + 0.7152 * imgData[i + 1] + 0.0722 * imgData[i + 2]);

					for (var j = 0; j < 4; j++) {
						var k = i + j;

						if (Math.abs(imgData[k] - color_from.r) <= sensitivity && Math.abs(imgData[k + 1] - color_from.g) <= sensitivity && Math.abs(imgData[k + 2] - color_from.b) <= sensitivity && Math.abs(imgData[k + 3] - color_from.a) <= sensitivity) {
							imgData_tmp[k] = color_to.r; //r
							imgData_tmp[k + 1] = color_to.g; //g
							imgData_tmp[k + 2] = color_to.b; //b
							imgData_tmp[k + 3] = color_to.a; //a
						}
					}
				}
			}

			//destination-out + blur = anti-aliasing
			ctxTemp.putImageData(img_tmp, 0, 0);
			context.globalCompositeOperation = "destination-out";
			if (anti_aliasing == true) {
				context.filter = 'blur(2px)';
			}
			context.drawImage(canvasTemp, 0, 0);
		}
	}]);

	return Magic_wand_class;
}(_baseTools2.default);

exports.default = Magic_wand_class;

/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _search = __webpack_require__(21);

var _search2 = _interopRequireDefault(_search);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Media_class = function (_Base_tools_class) {
	_inherits(Media_class, _Base_tools_class);

	function Media_class(ctx) {
		_classCallCheck(this, Media_class);

		var _this = _possibleConstructorReturn(this, (Media_class.__proto__ || Object.getPrototypeOf(Media_class)).call(this));

		_this.Seach = new _search2.default();
		_this.name = 'media';
		return _this;
	}

	_createClass(Media_class, [{
		key: 'load',
		value: function load() {
			//nothing
		}
	}, {
		key: 'render',
		value: function render(ctx, layer) {
			//nothing
		}
	}, {
		key: 'on_activate',
		value: function on_activate() {
			this.Seach.search();
		}
	}]);

	return Media_class;
}(_baseTools2.default);

;
exports.default = Media_class;

/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * image pasting into canvas
 * 
 * @param {string} canvas_id - canvas id
 * @param {boolean} autoresize - if canvas will be resized
 */
var Clipboard_class = function () {
	function Clipboard_class(on_paste) {
		_classCallCheck(this, Clipboard_class);

		var _self = this;

		this.on_paste = on_paste;
		this.ctrl_pressed = false;
		this.command_pressed = false;
		this.pasteCatcher;
		this.paste_mode;

		//handlers
		document.addEventListener('keydown', function (e) {
			_self.on_keyboard_action(e);
		}, false); //firefox fix
		document.addEventListener('keyup', function (e) {
			_self.on_keyboardup_action(e);
		}, false); //firefox fix
		document.addEventListener('paste', function (e) {
			_self.paste_auto(e);
		}, false); //official paste handler

		this.init();
	}

	//constructor - prepare


	_createClass(Clipboard_class, [{
		key: 'init',
		value: function init() {
			var _self = this;

			//if using auto
			if (window.Clipboard) return true;

			this.pasteCatcher = document.createElement("div");
			this.pasteCatcher.setAttribute("id", "paste_ff");
			this.pasteCatcher.setAttribute("contenteditable", "");
			this.pasteCatcher.style.cssText = 'opacity:0;position:fixed;top:0px;left:0px;';
			this.pasteCatcher.style.marginLeft = "-20px";
			this.pasteCatcher.style.width = "10px";
			document.body.appendChild(this.pasteCatcher);

			// create an observer instance
			var observer = new MutationObserver(function (mutations) {
				mutations.forEach(function (mutation) {
					if (this.paste_mode == 'auto' || this.ctrl_pressed == false || mutation.type != 'childList') return true;

					//if paste handle failed - capture pasted object manually
					if (mutation.addedNodes.length == 1) {
						if (mutation.addedNodes[0].src != undefined) {
							//image
							_self.paste_createImage(mutation.addedNodes[0].src);
						}
						//register cleanup after some time.
						setTimeout(function () {
							this.pasteCatcher.innerHTML = '';
						}, 20);
					}
				});
			});
			var target = document.getElementById('paste_ff');
			var config = { attributes: true, childList: true, characterData: true };
			observer.observe(target, config);
		}
	}, {
		key: 'paste_auto',

		//default paste action
		value: function paste_auto(e) {
			if (e.target.type == 'text') return;
			if (e.target.tagName.toUpperCase() == 'INPUT') return;
			if (e.target.tagName.toUpperCase() == 'TEXTAREA') return;

			this.paste_mode = '';
			if (!window.Clipboard) {
				this.pasteCatcher.innerHTML = '';
			}
			if (e.clipboardData) {
				var items = e.clipboardData.items;
				if (items) {
					this.paste_mode = 'auto';
					//access data directly
					for (var i = 0; i < items.length; i++) {
						if (items[i].type.indexOf("image") !== -1) {
							//image
							var blob = items[i].getAsFile();
							var URLObj = window.URL || window.webkitURL;
							var source = URLObj.createObjectURL(blob);
							this.paste_createImage(source);
						}
					}
					e.preventDefault();
				} else {
					//wait for DOMSubtreeModified event
					//https://bugzilla.mozilla.org/show_bug.cgi?id=891247
				}
			}
		}

		//on keyboard press

	}, {
		key: 'on_keyboard_action',
		value: function on_keyboard_action(event) {
			var k = event.keyCode;
			//ctrl
			if (k == 17 || event.metaKey || event.ctrlKey) {
				if (this.ctrl_pressed == false) this.ctrl_pressed = true;
			}
			//v
			if (k == 86) {
				if (document.activeElement != undefined && document.activeElement.type == 'text') {
					//let user paste into some input
					return false;
				}

				if (this.ctrl_pressed == true && !window.Clipboard) this.pasteCatcher.focus();
			}
		}

		//on kaybord release

	}, {
		key: 'on_keyboardup_action',
		value: function on_keyboardup_action(event) {
			//ctrl
			if (event.ctrlKey == false && this.ctrl_pressed == true) {
				this.ctrl_pressed = false;
			}
			//command
			else if (event.metaKey == false && this.command_pressed == true) {
					this.command_pressed = false;
					this.ctrl_pressed = false;
				}
		}

		//draw image

	}, {
		key: 'paste_createImage',
		value: function paste_createImage(source) {
			var pastedImage = new Image();
			var _this = this;

			pastedImage.onload = function () {
				_this.on_paste(source, pastedImage.width, pastedImage.height);
			};
			pastedImage.src = source;
		}
	}]);

	return Clipboard_class;
}();

exports.default = Clipboard_class;

/***/ }),
/* 72 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function() {

    var debug = false;

    var root = this;

    var EXIF = function(obj) {
        if (obj instanceof EXIF) return obj;
        if (!(this instanceof EXIF)) return new EXIF(obj);
        this.EXIFwrapped = obj;
    };

    if (true) {
        if (typeof module !== 'undefined' && module.exports) {
            exports = module.exports = EXIF;
        }
        exports.EXIF = EXIF;
    } else {
        root.EXIF = EXIF;
    }

    var ExifTags = EXIF.Tags = {

        // version tags
        0x9000 : "ExifVersion",             // EXIF version
        0xA000 : "FlashpixVersion",         // Flashpix format version

        // colorspace tags
        0xA001 : "ColorSpace",              // Color space information tag

        // image configuration
        0xA002 : "PixelXDimension",         // Valid width of meaningful image
        0xA003 : "PixelYDimension",         // Valid height of meaningful image
        0x9101 : "ComponentsConfiguration", // Information about channels
        0x9102 : "CompressedBitsPerPixel",  // Compressed bits per pixel

        // user information
        0x927C : "MakerNote",               // Any desired information written by the manufacturer
        0x9286 : "UserComment",             // Comments by user

        // related file
        0xA004 : "RelatedSoundFile",        // Name of related sound file

        // date and time
        0x9003 : "DateTimeOriginal",        // Date and time when the original image was generated
        0x9004 : "DateTimeDigitized",       // Date and time when the image was stored digitally
        0x9290 : "SubsecTime",              // Fractions of seconds for DateTime
        0x9291 : "SubsecTimeOriginal",      // Fractions of seconds for DateTimeOriginal
        0x9292 : "SubsecTimeDigitized",     // Fractions of seconds for DateTimeDigitized

        // picture-taking conditions
        0x829A : "ExposureTime",            // Exposure time (in seconds)
        0x829D : "FNumber",                 // F number
        0x8822 : "ExposureProgram",         // Exposure program
        0x8824 : "SpectralSensitivity",     // Spectral sensitivity
        0x8827 : "ISOSpeedRatings",         // ISO speed rating
        0x8828 : "OECF",                    // Optoelectric conversion factor
        0x9201 : "ShutterSpeedValue",       // Shutter speed
        0x9202 : "ApertureValue",           // Lens aperture
        0x9203 : "BrightnessValue",         // Value of brightness
        0x9204 : "ExposureBias",            // Exposure bias
        0x9205 : "MaxApertureValue",        // Smallest F number of lens
        0x9206 : "SubjectDistance",         // Distance to subject in meters
        0x9207 : "MeteringMode",            // Metering mode
        0x9208 : "LightSource",             // Kind of light source
        0x9209 : "Flash",                   // Flash status
        0x9214 : "SubjectArea",             // Location and area of main subject
        0x920A : "FocalLength",             // Focal length of the lens in mm
        0xA20B : "FlashEnergy",             // Strobe energy in BCPS
        0xA20C : "SpatialFrequencyResponse",    //
        0xA20E : "FocalPlaneXResolution",   // Number of pixels in width direction per FocalPlaneResolutionUnit
        0xA20F : "FocalPlaneYResolution",   // Number of pixels in height direction per FocalPlaneResolutionUnit
        0xA210 : "FocalPlaneResolutionUnit",    // Unit for measuring FocalPlaneXResolution and FocalPlaneYResolution
        0xA214 : "SubjectLocation",         // Location of subject in image
        0xA215 : "ExposureIndex",           // Exposure index selected on camera
        0xA217 : "SensingMethod",           // Image sensor type
        0xA300 : "FileSource",              // Image source (3 == DSC)
        0xA301 : "SceneType",               // Scene type (1 == directly photographed)
        0xA302 : "CFAPattern",              // Color filter array geometric pattern
        0xA401 : "CustomRendered",          // Special processing
        0xA402 : "ExposureMode",            // Exposure mode
        0xA403 : "WhiteBalance",            // 1 = auto white balance, 2 = manual
        0xA404 : "DigitalZoomRation",       // Digital zoom ratio
        0xA405 : "FocalLengthIn35mmFilm",   // Equivalent foacl length assuming 35mm film camera (in mm)
        0xA406 : "SceneCaptureType",        // Type of scene
        0xA407 : "GainControl",             // Degree of overall image gain adjustment
        0xA408 : "Contrast",                // Direction of contrast processing applied by camera
        0xA409 : "Saturation",              // Direction of saturation processing applied by camera
        0xA40A : "Sharpness",               // Direction of sharpness processing applied by camera
        0xA40B : "DeviceSettingDescription",    //
        0xA40C : "SubjectDistanceRange",    // Distance to subject

        // other tags
        0xA005 : "InteroperabilityIFDPointer",
        0xA420 : "ImageUniqueID"            // Identifier assigned uniquely to each image
    };

    var TiffTags = EXIF.TiffTags = {
        0x0100 : "ImageWidth",
        0x0101 : "ImageHeight",
        0x8769 : "ExifIFDPointer",
        0x8825 : "GPSInfoIFDPointer",
        0xA005 : "InteroperabilityIFDPointer",
        0x0102 : "BitsPerSample",
        0x0103 : "Compression",
        0x0106 : "PhotometricInterpretation",
        0x0112 : "Orientation",
        0x0115 : "SamplesPerPixel",
        0x011C : "PlanarConfiguration",
        0x0212 : "YCbCrSubSampling",
        0x0213 : "YCbCrPositioning",
        0x011A : "XResolution",
        0x011B : "YResolution",
        0x0128 : "ResolutionUnit",
        0x0111 : "StripOffsets",
        0x0116 : "RowsPerStrip",
        0x0117 : "StripByteCounts",
        0x0201 : "JPEGInterchangeFormat",
        0x0202 : "JPEGInterchangeFormatLength",
        0x012D : "TransferFunction",
        0x013E : "WhitePoint",
        0x013F : "PrimaryChromaticities",
        0x0211 : "YCbCrCoefficients",
        0x0214 : "ReferenceBlackWhite",
        0x0132 : "DateTime",
        0x010E : "ImageDescription",
        0x010F : "Make",
        0x0110 : "Model",
        0x0131 : "Software",
        0x013B : "Artist",
        0x8298 : "Copyright"
    };

    var GPSTags = EXIF.GPSTags = {
        0x0000 : "GPSVersionID",
        0x0001 : "GPSLatitudeRef",
        0x0002 : "GPSLatitude",
        0x0003 : "GPSLongitudeRef",
        0x0004 : "GPSLongitude",
        0x0005 : "GPSAltitudeRef",
        0x0006 : "GPSAltitude",
        0x0007 : "GPSTimeStamp",
        0x0008 : "GPSSatellites",
        0x0009 : "GPSStatus",
        0x000A : "GPSMeasureMode",
        0x000B : "GPSDOP",
        0x000C : "GPSSpeedRef",
        0x000D : "GPSSpeed",
        0x000E : "GPSTrackRef",
        0x000F : "GPSTrack",
        0x0010 : "GPSImgDirectionRef",
        0x0011 : "GPSImgDirection",
        0x0012 : "GPSMapDatum",
        0x0013 : "GPSDestLatitudeRef",
        0x0014 : "GPSDestLatitude",
        0x0015 : "GPSDestLongitudeRef",
        0x0016 : "GPSDestLongitude",
        0x0017 : "GPSDestBearingRef",
        0x0018 : "GPSDestBearing",
        0x0019 : "GPSDestDistanceRef",
        0x001A : "GPSDestDistance",
        0x001B : "GPSProcessingMethod",
        0x001C : "GPSAreaInformation",
        0x001D : "GPSDateStamp",
        0x001E : "GPSDifferential"
    };

     // EXIF 2.3 Spec
    var IFD1Tags = EXIF.IFD1Tags = {
        0x0100: "ImageWidth",
        0x0101: "ImageHeight",
        0x0102: "BitsPerSample",
        0x0103: "Compression",
        0x0106: "PhotometricInterpretation",
        0x0111: "StripOffsets",
        0x0112: "Orientation",
        0x0115: "SamplesPerPixel",
        0x0116: "RowsPerStrip",
        0x0117: "StripByteCounts",
        0x011A: "XResolution",
        0x011B: "YResolution",
        0x011C: "PlanarConfiguration",
        0x0128: "ResolutionUnit",
        0x0201: "JpegIFOffset",    // When image format is JPEG, this value show offset to JPEG data stored.(aka "ThumbnailOffset" or "JPEGInterchangeFormat")
        0x0202: "JpegIFByteCount", // When image format is JPEG, this value shows data size of JPEG image (aka "ThumbnailLength" or "JPEGInterchangeFormatLength")
        0x0211: "YCbCrCoefficients",
        0x0212: "YCbCrSubSampling",
        0x0213: "YCbCrPositioning",
        0x0214: "ReferenceBlackWhite"
    };

    var StringValues = EXIF.StringValues = {
        ExposureProgram : {
            0 : "Not defined",
            1 : "Manual",
            2 : "Normal program",
            3 : "Aperture priority",
            4 : "Shutter priority",
            5 : "Creative program",
            6 : "Action program",
            7 : "Portrait mode",
            8 : "Landscape mode"
        },
        MeteringMode : {
            0 : "Unknown",
            1 : "Average",
            2 : "CenterWeightedAverage",
            3 : "Spot",
            4 : "MultiSpot",
            5 : "Pattern",
            6 : "Partial",
            255 : "Other"
        },
        LightSource : {
            0 : "Unknown",
            1 : "Daylight",
            2 : "Fluorescent",
            3 : "Tungsten (incandescent light)",
            4 : "Flash",
            9 : "Fine weather",
            10 : "Cloudy weather",
            11 : "Shade",
            12 : "Daylight fluorescent (D 5700 - 7100K)",
            13 : "Day white fluorescent (N 4600 - 5400K)",
            14 : "Cool white fluorescent (W 3900 - 4500K)",
            15 : "White fluorescent (WW 3200 - 3700K)",
            17 : "Standard light A",
            18 : "Standard light B",
            19 : "Standard light C",
            20 : "D55",
            21 : "D65",
            22 : "D75",
            23 : "D50",
            24 : "ISO studio tungsten",
            255 : "Other"
        },
        Flash : {
            0x0000 : "Flash did not fire",
            0x0001 : "Flash fired",
            0x0005 : "Strobe return light not detected",
            0x0007 : "Strobe return light detected",
            0x0009 : "Flash fired, compulsory flash mode",
            0x000D : "Flash fired, compulsory flash mode, return light not detected",
            0x000F : "Flash fired, compulsory flash mode, return light detected",
            0x0010 : "Flash did not fire, compulsory flash mode",
            0x0018 : "Flash did not fire, auto mode",
            0x0019 : "Flash fired, auto mode",
            0x001D : "Flash fired, auto mode, return light not detected",
            0x001F : "Flash fired, auto mode, return light detected",
            0x0020 : "No flash function",
            0x0041 : "Flash fired, red-eye reduction mode",
            0x0045 : "Flash fired, red-eye reduction mode, return light not detected",
            0x0047 : "Flash fired, red-eye reduction mode, return light detected",
            0x0049 : "Flash fired, compulsory flash mode, red-eye reduction mode",
            0x004D : "Flash fired, compulsory flash mode, red-eye reduction mode, return light not detected",
            0x004F : "Flash fired, compulsory flash mode, red-eye reduction mode, return light detected",
            0x0059 : "Flash fired, auto mode, red-eye reduction mode",
            0x005D : "Flash fired, auto mode, return light not detected, red-eye reduction mode",
            0x005F : "Flash fired, auto mode, return light detected, red-eye reduction mode"
        },
        SensingMethod : {
            1 : "Not defined",
            2 : "One-chip color area sensor",
            3 : "Two-chip color area sensor",
            4 : "Three-chip color area sensor",
            5 : "Color sequential area sensor",
            7 : "Trilinear sensor",
            8 : "Color sequential linear sensor"
        },
        SceneCaptureType : {
            0 : "Standard",
            1 : "Landscape",
            2 : "Portrait",
            3 : "Night scene"
        },
        SceneType : {
            1 : "Directly photographed"
        },
        CustomRendered : {
            0 : "Normal process",
            1 : "Custom process"
        },
        WhiteBalance : {
            0 : "Auto white balance",
            1 : "Manual white balance"
        },
        GainControl : {
            0 : "None",
            1 : "Low gain up",
            2 : "High gain up",
            3 : "Low gain down",
            4 : "High gain down"
        },
        Contrast : {
            0 : "Normal",
            1 : "Soft",
            2 : "Hard"
        },
        Saturation : {
            0 : "Normal",
            1 : "Low saturation",
            2 : "High saturation"
        },
        Sharpness : {
            0 : "Normal",
            1 : "Soft",
            2 : "Hard"
        },
        SubjectDistanceRange : {
            0 : "Unknown",
            1 : "Macro",
            2 : "Close view",
            3 : "Distant view"
        },
        FileSource : {
            3 : "DSC"
        },

        Components : {
            0 : "",
            1 : "Y",
            2 : "Cb",
            3 : "Cr",
            4 : "R",
            5 : "G",
            6 : "B"
        }
    };

    function addEvent(element, event, handler) {
        if (element.addEventListener) {
            element.addEventListener(event, handler, false);
        } else if (element.attachEvent) {
            element.attachEvent("on" + event, handler);
        }
    }

    function imageHasData(img) {
        return !!(img.exifdata);
    }


    function base64ToArrayBuffer(base64, contentType) {
        contentType = contentType || base64.match(/^data\:([^\;]+)\;base64,/mi)[1] || ''; // e.g. 'data:image/jpeg;base64,...' => 'image/jpeg'
        base64 = base64.replace(/^data\:([^\;]+)\;base64,/gmi, '');
        var binary = atob(base64);
        var len = binary.length;
        var buffer = new ArrayBuffer(len);
        var view = new Uint8Array(buffer);
        for (var i = 0; i < len; i++) {
            view[i] = binary.charCodeAt(i);
        }
        return buffer;
    }

    function objectURLToBlob(url, callback) {
        var http = new XMLHttpRequest();
        http.open("GET", url, true);
        http.responseType = "blob";
        http.onload = function(e) {
            if (this.status == 200 || this.status === 0) {
                callback(this.response);
            }
        };
        http.send();
    }

    function getImageData(img, callback) {
        function handleBinaryFile(binFile) {
            var data = findEXIFinJPEG(binFile);
            img.exifdata = data || {};
            var iptcdata = findIPTCinJPEG(binFile);
            img.iptcdata = iptcdata || {};
            if (EXIF.isXmpEnabled) {
               var xmpdata= findXMPinJPEG(binFile);
               img.xmpdata = xmpdata || {};               
            }
            if (callback) {
                callback.call(img);
            }
        }

        if (img.src) {
            if (/^data\:/i.test(img.src)) { // Data URI
                var arrayBuffer = base64ToArrayBuffer(img.src);
                handleBinaryFile(arrayBuffer);

            } else if (/^blob\:/i.test(img.src)) { // Object URL
                var fileReader = new FileReader();
                fileReader.onload = function(e) {
                    handleBinaryFile(e.target.result);
                };
                objectURLToBlob(img.src, function (blob) {
                    fileReader.readAsArrayBuffer(blob);
                });
            } else {
                var http = new XMLHttpRequest();
                http.onload = function() {
                    if (this.status == 200 || this.status === 0) {
                        handleBinaryFile(http.response);
                    } else {
                        throw "Could not load image";
                    }
                    http = null;
                };
                http.open("GET", img.src, true);
                http.responseType = "arraybuffer";
                http.send(null);
            }
        } else if (self.FileReader && (img instanceof self.Blob || img instanceof self.File)) {
            var fileReader = new FileReader();
            fileReader.onload = function(e) {
                if (debug) console.log("Got file of length " + e.target.result.byteLength);
                handleBinaryFile(e.target.result);
            };

            fileReader.readAsArrayBuffer(img);
        }
    }

    function findEXIFinJPEG(file) {
        var dataView = new DataView(file);

        if (debug) console.log("Got file of length " + file.byteLength);
        if ((dataView.getUint8(0) != 0xFF) || (dataView.getUint8(1) != 0xD8)) {
            if (debug) console.log("Not a valid JPEG");
            return false; // not a valid jpeg
        }

        var offset = 2,
            length = file.byteLength,
            marker;

        while (offset < length) {
            if (dataView.getUint8(offset) != 0xFF) {
                if (debug) console.log("Not a valid marker at offset " + offset + ", found: " + dataView.getUint8(offset));
                return false; // not a valid marker, something is wrong
            }

            marker = dataView.getUint8(offset + 1);
            if (debug) console.log(marker);

            // we could implement handling for other markers here,
            // but we're only looking for 0xFFE1 for EXIF data

            if (marker == 225) {
                if (debug) console.log("Found 0xFFE1 marker");

                return readEXIFData(dataView, offset + 4, dataView.getUint16(offset + 2) - 2);

                // offset += 2 + file.getShortAt(offset+2, true);

            } else {
                offset += 2 + dataView.getUint16(offset+2);
            }

        }

    }

    function findIPTCinJPEG(file) {
        var dataView = new DataView(file);

        if (debug) console.log("Got file of length " + file.byteLength);
        if ((dataView.getUint8(0) != 0xFF) || (dataView.getUint8(1) != 0xD8)) {
            if (debug) console.log("Not a valid JPEG");
            return false; // not a valid jpeg
        }

        var offset = 2,
            length = file.byteLength;


        var isFieldSegmentStart = function(dataView, offset){
            return (
                dataView.getUint8(offset) === 0x38 &&
                dataView.getUint8(offset+1) === 0x42 &&
                dataView.getUint8(offset+2) === 0x49 &&
                dataView.getUint8(offset+3) === 0x4D &&
                dataView.getUint8(offset+4) === 0x04 &&
                dataView.getUint8(offset+5) === 0x04
            );
        };

        while (offset < length) {

            if ( isFieldSegmentStart(dataView, offset )){

                // Get the length of the name header (which is padded to an even number of bytes)
                var nameHeaderLength = dataView.getUint8(offset+7);
                if(nameHeaderLength % 2 !== 0) nameHeaderLength += 1;
                // Check for pre photoshop 6 format
                if(nameHeaderLength === 0) {
                    // Always 4
                    nameHeaderLength = 4;
                }

                var startOffset = offset + 8 + nameHeaderLength;
                var sectionLength = dataView.getUint16(offset + 6 + nameHeaderLength);

                return readIPTCData(file, startOffset, sectionLength);

                break;

            }


            // Not the marker, continue searching
            offset++;

        }

    }
    var IptcFieldMap = {
        0x78 : 'caption',
        0x6E : 'credit',
        0x19 : 'keywords',
        0x37 : 'dateCreated',
        0x50 : 'byline',
        0x55 : 'bylineTitle',
        0x7A : 'captionWriter',
        0x69 : 'headline',
        0x74 : 'copyright',
        0x0F : 'category'
    };
    function readIPTCData(file, startOffset, sectionLength){
        var dataView = new DataView(file);
        var data = {};
        var fieldValue, fieldName, dataSize, segmentType, segmentSize;
        var segmentStartPos = startOffset;
        while(segmentStartPos < startOffset+sectionLength) {
            if(dataView.getUint8(segmentStartPos) === 0x1C && dataView.getUint8(segmentStartPos+1) === 0x02){
                segmentType = dataView.getUint8(segmentStartPos+2);
                if(segmentType in IptcFieldMap) {
                    dataSize = dataView.getInt16(segmentStartPos+3);
                    segmentSize = dataSize + 5;
                    fieldName = IptcFieldMap[segmentType];
                    fieldValue = getStringFromDB(dataView, segmentStartPos+5, dataSize);
                    // Check if we already stored a value with this name
                    if(data.hasOwnProperty(fieldName)) {
                        // Value already stored with this name, create multivalue field
                        if(data[fieldName] instanceof Array) {
                            data[fieldName].push(fieldValue);
                        }
                        else {
                            data[fieldName] = [data[fieldName], fieldValue];
                        }
                    }
                    else {
                        data[fieldName] = fieldValue;
                    }
                }

            }
            segmentStartPos++;
        }
        return data;
    }



    function readTags(file, tiffStart, dirStart, strings, bigEnd) {
        var entries = file.getUint16(dirStart, !bigEnd),
            tags = {},
            entryOffset, tag,
            i;

        for (i=0;i<entries;i++) {
            entryOffset = dirStart + i*12 + 2;
            tag = strings[file.getUint16(entryOffset, !bigEnd)];
            if (!tag && debug) console.log("Unknown tag: " + file.getUint16(entryOffset, !bigEnd));
            tags[tag] = readTagValue(file, entryOffset, tiffStart, dirStart, bigEnd);
        }
        return tags;
    }


    function readTagValue(file, entryOffset, tiffStart, dirStart, bigEnd) {
        var type = file.getUint16(entryOffset+2, !bigEnd),
            numValues = file.getUint32(entryOffset+4, !bigEnd),
            valueOffset = file.getUint32(entryOffset+8, !bigEnd) + tiffStart,
            offset,
            vals, val, n,
            numerator, denominator;

        switch (type) {
            case 1: // byte, 8-bit unsigned int
            case 7: // undefined, 8-bit byte, value depending on field
                if (numValues == 1) {
                    return file.getUint8(entryOffset + 8, !bigEnd);
                } else {
                    offset = numValues > 4 ? valueOffset : (entryOffset + 8);
                    vals = [];
                    for (n=0;n<numValues;n++) {
                        vals[n] = file.getUint8(offset + n);
                    }
                    return vals;
                }

            case 2: // ascii, 8-bit byte
                offset = numValues > 4 ? valueOffset : (entryOffset + 8);
                return getStringFromDB(file, offset, numValues-1);

            case 3: // short, 16 bit int
                if (numValues == 1) {
                    return file.getUint16(entryOffset + 8, !bigEnd);
                } else {
                    offset = numValues > 2 ? valueOffset : (entryOffset + 8);
                    vals = [];
                    for (n=0;n<numValues;n++) {
                        vals[n] = file.getUint16(offset + 2*n, !bigEnd);
                    }
                    return vals;
                }

            case 4: // long, 32 bit int
                if (numValues == 1) {
                    return file.getUint32(entryOffset + 8, !bigEnd);
                } else {
                    vals = [];
                    for (n=0;n<numValues;n++) {
                        vals[n] = file.getUint32(valueOffset + 4*n, !bigEnd);
                    }
                    return vals;
                }

            case 5:    // rational = two long values, first is numerator, second is denominator
                if (numValues == 1) {
                    numerator = file.getUint32(valueOffset, !bigEnd);
                    denominator = file.getUint32(valueOffset+4, !bigEnd);
                    val = new Number(numerator / denominator);
                    val.numerator = numerator;
                    val.denominator = denominator;
                    return val;
                } else {
                    vals = [];
                    for (n=0;n<numValues;n++) {
                        numerator = file.getUint32(valueOffset + 8*n, !bigEnd);
                        denominator = file.getUint32(valueOffset+4 + 8*n, !bigEnd);
                        vals[n] = new Number(numerator / denominator);
                        vals[n].numerator = numerator;
                        vals[n].denominator = denominator;
                    }
                    return vals;
                }

            case 9: // slong, 32 bit signed int
                if (numValues == 1) {
                    return file.getInt32(entryOffset + 8, !bigEnd);
                } else {
                    vals = [];
                    for (n=0;n<numValues;n++) {
                        vals[n] = file.getInt32(valueOffset + 4*n, !bigEnd);
                    }
                    return vals;
                }

            case 10: // signed rational, two slongs, first is numerator, second is denominator
                if (numValues == 1) {
                    return file.getInt32(valueOffset, !bigEnd) / file.getInt32(valueOffset+4, !bigEnd);
                } else {
                    vals = [];
                    for (n=0;n<numValues;n++) {
                        vals[n] = file.getInt32(valueOffset + 8*n, !bigEnd) / file.getInt32(valueOffset+4 + 8*n, !bigEnd);
                    }
                    return vals;
                }
        }
    }

    /**
    * Given an IFD (Image File Directory) start offset
    * returns an offset to next IFD or 0 if it's the last IFD.
    */
    function getNextIFDOffset(dataView, dirStart, bigEnd){
        //the first 2bytes means the number of directory entries contains in this IFD
        var entries = dataView.getUint16(dirStart, !bigEnd);

        // After last directory entry, there is a 4bytes of data,
        // it means an offset to next IFD.
        // If its value is '0x00000000', it means this is the last IFD and there is no linked IFD.

        return dataView.getUint32(dirStart + 2 + entries * 12, !bigEnd); // each entry is 12 bytes long
    }

    function readThumbnailImage(dataView, tiffStart, firstIFDOffset, bigEnd){
        // get the IFD1 offset
        var IFD1OffsetPointer = getNextIFDOffset(dataView, tiffStart+firstIFDOffset, bigEnd);

        if (!IFD1OffsetPointer) {
            // console.log('******** IFD1Offset is empty, image thumb not found ********');
            return {};
        }
        else if (IFD1OffsetPointer > dataView.byteLength) { // this should not happen
            // console.log('******** IFD1Offset is outside the bounds of the DataView ********');
            return {};
        }
        // console.log('*******  thumbnail IFD offset (IFD1) is: %s', IFD1OffsetPointer);

        var thumbTags = readTags(dataView, tiffStart, tiffStart + IFD1OffsetPointer, IFD1Tags, bigEnd)

        // EXIF 2.3 specification for JPEG format thumbnail

        // If the value of Compression(0x0103) Tag in IFD1 is '6', thumbnail image format is JPEG.
        // Most of Exif image uses JPEG format for thumbnail. In that case, you can get offset of thumbnail
        // by JpegIFOffset(0x0201) Tag in IFD1, size of thumbnail by JpegIFByteCount(0x0202) Tag.
        // Data format is ordinary JPEG format, starts from 0xFFD8 and ends by 0xFFD9. It seems that
        // JPEG format and 160x120pixels of size are recommended thumbnail format for Exif2.1 or later.

        if (thumbTags['Compression']) {
            // console.log('Thumbnail image found!');

            switch (thumbTags['Compression']) {
                case 6:
                    // console.log('Thumbnail image format is JPEG');
                    if (thumbTags.JpegIFOffset && thumbTags.JpegIFByteCount) {
                    // extract the thumbnail
                        var tOffset = tiffStart + thumbTags.JpegIFOffset;
                        var tLength = thumbTags.JpegIFByteCount;
                        thumbTags['blob'] = new Blob([new Uint8Array(dataView.buffer, tOffset, tLength)], {
                            type: 'image/jpeg'
                        });
                    }
                break;

            case 1:
                console.log("Thumbnail image format is TIFF, which is not implemented.");
                break;
            default:
                console.log("Unknown thumbnail image format '%s'", thumbTags['Compression']);
            }
        }
        else if (thumbTags['PhotometricInterpretation'] == 2) {
            console.log("Thumbnail image format is RGB, which is not implemented.");
        }
        return thumbTags;
    }

    function getStringFromDB(buffer, start, length) {
        var outstr = "";
        for (n = start; n < start+length; n++) {
            outstr += String.fromCharCode(buffer.getUint8(n));
        }
        return outstr;
    }

    function readEXIFData(file, start) {
        if (getStringFromDB(file, start, 4) != "Exif") {
            if (debug) console.log("Not valid EXIF data! " + getStringFromDB(file, start, 4));
            return false;
        }

        var bigEnd,
            tags, tag,
            exifData, gpsData,
            tiffOffset = start + 6;

        // test for TIFF validity and endianness
        if (file.getUint16(tiffOffset) == 0x4949) {
            bigEnd = false;
        } else if (file.getUint16(tiffOffset) == 0x4D4D) {
            bigEnd = true;
        } else {
            if (debug) console.log("Not valid TIFF data! (no 0x4949 or 0x4D4D)");
            return false;
        }

        if (file.getUint16(tiffOffset+2, !bigEnd) != 0x002A) {
            if (debug) console.log("Not valid TIFF data! (no 0x002A)");
            return false;
        }

        var firstIFDOffset = file.getUint32(tiffOffset+4, !bigEnd);

        if (firstIFDOffset < 0x00000008) {
            if (debug) console.log("Not valid TIFF data! (First offset less than 8)", file.getUint32(tiffOffset+4, !bigEnd));
            return false;
        }

        tags = readTags(file, tiffOffset, tiffOffset + firstIFDOffset, TiffTags, bigEnd);

        if (tags.ExifIFDPointer) {
            exifData = readTags(file, tiffOffset, tiffOffset + tags.ExifIFDPointer, ExifTags, bigEnd);
            for (tag in exifData) {
                switch (tag) {
                    case "LightSource" :
                    case "Flash" :
                    case "MeteringMode" :
                    case "ExposureProgram" :
                    case "SensingMethod" :
                    case "SceneCaptureType" :
                    case "SceneType" :
                    case "CustomRendered" :
                    case "WhiteBalance" :
                    case "GainControl" :
                    case "Contrast" :
                    case "Saturation" :
                    case "Sharpness" :
                    case "SubjectDistanceRange" :
                    case "FileSource" :
                        exifData[tag] = StringValues[tag][exifData[tag]];
                        break;

                    case "ExifVersion" :
                    case "FlashpixVersion" :
                        exifData[tag] = String.fromCharCode(exifData[tag][0], exifData[tag][1], exifData[tag][2], exifData[tag][3]);
                        break;

                    case "ComponentsConfiguration" :
                        exifData[tag] =
                            StringValues.Components[exifData[tag][0]] +
                            StringValues.Components[exifData[tag][1]] +
                            StringValues.Components[exifData[tag][2]] +
                            StringValues.Components[exifData[tag][3]];
                        break;
                }
                tags[tag] = exifData[tag];
            }
        }

        if (tags.GPSInfoIFDPointer) {
            gpsData = readTags(file, tiffOffset, tiffOffset + tags.GPSInfoIFDPointer, GPSTags, bigEnd);
            for (tag in gpsData) {
                switch (tag) {
                    case "GPSVersionID" :
                        gpsData[tag] = gpsData[tag][0] +
                            "." + gpsData[tag][1] +
                            "." + gpsData[tag][2] +
                            "." + gpsData[tag][3];
                        break;
                }
                tags[tag] = gpsData[tag];
            }
        }

        // extract thumbnail
        tags['thumbnail'] = readThumbnailImage(file, tiffOffset, firstIFDOffset, bigEnd);

        return tags;
    }

   function findXMPinJPEG(file) {

        if (!('DOMParser' in self)) {
            // console.warn('XML parsing not supported without DOMParser');
            return;
        }
        var dataView = new DataView(file);

        if (debug) console.log("Got file of length " + file.byteLength);
        if ((dataView.getUint8(0) != 0xFF) || (dataView.getUint8(1) != 0xD8)) {
           if (debug) console.log("Not a valid JPEG");
           return false; // not a valid jpeg
        }

        var offset = 2,
            length = file.byteLength,
            dom = new DOMParser();

        while (offset < (length-4)) {
            if (getStringFromDB(dataView, offset, 4) == "http") {
                var startOffset = offset - 1;
                var sectionLength = dataView.getUint16(offset - 2) - 1;
                var xmpString = getStringFromDB(dataView, startOffset, sectionLength)
                var xmpEndIndex = xmpString.indexOf('xmpmeta>') + 8;
                xmpString = xmpString.substring( xmpString.indexOf( '<x:xmpmeta' ), xmpEndIndex );

                var indexOfXmp = xmpString.indexOf('x:xmpmeta') + 10
                //Many custom written programs embed xmp/xml without any namespace. Following are some of them.
                //Without these namespaces, XML is thought to be invalid by parsers
                xmpString = xmpString.slice(0, indexOfXmp)
                            + 'xmlns:Iptc4xmpCore="http://iptc.org/std/Iptc4xmpCore/1.0/xmlns/" '
                            + 'xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" '
                            + 'xmlns:tiff="http://ns.adobe.com/tiff/1.0/" '
                            + 'xmlns:plus="http://schemas.android.com/apk/lib/com.google.android.gms.plus" '
                            + 'xmlns:ext="http://www.gettyimages.com/xsltExtension/1.0" '
                            + 'xmlns:exif="http://ns.adobe.com/exif/1.0/" '
                            + 'xmlns:stEvt="http://ns.adobe.com/xap/1.0/sType/ResourceEvent#" '
                            + 'xmlns:stRef="http://ns.adobe.com/xap/1.0/sType/ResourceRef#" '
                            + 'xmlns:crs="http://ns.adobe.com/camera-raw-settings/1.0/" '
                            + 'xmlns:xapGImg="http://ns.adobe.com/xap/1.0/g/img/" '
                            + 'xmlns:Iptc4xmpExt="http://iptc.org/std/Iptc4xmpExt/2008-02-29/" '
                            + xmpString.slice(indexOfXmp)

                var domDocument = dom.parseFromString( xmpString, 'text/xml' );
                return xml2Object(domDocument);
            } else{
             offset++;
            }
        }
    }

    function xml2json(xml) {
        var json = {};
      
        if (xml.nodeType == 1) { // element node
          if (xml.attributes.length > 0) {
            json['@attributes'] = {};
            for (var j = 0; j < xml.attributes.length; j++) {
              var attribute = xml.attributes.item(j);
              json['@attributes'][attribute.nodeName] = attribute.nodeValue;
            }
          }
        } else if (xml.nodeType == 3) { // text node
          return xml.nodeValue;
        }
      
        // deal with children
        if (xml.hasChildNodes()) {
          for(var i = 0; i < xml.childNodes.length; i++) {
            var child = xml.childNodes.item(i);
            var nodeName = child.nodeName;
            if (json[nodeName] == null) {
              json[nodeName] = xml2json(child);
            } else {
              if (json[nodeName].push == null) {
                var old = json[nodeName];
                json[nodeName] = [];
                json[nodeName].push(old);
              }
              json[nodeName].push(xml2json(child));
            }
          }
        }
        
        return json;
    }

    function xml2Object(xml) {
        try {
            var obj = {};
            if (xml.children.length > 0) {
              for (var i = 0; i < xml.children.length; i++) {
                var item = xml.children.item(i);
                var attributes = item.attributes;
                for(var idx in attributes) {
                    var itemAtt = attributes[idx];
                    var dataKey = itemAtt.nodeName;
                    var dataValue = itemAtt.nodeValue;

                    if(dataKey !== undefined) {
                        obj[dataKey] = dataValue;
                    }
                }
                var nodeName = item.nodeName;

                if (typeof (obj[nodeName]) == "undefined") {
                  obj[nodeName] = xml2json(item);
                } else {
                  if (typeof (obj[nodeName].push) == "undefined") {
                    var old = obj[nodeName];

                    obj[nodeName] = [];
                    obj[nodeName].push(old);
                  }
                  obj[nodeName].push(xml2json(item));
                }
              }
            } else {
              obj = xml.textContent;
            }
            return obj;
          } catch (e) {
              console.log(e.message);
          }
    }

    EXIF.enableXmp = function() {
        EXIF.isXmpEnabled = true;
    }

    EXIF.disableXmp = function() {
        EXIF.isXmpEnabled = false;
    }

    EXIF.getData = function(img, callback) {
        if (((self.Image && img instanceof self.Image)
            || (self.HTMLImageElement && img instanceof self.HTMLImageElement))
            && !img.complete)
            return false;

        if (!imageHasData(img)) {
            getImageData(img, callback);
        } else {
            if (callback) {
                callback.call(img);
            }
        }
        return true;
    }

    EXIF.getTag = function(img, tag) {
        if (!imageHasData(img)) return;
        return img.exifdata[tag];
    }
    
    EXIF.getIptcTag = function(img, tag) {
        if (!imageHasData(img)) return;
        return img.iptcdata[tag];
    }

    EXIF.getAllTags = function(img) {
        if (!imageHasData(img)) return {};
        var a,
            data = img.exifdata,
            tags = {};
        for (a in data) {
            if (data.hasOwnProperty(a)) {
                tags[a] = data[a];
            }
        }
        return tags;
    }
    
    EXIF.getAllIptcTags = function(img) {
        if (!imageHasData(img)) return {};
        var a,
            data = img.iptcdata,
            tags = {};
        for (a in data) {
            if (data.hasOwnProperty(a)) {
                tags[a] = data[a];
            }
        }
        return tags;
    }

    EXIF.pretty = function(img) {
        if (!imageHasData(img)) return "";
        var a,
            data = img.exifdata,
            strPretty = "";
        for (a in data) {
            if (data.hasOwnProperty(a)) {
                if (typeof data[a] == "object") {
                    if (data[a] instanceof Number) {
                        strPretty += a + " : " + data[a] + " [" + data[a].numerator + "/" + data[a].denominator + "]\r\n";
                    } else {
                        strPretty += a + " : [" + data[a].length + " values]\r\n";
                    }
                } else {
                    strPretty += a + " : " + data[a] + "\r\n";
                }
            }
        }
        return strPretty;
    }

    EXIF.readFromBinaryFile = function(file) {
        return findEXIFinJPEG(file);
    }

    if (true) {
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function() {
            return EXIF;
        }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    }
}.call(this));



/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Pencil_class = function (_Base_tools_class) {
	_inherits(Pencil_class, _Base_tools_class);

	function Pencil_class(ctx) {
		_classCallCheck(this, Pencil_class);

		var _this2 = _possibleConstructorReturn(this, (Pencil_class.__proto__ || Object.getPrototypeOf(Pencil_class)).call(this));

		_this2.Base_layers = new _baseLayers2.default();

		_this2.name = 'pencil';
		_this2.data = [];
		_this2.layer = {};
		_this2.params_hash = false;
		return _this2;
	}

	_createClass(Pencil_class, [{
		key: 'load',
		value: function load() {
			var _this = this;

			//events
			document.addEventListener('mousedown', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousedown(e);
			});
			document.addEventListener('mousemove', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousemove(e);

				//mouse cursor
				var mouse = _this.get_mouse_info(e);
				var params = _this.getParams();
				if (params.antialiasing == true) _this.show_mouse_cursor(mouse.x, mouse.y, params.size || 1, 'circle');
			});
			document.addEventListener('mouseup', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mouseup(e);
			});
		}
	}, {
		key: 'mousedown',
		value: function mousedown(e) {
			var mouse = this.get_mouse_info(e);
			if (mouse.valid == false || mouse.click_valid == false) return;

			window.State.save();

			var params_hash = this.get_params_hash();

			if (_config2.default.layer.type != this.name || params_hash != this.params_hash) {
				//register new object - current layer is not ours or params changed
				this.data = [];
				this.layer = {
					type: this.name,
					data: this.data,
					params: this.clone(this.getParams()),
					status: 'draft',
					render_function: [this.name, 'render'],
					width: null,
					height: null,
					rotate: null
				};
				this.Base_layers.insert(this.layer);
				this.params_hash = params_hash;
			} else {
				//continue adding layer data, just register break
				this.data.push(null);
			}
		}
	}, {
		key: 'mousemove',
		value: function mousemove(e) {
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();
			if (mouse.is_drag == false) return;
			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}

			//more data
			if (params.antialiasing == false) this.data.push([Math.ceil(mouse.x), Math.ceil(mouse.y)]);else this.data.push([mouse.x - _config2.default.layer.x, mouse.y - _config2.default.layer.y]);
			this.Base_layers.render();
		}
	}, {
		key: 'mouseup',
		value: function mouseup(e) {
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();
			if (mouse.valid == false || mouse.click_valid == false) {
				_config2.default.layer.status = null;
				return;
			}

			//more data
			if (params.antialiasing == false) this.data.push([Math.ceil(mouse.x), Math.ceil(mouse.y)]);else this.data.push([mouse.x - _config2.default.layer.x, mouse.y - _config2.default.layer.y]);
			_config2.default.layer.status = null;
			this.Base_layers.render();
		}
	}, {
		key: 'on_params_update',
		value: function on_params_update() {
			var params = this.getParams();
			var strict_element = document.querySelector('.block .item.size');

			if (params.antialiasing == false) {
				//hide strict controlls
				strict_element.style.display = 'none';
			} else {
				//show strict controlls
				strict_element.style.display = 'inline_block';
			}
		}
	}, {
		key: 'render',
		value: function render(ctx, layer) {
			var params = layer.params;

			if (params.antialiasing == false) this.render_aliased(ctx, layer);else this.render_antialiased(ctx, layer);
		}

		/**
   * draw without antialiasing, sharp, ugly mode.
   * 
   * @param {ctx} ctx
   * @param {object} layer
   */

	}, {
		key: 'render_aliased',
		value: function render_aliased(ctx, layer) {
			if (layer.data.length == 0) return;

			var params = layer.params;
			var data = layer.data;
			var n = data.length;

			//set styles
			ctx.fillStyle = layer.color;
			ctx.strokeStyle = layer.color;

			ctx.translate(layer.x, layer.y);

			//draw
			ctx.beginPath();
			ctx.moveTo(data[0][0], data[0][1]);
			for (var i = 1; i < n; i++) {
				if (data[i] === null) {
					//break
					ctx.beginPath();
				} else {
					//line
					if (data[i - 1] == null) {
						//exception - point
						ctx.fillRect(data[i][0] - 1, data[i][1] - 1, 1, 1);
					} else {
						//lines
						ctx.beginPath();
						this.draw_simple_line(ctx, data[i - 1][0], data[i - 1][1], data[i][0], data[i][1]);
					}
				}
			}
			if (n == 1 || data[1] == null) {
				//point
				ctx.beginPath();
				ctx.fillRect(data[0][0] - 1, data[0][1] - 1, 1, 1);
			}

			ctx.translate(-layer.x, -layer.y);
		}

		/**
   * draws line without aliasing
   * 
   * @param {ctx} ctx
   * @param {int} from_x
   * @param {int} from_y
   * @param {int} to_x
   * @param {int} to_y
   */

	}, {
		key: 'draw_simple_line',
		value: function draw_simple_line(ctx, from_x, from_y, to_x, to_y) {
			var dist_x = from_x - to_x;
			var dist_y = from_y - to_y;
			var distance = Math.sqrt(dist_x * dist_x + dist_y * dist_y);
			var radiance = Math.atan2(dist_y, dist_x);
			for (var j = 0; j < distance; j++) {
				var x_tmp = Math.round(to_x - 1 + Math.cos(radiance) * j);
				var y_tmp = Math.round(to_y - 1 + Math.sin(radiance) * j);

				ctx.fillRect(x_tmp, y_tmp, 1, 1);
			}
		}

		/**
   * draw with antialiasing, nice mode
   * 
   * @param {ctx} ctx
   * @param {object} layer
   */

	}, {
		key: 'render_antialiased',
		value: function render_antialiased(ctx, layer) {
			if (layer.data.length == 0) return;

			var params = layer.params;
			var data = layer.data;
			var n = data.length;
			var size = params.size || 1;

			//set styles
			ctx.fillStyle = layer.color;
			ctx.strokeStyle = layer.color;
			ctx.lineWidth = size;
			ctx.lineCap = 'round';
			ctx.lineJoin = 'round';

			ctx.translate(layer.x, layer.y);

			//draw
			ctx.beginPath();
			ctx.moveTo(data[0][0], data[0][1]);
			for (var i = 1; i < n; i++) {
				if (data[i] === null) {
					//break
					ctx.beginPath();
				} else {
					//line
					if (data[i - 1] == null) {
						//exception - point
						ctx.arc(data[i][0], data[i][1], size / 2, 0, 2 * Math.PI, false);
						ctx.fill();
					} else {
						//lines
						ctx.beginPath();
						ctx.moveTo(data[i - 1][0], data[i - 1][1]);
						ctx.lineTo(data[i][0], data[i][1]);
						ctx.stroke();
					}
				}
			}
			if (n == 1 || data[1] == null) {
				//point
				ctx.beginPath();
				ctx.arc(data[0][0], data[0][1], size / 2, 0, 2 * Math.PI, false);
				ctx.fill();
			}

			ctx.translate(-layer.x, -layer.y);
		}
	}]);

	return Pencil_class;
}(_baseTools2.default);

;
exports.default = Pencil_class;

/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _helpers = __webpack_require__(4);

var _helpers2 = _interopRequireDefault(_helpers);

var _baseGui = __webpack_require__(7);

var _baseGui2 = _interopRequireDefault(_baseGui);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Pick_color_class = function (_Base_tools_class) {
	_inherits(Pick_color_class, _Base_tools_class);

	function Pick_color_class(ctx) {
		_classCallCheck(this, Pick_color_class);

		var _this2 = _possibleConstructorReturn(this, (Pick_color_class.__proto__ || Object.getPrototypeOf(Pick_color_class)).call(this));

		_this2.Base_layers = new _baseLayers2.default();
		_this2.Helper = new _helpers2.default();
		_this2.Base_gui = new _baseGui2.default();
		_this2.ctx = ctx;
		_this2.name = 'pick_color';
		return _this2;
	}

	_createClass(Pick_color_class, [{
		key: 'load',
		value: function load() {
			var _this = this;

			//mouse events
			document.addEventListener('mousedown', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousedown(e);
			});
			document.addEventListener('mousemove', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousemove(e);
			});
		}
	}, {
		key: 'mousedown',
		value: function mousedown(e) {
			var mouse = this.get_mouse_info(e);
			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}

			this.pick_color(mouse);
		}
	}, {
		key: 'mousemove',
		value: function mousemove(e) {
			var mouse = this.get_mouse_info(e);
			if (mouse.is_drag == false || mouse.valid == false || mouse.click_valid == false) {
				return;
			}

			this.pick_color(mouse);
		}
	}, {
		key: 'pick_color',
		value: function pick_color(mouse) {
			var params = this.getParams();

			//get canvas from layer
			if (params.global == false) {
				//active layer
				var canvas = this.Base_layers.convert_layer_to_canvas(_config2.default.layer.id, null, false);
				var ctx = canvas.getContext("2d");
			} else {
				//global
				var canvas = document.createElement('canvas');
				var ctx = canvas.getContext("2d");
				canvas.width = _config2.default.WIDTH;
				canvas.height = _config2.default.HEIGHT;
				this.Base_layers.convert_layers_to_canvas(ctx);
			}
			//find color
			var c = ctx.getImageData(mouse.x, mouse.y, 1, 1).data;
			_config2.default.COLOR = this.Helper.rgbToHex(c[0], c[1], c[2]);

			if (c[3] > 0) {
				//set alpha
				this.Base_gui.GUI_colors.change_alpha(c[3]);
			}

			this.Base_gui.GUI_colors.render_colors();
		}
	}]);

	return Pick_color_class;
}(_baseTools2.default);

;
exports.default = Pick_color_class;

/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Rectangle_class = function (_Base_tools_class) {
	_inherits(Rectangle_class, _Base_tools_class);

	function Rectangle_class(ctx) {
		_classCallCheck(this, Rectangle_class);

		var _this2 = _possibleConstructorReturn(this, (Rectangle_class.__proto__ || Object.getPrototypeOf(Rectangle_class)).call(this));

		_this2.Base_layers = new _baseLayers2.default();
		_this2.ctx = ctx;
		_this2.name = 'rectangle';
		_this2.layer = {};
		return _this2;
	}

	_createClass(Rectangle_class, [{
		key: 'load',
		value: function load() {
			var _this = this;

			//events
			document.addEventListener('mousedown', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousedown(e);
			});
			document.addEventListener('mousemove', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousemove(e);
			});
			document.addEventListener('mouseup', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mouseup(e);
			});
		}
	}, {
		key: 'mousedown',
		value: function mousedown(e) {
			var mouse = this.get_mouse_info(e);
			if (mouse.valid == false || mouse.click_valid == false) return;

			window.State.save();

			//register new object - current layer is not ours or params changed
			this.layer = {
				type: this.name,
				params: this.clone(this.getParams()),
				status: 'draft',
				render_function: [this.name, 'render'],
				x: mouse.x,
				y: mouse.y
			};
			this.Base_layers.insert(this.layer);
		}
	}, {
		key: 'mousemove',
		value: function mousemove(e) {
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();

			if (mouse.is_drag == false) return;
			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}

			var width = mouse.x - this.layer.x;
			var height = mouse.y - this.layer.y;

			if (params.square == true) {
				if (Math.abs(width) < Math.abs(height)) {
					if (width > 0) width = Math.abs(height);else width = -Math.abs(height);
				} else {
					if (height > 0) height = Math.abs(width);else height = -Math.abs(width);
				}
			}

			//more data
			_config2.default.layer.width = width;
			_config2.default.layer.height = height;
			this.Base_layers.render();
		}
	}, {
		key: 'mouseup',
		value: function mouseup(e) {
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();

			if (mouse.valid == false || mouse.click_valid == false) {
				_config2.default.layer.status = null;
				return;
			}

			var width = mouse.x - this.layer.x;
			var height = mouse.y - this.layer.y;

			if (params.square == true) {
				if (Math.abs(width) < Math.abs(height)) {
					if (width > 0) width = Math.abs(height);else width = -Math.abs(height);
				} else {
					if (height > 0) height = Math.abs(width);else height = -Math.abs(width);
				}
			}

			if (width == 0 && height == 0) {
				//same coordinates - cancel
				this.Base_layers.delete(_config2.default.layer.id);
				return;
			}

			//more data
			_config2.default.layer.width = width;
			_config2.default.layer.height = height;
			_config2.default.layer.status = null;
			this.Base_layers.render();
		}
	}, {
		key: 'render',
		value: function render(ctx, layer) {
			var params = layer.params;
			var fill = params.fill;
			var rotateSupport = true;

			ctx.save();

			//set styles
			ctx.fillStyle = layer.color;
			ctx.strokeStyle = layer.color;
			ctx.lineWidth = params.size;

			if (rotateSupport == false) {
				this.rectangle(ctx, layer.x, layer.y, layer.width, layer.height, fill);
			} else {
				//rotate
				ctx.translate(layer.x + layer.width / 2, layer.y + layer.height / 2);
				ctx.rotate(layer.rotate * Math.PI / 180);
				this.rectangle(ctx, -layer.width / 2, -layer.height / 2, layer.width, layer.height, fill);
			}

			ctx.restore();
		}

		//draws rectangle

	}, {
		key: 'rectangle',
		value: function rectangle(ctx, x, y, width, height, fill) {
			x = x + 0.5;
			y = y + 0.5;
			width--;
			height--;
			if (typeof fill == "undefined") fill = false;

			ctx.beginPath();
			ctx.rect(x, y, width, height);

			if (fill) {
				ctx.fill();
			} else {
				ctx.stroke();
			}
		}
	}]);

	return Rectangle_class;
}(_baseTools2.default);

;
exports.default = Rectangle_class;

/***/ }),
/* 76 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _baseSelection = __webpack_require__(12);

var _baseSelection2 = _interopRequireDefault(_baseSelection);

var _popup = __webpack_require__(3);

var _popup2 = _interopRequireDefault(_popup);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Select_tool_class = function (_Base_tools_class) {
	_inherits(Select_tool_class, _Base_tools_class);

	function Select_tool_class(ctx) {
		_classCallCheck(this, Select_tool_class);

		var _this2 = _possibleConstructorReturn(this, (Select_tool_class.__proto__ || Object.getPrototypeOf(Select_tool_class)).call(this));

		_this2.Base_layers = new _baseLayers2.default();
		_this2.POP = new _popup2.default();
		_this2.ctx = ctx;
		_this2.name = 'select';
		_this2.saved = false;
		_this2.last_post = { x: null, y: null };

		var sel_config = {
			enable_background: false,
			enable_borders: true,
			enable_controlls: true,
			data_function: function data_function() {
				return _config2.default.layer;
			}
		};
		_this2.Base_selection = new _baseSelection2.default(ctx, sel_config, _this2.name);
		return _this2;
	}

	_createClass(Select_tool_class, [{
		key: 'load',
		value: function load() {
			var _this = this;

			//mouse events
			document.addEventListener('mousedown', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousedown(e);
			});
			document.addEventListener('mousemove', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousemove(e);
			});

			//keyboard actions
			document.addEventListener('keydown', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				if (_this.POP.active == true) return;
				if (e.target.type == 'text' || e.target.tagName == 'INPUT') return;
				var k = e.keyCode;

				//up
				if (k == 38) {
					_this.move(0, -1, e);
				}
				//down
				else if (k == 40) {
						_this.move(0, 1, e);
					}
					//right
					else if (k == 39) {
							_this.move(1, 0, e);
						}
						//left
						else if (k == 37) {
								_this.move(-1, 0, e);
							}
				if (k == 46) {
					//delete
					if (_config2.default.TOOL.name == _this.name) {
						_this.Base_layers.delete(_config2.default.layer.id);
					}
				}
			});
		}
	}, {
		key: 'mousedown',
		value: function mousedown(e) {
			var mouse = this.get_mouse_info(e);
			if (mouse.valid == false || mouse.click_valid == false) return;
			if (this.Base_selection.mouse_lock != null) return;

			this.auto_select_object(e);
			this.saved = false;

			this.last_post = {
				x: _config2.default.layer.x,
				y: _config2.default.layer.y
			};
		}
	}, {
		key: 'mousemove',
		value: function mousemove(e) {
			var mouse = this.get_mouse_info(e);
			if (mouse.is_drag == false) return;
			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}
			if (this.Base_selection.mouse_lock != null) return;

			if (this.saved == false) {
				window.State.save();
				this.saved = true;
			}

			//move object
			_config2.default.layer.x = Math.round(mouse.x - mouse.click_x + this.last_post.x);
			_config2.default.layer.y = Math.round(mouse.y - mouse.click_y + this.last_post.y);

			this.Base_layers.render();
		}
	}, {
		key: 'move',
		value: function move(direction_x, direction_y, event) {
			var power = 10;
			if (event.ctrlKey == true || event.metaKey) power = 50;
			if (event.shiftKey == true) power = 1;

			_config2.default.layer.x += direction_x * power;
			_config2.default.layer.y += direction_y * power;
			_config2.default.need_render = true;
		}
	}, {
		key: 'auto_select_object',
		value: function auto_select_object(e) {
			var params = this.getParams();
			if (params.auto_select == false) return;

			var layers_sorted = this.Base_layers.get_sorted_layers();

			//render main canvas
			for (var i = 0; i < layers_sorted.length; i++) {
				var value = layers_sorted[i];
				var canvas = this.Base_layers.convert_layer_to_canvas(value.id, null, false);

				if (this.check_hit_region(e, canvas.getContext("2d")) == true) {
					this.Base_layers.select(value.id);
					break;
				}
			}
		}
	}, {
		key: 'check_hit_region',
		value: function check_hit_region(e, ctx) {
			var mouse = this.get_mouse_info(e);
			var data = ctx.getImageData(mouse.x, mouse.y, 1, 1).data;

			var blank = [0, 0, 0, 0];
			if (_config2.default.TRANSPARENCY == false) {
				blank = [0, 0, 0, 0];
			}

			if (data[0] != blank[0] || data[1] != blank[1] || data[2] != blank[2] || data[3] != blank[3]) {
				//hit
				return true;
			}

			return false;
		}
	}]);

	return Select_tool_class;
}(_baseTools2.default);

;
exports.default = Select_tool_class;

/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _alertifyMin = __webpack_require__(2);

var _alertifyMin2 = _interopRequireDefault(_alertifyMin);

var _imagefilters = __webpack_require__(6);

var _imagefilters2 = _interopRequireDefault(_imagefilters);

var _helpers = __webpack_require__(4);

var _helpers2 = _interopRequireDefault(_helpers);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Sharpen_class = function (_Base_tools_class) {
	_inherits(Sharpen_class, _Base_tools_class);

	function Sharpen_class(ctx) {
		_classCallCheck(this, Sharpen_class);

		var _this2 = _possibleConstructorReturn(this, (Sharpen_class.__proto__ || Object.getPrototypeOf(Sharpen_class)).call(this));

		_this2.Base_layers = new _baseLayers2.default();
		_this2.Helper = new _helpers2.default();
		_this2.ctx = ctx;
		_this2.name = 'sharpen';
		_this2.tmpCanvas = null;
		_this2.tmpCanvasCtx = null;
		_this2.started = false;
		return _this2;
	}

	_createClass(Sharpen_class, [{
		key: 'load',
		value: function load() {
			var _this = this;

			//mouse events
			document.addEventListener('mousedown', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousedown(e);
			});
			document.addEventListener('mousemove', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mousemove(e);

				//mouse cursor
				var mouse = _this.get_mouse_info(e);
				var params = _this.getParams();
				_this.show_mouse_cursor(mouse.x, mouse.y, params.size, 'circle');
			});
			document.addEventListener('mouseup', function (e) {
				if (_config2.default.TOOL.name != _this.name) return;
				_this.mouseup(e);
			});
		}
	}, {
		key: 'mousedown',
		value: function mousedown(e) {
			this.started = false;
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();
			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}
			if (_config2.default.layer.type != 'image') {
				_alertifyMin2.default.error('Layer must be image, convert it to raster to apply this tool.');
				return;
			}
			if (_config2.default.layer.rotate || 0 > 0) {
				_alertifyMin2.default.error('Erase on rotate object is disabled. Sorry.');
				return;
			}
			this.started = true;
			window.State.save();

			//get canvas from layer
			this.tmpCanvas = document.createElement('canvas');
			this.tmpCanvasCtx = this.tmpCanvas.getContext("2d");
			this.tmpCanvas.width = _config2.default.layer.width_original;
			this.tmpCanvas.height = _config2.default.layer.height_original;
			this.tmpCanvasCtx.drawImage(_config2.default.layer.link, 0, 0);

			//do sharpen
			this.sharpen_general('click', mouse, params.size);

			//register tmp canvas for faster redraw
			_config2.default.layer.link_canvas = this.tmpCanvas;
			_config2.default.need_render = true;
		}
	}, {
		key: 'mousemove',
		value: function mousemove(e) {
			var mouse = this.get_mouse_info(e);
			var params = this.getParams();
			if (mouse.is_drag == false) return;
			if (mouse.valid == false || mouse.click_valid == false) {
				return;
			}
			if (this.started == false) {
				return;
			}

			//do sharpen
			this.sharpen_general('move', mouse, params.size);

			//draw draft preview
			_config2.default.need_render = true;
		}
	}, {
		key: 'mouseup',
		value: function mouseup(e) {
			if (this.started == false) {
				return;
			}
			delete _config2.default.layer.link_canvas;

			this.Base_layers.update_layer_image(this.tmpCanvas);

			//decrease memory
			this.tmpCanvas.width = 1;
			this.tmpCanvas.height = 1;
			this.tmpCanvas = null;
			this.tmpCanvasCtx = null;
		}
	}, {
		key: 'sharpen_general',
		value: function sharpen_general(type, mouse, size) {
			var ctx = this.tmpCanvasCtx;
			var mouse_x = Math.round(mouse.x) - _config2.default.layer.x;
			var mouse_y = Math.round(mouse.y) - _config2.default.layer.y;

			//adapt to origin size
			mouse_x = this.adaptSize(mouse_x, 'width');
			mouse_y = this.adaptSize(mouse_y, 'height');
			var size_w = this.adaptSize(size, 'width');
			var size_h = this.adaptSize(size, 'height');

			//find center
			var center_x = mouse_x - Math.round(size_w / 2);
			var center_y = mouse_y - Math.round(size_h / 2);

			//convert float coords to integers
			mouse_x = Math.round(mouse_x);
			mouse_y = Math.round(mouse_y);
			center_x = Math.round(center_x);
			center_y = Math.round(center_y);

			var power = 0.5;
			if (type == 'move') {
				power = power / 10;
			}

			var imageData = ctx.getImageData(center_x, center_y, size_w, size_h);
			var filtered = _imagefilters2.default.Sharpen(imageData, power); //add effect
			this.Helper.image_round(this.tmpCanvasCtx, mouse_x, mouse_y, size_w, size_h, filtered);
		}
	}]);

	return Sharpen_class;
}(_baseTools2.default);

exports.default = Sharpen_class;

/***/ }),
/* 78 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = __webpack_require__(0);

var _config2 = _interopRequireDefault(_config);

var _baseTools = __webpack_require__(5);

var _baseTools2 = _interopRequireDefault(_baseTools);

var _baseLayers = __webpack_require__(1);

var _baseLayers2 = _interopRequireDefault(_baseLayers);

var _helpers = __webpack_require__(4);

var _helpers2 = _interopRequireDefault(_helpe