<?php

class Portlets_AdminController extends \Pimcore\Controller\Action\Admin
{
	public function getCountriesAction()
	{
		$exchangeRate = \Website\Tool\Utils::getEshopSettings()->getExchangeRate()->data;
		$countries = ['countries' => []];
		foreach ($exchangeRate as $locale => $options) {
			if ($options['isactive']) {
				$country = strtoupper(substr($locale, 3));
				$countries['countries'][] = ['country' => $country, 'value' => $country];
			}
		}

		$this->_helper->json($countries);
	}

	public function portletLastOrdersAction()
	{
		$count = $this->getRequest()->getParam('count', null);
		if ($count === null) {
			$count = 10;
		}

		$list = new \Website\Model\Order\Listing();
		$list->setLimit((int) $count);
		$list->setOrder('DESC');
		$list->setOrderKey('o_id');
		$list->load();

		$statusMap = [];
		array_walk(\Pimcore\Model\Object\ClassDefinition::getById(3)->getFieldDefinition('status')->getOptions(), function ($option) use (&$statusMap) {
			$statusMap[$option['value']] = $option['key'];
		});

		$response = [];
		$response["objects"] = [];

		foreach ($list as $object) {
			$response["objects"][] = [
				"id" => $object->getId(),
				"type" => $object->getType(),
				"path" => $object->getFullPath(),
				"date" => $object->getCreationDate(),
				"status" => $object->getStatus(),
				"statusText" => (isset($statusMap[$object->getStatus()])) ? $statusMap[$object->getStatus()] : '-'
			];
		}

		$this->_helper->json($response);
	}

	public function portletMostSoldProductsAction()
	{
		$count = $this->getRequest()->getParam('count', null);
		if ($count === null) {
			$count = 10;
		}

		$list = new \Website\Model\Product\Listing();
		$list->setLimit((int) $count);
		$list->setOrder('DESC');
		$list->setOrderKey('soldCount');
		$list->setObjectTypes([\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_VARIANT, \Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_OBJECT]);
		$list->load();

		$response = [];
		$response["objects"] = [];

		foreach ($list as $object) {
			$response["objects"][] = [
				"id" => $object->getId(),
				"type" => $object->getType(),
				"path" => $object->getFullPath(),
				"count" => (int)$object->getSoldCount()
			];
		}

		$this->_helper->json($response);
	}

	/**
	 * @TODO add multiple countries support
	 */
	public function portletEshopStatisticsAction()
	{
		$since = $this->getRequest()->getParam('since');
		$until = $this->getRequest()->getParam('until');
		$exchangeRate = \Website\Tool\Utils::getEshopSettings()->getExchangeRate()->data;
		foreach ($exchangeRate as $locale => $options) {
			if ($options['isactive'] && $options['isdefault']) {
				$defaultCountry = strtoupper(substr($locale, 3));
			}
		}
		$country = $this->getRequest()->getParam('country', $defaultCountry);

		$days = 30;
		if ($until) {
			$endDate = strtotime($until) + 60*60*24 - 1;
		} else {
			$endDate = mktime(23, 59, 59, date("m"), date("d"), date("Y"));
		}

		if ($since) {
			$startDate = strtotime($since);
		} else {
			$startDate = $endDate - $days * 60 * 60 * 24 + 1;
		}

		$days = (int)ceil((abs($endDate - $startDate)) / (60*60*24));

		$list = new \Website\Model\Order\Listing();
		$condition = 'o_creationDate > '.$startDate.' AND o_creationDate < '.$endDate;
		$condition .= \Pimcore\Db::get()->quoteInto(' AND country = ?', $country);
		$list->setCondition($condition)
		;
		$list->load();


		$dailyCost = 0;//$settings->getDailyCost(); this is bullshit...

		$orderCount = $list->count();
		$orderProductCount = 0;
		$orderPriceSum = 0;
		$profit = 0;
		foreach ($list->getItems(0, 0) as $order) {
			$country = $order->getCountry();
			$orderProducts = $order->getProducts();
			if ($orderProducts) {
				foreach ($orderProducts as $orderProduct) {
					$orderProductCount += $orderProduct->getCount();
					$orderPriceSum += $orderProduct->getPrice() * $orderProduct->getCount();
					$profit += ($orderProduct->getPrice() * $orderProduct->getCount() - $orderProduct->getCost() * $orderProduct->getCount());
				}
			}
			//shipping to profit
			$profit += $order->getShippingPrice() + $order->getPaymentPrice() - \Website\Tool\Utils::getOurShippingPrice($order->getPaymentType(), $order->getShippingType(), $country);
		}
		//daily add costs to profit
		$profit -= ($dailyCost * $days);
		$orderPriceAverage = number_format($orderPriceSum / $days, 2, ',', ' ');
		$orderCountAverage = number_format($orderCount / $days, 2, ',', ' ');
		$orderProductCountAverage = number_format($orderProductCount / $days, 2, ',', ' ');
		$profitAverage = number_format($profit / $days, 2, ',', ' ');


		$language = \Zend_Registry::get("Zend_Locale");
		if (is_object($language)) {
			$language = $language->__toString();
		}
		$translator = new \Zend_Translate('csv', PIMCORE_PLUGINS_PATH . \Portlets\Plugin::getTranslationFile($language), $language, ['delimiter' => ',']);

		$data = [];
		$data['stats'] = [
			['key' => $translator->_('plugin_portlets_stats_order_count'), 'value' => $orderCount],
			['key' => $translator->_('plugin_portlets_stats_product_count'), 'value' => $orderProductCount],
			['key' => $translator->_('plugin_portlets_stats_order_price'), 'value' => $orderPriceSum],
			['key' => $translator->_('plugin_portlets_stats_profit'), 'value' => $profit],
			['key' => $translator->_('plugin_portlets_stats_average_order_count'), 'value' => $orderCountAverage],
			['key' => $translator->_('plugin_portlets_stats_average_product_count'), 'value' => $orderProductCountAverage],
			['key' => $translator->_('plugin_portlets_stats_average_order_price'), 'value' => $orderPriceAverage],
			['key' => $translator->_('plugin_portlets_stats_average_profit'), 'value' => $profitAverage]
		];


		$this->_helper->json($data);
	}

	public function portletSalesGraphAction()
	{
		$since = $this->getRequest()->getParam('since');
		$until = $this->getRequest()->getParam('until');

		$days = 30;
		if ($until) {
			$endDate = strtotime($until) + 60*60*24 - 1;
		} else {
			$endDate = mktime(23, 59, 59, date("m"), date("d"), date("Y"));
		}

		if ($since) {
			$startDate = strtotime($since);
		} else {
			$startDate = $endDate - $days * 60 * 60 * 24 + 1;
		}

		$data = [];
		$list = new \Website\Model\Order\Listing();

		$start = $startDate;
		$end = 0;

		while ($start < $endDate) {
			$products = 0;
			$end = $start + 60 * 60 * 24 - 1;

			$list->setCondition('o_creationDate > '.$start.' AND o_creationDate < '.$end);
			$list->load();
			foreach ($list->getItems(0, 0) as $order) {
				$orderProducts = $order->getProducts();
				if ($orderProducts) {
					foreach ($orderProducts as $orderProduct) {
						$products += $orderProduct->getCount();
					}
				}
			}

			$date = new \Zend_Date($start);

			$data[] = [
				"timestamp" => $start,
				"datetext" => $date->get(\Zend_Date::DATE_LONG),
				"orders" => $list->count(),
				"products" => $products
			];

			$start += 60*60*24;
		}

		$this->_helper->json(["data" => $data]);
	}
}
