<?php

class UserController extends \Website\Controller\BaseController
{

	/* 						DOCUMENT ROUTED ACTIONS							 */

	public function loginAction()
	{
		$this->enableLayout();

		$loginForm = new \Website\Form\LoginForm();
		$loginForm->setAction($this->view->docUrl('/'.$this->defaultLanguage.'/prihlaseni'));
		$passwordResetForm = new \Website\Form\PasswordResetForm();
		$passwordResetForm->setAction($this->view->docUrl('/'.$this->defaultLanguage.'/prihlaseni'));
		$registrationForm = new \Website\Form\RegistrationForm();
		$registrationForm->setAction($this->view->docUrl('/'.$this->defaultLanguage.'/prihlaseni'));

		if ($this->getRequest()->isPost()) {
			$formName = $this->getRequest()->getPost('formName');
			switch ($formName) {
				case $loginForm->formName->getValue():
					if ($this->handleLoginForm($loginForm)) {
						$this->gotoUrl($this->getPreviousUrl());
						return;
					}
					break;
				case $passwordResetForm->formName->getValue():
					if ($this->handlePasswordResetForm($passwordResetForm)) {
						$this->gotoUrl($this->view->docUrl('/'.$this->defaultLanguage.'/prihlaseni'));
						return;
					}
					break;
				case $registrationForm->formName->getValue():
					if ($this->handleRegistrationForm($registrationForm)) {
						$this->gotoUrl($this->view->docUrl('/'.$this->defaultLanguage.'/prihlaseni'));
						return;
					}
					break;
			}
		} else {
			if (!\Zend_Auth::getInstance()->hasIdentity()) {
				$backlink = $this->getRequest()->getParam('backlink');
				if ($backlink) {//@TODO check if from our site...
					$this->setPreviousUrl($backlink, true);
				}
			}
		}


		$this->setPreviousUrl($this->getHttpReferer());
		$this->view->loginForm = $loginForm;
		$this->view->passwordResetForm = $passwordResetForm;
		$this->view->registrationForm = $registrationForm;
	}

	public function accountAction()
	{
		$this->checkAuth();
		$this->enableLayout();
	}

	public function passwordResetAction()
	{
		$this->enableLayout();

		$token = trim($this->getRequest()->getParam('token', ''));

		$list = new \Pimcore\Model\Object\User\Listing();
		$list->setUnpublished(true);
		$list->setCondition(\Pimcore\Db::get()->quoteInto('passwordResetToken = ?', $token));
		$list->setLimit(1);
		$user = $list->current();

		if (empty($token) || !$user) {
			$this->addErrorMsg($this->translate('msg_invalid_token'));
			$this->gotoUrl($this->view->docUrl('/'.$this->defaultLanguage.'/prihlaseni'));
			exit;
		}

		$form = new \Website\Form\PasswordResetChangeForm();

		if ($this->getRequest()->isPost()) {
			if ($this->handlePasswordResetChangeForm($form)) {
				$this->gotoUrl($this->view->docUrl('/'.$this->defaultLanguage.'/prihlaseni'));
			}
		} else {
			$form->token->setValue($token);
		}

		$this->view->passwordResetForm = $form;
	}

	public function changePasswordAction()
	{
		$this->checkAuth();
		$this->enableLayout();

		$form = new \Website\Form\PasswordChangeForm();
		$form->setAction($this->view->docUrl('/'.$this->defaultLanguage.'/ucet/zmena-hesla'));


		if ($this->getRequest()->isPost()) {
			if ($this->handlePasswordChangeForm($form)) {
				$this->gotoUrl($this->view->docUrl('/'.$this->defaultLanguage));
				return;
			}
		}

		if (!$this->isOutputCached($this->cacheKeySuffix)) {
		}

		$this->view->form = $form;
	}

	public function ordersAction()
	{
		$this->checkAuth();
		$this->enableLayout();

		$list = new \Website\Model\Order\Listing();
		$list->setOrderKey('o_creationDate');
		$list->setOrder('desc');
		$list->setCondition('user__id = ' . $this->getCurrentUser()->getId());

		$paginator = \Zend_Paginator::factory($list);
		$paginator->setCurrentPageNumber($this->_getParam('page'), 1);
		$paginator->setItemCountPerPage(10);

		if (!$this->isOutputCached($this->cacheKeySuffix)) {
		}

		$this->view->orders = $paginator;
	}

	public function profileAction()
	{
		$this->checkAuth();
		$this->enableLayout();

		$form = new \Website\Form\RegistrationForm();
		unset($form->email);
		unset($form->password);
		unset($form->password_again);
		unset($form->newsletter);
		unset($form->agreed);
		unset($form->formName);
		$form->send->setLabel($this->translate('label_edit'));

		if ($this->getRequest()->isPost()) {
			if ($this->handleProfileForm($form)) {
				$this->gotoUrl($this->view->docUrl('/'.$this->defaultLanguage.'/ucet/profil'));
			}
		} else {
			$user = $this->getCurrentUser();
			$form->populate(get_object_vars($user));
		}

		$this->view->profileForm = $form;
	}



	/*	 					STATIC-ROUTE ROUTED ACTIONS						 */



	public function orderAction()
	{
		$this->checkAuth();
		$this->enableLayout();

		$order = \Website\Model\Order::getById($this->getRequest()->getParam('id'));

		if (!$order instanceof \Website\Model\Order || !$order->getUser() instanceof \Pimcore\Model\Object\User || $order->getUser()->getEmail() != \Zend_Auth::getInstance()->getIdentity()->email) {
			throw new \Zend_Controller_Router_Exception($this->translate('system_page_not_found'), 404);
			return;
		}

		$this->addToBreadcrumbs[] = [
			'label' => sprintf($this->translate('title_order_detail'), $order->getOrderId()),
			'url' => \Website\Tool\Utils::url('order-' . $this->language, ['id' => $order->getId()])
		];

		//explicit language switch
		$this->languageSwitch = $this->_helper->buildLanguageSwitchFromRoute('order-', true, ['id' => $order->getId()]);

		$this->view->doNotCacheLayout = true;
		$this->view->order = $order;
	}



	/* 				VIEW-LESS ACTIONS (ALLWAYS REDIRECT)					 */



	public function activationAction()
	{
		$this->disableViewAutoRender();
		$code = $this->getRequest()->getParam('code');

		/* @var $user \Pimcore\Model\Object\User */
		$list = new \Pimcore\Model\Object\User\Listing();
		$list->setUnpublished(true);
		$list->setCondition(\Pimcore\Db::get()->quoteInto('activationCode = ?', $code));
		$list->setLimit(1);
		$user = $list->current();

		if ($user instanceof \Pimcore\Model\Object\User) {
			try {
				$user->setPublished(true);
				$user->save();
				$this->addSuccessMsg(sprintf($this->translate('msg_account_activated'), $user->getEmail()));
			} catch (\Exception $e) {
				$this->addErrorMsg($this->translate('msg_unknown_error'));
			}
		} else {
			$this->addErrorMsg($this->translate('msg_activation_code_invalid'));
		}

		$this->gotoUrl($this->view->docUrl('/'.$this->defaultLanguage.'/prihlaseni'));
	}

	public function logoutAction()
	{
		\Zend_Auth::getInstance()->clearIdentity();
		$this->addSuccessMsg($this->translate('msg_logout_successful'));
		$this->gotoUrl($this->view->docUrl('/' . $this->defaultLanguage));
	}



	/* 							FORM HANDLERS								 */



	private function handleLoginForm(\Zend_Form &$form)
	{
		if ($form->isValid($this->getRequest()->getPost())) {
			$data = $form->getValues();

			$authAdapter = new \Website\Model\Auth('\Pimcore\Model\Object\User', 'email', 'password');
			$authAdapter->setIdentity($data['email'])
					->setCredential($data['password']);

			$auth = \Zend_Auth::getInstance();
			$result = $auth->authenticate($authAdapter);

			switch ($result->getCode()) {
				case \Zend_Auth_Result::SUCCESS:
					if ($result->isValid()) {
						$identity = new \stdClass();
						$identity->email = $auth->getIdentity()->getEmail();
						$auth->getStorage()->write($identity);
						$this->addSuccessMsg($this->translate('msg_authentication_successful'));
						return true;
					}
					break;
				default:
					$this->addErrorMsg($this->translate('msg_authentication_error'));
					break;
			}
		} else {
			$this->addErrorMsg($this->translate('msg_form_invalid'));
		}

		return false;
	}

	private function handleRegistrationForm(\Zend_Form &$form)
	{
		if ($form->isValid($this->getRequest()->getPost())) {
			$data = $form->getValues();

			//already exists
			$list = new \Pimcore\Model\Object\User\Listing();
			$list->setUnpublished(true);
			$list->setCondition(\Pimcore\Db::get()->quoteInto('email = ?', $data['email']));
			$list->setLimit(1);
			$exists = $list->count();
			if ($exists) {
				$form->getElement('email')->addError('msg_email_registered');
			}
			//does not agree with terms
			if (!$data['agreed']) {
				$form->getElement('agreed')->addError('msg_agree_with_terms');
			}
			//error sum-up
			$errors = $form->getMessages();
			if (!empty($errors)) {
				$this->addErrorMsg($this->translate('msg_form_invalid'));
				return false;
			}

			$data['activationCode'] = uniqid();
			$data['password'] = \Website\Model\Auth::calculateHash($data['password']);
			$data['lang'] = $this->language;

			//user
			$userManager = new \Website\Model\UserManager($this->translator);
			$result = $userManager->createUser($data);

			//newsletter
			if ($result) {
				$this->addSuccessMsg(sprintf($this->translate('msg_registration_successfull'), $data['email']));

				$data['lang'] = $this->language;
				$newsletterManager = new \Website\Model\NewsletterManager();
				$newsletterManager->addNewsletter($data);
			}

			return $result;
		} else {
			$this->addErrorMsg($this->translate('msg_form_invalid'));
		}

		return false;
	}

	private function handlePasswordResetForm(\Zend_Form &$form)
	{
		if ($form->isValid($this->getRequest()->getPost())) {
			$data = $form->getValues();

			$list = new \Pimcore\Model\Object\User\Listing();
			$list->setUnpublished(true);
			$list->setCondition(\Pimcore\Db::get()->quoteInto('email = ?', $data['email']));
			$list->setLimit(1);
			$user = $list->current();

			if (!$user instanceof \Pimcore\Model\Object\User) {
				$this->addErrorMsg(sprintf($this->translate('msg_email_not_registered'), $data['email']));
				return false;
			}

			$token = strtolower(md5(uniqid()));

			try {
				$user->setPasswordResetToken($token);
				$user->save();
				$mailManager = new \Website\Model\MailManager();
				$mailManager->sendMail('/notifikace/reset-hesla', $this->language, $data['email'], null, [
					'link' => $this->view->serverUrl().  \Website\Tool\Utils::url('password-reset', ['token' => $token, 'language' => $this->language]),
					'user' => $user
				]);
				$this->addSuccessMsg(sprintf($this->translate('msg_password_reset_successfull'), $data['email']));

				return true;
			} catch (\Exception $e) {
				\Pimcore\Log\Simple::log('exceptions', 'PASSOWORD RESET FORM - ' . $e->getMessage() . "\n" . $e->getTraceAsString());
				$this->addErrorMsg($this->translate('msg_unknown_error'));
			}
		} else {
			$this->addErrorMsg($this->translate('msg_form_invalid'));
		}

		return false;
	}

	private function handlePasswordResetChangeForm(\Zend_Form &$form)
	{
		if ($form->isValid($this->getRequest()->getPost())) {
			$data = $form->getValues();

			$list = new \Pimcore\Model\Object\User\Listing();
			$list->setUnpublished(true);
			$list->setCondition(\Pimcore\Db::get()->quoteInto('passwordResetToken = ?', $data['token']));
			$list->setLimit(1);
			$user = $list->current();

			if (!$user instanceof \Pimcore\Model\Object\User) {
				$this->addErrorMsg(sprintf($this->translate('msg_unknown_error'), $data['password']));
				return false;
			}

			$hash = \Website\Model\Auth::calculateHash($data['password']);

			try {
				$user->setPassword($hash);
				$user->setPasswordResetToken('');
				$user->save();
				$this->addSuccessMsg(sprintf($this->translate('msg_password_change_successfull')));

				return true;
			} catch (\Exception $e) {
				\Pimcore\Log\Simple::log('exceptions', 'PASSOWORD RESET CHANGE FORM - ' . $e->getMessage() . "\n" . $e->getTraceAsString());
				$this->addErrorMsg($this->translate('msg_unknown_error'));
			}
		} else {
			$this->addErrorMsg($this->translate('msg_form_invalid'));
		}

		return false;
	}

	private function handlePasswordChangeForm(\Zend_Form &$form)
	{
		if ($form->isValid($this->getRequest()->getPost())) {
			$data = $form->getValues();

			//wrong old password
			$list = new \Pimcore\Model\Object\User\Listing();
			$list->setUnpublished(true);
			$list->setCondition(\Pimcore\Db::get()->quoteInto('email = ?', \Zend_Auth::getInstance()->getIdentity()->email));
			$list->setLimit(1);
			$user = $list->current();
			if (!$user instanceof \Pimcore\Model\Object\User || $user->getPassword() != \Website\Model\Auth::calculateHash($data['password_old'], $user->getPassword())) {
				$form->getElement('password_old')->addError('msg_wrong_old_password');
			}
			//error sum-up
			$errors = $form->getMessages();
			if (!empty($errors)) {
				$this->addErrorMsg($this->translate('msg_form_invalid'));
				return false;
			}

			try {
				$user->setPassword(\Website\Model\Auth::calculateHash($data['password']));
				$user->save();
				$this->addSuccessMsg($this->translate('msg_password_change_successfull'));

				return true;
			} catch (\Exception $e) {
				\Pimcore\Log\Simple::log('exceptions', 'PASSOWORD CHANGE FORM - ' . $e->getMessage() . "\n" . $e->getTraceAsString());
				$this->addErrorMsg($this->translate('msg_unknown_error'));
			}
		} else {
			$this->addErrorMsg($this->translate('msg_form_invalid'));
		}

		return false;
	}

	private function handleProfileForm(\Zend_Form &$form)
	{
		if ($form->isValid($this->getRequest()->getPost())) {
			$data = $form->getValues();

			$user = $this->getCurrentUser();
			$user->setValues($data);
			try {
				$user->save();
			} catch (\Exception $e) {
				\Pimcore\Log\Simple::log('exceptions', 'PROFILE FORM - ' . $e->getMessage() . "\n" . $e->getTraceAsString());
				$this->addErrorMsg($this->translate('msg_unknown_error'));
			}

			$this->addSuccessMsg('msg_profile_changed');

			return true;
		} else {
			$this->addErrorMsg($this->translate('msg_form_invalid'));
		}

		return false;
	}
}
