<?php

namespace Website\Form;

class CartInfoForm extends Base
{
	protected $number;
	protected $shippingAndPaymentTypes;

	public function __construct($shippingAndPaymentTypes)
	{
		$this->shippingAndPaymentTypes = $shippingAndPaymentTypes;
		parent::__construct();
	}

	public function init()
	{
		parent::init();
		$this->setName('cartinfoform');

		//validators
		$conditionDeliveryAddress = new \Website\Form\Validator\FieldDepends('deliveryAddress', 1);

		foreach (array_keys($this->shippingAndPaymentTypes) as $shippingCountry) {
			${'country' . $shippingCountry} = new \Website\Form\Validator\FieldDepends('country', $shippingCountry);
		}

		//@TODO why not used ? problem with multi-level conditional validator maybe ?
		/*
		  $shippingCZPersonal = new \Website\Form\Validator\FieldDepends('shippingTypeCZ', \Website\Model\Order::SHIPPING_PICK_UP);
		  $shippingCZPPL = new \Website\Form\Validator\FieldDepends('shippingTypeCZ', \Website\Model\Order::SHIPPING_CZECH_PPL);
		 *
		 */

		$countries = \Zend_locale::getTranslationList('Territory', $this->getTranslator()->getLocale(), 2);
		$countryMultiOptions = [];
		foreach (array_keys($this->shippingAndPaymentTypes) as $shippingCountry) {
			if (isset($countries[$shippingCountry])) {
				$countryMultiOptions[$shippingCountry] = $countries[$shippingCountry];
			}
		}
		$country = new \Zend_Form_Element_Select('country');
		$country->setRequired(true)
			->setDisableTranslator(true)
			->setLabel($this->getTranslator()->translate('label_choose_country'))
			->addMultiOptions($countryMultiOptions)
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($this->notEmptyValidator);

		//shipping depends on country
		foreach ($this->shippingAndPaymentTypes as $shippingCountry => $shippingAndPaymentSettings) {
			$shippingMultiOptions = [];
			foreach ($shippingAndPaymentSettings as $shippingCode => $shippingSettings) {
				$shippingMultiOptions[$shippingCode] = 'label_' . $shippingCode;
			}
			$shippingType = new \Zend_Form_Element_Radio('shippingType' . $shippingCountry);
			$shippingType->setRequired(false)
				->setAllowEmpty(false)
				->addMultiOptions($shippingMultiOptions)
				->setValue(key($shippingMultiOptions))
				->setLabel('label_shipping_type')
				//->setAttrib('data-label-extension', $shippingSettings['price'])
				->addFilter('StripTags')
				->addFilter('StringTrim')
				->addValidator(${'country' . $shippingCountry});
			$this->addElement($shippingType);

			//payment depends on shipping, which depends on country
			//@TODO fix 2nd level dependend validation
			foreach ($shippingAndPaymentSettings as $shippingCode => $shippingSettings) {
				$paymentMultiOptions = [];
				foreach (array_keys($shippingSettings['paymentPrices']) as $paymentCode) {
					$paymentMultiOptions[$paymentCode] = 'label_' . $paymentCode;
				}
				$paymentType = new \Zend_Form_Element_Radio('paymentType' . $shippingCountry . $shippingCode);
				$paymentType->setRequired(false)
					->setAllowEmpty(true)
					->addMultiOptions($paymentMultiOptions)
					->setValue(key($paymentMultiOptions))
					->setLabel('label_payment_type')
					->addFilter('StripTags')
					->addFilter('StringTrim');
				//->addValidator($shippingCZPersonal);
				$this->addElement($paymentType);
			}
		}


		$firstName = new \Zend_Form_Element_Text('fFirstName');
		$firstName->setRequired(true)
			->setLabel('label_first_name')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($this->notEmptyValidator);

		$lastName = new \Zend_Form_Element_Text('fLastName');
		$lastName->setRequired(true)
			->setLabel('label_last_name')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($this->notEmptyValidator);

		$email = new \Zend_Form_Element_Text('fEmail');
		$email->setRequired(true)
			->setLabel('label_email')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($this->notEmptyValidator)
			->addValidator($this->emailValidator);

		$phone = new \Zend_Form_Element_Text('fPhone');
		$phone->setRequired(true)
			->setLabel('label_phone')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addFilter('PregReplace', ['match' => '/ /', 'replace' => ''])
			->addValidator($this->notEmptyValidator)
			->addValidator($this->phoneValidator);

		$fCompany = new \Zend_Form_Element_Text('fCompany');
		$fCompany->setRequired(false)
			->setLabel('label_company')
			->addFilter('StripTags')
			->addFilter('StringTrim');

		$fIco = new \Zend_Form_Element_Text('fIco');
		$fIco->setRequired(false)
			->setLabel('label_ic')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($this->numberValidator);

		$fDic = new \Zend_Form_Element_Text('fDic');
		$fDic->setRequired(false)
			->setLabel('label_dic')
			->addFilter('StripTags')
			->addFilter('StringTrim');

		$fStreet = new \Zend_Form_Element_Text('fStreet');
		$fStreet->setRequired(true)
			->setLabel('label_street')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($this->notEmptyValidator);

		$fCity = new \Zend_Form_Element_Text('fCity');
		$fCity->setRequired(true)
			->setLabel('label_city')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($this->notEmptyValidator);

		$fZipCode = new \Zend_Form_Element_Text('fZipCode');
		$fZipCode->setRequired(true)
			->setLabel('label_zip_code')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addFilter('PregReplace', ['match' => '/ /', 'replace' => ''])
			->addValidator($this->notEmptyValidator)
			->addValidator($this->zipCodeValidator);

		$deliveryAddress = new \Zend_Form_Element_Checkbox('deliveryAddress');
		$deliveryAddress->setRequired(false)
			->setLabel('label_check_if_delivery_address')
			->setAttrib('disableHidden', true)
			->setValue(0)
			->addFilter('StripTags')
			->addFilter('StringTrim');

		$dCompany = new \Zend_Form_Element_Text('dCompany');
		$dCompany->setRequired(false)
			->setAllowEmpty(true)
			->setLabel('label_company')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($conditionDeliveryAddress);

		$dFirstName = new \Zend_Form_Element_Text('dFirstName');
		$dFirstName->setRequired(false)
			->setAllowEmpty(true)
			->setLabel('label_first_name')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($conditionDeliveryAddress);

		$dLastName = new \Zend_Form_Element_Text('dLastName');
		$dLastName->setRequired(false)
			->setAllowEmpty(true)
			->setLabel('label_last_name')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($conditionDeliveryAddress);

		$dStreet = new \Zend_Form_Element_Text('dStreet');
		$dStreet->setRequired(false)
			->setAllowEmpty(true)
			->setLabel('label_street')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($conditionDeliveryAddress);

		$dCity = new \Zend_Form_Element_Text('dCity');
		$dCity->setRequired(false)
			->setAllowEmpty(true)
			->setLabel('label_city')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($conditionDeliveryAddress);

		$dZipCode = new \Zend_Form_Element_Text('dZipCode');
		$dZipCode->setRequired(false)
			->setAllowEmpty(true)
			->setLabel('label_zip_code')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addFilter('PregReplace', ['match' => '/ /', 'replace' => ''])
			->addValidator($conditionDeliveryAddress)
			->addValidator($this->zipCodeValidator);

		$message = new \Zend_Form_Element_Textarea('message');
		$message->setRequired(false)
			->setLabel('label_message')
			->setAttrib('rows', 5)
			->addFilter('StripTags')
			->addFilter('StringTrim');

		$discountCode = new \Zend_Form_Element_Text('discountCode');
		$discountCode->setRequired(false)
			->setLabel('label_discount_code')
			->addFilter('StripTags')
			->addFilter('StringTrim');

		$csrf = new \Zend_Form_Element_Hash('csrf', ['timeout' => 900]);
		$csrf->setDisableTranslator(true);

		$submit = new \Zend_Form_Element_Submit('send');
		$submit->setLabel('label_order');

		$this->addElements([
			$country,
			$firstName,
			$lastName,
			$email,
			$phone,
			$fCompany,
			$fIco,
			$fDic,
			$fStreet,
			$fCity,
			$fZipCode,
			$deliveryAddress,
			$dCompany,
			$dFirstName,
			$dLastName,
			$dStreet,
			$dCity,
			$dZipCode,
			$message,
			$discountCode,
			$csrf,
			$submit
		]);

		//remove decorators
		$this->setElementDecorators(['ViewHelper']);

		$this->setUpJsValidation();
	}
}
