<?php

namespace Website\Tool\Console\Command;

use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class ElasticReindexCommand extends AbstractCommand
{
	protected function configure()
	{
		$this
			->setName('elastic:reindex')
			->setDescription('Reindex elastic search index')
			->addOption(
				'fulltext', 'f',
				InputOption::VALUE_NONE,
				'Build fulltext index',
				null
			)
			->addOption(
				'objects', 'o',
				InputOption::VALUE_NONE,
				'Build objects index',
				null
			);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		$fulltext = $input->getArgument('fulltext');
		$objects = $input->getArgument('objects');
		if (!$fulltext && !$objects) {
			$fulltext = true;
			$objects = true;
		}
		\Website\Tool\ElasticSearch::$fromCli = true;
		\Website\Tool\ElasticSearch::updateMappingsAndReindex($fulltext, $objects);
	}
}
