<?php
set_time_limit(60000);
include_once(__DIR__ . "/../../../pimcore/cli/startup.php");
$db = Pimcore_Resource_Mysql::get();
$languages = Pimcore_Tool::getValidLanguages();
Pimcore_Model_Cache::clearAll();

fputs(STDOUT, "cache\n");
$db->query("DROP TABLE IF EXISTS `cache`;");
$db->query("CREATE TABLE `cache` (
  `id` varchar(165) NOT NULL DEFAULT '',
  `data` longtext,
  `mtime` bigint(20) DEFAULT NULL,
  `expire` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8;");

fputs(STDOUT, "2695\n");
foreach (['translations_website','translations_admin'] as $type) {
	$db->query('ALTER TABLE ' . $type .' CHANGE `date` `creationDate` BIGINT(20) UNSIGNED NULL DEFAULT NULL');
	$db->query('ALTER TABLE ' . $type .' ADD `modificationDate` BIGINT(20) UNSIGNED NULL DEFAULT NULL');
	$db->query('UPDATE ' . $type .' SET modificationDate = creationDate');
	Translation_Website::clearDependentCache();
}

fputs(STDOUT, "2714\n");
if (!is_dir(PIMCORE_DEPLOYMENT_PACKAGES_DIRECTORY)) {
	mkdir(PIMCORE_DEPLOYMENT_PACKAGES_DIRECTORY, 0755, true);
}

fputs(STDOUT, "2717\n");
$list = new Object_Class_List();
$classes = $list->load();
if (!empty($classes)) {
	foreach ($classes as $class) {
		if ($class->getFielddefinition("localizedfields")) {
			$class->save();
		}
	}
}


fputs(STDOUT, "2718\n");
$list = new Object_Class_List();
$classes = $list->load();
if (!empty($classes)) {
	foreach ($classes as $class) {
		if ($class->getFielddefinition("localizedfields")) {
			$tableName = "object_localized_data_" . $class->getId();

			$cols = $db->fetchRow("SELECT * FROM " . $tableName . " LIMIT 1");
			if (is_array($cols)) {
				$cols = array_keys($cols);
				foreach ($cols as &$col) {
					$col = $db->quoteIdentifier($col);
				}

				foreach ($languages as $language) {
					$tableQueryName = "object_localized_query_" . $class->getId() . "_" . $language;
					try {
						$db->query("INSERT INTO " . $tableQueryName . " (" . implode(",", $cols) . ") SELECT * FROM " . $tableName . " WHERE language = '" . $language . "'");
					} catch (\Exception $e) {
						echo $e->getMessage() . "<br />";
					}
				}
			}
		}
	}
}

fputs(STDOUT, "2721\n");
$db->query("RENAME TABLE `targeting` TO `targeting_rules`;");
$db->query("DROP TABLE IF EXISTS `targeting_personas`;");
$db->query("CREATE TABLE `targeting_personas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `conditions` longtext,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8;");

fputs(STDOUT, "2723\n");
$db->query("ALTER TABLE `documents_page` ADD COLUMN `personas` varchar(255) NULL DEFAULT NULL;");
$db->query("CREATE TABLE `deployment_packages` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `type` VARCHAR(50) NOT NULL,
  `subType` VARCHAR(50) NOT NULL,
  `creationDate` BIGINT(20) NOT NULL,
  `version` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8;");
$db->query("CREATE TABLE `deployment_target` (
  `id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `parentId` BIGINT(20) UNSIGNED NOT NULL DEFAULT '0',
  `name` VARCHAR(255) NOT NULL,
  `creationDate` BIGINT(20) UNSIGNED NOT NULL,
  `status` VARCHAR(50) NOT NULL,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8;");

fputs(STDOUT, "2740\n");
$db->query("DROP TABLE IF EXISTS `cache`;");
$db->query("CREATE TABLE `cache` (
  `id` varchar(165) NOT NULL DEFAULT '',
  `data` longtext,
  `mtime` bigint(20) DEFAULT NULL,
  `expire` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8;");

fputs(STDOUT, "2794\n");
$db->query("CREATE TABLE IF NOT EXISTS `uuids` (
  `uuid` CHAR(36) NOT NULL,
  `itemId` BIGINT(20) UNSIGNED NOT NULL,
  `type` VARCHAR(25) NOT NULL,
  `subType` VARCHAR(20) NULL DEFAULT NULL,
  `instanceIdentifier` VARCHAR(50) NOT NULL,
  UNIQUE INDEX `itemId_type_uuid` (`itemId`, `type`, `uuid`)
) DEFAULT CHARSET=utf8;");

fputs(STDOUT, "2808\n");
User_Permission_Definition::create('deployment');

fputs(STDOUT, "2817\n");
$db->query("ALTER TABLE `uuids` DROP COLUMN `subType`;");

fputs(STDOUT, "2821\n");
$db->query("DROP TABLE IF EXISTS `session`;");
$db->query("CREATE TABLE `session` (
  `id` char(32) NOT NULL DEFAULT '',
  `modified` int(11) DEFAULT NULL,
  `lifetime` int(11) DEFAULT NULL,
  `data` text,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8;");

fputs(STDOUT, "2824\n");
$db->query("DROP TABLE IF EXISTS `session`;");

fputs(STDOUT, "2857\n");
$dir = PIMCORE_DOCUMENT_ROOT . "/PIMCORE_DEPLOYMENT_DIRECTORY";
if (is_dir($dir)) {
	recursiveDelete($dir);
}

fputs(STDOUT, "2860\n");
$dir = PIMCORE_DOCUMENT_ROOT . "/PIMCORE_DEPLOYMENT_DIRECTORY";
$dir = PIMCORE_DOCUMENT_ROOT . "/PIMCORE_DEPLOYMENT_PACKAGES_DIRECTORY";
if (is_dir($dir)) {
	recursiveDelete($dir);
}

fputs(STDOUT, "2893\n");
$db->query("ALTER TABLE `targeting_personas` ADD COLUMN `threshold` int(11) NULL DEFAULT NULL;");

fputs(STDOUT, "2908\n");
$db->query("ALTER TABLE `keyvalue_keys` CHANGE COLUMN `type` `type` ENUM('bool','number','select','text','translated') NULL DEFAULT NULL AFTER `description`;");

Pimcore_Model_Cache::clearAll();
fputs(STDOUT, "done\n");
