<?php
set_time_limit(60000);
include_once(__DIR__ . "/../../../pimcore/cli/startup.php");
\Pimcore\Cache::clearAll();


fputs(STDOUT, "3615 - preupdate\n");
$files = ["extensions","customviews","customviews_extension","reports","system"];
foreach ($files as $fileName) {
	$xmlFile = \Pimcore\Config::locateConfigFile($fileName . ".xml");
	if (file_exists($xmlFile)) {
		$phpFile = \Pimcore\Config::locateConfigFile($fileName . ".php");
		try {
			try {
				$contents = $config->toArray();
				$config = new \Zend_Config_Xml($xmlFile);
			} catch (\Exception $e) {
				continue;
			}
			$contents = $config->toArray();
			if (!is_writable(dirname($phpFile))) {
				throw new \Exception($phpFile . " is not writable");
			}
			if ($fileName == "customviews" || $fileName == "customviews_extension") {
				$cvData = [];
				if (isset($contents["views"]["view"][0])) {
					$cvData = $contents["views"]["view"];
				} else {
					$cvData[] = $contents["views"]["view"];
				}
				if ($fileName == "customviews_extension") {
					foreach ($cvData as $key => $struct) {
						if (isset($struct['extension'])) {
							if (isset($struct['extension']['path'])) {
								$cvData[$key]['extensions'] = [$struct['extension']];
							} else {
								$cvData[$key]['extensions'] = $struct['extension'];
							}
							unset($cvData[$key]['extension']);
						}
					}
				}
				$contents = [
					"views" => $cvData
				];
			}
			$contents = var_export_pretty($contents);
			$phpContents = "<?php \n\nreturn " . $contents . ";\n";
			\Pimcore\File::put($phpFile, $phpContents);
		} catch (\Exception $e) {
			\Logger::crit($e);
			\Zend_Debug::dump($e->getTraceAsString());
			echo "<b>Critical ERROR!</b><br />";
			echo $e->getMessage();
			echo "<br />Please try to fix it an run the update again.";
			exit;
		}
	}
}

$db = \Pimcore\Db::get();

fputs(STDOUT, "3604\n");
$file = \Pimcore\Config::locateConfigFile("staticroutes.json");
$db = \Pimcore\Db::get();
$staticRoutes = $db->fetchAll("SELECT * FROM staticroutes");
$json = \JsonFileTable::get($file);
$json->truncate();
foreach ($staticRoutes as $route) {
	$data = $route;
	unset($data["id"]);
	$json->insertOrUpdate($data, $route["id"]);
}
$db->query("RENAME TABLE `staticroutes` TO `PLEASE_DELETE__staticroutes`;");

fputs(STDOUT, "3606\n");
// DOCUMENT TYPES
$file = \Pimcore\Config::locateConfigFile("document-types.json");
$db = \Pimcore\Db::get();
$staticRoutes = $db->fetchAll("SELECT * FROM documents_doctypes");
$json = \JsonFileTable::get($file);
$json->truncate();
foreach ($staticRoutes as $route) {
	$data = $route;
	unset($data["id"]);
	$json->insertOrUpdate($data, $route["id"]);
}
$db->query("RENAME TABLE `documents_doctypes` TO `PLEASE_DELETE__documents_doctypes`;");
// PREDEFINED PROPERTIES
$file = \Pimcore\Config::locateConfigFile("predefined-properties.json");
$db = \Pimcore\Db::get();
$staticRoutes = $db->fetchAll("SELECT * FROM properties_predefined");
$json = \JsonFileTable::get($file);
$json->truncate();
foreach ($staticRoutes as $route) {
	$data = $route;
	unset($data["id"]);
	$json->insertOrUpdate($data, $route["id"]);
}
$db->query("RENAME TABLE `properties_predefined` TO `PLEASE_DELETE__properties_predefined`;");
// PREDEFINED PROPERTIES
$file = \Pimcore\Config::locateConfigFile("predefined-asset-metadata.json");
$db = \Pimcore\Db::get();
$staticRoutes = $db->fetchAll("SELECT * FROM assets_metadata_predefined");
$json = \JsonFileTable::get($file);
$json->truncate();
foreach ($staticRoutes as $route) {
	$data = $route;
	unset($data["id"]);
	$json->insertOrUpdate($data, $route["id"]);
}
$db->query("RENAME TABLE `assets_metadata_predefined` TO `PLEASE_DELETE__assets_metadata_predefined`;");

fputs(STDOUT, "3608 - preupdate\n");
// create legacy config folder
$legacyFolder = PIMCORE_CONFIGURATION_DIRECTORY . "/LEGACY";
if (!is_dir($legacyFolder)) {
	mkdir($legacyFolder, 0777, true);
}
// IMAGE THUMBNAILS
$dir = PIMCORE_CONFIGURATION_DIRECTORY . "/imagepipelines";
if (is_dir($dir)) {
	$file = \Pimcore\Config::locateConfigFile("image-thumbnails.json");
	$json = \JsonFileTable::get($file);
	$json->truncate();
	$files = scandir($dir);
	foreach ($files as $file) {
		if (strpos($file, ".xml")) {
			$config = new \Zend_Config_Xml($dir . '/' .$file);
			//$name = str_replace(".xml", "", $file);
			//$thumbnail = \Pimcore\Model\Asset\Image\Thumbnail\Config::getByName($name);
			//$thumbnail = object2array($thumbnail);
			$thumbnail = $config->toArray();
			if (isset($thumbnail['items'])) {
				$thumbnail['items'] = array_values($thumbnail['items']);
			}
			$thumbnail["id"] = $thumbnail["name"];
			unset($thumbnail["name"]);
			$json->insertOrUpdate($thumbnail, $thumbnail["id"]);
		}
	}
	// move data
	rename($dir, $legacyFolder . "/imagepipelines");
}
// VIDEO THUMBNAILS
$dir = PIMCORE_CONFIGURATION_DIRECTORY . "/videopipelines";
if (is_dir($dir)) {
	$file = \Pimcore\Config::locateConfigFile("video-thumbnails.json");
	$json = \JsonFileTable::get($file);
	$json->truncate();
	$files = scandir($dir);
	foreach ($files as $file) {
		if (strpos($file, ".xml")) {
			$name = str_replace(".xml", "", $file);
			$thumbnail = \Pimcore\Model\Asset\Video\Thumbnail\Config::getByName($name);
			$thumbnail = object2array($thumbnail);
			$thumbnail["id"] = $thumbnail["name"];
			unset($thumbnail["name"]);
			$json->insertOrUpdate($thumbnail, $thumbnail["id"]);
		}
	}
	// move data
	rename($dir, $legacyFolder . "/videopipelines");
}

fputs(STDOUT, "3609 - preupdate\n");
// create legacy config folder
$legacyFolder = PIMCORE_CONFIGURATION_DIRECTORY . "/LEGACY";
if (!is_dir($legacyFolder)) {
	mkdir($legacyFolder, 0777, true);
}
// NEWSLETTER
$dir = PIMCORE_CONFIGURATION_DIRECTORY . "/newsletter";
if (is_dir($dir)) {
	$file = \Pimcore\Config::locateConfigFile("newsletter.json");
	$json = \JsonFileTable::get($file);
	$json->truncate();
	$files = scandir($dir);
	foreach ($files as $file) {
		if (strpos($file, ".xml")) {
			$name = str_replace(".xml", "", $file);
			$thumbnail = \Pimcore\Model\Tool\Newsletter\Config::getByName($name);
			$thumbnail = object2array($thumbnail);
			$thumbnail["id"] = $thumbnail["name"];
			unset($thumbnail["name"]);
			$json->insertOrUpdate($thumbnail, $thumbnail["id"]);
		}
	}
	// move data
	rename($dir, $legacyFolder . "/newsletter");
}
// TAG SNIPPET MANAGEMENT
$dir = PIMCORE_CONFIGURATION_DIRECTORY . "/tags";
if (is_dir($dir)) {
	$file = \Pimcore\Config::locateConfigFile("tag-manager.json");
	$json = \JsonFileTable::get($file);
	$json->truncate();
	$files = scandir($dir);
	foreach ($files as $file) {
		if (strpos($file, ".xml")) {
			$name = str_replace(".xml", "", $file);
			$thumbnail = \Pimcore\Model\Tool\Tag\Config::getByName($name);
			$thumbnail = object2array($thumbnail);
			$thumbnail["id"] = $thumbnail["name"];
			unset($thumbnail["name"]);
			$json->insertOrUpdate($thumbnail, $thumbnail["id"]);
		}
	}
	// move data
	rename($dir, $legacyFolder . "/tags");
}

fputs(STDOUT, "3610 - preupdate\n");
// create legacy config folder
$legacyFolder = PIMCORE_CONFIGURATION_DIRECTORY . "/LEGACY";
if (!is_dir($legacyFolder)) {
	mkdir($legacyFolder, 0777, true);
}
// QR-CODES
$dir = PIMCORE_CONFIGURATION_DIRECTORY . "/qrcodes";
if (is_dir($dir)) {
	$file = \Pimcore\Config::locateConfigFile("qrcode.json");
	$json = \JsonFileTable::get($file);
	$json->truncate();
	$files = scandir($dir);
	foreach ($files as $file) {
		if (strpos($file, ".xml")) {
			$name = str_replace(".xml", "", $file);
			$thumbnail = \Pimcore\Model\Tool\Qrcode\Config::getByName($name);
			$thumbnail = object2array($thumbnail);
			$thumbnail["id"] = $thumbnail["name"];
			unset($thumbnail["name"]);
			$json->insertOrUpdate($thumbnail, $thumbnail["id"]);
		}
	}
	// move data
	rename($dir, $legacyFolder . "/qrcodes");
}
// SQL REPORTS
$dir = PIMCORE_CONFIGURATION_DIRECTORY . "/sqlreport";
if (is_dir($dir)) {
	$file = \Pimcore\Config::locateConfigFile("custom-reports.json");
	$json = \JsonFileTable::get($file);
	$json->truncate();
	$files = scandir($dir);
	foreach ($files as $file) {
		if (strpos($file, ".xml")) {
			$name = str_replace(".xml", "", $file);
			$thumbnail = \Pimcore\Model\Tool\CustomReport\Config::getByName($name);
			$thumbnail = object2array($thumbnail);
			$thumbnail["id"] = $thumbnail["name"];
			unset($thumbnail["name"]);
			$json->insertOrUpdate($thumbnail, $thumbnail["id"]);
		}
	}
	// move data
	rename($dir, $legacyFolder . "/sqlreport");
}

fputs(STDOUT, "3611\n");
\Pimcore\Cache::disable();
$customCacheFile = PIMCORE_CONFIGURATION_DIRECTORY . "/cache.xml";
// create legacy config folder
$legacyFolder = PIMCORE_CONFIGURATION_DIRECTORY . "/LEGACY";
if (!is_dir($legacyFolder)) {
	mkdir($legacyFolder, 0777, true);
}
if (file_exists($customCacheFile)) {
	try {
		$conf = new \Zend_Config_Xml($customCacheFile);
		$arrayConf = $conf->toArray();
		$content = json_encode($arrayConf);
		$content = \Zend_Json::prettyPrint($content);
		$jsonFile = \Pimcore\Config::locateConfigFile("cache.json");
		file_put_contents($jsonFile, $content);
		rename($customCacheFile, $legacyFolder . "/cache.xml");
	} catch (\Exception $e) {
	}
}

fputs(STDOUT, "3612\n");
// create legacy config folder
$legacyFolder = PIMCORE_CONFIGURATION_DIRECTORY . "/LEGACY";
if (!is_dir($legacyFolder)) {
	mkdir($legacyFolder, 0777, true);
}
$mappingFile = PIMCORE_CONFIGURATION_DIRECTORY . "/classmap.xml";
if (file_exists($mappingFile)) {
	try {
		$conf = new \Zend_Config_Xml($mappingFile);
		$arrayConf = $conf->toArray();
		$newConf = [];
		foreach ($arrayConf as $key => $value) {
			$newKey = str_replace("_", "\\", $key);
			$newConf[$newKey] = $value;
		}
		$content = json_encode($newConf);
		$content = \Zend_Json::prettyPrint($content);
		$jsonFile = \Pimcore\Config::locateConfigFile("classmap.json");
		file_put_contents($jsonFile, $content);
		rename($mappingFile, $legacyFolder . "/classmap.xml");
	} catch (\Exception $e) {
	}
}

fputs(STDOUT, "3614 - preupdate\n");
$configNames = ["document-types","image-thumbnails","newsletter", "predefined-asset-metadata", "custom-reports",
	"predefined-properties","qrcode","staticroutes","tag-manager","video-thumbnails","cache","classmap"];
foreach ($configNames as $configName) {
	$jsonFile = \Pimcore\Config::locateConfigFile($configName . ".json");
	if (file_exists($jsonFile)) {
		$phpFile = \Pimcore\Config::locateConfigFile($configName . ".php");
		$contents = file_get_contents($jsonFile);
		$contents = json_decode($contents, true);
		$contents = var_export_pretty($contents);
		$phpContents = "<?php \n\nreturn " . $contents . ";\n";
		\Pimcore\File::put($phpFile, $phpContents);
	}
}

fputs(STDOUT, "3614\n");
// create legacy config folder
$legacyFolder = PIMCORE_CONFIGURATION_DIRECTORY . "/LEGACY";
if (!is_dir($legacyFolder)) {
	mkdir($legacyFolder, 0777, true);
}
$configNames = ["document-types","image-thumbnails","newsletter", "predefined-asset-metadata", "custom-reports",
	"predefined-properties","qrcode","staticroutes","tag-manager","video-thumbnails","cache","classmap"];
foreach ($configNames as $configName) {
	$jsonFile = \Pimcore\Config::locateConfigFile($configName . ".json");
	if (file_exists($jsonFile)) {
		rename($jsonFile, $legacyFolder . "/" . basename($jsonFile));
	}
}

fputs(STDOUT, "3615\n");
// create legacy config folder
$legacyFolder = PIMCORE_CONFIGURATION_DIRECTORY . "/LEGACY";
if (!is_dir($legacyFolder)) {
	mkdir($legacyFolder, 0777, true);
}
$files = ["extensions","customviews","customviews_extension","reports","system"];
foreach ($files as $fileName) {
	$xmlFile = \Pimcore\Config::locateConfigFile($fileName . ".xml");
	if (file_exists($xmlFile)) {
		rename($xmlFile, $legacyFolder . "/" . basename($xmlFile));
	}
}

fputs(STDOUT, "3620\n");
// get db connection
try {
	$db->query("ALTER TABLE `classificationstore_keys`
		ADD COLUMN `title` VARCHAR(255) NOT NULL DEFAULT '' AFTER `name`,
		ADD INDEX `name` (`name`),
		ADD INDEX `enabled` (`enabled`),
		ADD INDEX `type` (`type`);
	");
} catch (\Exception $e) {
}


\Pimcore\Cache::clearAll();
fputs(STDOUT, "done\n");







class JsonFileTable
{
	protected static $tables = [];
	protected $filePath;
	protected $data = [];
	protected $lastInsertId;

	/**
	 * @param $filePath
	 * @return self
	 */
	public static function get($filePath)
	{
		if (!isset(self::$tables[$filePath])) {
			self::$tables[$filePath] = new self($filePath);
		}

		return self::$tables[$filePath];
	}

	/**
	 * JsonFileTable constructor.
	 * @param string $filePath
	 */
	public function __construct($filePath = null)
	{
		if ($filePath) {
			$this->setFilePath($filePath);
		}
	}

	/**
	 * @param $filePath
	 * @throws \Exception
	 */
	public function setFilePath($filePath)
	{
		$writeable = false;

		if (file_exists($filePath) && is_writeable($filePath)) {
			$writeable = true;
		} elseif (!file_exists($filePath)) {
			if (is_writeable(dirname($filePath))) {
				$writeable = true;
			}
		}

		if ($writeable) {
			$this->filePath = $filePath;

			$this->load();
		} else {
			throw new \Exception($filePath . " is not writeable");
		}
	}

	/**
	 * @param $data
	 * @param string|int $id
	 * @throws \Exception
	 */
	public function insertOrUpdate($data, $id = null)
	{
		if (!$id) {
			$id = $this->getNextId();
		}

		$data["id"] = $id;
		$this->data[$id] = $data;

		$this->save();
		$this->lastInsertId = $id;
	}

	/**
	 * @param string|int $id
	 */
	public function delete($id)
	{
		if (isset($this->data[$id])) {
			unset($this->data[$id]);
			$this->save();
		}
	}

	/**
	 * @param string|int $id
	 * @return array|null
	 */
	public function getById($id)
	{
		if (isset($this->data[$id])) {
			return $this->data[$id];
		}

		return null;
	}

	/**
	 * @param null $filter
	 * @param null $order
	 * @return array
	 */
	public function fetchAll($filter = null, $order = null)
	{
		$data = $this->data;

		if (is_callable($filter)) {
			$filteredData = [];
			foreach ($data as $row) {
				if ($filter($row)) {
					$filteredData[] = $row;
				}
			}

			$data = $filteredData;
		}

		if (is_callable($order)) {
			usort($data, $order);
		}

		return $data;
	}

	/**
	 * @return int
	 */
	public function getNextId()
	{
		$ids = array_keys($this->data);
		if (count($ids)) {
			$id = max($ids) + 1;
			return $id;
		}

		return 1;
	}

	/**
	 * @return int
	 */
	public function getLastInsertId()
	{
		return $this->lastInsertId;
	}

	/**
	 *
	 */
	public function truncate()
	{
		$this->data = [];
		$this->save();
	}

	/**
	 *
	 */
	protected function load()
	{
		if (file_exists($this->filePath)) {
			$contents = file_get_contents($this->filePath);
			$data = @json_decode($contents, true);
			if (is_array($data)) {
				$this->data = $data;
			}
		}
	}

	/**
	 *
	 */
	protected function save()
	{
		$contents = json_encode($this->data);
		$contents = \Zend_Json::prettyPrint($contents);
		\Pimcore\File::put($this->filePath, $contents);
	}
}
