<?php
set_time_limit(60000);
include_once(__DIR__ . "/../../../pimcore/cli/startup.php");
\Pimcore\Cache::clearAll();

$db = \Pimcore\Db::get();

fputs(STDOUT, "3642\n");
$tables = $db->fetchAll("SHOW TABLES LIKE 'object_classificationstore_data_%'");
foreach ($tables as $table) {
	$t = current($table);
	$db->query("ALTER TABLE `" . $t . "`
			ADD INDEX `o_id` (`o_id`),
			ADD INDEX `groupId` (`groupId`),
			ADD INDEX `keyId` (`keyId`),
			ADD INDEX `fieldname` (`fieldname`),
			ADD INDEX `language` (`language`);
	");
}


fputs(STDOUT, "3643\n");
$tables = $db->fetchAll("SHOW TABLES LIKE 'object_classificationstore_data_%'");
foreach ($tables as $table) {
	$t = current($table);
	$db->query("ALTER TABLE `" . $t . "`
			ADD COLUMN `value2` LONGTEXT NULL AFTER `value`;
	");
}


fputs(STDOUT, "3644\n");
$tables = $db->fetchAll("SHOW TABLES LIKE 'object_classificationstore_data_%'");
foreach ($tables as $table) {
	$t = current($table);
	// migrate the quantity value records
	$db->query("UPDATE `" . $t . "`
		set value2 = TRIM(BOTH '\"' FROM SUBSTRING_INDEX(SUBSTRING_INDEX(value,';',4),':',-1)), value = TRIM(BOTH '\"' FROM SUBSTRING_INDEX(SUBSTRING_INDEX(value,';',2),':',-1)) where type = 'quantityValue';
	");
}


fputs(STDOUT, "3645\n");
$tables = $db->query("ALTER TABLE documents_elements CHANGE COLUMN `name` `name` varchar(750) CHARACTER SET ascii DEFAULT '';");


fputs(STDOUT, "3651\n");
$tables = $db->query("ALTER TABLE documents_elements CHANGE COLUMN `name` `name` varchar(750) CHARACTER SET ascii DEFAULT '';");


fputs(STDOUT, "3660\n");
$tables = $db->query("CREATE TABLE `documents_translations` (
  `id` int(11) unsigned NOT NULL DEFAULT '0',
  `sourceId` int(11) unsigned NOT NULL DEFAULT '0',
  `language` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`sourceId`,`language`),
  KEY `id` (`id`),
  KEY `sourceId` (`sourceId`),
  KEY `language` (`language`)
) DEFAULT CHARSET=utf8;");
$tables = $db->fetchAll("SHOW TABLES LIKE 'object_classificationstore_groups_%'");
foreach ($tables as $table) {
	$t = current($table);
	// migrate the quantity value records
	$db->query("ALTER TABLE `" . $t . "`
		ADD INDEX `o_id` (`o_id`);
	");
}


fputs(STDOUT, "3662\n");
\Pimcore\Config::setFlag("useZendDate", true);


fputs(STDOUT, "3664\n");
$tables = $db->fetchAll("SHOW TABLES LIKE 'object_metadata_%'");
foreach ($tables as $table) {
	$t = current($table);
	// migrate the quantity value records
	$db->query("ALTER TABLE `" . $t . "` DROP PRIMARY KEY, ADD PRIMARY KEY (`o_id`, `dest_id`, `type`, `fieldname`, `column`, `ownertype`, `ownername`, `position`);");
}


fputs(STDOUT, "3667\n");
// update .htaccess to the latest version if not changed manually
$htaccessFile = PIMCORE_DOCUMENT_ROOT . "/.htaccess";
$currentFileMd5 = md5_file($htaccessFile);
// old standard md5's
$defaultMd5s = [
	"64fcf5d7266000f01ed7c64e4793b407",
	"bdf1652ff1c76d0251d8f4afe73d1e0f",
	"e769830d7e4f2d7b79481237052df0ec",
	"cc05bacbc951d4afc1224ec3a4191bbd",
	"6375537320664103ff1d9b1f22852b63",
	"254fc7e808732c5bd3008b92ebce8cae",
	"42c4974dff95764f3cf0e5b7a6e8df0d",
	"18fede900eb01b921a522b7e80a61bfd",
	"2716d910eef4ff1e887b4fc8bc865f7d",
	"e173dc2b9c278baa8e6bb3fca4676e23",
	"1dc23f9666512f20743e718b7e54fed9",
	"5f8d678fdc15a4552d8d3c99d657b844",
	"5c5a899c5c5b190300764b75f2492aef",
	"9c22252dc36769323ab15c036c055afa",
	"1c656a396801827236a3af3c63638070",
	"0bdde18a3484599a9b9ae4a42ee6d1f8",
];
if (in_array($currentFileMd5, $defaultMd5s)) {
	// this instance is using a default .htaccess, so we can update it
	$oldData = file_get_contents($htaccessFile);
	$data = \Pimcore\Tool::getHttpData("https://raw.githubusercontent.com/pimcore/pimcore/1bf36b865bc47cf88ead0fc401161f3782f5de07/.htaccess");
	if (strpos($data, "RewriteEngine On")) { // check for a certain string in the content, that has to be in the file
		file_put_contents($htaccessFile, $data);
		if (md5_file($htaccessFile) != "93c9ae0d2211a46db278bdfe5011fff2") {
			// something went wrong, write back the old contents
			file_put_contents($htaccessFile, $oldData);
		}
	}
}


fputs(STDOUT, "3689\n");
$db->query("ALTER TABLE `classificationstore_relations` ADD INDEX `groupId` (`groupId`);");
$db->query("ALTER TABLE `classificationstore_collectionrelations` ADD INDEX `colId` (`colId`);");


fputs(STDOUT, "3690\n");
$db->query("ALTER TABLE `classificationstore_relations` ALTER `sorter` DROP DEFAULT;");
$db->query("ALTER TABLE `classificationstore_relations` CHANGE COLUMN `sorter` `sorter` INT(11) NULL AFTER `keyId`;");


fputs(STDOUT, "3710\n");
$db->query("DROP TABLE IF EXISTS `classificationstore_stores`;");
$db->query("CREATE TABLE `classificationstore_stores` (
	`id` INT(11) NOT NULL AUTO_INCREMENT,
	`name` VARCHAR(255) NULL DEFAULT NULL,
	`description` LONGTEXT NULL,
	PRIMARY KEY (`id`),
	INDEX `name` (`name`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
;
");
$db->query("INSERT INTO `classificationstore_stores` (`id`, `name`, `description`) VALUES (1, 'Default', 'Default Store');");
$db->query("ALTER TABLE `classificationstore_keys`
	ADD COLUMN `storeId` INT NULL DEFAULT NULL AFTER `id`,
	ADD INDEX `storeId` (`storeId`);
");
$db->query("ALTER TABLE `classificationstore_groups`
	ADD COLUMN `storeId` INT NULL DEFAULT NULL AFTER `id`,
	ADD INDEX `storeId` (`storeId`);
");
$db->query("ALTER TABLE `classificationstore_collections`
	ADD COLUMN `storeId` INT NULL DEFAULT NULL AFTER `id`,
	ADD INDEX `storeId` (`storeId`);
");
$db->query("UPDATE classificationstore_keys set storeId = 1");
$db->query("UPDATE classificationstore_groups set storeId = 1");
$db->query("UPDATE classificationstore_collections set storeId = 1");


fputs(STDOUT, "3719\n");
$db->query("ALTER TABLE `users`
	ADD COLUMN `activePerspective` VARCHAR(255) NULL DEFAULT NULL AFTER `apiKey`,
	ADD COLUMN `perspectives` LONGTEXT NULL DEFAULT NULL AFTER `activePerspective`;
");


fputs(STDOUT, "3730\n");
$db->query("ALTER TABLE `classificationstore_keys` CHANGE `type` `type` VARCHAR(255) NULL DEFAULT NULL;");


fputs(STDOUT, "3739\n");
$columns = $db->fetchAll("SHOW COLUMNS FROM documents_page");
foreach ($columns as $column) {
	if ($column["Field"] == "css") {
		$db->query("ALTER TABLE documents_page DROP COLUMN `css`;");
	}
}


\Pimcore\Cache::clearAll();
fputs(STDOUT, "done\n");
