<?php

namespace Website\View\Helper;

class ShippingDiscountInfo extends \Zend_View_Helper_Abstract
{

	public $view;

	protected function _run()
	{
		
	}

	/**
	 * 
	 * @param array $steps - array returned from \Website\Model\OrderManager::getShippingDiscountSteps
	 * @return string
	 */
	public function shippingDiscountInfo($steps, $productsPrice)
	{
		$output = '';
		list($current, $next) = $steps;

		if ($current) {
			if ($current['ispercentual']) {
				$output .= sprintf('<p class="text-success">' . $this->view->enc($this->view->translate('msg_shipping_discount_current_percentual')) . '</p>', $current['discount']);
			} else {
				$output .= sprintf('<p class="text-success">' . $this->view->enc($this->view->translate('msg_shipping_discount_current')) . '</p>', $this->view->localizeCurrency($current['discount'], true));
			}
		}

		if ($next) {
			$toGo = $this->view->localizeCurrency($next['price'] - $productsPrice, true);
			if ($next['ispercentual']) {
				$output .= sprintf('<p class="text-info">' . $this->view->enc($this->view->translate('msg_shipping_discount_next_percentual')) . '</p>', $toGo, $next['discount']);
			} else {
				$output .= sprintf('<p class="text-info">' . $this->view->enc($this->view->translate('msg_shipping_discount_next')) . '</p>', $toGo, $this->view->localizeCurrency($next['discount'], true));
			}
		}

		return $output;
	}

	public function setView(\Zend_View_Interface $view)
	{
		parent::setView($view);

		$this->view = $view;
	}

}
