<div>
	<div style="text-align: right; border-bottom: 2px solid #000000; color: #1A5DAC; font-weight: bold; font-size: 20px;">
		<?=($this->isCreditNote) ? 'Dobropis č. ' : 'Faktura č. ' ?>
		<?=($this->isCreditNote) ? $this->order->getCreditNoteId() : $this->order->getInvoiceId();?>
	</div>

	<table>
		<tr>
			<td width="40%">
				<span style="color: #1A5DAC; font-weight: bold; font-size: 12px;">Dodavatel:</span>
				<table style="font-weight: bold; margin-bottom: 15px;">
					<tr>
						<td><?= $this->settings->getSupplierName(); ?></td>
					</tr>
					<tr>
						<td><?= $this->settings->getSupplierStreet(); ?></td>
					</tr>
					<tr>
						<td><?= $this->settings->getSupplierCity(); ?>, <?= $this->settings->getSupplierZip(); ?></td>
					</tr>
				</table>

				<table style="color: #1A5DAC; margin-bottom: 15px;">
					<?
						$ic = $this->settings->getSupplierIco();
						$dic = $this->settings->getSupplierDic();
					?>
					<? if (!empty($ic)): ?>
						<tr>
							<td>IČ:</td>
							<td><?= $ic; ?></td>
						</tr>
					<? endif; ?>
					<? if (!empty($dic) && $this->order->getIsTaxPayer()): ?>
						<tr>
							<td>DIČ:</td>
							<td><?= $dic; ?></td>
						</tr>
					<? endif; ?>
				</table>

				<table style="width: 100%; margin-bottom: 15px;">
					<tr>
						<td>Číslo účtu:</td>
						<td style="text-align: center; border: 3px solid #000000; font-weight: bold" width="220"><?= $this->settings->getSupplierAccountNumber(); ?></td>
					</tr>
				</table>

				<table style="width: 100%;">
					<tr>
						<td>Forma úhrady:</td>
						<td style="text-align: center;"><?=$this->translate('label_'.$this->order->getPaymentType());?></td>
					</tr>
					<?
						if ($this->isCreditNote) {
							$issuedOn = $this->order->getCnIssuedOn();
							$dueTo = $this->order->getCnDueTo();
						} else {
							$issuedOn = $this->order->getIssuedOn();
							$dueTo = $this->order->getDueTo();
						}
						if (!$issuedOn) {
							$issuedOn = time();
						} else {
							$issuedOn = $issuedOn->getTimestamp() + 60*60;//bulgarian constant
						}
						if(!$dueTo) {
							$dueTo = time() + 60*60*24*10;
						} else {
							$dueTo = $dueTo->getTimestamp() + 60*60;//bulgarian constant
						}
					?>
					<tr>
						<td>Datum vystavení:</td>
						<td style="text-align: center;"><?=date('j.n.Y', $issuedOn);?></td>
					</tr>
					<tr>
						<td>Datum splatnosti:</td>
						<td style="text-align: center;"><?=date('j.n.Y', $dueTo);?></td>
					</tr>
					<?if($this->order->getIsTaxPayer()):?>
						<?if($this->isCreditNote):?>
							<tr>
								<td colspan="2">Datum UZP je datum převzetí dokladu.</td>
							</tr>
						<?else:?>
							<tr>
								<td>Datum uskutečnění zdanitelného plnění:</td>
								<td style="text-align: center;"><?=date('j.n.Y', $issuedOn);?></td>
							</tr>
						<?endif;?>
					<?else:?>
						<tr>
							<td colspan="2">Tento doklad není DPH dokladem.</td>
						</tr>
					<?endif;?>
					<?if($this->isCreditNote):?>
						<tr><td colspan="2">&nbsp;</td></tr>
						<tr>
							<td colspan="2">Dobropis k dokladu Faktura č. <?=$this->order->getInvoiceId();?></td>
						</tr>
					<?endif;?>
				</table>
			</td>
			<td width="60%" align="right">
				<table style="margin-bottom: 15px;">
					<tr>
						<td style="text-align: right;">Variabilní symbol:</td>
						<td style="text-align: center;"><?=$this->order->getOrderId();?></td>
					</tr>
				</table>

				<table style="border: 3px solid #000000;">
					<tr>
						<td width="350">
							<span style="color: #1A5DAC; font-weight: bold; font-size: 12px;">Odběratel:</span>
							<table style="margin-bottom: 15px;">
								<?
									$ic = $this->order->getFIco();
									$dic = $this->order->getFDic();
								?>
								<?if(!empty($ic)):?>
									<tr>
										<td>IČ:</td>
										<td><?=$ic;?></td>
									</tr>
								<?endif;?>
								<?if(!empty($dic)):?>
									<tr>
										<td>DIČ:</td>
										<td><?=$dic;?></td>
									</tr>
								<?endif;?>
							</table>

							<table style="font-weight: bold; margin-bottom: 15px;">
								<?
									$company = $this->order->getFCompany();
									$name = $this->order->getFFirstName().' '.$this->order->getFLastName();
									if(!empty($company)) {
										$name = $company.' ('.$name.')';
									}
								?>
								<tr>
									<td><?=$name;?></td>
								</tr>
								<tr>
									<td><?=$this->order->getFStreet();?></td>
								</tr>
								<tr>
									<td><?=$this->order->getFCity();?>, <?=$this->order->getFZipCode();?></td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
	<?
		//crunch the numbers
		$locale = $this->order->getCurrency();
		$currencyOptions = $this->currencyModel->getCurrencyOptions($locale);
		if ($this->order->getIsTaxPayer()) {
			$currencyOptions['precision'] = 2;
		}
		$currency = new \Zend_Currency($currencyOptions, $locale);
		$shippingPrice = $this->order->getBaseShippingPrice();
		$paymentPrice = $this->order->getBasePaymentPrice();
		$discount = min([$this->order->getProductsPrice(), $this->order->getProductsDiscount()]) + $this->order->getShippingDiscount() + $this->order->getPaymentDiscount();
		$cnReturnWholeOrder = true;

		//products
		$invoice = ['items' => [], 'finalPrice' => 0, 'finalPriceWithoutVat' => 0];
		foreach($this->order->getProducts() as $product) {
			if ($product->getCount() > $product->getReturned()) {
				$cnReturnWholeOrder = false;
			}
			$count = ($this->isCreditNote) ? $product->getReturned() : $product->getCount();
			if (!$count) continue; # happens on credit-notes
			$vat = $product->getVat();
			$priceForOne = $product->getPrice();
			$priceForOneWithoutVat = $priceForOne / (100 + $product->getVat()) * 100;
			$price = $product->getPrice() * $count;
			$priceWithoutVat = $price / (100 + $vat) * 100;
			$invoice['items'][] = [
				'name' => $product->getName(),
				'count' => $count,
				'priceForOneWithoutVat' => $currency->setValue($priceForOneWithoutVat)->toCurrency(),
				'priceForOne' => $currency->setValue($priceForOne)->toCurrency(),
				'priceWithoutVat' => $currency->setValue($priceWithoutVat)->toCurrency(),
				'price' => $currency->setValue($price)->toCurrency(),
				'vat' => $vat
			];
			$invoice['finalPrice'] += $price;
			$invoice['finalPriceWithoutVat'] += $priceWithoutVat;
		}

		//shipping, payment price, discount
		foreach ([
			$this->translate('label_shipping').' - '.$this->translate('label_'.$this->order->getShippingType()) => $shippingPrice,
			$this->translate('label_payment').' - '.$this->translate('label_'.$this->order->getPaymentType()) => $paymentPrice,
			$this->translate('label_discount') => $discount
		] as $additionalItemName => $price) { if ($price) {
			if ($this->isCreditNote && !$cnReturnWholeOrder) {
				continue;
			}
			if ($additionalItemName == $this->translate('label_discount')) {
				$price = round(-1 * $price, 0);
			}
			$count = 1;
			$vat = $this->order->getVatHigh();
			$priceWithoutVat = $price / (100 + $vat) * 100;
			$invoice['items'][] = [
				'name' => $additionalItemName,
				'count' => $count,
				'priceForOneWithoutVat' => $currency->setValue($priceWithoutVat)->toCurrency(),
				'priceForOne' => $currency->setValue($price)->toCurrency(),
				'priceWithoutVat' => $currency->setValue($priceWithoutVat)->toCurrency(),
				'price' => $currency->setValue($price)->toCurrency(),
				'vat' => $vat
			];
			$invoice['finalPrice'] += $price;
			$invoice['finalPriceWithoutVat'] += $priceWithoutVat;
		}}

		/*
		if ($this->isCreditNote) {
			$price = $finalPrice;
			$priceWithoutVat = $finalPriceWithoutVat;
		} else {
			$price = round($this->order->getFinalPrice(), 0);
			$priceWithoutVat = $price / (100 + $product->getVat()) * 100;
		}
		 * 
		 */
	?>
	<div style="border: 1px solid #BEC8CE; clear: both; margin-bottom: 15px;">
		<table style="width: 100%;">
			<tr>
				<td><strong>Položka</strong></td>
				<td style="text-align: right;"><strong>Počet</strong></td>
				<td style="text-align: right;"><strong>Cena/jedn.</strong></td>
				<?if($this->order->getIsTaxPayer()):?>
					<td style="text-align: right;"><strong>Cena bez DPH (<?=$currency->getSymbol();?>)</strong></td>
					<td style="text-align: right;"><strong>Sazba DPH</strong></td>
				<?endif;?>
				<td style="text-align: right;"><strong>Cena (<?=$currency->getSymbol();?>)</strong></td>
			</tr>
			<?foreach($invoice['items'] as $item):?>
				<tr>
					<td><?=$item['name'];?></td>
					<td style="text-align: right;"><?=$item['count'];?></td>
					<?if($this->order->getIsTaxPayer()):?>
						<td style="text-align: right;"><?=$item['priceForOneWithoutVat'];?></td>
						<td style="text-align: right;"><?=$item['priceWithoutVat'];?></td>
						<td style="text-align: right;"><?=$item['vat'];?>%</td>
					<?else:?>
						<td style="text-align: right;"><?=$item['priceForOne'];?></td>
					<?endif;?>
					<td style="text-align: right;"><?=$item['price'];?></td>
				</tr>
			<?endforeach;?>
		</table>
	</div>

	<div style="border: 2px solid #000000; margin-bottom: 15px;">
		<table style="width: 100%;">
			<tr style="font-size: 20px;">
				<td><strong>Cena celkem:</strong></td>
				<td style="text-align: right;"><strong><?=$currency->setValue($invoice['finalPrice'])->toCurrency();?></strong></td>
			</tr>
		</table>
	</div>

	<?
		$stamp = $this->settings->getSupplierStamp();
	?>
	<?if($stamp):?>
		<div style="text-align: right; padding-right: 100px;">
			<div style="font-weight: bold;">Vystavil, razítko, podpis:</div>
			<img src="<?=$stamp->getThumbnail();?>" alt="Razitko s podpisem" />
		</div>
	<?endif;?>
</div>
