pimcore.registerNS("pimcore.layout.portlets.lastOrders");
pimcore.layout.portlets.lastOrders = Class.create(pimcore.layout.portlets.abstract, {
	getClassName: function() {
		return "pimcore.layout.portlets.lastOrders";
	},

	initialize: function() {
		pimcore.plugin.broker.registerPlugin(this);
	},

	getType: function () {
		return "pimcore.layout.portlets.lastOrders";
	},

	getName: function () {
		return t("plugin_portlets_last_orders");
	},

	getIcon: function () {
		return "plugin_portlets_last_orders";
	},

	getLayout: function (portletId) {

		var store = new Ext.data.Store({
			autoDestroy: true,
			proxy: {
				type: 'ajax',
				url: '/plugin/Portlets/admin/portlet-last-orders',
				reader: {
					type: 'json',
					rootProperty: 'objects'
				}
			},
			fields: ['id','path',"type",'date','status', 'statusText']
		});

		var selectStore = new Ext.data.Store({
			fields: ['count', 'value'],
			data: [
				{count:"10", value:"10"},
				{count:"20", value:"20"},
				{count:"40", value:"40"},
				{count:"60", value:"60"},
				{count:"80", value:"80"},
				{count:"100", value:"100"},
				{count:t("plugin_portlets_all"), value:"0"}
			]
		});

		store.load();

		var tbar = [
			{
				xtype:"tbtext",
				text:t('plugin_portlets_select_count')
			},
			{
				id: "portlet-eshop-last-orders-count",
				xtype:"combo",
				name:"count",
				store: selectStore,
				displayField: "count",
				valueField: "value",
				value: "20",
				mode: "local",
				triggerAction: "all",
				listeners:{
					select: function () {
						var refreshButton = Ext.getCmp('portlet-eshop-last-orders-refresh');
						refreshButton.handler.call(refreshButton.scope);
					}
			   }
			},
			"->",
			{
				id:"portlet-eshop-last-orders-refresh",
				xtype:"button",
				iconCls: "x-tbar-loading",
				scale: "small",
				handler: function() {
					store.load({
						params: {
							count : Ext.getCmp('portlet-eshop-last-orders-count').getValue()
						}
					});
				}
			}
		]	

		var grid = new Ext.grid.GridPanel({
			store: store,
			tbar: tbar,
			columns: [
				{header: t('plugin_portlets_path'), id: "path", sortable: false, dataIndex: 'path', flex: 1},
				{header: t('plugin_portlets_status'), id: "statusText", sortable: false, dataIndex: 'statusText'},
				{header: t('plugin_portlets_date'), width: 130, sortable: false, renderer: function (d) {
					var date = new Date(d * 1000);
					return Ext.Date.format(date, "Y-m-d H:i:s");
				}, dataIndex: 'date'}
			],
			stripeRows: true,
			autoExpandColumn: 'path',
			viewConfig: {
				stripeRows: false,
				getRowClass: function(record) {
					return 'plugin_portlets_grid_row_' + record.get('status');
				}
			}
		});

		grid.on("rowclick", function (grid, row, event) {
			pimcore.helpers.openObject(row.getData().id, row.getData().type);
		});


		this.layout = new Ext.create('Portal.view.Portlet', Object.extend(this.getDefaultConfig(), {
			title: this.getName(),
			iconCls: this.getIcon(),
			height: 560,
			layout: "fit",
			items: [grid]
		}));

		this.layout.portletId = portletId;
		return this.layout;
	}
});

pimcore.registerNS("pimcore.layout.portlets.mostSoldProducts");
pimcore.layout.portlets.mostSoldProducts = Class.create(pimcore.layout.portlets.abstract, {
	getClassName: function() {
		return "pimcore.layout.portlets.mostSoldProducts";
	},

	initialize: function() {
		pimcore.plugin.broker.registerPlugin(this);
	},

	getType: function () {
		return "pimcore.layout.portlets.mostSoldProducts";
	},

	getName: function () {
		return t("plugin_portlets_most_sold_products");
	},

	getIcon: function () {
		return "plugin_portlets_most_sold_products";
	},

	getLayout: function (portletId) {

		var store = new Ext.data.Store({
			autoDestroy: true,
			proxy: {
				type: 'ajax',
				url: '/plugin/Portlets/admin/portlet-most-sold-products',
				reader: {
					type: 'json',
					rootProperty: 'objects'
				}
			},
			fields: ['id','path',"type","count"]
		});

		var selectStore = new Ext.data.Store({
			fields: ['count', 'value'],
			data: [
				{count:"10", value:"10"},
				{count:"20", value:"20"},
				{count:"40", value:"40"},
				{count:"60", value:"60"},
				{count:"80", value:"80"},
				{count:"100", value:"100"},
				{count:t("plugin_portlets_all"), value:"0"}
			]
		});

		store.load();

		var tbar = [
			{
				xtype:"tbtext",
				text:t('plugin_portlets_select_count')
			},
			{
				id: "portlet-most-sold-products-count",
				xtype:"combo",
				name:"count",
				store: selectStore,
				displayField: "count",
				valueField: "value",
				value: "10",
				mode: "local",
				triggerAction: "all",
				listeners:{
					select: function () {
						var refreshButton = Ext.getCmp('portlet-most-sold-products-refresh');
						refreshButton.handler.call(refreshButton.scope);
					}
			   }
			},
			"->",
			{
				id:"portlet-most-sold-products-refresh",
				xtype:"button",
				iconCls: "x-tbar-loading",
				scale: "small",
				handler: function() {
					store.load({
						params: {
							count : Ext.getCmp('portlet-most-sold-products-count').getValue()
						}
					});
				}
			}
		]	

		var grid = new Ext.grid.GridPanel({
			store: store,
			tbar: tbar,
			columns: [
				{header: t('plugin_portlets_path'), id: "path", sortable: false, dataIndex: 'path', flex: 1},
				{header: t('plugin_portlets_count'), id: "count", sortable: false, dataIndex: 'count'},
			],
			stripeRows: true,
			autoExpandColumn: 'path'
		});

		grid.on("rowclick", function (grid, row, event) {
			pimcore.helpers.openObject(row.getData().id, row.getData().type);
		});


		this.layout = new Ext.create('Portal.view.Portlet', Object.extend(this.getDefaultConfig(), {
			title: this.getName(),
			iconCls: this.getIcon(),
			height: 275,
			layout: "fit",
			items: [grid]
		}));

		this.layout.portletId = portletId;
		return this.layout;
	}
});

pimcore.registerNS("pimcore.layout.portlets.eshopStatistics");
pimcore.layout.portlets.eshopStatistics = Class.create(pimcore.layout.portlets.abstract, {
	getClassName: function() {
		return "pimcore.layout.portlets.eshopStatistics";
	},

	initialize: function() {
		pimcore.plugin.broker.registerPlugin(this);
	},

	getType: function () {
		return "pimcore.layout.portlets.eshopStatistics";
	},

	getName: function () {
		return t("plugin_portlets_eshop_statistics");
	},

	getIcon: function () {
		return "plugin_portlets_eshop_statistics";
	},

	getLayout: function (portletId) {

		var store = new Ext.data.Store({
			autoDestroy: true,
			proxy: {
				type: 'ajax',
				url: '/plugin/Portlets/admin/portlet-eshop-statistics',
				reader: {
					type: 'json',
					rootProperty: 'stats'
				}
			},
			fields: ['key','value']
		});
		store.load();

		var countryStore = new Ext.data.Store({
			autoDestroy: true,
			proxy: {
				type: 'ajax',
				url: '/plugin/Portlets/admin/get-countries',
				reader: {
					type: 'json',
					rootProperty: 'countries'
				}
			},
			fields: ['country','value']
		});
		countryStore.load();

		var today = new Date();

		var tbar = [
			{
				xtype:"tbtext",
				text:t('plugin_portlets_since')
			},
			{
				id: "portlet-eshop-statistics-since",
				xtype:"datefield",
				name:"since",
				format: "d/m/Y",
				submitFormat: 'Y-m-d H:i:s',
				value: new Date(new Date().setDate(today.getDate() - 29)),
				allowBlank: true,
				triggerAction: "all",
				listeners:{
					change: function () {
						var refreshButton = Ext.getCmp('portlet-eshop-statistics-refresh');
						refreshButton.handler.call(refreshButton.scope);
					}
			   }
			},
			{ xtype: 'tbseparator' },
			{
				xtype:"tbtext",
				text:t('plugin_portlets_until')
			},
			{
				id: "portlet-eshop-statistics-until",
				xtype:"datefield",
				name:"until",
				format: "d/m/Y",
				submitFormat: 'Y-m-d H:i:s',
				value: today,
				allowBlank: true,
				triggerAction: "all",
				listeners:{
					change: function () {
						var refreshButton = Ext.getCmp('portlet-eshop-statistics-refresh');
						refreshButton.handler.call(refreshButton.scope);
					}
			   }
			},
			{ xtype: 'tbseparator' },
			{
				xtype:"tbtext",
				text:t('plugin_portlets_country')
			},
			{
				id: "portlet-eshop-statistics-country",
				xtype:"combo",
				name:"country",
				store: countryStore,
				displayField: "country",
				valueField: "value",
				width: 50,
				value: "CZ",
				mode: "local",
				triggerAction: "all",
				listeners:{
					select: function () {
						var refreshButton = Ext.getCmp('portlet-eshop-statistics-refresh');
						refreshButton.handler.call(refreshButton.scope);
					}
			   }
			},
			{ xtype: 'tbseparator' },
			{
				xtype:"button",
				text:t("plugin_portlets_today"),
				border:"1",
				handler: function() {
					Ext.getCmp('portlet-eshop-statistics-since').setValue(today);
					Ext.getCmp('portlet-eshop-statistics-until').setValue(today);
					var refreshButton = Ext.getCmp('portlet-eshop-statistics-refresh');
					refreshButton.handler.call(refreshButton.scope);
				}
			},
			{ xtype: 'tbseparator' },
			{
				xtype:"button",
				text:t("plugin_portlets_last_week"),
				handler: function() {
					Ext.getCmp('portlet-eshop-statistics-since').setValue(new Date(new Date().setDate(today.getDate() - 6)));
					Ext.getCmp('portlet-eshop-statistics-until').setValue(today);
					var refreshButton = Ext.getCmp('portlet-eshop-statistics-refresh');
					refreshButton.handler.call(refreshButton.scope);
				}
			},
			{ xtype: 'tbseparator' },
			{
				xtype:"button",
				text:t("plugin_portlets_last_30_days"),
				handler: function() {
					Ext.getCmp('portlet-eshop-statistics-since').setValue(new Date(new Date().setDate(today.getDate() - 29)));
					Ext.getCmp('portlet-eshop-statistics-until').setValue(today);
					var refreshButton = Ext.getCmp('portlet-eshop-statistics-refresh');
					refreshButton.handler.call(refreshButton.scope);
				}
			},
			"->",
			{
				id:"portlet-eshop-statistics-refresh",
				xtype:"button",
				iconCls: "x-tbar-loading",
				scale: "small",
				handler: function() {
					store.load({
						params: {
							since : Ext.getCmp('portlet-eshop-statistics-since').getValue(),
							until : Ext.getCmp('portlet-eshop-statistics-until').getValue(),
							country: Ext.getCmp('portlet-eshop-statistics-country').getValue()
						}
					});
				}
			}
		];

		var grid = new Ext.grid.GridPanel({
			store: store,
			tbar: tbar,
			columns: [
				{header: t('plugin_portlets_stat_key'), id: "key", sortable: false, dataIndex: 'key', flex: 1},
				{header: t('plugin_portlets_stat_value'), id: "value", sortable: false, dataIndex: 'value'}
			],
			stripeRows: true,
			autoExpandColumn: 'key'
		});

		this.layout = Ext.create('Portal.view.Portlet', Object.extend(this.getDefaultConfig(), {
			title: this.getName(),
			iconCls: this.getIcon(),
			height: 275,
			layout: "fit",
			items: [grid]
		}));

		this.layout.portletId = portletId;
		return this.layout;
	}
});

pimcore.registerNS("pimcore.layout.portlets.salesGraph");
pimcore.layout.portlets.salesGraph = Class.create(pimcore.layout.portlets.abstract, {
	getClassName: function() {
		return "pimcore.layout.portlets.salesGraph";
	},

	initialize: function() {
		pimcore.plugin.broker.registerPlugin(this);
	},

	getType: function () {
		return "pimcore.layout.portlets.salesGraph";
	},

	getName: function () {
		return t("plugin_portlets_sales_graph");
	},

	getIcon: function () {
		return "plugin_portlets_sales_graph";
	},

	getLayout: function (portletId) {

		var store = new Ext.data.Store({
			autoDestroy: true,
			proxy: {
				type: 'ajax',
				url: '/plugin/Portlets/admin/portlet-sales-graph',
				reader: {
					type: 'json',
					rootProperty: 'data'
				}
			},
			fields: ['timestamp','datetext',"orders", "products"]
		});

		store.load();

		var today = new Date();

		var tbar = [
			{
				xtype:"tbtext",
				text:t('plugin_portlets_since')
			},
			{
				id: "portlet-sales-graph-since",
				xtype:"datefield",
				name:"since",
				format: "d/m/Y",
				submitFormat: 'Y-m-d H:i:s',
				value: new Date(new Date().setDate(today.getDate() - 29)),
				allowBlank: true,
				triggerAction: "all",
				listeners:{
					change: function () {
						var refreshButton = Ext.getCmp('portlet-sales-graph-refresh');
						refreshButton.handler.call(refreshButton.scope);
					}
			   }
			},
			{ xtype: 'tbseparator' },
			{
				xtype:"tbtext",
				text:t('plugin_portlets_until')
			},
			{
				id: "portlet-sales-graph-until",
				xtype:"datefield",
				name:"until",
				format: "d/m/Y",
				submitFormat: 'Y-m-d H:i:s',
				value: today,
				allowBlank: true,
				triggerAction: "all",
				listeners:{
					change: function () {
						var refreshButton = Ext.getCmp('portlet-sales-graph-refresh');
						refreshButton.handler.call(refreshButton.scope);
					}
			   }
			},
			{ xtype: 'tbseparator' },
			{
				xtype:"button",
				text:t("plugin_portlets_today"),
				border:"1",
				handler: function() {
					Ext.getCmp('portlet-sales-graph-since').setValue(today);
					Ext.getCmp('portlet-sales-graph-until').setValue(today);
					var refreshButton = Ext.getCmp('portlet-sales-graph-refresh');
					refreshButton.handler.call(refreshButton.scope);
				}
			},
			{ xtype: 'tbseparator' },
			{
				xtype:"button",
				text:t("plugin_portlets_last_week"),
				handler: function() {
					Ext.getCmp('portlet-sales-graph-since').setValue(new Date(new Date().setDate(today.getDate() - 6)));
					Ext.getCmp('portlet-sales-graph-until').setValue(today);
					var refreshButton = Ext.getCmp('portlet-sales-graph-refresh');
					refreshButton.handler.call(refreshButton.scope);
				}
			},
			{ xtype: 'tbseparator' },
			{
				xtype:"button",
				text:t("plugin_portlets_last_30_days"),
				handler: function() {
					Ext.getCmp('portlet-sales-graph-since').setValue(new Date(new Date().setDate(today.getDate() - 29)));
					Ext.getCmp('portlet-sales-graph-until').setValue(today);
					var refreshButton = Ext.getCmp('portlet-sales-graph-refresh');
					refreshButton.handler.call(refreshButton.scope);
				}
			},
			"->",
			{
				id:"portlet-sales-graph-refresh",
				xtype:"button",
				iconCls: "x-tbar-loading",
				scale: "small",
				handler: function() {
					store.load({
						params: {
							since : Ext.getCmp('portlet-sales-graph-since').getValue(),
							until : Ext.getCmp('portlet-sales-graph-until').getValue()
						}
					});
				}
			}
		];

		var panel = new Ext.Panel({
			layout:'fit',
			tbar: tbar,
			height: 275,
			items: {
				xtype: 'cartesian',
				store: store,
				xField: 'datetext',
                interactions: ['itemhighlight'],
				axes: [{
					type: 'numeric',
					fields: ['orders', 'products'],
					position: 'left',
					grid: true,
					minimum: 0
				},
				{
					type: 'category',
					fields: 'datetext',
					position: 'bottom',
					grid: true,
					label: {
						rotate: {
							degrees: -45
						}
					}
				}],
				series: [
					{
						type: 'line',
						title: t('plugin_portlets_sales_graph_orders'),
                        xField: 'datetext',
						yField: 'orders',
						style: {
							color:0x00ff00
						},
                        marker: {
                            radius: 4
                        },
                        highlight: {
                            fillStyle: '#000',
                            radius: 5,
                            lineWidth: 2,
                            strokeStyle: '#fff'
                        },
                        tooltip: {
                            trackMouse: true,
                            style: 'background: #01841c',
                            renderer: function(tooltip, storeItem, item) {
                                var title = item.series.getTitle();
                                tooltip.setHtml(title + ' for ' + storeItem.get('datetext') + ': ' + storeItem.get(item.series.getYField()));
                            }
                        }
					},
					{
						type: 'line',
						title: t('plugin_portlets_sales_graph_products'),
                        xField: 'datetext',
						yField: 'products',
						style: {
							color:0x0000ff
						},
                        marker: {
                            radius: 4
                        },
                        highlight: {
                            fillStyle: '#000',
                            radius: 5,
                            lineWidth: 2,
                            strokeStyle: '#fff'
                        },
                        tooltip: {
                            trackMouse: true,
                            style: 'background: #01841c',
                            renderer: function(tooltip, storeItem, item) {
                                var title = item.series.getTitle();
                                tooltip.setHtml(title + ' for ' + storeItem.get('datetext') + ': ' + storeItem.get(item.series.getYField()));
                            }
                        }
					}
				]
			}
		});

		this.layout = new Ext.create('Portal.view.Portlet', Object.extend(this.getDefaultConfig(), {
			title: this.getName(),
			iconCls: this.getIcon(),
			height: 275,
			layout: "fit",
			items: [panel]
		}));

		this.layout.portletId = portletId;
		return this.layout;
	}
});
