<?php

set_time_limit(60000);
include_once(__DIR__."/../../pimcore/cli/startup.php");
//execute in admin mode
define("PIMCORE_ADMIN", true);
//disable cache and verrsions
\Pimcore\Cache::disable();
\Pimcore\Model\Version::disable();

try {
	$opts = new \Zend_Console_Getopt([
				'verbose|v' => 'show detailed information during the maintenance (for debug, ...)',
				'class|c' => 'class name',
				'minid|m' => 'id to start',
				'maxid|x' => 'id to stop',
				'publish|p' => 'publish instead of deleting',
				'help|h' => 'show this help'
			]);
	$opts->parse();
} catch (\Exception $e) {
	echo $e->getMessage();
}

// display help message
if ($opts->getOption("help")) {
	echo $opts->getUsageMessage();
	exit;
}

if ($opts->getOption("verbose")) {
	$writer = new \Zend_Log_Writer_Stream('php://output');
	$logger = new \Zend_Log($writer);
	\Logger::addLogger($logger);

	// set all priorities
	\Logger::setPriorities([
		\Zend_Log::DEBUG,
		\Zend_Log::INFO,
		\Zend_Log::NOTICE,
		\Zend_Log::WARN,
		\Zend_Log::ERR,
		\Zend_Log::CRIT,
		\Zend_Log::ALERT,
		\Zend_Log::EMERG
	]);
}

$class = $opts->getOption("class");

if (!$class) {
	fputs(STDOUT, "no class specified try -help\n");
	exit;
}

$minId = $opts->getOption("minid");
$maxId = $opts->getOption("maxid");
$publish = $opts->getOption("publish");
$listClass = '\\Pimcore\\Model\\Object\\' . $class . '\\Listing';
$operation = ($publish) ? 'Publishing' : 'Deleting';

$list = new $listClass;
$list->setUnpublished(true);
$list->setOrderKey('o_id');
$list->setOrder('asc');

if ($minId && $maxId) {
	fputs(STDOUT, sprintf("ID restriction active, %d <= ID <= %d.\n", $minId, $maxId));
	$list->setCondition('o_id >= ' . $list->quote($minId) . ' AND o_id <= ' . $list->quote($maxId));
} elseif ($minId) {
	fputs(STDOUT, sprintf("ID restriction active, ID >= %d.\n", $minId));
	$list->setCondition('o_id >= ' . $list->quote($minId));
} elseif ($maxId) {
	fputs(STDOUT, sprintf("ID restriction active, ID <= %d.\n", $maxId));
	$list->setCondition('o_id <= ' . $list->quote($maxId));
}

$list->load();
$count = $list->count();

fputs(STDOUT, sprintf("%s %d objects from class %s...\n", $operation, $count, $class));
$errors = 0;
foreach ($list->getItems(0, 0) as $key => $object) {
	if ($key > 0 && $key % 50 == 0) {
		fputs(STDOUT, sprintf("%d objects deleted.\n", $key));
	}
	try {
		if ($publish) {
			$object->setPublished(true);
			$object->save();
		} else {
			$object->delete();
		}
	} catch (\Exception $e) {
		$errors += 1;
		\Pimcore\Log\Simple::log('batch', $e->getMessage());
	}
}

fputs(STDOUT, sprintf("Batch operation completed. errors: %d.\n", $errors));
