<?php
set_time_limit(60000);
include_once("../../pimcore/cli/startup.php");
$db = Pimcore_Resource_Mysql::get();
$languages = Pimcore_Tool::getValidLanguages();
Pimcore_Model_Cache::clearAll();

fputs(STDOUT, "2961\n");
if (version_compare(PHP_VERSION, '5.4.0', "<")) {
    echo "<b>Pimcore requires at least PHP 5.4.<br />Your version is" . PHP_VERSION . ".<br />Please upgrade your PHP installation before resuming the pimcore update!</b>";
    exit;
}

fputs(STDOUT, "2978\n");
$db->query("ALTER TABLE `search_backend_data` CHANGE COLUMN `fullpath` `fullpath` varchar(330) NULL DEFAULT NULL;");

fputs(STDOUT, "2992\n");
$tableNames = [
    "documents_doctypes",
    "glossary",
    "keyvalue_groups",
    "keyvalue_keys",
    "properties_predefined",
    "redirects",
    "sites",
    "staticroutes"
];
foreach ($tableNames as $tableName) {
    sendQuery("ALTER TABLE `" . $tableName . "` ADD COLUMN `creationDate` bigint(20) unsigned DEFAULT 0;");
    sendQuery("ALTER TABLE `" . $tableName . "` ADD COLUMN `modificationDate` bigint(20) unsigned DEFAULT 0;");
}

fputs(STDOUT, "2994\n");
sendQuery("DROP TABLE IF EXISTS `website_settings`;");
sendQuery("CREATE TABLE `website_settings` (
        `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
        `name` VARCHAR(255) NOT NULL DEFAULT '',
        `type` ENUM('text','document','asset','object','bool') NULL DEFAULT NULL,
        `data` TEXT NULL,
        `siteId` INT(11) UNSIGNED NULL DEFAULT NULL,
        `creationDate` BIGINT(20) UNSIGNED NULL DEFAULT '0',
        `modificationDate` BIGINT(20) UNSIGNED NULL DEFAULT '0',
        PRIMARY KEY (`id`),
        INDEX `name` (`name`),
        INDEX `siteId` (`siteId`)
)
DEFAULT CHARSET=utf8;");
if (file_exists(PIMCORE_CONFIGURATION_DIRECTORY . "/website.xml")) {
	$configFile = PIMCORE_CONFIGURATION_DIRECTORY . "/website.xml";
	$configFileNew = PIMCORE_CONFIGURATION_DIRECTORY . "/website-legacy.xml";
	$rawConfig = new Zend_Config_Xml($configFile);
	$arrayData = $rawConfig->toArray();
	$data = [];
	foreach ($arrayData as $key => $value) {
		$setting = new WebsiteSetting();
		$setting->setName($key);
		$type = $value["type"];
		$setting->setType($type);
		$data = $value["data"];
		if ($type == "bool") {
			$data = (bool) $data;
		} else if($type == "document") {
			$data = Document::getByPath($value["data"]);
		} else if($type == "asset") {
			$data = Asset::getByPath($value["data"]);
		}  else if($type == "object") {
			$data = Object_Abstract::getByPath($value["data"]);
		}
		if ($data instanceof Element_Interface) {
			$data = $data->getId();
		}
		$setting->setData($data);
		$siteId = ($value["siteId"] > 0) ? (int)$value["siteId"] : null;
		$setting->setSiteId($siteId);
		$setting->save();
	}
	@rename($configFile, $configFileNew);
}

fputs(STDOUT, "3025\n");
$db->update("content_index", ["content" => ""]);
$db->query("ALTER TABLE `content_index` CHANGE COLUMN `content` `content` longblob NULL;");

fputs(STDOUT, "3027\n");
$db->query("ALTER TABLE `users` ADD COLUMN `docTypes` varchar(255) NULL DEFAULT NULL;");
$db->query("ALTER TABLE `users` ADD COLUMN `classes` varchar(255) NULL DEFAULT NULL;");

fputs(STDOUT, "3044\n");
$db->query("DELETE FROM `users_permission_definitions` WHERE `key`='bounce_mail_inbox';");
$db->query("INSERT INTO `users_permission_definitions` SET `key`='emails';");

fputs(STDOUT, "3045\n");
$db->query("CREATE TABLE `email_blacklist` (
  `address` varchar(255) NOT NULL DEFAULT '',
  `creationDate` int(11) unsigned DEFAULT NULL,
  `modificationDate` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`address`)
) DEFAULT CHARSET=utf8;");

fputs(STDOUT, "3051\n");
$db->query("ALTER TABLE `users_workspaces_object`
	ADD COLUMN `lEdit` TEXT NULL DEFAULT NULL AFTER `properties`,
	ADD COLUMN `lView` TEXT NULL DEFAULT NULL AFTER `lEdit`;
");

Pimcore_Model_Cache::clearAll();
fputs(STDOUT, "done\n");




//functions
function sendQuery ($sql) {
    try {
        $db = Pimcore_Resource::get();
        $db->query($sql);
    } catch (Exception $e) {
        echo $e->getMessage();
        echo "Please execute the following query manually: <br />";
        echo "<pre>" . $sql . "</pre><hr />";
    }
}
