<?php

/**
 * Simple search form, without decorators
 * 
 * @author Martin Kuric <martin.kuric@portadesign.cz>
 */

namespace Website\Form;

class SearchForm extends Base
{

	public function init()
	{
		parent::init();
		$this->setName('searchform');
		$this->setMethod('GET');
		$translator = \Zend_Registry::get('Zend_Translate');

		//elements
		$query = new \Zend_Form_Element_Text($translator->translate('query'));
		$query->setRequired(false)
				->setLabel('label_search')
				->setAttrib('autocomplete', 'off')
				->addFilter('StripTags')
				->addFilter('StringTrim')
				->addValidator($this->notEmptyValidator);

		$this->addElements([$query]);

		//remove decorators
		$this->setElementDecorators(['ViewHelper']);
	}

}
