<?php

namespace Website\Tool\Console\Command;

use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class ElasticReindexCommand extends AbstractCommand
{
	protected function configure()
	{
		$this
			->setName('elastic:reindex')
			->setDescription('Reindex elastic search index')
			->addOption(
				'fulltext', 'f',
				InputOption::VALUE_OPTIONAL,
				'Restrict fulltext index with a comma separated class list',
				'all'
			)
			->addOption(
				'objects', 'o',
				InputOption::VALUE_OPTIONAL,
				'Restrict objects index with a comma separated class list',
				'all'
			)
			->addOption(
				'copy', 'c',
				InputOption::VALUE_NONE,
				'Copy types which are not reindexed',
				null
			);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		$fulltext = $input->getOption('fulltext');
		$objects = $input->getOption('objects');
		$copy = $input->getOption('copy');
		if (!$fulltext && !$objects) {
			$fulltext = true;
			$objects = true;
		}
		if ($fulltext == 'all') {
			$fulltext = true;
		}
		if ($objects == 'all') {
			$objects = true;
		}
		\Website\Tool\ElasticSearch::setOutputInterface($output);
		\Website\Tool\ElasticSearch::updateMappingsAndReindex($fulltext, $objects, $copy);
	}
}
