CREATE TABLE IF NOT EXISTS `object_brick_query_color_1` (
  `o_id` int(11) NOT NULL DEFAULT '0',
  `fieldname` varchar(255) NOT NULL DEFAULT '',
  `color__id` int(11) DEFAULT NULL,
  `color__type` enum('document','asset','object') DEFAULT NULL,
  PRIMARY KEY (`o_id`,`fieldname`),
  KEY `o_id` (`o_id`),
  KEY `fieldname` (`fieldname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_brick_query_size_1` (
  `o_id` int(11) NOT NULL DEFAULT '0',
  `fieldname` varchar(255) NOT NULL DEFAULT '',
  `size__id` int(11) DEFAULT NULL,
  `size__type` enum('document','asset','object') DEFAULT NULL,
  PRIMARY KEY (`o_id`,`fieldname`),
  KEY `o_id` (`o_id`),
  KEY `fieldname` (`fieldname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_brick_store_color_1` (
  `o_id` int(11) NOT NULL DEFAULT '0',
  `fieldname` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`o_id`,`fieldname`),
  KEY `o_id` (`o_id`),
  KEY `fieldname` (`fieldname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_brick_store_size_1` (
  `o_id` int(11) NOT NULL DEFAULT '0',
  `fieldname` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`o_id`,`fieldname`),
  KEY `o_id` (`o_id`),
  KEY `fieldname` (`fieldname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_collection_orderproduct_3` (
  `o_id` int(11) NOT NULL DEFAULT '0',
  `index` int(11) NOT NULL DEFAULT '0',
  `fieldname` varchar(255) NOT NULL DEFAULT '',
  `count` double DEFAULT NULL,
  `price` double DEFAULT NULL,
  `isLowVat` tinyint(1) DEFAULT NULL,
  `vat` double DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `returned` double DEFAULT NULL,
  `cost` double DEFAULT NULL,
  PRIMARY KEY (`o_id`,`index`,`fieldname`),
  KEY `o_id` (`o_id`),
  KEY `index` (`index`),
  KEY `fieldname` (`fieldname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_localized_data_1` (
  `ooo_id` int(11) NOT NULL DEFAULT '0',
  `language` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(255) DEFAULT NULL,
  `seoDescription` longtext,
  `translatedPath` varchar(255) DEFAULT NULL,
  `shortDescription` longtext,
  `description` longtext,
  `parameters` text,
  `variantName` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ooo_id`,`language`),
  KEY `ooo_id` (`ooo_id`),
  KEY `language` (`language`),
  KEY `p_index_translatedPath` (`translatedPath`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_localized_data_2` (
  `ooo_id` int(11) NOT NULL DEFAULT '0',
  `language` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(255) DEFAULT NULL,
  `seoDescription` longtext,
  `translatedPath` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ooo_id`,`language`),
  KEY `ooo_id` (`ooo_id`),
  KEY `language` (`language`),
  KEY `p_index_translatedPath` (`translatedPath`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_localized_data_4` (
  `ooo_id` int(11) NOT NULL DEFAULT '0',
  `language` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(255) DEFAULT NULL,
  `seoDescription` longtext,
  `perex` longtext,
  `content` longtext,
  PRIMARY KEY (`ooo_id`,`language`),
  KEY `ooo_id` (`ooo_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_localized_data_11` (
  `ooo_id` int(11) NOT NULL DEFAULT '0',
  `language` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ooo_id`,`language`),
  KEY `ooo_id` (`ooo_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_localized_data_12` (
  `ooo_id` int(11) NOT NULL DEFAULT '0',
  `language` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ooo_id`,`language`),
  KEY `ooo_id` (`ooo_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_localized_query_1_cs` (
  `ooo_id` int(11) NOT NULL DEFAULT '0',
  `language` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(255) DEFAULT NULL,
  `variantName` varchar(255) DEFAULT NULL,
  `seoDescription` longtext,
  `translatedPath` varchar(255) DEFAULT NULL,
  `shortDescription` longtext,
  `description` longtext,
  `parameters` text,
  `url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ooo_id`,`language`),
  KEY `ooo_id` (`ooo_id`),
  KEY `language` (`language`),
  KEY `p_index_translatedPath` (`translatedPath`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_localized_query_2_cs` (
  `ooo_id` int(11) NOT NULL DEFAULT '0',
  `language` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(255) DEFAULT NULL,
  `seoDescription` longtext,
  `translatedPath` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ooo_id`,`language`),
  KEY `ooo_id` (`ooo_id`),
  KEY `language` (`language`),
  KEY `p_index_translatedPath` (`translatedPath`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_localized_query_4_cs` (
  `ooo_id` int(11) NOT NULL DEFAULT '0',
  `language` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(255) DEFAULT NULL,
  `seoDescription` longtext,
  `perex` longtext,
  `content` longtext,
  `url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ooo_id`,`language`),
  KEY `ooo_id` (`ooo_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_localized_query_11_cs` (
  `ooo_id` int(11) NOT NULL DEFAULT '0',
  `language` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ooo_id`,`language`),
  KEY `ooo_id` (`ooo_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_localized_query_12_cs` (
  `ooo_id` int(11) NOT NULL DEFAULT '0',
  `language` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ooo_id`,`language`),
  KEY `ooo_id` (`ooo_id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_query_1` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '1',
  `oo_className` varchar(255) DEFAULT 'Product',
  `ordering` double DEFAULT NULL,
  `isLowVat` tinyint(1) DEFAULT NULL,
  `gallery` text,
  `inStock` double DEFAULT NULL,
  `isNew` tinyint(1) DEFAULT NULL,
  `soldCount` double DEFAULT NULL,
  `brand__id` int(11) DEFAULT NULL,
  `brand__type` enum('document','asset','object') DEFAULT NULL,
  `isMasterProduct` double DEFAULT NULL,
  `priceCZ` double DEFAULT NULL,
  `discountedPriceCZ` double DEFAULT NULL,
  `priceSK` double DEFAULT NULL,
  `discountedPriceSK` double DEFAULT NULL,
  `ignoreSalePromotionsCZ` tinyint(1) DEFAULT NULL,
  `ignoreSalePromotionsSK` tinyint(1) DEFAULT NULL,
  `costCZ` double DEFAULT NULL,
  `costSK` double DEFAULT NULL,
  `colors` varchar(255) DEFAULT NULL,
  `sizes` varchar(255) DEFAULT NULL,
  `additionalCategories` text,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_ordering` (`ordering`),
  KEY `p_index_inStock` (`inStock`),
  KEY `p_index_soldCount` (`soldCount`),
  KEY `p_index_brand__id` (`brand__id`),
  KEY `p_index_brand__type` (`brand__type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_query_2` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '2',
  `oo_className` varchar(255) DEFAULT 'Category',
  `ordering` double DEFAULT NULL,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_ordering` (`ordering`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_query_3` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '3',
  `oo_className` varchar(255) DEFAULT 'Order',
  `orderId` varchar(255) DEFAULT NULL,
  `paymentType` varchar(255) DEFAULT NULL,
  `shippingType` varchar(255) DEFAULT NULL,
  `productsPrice` double DEFAULT NULL,
  `shippingPrice` double DEFAULT NULL,
  `finalPrice` double DEFAULT NULL,
  `currency` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `message` longtext,
  `fCompany` varchar(255) DEFAULT NULL,
  `fStreet` varchar(255) DEFAULT NULL,
  `fCity` varchar(255) DEFAULT NULL,
  `fZipCode` varchar(255) DEFAULT NULL,
  `fEmail` varchar(255) DEFAULT NULL,
  `fPhone` varchar(255) DEFAULT NULL,
  `fIco` varchar(255) DEFAULT NULL,
  `fDic` varchar(255) DEFAULT NULL,
  `dCompany` varchar(255) DEFAULT NULL,
  `dStreet` varchar(255) DEFAULT NULL,
  `dCity` varchar(255) DEFAULT NULL,
  `dZipCode` varchar(255) DEFAULT NULL,
  `user__id` int(11) DEFAULT NULL,
  `user__type` enum('document','asset','object') DEFAULT NULL,
  `discountCode__id` int(11) DEFAULT NULL,
  `discountCode__type` enum('document','asset','object') DEFAULT NULL,
  `showInvoice` tinyint(1) DEFAULT NULL,
  `issuedOn` bigint(20) DEFAULT NULL,
  `dueTo` bigint(20) DEFAULT NULL,
  `vatLow` double DEFAULT NULL,
  `vatHigh` double DEFAULT NULL,
  `paymentPrice` double DEFAULT NULL,
  `paid` tinyint(1) DEFAULT NULL,
  `gpeWebPayTimestamp` varchar(255) DEFAULT NULL,
  `gpeWebPayNote` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fFirstName` varchar(255) DEFAULT NULL,
  `fLastName` varchar(255) DEFAULT NULL,
  `dFirstName` varchar(255) DEFAULT NULL,
  `dLastName` varchar(255) DEFAULT NULL,
  `isTaxPayer` tinyint(1) DEFAULT NULL,
  `invoiceId` varchar(255) DEFAULT NULL,
  `creditNoteId` varchar(255) DEFAULT NULL,
  `cnIssuedOn` bigint(20) DEFAULT NULL,
  `cnDueTo` bigint(20) DEFAULT NULL,
  `trackingNumber` varchar(255) DEFAULT NULL,
  `paidShadow` tinyint(1) DEFAULT NULL,
  `fromStore` tinyint(1) DEFAULT NULL,
  `ulozenkaAddress` varchar(255) DEFAULT NULL,
  `shippingDiscount` double DEFAULT NULL,
  `paymentDiscount` double DEFAULT NULL,
  `productsDiscount` double DEFAULT NULL,
  `statusShadow` varchar(255) DEFAULT NULL,
  `shippingCost` double DEFAULT NULL,
  `paymentCost` double DEFAULT NULL,
  `baseShippingPrice` double DEFAULT NULL,
  `basePaymentPrice` double DEFAULT NULL,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_user__id` (`user__id`),
  KEY `p_index_user__type` (`user__type`),
  KEY `p_index_paid` (`paid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_query_4` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '4',
  `oo_className` varchar(255) DEFAULT 'News',
  `createdOn` bigint(20) DEFAULT NULL,
  `previewImage__image` int(11) DEFAULT NULL,
  `previewImage__hotspots` text,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_createdOn` (`createdOn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_query_5` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '5',
  `oo_className` varchar(255) DEFAULT 'ContactForm',
  `fullName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `message` longtext,
  `lang` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`oo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_query_6` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '6',
  `oo_className` varchar(255) DEFAULT 'NewsletterForm',
  `email` varchar(255) DEFAULT NULL,
  `lang` varchar(255) DEFAULT NULL,
  `unsubscribeCode` varchar(255) DEFAULT NULL,
  `firstname` varchar(255) DEFAULT NULL,
  `lastname` varchar(255) DEFAULT NULL,
  `gender` varchar(255) DEFAULT NULL,
  `newsletterActive` tinyint(1) DEFAULT NULL,
  `newsletterConfirmed` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_unsubscribeCode` (`unsubscribeCode`),
  KEY `p_index_email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_query_7` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '7',
  `oo_className` varchar(255) DEFAULT 'DiscountCode',
  `code` varchar(255) DEFAULT NULL,
  `activeSince` bigint(20) DEFAULT NULL,
  `activeUntil` bigint(20) DEFAULT NULL,
  `used` tinyint(1) DEFAULT NULL,
  `isPercentual` tinyint(1) DEFAULT NULL,
  `reusable` tinyint(1) DEFAULT NULL,
  `discountCZ` double DEFAULT NULL,
  `discountSK` double DEFAULT NULL,
  `applyOnShipping` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_code` (`code`),
  KEY `p_index_activeSince` (`activeSince`),
  KEY `p_index_activeUntil` (`activeUntil`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_query_8` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '8',
  `oo_className` varchar(255) DEFAULT 'SalePromotion',
  `includedProducts` text,
  `isPercentual` tinyint(1) DEFAULT NULL,
  `discountCZ` double DEFAULT NULL,
  `discountSK` double DEFAULT NULL,
  PRIMARY KEY (`oo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_query_9` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '9',
  `oo_className` varchar(255) DEFAULT 'EshopSettings',
  `vatHigh` double DEFAULT NULL,
  `vatLow` double DEFAULT NULL,
  `exchangeRate__cs_cz#rate` double DEFAULT NULL,
  `exchangeRate__cs_cz#isdefault` tinyint(1) DEFAULT NULL,
  `exchangeRate__cs_cz#isactive` tinyint(1) DEFAULT NULL,
  `exchangeRate__sk_sk#rate` double DEFAULT NULL,
  `exchangeRate__sk_sk#isdefault` tinyint(1) DEFAULT NULL,
  `exchangeRate__sk_sk#isactive` tinyint(1) DEFAULT NULL,
  `supplierName` varchar(255) DEFAULT NULL,
  `supplierStreet` varchar(255) DEFAULT NULL,
  `supplierCity` varchar(255) DEFAULT NULL,
  `supplierZip` varchar(255) DEFAULT NULL,
  `supplierIco` varchar(255) DEFAULT NULL,
  `supplierDic` varchar(255) DEFAULT NULL,
  `invoiceTitle` varchar(255) DEFAULT NULL,
  `supplierAccountNumber` varchar(255) DEFAULT NULL,
  `supplierIsTaxPayer` tinyint(1) DEFAULT NULL,
  `supplierStamp__image` int(11) DEFAULT NULL,
  `supplierStamp__hotspots` text,
  `outOfStockBehaviour` varchar(255) DEFAULT NULL,
  `productPageLimit` double DEFAULT NULL,
  `dailyCost` double DEFAULT NULL,
  `showVariantsInLists` tinyint(1) DEFAULT NULL,
  `shippingOptionsCZ__cz#shipping_pick_up` double DEFAULT NULL,
  `shippingOptionsCZ__cz#shipping_czech_ppl` double DEFAULT NULL,
  `shippingOptionsCZ__cz#shipping_czech_post` double DEFAULT NULL,
  `shippingOptionsCZ__cz#shipping_ulozenka` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_pick_up#payment_cash` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_pick_up#payment_cod` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_pick_up#payment_bank_transfer` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_pick_up#payment_credit_card` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_czech_ppl#payment_cash` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_czech_ppl#payment_cod` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_czech_ppl#payment_bank_transfer` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_czech_ppl#payment_credit_card` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_czech_post#payment_cash` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_czech_post#payment_cod` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_czech_post#payment_bank_transfer` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_czech_post#payment_credit_card` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_ulozenka#payment_cash` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_ulozenka#payment_cod` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_ulozenka#payment_bank_transfer` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_ulozenka#payment_credit_card` double DEFAULT NULL,
  `shippingDiscountOptionsCZ__step1#price` double DEFAULT NULL,
  `shippingDiscountOptionsCZ__step1#discount` double DEFAULT NULL,
  `shippingDiscountOptionsCZ__step1#ispercentual` tinyint(1) DEFAULT NULL,
  `shippingDiscountOptionsCZ__step2#price` double DEFAULT NULL,
  `shippingDiscountOptionsCZ__step2#discount` double DEFAULT NULL,
  `shippingDiscountOptionsCZ__step2#ispercentual` tinyint(1) DEFAULT NULL,
  `shippingDiscountOptionsCZ__step3#price` double DEFAULT NULL,
  `shippingDiscountOptionsCZ__step3#discount` double DEFAULT NULL,
  `shippingDiscountOptionsCZ__step3#ispercentual` tinyint(1) DEFAULT NULL,
  `shippingDiscountOptionsCZ__step4#price` double DEFAULT NULL,
  `shippingDiscountOptionsCZ__step4#discount` double DEFAULT NULL,
  `shippingDiscountOptionsCZ__step4#ispercentual` tinyint(1) DEFAULT NULL,
  `shippingOptionsSK__sk#shipping_pick_up` double DEFAULT NULL,
  `shippingOptionsSK__sk#shipping_ulozenka` double DEFAULT NULL,
  `paymentOptionsSK__shipping_pick_up#payment_cash` double DEFAULT NULL,
  `paymentOptionsSK__shipping_pick_up#payment_credit_card` double DEFAULT NULL,
  `paymentOptionsSK__shipping_ulozenka#payment_cash` double DEFAULT NULL,
  `paymentOptionsSK__shipping_ulozenka#payment_credit_card` double DEFAULT NULL,
  `shippingDiscountOptionsSK__step1#price` double DEFAULT NULL,
  `shippingDiscountOptionsSK__step1#discount` double DEFAULT NULL,
  `shippingDiscountOptionsSK__step1#ispercentual` tinyint(1) DEFAULT NULL,
  `shippingDiscountOptionsSK__step2#price` double DEFAULT NULL,
  `shippingDiscountOptionsSK__step2#discount` double DEFAULT NULL,
  `shippingDiscountOptionsSK__step2#ispercentual` tinyint(1) DEFAULT NULL,
  `shippingDiscountOptionsSK__step3#price` double DEFAULT NULL,
  `shippingDiscountOptionsSK__step3#discount` double DEFAULT NULL,
  `shippingDiscountOptionsSK__step3#ispercentual` tinyint(1) DEFAULT NULL,
  `shippingDiscountOptionsSK__step4#price` double DEFAULT NULL,
  `shippingDiscountOptionsSK__step4#discount` double DEFAULT NULL,
  `shippingDiscountOptionsSK__step4#ispercentual` tinyint(1) DEFAULT NULL,
  `shippingCostOptionsCZ__payment_cash#shipping_pick_up` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_cash#shipping_czech_post` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_cash#shipping_czech_ppl` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_cash#shipping_ulozenka` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_bank_transfer#shipping_pick_up` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_bank_transfer#shipping_czech_post` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_bank_transfer#shipping_czech_ppl` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_bank_transfer#shipping_ulozenka` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_credit_card#shipping_pick_up` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_credit_card#shipping_czech_post` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_credit_card#shipping_czech_ppl` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_credit_card#shipping_ulozenka` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_cod#shipping_pick_up` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_cod#shipping_czech_post` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_cod#shipping_czech_ppl` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_cod#shipping_ulozenka` double DEFAULT NULL,
  `shippingCostOptionsSK__payment_cash#shipping_pick_up` double DEFAULT NULL,
  `shippingCostOptionsSK__payment_cash#shipping_ulozenka` double DEFAULT NULL,
  `shippingCostOptionsSK__payment_credit_card#shipping_pick_up` double DEFAULT NULL,
  `shippingCostOptionsSK__payment_credit_card#shipping_ulozenka` double DEFAULT NULL,
  `exchangeRateShadow` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`oo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_query_10` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '10',
  `oo_className` varchar(255) DEFAULT 'User',
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `activationCode` varchar(255) DEFAULT NULL,
  `lang` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `street` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `zipCode` varchar(255) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `ico` varchar(255) DEFAULT NULL,
  `dic` varchar(255) DEFAULT NULL,
  `passwordResetToken` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_email` (`email`),
  KEY `p_index_activationCode` (`activationCode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_query_11` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '11',
  `oo_className` varchar(255) DEFAULT 'ProductColor',
  PRIMARY KEY (`oo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_query_12` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '12',
  `oo_className` varchar(255) DEFAULT 'ProductSize',
  PRIMARY KEY (`oo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_query_14` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `oo_classId` int(11) DEFAULT '14',
  `oo_className` varchar(255) DEFAULT 'Brand',
  `ordering` double DEFAULT NULL,
  `Name` varchar(255) DEFAULT NULL,
  `logo__image` int(11) DEFAULT NULL,
  `logo__hotspots` text,
  PRIMARY KEY (`oo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_relations_1` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  PRIMARY KEY (`src_id`,`dest_id`,`ownertype`,`ownername`,`fieldname`,`type`,`position`),
  KEY `index` (`index`),
  KEY `src_id` (`src_id`),
  KEY `dest_id` (`dest_id`),
  KEY `fieldname` (`fieldname`),
  KEY `position` (`position`),
  KEY `ownertype` (`ownertype`),
  KEY `type` (`type`),
  KEY `ownername` (`ownername`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_relations_2` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  PRIMARY KEY (`src_id`,`dest_id`,`ownertype`,`ownername`,`fieldname`,`type`,`position`),
  KEY `index` (`index`),
  KEY `src_id` (`src_id`),
  KEY `dest_id` (`dest_id`),
  KEY `fieldname` (`fieldname`),
  KEY `position` (`position`),
  KEY `ownertype` (`ownertype`),
  KEY `type` (`type`),
  KEY `ownername` (`ownername`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_relations_3` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  PRIMARY KEY (`src_id`,`dest_id`,`ownertype`,`ownername`,`fieldname`,`type`,`position`),
  KEY `index` (`index`),
  KEY `src_id` (`src_id`),
  KEY `dest_id` (`dest_id`),
  KEY `fieldname` (`fieldname`),
  KEY `position` (`position`),
  KEY `ownertype` (`ownertype`),
  KEY `type` (`type`),
  KEY `ownername` (`ownername`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_relations_4` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  PRIMARY KEY (`src_id`,`dest_id`,`ownertype`,`ownername`,`fieldname`,`type`,`position`),
  KEY `index` (`index`),
  KEY `src_id` (`src_id`),
  KEY `dest_id` (`dest_id`),
  KEY `fieldname` (`fieldname`),
  KEY `position` (`position`),
  KEY `ownertype` (`ownertype`),
  KEY `type` (`type`),
  KEY `ownername` (`ownername`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_relations_5` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  PRIMARY KEY (`src_id`,`dest_id`,`ownertype`,`ownername`,`fieldname`,`type`,`position`),
  KEY `index` (`index`),
  KEY `src_id` (`src_id`),
  KEY `dest_id` (`dest_id`),
  KEY `fieldname` (`fieldname`),
  KEY `position` (`position`),
  KEY `ownertype` (`ownertype`),
  KEY `type` (`type`),
  KEY `ownername` (`ownername`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_relations_6` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  PRIMARY KEY (`src_id`,`dest_id`,`ownertype`,`ownername`,`fieldname`,`type`,`position`),
  KEY `index` (`index`),
  KEY `src_id` (`src_id`),
  KEY `dest_id` (`dest_id`),
  KEY `fieldname` (`fieldname`),
  KEY `position` (`position`),
  KEY `ownertype` (`ownertype`),
  KEY `type` (`type`),
  KEY `ownername` (`ownername`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_relations_7` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  PRIMARY KEY (`src_id`,`dest_id`,`ownertype`,`ownername`,`fieldname`,`type`,`position`),
  KEY `index` (`index`),
  KEY `src_id` (`src_id`),
  KEY `dest_id` (`dest_id`),
  KEY `fieldname` (`fieldname`),
  KEY `position` (`position`),
  KEY `ownertype` (`ownertype`),
  KEY `type` (`type`),
  KEY `ownername` (`ownername`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_relations_8` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  PRIMARY KEY (`src_id`,`dest_id`,`ownertype`,`ownername`,`fieldname`,`type`,`position`),
  KEY `index` (`index`),
  KEY `src_id` (`src_id`),
  KEY `dest_id` (`dest_id`),
  KEY `fieldname` (`fieldname`),
  KEY `position` (`position`),
  KEY `ownertype` (`ownertype`),
  KEY `type` (`type`),
  KEY `ownername` (`ownername`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_relations_9` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  PRIMARY KEY (`src_id`,`dest_id`,`ownertype`,`ownername`,`fieldname`,`type`,`position`),
  KEY `index` (`index`),
  KEY `src_id` (`src_id`),
  KEY `dest_id` (`dest_id`),
  KEY `fieldname` (`fieldname`),
  KEY `position` (`position`),
  KEY `ownertype` (`ownertype`),
  KEY `type` (`type`),
  KEY `ownername` (`ownername`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_relations_10` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  PRIMARY KEY (`src_id`,`dest_id`,`ownertype`,`ownername`,`fieldname`,`type`,`position`),
  KEY `index` (`index`),
  KEY `src_id` (`src_id`),
  KEY `dest_id` (`dest_id`),
  KEY `fieldname` (`fieldname`),
  KEY `position` (`position`),
  KEY `ownertype` (`ownertype`),
  KEY `type` (`type`),
  KEY `ownername` (`ownername`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_relations_11` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  PRIMARY KEY (`src_id`,`dest_id`,`ownertype`,`ownername`,`fieldname`,`type`,`position`),
  KEY `index` (`index`),
  KEY `src_id` (`src_id`),
  KEY `dest_id` (`dest_id`),
  KEY `fieldname` (`fieldname`),
  KEY `position` (`position`),
  KEY `ownertype` (`ownertype`),
  KEY `type` (`type`),
  KEY `ownername` (`ownername`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_relations_12` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  PRIMARY KEY (`src_id`,`dest_id`,`ownertype`,`ownername`,`fieldname`,`type`,`position`),
  KEY `index` (`index`),
  KEY `src_id` (`src_id`),
  KEY `dest_id` (`dest_id`),
  KEY `fieldname` (`fieldname`),
  KEY `position` (`position`),
  KEY `ownertype` (`ownertype`),
  KEY `type` (`type`),
  KEY `ownername` (`ownername`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_relations_14` (
  `src_id` int(11) NOT NULL DEFAULT '0',
  `dest_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `fieldname` varchar(70) NOT NULL DEFAULT '0',
  `index` int(11) unsigned NOT NULL DEFAULT '0',
  `ownertype` enum('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object',
  `ownername` varchar(70) NOT NULL DEFAULT '',
  `position` varchar(70) NOT NULL DEFAULT '0',
  PRIMARY KEY (`src_id`,`dest_id`,`ownertype`,`ownername`,`fieldname`,`type`,`position`),
  KEY `index` (`index`),
  KEY `src_id` (`src_id`),
  KEY `dest_id` (`dest_id`),
  KEY `fieldname` (`fieldname`),
  KEY `position` (`position`),
  KEY `ownertype` (`ownertype`),
  KEY `type` (`type`),
  KEY `ownername` (`ownername`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_store_1` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `ordering` double DEFAULT NULL,
  `isLowVat` tinyint(1) DEFAULT NULL,
  `inStock` double DEFAULT NULL,
  `isNew` tinyint(1) DEFAULT NULL,
  `soldCount` double DEFAULT NULL,
  `isMasterProduct` double DEFAULT NULL,
  `priceCZ` double DEFAULT NULL,
  `discountedPriceCZ` double DEFAULT NULL,
  `priceSK` double DEFAULT NULL,
  `discountedPriceSK` double DEFAULT NULL,
  `ignoreSalePromotionsCZ` tinyint(1) DEFAULT NULL,
  `ignoreSalePromotionsSK` tinyint(1) DEFAULT NULL,
  `costCZ` double DEFAULT NULL,
  `costSK` double DEFAULT NULL,
  `colors` varchar(255) DEFAULT NULL,
  `sizes` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_ordering` (`ordering`),
  KEY `p_index_inStock` (`inStock`),
  KEY `p_index_soldCount` (`soldCount`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_store_2` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `ordering` double DEFAULT NULL,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_ordering` (`ordering`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_store_3` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `orderId` varchar(255) DEFAULT NULL,
  `paymentType` varchar(255) DEFAULT NULL,
  `shippingType` varchar(255) DEFAULT NULL,
  `productsPrice` double DEFAULT NULL,
  `shippingPrice` double DEFAULT NULL,
  `finalPrice` double DEFAULT NULL,
  `currency` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `message` longtext,
  `fCompany` varchar(255) DEFAULT NULL,
  `fStreet` varchar(255) DEFAULT NULL,
  `fCity` varchar(255) DEFAULT NULL,
  `fZipCode` varchar(255) DEFAULT NULL,
  `fEmail` varchar(255) DEFAULT NULL,
  `fPhone` varchar(255) DEFAULT NULL,
  `fIco` varchar(255) DEFAULT NULL,
  `fDic` varchar(255) DEFAULT NULL,
  `dCompany` varchar(255) DEFAULT NULL,
  `dStreet` varchar(255) DEFAULT NULL,
  `dCity` varchar(255) DEFAULT NULL,
  `dZipCode` varchar(255) DEFAULT NULL,
  `showInvoice` tinyint(1) DEFAULT NULL,
  `issuedOn` bigint(20) DEFAULT NULL,
  `dueTo` bigint(20) DEFAULT NULL,
  `vatLow` double DEFAULT NULL,
  `vatHigh` double DEFAULT NULL,
  `paymentPrice` double DEFAULT NULL,
  `paid` tinyint(1) DEFAULT NULL,
  `gpeWebPayTimestamp` varchar(255) DEFAULT NULL,
  `gpeWebPayNote` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fFirstName` varchar(255) DEFAULT NULL,
  `fLastName` varchar(255) DEFAULT NULL,
  `dFirstName` varchar(255) DEFAULT NULL,
  `dLastName` varchar(255) DEFAULT NULL,
  `isTaxPayer` tinyint(1) DEFAULT NULL,
  `invoiceId` varchar(255) DEFAULT NULL,
  `creditNoteId` varchar(255) DEFAULT NULL,
  `cnIssuedOn` bigint(20) DEFAULT NULL,
  `cnDueTo` bigint(20) DEFAULT NULL,
  `trackingNumber` varchar(255) DEFAULT NULL,
  `paidShadow` tinyint(1) DEFAULT NULL,
  `fromStore` tinyint(1) DEFAULT NULL,
  `ulozenkaAddress` varchar(255) DEFAULT NULL,
  `shippingDiscount` double DEFAULT NULL,
  `paymentDiscount` double DEFAULT NULL,
  `productsDiscount` double DEFAULT NULL,
  `statusShadow` varchar(255) DEFAULT NULL,
  `shippingCost` double DEFAULT NULL,
  `paymentCost` double DEFAULT NULL,
  `baseShippingPrice` double DEFAULT NULL,
  `basePaymentPrice` double DEFAULT NULL,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_paid` (`paid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_store_4` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `createdOn` bigint(20) DEFAULT NULL,
  `previewImage__image` int(11) DEFAULT NULL,
  `previewImage__hotspots` text,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_createdOn` (`createdOn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_store_5` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `fullName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `message` longtext,
  `lang` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`oo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_store_6` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `email` varchar(255) DEFAULT NULL,
  `lang` varchar(255) DEFAULT NULL,
  `unsubscribeCode` varchar(255) DEFAULT NULL,
  `firstname` varchar(255) DEFAULT NULL,
  `lastname` varchar(255) DEFAULT NULL,
  `gender` varchar(255) DEFAULT NULL,
  `newsletterActive` tinyint(1) DEFAULT NULL,
  `newsletterConfirmed` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_unsubscribeCode` (`unsubscribeCode`),
  KEY `p_index_email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_store_7` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `code` varchar(255) DEFAULT NULL,
  `activeSince` bigint(20) DEFAULT NULL,
  `activeUntil` bigint(20) DEFAULT NULL,
  `used` tinyint(1) DEFAULT NULL,
  `isPercentual` tinyint(1) DEFAULT NULL,
  `reusable` tinyint(1) DEFAULT NULL,
  `discountCZ` double DEFAULT NULL,
  `discountSK` double DEFAULT NULL,
  `applyOnShipping` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_code` (`code`),
  KEY `p_index_activeSince` (`activeSince`),
  KEY `p_index_activeUntil` (`activeUntil`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_store_8` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `isPercentual` tinyint(1) DEFAULT NULL,
  `discountCZ` double DEFAULT NULL,
  `discountSK` double DEFAULT NULL,
  PRIMARY KEY (`oo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_store_9` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `vatHigh` double DEFAULT NULL,
  `vatLow` double DEFAULT NULL,
  `exchangeRate__cs_cz#rate` double DEFAULT NULL,
  `exchangeRate__cs_cz#isdefault` tinyint(1) DEFAULT NULL,
  `exchangeRate__cs_cz#isactive` tinyint(1) DEFAULT NULL,
  `exchangeRate__sk_sk#rate` double DEFAULT NULL,
  `exchangeRate__sk_sk#isdefault` tinyint(1) DEFAULT NULL,
  `exchangeRate__sk_sk#isactive` tinyint(1) DEFAULT NULL,
  `supplierName` varchar(255) DEFAULT NULL,
  `supplierStreet` varchar(255) DEFAULT NULL,
  `supplierCity` varchar(255) DEFAULT NULL,
  `supplierZip` varchar(255) DEFAULT NULL,
  `supplierIco` varchar(255) DEFAULT NULL,
  `supplierDic` varchar(255) DEFAULT NULL,
  `invoiceTitle` varchar(255) DEFAULT NULL,
  `supplierAccountNumber` varchar(255) DEFAULT NULL,
  `supplierIsTaxPayer` tinyint(1) DEFAULT NULL,
  `supplierStamp__image` int(11) DEFAULT NULL,
  `supplierStamp__hotspots` text,
  `outOfStockBehaviour` varchar(255) DEFAULT NULL,
  `productPageLimit` double DEFAULT NULL,
  `dailyCost` double DEFAULT NULL,
  `showVariantsInLists` tinyint(1) DEFAULT NULL,
  `shippingOptionsCZ__cz#shipping_pick_up` double DEFAULT NULL,
  `shippingOptionsCZ__cz#shipping_czech_ppl` double DEFAULT NULL,
  `shippingOptionsCZ__cz#shipping_czech_post` double DEFAULT NULL,
  `shippingOptionsCZ__cz#shipping_ulozenka` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_pick_up#payment_cash` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_pick_up#payment_cod` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_pick_up#payment_bank_transfer` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_pick_up#payment_credit_card` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_czech_ppl#payment_cash` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_czech_ppl#payment_cod` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_czech_ppl#payment_bank_transfer` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_czech_ppl#payment_credit_card` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_czech_post#payment_cash` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_czech_post#payment_cod` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_czech_post#payment_bank_transfer` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_czech_post#payment_credit_card` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_ulozenka#payment_cash` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_ulozenka#payment_cod` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_ulozenka#payment_bank_transfer` double DEFAULT NULL,
  `paymentOptionsCZ__shipping_ulozenka#payment_credit_card` double DEFAULT NULL,
  `shippingDiscountOptionsCZ__step1#price` double DEFAULT NULL,
  `shippingDiscountOptionsCZ__step1#discount` double DEFAULT NULL,
  `shippingDiscountOptionsCZ__step1#ispercentual` tinyint(1) DEFAULT NULL,
  `shippingDiscountOptionsCZ__step2#price` double DEFAULT NULL,
  `shippingDiscountOptionsCZ__step2#discount` double DEFAULT NULL,
  `shippingDiscountOptionsCZ__step2#ispercentual` tinyint(1) DEFAULT NULL,
  `shippingDiscountOptionsCZ__step3#price` double DEFAULT NULL,
  `shippingDiscountOptionsCZ__step3#discount` double DEFAULT NULL,
  `shippingDiscountOptionsCZ__step3#ispercentual` tinyint(1) DEFAULT NULL,
  `shippingDiscountOptionsCZ__step4#price` double DEFAULT NULL,
  `shippingDiscountOptionsCZ__step4#discount` double DEFAULT NULL,
  `shippingDiscountOptionsCZ__step4#ispercentual` tinyint(1) DEFAULT NULL,
  `shippingOptionsSK__sk#shipping_pick_up` double DEFAULT NULL,
  `shippingOptionsSK__sk#shipping_ulozenka` double DEFAULT NULL,
  `paymentOptionsSK__shipping_pick_up#payment_cash` double DEFAULT NULL,
  `paymentOptionsSK__shipping_pick_up#payment_credit_card` double DEFAULT NULL,
  `paymentOptionsSK__shipping_ulozenka#payment_cash` double DEFAULT NULL,
  `paymentOptionsSK__shipping_ulozenka#payment_credit_card` double DEFAULT NULL,
  `shippingDiscountOptionsSK__step1#price` double DEFAULT NULL,
  `shippingDiscountOptionsSK__step1#discount` double DEFAULT NULL,
  `shippingDiscountOptionsSK__step1#ispercentual` tinyint(1) DEFAULT NULL,
  `shippingDiscountOptionsSK__step2#price` double DEFAULT NULL,
  `shippingDiscountOptionsSK__step2#discount` double DEFAULT NULL,
  `shippingDiscountOptionsSK__step2#ispercentual` tinyint(1) DEFAULT NULL,
  `shippingDiscountOptionsSK__step3#price` double DEFAULT NULL,
  `shippingDiscountOptionsSK__step3#discount` double DEFAULT NULL,
  `shippingDiscountOptionsSK__step3#ispercentual` tinyint(1) DEFAULT NULL,
  `shippingDiscountOptionsSK__step4#price` double DEFAULT NULL,
  `shippingDiscountOptionsSK__step4#discount` double DEFAULT NULL,
  `shippingDiscountOptionsSK__step4#ispercentual` tinyint(1) DEFAULT NULL,
  `shippingCostOptionsCZ__payment_cash#shipping_pick_up` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_cash#shipping_czech_post` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_cash#shipping_czech_ppl` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_cash#shipping_ulozenka` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_bank_transfer#shipping_pick_up` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_bank_transfer#shipping_czech_post` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_bank_transfer#shipping_czech_ppl` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_bank_transfer#shipping_ulozenka` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_credit_card#shipping_pick_up` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_credit_card#shipping_czech_post` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_credit_card#shipping_czech_ppl` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_credit_card#shipping_ulozenka` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_cod#shipping_pick_up` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_cod#shipping_czech_post` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_cod#shipping_czech_ppl` double DEFAULT NULL,
  `shippingCostOptionsCZ__payment_cod#shipping_ulozenka` double DEFAULT NULL,
  `shippingCostOptionsSK__payment_cash#shipping_pick_up` double DEFAULT NULL,
  `shippingCostOptionsSK__payment_cash#shipping_ulozenka` double DEFAULT NULL,
  `shippingCostOptionsSK__payment_credit_card#shipping_pick_up` double DEFAULT NULL,
  `shippingCostOptionsSK__payment_credit_card#shipping_ulozenka` double DEFAULT NULL,
  `exchangeRateShadow` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`oo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_store_10` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `activationCode` varchar(255) DEFAULT NULL,
  `lang` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `street` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `zipCode` varchar(255) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `ico` varchar(255) DEFAULT NULL,
  `dic` varchar(255) DEFAULT NULL,
  `passwordResetToken` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`oo_id`),
  KEY `p_index_email` (`email`),
  KEY `p_index_activationCode` (`activationCode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_store_11` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`oo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_store_12` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`oo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `object_store_14` (
  `oo_id` int(11) NOT NULL DEFAULT '0',
  `ordering` double DEFAULT NULL,
  `Name` varchar(255) DEFAULT NULL,
  `logo__image` int(11) DEFAULT NULL,
  `logo__hotspots` text,
  PRIMARY KEY (`oo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `eshop_old_paths` (
	`id` int(11) NOT NULL AUTO_INCREMENT,
	`o_id` int(11) NOT NULL,
	`class` int(3) NOT NULL,
	`translatedPath` VARCHAR(255),
	`language` VARCHAR(8),
	PRIMARY KEY (`id`),
	KEY `key_o_id` (`o_id`),
	KEY `key_class` (`class`),
	KEY `key_translatedPath` (`translatedPath`),
	KEY `key_language` (`language`)
)ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `object_1`;
DROP VIEW IF EXISTS `object_1`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `object_1` AS select `object_query_1`.`oo_id` AS `oo_id`,`object_query_1`.`oo_classId` AS `oo_classId`,`object_query_1`.`oo_className` AS `oo_className`,`object_query_1`.`ordering` AS `ordering`,`object_query_1`.`isLowVat` AS `isLowVat`,`object_query_1`.`gallery` AS `gallery`,`object_query_1`.`inStock` AS `inStock`,`object_query_1`.`isNew` AS `isNew`,`object_query_1`.`soldCount` AS `soldCount`,`object_query_1`.`brand__id` AS `brand__id`,`object_query_1`.`brand__type` AS `brand__type`,`object_query_1`.`isMasterProduct` AS `isMasterProduct`,`object_query_1`.`priceCZ` AS `priceCZ`,`object_query_1`.`discountedPriceCZ` AS `discountedPriceCZ`,`object_query_1`.`priceSK` AS `priceSK`,`object_query_1`.`discountedPriceSK` AS `discountedPriceSK`,`object_query_1`.`ignoreSalePromotionsCZ` AS `ignoreSalePromotionsCZ`,`object_query_1`.`ignoreSalePromotionsSK` AS `ignoreSalePromotionsSK`,`object_query_1`.`costCZ` AS `costCZ`,`object_query_1`.`costSK` AS `costSK`,`object_query_1`.`colors` AS `colors`,`object_query_1`.`sizes` AS `sizes`,`object_query_1`.`additionalCategories` AS `additionalCategories`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className` from (`object_query_1` join `objects` on((`objects`.`o_id` = `object_query_1`.`oo_id`)));

DROP TABLE IF EXISTS `object_2`;
DROP VIEW IF EXISTS `object_2`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `object_2` AS select `object_query_2`.`oo_id` AS `oo_id`,`object_query_2`.`oo_classId` AS `oo_classId`,`object_query_2`.`oo_className` AS `oo_className`,`object_query_2`.`ordering` AS `ordering`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className` from (`object_query_2` join `objects` on((`objects`.`o_id` = `object_query_2`.`oo_id`)));

DROP TABLE IF EXISTS `object_3`;
DROP VIEW IF EXISTS `object_3`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `object_3` AS select `object_query_3`.`oo_id` AS `oo_id`,`object_query_3`.`oo_classId` AS `oo_classId`,`object_query_3`.`oo_className` AS `oo_className`,`object_query_3`.`orderId` AS `orderId`,`object_query_3`.`paymentType` AS `paymentType`,`object_query_3`.`shippingType` AS `shippingType`,`object_query_3`.`productsPrice` AS `productsPrice`,`object_query_3`.`shippingPrice` AS `shippingPrice`,`object_query_3`.`finalPrice` AS `finalPrice`,`object_query_3`.`currency` AS `currency`,`object_query_3`.`country` AS `country`,`object_query_3`.`message` AS `message`,`object_query_3`.`fCompany` AS `fCompany`,`object_query_3`.`fStreet` AS `fStreet`,`object_query_3`.`fCity` AS `fCity`,`object_query_3`.`fZipCode` AS `fZipCode`,`object_query_3`.`fEmail` AS `fEmail`,`object_query_3`.`fPhone` AS `fPhone`,`object_query_3`.`fIco` AS `fIco`,`object_query_3`.`fDic` AS `fDic`,`object_query_3`.`dCompany` AS `dCompany`,`object_query_3`.`dStreet` AS `dStreet`,`object_query_3`.`dCity` AS `dCity`,`object_query_3`.`dZipCode` AS `dZipCode`,`object_query_3`.`user__id` AS `user__id`,`object_query_3`.`user__type` AS `user__type`,`object_query_3`.`discountCode__id` AS `discountCode__id`,`object_query_3`.`discountCode__type` AS `discountCode__type`,`object_query_3`.`showInvoice` AS `showInvoice`,`object_query_3`.`issuedOn` AS `issuedOn`,`object_query_3`.`dueTo` AS `dueTo`,`object_query_3`.`vatLow` AS `vatLow`,`object_query_3`.`vatHigh` AS `vatHigh`,`object_query_3`.`paymentPrice` AS `paymentPrice`,`object_query_3`.`paid` AS `paid`,`object_query_3`.`gpeWebPayTimestamp` AS `gpeWebPayTimestamp`,`object_query_3`.`gpeWebPayNote` AS `gpeWebPayNote`,`object_query_3`.`status` AS `status`,`object_query_3`.`fFirstName` AS `fFirstName`,`object_query_3`.`fLastName` AS `fLastName`,`object_query_3`.`dFirstName` AS `dFirstName`,`object_query_3`.`dLastName` AS `dLastName`,`object_query_3`.`isTaxPayer` AS `isTaxPayer`,`object_query_3`.`invoiceId` AS `invoiceId`,`object_query_3`.`creditNoteId` AS `creditNoteId`,`object_query_3`.`cnIssuedOn` AS `cnIssuedOn`,`object_query_3`.`cnDueTo` AS `cnDueTo`,`object_query_3`.`trackingNumber` AS `trackingNumber`,`object_query_3`.`paidShadow` AS `paidShadow`,`object_query_3`.`fromStore` AS `fromStore`,`object_query_3`.`ulozenkaAddress` AS `ulozenkaAddress`,`object_query_3`.`shippingDiscount` AS `shippingDiscount`,`object_query_3`.`paymentDiscount` AS `paymentDiscount`,`object_query_3`.`productsDiscount` AS `productsDiscount`,`object_query_3`.`statusShadow` AS `statusShadow`,`object_query_3`.`shippingCost` AS `shippingCost`,`object_query_3`.`paymentCost` AS `paymentCost`,`object_query_3`.`baseShippingPrice` AS `baseShippingPrice`,`object_query_3`.`basePaymentPrice` AS `basePaymentPrice`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className` from (`object_query_3` join `objects` on((`objects`.`o_id` = `object_query_3`.`oo_id`)));

DROP TABLE IF EXISTS `object_4`;
DROP VIEW IF EXISTS `object_4`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `object_4` AS select `object_query_4`.`oo_id` AS `oo_id`,`object_query_4`.`oo_classId` AS `oo_classId`,`object_query_4`.`oo_className` AS `oo_className`,`object_query_4`.`createdOn` AS `createdOn`,`object_query_4`.`previewImage__image` AS `previewImage__image`,`object_query_4`.`previewImage__hotspots` AS `previewImage__hotspots`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className` from (`object_query_4` join `objects` on((`objects`.`o_id` = `object_query_4`.`oo_id`)));

DROP TABLE IF EXISTS `object_5`;
DROP VIEW IF EXISTS `object_5`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `object_5` AS select `object_query_5`.`oo_id` AS `oo_id`,`object_query_5`.`oo_classId` AS `oo_classId`,`object_query_5`.`oo_className` AS `oo_className`,`object_query_5`.`fullName` AS `fullName`,`object_query_5`.`email` AS `email`,`object_query_5`.`phone` AS `phone`,`object_query_5`.`message` AS `message`,`object_query_5`.`lang` AS `lang`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className` from (`object_query_5` join `objects` on((`objects`.`o_id` = `object_query_5`.`oo_id`)));

DROP TABLE IF EXISTS `object_6`;
DROP VIEW IF EXISTS `object_6`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `object_6` AS select `object_query_6`.`oo_id` AS `oo_id`,`object_query_6`.`oo_classId` AS `oo_classId`,`object_query_6`.`oo_className` AS `oo_className`,`object_query_6`.`email` AS `email`,`object_query_6`.`lang` AS `lang`,`object_query_6`.`unsubscribeCode` AS `unsubscribeCode`,`object_query_6`.`firstname` AS `firstname`,`object_query_6`.`lastname` AS `lastname`,`object_query_6`.`gender` AS `gender`,`object_query_6`.`newsletterActive` AS `newsletterActive`,`object_query_6`.`newsletterConfirmed` AS `newsletterConfirmed`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className` from (`object_query_6` join `objects` on((`objects`.`o_id` = `object_query_6`.`oo_id`)));

DROP TABLE IF EXISTS `object_7`;
DROP VIEW IF EXISTS `object_7`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `object_7` AS select `object_query_7`.`oo_id` AS `oo_id`,`object_query_7`.`oo_classId` AS `oo_classId`,`object_query_7`.`oo_className` AS `oo_className`,`object_query_7`.`code` AS `code`,`object_query_7`.`activeSince` AS `activeSince`,`object_query_7`.`activeUntil` AS `activeUntil`,`object_query_7`.`used` AS `used`,`object_query_7`.`isPercentual` AS `isPercentual`,`object_query_7`.`reusable` AS `reusable`,`object_query_7`.`discountCZ` AS `discountCZ`,`object_query_7`.`discountSK` AS `discountSK`,`object_query_7`.`applyOnShipping` AS `applyOnShipping`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className` from (`object_query_7` join `objects` on((`objects`.`o_id` = `object_query_7`.`oo_id`)));

DROP TABLE IF EXISTS `object_8`;
DROP VIEW IF EXISTS `object_8`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `object_8` AS select `object_query_8`.`oo_id` AS `oo_id`,`object_query_8`.`oo_classId` AS `oo_classId`,`object_query_8`.`oo_className` AS `oo_className`,`object_query_8`.`includedProducts` AS `includedProducts`,`object_query_8`.`isPercentual` AS `isPercentual`,`object_query_8`.`discountCZ` AS `discountCZ`,`object_query_8`.`discountSK` AS `discountSK`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className` from (`object_query_8` join `objects` on((`objects`.`o_id` = `object_query_8`.`oo_id`)));

DROP TABLE IF EXISTS `object_9`;
DROP VIEW IF EXISTS `object_9`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `object_9` AS select `object_query_9`.`oo_id` AS `oo_id`,`object_query_9`.`oo_classId` AS `oo_classId`,`object_query_9`.`oo_className` AS `oo_className`,`object_query_9`.`vatHigh` AS `vatHigh`,`object_query_9`.`vatLow` AS `vatLow`,`object_query_9`.`exchangeRate__cs_cz#rate` AS `exchangeRate__cs_cz#rate`,`object_query_9`.`exchangeRate__cs_cz#isdefault` AS `exchangeRate__cs_cz#isdefault`,`object_query_9`.`exchangeRate__cs_cz#isactive` AS `exchangeRate__cs_cz#isactive`,`object_query_9`.`exchangeRate__sk_sk#rate` AS `exchangeRate__sk_sk#rate`,`object_query_9`.`exchangeRate__sk_sk#isdefault` AS `exchangeRate__sk_sk#isdefault`,`object_query_9`.`exchangeRate__sk_sk#isactive` AS `exchangeRate__sk_sk#isactive`,`object_query_9`.`supplierName` AS `supplierName`,`object_query_9`.`supplierStreet` AS `supplierStreet`,`object_query_9`.`supplierCity` AS `supplierCity`,`object_query_9`.`supplierZip` AS `supplierZip`,`object_query_9`.`supplierIco` AS `supplierIco`,`object_query_9`.`supplierDic` AS `supplierDic`,`object_query_9`.`invoiceTitle` AS `invoiceTitle`,`object_query_9`.`supplierAccountNumber` AS `supplierAccountNumber`,`object_query_9`.`supplierIsTaxPayer` AS `supplierIsTaxPayer`,`object_query_9`.`outOfStockBehaviour` AS `outOfStockBehaviour`,`object_query_9`.`productPageLimit` AS `productPageLimit`,`object_query_9`.`dailyCost` AS `dailyCost`,`object_query_9`.`showVariantsInLists` AS `showVariantsInLists`,`object_query_9`.`shippingOptionsCZ__cz#shipping_pick_up` AS `shippingOptionsCZ__cz#shipping_pick_up`,`object_query_9`.`shippingOptionsCZ__cz#shipping_czech_ppl` AS `shippingOptionsCZ__cz#shipping_czech_ppl`,`object_query_9`.`shippingOptionsCZ__cz#shipping_czech_post` AS `shippingOptionsCZ__cz#shipping_czech_post`,`object_query_9`.`shippingOptionsCZ__cz#shipping_ulozenka` AS `shippingOptionsCZ__cz#shipping_ulozenka`,`object_query_9`.`paymentOptionsCZ__shipping_pick_up#payment_cash` AS `paymentOptionsCZ__shipping_pick_up#payment_cash`,`object_query_9`.`paymentOptionsCZ__shipping_pick_up#payment_cod` AS `paymentOptionsCZ__shipping_pick_up#payment_cod`,`object_query_9`.`paymentOptionsCZ__shipping_pick_up#payment_bank_transfer` AS `paymentOptionsCZ__shipping_pick_up#payment_bank_transfer`,`object_query_9`.`paymentOptionsCZ__shipping_pick_up#payment_credit_card` AS `paymentOptionsCZ__shipping_pick_up#payment_credit_card`,`object_query_9`.`paymentOptionsCZ__shipping_czech_ppl#payment_cash` AS `paymentOptionsCZ__shipping_czech_ppl#payment_cash`,`object_query_9`.`paymentOptionsCZ__shipping_czech_ppl#payment_cod` AS `paymentOptionsCZ__shipping_czech_ppl#payment_cod`,`object_query_9`.`paymentOptionsCZ__shipping_czech_ppl#payment_bank_transfer` AS `paymentOptionsCZ__shipping_czech_ppl#payment_bank_transfer`,`object_query_9`.`paymentOptionsCZ__shipping_czech_ppl#payment_credit_card` AS `paymentOptionsCZ__shipping_czech_ppl#payment_credit_card`,`object_query_9`.`paymentOptionsCZ__shipping_czech_post#payment_cash` AS `paymentOptionsCZ__shipping_czech_post#payment_cash`,`object_query_9`.`paymentOptionsCZ__shipping_czech_post#payment_cod` AS `paymentOptionsCZ__shipping_czech_post#payment_cod`,`object_query_9`.`paymentOptionsCZ__shipping_czech_post#payment_bank_transfer` AS `paymentOptionsCZ__shipping_czech_post#payment_bank_transfer`,`object_query_9`.`paymentOptionsCZ__shipping_czech_post#payment_credit_card` AS `paymentOptionsCZ__shipping_czech_post#payment_credit_card`,`object_query_9`.`paymentOptionsCZ__shipping_ulozenka#payment_cash` AS `paymentOptionsCZ__shipping_ulozenka#payment_cash`,`object_query_9`.`paymentOptionsCZ__shipping_ulozenka#payment_cod` AS `paymentOptionsCZ__shipping_ulozenka#payment_cod`,`object_query_9`.`paymentOptionsCZ__shipping_ulozenka#payment_bank_transfer` AS `paymentOptionsCZ__shipping_ulozenka#payment_bank_transfer`,`object_query_9`.`paymentOptionsCZ__shipping_ulozenka#payment_credit_card` AS `paymentOptionsCZ__shipping_ulozenka#payment_credit_card`,`object_query_9`.`shippingDiscountOptionsCZ__step1#price` AS `shippingDiscountOptionsCZ__step1#price`,`object_query_9`.`shippingDiscountOptionsCZ__step1#discount` AS `shippingDiscountOptionsCZ__step1#discount`,`object_query_9`.`shippingDiscountOptionsCZ__step1#ispercentual` AS `shippingDiscountOptionsCZ__step1#ispercentual`,`object_query_9`.`shippingDiscountOptionsCZ__step2#price` AS `shippingDiscountOptionsCZ__step2#price`,`object_query_9`.`shippingDiscountOptionsCZ__step2#discount` AS `shippingDiscountOptionsCZ__step2#discount`,`object_query_9`.`shippingDiscountOptionsCZ__step2#ispercentual` AS `shippingDiscountOptionsCZ__step2#ispercentual`,`object_query_9`.`shippingDiscountOptionsCZ__step3#price` AS `shippingDiscountOptionsCZ__step3#price`,`object_query_9`.`shippingDiscountOptionsCZ__step3#discount` AS `shippingDiscountOptionsCZ__step3#discount`,`object_query_9`.`shippingDiscountOptionsCZ__step3#ispercentual` AS `shippingDiscountOptionsCZ__step3#ispercentual`,`object_query_9`.`shippingDiscountOptionsCZ__step4#price` AS `shippingDiscountOptionsCZ__step4#price`,`object_query_9`.`shippingDiscountOptionsCZ__step4#discount` AS `shippingDiscountOptionsCZ__step4#discount`,`object_query_9`.`shippingDiscountOptionsCZ__step4#ispercentual` AS `shippingDiscountOptionsCZ__step4#ispercentual`,`object_query_9`.`shippingOptionsSK__sk#shipping_pick_up` AS `shippingOptionsSK__sk#shipping_pick_up`,`object_query_9`.`shippingOptionsSK__sk#shipping_ulozenka` AS `shippingOptionsSK__sk#shipping_ulozenka`,`object_query_9`.`paymentOptionsSK__shipping_pick_up#payment_cash` AS `paymentOptionsSK__shipping_pick_up#payment_cash`,`object_query_9`.`paymentOptionsSK__shipping_pick_up#payment_credit_card` AS `paymentOptionsSK__shipping_pick_up#payment_credit_card`,`object_query_9`.`paymentOptionsSK__shipping_ulozenka#payment_cash` AS `paymentOptionsSK__shipping_ulozenka#payment_cash`,`object_query_9`.`paymentOptionsSK__shipping_ulozenka#payment_credit_card` AS `paymentOptionsSK__shipping_ulozenka#payment_credit_card`,`object_query_9`.`shippingDiscountOptionsSK__step1#price` AS `shippingDiscountOptionsSK__step1#price`,`object_query_9`.`shippingDiscountOptionsSK__step1#discount` AS `shippingDiscountOptionsSK__step1#discount`,`object_query_9`.`shippingDiscountOptionsSK__step1#ispercentual` AS `shippingDiscountOptionsSK__step1#ispercentual`,`object_query_9`.`shippingDiscountOptionsSK__step2#price` AS `shippingDiscountOptionsSK__step2#price`,`object_query_9`.`shippingDiscountOptionsSK__step2#discount` AS `shippingDiscountOptionsSK__step2#discount`,`object_query_9`.`shippingDiscountOptionsSK__step2#ispercentual` AS `shippingDiscountOptionsSK__step2#ispercentual`,`object_query_9`.`shippingDiscountOptionsSK__step3#price` AS `shippingDiscountOptionsSK__step3#price`,`object_query_9`.`shippingDiscountOptionsSK__step3#discount` AS `shippingDiscountOptionsSK__step3#discount`,`object_query_9`.`shippingDiscountOptionsSK__step3#ispercentual` AS `shippingDiscountOptionsSK__step3#ispercentual`,`object_query_9`.`shippingDiscountOptionsSK__step4#price` AS `shippingDiscountOptionsSK__step4#price`,`object_query_9`.`shippingDiscountOptionsSK__step4#discount` AS `shippingDiscountOptionsSK__step4#discount`,`object_query_9`.`shippingDiscountOptionsSK__step4#ispercentual` AS `shippingDiscountOptionsSK__step4#ispercentual`,`object_query_9`.`shippingCostOptionsCZ__payment_cash#shipping_pick_up` AS `shippingCostOptionsCZ__payment_cash#shipping_pick_up`,`object_query_9`.`shippingCostOptionsCZ__payment_cash#shipping_czech_post` AS `shippingCostOptionsCZ__payment_cash#shipping_czech_post`,`object_query_9`.`shippingCostOptionsCZ__payment_cash#shipping_czech_ppl` AS `shippingCostOptionsCZ__payment_cash#shipping_czech_ppl`,`object_query_9`.`shippingCostOptionsCZ__payment_cash#shipping_ulozenka` AS `shippingCostOptionsCZ__payment_cash#shipping_ulozenka`,`object_query_9`.`shippingCostOptionsCZ__payment_bank_transfer#shipping_pick_up` AS `shippingCostOptionsCZ__payment_bank_transfer#shipping_pick_up`,`object_query_9`.`shippingCostOptionsCZ__payment_bank_transfer#shipping_czech_post` AS `shippingCostOptionsCZ__payment_bank_transfer#shipping_czech_post`,`object_query_9`.`shippingCostOptionsCZ__payment_bank_transfer#shipping_czech_ppl` AS `shippingCostOptionsCZ__payment_bank_transfer#shipping_czech_ppl`,`object_query_9`.`shippingCostOptionsCZ__payment_bank_transfer#shipping_ulozenka` AS `shippingCostOptionsCZ__payment_bank_transfer#shipping_ulozenka`,`object_query_9`.`shippingCostOptionsCZ__payment_credit_card#shipping_pick_up` AS `shippingCostOptionsCZ__payment_credit_card#shipping_pick_up`,`object_query_9`.`shippingCostOptionsCZ__payment_credit_card#shipping_czech_post` AS `shippingCostOptionsCZ__payment_credit_card#shipping_czech_post`,`object_query_9`.`shippingCostOptionsCZ__payment_credit_card#shipping_czech_ppl` AS `shippingCostOptionsCZ__payment_credit_card#shipping_czech_ppl`,`object_query_9`.`shippingCostOptionsCZ__payment_credit_card#shipping_ulozenka` AS `shippingCostOptionsCZ__payment_credit_card#shipping_ulozenka`,`object_query_9`.`shippingCostOptionsCZ__payment_cod#shipping_pick_up` AS `shippingCostOptionsCZ__payment_cod#shipping_pick_up`,`object_query_9`.`shippingCostOptionsCZ__payment_cod#shipping_czech_post` AS `shippingCostOptionsCZ__payment_cod#shipping_czech_post`,`object_query_9`.`shippingCostOptionsCZ__payment_cod#shipping_czech_ppl` AS `shippingCostOptionsCZ__payment_cod#shipping_czech_ppl`,`object_query_9`.`shippingCostOptionsCZ__payment_cod#shipping_ulozenka` AS `shippingCostOptionsCZ__payment_cod#shipping_ulozenka`,`object_query_9`.`shippingCostOptionsSK__payment_cash#shipping_pick_up` AS `shippingCostOptionsSK__payment_cash#shipping_pick_up`,`object_query_9`.`shippingCostOptionsSK__payment_cash#shipping_ulozenka` AS `shippingCostOptionsSK__payment_cash#shipping_ulozenka`,`object_query_9`.`shippingCostOptionsSK__payment_credit_card#shipping_pick_up` AS `shippingCostOptionsSK__payment_credit_card#shipping_pick_up`,`object_query_9`.`shippingCostOptionsSK__payment_credit_card#shipping_ulozenka` AS `shippingCostOptionsSK__payment_credit_card#shipping_ulozenka`,`object_query_9`.`exchangeRateShadow` AS `exchangeRateShadow`,`object_query_9`.`supplierStamp__image` AS `supplierStamp__image`,`object_query_9`.`supplierStamp__hotspots` AS `supplierStamp__hotspots`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className` from (`object_query_9` join `objects` on((`objects`.`o_id` = `object_query_9`.`oo_id`)));

DROP TABLE IF EXISTS `object_10`;
DROP VIEW IF EXISTS `object_10`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `object_10` AS select `object_query_10`.`oo_id` AS `oo_id`,`object_query_10`.`oo_classId` AS `oo_classId`,`object_query_10`.`oo_className` AS `oo_className`,`object_query_10`.`email` AS `email`,`object_query_10`.`password` AS `password`,`object_query_10`.`activationCode` AS `activationCode`,`object_query_10`.`lang` AS `lang`,`object_query_10`.`firstName` AS `firstName`,`object_query_10`.`lastName` AS `lastName`,`object_query_10`.`phone` AS `phone`,`object_query_10`.`street` AS `street`,`object_query_10`.`city` AS `city`,`object_query_10`.`zipCode` AS `zipCode`,`object_query_10`.`company` AS `company`,`object_query_10`.`ico` AS `ico`,`object_query_10`.`dic` AS `dic`,`object_query_10`.`passwordResetToken` AS `passwordResetToken`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className` from (`object_query_10` join `objects` on((`objects`.`o_id` = `object_query_10`.`oo_id`)));

DROP TABLE IF EXISTS `object_11`;
DROP VIEW IF EXISTS `object_11`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `object_11` AS select `object_query_11`.`oo_id` AS `oo_id`,`object_query_11`.`oo_classId` AS `oo_classId`,`object_query_11`.`oo_className` AS `oo_className`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className` from (`object_query_11` join `objects` on((`objects`.`o_id` = `object_query_11`.`oo_id`)));

DROP TABLE IF EXISTS `object_12`;
DROP VIEW IF EXISTS `object_12`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `object_12` AS select `object_query_12`.`oo_id` AS `oo_id`,`object_query_12`.`oo_classId` AS `oo_classId`,`object_query_12`.`oo_className` AS `oo_className`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className` from (`object_query_12` join `objects` on((`objects`.`o_id` = `object_query_12`.`oo_id`)));

DROP TABLE IF EXISTS `object_14`;
DROP VIEW IF EXISTS `object_14`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `object_14` AS select `object_query_14`.`oo_id` AS `oo_id`,`object_query_14`.`oo_classId` AS `oo_classId`,`object_query_14`.`oo_className` AS `oo_className`,`object_query_14`.`ordering` AS `ordering`,`object_query_14`.`Name` AS `Name`,`object_query_14`.`logo__image` AS `logo__image`,`object_query_14`.`logo__hotspots` AS `logo__hotspots`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className` from (`object_query_14` join `objects` on((`objects`.`o_id` = `object_query_14`.`oo_id`)));

DROP TABLE IF EXISTS `object_localized_1_cs`;
DROP VIEW IF EXISTS `object_localized_1_cs`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `object_localized_1_cs` AS select `object_query_1`.`oo_id` AS `oo_id`,`object_query_1`.`oo_classId` AS `oo_classId`,`object_query_1`.`oo_className` AS `oo_className`,`object_query_1`.`ordering` AS `ordering`,`object_query_1`.`isLowVat` AS `isLowVat`,`object_query_1`.`gallery` AS `gallery`,`object_query_1`.`inStock` AS `inStock`,`object_query_1`.`isNew` AS `isNew`,`object_query_1`.`soldCount` AS `soldCount`,`object_query_1`.`brand__id` AS `brand__id`,`object_query_1`.`brand__type` AS `brand__type`,`object_query_1`.`isMasterProduct` AS `isMasterProduct`,`object_query_1`.`priceCZ` AS `priceCZ`,`object_query_1`.`discountedPriceCZ` AS `discountedPriceCZ`,`object_query_1`.`priceSK` AS `priceSK`,`object_query_1`.`discountedPriceSK` AS `discountedPriceSK`,`object_query_1`.`ignoreSalePromotionsCZ` AS `ignoreSalePromotionsCZ`,`object_query_1`.`ignoreSalePromotionsSK` AS `ignoreSalePromotionsSK`,`object_query_1`.`costCZ` AS `costCZ`,`object_query_1`.`costSK` AS `costSK`,`object_query_1`.`colors` AS `colors`,`object_query_1`.`sizes` AS `sizes`,`object_query_1`.`additionalCategories` AS `additionalCategories`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className`,`cs`.`ooo_id` AS `ooo_id`,`cs`.`language` AS `language`,`cs`.`name` AS `name`,`cs`.`variantName` AS `variantName`,`cs`.`seoDescription` AS `seoDescription`,`cs`.`translatedPath` AS `translatedPath`,`cs`.`shortDescription` AS `shortDescription`,`cs`.`description` AS `description`,`cs`.`parameters` AS `parameters`,`cs`.`url` AS `url` from ((`object_query_1` join `objects` on((`objects`.`o_id` = `object_query_1`.`oo_id`))) left join `object_localized_query_1_cs` `cs` on((1 and (`object_query_1`.`oo_id` = `cs`.`ooo_id`))));

DROP TABLE IF EXISTS `object_localized_2_cs`;
DROP VIEW IF EXISTS `object_localized_2_cs`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `object_localized_2_cs` AS select `object_query_2`.`oo_id` AS `oo_id`,`object_query_2`.`oo_classId` AS `oo_classId`,`object_query_2`.`oo_className` AS `oo_className`,`object_query_2`.`ordering` AS `ordering`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className`,`cs`.`ooo_id` AS `ooo_id`,`cs`.`language` AS `language`,`cs`.`name` AS `name`,`cs`.`seoDescription` AS `seoDescription`,`cs`.`translatedPath` AS `translatedPath`,`cs`.`url` AS `url` from ((`object_query_2` join `objects` on((`objects`.`o_id` = `object_query_2`.`oo_id`))) left join `object_localized_query_2_cs` `cs` on((1 and (`object_query_2`.`oo_id` = `cs`.`ooo_id`))));

DROP TABLE IF EXISTS `object_localized_4_cs`;
DROP VIEW IF EXISTS `object_localized_4_cs`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `object_localized_4_cs` AS select `object_query_4`.`oo_id` AS `oo_id`,`object_query_4`.`oo_classId` AS `oo_classId`,`object_query_4`.`oo_className` AS `oo_className`,`object_query_4`.`createdOn` AS `createdOn`,`object_query_4`.`previewImage__image` AS `previewImage__image`,`object_query_4`.`previewImage__hotspots` AS `previewImage__hotspots`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className`,`cs`.`ooo_id` AS `ooo_id`,`cs`.`language` AS `language`,`cs`.`name` AS `name`,`cs`.`seoDescription` AS `seoDescription`,`cs`.`perex` AS `perex`,`cs`.`content` AS `content`,`cs`.`url` AS `url` from ((`object_query_4` join `objects` on((`objects`.`o_id` = `object_query_4`.`oo_id`))) left join `object_localized_query_4_cs` `cs` on((1 and (`object_query_4`.`oo_id` = `cs`.`ooo_id`))));

DROP TABLE IF EXISTS `object_localized_11_cs`;
DROP VIEW IF EXISTS `object_localized_11_cs`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `object_localized_11_cs` AS select `object_query_11`.`oo_id` AS `oo_id`,`object_query_11`.`oo_classId` AS `oo_classId`,`object_query_11`.`oo_className` AS `oo_className`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className`,`cs`.`ooo_id` AS `ooo_id`,`cs`.`language` AS `language`,`cs`.`name` AS `name` from ((`object_query_11` join `objects` on((`objects`.`o_id` = `object_query_11`.`oo_id`))) left join `object_localized_query_11_cs` `cs` on((1 and (`object_query_11`.`oo_id` = `cs`.`ooo_id`))));

DROP TABLE IF EXISTS `object_localized_12_cs`;
DROP VIEW IF EXISTS `object_localized_12_cs`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `object_localized_12_cs` AS select `object_query_12`.`oo_id` AS `oo_id`,`object_query_12`.`oo_classId` AS `oo_classId`,`object_query_12`.`oo_className` AS `oo_className`,`objects`.`o_id` AS `o_id`,`objects`.`o_parentId` AS `o_parentId`,`objects`.`o_type` AS `o_type`,`objects`.`o_key` AS `o_key`,`objects`.`o_path` AS `o_path`,`objects`.`o_index` AS `o_index`,`objects`.`o_published` AS `o_published`,`objects`.`o_creationDate` AS `o_creationDate`,`objects`.`o_modificationDate` AS `o_modificationDate`,`objects`.`o_userOwner` AS `o_userOwner`,`objects`.`o_userModification` AS `o_userModification`,`objects`.`o_classId` AS `o_classId`,`objects`.`o_className` AS `o_className`,`cs`.`ooo_id` AS `ooo_id`,`cs`.`language` AS `language`,`cs`.`name` AS `name` from ((`object_query_12` join `objects` on((`objects`.`o_id` = `object_query_12`.`oo_id`))) left join `object_localized_query_12_cs` `cs` on((1 and (`object_query_12`.`oo_id` = `cs`.`ooo_id`))));
