<?php

namespace Website\Model;

class ValueCalculator
{
	/**
	 * @param \Pimcore\Model\Object\Concrete             $object
	 * @param \Pimcore\Model\Object\Data\CalculatedValue $context
	 *
	 * @return string
	 */
	public static function compute($object, $context, $editmode = false)
	{
		if (\Zend_Registry::isRegistered('routesSwitchEditmode')
				&& \Zend_Registry::get('routesSwitchEditmode')) {
			$editmode = true;
		}
		switch ($context->getFieldname()) {
			case 'url':
				return self::getUrl($object, $context->getPosition(), [], $editmode);
				break;
			default:
				\Pimcore\Logger::error('CALCULATING VALUE - '.$e->getMessage()."\n".$e->getTraceAsString());
				break;
		}
	}

	/**
	 * @param \Pimcore\Model\Object\Concrete             $object
	 * @param \Pimcore\Model\Object\Data\CalculatedValue $context
	 *
	 * @return string
	 */
	public static function getCalculatedValueForEditMode($object, $context)
	{
		return self::compute($object, $context, true);
	}

	/**
	 * @param \Pimcore\Model\Object\Concrete $object
	 * @param string                         $language
	 *
	 * @return string
	 */
	public static function getUrl($object, $language = null, $params = [], $editmode = false)
	{
		if (!$language) {
			$language = \Website\Tool\Utils::getDefaultLanguage();
		}

		$realObject = ($object instanceof \Pimcore\Model\Object\Concrete);
		$url = '';
		$className = ($realObject) ? $object->getClassName() : $object;
		switch ($className) {
			// for id + slug pages
			case 'News':
				if ($realObject) {
					$slug = \Website\Tool\Utils::webalize(trim($object->getName($language)));
					if (!$slug) {
						return;
					}
					$params = [
						'id' => $object->getId(),
						'slug' => $slug,
					];
				}
				//static route names must match this normalized class name + language
				$staticRouteKey = ltrim(strtolower(preg_replace('/[A-Z]/', '-$0', $className.'-'.$language)), '-');
				$url = \Website\Tool\Utils::url($staticRouteKey, $params);
				break;
			// for translatedPath pages
			case 'Category':
			case 'Product':
				if ($realObject) {
					$translatedPath = trim($object->getTranslatedPath($language));
					if (!$translatedPath) {
						return;
					}
					$params = [
						'translatedPath' => $translatedPath,
					];
				}
				//static route names must match this normalized class name + language
				$staticRouteKey = ltrim(strtolower(preg_replace('/[A-Z]/', '-$0', $className.'-'.$language)), '-');
				$url = \Website\Tool\Utils::url($staticRouteKey, $params);
				break;
		}

		return $url;
	}
}
