<?php

namespace Website\Tool\Setup;

use Composer\Script\Event;
use Composer\Util\Filesystem;

class Composer
{
	public static function postCreateProject(Event $event)
	{
		$config = $event->getComposer()->getConfig();
		$rootPath = dirname($config->get('vendor-dir'));
		$projectName = basename($rootPath);

		// init composer
		rename($rootPath.'/composer.tmpl', $rootPath.'/composer.json');

		// init git
		$filesystem = new Filesystem();
		$filesystem->removeDirectory($rootPath.'/.git');
		rename($rootPath.'/gitignore.tmpl', $rootPath.'/.gitignore');
		exec('which git', $returnVal, $returnCode);
		if (empty($returnVal) || $returnCode) {
			fputs(STDOUT, sprintf(
				"\033[31m Local git repository could not be initialized. Please initialize it manually with remote \033[33m[ssh://git@bitbucket.org/portabucket/%s.git]\n",
				$projectName
			));
		} else {
			exec('git init');
			exec(sprintf(
				'git remote add origin ssh://git@bitbucket.org/portabucket/%s.git',
				$projectName
			));
			fputs(STDOUT, sprintf(
				"\033[32m Initialized local git repository with remote \033[33m[ssh://git@bitbucket.org/portabucket/%s.git]\n",
				$projectName
			));
		}

		// create database
		$databaseCreated = false;
		exec('which mysql', $returnVal, $returnCode);
		if (empty($returnVal) || $returnCode) {
			fputs(STDOUT, sprintf(
				"\033[31m Database \033[33m[%s] \033[31mcould not be created. Please create it manually.\n",
				$projectName
			));
		} else {
			exec(sprintf(
				'mysql --login-path=deployment -e "create database %s character set utf8 collate utf8_general_ci"',
				$projectName
			), $returnVal, $returnCode);
			if (!$returnCode) {
				fputs(STDOUT, sprintf(
					"\033[32m Created database \033[33m[%s]\n",
					$projectName
				));
			} else {
				fputs(STDOUT, sprintf(
					"\033[31m Database \033[33m[%s] \033[31mcould not be created. Please create it manually.\n",
					$projectName
				));
				$databaseCreated = true;
			}
		}

		// init readme
		$contents = preg_replace(
			'/###TITLE###/',
			ucfirst($projectName),
			file_get_contents($rootPath.'/README.tmpl')
		);
		$contents = preg_replace(
			'/###TITLE_LOWERCASE###/',
			strtolower($projectName),
			$contents
		);
		$repositoryUrl = sprintf('ssh://git@bitbucket.org/portabucket/%s.git', strtolower($projectName));
		$contents = preg_replace(
			'/###REPOSITORY###/',
			$repositoryUrl,
			$contents
		);
		$fh = fopen($rootPath.'/README.md', 'w');
		fwrite($fh, $contents);
		fclose($fh);
		fputs(STDOUT, sprintf("\033[32mGenerated \033[33mREADME.md\n", $projectName));

		// cleanup
		$filesystem->removeDirectory($rootPath.'/website/tools/Update');
		@unlink($rootPath.'/README.tmpl');
	}
}
