<?php

set_time_limit(60000);
include_once __DIR__.'/../../../pimcore/cli/startup.php';
\Pimcore\Cache::clearAll();
$db = \Pimcore\Db::get();


fwrite(STDOUT, "3925\n");
try {
	$classesData = $db->fetchAll("SELECT * FROM classes");
	foreach($classesData as $classData) {
		$class = new \Pimcore\Model\Object\ClassDefinition();
		$class->setValues($classData);
		$class->setPropertyVisibility(\Pimcore\Tool\Serialize::unserialize($classData["propertyVisibility"]));
		$file = PIMCORE_CLASS_DIRECTORY."/definition_". $class->getId() .".psf";
		$layoutData = \Pimcore\Tool\Serialize::unserialize(file_get_contents($file));
		$class->setLayoutDefinitions($layoutData);
		$definitionFile = PIMCORE_CLASS_DIRECTORY."/definition_". $class->getName() .".php";
		if (!is_writable(dirname($definitionFile)) || (is_file($definitionFile) && !is_writable($definitionFile))) {
			throw new \Exception("Cannot write definition file in: " . $definitionFile . " please check write permission on this directory.");
		}
		$clone = clone $class;
		$clone->setDao(null);
		unset($clone->id);
		unset($clone->fieldDefinitions);
		$exportedClass = var_export($clone, true);
		$data = '<?php ';
		$data .= "\n\n";
		$data .= "/** Generated at " . date('c') . " */";
		$data .= "\n\n";
		$data .= "\nreturn " . $exportedClass . ";\n";
		\Pimcore\File::put($definitionFile, $data);
	}
	$db->query("
	ALTER TABLE `classes`
		DROP COLUMN `description`,
		DROP COLUMN `creationDate`,
		DROP COLUMN `modificationDate`,
		DROP COLUMN `userOwner`,
		DROP COLUMN `userModification`,
		DROP COLUMN `allowInherit`,
		DROP COLUMN `allowVariants`,
		DROP COLUMN `parentClass`,
		DROP COLUMN `useTraits`,
		DROP COLUMN `icon`,
		DROP COLUMN `previewUrl`,
		DROP COLUMN `propertyVisibility`,
		DROP COLUMN `showVariants`,
		DROP COLUMN `group`;
	");
} catch (\Exception $e) {
	fwrite(STDOUT, '3925 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3936\n");
try {
	$db->delete("users_permission_definitions", $db->quoteIdentifier("key") . " = 'newsletter'");
} catch (\Exception $e) {
	fwrite(STDOUT, '3936 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3938\n");
	$db->query("ALTER TABLE tags CHANGE COLUMN `name` `name` varchar(255) DEFAULT NULL;");
try {
} catch (\Exception $e) {
	fwrite(STDOUT, '3938 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3947\n");
try {
	$folders = [PIMCORE_CLASS_DIRECTORY . "/objectbricks", PIMCORE_CLASS_DIRECTORY . "/fieldcollections"];
	foreach($folders as $folder) {
		$files = glob($folder . "/*.psf");
		foreach ($files as $file) {
			$data = file_get_contents($file);
			$definition = \Pimcore\Tool\Serialize::unserialize($data);
			$phpDefinitionFile = preg_replace("@\.psf$@", ".php", $file);
			$clone = clone $definition;
			$clone->setDao(null);
			unset($clone->fieldDefinitions);
			$exportedClass = var_export($clone, true);
			$data = '<?php ';
			$data .= "\n\n";
			$data .= "\nreturn " . $exportedClass . ";\n";
			\Pimcore\File::put($phpDefinitionFile, $data);
		}
	}
} catch (\Exception $e) {
	fwrite(STDOUT, '3947 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3976\n");
try {
	$db->update("properties", [
		"inheritable" => "0"
	], "`name` LIKE 'navigation\\_%' AND `inheritable` = '1'");
} catch (\Exception $e) {
	fwrite(STDOUT, '3976 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3977\n");
try {
	// shouldn't be necessary, since default collation of ascii is ascii_general_ci, but just to be entirely sure
	$db->query("ALTER TABLE assets CHANGE COLUMN `path` `path` varchar(765) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL");
	$db->query("ALTER TABLE assets CHANGE COLUMN `filename` `filename` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT ''");
	$db->query("ALTER TABLE documents CHANGE COLUMN `path` `path` varchar(765) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL");
	$db->query("ALTER TABLE documents CHANGE COLUMN `key` `key`  varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT ''");
	$db->query("ALTER TABLE documents_elements CHANGE COLUMN `name` `name` varchar(750) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT ''");
	$db->query("ALTER TABLE objects CHANGE COLUMN `o_path` `o_path` varchar(765) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL");
	$db->query("ALTER TABLE objects CHANGE COLUMN `o_key` `o_key` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci default ''");
	$db->query("ALTER TABLE properties CHANGE COLUMN `cpath` `cpath` varchar(765) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL");
	$db->query("ALTER TABLE search_backend_data CHANGE COLUMN `fullpath` `fullpath` varchar(765) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL");
	$db->query("ALTER TABLE users_workspaces_asset CHANGE COLUMN `cpath` `cpath` varchar(765) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL");
	$db->query("ALTER TABLE users_workspaces_document CHANGE COLUMN `cpath` `cpath` varchar(765) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL");
	$db->query("ALTER TABLE users_workspaces_object CHANGE COLUMN `cpath` `cpath` varchar(765) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL");
} catch (\Exception $e) {
	fwrite(STDOUT, '3977 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3987\n");
try {
	$pages = $db->fetchAll("SELECT id, metaData FROM documents_page WHERE LENGTH(metaData) > 6");
	$tpl = '<meta %s="%s" "%s="%s">';
	foreach($pages as &$page) {
		$metaData = unserialize($page["metaData"]);
		$meta = [];
		foreach($metaData as $record) {
			$meta[] = sprintf(
				$tpl,
				$record["idName"],
				htmlspecialchars($record["idValue"], ENT_COMPAT, "UTF-8"),
				$record["contentName"],
				htmlspecialchars($record["contentValue"], ENT_COMPAT, "UTF-8")
			);
		}
		$db->update("documents_page", [
			"metaData" => serialize($meta)
		], "id = " . $page["id"]);
	}
	$db->update("documents_page", [
		"metaData" => ""
	], "LENGTH(metaData) < 7");
} catch (\Exception $e) {
	fwrite(STDOUT, '3987 failed - '.$e->getMessage()."\n");
}


\Pimcore\Cache::clearAll();
fwrite(STDOUT, "done\n");
