<div class="col-md-12">
	<div class="page-header">
		<h1>
			<?=$this->product->getVariantName($this->language);?>
		</h1>
	</div>

	<div class="row">
		<div class="col-md-7">
			<div class="row">
				<div class="col-md-12">
					<div class="" id="product_showroom">
						<?=\Website\Tool\Utils::image(
							$this->product->getPreviewImage(),
							'ProductShowcaseImage',
							null,
							['id' => 'product_image', 'class' => 'img-responsive']
						);?>
					</div>
				</div>
			</div>
			<div class="row product-image-thumbs">
				<? foreach($this->product->getGallery() as $key => $image):?>
					<div class="col-md-2">
						<a href="javascript:void(0);" id="reload_image_<?=($key+1);?>">
							<?=\Website\Tool\Utils::image($image, 'ProductShowcaseImagePreview', null, ['class' => 'img-reponsive']);?>
						</a>
					</div>
				<? endforeach;?>
			</div>
		</div>
		<div class="col-md-5">
			<?if($this->product->getDescription()):?>
				<div class="row">
					<div class="col-md-12">
						<h3>Popis</h3>
						<p><?=$this->product->getDescription();?></p>
					</div>
				</div>
			<?endif;?>
			<?
				$parametersTable = $this->product->getParameters();
				$maxCols = 0;
				if (!empty($parametersTable)) {
					foreach ($parametersTable as $row) {
						$maxCols = max([$maxCols, count($row)]);
					}
				}
			?>
			<?if(!empty($parametersTable)):?>
				<div class="row">
					<div class="col-md-12">
						<h3>Parametre</h3>
						<table class="table table-striped">
							<tbody>
								<?foreach($parametersTable as $row):?>
									<tr>
										<?if(count($row)): for($key = 0; $key < count($row); $key++):?>
											<?if(isset($row[$key])):?>
												<?if($key == 0):?>
													<td><strong><?=trim($row[$key]);?></strong></td>
												<?else:?>
													<td><?=trim($row[$key]);?></td>
												<?endif;?>
											<?else:?>
													<td></td>
											<?endif;?>
										<?endfor; endif;?>
									</tr>
								<?endforeach;?>
							</tbody>
						</table>
					</div>
				</div>
			<?endif;?>
			<div class="row">
				<div class="col-md-12">
					<h3>Cena: <?=$this->printPrice($this->product);?></h3>
				</div>
			</div>
			<div class="row">
				<div class="col-md-6">
					<?if(count($this->variants)):?>
						<div id="add-to-cart-<?=$this->product->getId();?>">
							<?=$this->render('shop/snippets/add-to-cart.php');?>
						</div>
					<?else:?>
						<div id="add-to-cart-<?=$this->product->getId();?>">
							<?=$this->render('shop/snippets/add-to-cart.php');?>
						</div>
					<?endif;?>
				</div>
				<div class="col-md-6">
					<a class="ajax btn btn-default pull-right" href="<?=\Website\Tool\Utils::url('modify-comparison', ['language' => $this->language, 'id' => $this->product->getId(), 'remove' => 0, 'context' => $this->product->getId()]);?>"><span class="glyphicon glyphicon-eye-open"></span>&nbsp;<?=$this->translate('label_add_to_comparison');?></a>
				</div>
			</div>
		</div>
	</div>

	<?
		$relatedProducts = $this->relatedProducts;
	?>
	<?if(!empty($relatedProducts->items)):?>
		<div class="row">
			<div class="col-md-12">
				<h3>Mohlo by Vás zajímat</h3>
			</div>
		</div>
		<div class="row">
			<?foreach($relatedProducts->items as $result):?>
				<div class="col-md-2">
					<?
						$product = $result['_source'];
						$link = \Website\Model\ValueCalculator::getUrl('Product', $this->language, ['translatedPath' => $product['translatedPath']]);
					?>
					<a href="<?=$link;?>">
						<?=$product['previewImage'];?>
					</a>
				</div>
			<?endforeach;?>
		</div>
	<?endif;?>
</div>

<?
	//prepare images structure for lightbox json
	$fancyboxImages = [];
	foreach($this->product->getGallery() as $key => $image) {
		$fancyboxImages[$key] = [
			'href' => $this->baseUrl().$image->getRelativeFileSystemPath()
		];
	}
?>
<script type="text/javascript">
	document.addEventListener("DOMContentLoaded", function() { 
		//init fancybox
		$("body").on('click', "#product_showroom", function() {
			$.fancybox.open(<?=json_encode($fancyboxImages);?>);
		});
		<?foreach($this->product->getGallery() as $key => $image):?>
			$("body").on("click", "#reload_image_<?=($key+1);?>", function() {
				$("#product_showroom").fadeTo(100, 0, function() {
					var img = $('<img class="img-polaroid">').load(function() { //clime: load before src to work under ie8
						$("#product_showroom").html(img); //clime: append changed to html

						$("#product_showroom").fadeTo(200, 1);
					}).attr("src", "<?=\Website\Tool\Utils::thumbnail($image, 'ProductShowcaseImage');?>?"+new Date()); //because of cache
				});
				<?//rewind images so that the correct (currently shown in showroom) image is first in opened lightbox?>
				$("body").on("click", "#product_showroom", function() {
					$.fancybox.open(<?=json_encode(array_merge(array_slice($fancyboxImages, $key), array_slice($fancyboxImages, 0, $key)));?>);
				});
				return false;
			});
		<? endforeach;?>
	});
</script>

<?$this->layout()->setLayout('standard');?>
