<?if(empty($this->products)):?>
	<div class="alert alert-info"><?=$this->translate('msg_cart_empty');?></div>
	<a class="btn btn-default" href="<?=$this->docUrl('/');?>"><span class="glyphicon glyphicon-shopping-cart"></span>&nbsp;<?=$this->translate('label_continue_shopping');?></a>
<?else:?>
	<?
		/* @var $formBuilder \Website\View\Helper\FormBuilder */
		$formBuilder = $this->formBuilder($this->cartForm, 'bootstrap')->setFormClass('ajax');
	?>
	<?=$formBuilder->start();?>
		<table class="table table-striped">
			<thead>
				<tr>
					<th>Název</th>
					<th>Cena s DPH</th>
					<th>Počet ks</th>
					<th>Celkem</th>
					<th></th>
				</tr>
			</thead>
			<tbody>
				<?foreach($this->products as $id => $product):?>
					<?
						list(, $discountedPrice) = $this->currencyModel->getProductPrices($product);
					?>
					<tr>
						<td><?=$product->getVariantName($this->language);?></td>
						<td><?=$this->printPrice($product);?></td>
						<td class="col-md-1">
							<div class="input-group">
								<?=$formBuilder->setInputElementWrapperClass(null)->setInputWrapperClass(null)->setShowLabel(false)->element('count_'.$id);?>
								<span class="input-group-btn">
									<a href="javascript:void(0);" class="btn btn-default update-cart-count"><span class="glyphicon glyphicon-refresh"></span></a>
								</span>
							</div>
						</td>
						<td><?=$this->localizeCurrency($discountedPrice * $this->cart->getOrder()->products[$id]->count, true);?></td>
						<td>
							<a href="javascript:void(0);" class="btn btn-default update-cart-count" data-id="<?=$id;?>" data-count="0"><span class="glyphicon glyphicon-remove"></span>&nbsp;Smazat</a>
						</td>
					</tr>	
				<?endforeach;?>
			</tbody>
			<tfoot>
				<tr>
					<th>Celkem</th>
					<th></th>
					<th></th>
					<th><?=$this->localizeCurrency($this->cart->getOrder()->productsPrice, true);?></th>
					<th></th>
				</tr>
			</tfoot>
		</table>

		<?=$formBuilder->element('csrf');?>
		<?=$formBuilder->setButtonClass('btn btn-primary')->element('send');?>
	<?=$formBuilder->end();?>
<? endif; ?>
