<div class="col-md-12">
	<div class="page-header">
		<h1>Správa objednávek</h1>
	</div>

	<?if(count($this->orders) > 0):?>
		<?
			$currencyCache = [];
		?>
		<table class="table table-striped table-hover">
			<caption>Vaše objednávky</caption>
			<thead>
				<th>Datum</th>
				<th>Č. objednávky</th>
				<th>Platba</th>
				<th>Doprava</th>
				<th>Cena</th>
				<th>Cena za dopravu</th>
				<th>Sleva</th>
				<th>Konečná cena</th>
			</thead>
			<tbody>
				<?foreach($this->orders as $order):?>
					<?
						$locale = $order->getCurrency();
						if (isset($currencyCache[$locale])) {
							$currency = $currencyCache[$locale];
						} else {
							$currency = $this->currencyModel->createFrozenCurrency($locale);
						}
						$discount = min([$order->getProductsDiscount(), $order->getProductsPrice()]) + $order->getShippingDiscount() + $order->getPaymentDiscount();
					?>
					<tr class="clickable" data-url="<?=\Website\Tool\Utils::url('order-'.$this->language, ['id' => $order->getId()]);?>">
						<td><?=date('j.n.Y', $order->getCreationDate());?></td>
						<td class="order-id"><?=$order->getOrderId();?></td>
						<td><?=$this->translate('label_'.$order->getPaymentType());?></td>
						<td><?=$this->translate('label_'.$order->getShippingType());?></td>
						<td class="rightCell"><?=$this->currencyModel->localizeCurrency($order->getProductsPrice(), $currency);?></td>
						<td class="rightCell"><?=$this->currencyModel->localizeCurrency($order->getBaseShippingPrice() + $order->getBasePaymentPrice(), $currency);?></td>
						<td class="rightCell"><?=(($discount) ? '-' : '').$this->currencyModel->localizeCurrency($discount, $currency);?></td>
						<td class="rightCell"><?=$this->currencyModel->localizeCurrency($order->getFinalPrice(), $currency);?></td>
					</tr>
				<?endforeach;?>
			</tbody>
		</table>
	<?endif;?>

	<?=$this->paginationControl($this->orders, 'Sliding', 'default/snippets/pagination.php', [
		'urlprefix' => $this->docUrl('/ucet/objednavky'). '?page=',
		'appendQueryString' => true]);
	?>
</div>

<?$this->layout()->setLayout('standard');?>
