<?php

namespace Website\Model;

class Category extends \Pimcore\Model\Object\Category implements IElasticObjectFulltext
{
	public $forceChain = false;
	private $url = array();

	/*								Helpers										*/

	public function getUrl($language = null)
	{
		if (!$language) $language = \Website\Tool\Utils::getDefaultLanguage();

		if (!isset($this->url[$language])) {
			$this->url[$language] = \Website\Tool\Utils::url('product-' . $language, array('translatedPath' => $this->getTranslatedPath($language)));
		}

		return $this->url[$language];
	}

	/*								Mapped										*/

	public function save()
	{
		$systemLanguages = \Pimcore\Tool::getValidLanguages();
		$updatePath = false;
		if (parent::getId()) {
			foreach ($systemLanguages as $lang) {
				//slug
				$slug = \Website\Tool\Utils::webalize(parent::getName($lang));
				$slugOld = parent::getSlug($lang); # for old paths purposes
				parent::setSlug($slug, $lang);
				//translated path
				$translatedPath = parent::getTranslatedPath($lang);
				$newTranslatedPath = $slug;
				//check if translated path is unique
				$list = $this->getList();
				$list->setCondition('o_id <> '.(int)parent::getId().' AND translatedPath = '.$list->quote($newTranslatedPath));
				if ($list->count()) {
					throw new \Exception('plugin_backend_error_category_name_not_unique');
				}
				//translatedPath is going to change => add old path to redirects
				if (($translatedPath != $newTranslatedPath) && !empty($slugOld)) {
					\Website\Tool\Utils::addToOldEshopUrls(parent::getId(), parent::getClassId(), $translatedPath, $lang);
				}
				//update childs when translatedPath was changed
				$updatePath = ($updatePath || ($newTranslatedPath != $translatedPath));
				parent::setTranslatedPath($newTranslatedPath, $lang);

				$this->elasticSearchUpdateFulltext();
			}
		}
		//save object
		parent::save();

		//update all childs
		if ($this->forceChain ||$updatePath || \Website\Tool\ElasticSearch::isUpdateRequest()) {
			foreach (parent::getChilds() as $child) {
				try {
					$child->setOmitMandatoryCheck(true);
					$child->save();
				} catch(\Exception $e) {
					\Pimcore\Log\Simple::log('exceptions', 'CHAIN SAVING: could not save child with ID: '.$child->getId().' - '.$e->getMessage());
				}
			}
		}

		//update products with this category in additionalCategories field
		if (parent::getId() && $updatePath) {
			$db = \Pimcore\db::get();
			foreach($db->select()->from('object_1', array('oo_id as id'))->where('additionalCategories LIKE ?', '%'.parent::getId().'%')->query()->fetchAll() as $rawDbRow) {
				$product = Product::getById($rawDbRow['id']);
				if ($product) {
					try {
						$product->setOmitMandatoryCheck(true);
						$product->save();
					} catch (\Exception $e) {
						\Pimcore\Log\Simple::log('exceptions', 'CHAIN SAVING: could not save product with ID: '.$child->getId());
					}
				}
			}
		}
	}

	public function delete()
	{
		$id = parent::getId();

		parent::delete();

		\Website\Tool\ElasticSearch::delete($id, \Website\Tool\ElasticSearch::OBJECT_TYPE_KEY);
	}

	/* 								For elastic search							 */

	/**
	 * indexed the category object data into elastic search at current index
	 */
	public function elasticSearchUpdateFulltext()
	{
		$indexName = \Website\Tool\ElasticSearch::getMainIndexName();
		$systemLanguages = \Pimcore\Tool::getValidLanguages();
		$elasticClient = \Website\Tool\ElasticSearch::getClient();

		foreach ($systemLanguages as $lang) {
			$data = $this->elasticSearchLoadFulltext($lang);
			$elasticClient->index(array(
				'index' => $indexName,
				'type' => \Website\Tool\ElasticSearch::OBJECT_TYPE_KEY . '_' . $lang,
				'id' => $data['id'],
				'body' => $data
			));

			if (!\Website\Tool\ElasticSearch::isUpdateRequest()) {
				$elasticClient->indices()->refresh(array('index' => $indexName));
			}
		}
	}

	/**
	 * returns elastic search document data structure 
	 * @param string $lang
	 * @return array
	 */
	public function elasticSearchLoadFulltext($lang)
	{
		$data = array(
			'id' => $this->getId(),
			'path' => $this->getUrl($lang),
			'published' => $this->isPublished(),
			'title' => $this->getName($lang),
			'keywords' => $this->getSeoKeywords($lang),
			'description' => $this->getSeoDescription($lang),
			'content' => ''//is paginated so the content is irelevant
		);

		return $data;
	}

}
