$(function(){
	//init cart form
	$('#cart-form-wrapper').on('click', '.update-cart-count', function() {
		var toInject = { 'act' : 'recalculate' };
		var id = $(this).attr('data-id');
		if (id) {
			var count = $(this).attr('data-count');
			toInject['count_'+id] = count;
		}
		$('#cartform').submitForm(toInject);
	});
	//init filter form
	$('#category-filter-wrapper').on('change', 'form#filter input[type=checkbox]', function() {
		$(this).closest('form').submitForm();
	});

	//init filter pagination
	$('#category-product-list-wrapper').on('click', '.ajax-pagination a', function() {
		var paramPage = $(this).closest('ul').attr('data-param-page');
		var page = $(this).attr('data-page');
		var data = {}
		data[paramPage] = page;
		$('#filter').submitForm(data);
		$("html, body").animate({ scrollTop: 0 });
	});

	//init shipping switcher
	$("#country").change(function() {
		var country = $(this).val();
		$(".country-shipping").hide();
		$("#project-hints > p").hide();
		var selectedBlock = $('div[data-country="'+country+'"]');
		if (selectedBlock.length) {
			selectedBlock.show();
			$('input[name="shippingType'+country+'"]').change();
		}
	});

	$('input[name^="shippingType"]').change(function() {
		if ($(this).is(':checked')) {
			var country = $("#country").val();
			var shippingType = $(this).val();
			if ($('.payment-switcher[data-type="'+country+shippingType+'"]').length) {
				$(".payment-switcher").hide();
				$('.payment-switcher[data-type="'+country+shippingType+'"]').show();
			}
			$('input[name="paymentType'+country+shippingType+'"]').change();
		}
	});
	$('input[name^="paymentType"]').change(function() {
		if ($(this).is(':checked')) {
			var paymentType = $(this).val();
			var countryAndShipping = $(this).attr('name');
			var price = $('span#price_'+countryAndShipping+paymentType).attr('data-price');
			$('#dynamic-price, span#cart-summary').html(price);
		}
	});
	$("#country").change();

	//init cart delivery address trigger
	$(function() {
		$('#deliveryAddress').change(function() {		
			if ( $(this).is(':checked') ) {
				$('#delivery-address').slideDown().find('input,select').attr('disabled',false);
			}
			else {
				$('#delivery-address').slideUp().find('input,select').attr('disabled',true);
			}
		});
		$('#deliveryAddress').change();
	});

	//scroll to discount code input in case of an error msg
	if ($('div.error #discountCode').length > 0) {
		$('html,body').animate({
			scrollTop: $('#discountCode').offset().top
		}, 0);
	}

	//forward GPE WebPay request form 
	$("form#webpay").submit();

	//init typeahead
	$('.typeahead').typeahead({
		remote: {
			url: '/cs/autocomplete/%QUERY',
			maxParallelRequests: 2
		}
	});
});