<?php

set_time_limit(60000);
include_once("../../pimcore/cli/startup.php");
$db = Pimcore_Resource_Mysql::get();
$languages = Pimcore_Tool::getValidLanguages();
Pimcore_Model_Cache::clearAll();

fputs(STDOUT, "2922\n");
$db->query("ALTER TABLE `targeting_rules` ADD COLUMN `scope` varchar(50) NULL DEFAULT NULL AFTER `description`;");

fputs(STDOUT, "2926\n");
$db->query("ALTER TABLE `targeting_rules` ADD COLUMN `active` tinyint(1) NULL DEFAULT NULL AFTER `scope`;");
$db->query("ALTER TABLE `targeting_personas` ADD COLUMN `active` tinyint(1) NULL DEFAULT NULL;");

fputs(STDOUT, "2944\n");
$db->query("ALTER TABLE `sites` ADD COLUMN `mainDomain` varchar(255) NULL DEFAULT NULL AFTER `id`;");
$db->query("ALTER TABLE `sites` ADD COLUMN `errorDocument` varchar(255) NULL DEFAULT NULL;");
$db->query("ALTER TABLE `sites` ADD COLUMN `redirectToMainDomain` tinyint(1) NULL DEFAULT NULL;");
$sites = new Site_List();
$sites->load();
foreach ($sites->getSites() as $site) {
	$domains = $site->getDomains();
	$mainDomain = "";
	if (is_array($domains)) {
		$mainDomain = array_shift($domains);
	}

	$site->setMainDomain($mainDomain);
	$site->setDomains($domains);

	$siteKey = Pimcore_Tool_Frontend::getSiteKey($site);
	$errorPath = Pimcore_Config::getSystemConfig()->documents->error_pages->$siteKey;
	if ($errorPath) {
		$site->setErrorDocument($errorPath);
	}

	$site->save();
}

fputs(STDOUT, "2944\n");
fputs(STDOUT, "Please cleanup the folder " . PIMCORE_TEMPORARY_DIRECTORY . " manually\n");
fputs(STDOUT, "It's a good idea to rename the folder first and create a new tmp directory.\nRemember: flushing " . PIMCORE_TEMPORARY_DIRECTORY . " can have major impact on the systems stability.\n");

Pimcore_Model_Cache::clearAll();
fputs(STDOUT, "done\n");