<?php

class DefaultController extends \Website\Controller\BaseController 
{

	/* 						DOCUMENT ROUTED ACTIONS							 */

	public function indexAction()
	{
		$this->enableLayout();

		$this->setCanonicalUrl();

		unset($this->view->filterForm);
	}

	public function defaultAction()
	{
		if (!$this->editmode && !\Pimcore\Tool::isFrontentRequestByAdmin()) {
			$this->gotoUrl($this->view->docUrl('/' . $this->defaultLanguage, 301));
		}
	}

	public function emptyPageAction()
	{
		if (!$this->editmode && !\Pimcore\Tool::isFrontentRequestByAdmin()) {
			$childs = $this->document->getChilds();
			if (empty($childs)) {
				throw new \Zend_Controller_Action_Exception($this->translate('system_page_not_found'), 404);
			} else {
				$this->gotoUrl(current($childs)->getFullPath(), 301);
			}
		}
	}

	public function errorPageAction()
	{
		\Pimcore\Model\Cache::disable();

		$errorHandler = $this->getRequest()->getParam('error_handler');
		$exception = $errorHandler->exception;

		//this catches administration previews and maybe some other cases?
		if (!$exception) $exception = new \Zend_Exception ('', 404);

		if ($exception->getCode() == 404) {
			$this->enableLayout();
			$this->view->withLayout = true;
			$this->view->content = '<h1>Požadovaná stránka neexistuje</h1>';
		} else {
			$this->disableLayout();
			$this->view->content = '<h1>Chyba aplikace</h1>';
			\Pimcore\Log\Simple::log('exceptions', $exception->getMessage() . "\n" . $exception->getTraceAsString());
		}

		$this->getResponse()->setHttpResponseCode($exception->getCode());
	}



	/* 						STATIC-ROUTE ROUTED ACTIONS						 */



	public function sitemapXmlAction()
	{
		$this->disableLayout();
		$this->disableViewAutoRender();

		$file = sprintf(PIMCORE_WEBSITE_PATH.'/var/tmp/sitemap%s.xml', (\Pimcore\Model\Site::isSiteRequest()) ? \Pimcore\Model\Site::getCurrentSite()->getRootDocument()->getProperty('language') : '');
		$timestamp = (file_exists($file)) ? filemtime($file) : 0;
		if ((time() - $timestamp) < 86400) {
			$xml = file_get_contents($file);
		} else {
			$xml = null;
		}
		if (!$xml) {
			$xml = '<?xml version="1.0" encoding="UTF-8"?><urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
			$db = \Pimcore\db::get();
			$validLanguages = \Website\Tool\Utils::getValidFrontendLanguages();
			$rootDocumentsIds = $db->select()->from('documents', array('documents.id'))
			->join('documents_page', 'documents.id = documents_page.id', array())
			->joinLeft('properties', 'documents_page.id = properties.cid', array())
			->where('documents_page.id = '.\Website\Tool\Utils::DOCUMENT_ROOT.' OR documents_page.contentMasterDocumentId = ?', \Website\Tool\Utils::DOCUMENT_ROOT)
			->where('properties.name = ?', 'language')
			->query()->fetchAll(\Zend_Db::FETCH_COLUMN);
			$notAllowedDocumentsIds = $db->select()->from('documents', array('documents.id'))
			->join('documents_page', 'documents.id = documents_page.id', array())
			->where('documents_page.contentMasterDocumentId IN (?)', array(
				\Website\Tool\Utils::DOCUMENT_ACCOUNT,
				\Website\Tool\Utils::DOCUMENT_CART,
				\Website\Tool\Utils::DOCUMENT_COMPARE_PRODUCTS,
				\Website\Tool\Utils::DOCUMENT_SEARCH_RESULTS
			))
			->query()->fetchAll(\Zend_Db::FETCH_COLUMN);
			$notAllowedDocumentsIds[] = \Website\Tool\Utils::DOCUMENT_ACCOUNT;
			$notAllowedDocumentsIds[] = \Website\Tool\Utils::DOCUMENT_CART;
			$notAllowedDocumentsIds[] = \Website\Tool\Utils::DOCUMENT_COMPARE_PRODUCTS;
			$notAllowedDocumentsIds[] = \Website\Tool\Utils::DOCUMENT_SEARCH_RESULTS;
			foreach ($rootDocumentsIds as $rootDocumentId) {
				$csRoot = \Pimcore\Model\Document\Page::getById($rootDocumentId);
				$language = $csRoot->getProperty('language');
				if (!in_array($language, $validLanguages)) continue;
				if (\Pimcore\Model\Site::isSiteRequest() && \Pimcore\Model\Site::getCurrentSite()->getRootId() != $rootDocumentId) continue;
				//add documents
				$queue = array($csRoot);
				while ($page = array_shift($queue)) {
					if ($page instanceof \Pimcore\Model\Document\Page && !in_array($page->getId(), $notAllowedDocumentsIds)) {
						$xml .= sprintf('<url><loc>%s</loc><lastmod>%s</lastmod><changefreq>monthly</changefreq></url>', $this->view->serverUrl().$page->getFullPath(), date('Y-m-d', $page->getModificationDate()));
						if ($page->hasChilds()) foreach ($page->getChilds () as $child) {
							$queue[] = $child;
						}
					}
				}
				//add news
				$newsList = new \Website\Model\News\Listing();
				$newsList->load();
				foreach ($newsList->getItems(0, 0) as $news) {
					$xml .= sprintf('<url><loc>%s</loc><lastmod>%s</lastmod><changefreq>monthly</changefreq></url>',
						$this->view->serverUrl(). $news->getUrl($language),
						date('Y-m-d', $news->getModificationDate())
					);
				}
				//add categories
				$categoryList = new \Website\Model\Category\Listing();
				$categoryList->load();
				foreach ($categoryList->getItems(0, 0) as $category) {
					$xml .= sprintf('<url><loc>%s</loc><lastmod>%s</lastmod><changefreq>monthly</changefreq></url>',
						$this->view->serverUrl().  $category->getUrl($language),
						date('Y-m-d', $category->getModificationDate())
					);
				}
				//add products
				$productList = new Website\Model\Product\Listing();
				$productList->setObjectTypes(array(\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_OBJECT));
				$productList->load();
				$variantList = new Website\Model\Product\Listing();
				$variantList->setObjectTypes(array(\Pimcore\Model\Object\AbstractObject::OBJECT_TYPE_VARIANT));
				foreach ($productList->getItems(0, 0) as $product) {
					$variantList->setCondition('o_parentId = '.$product->getId().' AND o_published = 1');
					$variantList->load();
					if (!$variantList->count()) {
						$xml .= sprintf('<url><loc>%s</loc><lastmod>%s</lastmod><changefreq>weekly</changefreq></url>',
							$this->view->serverUrl().  $product->getUrl($language),
							date('Y-m-d', $product->getModificationDate())
						);
					} else {
						foreach ($variantList->getItems(0, 0) as $variant) {
							$xml .= sprintf('<url><loc>%s</loc><lastmod>%s</lastmod><changefreq>weekly</changefreq></url>',
								$this->view->serverUrl().  $product->getUrl($language),
								date('Y-m-d', $variant->getModificationDate())
							);
						}
					}
				}
				//TODO add pre-filtered landing pages 
			}

			$xml .= sprintf('</urlset>');

			$handle = fopen($file, 'w');
			fwrite($handle, $xml);
			fclose($handle);
		}
		
		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename='.basename('sitemap.xml'));
		header('Content-Transfer-Encoding: binary');
		header('Expires: 0');
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Pragma: public');
		
		echo $xml;
		exit;
	}



	/* 				VIEW-LESS ACTIONS (ALLWAYS REDIRECT)					 */



	public function downloadAssetAction()
	{
		//@TODO check for ownership
		$this->disableLayout();
		$this->disableViewAutoRender();

		$id = $this->getRequest()->getParam('id');
		$asset = Asset::getById($id);
		if (!$asset) {
			$this->addErrorMsg($this->translate('msg_invalid_request'));
		}

		//@TODO name from meta data...
		$name = substr(basename($asset->getFilename()), (stripos($asset->getFilename(), '_')) ? stripos($asset->getFilename(), '_') + 1 : 0);
		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename='.$name);
		header('Content-Transfer-Encoding: binary');
		header('Expires: 0');
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Pragma: public');
		header('Content-Length: ' . filesize($asset->getFileSystemPath()));
		ob_clean();
		flush();
		readfile($asset->getFileSystemPath());
		exit;
	}

	public function changeLocaleAction()
	{
		$locale = $this->getRequest()->getParam('locale', '');
		if (strlen($locale) >= 5) {
			$locale = substr($locale, 0, 3) . strtoupper(substr($locale, 3));
		}

		if (array_key_exists($locale, $this->currencyModel->getSystemCurrenciesOptions())) {
			setcookie('locale', $locale, time() + 60 * 60 * 24 * 356, '/');
		}

		$this->gotoUrl($this->getPreviousUrl());
	}



	/* 							FORM HANDLERS								 */

}
