<?php

namespace Website\Form;

class GpeWebPayResponseForm extends Base
{

	public function init()
	{
		parent::init();
		$this->setMethod(\Zend_Form::METHOD_GET);
		$this->setName('webpay');

		//elements		
		$operation = new \Zend_Form_Element_Text('OPERATION');
		$operation->setRequired(true)
				->addValidator($this->notEmptyValidator);

		$orderNumber = new \Zend_Form_Element_Text('ORDERNUMBER');
		$orderNumber->setRequired(true)
				->addValidator($this->notEmptyValidator)->addValidator($this->numberValidator);

		$merOrderNum = new \Zend_Form_Element_Text('MERORDERNUM');
		$merOrderNum->setRequired(true)
				->addValidator($this->notEmptyValidator)->addValidator($this->numberValidator);

		$md = new \Zend_Form_Element_Text('MD');
		$md->setRequired(true)
				->addValidator($this->notEmptyValidator);

		$PRCode = new \Zend_Form_Element_Text('PRCODE');
		$PRCode->setRequired(true)
				->addValidator($this->notEmptyValidator)->addValidator($this->numberValidator);

		$SRCode = new \Zend_Form_Element_Text('SRCODE');
		$SRCode->setRequired(true)
				->addValidator($this->notEmptyValidator)->addValidator($this->numberValidator);

		$resultText = new \Zend_Form_Element_Text('RESULTTEXT');
		$resultText->setRequired(false)
				->addValidator($this->notEmptyValidator);

		$digest = new \Zend_Form_Element_Text('DIGEST');
		$digest->setRequired(true)
				->addValidator($this->notEmptyValidator);

		$this->addElements(array(
			$operation,
			$orderNumber,
			$merOrderNum,
			$md,
			$PRCode,
			$SRCode,
			$resultText,
			$digest
		));

		//remove decorators
		$this->setElementDecorators(array('ViewHelper'));
	}

}
