<?php

namespace Website\Model;

class SalePromotion extends \Pimcore\Model\Object\SalePromotion
{

	protected $recalculate = true;

	public function save()
	{
		$currencyModel = \Website\Tool\Utils::getCurrencyModel();
		$systemCurrencies = $currencyModel->getSystemCurrencies();
		$baseLocale = $currencyModel->getBaseLocale();
		$baseDiscountGetter = 'getDiscount' . substr($baseLocale, 3);
		foreach ($currencyModel->getSystemCurrenciesOptions(true) as $locale => $currencyOptions) {
			$country = substr($locale, 3);
			$discountSetter = 'setDiscount' . $country;

			//calculate exchange rate based discount prices
			if ($locale != $baseLocale && $currencyOptions['rate'] && $currencyOptions['rate'] != 1) {
				if (parent::getIsPercentual()) {
					parent::$discountSetter(parent::$baseDiscountGetter());
				} else {
					parent::$discountSetter($currencyModel->localizeCurrency(parent::$baseDiscountGetter(), $systemCurrencies[$locale], true));
				}
			}
		}

		parent::save();

		if ($this->recalculate) {
			$this->recalculateSalePromotions();
		}
	}

	public function delete()
	{
		$this->recalculateSalePromotions($this);

		parent::delete();
	}

	public function setRecalculate($recalculate)
	{
		$this->recalculate = $recalculate;
	}

	private function recalculateSalePromotions(SalePromotion $toDelete = null)
	{
		$salePromotions = \Website\Model\DiscountManager::getSalePromotions($toDelete);

		foreach (array_keys($salePromotions) as $path) {
			$productOrCategory = \Pimcore\Model\Object\Concrete::getByPath($path);
			if ($productOrCategory) {
				if ($productOrCategory instanceof Category) {
					$productOrCategory->forceChain = true;
				}
				$productOrCategory->setOmitMandatoryCheck(true);
				$productOrCategory->save();
			}
		}
	}

}
