# Pimshop
***
Generic e-shop solution built on top of our customized version of Pimcore (https://github.com/chix/pimcore).

## Installation
+ you need Elasticsearch (https://www.elastic.co/products/elasticsearch) v1.0 with Hunspell and ICU analyzers
+ inside your project folder run `composer create-project portabucket/pimshop --repository-url=https://packages.portadesign.cz . version` (see https://packages.portadesign.cz for available versions)
+ read https://www.pimcore.org/wiki/display/PIMCORE/Installation+and+Upgrade
+ install pimcore from the browser
+ remove website/lib/Tool/Setup* installation extension files

# Help (may be outdated)
+ For some base help see https://bitbucket.org/portabucket/pimweb
+ Adding a new currency to the system:
	- pimshop allows to define a exchange rate table based currency (prices are calculated from the base currency) or an absolute prices based currency (prices for currency are input manually)
	- for each type of currency you have to set up the new input fields for prices on classes Product, DiscountCode, SalePromotion and also the new shipping configuration tables on the EshopSettings class
	- fill the prices (in case of absolute prices currency) and the shipping configuration
	- add a new row for the new currency to exchange rate table on the EshopSettings class
	- open _nastaveni in Eshop tree and on the Currency settings activate the new currency
	and set the exchange rate or set it to 1 or 0 if the currency should be absolute
+ Adding a new variant combination:
	- the default pimshop installations comes with 2 predefined variant combinations (color and size) with one item in each combination :)
	- combinations are defined as objed bricks, so for a new combo just create a new objectbrick for example color-size or product-product and in Class definitions of the brick allow the field variantAttributes on class Product
	- now, this is only the backend part, the frontend part has to be modified to work with your new combinations, see website/models/Product.php for inspiration how to process the data from backend...

+ About elastic search:
	- there are three main mappings: product_lang, document_lang, object_lang each localized for differend languages used in the system, so product_cs, product_sk etc.
	- the product_ mapping is used for product filtering and implements the Website_Interface_ElasticObject, Pimcore objects which implement this interface throught classmaping are automatically reindexed by the global elastic search reindexing process
	- document_ mapping is used for fulltext document indexing
	- object_ mapping is fulltext for objects, to add objects of some class to this index implement the Website_Interface_ElasticObjectFulltext throught classmaping on that Object, this will also register the class for global reindexing
	- global reindexing can be run from administration by removing temporary files (has to be, because of thumbnails) or by calling Website_Tool_ElasticSearch::updateElasticSearchIndexesAndMappings(true, true)

+ Elastic pro tips:
	- disable delete all indices
	- try out rescore api
	- monitor the shard so that they do not grow too big => if, then add more...
	- use more indexes based on some unique param (for example time) and then search only last week for example... is faster then shards
	- plugins:
		- marvel
		- paramedic
		- hq
		- head
		- sense chrome plugin (also part of marvel)
