<?php

/**
 * Builds a language switching structure for a given static route.
 *
 * @author Martin Kuric <martin.kuric@portadesign.cz>
 */
namespace Website\Controller\Action\Helper;

class BuildLanguageSwitchFromRoute extends \Zend_Controller_Action_Helper_Abstract
{
	protected $switcher = [];

	/**
	 * @param string $routeName            name of the used static route
	 * @param bool   $routeForEachLanguage tells if there are seperate static routes for each language
	 * @param array  $params               params needed to assemble the URL
	 *
	 * @return array associative array with localized URLs for each language, e.g. ['en' => 'en_url', 'cs' => 'cs_url']
	 */
	public function direct($routeName, $routeForEachLanguage = true, $params = [])
	{
		$languages = \Website\Tool\Utils::getValidFrontendLanguages();

		if (!$routeForEachLanguage) {
			$route = \Pimcore\Model\Staticroute::getByName($routeName, (\Pimcore\Model\Site::isSiteRequest()) ? \Pimcore\Model\Site::getCurrentSite()->getId() : 0);
		}

		$serverUrlHelper = new \Zend_View_Helper_ServerUrl();
		foreach ($languages as $language) {
			$baseUrl = '';
			$siteId = 0;
			if ($routeForEachLanguage) {
				if (\Pimcore\Model\Site::isSiteRequest()) {
					$siteRootId = \Pimcore\Model\Document\Page::getByPath('/'.$language)->getId();
					$site = \Pimcore\Model\Site::getByRootId($siteRootId);
					if ($site) {
						$siteId = $site->getId();
						$baseUrl = $serverUrlHelper->getScheme().'://'.$site->getMainDomain();
					}
				}
				$route = \Pimcore\Model\Staticroute::getByName($routeName.$language, $siteId);
			} else {
				$params['language'] = $language;
			}
			$this->switcher[$language] = $baseUrl.$route->assemble($params, true);
		}

		return $this->switcher;
	}
}
