<?php

class EcommerceController extends \Website\Controller\BaseController
{
	/* 						DOCUMENT ROUTED ACTIONS							 */

	/* 					STATIC-ROUTE ROUTED ACTIONS							 */

	public function gpeWebpayGateAction()
	{
		$this->enableLayout();

		$orderObject = \Website\Model\Order::getById($this->cart->getOrderId());
		if (!$orderObject) {
			\Pimcore\Log\Simple::log('webpay', 'GATE- invalid request - orderId: '.$this->cart->getOrderId());
			$this->addErrorMsg('msg_invalid_request');
			$this->gotoUrl($this->view->docUrl('/'.$this->defaultLanguage.'/kosik/kontaktni-a-platebni-udaje'));

			return;
		}
		$gpeWebPay = new \Website\Model\GpeWebPay($this->language);
		$this->view->gpeRequestForm = $gpeWebPay->genRequestForm($orderObject);
	}

	/* 				VIEW-LESS ACTIONS (ALLWAYS REDIRECT)					 */

	public function gpeWebpayAction()
	{
		$form = new \Website\Form\GpeWebPayResponseForm();
		$webPay = new \Website\Model\GpeWebPay($this->language);

		//handle response
		$orderObject = \Website\Model\Order::getById($this->cart->getOrderId());
		if (!$orderObject) {
			\Pimcore\Log\Simple::log('webpay', 'LANDING - invalid request - orderId: '.$this->cart->getOrderId());
			$this->addErrorMsg('msg_invalid_request');
			$this->gotoUrl($this->view->docUrl('/'.$this->defaultLanguage.'/kosik/kontaktni-a-platebni-udaje'));

			return;
		}
		$modelReponse = $webPay->handleResponse($form, $this->getRequest()->getParams(), $orderObject);
		$this->_helper->handleModelResponse($modelReponse);
		if ($modelReponse['status'] >= 0) {
			$this->gotoUrl($this->view->docUrl('/'.$this->defaultLanguage.'/kosik/kontaktni-a-platebni-udaje/rekapitulace'));
		} else {
			$this->gotoUrl($this->view->docUrl('/'.$this->defaultLanguage.'/kosik/kontaktni-a-platebni-udaje'));
		}
	}

	/* 							FORM HANDLERS								 */
}
