<?php

/**
 * @author Martin Kuric <martin.kuric@portadesign.cz>
 */
namespace Website\Model;

class DiscountManager
{
	private static $salePromotions = null;

	/**
	 * returns array path => active promotions.
	 */
	public static function getSalePromotions(SalePromotion $toDelete = null)
	{
		if (self::$salePromotions !== null) {
			return self::$salePromotions;
		}

		$currencyModel = \Website\Tool\Utils::getCurrencyModel();

		self::$salePromotions = [];

		$list = new SalePromotion\Listing();
		$list->setUnpublished(true);
		$list->load();

		$toDeleteId = ($toDelete) ? $toDelete->getId() : 0;
		foreach ($list as $salePromotion) {
			foreach ($salePromotion->getIncludedProducts() as $productOrCategory) {
				if (!isset(self::$salePromotions[$productOrCategory->getFullPath()])) {
					self::$salePromotions[$productOrCategory->getFullPath()] = [];
				}

				$promotion = ['isPercentual' => $salePromotion->getIsPercentual()];
				foreach (array_keys($currencyModel->getSystemCurrenciesOptions(true)) as $locale) {
					$country = substr($locale, 3);
					if (!$salePromotion->isPublished() || $toDeleteId == $salePromotion->getId()) {
						$promotion['discount'.$country] = 0;
					} else {
						$promotion['discount'.$country] = $salePromotion->{'getDiscount'.$country}();
					}
				}

				self::$salePromotions[$productOrCategory->getFullPath()][$salePromotion->getId()] = $promotion;
			}
		}

		return self::$salePromotions;
	}
}
