<?php

namespace Website\Tool\Console\Command;

use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class DeploymentObjectbrickUpdateCommand extends AbstractCommand
{
	protected function configure()
	{
		$this
			->setName('deployment:objectbrick-update')
			->setDescription('Create or update objectbrick based on its definition file')
			->addArgument(
				'key',
				InputArgument::REQUIRED,
				'Objectbrick key'
			);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		$key = trim($input->getArgument('key'));
		try {
			$brick = \Pimcore\Model\Object\Objectbrick\Definition::getByKey($key);
			$brick->save();
			$output->writeln(sprintf('Objectbrick %s updated', $key));
		} catch (\Exception $e) {
			$output->writeln(sprintf(
				'<error>Error updating objectbrick %s: %s</error>',
				$key,
				$e->getMessage()
			));
		}
	}
}
