<?php

namespace Website\Tool\Console\Command;

use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class GeneratorClassCreateCommand extends AbstractCommand
{
	protected function configure()
	{
		$this
			->setName('generator:class-create')
			->setDescription('Create a pimcore class definition')
			->addArgument(
				'name',
				InputArgument::REQUIRED,
				'Class name in CamelCase'
			)
			->addOption(
				'localized', 'l',
				InputOption::VALUE_NONE,
				'Create a localized class',
				null
			)
			->addOption(
				'url', 'u',
				InputOption::VALUE_NONE,
				'Create a class with and URL calculated value field',
				null
			)
			->addOption(
				'icon', 'i',
				InputOption::VALUE_REQUIRED,
				'Path to an icon file relative to the website root'
			)
			->addOption(
				'nomap', null,
				InputOption::VALUE_NONE,
				'Do not create classmap entries',
				null
			);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		$generator = new \Website\Model\Generator();

		$name = $input->getArgument('name');
		$icon = $generator->normalizePathParam($input->getOption('icon'));
		$url = $input->getOption('url');
		$localized = $input->getOption('localized');
		$nomap = $input->getOption('nomap');

		$id = $generator->createClassDefinition($name, $url, $localized, $icon);
		if ($id) {
			$output->writeln(sprintf('Class [%s] created with ID %d', $name, $id));
			if (!$nomap) {
				if ($generator->createClassMapping($id)) {
					$output->writeln(sprintf('Class [%s] mapped', $name));
				} else {
					$output->writeln(sprintf(
						'<error>Class [%s] could not be mapped. See /website/var/log/generator.log for details.</error>',
						$name
					));
				}
			}
		} else {
			$output->writeln(sprintf(
				'<error>Class [%s] could not be created. See /website/var/log/generator.log for details.</error>',
				$name
			));
		}
	}
}
