<?php

namespace Website\Tool\Console\Command;

use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class GeneratorClassMapDeleteCommand extends AbstractCommand
{
	protected function configure()
	{
		$this
			->setName('generator:classmap-delete')
			->setDescription('Delete a pimcore classmap entry')
			->addArgument(
				'name',
				InputArgument::REQUIRED,
				'Class name in CamelCase'
			);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		$generator = new \Website\Model\Generator();

		$name = $input->getArgument('name');

		if ($generator->deleteClassMapping($name)) {
			$output->writeln(sprintf('Classmapping for class [%s] deleted', $name));
		} else {
			$output->writeln(sprintf(
				'<error>Classmapping for class [%s] could not be deleted. See /website/var/log/generator.log for details.</error>',
				$name
			));
		}
	}
}
