<?php

set('web_name', basename(realpath(__DIR__.'/../../../')));
set('default_stage', 'vm3_production');

/*
 * local mysql root access
 */
env('bin/local/mysql', 'mysql --login-path=deployment');
env('bin/local/mysqldump', 'mysqldump --login-path=deployment');
env('bin/local/mysqladmin', 'mysqladmin --login-path=deployment');

/*
 * vhosts templates
 */
$vm1VhostConfigTemplate = str_replace('###WEB_NAME###', get('web_name'),
'<VirtualHost *:80>
	ServerName			###WEB_NAME###.cz
	ServerAlias			*.###WEB_NAME###.cz
	ServerAlias			###WEB_NAME###.vm2.portadesign.cz *.###WEB_NAME###.vm2.portadesign.cz

	php_value			memory_limit			128M
	php_value			upload_max_filesize		200M
	php_value			post_max_size			200M

	php_admin_value		upload_tmp_dir "/data/hosting/###WEB_NAME###/tmp"
	php_admin_value		open_basedir "/data/hosting/###WEB_NAME###:/usr/share/php:/usr/local/src/"

	CustomLog			"/data/hosting/###WEB_NAME###/logs/access_log" combined
	ErrorLog			"/data/hosting/###WEB_NAME###/logs/error_log"
	DocumentRoot		"/data/hosting/###WEB_NAME###/www"
</VirtualHost>');

$vm2VhostConfigTemplate = str_replace('###WEB_NAME###', get('web_name'),
'<VirtualHost *:80>
	ServerName			###WEB_NAME###.cz
	ServerAlias			*.###WEB_NAME###.cz
	ServerAlias			###WEB_NAME###.vm2.portadesign.cz *.###WEB_NAME###.vm2.portadesign.cz

	php_value			memory_limit			128M
	php_value			upload_max_filesize		200M
	php_value			post_max_size			200M

	php_admin_value		upload_tmp_dir "/data/hosting/###WEB_NAME###/tmp"
	php_admin_value		open_basedir "/data/hosting/###WEB_NAME###:/usr/share/php:/usr/share/pear:/usr/local/src/:/tmp"

	CustomLog			"/data/hosting/###WEB_NAME###/logs/access_log" combined
	ErrorLog			"/data/hosting/###WEB_NAME###/logs/error_log"
	DocumentRoot		"/data/hosting/###WEB_NAME###/www"
</VirtualHost>');

$vm3VhostConfigTemplate = str_replace('###WEB_NAME###', get('web_name'),
'<VirtualHost *:80>
	ServerName			###WEB_NAME###.cz
	ServerAlias			*.###WEB_NAME###.cz
	ServerAlias			###WEB_NAME###.vm3.portadesign.cz *.###WEB_NAME###.vm3.portadesign.cz

	CustomLog			"/data/hosting/###WEB_NAME###/logs/access_log" combined
	ErrorLog			"/data/hosting/###WEB_NAME###/logs/error_log"
	DocumentRoot		"/data/hosting/###WEB_NAME###/html"

	RewriteEngine		On
	# this is needed to pass the auth header correctly - fastcgi environment
	RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization},L]
</VirtualHost>');

$cacheFrontend = [
	'type' => 'Core',
	'options' => [
		'cache_id_prefix' => get('web_name').'_',
		'lifetime' => '99999',
		'automatic_serialization' => 'true',
	],
];
$cacheConfigs = [
	'redis' => [
		'frontend' => $cacheFrontend,
		'backend' => [
			'type' => '\\Pimcore\\Cache\\Backend\\Redis2',
			'custom' => 'true',
			'options' => [
				'server' => '127.0.0.1',
				'port' => '6379',
				'persistent' => '1',
				'database' => '1',
				'use_lua' => '1',
				'dbname' => get('web_name'),
			],
		],
	],
	'mongo' => [
		'frontend' => $cacheFrontend,
		'backend' => [
			'type' => '\\Pimcore\\Cache\\Backend\\Mongodb',
			'custom' => 'true',
			'options' => [
				'dbname' => get('web_name'),
			],
		],
	],
	'memcached' => [
		'frontend' => $cacheFrontend,
		'backend' => [
			'type' => '\\Pimcore\\Cache\\Backend\\Memcached',
			'custom' => 'true',
			'options' => [
				'tags_do_not_switch_to_innodb' => true,
				'compatibility' => true,
				'servers' => [
					[
						'host' => 'localhost',
						'port' => '112211',
						'persistent' => true,
					],
				],
			],
		],
	],
];

/*
 * Remote servers configration example
 * See http://deployer.org/docs/servers for options
 */
server('vm1', 'vm.portadesign.cz')
	->user('martin')
	->identityFile('~/.ssh/id_rsa.pub', '~/.ssh/id_rsa', '')
	->env('hosting_path', '/data/hosting')
	->env('user_group', 'portadesign')
	->env('http_user', 'apache')
	->env('mysql_user', 'root')
	->env('mysql_password', '')
	->env('vhosts_path', '/etc/httpd/conf.d/vhosts')
	->env('vhosts_config_template', $vm1VhostConfigTemplate)
	->env('apache_reload_command', 'sudo /etc/init.d/httpd/reload')
	->stage('vm1_production');

server('vm2', 'vm2.portadesign.cz')
	->user('martin')
	->identityFile('~/.ssh/id_rsa.pub', '~/.ssh/id_rsa', '')
	->env('hosting_path', '/data/hosting')
	->env('user_group', 'portadesign')
	->env('http_user', 'apache')
	->env('mysql_login_path', 'deployment')
	->env('vhosts_path', '/etc/httpd/conf/sites-available')
	->env('vhosts_symlink_path', '/etc/httpd/conf/sites-enabled')
	->env('vhosts_config_template', $vm2VhostConfigTemplate)
	->env('apache_reload_command', 'sudo service httpd reload')
	->env('cache_config', $cacheConfigs['redis'])
	->stage('vm2_production');

server('vm3', 'vm3.portadesign.cz')
	->user('martin')
	->identityFile('~/.ssh/id_rsa.pub', '~/.ssh/id_rsa', '')
	->env('hosting_path', '/data/hosting')
	->env('user_group', 'portadesign')
	->env('mysql_login_path', 'deployment')
	->env('http_user', 'www-data')
	->env('vhosts_path', '/etc/apache2/sites-available')
	->env('vhosts_symlink_path', '/etc/apache2/sites-enabled')
	->env('vhosts_config_template', $vm3VhostConfigTemplate)
	->env('apache_reload_command', 'sudo service apache2 reload')
	->env('cache_config', $cacheConfigs['redis'])
	->stage('vm3_production');
