<?php

namespace Website\Form;

class PasswordResetChangeForm extends Base
{
	public function init()
	{
		parent::init();
		$this->setName('password-reset-change');

		$password = new \Zend_Form_Element_Password('password');
		$password->setRequired(true)
			->setLabel('label_password_new')
			->addFilter('StripTags')
			->addFilter('StripTags')
			->addValidator($this->notEmptyValidator)
			->addValidator($this->passwordLengthValidator);

		$password_again = new \Zend_Form_Element_Password('password_again');
		$password_again->setRequired(true)
			->setLabel('label_password_new_again')
			->addFilter('StripTags')
			->addFilter('StripTags')
			->addValidator($this->notEmptyValidator)
			->addValidator($this->passwordLengthValidator)
			->addValidator($this->passwordIdenticalValidator);

		$token = new \Zend_Form_Element_Hidden('token');

		$submit = new \Zend_Form_Element_Button('send');
		$submit->setLabel('label_change')
			->setAttrib('type', 'submit');

		$this->addElements([
			$password,
			$password_again,
			$token,
			$submit,
		]);

		//remove decorators
		$this->setElementDecorators(['ViewHelper']);

		$this->setUpJsValidation();
	}
}
