<?php

set_time_limit(60000);
include_once __DIR__.'/../../../pimcore/cli/startup.php';
\Pimcore\Cache::clearAll();
$db = \Pimcore\Db::get();

fwrite(STDOUT, "3642\n");
try {
	$tables = $db->fetchAll("SHOW TABLES LIKE 'object_classificationstore_data_%'");
	foreach ($tables as $table) {
		$t = current($table);
		$db->query('ALTER TABLE `'.$t.'`
				ADD INDEX `o_id` (`o_id`),
				ADD INDEX `groupId` (`groupId`),
				ADD INDEX `keyId` (`keyId`),
				ADD INDEX `fieldname` (`fieldname`),
				ADD INDEX `language` (`language`);
		');
	}
} catch (\Exception $e) {
	fwrite(STDOUT, '3642 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3643\n");
try {
	$tables = $db->fetchAll("SHOW TABLES LIKE 'object_classificationstore_data_%'");
	foreach ($tables as $table) {
		$t = current($table);
		$db->query('ALTER TABLE `'.$t.'`
				ADD COLUMN `value2` LONGTEXT NULL AFTER `value`;
		');
	}
} catch (\Exception $e) {
	fwrite(STDOUT, '3643 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3644\n");
try {
	$tables = $db->fetchAll("SHOW TABLES LIKE 'object_classificationstore_data_%'");
	foreach ($tables as $table) {
		$t = current($table);
		// migrate the quantity value records
		$db->query('UPDATE `'.$t."`
			set value2 = TRIM(BOTH '\"' FROM SUBSTRING_INDEX(SUBSTRING_INDEX(value,';',4),':',-1)), value = TRIM(BOTH '\"' FROM SUBSTRING_INDEX(SUBSTRING_INDEX(value,';',2),':',-1)) where type = 'quantityValue';
		");
	}
} catch (\Exception $e) {
	fwrite(STDOUT, '3644 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3645\n");
try {
	$tables = $db->query("ALTER TABLE documents_elements CHANGE COLUMN `name` `name` varchar(750) CHARACTER SET ascii DEFAULT '';");
} catch (\Exception $e) {
	fwrite(STDOUT, '3645 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3651\n");
try {
	$tables = $db->query("ALTER TABLE documents_elements CHANGE COLUMN `name` `name` varchar(750) CHARACTER SET ascii DEFAULT '';");
} catch (\Exception $e) {
	fwrite(STDOUT, '3651 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3660\n");
try {
	$tables = $db->query("CREATE TABLE `documents_translations` (
	  `id` int(11) unsigned NOT NULL DEFAULT '0',
	  `sourceId` int(11) unsigned NOT NULL DEFAULT '0',
	  `language` varchar(10) NOT NULL DEFAULT '',
	  PRIMARY KEY (`sourceId`,`language`),
	  KEY `id` (`id`),
	  KEY `sourceId` (`sourceId`),
	  KEY `language` (`language`)
	) DEFAULT CHARSET=utf8;");
	$tables = $db->fetchAll("SHOW TABLES LIKE 'object_classificationstore_groups_%'");
	foreach ($tables as $table) {
		$t = current($table);
		// migrate the quantity value records
		$db->query('ALTER TABLE `'.$t.'`
			ADD INDEX `o_id` (`o_id`);
		');
	}
} catch (\Exception $e) {
	fwrite(STDOUT, '3660 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3662\n");
\Pimcore\Config::setFlag('useZendDate', true);

fwrite(STDOUT, "3664\n");
try {
	$tables = $db->fetchAll("SHOW TABLES LIKE 'object_metadata_%'");
	foreach ($tables as $table) {
		$t = current($table);
		// migrate the quantity value records
		$db->query('ALTER TABLE `'.$t.'` DROP PRIMARY KEY, ADD PRIMARY KEY (`o_id`, `dest_id`, `type`, `fieldname`, `column`, `ownertype`, `ownername`, `position`);');
	}
} catch (\Exception $e) {
	fwrite(STDOUT, '3664 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3689\n");
try {
	$db->query('ALTER TABLE `classificationstore_relations` ADD INDEX `groupId` (`groupId`);');
	$db->query('ALTER TABLE `classificationstore_collectionrelations` ADD INDEX `colId` (`colId`);');
} catch (\Exception $e) {
	fwrite(STDOUT, '3689 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3690\n");
try {
	$db->query('ALTER TABLE `classificationstore_relations` ALTER `sorter` DROP DEFAULT;');
	$db->query('ALTER TABLE `classificationstore_relations` CHANGE COLUMN `sorter` `sorter` INT(11) NULL AFTER `keyId`;');
} catch (\Exception $e) {
	fwrite(STDOUT, '3690 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3710\n");
try {
	$db->query('DROP TABLE IF EXISTS `classificationstore_stores`;');
	$db->query("CREATE TABLE `classificationstore_stores` (
		`id` INT(11) NOT NULL AUTO_INCREMENT,
		`name` VARCHAR(255) NULL DEFAULT NULL,
		`description` LONGTEXT NULL,
		PRIMARY KEY (`id`),
		INDEX `name` (`name`)
	)
	COLLATE='utf8_general_ci'
	ENGINE=InnoDB
	;
	");
	$db->query("INSERT INTO `classificationstore_stores` (`id`, `name`, `description`) VALUES (1, 'Default', 'Default Store');");
	$db->query('ALTER TABLE `classificationstore_keys`
		ADD COLUMN `storeId` INT NULL DEFAULT NULL AFTER `id`,
		ADD INDEX `storeId` (`storeId`);
	');
	$db->query('ALTER TABLE `classificationstore_groups`
		ADD COLUMN `storeId` INT NULL DEFAULT NULL AFTER `id`,
		ADD INDEX `storeId` (`storeId`);
	');
	$db->query('ALTER TABLE `classificationstore_collections`
		ADD COLUMN `storeId` INT NULL DEFAULT NULL AFTER `id`,
		ADD INDEX `storeId` (`storeId`);
	');
	$db->query('UPDATE classificationstore_keys set storeId = 1');
	$db->query('UPDATE classificationstore_groups set storeId = 1');
	$db->query('UPDATE classificationstore_collections set storeId = 1');
} catch (\Exception $e) {
	fwrite(STDOUT, '3710 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3719\n");
try {
	$db->query('ALTER TABLE `users`
		ADD COLUMN `activePerspective` VARCHAR(255) NULL DEFAULT NULL AFTER `apiKey`,
		ADD COLUMN `perspectives` LONGTEXT NULL DEFAULT NULL AFTER `activePerspective`;
	');
} catch (\Exception $e) {
	fwrite(STDOUT, '3719 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3720\n");
$perspectivesConfig = [
	'default' => [
		'iconCls' => 'pimcore_icon_perspective',
		'elementTree' => [
			[
				'type' => 'documents',
				'position' => 'left',
				'expanded' => true,
				'hidden' => false,
				'sort' => -3,
			],
			[
				'type' => 'assets',
				'position' => 'left',
				'expanded' => false,
				'hidden' => false,
				'sort' => -2,
			],
			[
				'type' => 'objects',
				'position' => 'left',
				'expanded' => false,
				'hidden' => false,
				'sort' => -1,
			],
		],
		'toolbar' => [
			'file' => [
				'items' => [
					'searchReplace' => false,
					'seemode' => false,
					'help' => false,
					'about' => false,
				],
			],
			'extras' => [
				'items' => [
					'plugins' => false,
					'backup' => false,
					'update' => false,
				],
			],
		],
	],
	'editor' => [
		'iconCls' => 'pimcore_icon_perspective',
		'toolbar' => [
			'file' => [
				'items' => [
					'searchReplace' => false,
					'seemode' => false,
					'help' => false,
					'about' => false,
				],
			],
			'extras' => [
				'items' => [
					'glossary' => false,
					'redirects' => false,
					'plugins' => false,
					'applicationlog' => false,
					'backup' => false,
					'update' => false,
					'maintenance' => false,
					'systemtools' => false,
				],
			],
			'marketing' => [
				'items' => [
					'tagmanagement' => false,
					'targeting' => false,
					'newsletter' => false,
					'seo' => false,
				],
			],
			'settings' => [
				'items' => [
					'customReports' => false,
					'marketingReports' => false,
					'documentTypes' => false,
					'predefinedProperties' => false,
					'predefinedMetadata' => false,
					'system' => false,
					'website' => false,
					'web2print' => false,
					'users' => false,
					'thumbnails' => false,
					'objects' => false,
					'routes' => false,
					'cache' => [
						'items' => [
							'clearAll' => false,
							'clearTemp' => false,
							'generatePreviews' => false,
						],
					],
					'adminTranslations' => false,
					'tagConfiguration' => false,
				],
			],
		],
		'elementTree' => [
			[
				'type' => 'documents',
				'position' => 'left',
				'expanded' => true,
				'hidden' => false,
				'sort' => -3,
				'treeContextMenu' => [
					'document' => [
						'items' => [
							'addPrintPage' => false,
						],
					],
				],
				'extension' => [
					'elementRestrictions' => [
						[
							'path' => '/',
							'restrictEmptyPage' => '1',
							'restrictEmail' => '1',
							'restrictNewsletter' => '1',
							'restrictEmptySnippet' => '1',
							'restrictSnippet' => '1',
							'restrictHardlink' => '1',
							'restrictFolder' => '1',
							'restrictOpen' => '1',
							'restrictAdvanced' => '1',
						],
						[
							'path' => '/notifikace',
							'restrictPage' => true,
							'restrictLink' => true,
						],
					],
				],
			],
			[
				'type' => 'assets',
				'position' => 'left',
				'expanded' => false,
				'hidden' => false,
				'sort' => -2,
				'extension' => [
					'elementRestrictions' => [
						[
							'path' => '/',
							'restrictAdvanced' => '1',
						],
					],
				],
			],
			[
				'type' => 'objects',
				'position' => 'left',
				'expanded' => false,
				'hidden' => true,
				'sort' => -1,
				'extension' => [
					'elementRestrictions' => [
						[
							'path' => '/',
							'restrictFolder' => '1',
							'restrictImport' => '1',
							'restrictAdvanced' => '1',
						],
					],
				],
			],
		],
	],
];
try {
	$customviewsConfigPath = \Pimcore\Config::locateConfigFile('customviews.php');
	$customviewsExtensionConfigPath = \Pimcore\Config::locateConfigFile('customviews_extension.php');
	if (file_exists($customviewsConfigPath)) {
		copy($customviewsConfigPath, PIMCORE_CONFIGURATION_DIRECTORY.'/customviews_legacy.php');
		$customviewsConfig = include $customviewsConfigPath;
		$customviewsExtensionConfig = null;
		if (file_exists($customviewsExtensionConfigPath)) {
			copy(
				$customviewsExtensionConfigPath,
				PIMCORE_CONFIGURATION_DIRECTORY.'/customviews_extension_legacy.php'
			);
			$customviewsExtensionConfig = include $customviewsExtensionConfigPath;
		}

		$break = false;
		foreach ($customviewsConfig['views'] as $key => $customview) {
			if (isset($customview['extension'])) {
				$break = true;
				break;
			}
			$customviewsConfig['views'][$key]['id'] = intval($customview['id']);
			$customviewsConfig['views'][$key]['sort'] = $key + 1;
			$customviewsConfig['views'][$key]['treetyp'] = 'object';
			$customviewsConfig['views'][$key]['condition'] = null;
			$customviewsConfig['views'][$key]['showroot'] = boolval($customview['showroot']);
			$customviewsConfig['views'][$key]['position'] = 'left';
			$customviewsConfig['views'][$key]['expadned'] = false;
			$customviewsConfig['views'][$key]['extension'] = [
				'elementRestrictions' => [],
			];

			$customviewExtensions = null;
			if ($customviewsExtensionConfig) {
				foreach ($customviewsExtensionConfig['views'] as $tmp) {
					if ($customview['id'] == $tmp['id']) {
						$customviewExtensions = $tmp['extensions'];
						break;
					}
				}
			}

			if ($customviewExtensions) {
				foreach ($customviewExtensions as $extension) {
					$extension['restrictImport'] = '1';
					$extension['restrictAdvanced'] = '1';
					$customviewsConfig['views'][$key]['extension']['elementRestrictions'][] = $extension;
				}
			} else {
				$extension = [
					'path' => $customview['rootfolder'],
					'restrictFolder' => '1',
					'restrictImport' => '1',
					'restrictAdvanced' => '1',
				];
				$customviewsConfig['views'][$key]['extension']['elementRestrictions'][] = $extension;
			}
		}
		if (!$break) {
			$contents = var_export_pretty($customviewsConfig);
			$phpContents = "<?php \n\nreturn ".$contents.";\n";
			\Pimcore\File::put($customviewsConfigPath, $phpContents);
		}

		$perspectivesConfigPath = \Pimcore\Config::locateConfigFile('perspectives.php');
		if (!file_exists($perspectivesConfigPath)) {
			foreach ($perspectivesConfig as $pKey => $perspective) {
				foreach ($customviewsConfig['views'] as $key => $customview) {
					$perspectivesConfig[$pKey]['elementTree'][] = [
						'type' => 'customview',
						'id' => intval($customview['id']),
					];
				}
			}
			$contents = var_export_pretty($perspectivesConfig);
			$phpContents = "<?php \n\nreturn ".$contents.";\n";
			\Pimcore\File::put(PIMCORE_CONFIGURATION_DIRECTORY.'/perspectives.php', $phpContents);
		}
	}
} catch (\Exception $e) {
	fwrite(STDOUT, '3720 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3730\n");
try {
	$db->query('ALTER TABLE `classificationstore_keys` CHANGE `type` `type` VARCHAR(255) NULL DEFAULT NULL;');
} catch (\Exception $e) {
	fwrite(STDOUT, '3730 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3739\n");
try {
	$columns = $db->fetchAll('SHOW COLUMNS FROM documents_page');
	foreach ($columns as $column) {
		if ($column['Field'] == 'css') {
			$db->query('ALTER TABLE documents_page DROP COLUMN `css`;');
		}
	}
} catch (\Exception $e) {
	fwrite(STDOUT, '3739 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3783\n");
try {
	$db->query('ALTER TABLE `classificationstore_relations`
		ADD COLUMN `mandatory` TINYINT(1) NULL DEFAULT NULL AFTER `sorter`;
	');
} catch (\Exception $e) {
	fwrite(STDOUT, '3783 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3786\n");
try {
	// REDIRECTS: added active flag to enable/disable them
	$db->query('ALTER TABLE `redirects` ADD COLUMN `active` tinyint(1) NULL DEFAULT NULL AFTER `priority`;');
	$db->update('redirects', ['active' => 1]); // set all existing redirects to active
	// no more individual configuration paths for executables
	$config = \Pimcore\Config::getSystemConfig();
	$existingConfigArray = $config->toArray();
	$paths = [];
	foreach (['ffmpeg', 'ghostscript', 'libreoffice', 'pngcrush', 'imgmin', 'jpegoptim', 'pdftotext'] as $app) {
		if (isset($config->assets->$app)) {
			$pathOnly = dirname($config->assets->$app);
			if (strlen($pathOnly) > 1) {
				$paths[] = $pathOnly;
			}

			unset($existingConfigArray['assets'][$app]);
		}
	}
	if (isset($config->general->php_cli)) {
		$pathOnly = dirname($config->general->php_cli);
		if (strlen($pathOnly) > 1) {
			$paths[] = $pathOnly;
		}

		unset($existingConfigArray['general']['php_cli']);
	}
	$newPath = implode(':', $paths);
	$existingConfigArray['general']['path_variable'] = $newPath;
	$configFile = \Pimcore\Config::locateConfigFile('system.php');
	\Pimcore\File::putPhpFile($configFile, to_php_data_file_format($existingConfigArray));
} catch (\Exception $e) {
	fwrite(STDOUT, '3786 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3803\n");
try {
	$keywords = $db->fetchAll("SELECT id,keywords FROM documents_page WHERE LENGTH(IFNULL(keywords,'')) > 0");
	$keywordList = '';
	foreach ($keywords as $keyword) {
		$keywordList .= $keyword['id'].'|'.$keyword['keywords']."\n";
	}
	\Pimcore\File::put(PIMCORE_SYSTEM_TEMP_DIRECTORY.'/document-page-keyword-export.csv', $keywordList);
	$db->query('ALTER TABLE documents_page DROP COLUMN keywords');
} catch (\Exception $e) {
	fwrite(STDOUT, '3803 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3808\n");
try {
	// add missing indexes
	$db->query('ALTER TABLE `redirects` ADD INDEX `active` (`active`);');
	$db->query('ALTER TABLE `classificationstore_relations` ADD INDEX `mandatory` (`mandatory`);');

	fwrite(STDOUT, "3814\n");
	$types = \Pimcore\Model\Document::getTypes();
	$types[] = 'printpage';
	$types[] = 'printcontainer';
	$types = array_unique($types);
	$db->query("
		ALTER TABLE documents
		CHANGE type type ENUM('".implode("', '", $types)."');
	");
	// add missing indexes
	$db->query("CREATE TABLE IF NOT EXISTS `documents_printpage` (
		`id` int(11) unsigned NOT NULL DEFAULT '0',
		`module` varchar(255) DEFAULT NULL,
		`controller` varchar(255) DEFAULT NULL,
		`action` varchar(255) DEFAULT NULL,
		`template` varchar(255) DEFAULT NULL,
		`lastGenerated` int(11) DEFAULT NULL,
		`lastGenerateMessage` text CHARACTER SET utf8,
		PRIMARY KEY (`id`)
	) DEFAULT CHARSET=utf8;
	");
} catch (\Exception $e) {
	fwrite(STDOUT, '3808 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3815\n");
try {
	$db->query("INSERT INTO `users_permission_definitions` VALUES ('web2print_settings');");
} catch (\Exception $e) {
	fwrite(STDOUT, '3815 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3837\n");
try {
	$db->query("ALTER TABLE `quantityvalue_units`
		ADD COLUMN `reference` VARCHAR(50) NULL DEFAULT NULL COLLATE 'utf8_bin' AFTER `conversionOffset`;
	");
} catch (\Exception $e) {
	fwrite(STDOUT, '3837 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3844\n");
try {
	$db->query('ALTER TABLE `users` CHANGE COLUMN `permissions` `permissions` text;');
} catch (\Exception $e) {
	fwrite(STDOUT, '3844 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3864\n");
try {
	$db->query('ALTER TABLE `classes` ADD COLUMN `group` varchar(255) NULL DEFAULT NULL AFTER `showVariants`;');
} catch (\Exception $e) {
	fwrite(STDOUT, '3864 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3866\n");
$file = \Pimcore\Config::locateConfigFile('classmap.php');
if (file_exists($file)) {
	$data = include $file;
	$diContents = "<?php\n\nreturn [\n";
	foreach ($data as $source => $target) {
		$diContents .= '	\'Pimcore\Model\\'.$source.'\' => DI\object(\''.$target.'\'),'."\n";
	}
	$diContents .= "];\n";
	$customFile = \Pimcore\Config::locateConfigFile('di.php');
	\Pimcore\File::put($customFile, $diContents);
}

fwrite(STDOUT, "3874\n");
try {
	$db->query("
	CREATE TABLE `element_workflow_state` (
		`cid` int(10) NOT NULL DEFAULT '0',
		`ctype` enum('document','asset','object') NOT NULL,
		`workflowId` int(11) NOT NULL,
		`state` varchar(255) DEFAULT NULL,
		`status` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`cid`,`ctype`,`workflowId`)
	) ENGINE=InnoDB DEFAULT CHARSET=utf8;
	");
} catch (\Exception $e) {
	fwrite(STDOUT, '3874 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3895\n");
try {
	$db->query('
		ALTER TABLE users ADD COLUMN allowDirtyClose TINYINT(1) UNSIGNED NOT NULL DEFAULT 1;
	');
} catch (\Exception $e) {
	fwrite(STDOUT, '3895 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3905\n");
try {
	$types = \Pimcore\Model\Document::getTypes();
	$types[] = 'newsletter';
	$types = array_unique($types);
	$db->query("
		ALTER TABLE documents
		CHANGE type type ENUM('".implode("', '", $types)."');
	");

	$db->query("CREATE TABLE `documents_newsletter` (
		`id` int(11) unsigned NOT NULL DEFAULT '0',
		`module` varchar(255) DEFAULT NULL,
		`controller` varchar(255) DEFAULT NULL,
		`action` varchar(255) DEFAULT NULL,
		`template` varchar(255) DEFAULT NULL,
		`from` varchar(255) DEFAULT NULL,
		`subject` varchar(255) DEFAULT NULL,
		`trackingParameterSource` varchar(255) DEFAULT NULL,
		`trackingParameterMedium` varchar(255) DEFAULT NULL,
		`trackingParameterName` varchar(255) DEFAULT NULL,
		`enableTrackingParameters` tinyint(1) unsigned DEFAULT NULL,
		`sendingMode` varchar(20) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) ENGINE=InnoDB DEFAULT CHARSET=utf8;
	");
} catch (\Exception $e) {
	fwrite(STDOUT, '3905 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3914\n");
try {
	$db->query('
		ALTER TABLE documents_printpage
		ADD contentMasterDocumentId INT(11) AFTER lastGenerateMessage;
	');
} catch (\Exception $e) {
	fwrite(STDOUT, '3914 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3915\n");
try {
	$tables = $db->fetchAll("SHOW TABLES LIKE 'object_classificationstore_data_%'");
	foreach ($tables as $table) {
		$t = current($table);
		$db->query('ALTER TABLE `'.$t.'`
			CHANGE COLUMN `value` `value` LONGTEXT NULL AFTER `keyId`;
		');
	}
} catch (\Exception $e) {
	fwrite(STDOUT, '3915 failed - '.$e->getMessage()."\n");
}


\Pimcore\Cache::clearAll();
fwrite(STDOUT, "done\n");
